/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Map;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.MeteredWindowStoreIterator;
import org.apache.kafka.streams.state.internals.MeteredWindowedKeyValueIterator;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.apache.kafka.streams.state.internals.metrics.Sensors;

public class MeteredWindowStore<K, V>
extends WrappedStateStore<WindowStore<Bytes, byte[]>, Windowed<K>, V>
implements WindowStore<K, V> {
    private final long windowSizeMs;
    private final String metricsScope;
    private final Time time;
    final Serde<K> keySerde;
    final Serde<V> valueSerde;
    StateSerdes<K, V> serdes;
    private StreamsMetricsImpl metrics;
    private Sensor putTime;
    private Sensor fetchTime;
    private Sensor flushTime;
    private ProcessorContext context;
    private final String threadId;
    private String taskName;

    MeteredWindowStore(WindowStore<Bytes, byte[]> inner, long windowSizeMs, String metricsScope, Time time, Serde<K> keySerde, Serde<V> valueSerde) {
        super(inner);
        this.windowSizeMs = windowSizeMs;
        this.threadId = Thread.currentThread().getName();
        this.metricsScope = metricsScope;
        this.time = time;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.context = context;
        this.initStoreSerde(context);
        this.metrics = (StreamsMetricsImpl)context.metrics();
        this.taskName = context.taskId().toString();
        String metricsGroup = "stream-" + this.metricsScope + "-state-metrics";
        Map<String, String> taskTags = this.metrics.storeLevelTagMap(this.threadId, this.taskName, this.metricsScope, "all");
        Map<String, String> storeTags = this.metrics.storeLevelTagMap(this.threadId, this.taskName, this.metricsScope, this.name());
        this.putTime = Sensors.createTaskAndStoreLatencyAndThroughputSensors(Sensor.RecordingLevel.DEBUG, "put", this.metrics, metricsGroup, this.threadId, this.taskName, this.name(), taskTags, storeTags);
        this.fetchTime = Sensors.createTaskAndStoreLatencyAndThroughputSensors(Sensor.RecordingLevel.DEBUG, "fetch", this.metrics, metricsGroup, this.threadId, this.taskName, this.name(), taskTags, storeTags);
        this.flushTime = Sensors.createTaskAndStoreLatencyAndThroughputSensors(Sensor.RecordingLevel.DEBUG, "flush", this.metrics, metricsGroup, this.threadId, this.taskName, this.name(), taskTags, storeTags);
        Sensor restoreTime = Sensors.createTaskAndStoreLatencyAndThroughputSensors(Sensor.RecordingLevel.DEBUG, "restore", this.metrics, metricsGroup, this.threadId, this.taskName, this.name(), taskTags, storeTags);
        long startNs = this.time.nanoseconds();
        try {
            super.init(context, root);
        }
        finally {
            this.metrics.recordLatency(restoreTime, startNs, this.time.nanoseconds());
        }
    }

    void initStoreSerde(ProcessorContext context) {
        this.serdes = new StateSerdes(ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.name()), (Serde<?>)(this.keySerde == null ? context.keySerde() : this.keySerde), (Serde<?>)(this.valueSerde == null ? context.valueSerde() : this.valueSerde));
    }

    @Override
    public boolean setFlushListener(CacheFlushListener<Windowed<K>, V> listener, boolean sendOldValues) {
        WindowStore wrapped = (WindowStore)this.wrapped();
        if (wrapped instanceof CachedStateStore) {
            return ((CachedStateStore)((Object)wrapped)).setFlushListener((K key, V newValue, V oldValue, long timestamp) -> listener.apply(WindowKeySchema.fromStoreKey(key, this.windowSizeMs, this.serdes.keyDeserializer(), this.serdes.topic()), newValue != null ? (Object)this.serdes.valueFrom((byte[])newValue) : null, oldValue != null ? (Object)this.serdes.valueFrom((byte[])oldValue) : null, timestamp), sendOldValues);
        }
        return false;
    }

    @Override
    @Deprecated
    public void put(K key, V value) {
        this.put(key, value, this.context.timestamp());
    }

    @Override
    public void put(K key, V value, long windowStartTimestamp) {
        long startNs = this.time.nanoseconds();
        try {
            ((WindowStore)this.wrapped()).put(this.keyBytes(key), this.serdes.rawValue(value), windowStartTimestamp);
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key, value);
            throw new ProcessorStateException(message, (Throwable)((Object)e));
        }
        finally {
            this.metrics.recordLatency(this.putTime, startNs, this.time.nanoseconds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V fetch(K key, long timestamp) {
        long startNs = this.time.nanoseconds();
        try {
            byte[] result = (byte[])((WindowStore)this.wrapped()).fetch(this.keyBytes(key), timestamp);
            if (result == null) {
                V v = null;
                return v;
            }
            V v = this.serdes.valueFrom(result);
            return v;
        }
        finally {
            this.metrics.recordLatency(this.fetchTime, startNs, this.time.nanoseconds());
        }
    }

    @Override
    public WindowStoreIterator<V> fetch(K key, long timeFrom, long timeTo) {
        return new MeteredWindowStoreIterator<V>(((WindowStore)this.wrapped()).fetch(this.keyBytes(key), timeFrom, timeTo), this.fetchTime, this.metrics, this.serdes, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(K from, K to, long timeFrom, long timeTo) {
        return new MeteredWindowedKeyValueIterator<K, V>(((WindowStore)this.wrapped()).fetch(this.keyBytes(from), this.keyBytes(to), timeFrom, timeTo), this.fetchTime, this.metrics, this.serdes, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetchAll(long timeFrom, long timeTo) {
        return new MeteredWindowedKeyValueIterator<K, V>(((WindowStore)this.wrapped()).fetchAll(timeFrom, timeTo), this.fetchTime, this.metrics, this.serdes, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> all() {
        return new MeteredWindowedKeyValueIterator<K, V>(((WindowStore)this.wrapped()).all(), this.fetchTime, this.metrics, this.serdes, this.time);
    }

    @Override
    public void flush() {
        long startNs = this.time.nanoseconds();
        try {
            super.flush();
        }
        finally {
            this.metrics.recordLatency(this.flushTime, startNs, this.time.nanoseconds());
        }
    }

    @Override
    public void close() {
        super.close();
        this.metrics.removeAllStoreLevelSensors(this.threadId, this.taskName, this.name());
    }

    private Bytes keyBytes(K key) {
        return Bytes.wrap((byte[])this.serdes.rawKey(key));
    }
}

