/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.CacheFlushListener;

class TimestampedCacheFlushListener<K, V>
implements CacheFlushListener<K, ValueAndTimestamp<V>> {
    private final InternalProcessorContext context;
    private final ProcessorNode myNode;

    TimestampedCacheFlushListener(ProcessorContext context) {
        this.context = (InternalProcessorContext)context;
        this.myNode = this.context.currentNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(K key, ValueAndTimestamp<V> newValue, ValueAndTimestamp<V> oldValue, long timestamp) {
        ProcessorNode<?, ?, ?, ?> prev = this.context.currentNode();
        this.context.setCurrentNode(this.myNode);
        try {
            this.context.forward(key, new Change<V>(ValueAndTimestamp.getValueOrNull(newValue), ValueAndTimestamp.getValueOrNull(oldValue)), To.all().withTimestamp(newValue != null ? newValue.timestamp() : timestamp));
        }
        finally {
            this.context.setCurrentNode(prev);
        }
    }
}

