/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.processor.BatchingStateRestoreCallback;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.RocksDBConfigSetter;
import org.apache.kafka.streams.state.internals.BatchWritingStore;
import org.apache.kafka.streams.state.internals.BlockBasedTableConfigWithAccessibleCache;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter;
import org.apache.kafka.streams.state.internals.RocksDBRangeIterator;
import org.apache.kafka.streams.state.internals.RocksDbIterator;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.Cache;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.Filter;
import org.rocksdb.FlushOptions;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.LRUCache;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Statistics;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBStore
implements KeyValueStore<Bytes, byte[]>,
BatchWritingStore {
    private static final Logger log = LoggerFactory.getLogger(RocksDBStore.class);
    private static final CompressionType COMPRESSION_TYPE = CompressionType.NO_COMPRESSION;
    private static final CompactionStyle COMPACTION_STYLE = CompactionStyle.UNIVERSAL;
    private static final long WRITE_BUFFER_SIZE = 0x1000000L;
    private static final long BLOCK_CACHE_SIZE = 0x3200000L;
    private static final long BLOCK_SIZE = 4096L;
    private static final int MAX_WRITE_BUFFERS = 3;
    private static final String DB_FILE_DIR = "rocksdb";
    final String name;
    private final String parentDir;
    final Set<KeyValueIterator<Bytes, byte[]>> openIterators = Collections.synchronizedSet(new HashSet());
    File dbDir;
    RocksDB db;
    RocksDBAccessor dbAccessor;
    private RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter userSpecifiedOptions;
    WriteOptions wOptions;
    FlushOptions fOptions;
    private Cache cache;
    private BloomFilter filter;
    private RocksDBConfigSetter configSetter;
    private boolean userSpecifiedStatistics = false;
    private final RocksDBMetricsRecorder metricsRecorder;
    volatile BatchingStateRestoreCallback batchingStateRestoreCallback = null;
    protected volatile boolean open = false;

    RocksDBStore(String name, String metricsScope) {
        this(name, DB_FILE_DIR, new RocksDBMetricsRecorder(metricsScope, name));
    }

    RocksDBStore(String name, String parentDir, RocksDBMetricsRecorder metricsRecorder) {
        this.name = name;
        this.parentDir = parentDir;
        this.metricsRecorder = metricsRecorder;
    }

    void openDB(Map<String, Object> configs, File stateDir) {
        DBOptions dbOptions = new DBOptions();
        ColumnFamilyOptions columnFamilyOptions = new ColumnFamilyOptions();
        this.userSpecifiedOptions = new RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter(dbOptions, columnFamilyOptions);
        BlockBasedTableConfigWithAccessibleCache tableConfig = new BlockBasedTableConfigWithAccessibleCache();
        this.cache = new LRUCache(0x3200000L);
        tableConfig.setBlockCache(this.cache);
        tableConfig.setBlockSize(4096L);
        this.filter = new BloomFilter();
        tableConfig.setFilter((Filter)this.filter);
        this.userSpecifiedOptions.optimizeFiltersForHits();
        this.userSpecifiedOptions.setTableFormatConfig((TableFormatConfig)tableConfig);
        this.userSpecifiedOptions.setWriteBufferSize(0x1000000L);
        this.userSpecifiedOptions.setCompressionType(COMPRESSION_TYPE);
        this.userSpecifiedOptions.setCompactionStyle(COMPACTION_STYLE);
        this.userSpecifiedOptions.setMaxWriteBufferNumber(3);
        this.userSpecifiedOptions.setCreateIfMissing(true);
        this.userSpecifiedOptions.setErrorIfExists(false);
        this.userSpecifiedOptions.setInfoLogLevel(InfoLogLevel.ERROR_LEVEL);
        this.userSpecifiedOptions.setIncreaseParallelism(Math.max(Runtime.getRuntime().availableProcessors(), 2));
        this.wOptions = new WriteOptions();
        this.wOptions.setDisableWAL(true);
        this.fOptions = new FlushOptions();
        this.fOptions.setWaitForFlush(true);
        Class configSetterClass = (Class)configs.get("rocksdb.config.setter");
        if (configSetterClass != null) {
            this.configSetter = (RocksDBConfigSetter)Utils.newInstance((Class)configSetterClass);
            this.configSetter.setConfig(this.name, this.userSpecifiedOptions, configs);
        }
        this.dbDir = new File(new File(stateDir, this.parentDir), this.name);
        try {
            Files.createDirectories(this.dbDir.getParentFile().toPath(), new FileAttribute[0]);
            Files.createDirectories(this.dbDir.getAbsoluteFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException fatal) {
            throw new ProcessorStateException(fatal);
        }
        this.maybeSetUpStatistics(configs);
        this.openRocksDB(dbOptions, columnFamilyOptions);
        this.open = true;
        this.addValueProvidersToMetricsRecorder();
    }

    private void maybeSetUpStatistics(Map<String, Object> configs) {
        if (this.userSpecifiedOptions.statistics() != null) {
            this.userSpecifiedStatistics = true;
        }
        if (!this.userSpecifiedStatistics && Sensor.RecordingLevel.forName((String)((String)configs.get("metrics.recording.level"))) == Sensor.RecordingLevel.DEBUG) {
            Statistics statistics = new Statistics();
            this.userSpecifiedOptions.setStatistics(statistics);
        }
    }

    private void addValueProvidersToMetricsRecorder() {
        Statistics statistics;
        TableFormatConfig tableFormatConfig = this.userSpecifiedOptions.tableFormatConfig();
        Statistics statistics2 = statistics = this.userSpecifiedStatistics ? null : this.userSpecifiedOptions.statistics();
        if (tableFormatConfig instanceof BlockBasedTableConfigWithAccessibleCache) {
            Cache cache = ((BlockBasedTableConfigWithAccessibleCache)tableFormatConfig).blockCache();
            this.metricsRecorder.addValueProviders(this.name, this.db, cache, statistics);
        } else {
            if (tableFormatConfig instanceof BlockBasedTableConfig) {
                throw new ProcessorStateException("The used block-based table format configuration does not expose the block cache. Use the BlockBasedTableConfig instance provided by Options#tableFormatConfig() to configure the block-based table format of RocksDB. Do not provide a new instance of BlockBasedTableConfig to the RocksDB options.");
            }
            this.metricsRecorder.addValueProviders(this.name, this.db, null, statistics);
        }
    }

    void openRocksDB(DBOptions dbOptions, ColumnFamilyOptions columnFamilyOptions) {
        List<ColumnFamilyDescriptor> columnFamilyDescriptors = Collections.singletonList(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, columnFamilyOptions));
        ArrayList columnFamilies = new ArrayList(columnFamilyDescriptors.size());
        try {
            this.db = RocksDB.open((DBOptions)dbOptions, (String)this.dbDir.getAbsolutePath(), columnFamilyDescriptors, columnFamilies);
            this.dbAccessor = new SingleColumnFamilyAccessor((ColumnFamilyHandle)columnFamilies.get(0));
        }
        catch (RocksDBException e) {
            throw new ProcessorStateException("Error opening store " + this.name + " at location " + this.dbDir.toString(), e);
        }
    }

    @Override
    @Deprecated
    public void init(ProcessorContext context, StateStore root) {
        this.metricsRecorder.init(ProcessorContextUtils.getMetricsImpl(context), context.taskId());
        this.openDB(context.appConfigs(), context.stateDir());
        this.batchingStateRestoreCallback = new RocksDBBatchingRestoreCallback(this);
        context.register(root, this.batchingStateRestoreCallback);
    }

    @Override
    public void init(StateStoreContext context, StateStore root) {
        this.metricsRecorder.init(ProcessorContextUtils.getMetricsImpl(context), context.taskId());
        this.openDB(context.appConfigs(), context.stateDir());
        this.batchingStateRestoreCallback = new RocksDBBatchingRestoreCallback(this);
        context.register(root, this.batchingStateRestoreCallback);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean persistent() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    private void validateStoreOpen() {
        if (!this.open) {
            throw new InvalidStateStoreException("Store " + this.name + " is currently closed");
        }
    }

    @Override
    public synchronized void put(Bytes key, byte[] value) {
        Objects.requireNonNull(key, "key cannot be null");
        this.validateStoreOpen();
        this.dbAccessor.put(key.get(), value);
    }

    @Override
    public synchronized byte[] putIfAbsent(Bytes key, byte[] value) {
        Objects.requireNonNull(key, "key cannot be null");
        byte[] originalValue = this.get(key);
        if (originalValue == null) {
            this.put(key, value);
        }
        return originalValue;
    }

    @Override
    public void putAll(List<KeyValue<Bytes, byte[]>> entries) {
        try (WriteBatch batch = new WriteBatch();){
            this.dbAccessor.prepareBatch(entries, batch);
            this.write(batch);
        }
        catch (RocksDBException e) {
            throw new ProcessorStateException("Error while batch writing to store " + this.name, e);
        }
    }

    @Override
    public <PS extends Serializer<P>, P> KeyValueIterator<Bytes, byte[]> prefixScan(P prefix, PS prefixKeySerializer) {
        Objects.requireNonNull(prefix, "prefix cannot be null");
        Objects.requireNonNull(prefixKeySerializer, "prefixKeySerializer cannot be null");
        this.validateStoreOpen();
        Objects.requireNonNull(prefix, "prefix cannot be null");
        Objects.requireNonNull(prefixKeySerializer, "prefixKeySerializer cannot be null");
        Bytes prefixBytes = Bytes.wrap((byte[])prefixKeySerializer.serialize(null, prefix));
        KeyValueIterator<Bytes, byte[]> rocksDbPrefixSeekIterator = this.dbAccessor.prefixScan(prefixBytes);
        this.openIterators.add(rocksDbPrefixSeekIterator);
        return rocksDbPrefixSeekIterator;
    }

    @Override
    public synchronized byte[] get(Bytes key) {
        this.validateStoreOpen();
        try {
            return this.dbAccessor.get(key.get());
        }
        catch (RocksDBException e) {
            throw new ProcessorStateException("Error while getting value for key from store " + this.name, e);
        }
    }

    @Override
    public synchronized byte[] delete(Bytes key) {
        byte[] oldValue;
        Objects.requireNonNull(key, "key cannot be null");
        try {
            oldValue = this.dbAccessor.getOnly(key.get());
        }
        catch (RocksDBException e) {
            throw new ProcessorStateException("Error while getting value for key from store " + this.name, e);
        }
        this.put(key, null);
        return oldValue;
    }

    @Override
    public synchronized KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to) {
        return this.range(from, to, true);
    }

    @Override
    public synchronized KeyValueIterator<Bytes, byte[]> reverseRange(Bytes from, Bytes to) {
        return this.range(from, to, false);
    }

    KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to, boolean forward) {
        Objects.requireNonNull(from, "from cannot be null");
        Objects.requireNonNull(to, "to cannot be null");
        if (from.compareTo(to) > 0) {
            log.warn("Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers");
            return KeyValueIterators.emptyIterator();
        }
        this.validateStoreOpen();
        KeyValueIterator<Bytes, byte[]> rocksDBRangeIterator = this.dbAccessor.range(from, to, forward);
        this.openIterators.add(rocksDBRangeIterator);
        return rocksDBRangeIterator;
    }

    @Override
    public synchronized KeyValueIterator<Bytes, byte[]> all() {
        return this.all(true);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> reverseAll() {
        return this.all(false);
    }

    KeyValueIterator<Bytes, byte[]> all(boolean forward) {
        this.validateStoreOpen();
        KeyValueIterator<Bytes, byte[]> rocksDbIterator = this.dbAccessor.all(forward);
        this.openIterators.add(rocksDbIterator);
        return rocksDbIterator;
    }

    @Override
    public long approximateNumEntries() {
        long numEntries;
        this.validateStoreOpen();
        try {
            numEntries = this.dbAccessor.approximateNumEntries();
        }
        catch (RocksDBException e) {
            throw new ProcessorStateException("Error fetching property from store " + this.name, e);
        }
        if (this.isOverflowing(numEntries)) {
            return Long.MAX_VALUE;
        }
        return numEntries;
    }

    private boolean isOverflowing(long value) {
        return value < 0L;
    }

    @Override
    public synchronized void flush() {
        if (this.db == null) {
            return;
        }
        try {
            this.dbAccessor.flush();
        }
        catch (RocksDBException e) {
            throw new ProcessorStateException("Error while executing flush from store " + this.name, e);
        }
    }

    @Override
    public void addToBatch(KeyValue<byte[], byte[]> record, WriteBatch batch) throws RocksDBException {
        this.dbAccessor.addToBatch((byte[])record.key, (byte[])record.value, batch);
    }

    @Override
    public void write(WriteBatch batch) throws RocksDBException {
        this.db.write(this.wOptions, batch);
    }

    @Override
    public synchronized void close() {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.closeOpenIterators();
        if (this.configSetter != null) {
            this.configSetter.close(this.name, this.userSpecifiedOptions);
            this.configSetter = null;
        }
        this.metricsRecorder.removeValueProviders(this.name);
        this.dbAccessor.close();
        this.db.close();
        this.userSpecifiedOptions.close();
        this.wOptions.close();
        this.fOptions.close();
        this.filter.close();
        this.cache.close();
        this.dbAccessor = null;
        this.userSpecifiedOptions = null;
        this.wOptions = null;
        this.fOptions = null;
        this.db = null;
        this.filter = null;
        this.cache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOpenIterators() {
        HashSet<KeyValueIterator<Bytes, byte[]>> iterators;
        Set<KeyValueIterator<Bytes, byte[]>> set = this.openIterators;
        synchronized (set) {
            iterators = new HashSet<KeyValueIterator<Bytes, byte[]>>(this.openIterators);
        }
        if (iterators.size() != 0) {
            log.warn("Closing {} open iterators for store {}", (Object)iterators.size(), (Object)this.name);
            for (KeyValueIterator keyValueIterator : iterators) {
                keyValueIterator.close();
            }
        }
    }

    public Options getOptions() {
        return this.userSpecifiedOptions;
    }

    static class RocksDBBatchingRestoreCallback
    implements BatchingStateRestoreCallback {
        private final RocksDBStore rocksDBStore;

        RocksDBBatchingRestoreCallback(RocksDBStore rocksDBStore) {
            this.rocksDBStore = rocksDBStore;
        }

        @Override
        public void restoreAll(Collection<KeyValue<byte[], byte[]>> records) {
            try (WriteBatch batch = new WriteBatch();){
                this.rocksDBStore.dbAccessor.prepareBatchForRestore(records, batch);
                this.rocksDBStore.write(batch);
            }
            catch (RocksDBException e) {
                throw new ProcessorStateException("Error restoring batch to store " + this.rocksDBStore.name, e);
            }
        }
    }

    class SingleColumnFamilyAccessor
    implements RocksDBAccessor {
        private final ColumnFamilyHandle columnFamily;

        SingleColumnFamilyAccessor(ColumnFamilyHandle columnFamily) {
            this.columnFamily = columnFamily;
        }

        @Override
        public void put(byte[] key, byte[] value) {
            if (value == null) {
                try {
                    RocksDBStore.this.db.delete(this.columnFamily, RocksDBStore.this.wOptions, key);
                }
                catch (RocksDBException e) {
                    throw new ProcessorStateException("Error while removing key from store " + RocksDBStore.this.name, e);
                }
            }
            try {
                RocksDBStore.this.db.put(this.columnFamily, RocksDBStore.this.wOptions, key, value);
            }
            catch (RocksDBException e) {
                throw new ProcessorStateException("Error while putting key/value into store " + RocksDBStore.this.name, e);
            }
        }

        @Override
        public void prepareBatch(List<KeyValue<Bytes, byte[]>> entries, WriteBatch batch) throws RocksDBException {
            for (KeyValue<Bytes, byte[]> entry : entries) {
                Objects.requireNonNull(entry.key, "key cannot be null");
                this.addToBatch(((Bytes)entry.key).get(), (byte[])entry.value, batch);
            }
        }

        @Override
        public byte[] get(byte[] key) throws RocksDBException {
            return RocksDBStore.this.db.get(this.columnFamily, key);
        }

        @Override
        public byte[] getOnly(byte[] key) throws RocksDBException {
            return RocksDBStore.this.db.get(this.columnFamily, key);
        }

        @Override
        public KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to, boolean forward) {
            return new RocksDBRangeIterator(RocksDBStore.this.name, RocksDBStore.this.db.newIterator(this.columnFamily), RocksDBStore.this.openIterators, from, to, forward, true);
        }

        @Override
        public KeyValueIterator<Bytes, byte[]> all(boolean forward) {
            RocksIterator innerIterWithTimestamp = RocksDBStore.this.db.newIterator(this.columnFamily);
            if (forward) {
                innerIterWithTimestamp.seekToFirst();
            } else {
                innerIterWithTimestamp.seekToLast();
            }
            return new RocksDbIterator(RocksDBStore.this.name, innerIterWithTimestamp, RocksDBStore.this.openIterators, forward);
        }

        @Override
        public KeyValueIterator<Bytes, byte[]> prefixScan(Bytes prefix) {
            Bytes to = Bytes.increment((Bytes)prefix);
            return new RocksDBRangeIterator(RocksDBStore.this.name, RocksDBStore.this.db.newIterator(this.columnFamily), RocksDBStore.this.openIterators, prefix, to, true, false);
        }

        @Override
        public long approximateNumEntries() throws RocksDBException {
            return RocksDBStore.this.db.getLongProperty(this.columnFamily, "rocksdb.estimate-num-keys");
        }

        @Override
        public void flush() throws RocksDBException {
            RocksDBStore.this.db.flush(RocksDBStore.this.fOptions, this.columnFamily);
        }

        @Override
        public void prepareBatchForRestore(Collection<KeyValue<byte[], byte[]>> records, WriteBatch batch) throws RocksDBException {
            for (KeyValue<byte[], byte[]> record : records) {
                this.addToBatch((byte[])record.key, (byte[])record.value, batch);
            }
        }

        @Override
        public void addToBatch(byte[] key, byte[] value, WriteBatch batch) throws RocksDBException {
            if (value == null) {
                batch.delete(this.columnFamily, key);
            } else {
                batch.put(this.columnFamily, key, value);
            }
        }

        @Override
        public void close() {
            this.columnFamily.close();
        }
    }

    static interface RocksDBAccessor {
        public void put(byte[] var1, byte[] var2);

        public void prepareBatch(List<KeyValue<Bytes, byte[]>> var1, WriteBatch var2) throws RocksDBException;

        public byte[] get(byte[] var1) throws RocksDBException;

        public byte[] getOnly(byte[] var1) throws RocksDBException;

        public KeyValueIterator<Bytes, byte[]> range(Bytes var1, Bytes var2, boolean var3);

        public KeyValueIterator<Bytes, byte[]> all(boolean var1);

        public KeyValueIterator<Bytes, byte[]> prefixScan(Bytes var1);

        public long approximateNumEntries() throws RocksDBException;

        public void flush() throws RocksDBException;

        public void prepareBatchForRestore(Collection<KeyValue<byte[], byte[]>> var1, WriteBatch var2) throws RocksDBException;

        public void addToBatch(byte[] var1, byte[] var2, WriteBatch var3) throws RocksDBException;

        public void close();
    }
}

