/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.namedtopology;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.internals.DefaultKafkaClientSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.namedtopology.NamedTopology;

@InterfaceStability.Unstable
public class KafkaStreamsNamedTopologyWrapper
extends KafkaStreams {
    public KafkaStreamsNamedTopologyWrapper(NamedTopology topology, Properties props) {
        this(Collections.singleton(topology), new StreamsConfig(props), (KafkaClientSupplier)new DefaultKafkaClientSupplier());
    }

    public KafkaStreamsNamedTopologyWrapper(NamedTopology topology, Properties props, KafkaClientSupplier clientSupplier) {
        this(Collections.singleton(topology), new StreamsConfig(props), clientSupplier);
    }

    public KafkaStreamsNamedTopologyWrapper(Properties props) {
        this(Collections.emptyList(), new StreamsConfig(props), (KafkaClientSupplier)new DefaultKafkaClientSupplier());
    }

    public KafkaStreamsNamedTopologyWrapper(Properties props, KafkaClientSupplier clientSupplier) {
        this(Collections.emptyList(), new StreamsConfig(props), clientSupplier);
    }

    public KafkaStreamsNamedTopologyWrapper(Collection<NamedTopology> topologies, Properties props) {
        this(topologies, new StreamsConfig(props), (KafkaClientSupplier)new DefaultKafkaClientSupplier());
    }

    public KafkaStreamsNamedTopologyWrapper(Collection<NamedTopology> topologies, Properties props, KafkaClientSupplier clientSupplier) {
        this(topologies, new StreamsConfig(props), clientSupplier);
    }

    private KafkaStreamsNamedTopologyWrapper(Collection<NamedTopology> topologies, StreamsConfig config, KafkaClientSupplier clientSupplier) {
        super(new TopologyMetadata(topologies.stream().collect(Collectors.toMap(NamedTopology::name, NamedTopology::internalTopologyBuilder, (v1, v2) -> {
            throw new IllegalArgumentException("Topology names must be unique");
        }, () -> new ConcurrentSkipListMap())), config), config, clientSupplier);
    }

    public Optional<NamedTopology> getTopologyByName(String name) {
        return Optional.ofNullable(this.topologyMetadata.lookupBuilderForNamedTopology(name)).map(InternalTopologyBuilder::namedTopology);
    }

    public void addNamedTopology(NamedTopology newTopology) {
        if (this.hasStartedOrFinishedShuttingDown()) {
            throw new IllegalStateException("Cannot add a NamedTopology while the state is " + (Object)((Object)this.state));
        }
        if (this.getTopologyByName(newTopology.name()).isPresent()) {
            throw new IllegalArgumentException("Unable to add the new NamedTopology " + newTopology.name() + " as another of the same name already exists");
        }
        this.topologyMetadata.registerAndBuildNewTopology(newTopology.internalTopologyBuilder());
    }

    public void removeNamedTopology(String topologyToRemove) {
        if (!this.isRunningOrRebalancing()) {
            throw new IllegalStateException("Cannot remove a NamedTopology while the state is " + (Object)((Object)this.state));
        }
        if (!this.getTopologyByName(topologyToRemove).isPresent()) {
            throw new IllegalArgumentException("Unable to locate for removal a NamedTopology called " + topologyToRemove);
        }
        this.topologyMetadata.unregisterTopology(topologyToRemove);
    }

    public void cleanUpNamedTopology(String name) {
        if (this.getTopologyByName(name).isPresent()) {
            throw new IllegalStateException("Can't clean up local state for an active NamedTopology: " + name);
        }
        this.stateDirectory.clearLocalStateForNamedTopology(name);
    }

    public String getFullTopologyDescription() {
        return this.topologyMetadata.topologyDescriptionString();
    }
}

