/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.Maybe;

public interface TimeOrderedKeyValueBuffer<K, V>
extends StateStore {
    public void setSerdesIfNull(SerdeGetter var1);

    public void evictWhile(Supplier<Boolean> var1, Consumer<Eviction<K, V>> var2);

    public Maybe<ValueAndTimestamp<V>> priorValueForBuffered(K var1);

    public void put(long var1, Record<K, Change<V>> var3, ProcessorRecordContext var4);

    public int numRecords();

    public long bufferSize();

    public long minTimestamp();

    public static final class Eviction<K, V> {
        private final K key;
        private final Change<V> value;
        private final ProcessorRecordContext recordContext;

        Eviction(K key, Change<V> value, ProcessorRecordContext recordContext) {
            this.key = key;
            this.value = value;
            this.recordContext = recordContext;
        }

        public K key() {
            return this.key;
        }

        public Change<V> value() {
            return this.value;
        }

        public Record<K, Change<V>> record() {
            return new Record<K, Change<V>>(this.key, this.value, this.recordContext.timestamp());
        }

        public ProcessorRecordContext recordContext() {
            return this.recordContext;
        }

        public String toString() {
            return "Eviction{key=" + this.key + ", value=" + this.value + ", recordContext=" + this.recordContext + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Eviction eviction = (Eviction)o;
            return Objects.equals(this.key, eviction.key) && Objects.equals(this.value, eviction.value) && Objects.equals(this.recordContext, eviction.recordContext);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value, this.recordContext);
        }
    }
}

