/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload.partitioner;

import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.trogdor.workload.partitioner.GaussianPartitionerConfig;

public class GaussianPartitioner
implements Partitioner {
    private final Random random = new Random();
    private int mean;
    private int std;

    public void configure(Map<String, ?> configs) {
        GaussianPartitionerConfig config = new GaussianPartitionerConfig(configs);
        this.mean = config.getInt("confluent.gaussian.partitioner.mean");
        this.std = config.getInt("confluent.gaussian.partitioner.std");
    }

    public int partition(String topic, Object key, byte[] keyBytes, Object value, byte[] valueBytes, Cluster cluster) {
        List partitions = cluster.partitionsForTopic(topic);
        return this.nextPartition(partitions.size());
    }

    private int nextPartition(int partitionCount) {
        double val;
        int partition;
        while ((partition = ((int)Math.round(val = this.random.nextGaussian() * (double)this.std + (double)this.mean) + partitionCount) % partitionCount) < 0 || partition > partitionCount - 1) {
        }
        return partition;
    }

    public void close() {
    }
}

