/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.api;

import java.io.File;
import java.util.Properties;
import kafka.admin.AdminClient;
import kafka.admin.AdminClient$;
import kafka.api.IntegrationTestHarness;
import kafka.api.IntegrationTestHarness$class;
import kafka.coordinator.GroupOverview;
import kafka.coordinator.GroupSummary;
import kafka.coordinator.MemberSummary;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u0001%\u0011q\"\u00113nS:\u001cE.[3oiR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1!\u00199j\u0015\t)a!A\u0003lC\u001a\\\u0017MC\u0001\b\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\u0004\u0001M!\u0001A\u0003\u000b\u001b!\tY!#D\u0001\r\u0015\tia\"A\u0003kk:LGO\u0003\u0002\u0010!\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002#\u0005\u0019qN]4\n\u0005Ma!A\u0003&V]&$8+^5uKB\u0011Q\u0003G\u0007\u0002-)\u00111a\u0006\u0006\u0002\u000b%\u0011\u0011D\u0006\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tgB\u00111DH\u0007\u00029)\u0011QdF\u0001\u0006kRLGn]\u0005\u0003?q\u0011q\u0001T8hO&tw\rC\u0003\"\u0001\u0011\u0005!%\u0001\u0004=S:LGO\u0010\u000b\u0002GA\u0011A\u0005A\u0007\u0002\u0005!9a\u0005\u0001b\u0001\n\u00039\u0013!\u00049s_\u0012,8-\u001a:D_VtG/F\u0001)!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\rIe\u000e\u001e\u0005\u0007_\u0001\u0001\u000b\u0011\u0002\u0015\u0002\u001dA\u0014x\u000eZ;dKJ\u001cu.\u001e8uA!9\u0011\u0007\u0001b\u0001\n\u00039\u0013!D2p]N,X.\u001a:D_VtG\u000f\u0003\u00044\u0001\u0001\u0006I\u0001K\u0001\u000fG>t7/^7fe\u000e{WO\u001c;!\u0011\u001d)\u0004A1A\u0005\u0002\u001d\n1b]3sm\u0016\u00148i\\;oi\"1q\u0007\u0001Q\u0001\n!\nAb]3sm\u0016\u00148i\\;oi\u0002Bq!\u000f\u0001C\u0002\u0013\u0005!(A\u0004he>,\b/\u00133\u0016\u0003m\u0002\"\u0001P!\u000e\u0003uR!AP \u0002\t1\fgn\u001a\u0006\u0002\u0001\u0006!!.\u0019<b\u0013\t\u0011UH\u0001\u0004TiJLgn\u001a\u0005\u0007\t\u0002\u0001\u000b\u0011B\u001e\u0002\u0011\u001d\u0014x.\u001e9JI\u0002BqA\u0012\u0001C\u0002\u0013\u0005!(\u0001\u0005dY&,g\u000e^%e\u0011\u0019A\u0005\u0001)A\u0005w\u0005I1\r\\5f]RLE\r\t\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001;\u0003\u0015!x\u000e]5d\u0011\u0019a\u0005\u0001)A\u0005w\u00051Ao\u001c9jG\u0002BqA\u0014\u0001C\u0002\u0013\u0005q%\u0001\u0003qCJ$\bB\u0002)\u0001A\u0003%\u0001&A\u0003qCJ$\b\u0005C\u0004S\u0001\t\u0007I\u0011A*\u0002\u0005Q\u0004X#\u0001+\u0011\u0005U[V\"\u0001,\u000b\u0005]C\u0016AB2p[6|gN\u0003\u0002\u00063*\u0011!\fE\u0001\u0007CB\f7\r[3\n\u0005q3&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007=\u0002\u0001\u000b\u0011\u0002+\u0002\u0007Q\u0004\b\u0005C\u0004a\u0001\t\u0007I\u0011A\u0014\u0002\u000bA\f'\u000f\u001e\u001a\t\r\t\u0004\u0001\u0015!\u0003)\u0003\u0019\u0001\u0018M\u001d;3A!9A\r\u0001b\u0001\n\u0003\u0019\u0016a\u0001;qe!1a\r\u0001Q\u0001\nQ\u000bA\u0001\u001e93A!9\u0001\u000e\u0001a\u0001\n\u0003I\u0017AB2mS\u0016tG/F\u0001k!\tYg.D\u0001m\u0015\tiw#A\u0003bI6Lg.\u0003\u0002pY\nY\u0011\tZ7j]\u000ec\u0017.\u001a8u\u0011\u001d\t\b\u00011A\u0005\u0002I\f!b\u00197jK:$x\fJ3r)\t\u0019h\u000f\u0005\u0002*i&\u0011QO\u000b\u0002\u0005+:LG\u000fC\u0004xa\u0006\u0005\t\u0019\u00016\u0002\u0007a$\u0013\u0007\u0003\u0004z\u0001\u0001\u0006KA[\u0001\bG2LWM\u001c;!\u0011\u0015Y\b\u0001\"\u0011}\u0003\u0015\u0019X\r^+q)\u0005\u0019\bF\u0001>\u007f!\ry\u00181A\u0007\u0003\u0003\u0003Q!!\u0004\t\n\t\u0005\u0015\u0011\u0011\u0001\u0002\u0007\u0005\u00164wN]3\t\r\u0005%\u0001\u0001\"\u0001}\u00039!Xm\u001d;MSN$xI]8vaNDC!a\u0002\u0002\u000eA\u0019q0a\u0004\n\t\u0005E\u0011\u0011\u0001\u0002\u0005)\u0016\u001cH\u000f\u0003\u0004\u0002\u0016\u0001!\t\u0001`\u0001\u0012i\u0016\u001cH\u000fR3tGJL'-Z$s_V\u0004\b\u0006BA\n\u0003\u001bAa!a\u0007\u0001\t\u0003a\u0018!\u0007;fgR$Um]2sS\n,7i\u001c8tk6,'o\u0012:pkBDC!!\u0007\u0002\u000e!1\u0011\u0011\u0005\u0001\u0005\u0002q\fA\u0006^3ti\u0012+7o\u0019:jE\u0016\u001cuN\\:v[\u0016\u0014xI]8va\u001a{'OT8o\u000bbL7\u000f^3oi\u001e\u0013x.\u001e9)\t\u0005}\u0011Q\u0002")
public class AdminClientTest
extends JUnitSuite
implements IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String groupId;
    private final String clientId;
    private final String topic;
    private final int part;
    private final TopicPartition tp;
    private final int part2;
    private final TopicPartition tp2;
    private AdminClient client;
    private final Properties producerConfig;
    private final Properties consumerConfig;
    private final Properties serverConfig;
    private final Buffer<KafkaConsumer<byte[], byte[]>> consumers;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private EmbeddedZookeeper zookeeper;
    private int zkPort;
    private ZkUtils zkUtils;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile byte bitmap$0;

    private Properties producerConfig$lzycompute() {
        AdminClientTest adminClientTest = this;
        synchronized (adminClientTest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.producerConfig = IntegrationTestHarness$class.producerConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.producerConfig;
        }
    }

    @Override
    public Properties producerConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.producerConfig$lzycompute() : this.producerConfig;
    }

    private Properties consumerConfig$lzycompute() {
        AdminClientTest adminClientTest = this;
        synchronized (adminClientTest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.consumerConfig = IntegrationTestHarness$class.consumerConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.consumerConfig;
        }
    }

    @Override
    public Properties consumerConfig() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.consumerConfig$lzycompute() : this.consumerConfig;
    }

    private Properties serverConfig$lzycompute() {
        AdminClientTest adminClientTest = this;
        synchronized (adminClientTest) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.serverConfig = IntegrationTestHarness$class.serverConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.serverConfig;
        }
    }

    @Override
    public Properties serverConfig() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.serverConfig$lzycompute() : this.serverConfig;
    }

    @Override
    public Buffer<KafkaConsumer<byte[], byte[]>> consumers() {
        return this.consumers;
    }

    @Override
    public Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    @Override
    public void kafka$api$IntegrationTestHarness$$super$setUp() {
        KafkaServerTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$api$IntegrationTestHarness$$super$tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$api$IntegrationTestHarness$_setter_$consumers_$eq(Buffer x$1) {
        this.consumers = x$1;
    }

    @Override
    public void kafka$api$IntegrationTestHarness$_setter_$producers_$eq(Buffer x$1) {
        this.producers = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return IntegrationTestHarness$class.generateConfigs(this);
    }

    @Override
    @After
    public void tearDown() {
        IntegrationTestHarness$class.tearDown(this);
    }

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public int zkPort() {
        return this.zkPort;
    }

    @Override
    public void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    public String confFile() {
        return ZooKeeperTestHarness$class.confFile(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AdminClientTest adminClientTest = this;
        synchronized (adminClientTest) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    public String groupId() {
        return this.groupId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public AdminClient client() {
        return this.client;
    }

    public void client_$eq(AdminClient x$1) {
        this.client = x$1;
    }

    @Override
    @Before
    public void setUp() {
        IntegrationTestHarness$class.setUp(this);
        this.client_$eq(AdminClient$.MODULE$.createSimplePlaintext(this.brokerList()));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    @Test
    public void testListGroups() {
        ((KafkaConsumer)this.consumers().apply(0)).subscribe(JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(0L);
                return !((KafkaConsumer)this.$outer.consumers().apply(0)).assignment().isEmpty();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "Expected non-empty assignment", TestUtils$.MODULE$.waitUntilTrue$default$3());
        List groups = this.client().listAllGroupsFlattened();
        Assert.assertFalse((boolean)groups.isEmpty());
        GroupOverview group = (GroupOverview)groups.apply(0);
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)"consumer", (Object)group.protocolType());
    }

    @Test
    public void testDescribeGroup() {
        ((KafkaConsumer)this.consumers().apply(0)).subscribe(JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(0L);
                return !((KafkaConsumer)this.$outer.consumers().apply(0)).assignment().isEmpty();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "Expected non-empty assignment", TestUtils$.MODULE$.waitUntilTrue$default$3());
        GroupSummary group = this.client().describeGroup(this.groupId());
        Assert.assertEquals((Object)"consumer", (Object)group.protocolType());
        Assert.assertEquals((Object)"range", (Object)group.protocol());
        Assert.assertEquals((Object)"Stable", (Object)group.state());
        Assert.assertFalse((boolean)group.members().isEmpty());
        MemberSummary member = (MemberSummary)group.members().apply(0);
        Assert.assertEquals((Object)this.clientId(), (Object)member.clientId());
        Assert.assertFalse((boolean)member.clientHost().isEmpty());
        Assert.assertFalse((boolean)member.memberId().isEmpty());
    }

    @Test
    public void testDescribeConsumerGroup() {
        ((KafkaConsumer)this.consumers().apply(0)).subscribe(JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(0L);
                return !((KafkaConsumer)this.$outer.consumers().apply(0)).assignment().isEmpty();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "Expected non-empty assignment", TestUtils$.MODULE$.waitUntilTrue$default$3());
        List consumerSummaries = this.client().describeConsumerGroup(this.groupId());
        Assert.assertEquals((long)1L, (long)consumerSummaries.size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()})), (Object)((AdminClient.ConsumerSummary)consumerSummaries.head()).assignment().toSet());
    }

    @Test
    public void testDescribeConsumerGroupForNonExistentGroup() {
        String nonExistentGroup = new StringBuilder().append((Object)"non").append((Object)this.groupId()).toString();
        Assert.assertTrue((String)"Expected empty ConsumerSummary list", (boolean)this.client().describeConsumerGroup(nonExistentGroup).isEmpty());
    }

    public AdminClientTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        IntegrationTestHarness$class.$init$(this);
        this.producerCount = 1;
        this.consumerCount = 2;
        this.serverCount = 3;
        this.groupId = "my-test";
        this.clientId = "consumer-498";
        this.topic = "topic";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.part2 = 1;
        this.tp2 = new TopicPartition(this.topic(), this.part2());
        this.client = null;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.producerConfig().setProperty("acks", "all");
        this.consumerConfig().setProperty("group.id", this.groupId());
        this.consumerConfig().setProperty("client.id", this.clientId());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
    }
}

