/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.api.ProducerResponseStatus;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.common.TopicAndPartition;
import kafka.coordinator.AwaitingSync$;
import kafka.coordinator.GroupCoordinator;
import kafka.coordinator.GroupCoordinator$;
import kafka.coordinator.GroupOverview;
import kafka.coordinator.GroupSummary;
import kafka.coordinator.JoinGroupResult;
import kafka.coordinator.MemberSummary;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.utils.KafkaScheduler;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.protocol.Errors;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Short$;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\rh\u0001B\u0001\u0003\u0001\u001d\u0011Ad\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:SKN\u0004xN\\:f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0003\u000b\u0011A\u0002\u0001A\r\u0003#){\u0017N\\$s_V\u00048)\u00197mE\u0006\u001c7\u000e\u0005\u0003\u001b;}\u0011S\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\f!\u0013\t\t#AA\bK_&twI]8vaJ+7/\u001e7u!\tQ2%\u0003\u0002%7\t!QK\\5u\u000b\u00111\u0003\u0001A\u0014\u0003/MKhnY$s_V\u00048)\u00197mE\u0006\u001c7\u000eU1sC6\u001c\b\u0003\u0002\u000e)UAJ!!K\u000e\u0003\rQ+\b\u000f\\33!\rQ2&L\u0005\u0003Ym\u0011Q!\u0011:sCf\u0004\"A\u0007\u0018\n\u0005=Z\"\u0001\u0002\"zi\u0016\u0004\"AG\u0019\n\u0005IZ\"!B*i_J$X\u0001\u0002\u001b\u0001\u0001U\u0012\u0011cU=oG\u001e\u0013x.\u001e9DC2d'-Y2l!\u0015QbG\u000b\u0019#\u0013\t94DA\u0005Gk:\u001cG/[8oe\u0015!\u0011\b\u0001\u00011\u0005]AU-\u0019:uE\u0016\fGoQ1mY\n\f7m\u001b)be\u0006l7/\u0002\u0003<\u0001\u0001a$!\u0005%fCJ$(-Z1u\u0007\u0006dGNY1dWB!!$\b\u0019#\u000b\u0011q\u0004\u0001A \u00035\r{W.\\5u\u001f\u001a47/\u001a;DC2d'-Y2l!\u0006\u0014\u0018-\\:\u0011\t\u0001\u001bU\tM\u0007\u0002\u0003*\u0011!iG\u0001\u000bG>dG.Z2uS>t\u0017B\u0001#B\u0005\ri\u0015\r\u001d\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\u0012\taaY8n[>t\u0017B\u0001&H\u0005E!v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\\\u0003\u0005\u0019\u0002\u0001QJ\u0001\u000bD_6l\u0017\u000e^(gMN,GoQ1mY\n\f7m\u001b\t\u00055uy$%\u0002\u0003P\u0001\u0001\u0001$\u0001\u0007'fCZ,wI]8va\u000e\u000bG\u000e\u001c2bG.\u0004\u0016M]1ng\u0016!\u0011\u000b\u0001\u0001=\u0005IaU-\u0019<f\u000fJ|W\u000f]\"bY2\u0014\u0017mY6\t\u000fM\u0003!\u0019!C\u0001)\u0006A1\t\\5f]RLE-F\u0001V!\t16,D\u0001X\u0015\tA\u0016,\u0001\u0003mC:<'\"\u0001.\u0002\t)\fg/Y\u0005\u00039^\u0013aa\u0015;sS:<\u0007B\u00020\u0001A\u0003%Q+A\u0005DY&,g\u000e^%eA!9\u0001\r\u0001b\u0001\n\u0003!\u0016AC\"mS\u0016tG\u000fS8ti\"1!\r\u0001Q\u0001\nU\u000b1b\u00117jK:$\bj\\:uA!9A\r\u0001b\u0001\n\u0003)\u0017!G\"p]N,X.\u001a:NS:\u001cVm]:j_:$\u0016.\\3pkR,\u0012A\u001a\t\u00035\u001dL!\u0001[\u000e\u0003\u0007%sG\u000f\u0003\u0004k\u0001\u0001\u0006IAZ\u0001\u001b\u0007>t7/^7fe6KgnU3tg&|g\u000eV5nK>,H\u000f\t\u0005\bY\u0002\u0011\r\u0011\"\u0001f\u0003e\u0019uN\\:v[\u0016\u0014X*\u0019=TKN\u001c\u0018n\u001c8US6,w.\u001e;\t\r9\u0004\u0001\u0015!\u0003g\u0003i\u0019uN\\:v[\u0016\u0014X*\u0019=TKN\u001c\u0018n\u001c8US6,w.\u001e;!\u0011\u001d\u0001\bA1A\u0005\u0002\u0015\fQ\u0003R3gCVdGoU3tg&|g\u000eV5nK>,H\u000f\u0003\u0004s\u0001\u0001\u0006IAZ\u0001\u0017\t\u00164\u0017-\u001e7u'\u0016\u001c8/[8o)&lWm\\;uA!9A\u000f\u0001a\u0001\n\u0003)\u0018\u0001E4s_V\u00048i\\8sI&t\u0017\r^8s+\u00051\bC\u0001\fx\u0013\tA(A\u0001\tHe>,\boQ8pe\u0012Lg.\u0019;pe\"9!\u0010\u0001a\u0001\n\u0003Y\u0018\u0001F4s_V\u00048i\\8sI&t\u0017\r^8s?\u0012*\u0017\u000f\u0006\u0002#y\"9Q0_A\u0001\u0002\u00041\u0018a\u0001=%c!1q\u0010\u0001Q!\nY\f\u0011c\u001a:pkB\u001cun\u001c:eS:\fGo\u001c:!\u0011%\t\u0019\u0001\u0001a\u0001\n\u0003\t)!\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055A!\u0001\u0004tKJ4XM]\u0005\u0005\u0003#\tYA\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u0013\u0005U\u0001\u00011A\u0005\u0002\u0005]\u0011A\u0005:fa2L7-Y'b]\u0006<WM]0%KF$2AIA\r\u0011%i\u00181CA\u0001\u0002\u0004\t9\u0001\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0015BA\u0004\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0003\"CA\u0011\u0001\u0001\u0007I\u0011AA\u0012\u0003%\u00198\r[3ek2,'/\u0006\u0002\u0002&A!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,\u0011\tQ!\u001e;jYNLA!a\f\u0002*\tq1*\u00194lCN\u001b\u0007.\u001a3vY\u0016\u0014\b\"CA\u001a\u0001\u0001\u0007I\u0011AA\u001b\u00035\u00198\r[3ek2,'o\u0018\u0013fcR\u0019!%a\u000e\t\u0013u\f\t$!AA\u0002\u0005\u0015\u0002\u0002CA\u001e\u0001\u0001\u0006K!!\n\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u0014\b\u0005C\u0005\u0002@\u0001\u0001\r\u0011\"\u0001\u0002B\u00059!p[+uS2\u001cXCAA\"!\u0011\t9#!\u0012\n\t\u0005\u001d\u0013\u0011\u0006\u0002\b5.,F/\u001b7t\u0011%\tY\u0005\u0001a\u0001\n\u0003\ti%A\u0006{WV#\u0018\u000e\\:`I\u0015\fHc\u0001\u0012\u0002P!IQ0!\u0013\u0002\u0002\u0003\u0007\u00111\t\u0005\t\u0003'\u0002\u0001\u0015)\u0003\u0002D\u0005A!p[+uS2\u001c\b\u0005\u0003\u0005\u0002X\u0001\u0011\r\u0011\"\u0003U\u0003\u001d9'o\\;q\u0013\u0012Dq!a\u0017\u0001A\u0003%Q+\u0001\u0005he>,\b/\u00133!\u0011!\ty\u0006\u0001b\u0001\n\u0013!\u0016\u0001\u00049s_R|7m\u001c7UsB,\u0007bBA2\u0001\u0001\u0006I!V\u0001\u000eaJ|Go\\2pYRK\b/\u001a\u0011\t\u0011\u0005\u001d\u0004A1A\u0005\nQ\u000b\u0001\"\\3nE\u0016\u0014\u0018\n\u001a\u0005\b\u0003W\u0002\u0001\u0015!\u0003V\u0003%iW-\u001c2fe&#\u0007\u0005C\u0005\u0002p\u0001\u0011\r\u0011\"\u0003\u0002r\u0005AQ.\u001a;bI\u0006$\u0018-F\u0001+\u0011\u001d\t)\b\u0001Q\u0001\n)\n\u0011\"\\3uC\u0012\fG/\u0019\u0011\t\u0013\u0005e\u0004A1A\u0005\n\u0005m\u0014!\u00039s_R|7m\u001c7t+\t\ti\b\u0005\u0004\u0002\u0000\u0005\u0015\u0015\u0011R\u0007\u0003\u0003\u0003S1!a!B\u0003%IW.\\;uC\ndW-\u0003\u0003\u0002\b\u0006\u0005%\u0001\u0002'jgR\u0004BA\u0007\u0015VU!A\u0011Q\u0012\u0001!\u0002\u0013\ti(\u0001\u0006qe>$xnY8mg\u0002B\u0001\"!%\u0001\u0001\u0004%I!Z\u0001\u0011OJ|W\u000f\u001d)beRLG/[8o\u0013\u0012D\u0011\"!&\u0001\u0001\u0004%I!a&\u0002)\u001d\u0014x.\u001e9QCJ$\u0018\u000e^5p]&#w\fJ3r)\r\u0011\u0013\u0011\u0014\u0005\t{\u0006M\u0015\u0011!a\u0001M\"9\u0011Q\u0014\u0001!B\u00131\u0017!E4s_V\u0004\b+\u0019:uSRLwN\\%eA!A\u0011\u0011\u0015\u0001C\u0002\u0013%A+\u0001\u0007pi\",'o\u0012:pkBLE\rC\u0004\u0002&\u0002\u0001\u000b\u0011B+\u0002\u001b=$\b.\u001a:He>,\b/\u00133!\u0011\u001d\tI\u000b\u0001C\u0001\u0003W\u000bQa]3u+B$\u0012A\t\u0015\u0005\u0003O\u000by\u000b\u0005\u0003\u00022\u0006UVBAAZ\u0015\tYa\"\u0003\u0003\u00028\u0006M&A\u0002\"fM>\u0014X\rC\u0004\u0002<\u0002!\t!a+\u0002\u0011Q,\u0017M\u001d#po:DC!!/\u0002@B!\u0011\u0011WAa\u0013\u0011\t\u0019-a-\u0003\u000b\u00053G/\u001a:\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002,\u0006iB/Z:u\u0015>Lgn\u0012:pkB<&o\u001c8h\u0007>|'\u000fZ5oCR|'\u000f\u000b\u0003\u0002F\u0006-\u0007\u0003BAY\u0003\u001bLA!a4\u00024\n!A+Z:u\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003W\u000b1\u0005^3ti*{\u0017N\\$s_V\u00048+Z:tS>tG+[7f_V$Hk\\8T[\u0006dG\u000e\u000b\u0003\u0002R\u0006-\u0007bBAm\u0001\u0011\u0005\u00111V\u0001$i\u0016\u001cHOS8j]\u001e\u0013x.\u001e9TKN\u001c\u0018n\u001c8US6,w.\u001e;U_>d\u0015M]4fQ\u0011\t9.a3\t\u000f\u0005}\u0007\u0001\"\u0001\u0002,\u0006!C/Z:u\u0015>Lgn\u0012:pkB,fn\u001b8po:\u001cuN\\:v[\u0016\u0014h*Z<He>,\b\u000f\u000b\u0003\u0002^\u0006-\u0007bBAs\u0001\u0011\u0005\u00111V\u0001\u0013i\u0016\u001cH/\u00138wC2LGm\u0012:pkBLE\r\u000b\u0003\u0002d\u0006-\u0007bBAv\u0001\u0011\u0005\u00111V\u0001\u0013i\u0016\u001cHOV1mS\u0012Tu.\u001b8He>,\b\u000f\u000b\u0003\u0002j\u0006-\u0007bBAy\u0001\u0011\u0005\u00111V\u0001&i\u0016\u001cHOS8j]\u001e\u0013x.\u001e9J]\u000e|gn]5ti\u0016tG\u000f\u0015:pi>\u001cw\u000e\u001c+za\u0016DC!a<\u0002L\"9\u0011q\u001f\u0001\u0005\u0002\u0005-\u0016A\n;fgRTu.\u001b8He>,\b/\u00138d_:\u001c\u0018n\u001d;f]R<%o\\;q!J|Go\\2pY\"\"\u0011Q_Af\u0011\u001d\ti\u0010\u0001C\u0001\u0003W\u000b\u0011\u0006^3ti*{\u0017N\\$s_V\u0004XK\\6o_^t7i\u001c8tk6,'/\u0012=jgRLgnZ$s_V\u0004\b\u0006BA~\u0003\u0017DqAa\u0001\u0001\t\u0003\tY+A\u000fuKN$\b*Z1si\n,\u0017\r^,s_:<7i\\8sI&t\u0017\r^8sQ\u0011\u0011\t!a3\t\u000f\t%\u0001\u0001\"\u0001\u0002,\u0006IB/Z:u\u0011\u0016\f'\u000f\u001e2fCR,fn\u001b8po:<%o\\;qQ\u0011\u00119!a3\t\u000f\t=\u0001\u0001\"\u0001\u0002,\u0006IC/Z:u\u0011\u0016\f'\u000f\u001e2fCR,fn\u001b8po:\u001cuN\\:v[\u0016\u0014X\t_5ti&twm\u0012:pkBDCA!\u0004\u0002L\"9!Q\u0003\u0001\u0005\u0002\u0005-\u0016\u0001\t;fgRDU-\u0019:uE\u0016\fGOU3cC2\fgnY3J]B\u0013xn\u001a:fgNDCAa\u0005\u0002L\"9!1\u0004\u0001\u0005\u0002\u0005-\u0016A\b;fgRDU-\u0019:uE\u0016\fG/\u00137mK\u001e\fGnR3oKJ\fG/[8oQ\u0011\u0011I\"a3\t\u000f\t\u0005\u0002\u0001\"\u0001\u0002,\u0006\u0011B/Z:u-\u0006d\u0017\u000e\u001a%fCJ$(-Z1uQ\u0011\u0011y\"a3\t\u000f\t\u001d\u0002\u0001\"\u0001\u0002,\u0006aB/Z:u'ft7m\u0012:pkB,U\u000e\u001d;z\u0003N\u001c\u0018n\u001a8nK:$\b\u0006\u0002B\u0013\u0003\u0017DqA!\f\u0001\t\u0003\tY+A\u000euKN$8+\u001f8d\u000fJ|W\u000f\u001d(pi\u000e{wN\u001d3j]\u0006$xN\u001d\u0015\u0005\u0005W\tY\rC\u0004\u00034\u0001!\t!a+\u0002;Q,7\u000f^*z]\u000e<%o\\;q\rJ|W.\u00168l]><hn\u0012:pkBDCA!\r\u0002L\"9!\u0011\b\u0001\u0005\u0002\u0005-\u0016A\b;fgR\u001c\u0016P\\2He>,\bO\u0012:p[Vs7N\\8x]6+WNY3sQ\u0011\u00119$a3\t\u000f\t}\u0002\u0001\"\u0001\u0002,\u0006\u0011C/Z:u'ft7m\u0012:pkB4%o\\7JY2,w-\u00197HK:,'/\u0019;j_:DCA!\u0010\u0002L\"9!Q\t\u0001\u0005\u0002\u0005-\u0016A\r;fgRTu.\u001b8He>,\bO\u0012:p[Vs7\r[1oO\u0016$gi\u001c7m_^,'\u000fR8fg:{GOU3cC2\fgnY3)\t\t\r\u00131\u001a\u0005\b\u0005\u0017\u0002A\u0011AAV\u0003=\"Xm\u001d;K_&twI]8va\u001a\u0013x.\\+oG\"\fgnZ3e\u0019\u0016\fG-\u001a:TQ>,H\u000e\u001a*fE\u0006d\u0017M\\2fQ\u0011\u0011I%a3\t\u000f\tE\u0003\u0001\"\u0001\u0002,\u0006aB/Z:u\u0019\u0016\fG-\u001a:GC&dWO]3J]NKhnY$s_V\u0004\b\u0006\u0002B(\u0003\u0017DqAa\u0016\u0001\t\u0003\tY+\u0001\u0011uKN$8+\u001f8d\u000fJ|W\u000f\u001d$pY2|w/\u001a:BMR,'\u000fT3bI\u0016\u0014\b\u0006\u0002B+\u0003\u0017DqA!\u0018\u0001\t\u0003\tY+\u0001\u0011uKN$8+\u001f8d\u000fJ|W\u000f\u001d'fC\u0012,'/\u00114uKJ4u\u000e\u001c7po\u0016\u0014\b\u0006\u0002B.\u0003\u0017DqAa\u0019\u0001\t\u0003\tY+\u0001\u0011uKN$8i\\7nSR|eMZ:fi\u001a\u0013x.\\+oW:|wO\\$s_V\u0004\b\u0006\u0002B1\u0003\u0017DqA!\u001b\u0001\t\u0003\tY+A\u0013uKN$8i\\7nSR|eMZ:fi^KG\u000f\u001b#fM\u0006,H\u000e^$f]\u0016\u0014\u0018\r^5p]\"\"!qMAf\u0011\u001d\u0011y\u0007\u0001C\u0001\u0003W\u000ba\u0004^3ti\u000e{W.\\5u\u001f\u001a47/\u001a;J]\u0006;\u0018-\u001b;j]\u001e\u001c\u0016P\\2)\t\t5\u00141\u001a\u0005\b\u0005k\u0002A\u0011AAV\u0003U\"Xm\u001d;IK\u0006\u0014HOY3bi\u0012+(/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016\u001c\u0015-^:fgJ+'-\u00197b]\u000e,\u0017J\u001c)s_\u001e\u0014Xm]:)\t\tM\u00141\u001a\u0005\b\u0005w\u0002A\u0011AAV\u0003\u0015\"Xm\u001d;HK:,'/\u0019;j_:LE-\u00138de\u0016lWM\u001c;t\u001f:\u0014VMY1mC:\u001cW\r\u000b\u0003\u0003z\u0005-\u0007b\u0002BA\u0001\u0011\u0005\u00111V\u0001\u001fi\u0016\u001cH\u000fT3bm\u0016<%o\\;q/J|gnZ\"p_J$\u0017N\\1u_JDCAa \u0002L\"9!q\u0011\u0001\u0005\u0002\u0005-\u0016A\u0007;fgRdU-\u0019<f\u000fJ|W\u000f]+oW:|wO\\$s_V\u0004\b\u0006\u0002BC\u0003\u0017DqA!$\u0001\t\u0003\tY+\u0001\u0016uKN$H*Z1wK\u001e\u0013x.\u001e9V].twn\u001e8D_:\u001cX/\\3s\u000bbL7\u000f^5oO\u001e\u0013x.\u001e9)\t\t-\u00151\u001a\u0005\b\u0005'\u0003A\u0011AAV\u0003M!Xm\u001d;WC2LG\rT3bm\u0016<%o\\;qQ\u0011\u0011\t*a3\t\u000f\te\u0005\u0001\"\u0001\u0002,\u0006\u0011C/Z:u\u0019&\u001cHo\u0012:pkB\u001c\u0018J\\2mk\u0012,7o\u0015;bE2,wI]8vaNDCAa&\u0002L\"9!q\u0014\u0001\u0005\u0002\u0005-\u0016a\n;fgRd\u0015n\u001d;He>,\bo]%oG2,H-Z:SK\n\fG.\u00198dS:<wI]8vaNDCA!(\u0002L\"9!Q\u0015\u0001\u0005\u0002\u0005-\u0016!\t;fgR$Um]2sS\n,wI]8va^\u0013xN\\4D_>\u0014H-\u001b8bi>\u0014\b\u0006\u0002BR\u0003\u0017DqAa+\u0001\t\u0003\tY+\u0001\u0010uKN$H)Z:de&\u0014Wm\u0012:pkBLe.Y2uSZ,wI]8va\"\"!\u0011VAf\u0011\u001d\u0011\t\f\u0001C\u0001\u0003W\u000bq\u0003^3ti\u0012+7o\u0019:jE\u0016<%o\\;q'R\f'\r\\3)\t\t=\u00161\u001a\u0005\b\u0005o\u0003A\u0011AAV\u0003q!Xm\u001d;EKN\u001c'/\u001b2f\u000fJ|W\u000f\u001d*fE\u0006d\u0017M\\2j]\u001eDCA!.\u0002L\"9!Q\u0018\u0001\u0005\n\t}\u0016AF:fiV\u0004(j\\5o\u000fJ|W\u000f]\"bY2\u0014\u0017mY6\u0016\u0005\t\u0005\u0007C\u0002\u000e)\u0005\u0007\u0014y\rE\u0003\u0003F\n-w$\u0004\u0002\u0003H*\u0019!\u0011Z\u000e\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0003N\n\u001d'A\u0002$viV\u0014X\rE\u0002\u0003R^i\u0011\u0001\u0001\u0005\b\u0005+\u0004A\u0011\u0002Bl\u0003Y\u0019X\r^;q'ft7m\u0012:pkB\u001c\u0015\r\u001c7cC\u000e\\WC\u0001Bm!\u0019Q\u0002Fa7\u0003`B1!Q\u0019Bf\u0005;\u00042A!5&!\r\u0011\tn\r\u0005\b\u0005G\u0004A\u0011\u0002Bs\u0003Y\u0019X\r^;q\u0011\u0016\f'\u000f\u001e2fCR\u001c\u0015\r\u001c7cC\u000e\\WC\u0001Bt!\u0019Q\u0002F!;\u0003nB1!Q\u0019Bf\u0005W\u00042A!59!\r\u0011\tN\u000f\u0005\b\u0005c\u0004A\u0011\u0002Bz\u0003i\u0019X\r^;q\u0007>lW.\u001b;PM\u001a\u001cX\r^:DC2d'-Y2l+\t\u0011)\u0010\u0005\u0004\u001bQ\t](1 \t\u0007\u0005\u000b\u0014YM!?\u0011\u0007\tEW\bE\u0002\u0003R.CqAa@\u0001\t\u0013\u0019\t!A\u0007tK:$'j\\5o\u000fJ|W\u000f\u001d\u000b\r\u0005\u0007\u001c\u0019a!\u0005\u0004\u0014\r]1\u0011\u0004\u0005\t\u0003/\u0012i\u00101\u0001\u0004\u0006A!1qAB\u0007\u001d\rQ2\u0011B\u0005\u0004\u0007\u0017Y\u0012A\u0002)sK\u0012,g-C\u0002]\u0007\u001fQ1aa\u0003\u001c\u0011!\t9G!@A\u0002\r\u0015\u0001bBB\u000b\u0005{\u0004\rAZ\u0001\u000fg\u0016\u001c8/[8o)&lWm\\;u\u0011!\tyF!@A\u0002\r\u0015\u0001\u0002CA=\u0005{\u0004\raa\u0007\u0011\r\ru1QFB\u0019\u001d\u0011\u0019yb!\u000b\u000f\t\r\u00052qE\u0007\u0003\u0007GQ1a!\n\u0007\u0003\u0019a$o\\8u}%\tA$C\u0002\u0004,m\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\b\u000e=\"bAB\u00167A)!\u0004KB\u0003U!91Q\u0007\u0001\u0005\n\r]\u0012aE:f]\u0012\u001c\u0016P\\2He>,\b\u000fT3bI\u0016\u0014HC\u0003Bn\u0007s\u0019Yda\u0010\u0004D!A\u0011qKB\u001a\u0001\u0004\u0019)\u0001C\u0004\u0004>\rM\u0002\u0019\u00014\u0002\u0015\u001d,g.\u001a:bi&|g\u000e\u0003\u0005\u0004B\rM\u0002\u0019AB\u0003\u0003!aW-\u00193fe&#\u0007\u0002CB#\u0007g\u0001\raa\u0012\u0002\u0015\u0005\u001c8/[4o[\u0016tG\u000fE\u0003A\u0007\u000e\u0015!\u0006C\u0004\u0004L\u0001!Ia!\u0014\u0002+M,g\u000eZ*z]\u000e<%o\\;q\r>dGn\\<feRA!1\\B(\u0007#\u001a\u0019\u0006\u0003\u0005\u0002X\r%\u0003\u0019AB\u0003\u0011\u001d\u0019id!\u0013A\u0002\u0019D\u0001\"a\u001a\u0004J\u0001\u00071Q\u0001\u0005\b\u0007/\u0002A\u0011BB-\u0003%Qw.\u001b8He>,\b\u000fF\u0006 \u00077\u001aifa\u0018\u0004b\r\r\u0004\u0002CA,\u0007+\u0002\ra!\u0002\t\u0011\u0005\u001d4Q\u000ba\u0001\u0007\u000bAqa!\u0006\u0004V\u0001\u0007a\r\u0003\u0005\u0002`\rU\u0003\u0019AB\u0003\u0011!\tIh!\u0016A\u0002\rm\u0001bBB4\u0001\u0011%1\u0011N\u0001\u0012gft7m\u0012:pkB4u\u000e\u001c7po\u0016\u0014H\u0003\u0003Bo\u0007W\u001aig!\u001d\t\u0011\u0005]3Q\ra\u0001\u0007\u000bAqaa\u001c\u0004f\u0001\u0007a-\u0001\u0007hK:,'/\u0019;j_:LE\r\u0003\u0005\u0002h\r\u0015\u0004\u0019AB\u0003\u0011\u001d\u0019)\b\u0001C\u0005\u0007o\nqb]=oG\u001e\u0013x.\u001e9MK\u0006$WM\u001d\u000b\u000b\u0005;\u001cIha\u001f\u0004~\r}\u0004\u0002CA,\u0007g\u0002\ra!\u0002\t\u000f\r=41\u000fa\u0001M\"A\u0011qMB:\u0001\u0004\u0019)\u0001\u0003\u0005\u0004F\rM\u0004\u0019AB$\u0011\u001d\u0019\u0019\t\u0001C\u0005\u0007\u000b\u000b\u0011\u0002[3beR\u0014W-\u0019;\u0015\u0011\t-8qQBE\u0007\u001bC\u0001\"a\u0016\u0004\u0002\u0002\u00071Q\u0001\u0005\t\u0007\u0017\u001b\t\t1\u0001\u0004\u0006\u0005Q1m\u001c8tk6,'/\u00133\t\u000f\r=4\u0011\u0011a\u0001M\"91\u0011\u0013\u0001\u0005\n\rM\u0015!B1xC&$X\u0003BBK\u00077#baa&\u0004.\u000eM\u0006\u0003BBM\u00077c\u0001\u0001\u0002\u0005\u0004\u001e\u000e=%\u0019ABP\u0005\u0005!\u0016\u0003BBQ\u0007O\u00032AGBR\u0013\r\u0019)k\u0007\u0002\b\u001d>$\b.\u001b8h!\rQ2\u0011V\u0005\u0004\u0007W[\"aA!os\"A1qVBH\u0001\u0004\u0019\t,\u0001\u0004gkR,(/\u001a\t\u0007\u0005\u000b\u0014Yma&\t\u0011\rU6q\u0012a\u0001\u0007o\u000ba!\\5mY&\u001c\bc\u0001\u000e\u0004:&\u001911X\u000e\u0003\t1{gn\u001a\u0005\b\u0007\u007f\u0003A\u0011BBa\u00035\u0019w.\\7ji>3gm]3ugRQ!\u0011`Bb\u0007\u000b\u001c9m!3\t\u0011\u0005]3Q\u0018a\u0001\u0007\u000bA\u0001ba#\u0004>\u0002\u00071Q\u0001\u0005\b\u0007_\u001ai\f1\u0001g\u0011!\u0019Ym!0A\u0002\r5\u0017aB8gMN,Go\u001d\t\b\u0003\u007f\u001ay-RBi\u0013\r!\u0015\u0011\u0011\t\u0004\r\u000eM\u0017bABk\u000f\n\trJ\u001a4tKR\fe\u000eZ'fi\u0006$\u0017\r^1\t\u000f\re\u0007\u0001\"\u0003\u0004\\\u0006QA.Z1wK\u001e\u0013x.\u001e9\u0015\r\ru7q\\Bq!\r\u0011\tN\u0014\u0005\t\u0003/\u001a9\u000e1\u0001\u0004\u0006!A11RBl\u0001\u0004\u0019)\u0001")
public class GroupCoordinatorResponseTest
extends JUnitSuite {
    private final String ClientId;
    private final String ClientHost;
    private final int ConsumerMinSessionTimeout;
    private final int ConsumerMaxSessionTimeout;
    private final int DefaultSessionTimeout;
    private GroupCoordinator groupCoordinator = null;
    private ReplicaManager replicaManager = null;
    private KafkaScheduler scheduler = null;
    private ZkUtils zkUtils = null;
    private final String groupId;
    private final String protocolType;
    private final String memberId;
    private final byte[] metadata = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
    private final List<Tuple2<String, byte[]>> protocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", (Object)this.metadata())}));
    private int kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId = -1;
    private final String otherGroupId;

    public String ClientId() {
        return this.ClientId;
    }

    public String ClientHost() {
        return this.ClientHost;
    }

    public int ConsumerMinSessionTimeout() {
        return this.ConsumerMinSessionTimeout;
    }

    public int ConsumerMaxSessionTimeout() {
        return this.ConsumerMaxSessionTimeout;
    }

    public int DefaultSessionTimeout() {
        return this.DefaultSessionTimeout;
    }

    public GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    public void groupCoordinator_$eq(GroupCoordinator x$1) {
        this.groupCoordinator = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public KafkaScheduler scheduler() {
        return this.scheduler;
    }

    public void scheduler_$eq(KafkaScheduler x$1) {
        this.scheduler = x$1;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    private String groupId() {
        return this.groupId;
    }

    private String protocolType() {
        return this.protocolType;
    }

    private String memberId() {
        return this.memberId;
    }

    private byte[] metadata() {
        return this.metadata;
    }

    private List<Tuple2<String, byte[]>> protocols() {
        return this.protocols;
    }

    public int kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId() {
        return this.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId;
    }

    private void kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId_$eq(int x$1) {
        this.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId = x$1;
    }

    private String otherGroupId() {
        return this.otherGroupId;
    }

    @Before
    public void setUp() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14());
        props.setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.ConsumerMinSessionTimeout())).toString());
        props.setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.ConsumerMaxSessionTimeout())).toString());
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ret.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)GroupCoordinator$.MODULE$.GroupMetadataTopicName()), (Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})))}))));
        this.replicaManager_$eq((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class));
        this.zkUtils_$eq((ZkUtils)EasyMock.createNiceMock(ZkUtils.class));
        EasyMock.expect((Object)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{GroupCoordinator$.MODULE$.GroupMetadataTopicName()})))).andReturn((Object)ret);
        EasyMock.replay((Object[])new Object[]{this.zkUtils()});
        this.groupCoordinator_$eq(GroupCoordinator$.MODULE$.create(KafkaConfig$.MODULE$.fromProps(props), this.zkUtils(), this.replicaManager()));
        this.groupCoordinator().startup();
        this.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId_$eq(this.groupCoordinator().partitionFor(this.groupId()));
        this.groupCoordinator().groupManager().addPartitionOwnership(this.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId());
    }

    @After
    public void tearDown() {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        this.groupCoordinator().shutdown();
    }

    @Test
    public void testJoinGroupWrongCoordinator() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.otherGroupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NOT_COORDINATOR_FOR_GROUP.code(), (long)joinGroupErrorCode);
    }

    @Test
    public void testJoinGroupSessionTimeoutTooSmall() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.ConsumerMinSessionTimeout() - 1, this.protocolType(), this.protocols());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.INVALID_SESSION_TIMEOUT.code(), (long)joinGroupErrorCode);
    }

    @Test
    public void testJoinGroupSessionTimeoutTooLarge() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.ConsumerMaxSessionTimeout() + 1, this.protocolType(), this.protocols());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.INVALID_SESSION_TIMEOUT.code(), (long)joinGroupErrorCode);
    }

    @Test
    public void testJoinGroupUnknownConsumerNewGroup() {
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), this.memberId(), this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)joinGroupErrorCode);
    }

    @Test
    public void testInvalidGroupId() {
        String groupId = "";
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(groupId, memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        Assert.assertEquals((long)Errors.INVALID_GROUP_ID.code(), (long)joinGroupResult.errorCode());
    }

    @Test
    public void testValidJoinGroup() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
    }

    @Test
    public void testJoinGroupInconsistentProtocolType() {
        String memberId = "";
        String otherMemberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        JoinGroupResult otherJoinGroupResult = this.joinGroup(this.groupId(), otherMemberId, this.DefaultSessionTimeout(), "connect", this.protocols());
        Assert.assertEquals((long)Errors.INCONSISTENT_GROUP_PROTOCOL.code(), (long)otherJoinGroupResult.errorCode());
    }

    @Test
    public void testJoinGroupInconsistentGroupProtocol() {
        String memberId = "";
        String otherMemberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), (List<Tuple2<String, byte[]>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", (Object)this.metadata())})));
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        JoinGroupResult otherJoinGroupResult = this.joinGroup(this.groupId(), otherMemberId, this.DefaultSessionTimeout(), this.protocolType(), (List<Tuple2<String, byte[]>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", (Object)this.metadata())})));
        Assert.assertEquals((long)Errors.INCONSISTENT_GROUP_PROTOCOL.code(), (long)otherJoinGroupResult.errorCode());
    }

    @Test
    public void testJoinGroupUnknownConsumerExistingGroup() {
        String memberId = "";
        String otherMemberId = "memberId";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        JoinGroupResult otherJoinGroupResult = this.joinGroup(this.groupId(), otherMemberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)otherJoinGroupResult.errorCode());
    }

    @Test
    public void testHeartbeatWrongCoordinator() {
        short heartbeatResult = this.heartbeat(this.otherGroupId(), this.memberId(), -1);
        Assert.assertEquals((long)Errors.NOT_COORDINATOR_FOR_GROUP.code(), (long)Short$.MODULE$.short2long(heartbeatResult));
    }

    @Test
    public void testHeartbeatUnknownGroup() {
        short heartbeatResult = this.heartbeat(this.groupId(), this.memberId(), -1);
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)Short$.MODULE$.short2long(heartbeatResult));
    }

    @Test
    public void testHeartbeatUnknownConsumerExistingGroup() {
        String memberId = "";
        String otherMemberId = "memberId";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedMemberId = joinGroupResult.memberId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), joinGroupResult.generationId(), assignedMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)assignedMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short heartbeatResult = this.heartbeat(this.groupId(), otherMemberId, 1);
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)Short$.MODULE$.short2long(heartbeatResult));
    }

    @Test
    public void testHeartbeatRebalanceInProgress() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedMemberId = joinGroupResult.memberId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short heartbeatResult = this.heartbeat(this.groupId(), assignedMemberId, 2);
        Assert.assertEquals((long)Errors.REBALANCE_IN_PROGRESS.code(), (long)Short$.MODULE$.short2long(heartbeatResult));
    }

    @Test
    public void testHeartbeatIllegalGeneration() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedMemberId = joinGroupResult.memberId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), joinGroupResult.generationId(), assignedMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)assignedMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short heartbeatResult = this.heartbeat(this.groupId(), assignedMemberId, 2);
        Assert.assertEquals((long)Errors.ILLEGAL_GENERATION.code(), (long)Short$.MODULE$.short2long(heartbeatResult));
    }

    @Test
    public void testValidHeartbeat() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedConsumerId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), generationId, assignedConsumerId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)assignedConsumerId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short heartbeatResult = this.heartbeat(this.groupId(), assignedConsumerId, 1);
        Assert.assertEquals((long)Errors.NONE.code(), (long)Short$.MODULE$.short2long(heartbeatResult));
    }

    @Test
    public void testSyncGroupEmptyAssignment() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedConsumerId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), generationId, assignedConsumerId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        Assert.assertTrue((boolean)Predef$.MODULE$.byteArrayOps((byte[])syncGroupResult._1()).isEmpty());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short heartbeatResult = this.heartbeat(this.groupId(), assignedConsumerId, 1);
        Assert.assertEquals((long)Errors.NONE.code(), (long)Short$.MODULE$.short2long(heartbeatResult));
    }

    @Test
    public void testSyncGroupNotCoordinator() {
        int generation = 1;
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupFollower(this.otherGroupId(), generation, this.memberId());
        Assert.assertEquals((long)Errors.NOT_COORDINATOR_FOR_GROUP.code(), (long)BoxesRunTime.unboxToShort((Object)syncGroupResult._2()));
    }

    @Test
    public void testSyncGroupFromUnknownGroup() {
        int generation = 1;
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupFollower(this.groupId(), generation, this.memberId());
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)BoxesRunTime.unboxToShort((Object)syncGroupResult._2()));
    }

    @Test
    public void testSyncGroupFromUnknownMember() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedConsumerId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), generationId, assignedConsumerId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)assignedConsumerId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        String unknownMemberId = "blah";
        Tuple2<byte[], Object> unknownMemberSyncResult = this.syncGroupFollower(this.groupId(), generationId, unknownMemberId);
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)BoxesRunTime.unboxToShort((Object)unknownMemberSyncResult._2()));
    }

    @Test
    public void testSyncGroupFromIllegalGeneration() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedConsumerId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), generationId + 1, assignedConsumerId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)assignedConsumerId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        Assert.assertEquals((long)Errors.ILLEGAL_GENERATION.code(), (long)BoxesRunTime.unboxToShort((Object)syncGroupResult._2()));
    }

    @Test
    public void testJoinGroupFromUnchangedFollowerDoesNotRebalance() {
        JoinGroupResult firstJoinResult = this.joinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String firstMemberId = firstJoinResult.memberId();
        int firstGenerationId = firstJoinResult.generationId();
        Assert.assertEquals((Object)firstMemberId, (Object)firstJoinResult.leaderId());
        Assert.assertEquals((long)Errors.NONE.code(), (long)firstJoinResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> firstSyncResult = this.syncGroupLeader(this.groupId(), firstGenerationId, firstMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)firstMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)firstSyncResult._2()));
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> otherJoinFuture = this.sendJoinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> joinFuture = this.sendJoinGroup(this.groupId(), firstMemberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        JoinGroupResult joinResult = this.await(joinFuture, this.DefaultSessionTimeout() + 100);
        JoinGroupResult otherJoinResult = this.await(otherJoinFuture, this.DefaultSessionTimeout() + 100);
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinResult.errorCode());
        Assert.assertEquals((long)Errors.NONE.code(), (long)otherJoinResult.errorCode());
        Assert.assertTrue((joinResult.generationId() == otherJoinResult.generationId() ? 1 : 0) != 0);
        Assert.assertEquals((Object)firstMemberId, (Object)joinResult.leaderId());
        Assert.assertEquals((Object)firstMemberId, (Object)otherJoinResult.leaderId());
        int nextGenerationId = joinResult.generationId();
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        JoinGroupResult followerJoinResult = this.joinGroup(this.groupId(), otherJoinResult.memberId(), this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        Assert.assertEquals((long)Errors.NONE.code(), (long)followerJoinResult.errorCode());
        Assert.assertEquals((long)nextGenerationId, (long)followerJoinResult.generationId());
    }

    @Test
    public void testJoinGroupFromUnchangedLeaderShouldRebalance() {
        JoinGroupResult firstJoinResult = this.joinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String firstMemberId = firstJoinResult.memberId();
        int firstGenerationId = firstJoinResult.generationId();
        Assert.assertEquals((Object)firstMemberId, (Object)firstJoinResult.leaderId());
        Assert.assertEquals((long)Errors.NONE.code(), (long)firstJoinResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> firstSyncResult = this.syncGroupLeader(this.groupId(), firstGenerationId, firstMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)firstMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)firstSyncResult._2()));
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        JoinGroupResult secondJoinResult = this.joinGroup(this.groupId(), firstMemberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        Assert.assertEquals((long)Errors.NONE.code(), (long)secondJoinResult.errorCode());
        Assert.assertNotEquals((long)firstGenerationId, (long)secondJoinResult.generationId());
    }

    @Test
    public void testLeaderFailureInSyncGroup() {
        JoinGroupResult firstJoinResult = this.joinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String firstMemberId = firstJoinResult.memberId();
        int firstGenerationId = firstJoinResult.generationId();
        Assert.assertEquals((Object)firstMemberId, (Object)firstJoinResult.leaderId());
        Assert.assertEquals((long)Errors.NONE.code(), (long)firstJoinResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> firstSyncResult = this.syncGroupLeader(this.groupId(), firstGenerationId, firstMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)firstMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)firstSyncResult._2()));
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> otherJoinFuture = this.sendJoinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> joinFuture = this.sendJoinGroup(this.groupId(), firstMemberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        JoinGroupResult joinResult = this.await(joinFuture, this.DefaultSessionTimeout() + 100);
        JoinGroupResult otherJoinResult = this.await(otherJoinFuture, this.DefaultSessionTimeout() + 100);
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinResult.errorCode());
        Assert.assertEquals((long)Errors.NONE.code(), (long)otherJoinResult.errorCode());
        Assert.assertTrue((joinResult.generationId() == otherJoinResult.generationId() ? 1 : 0) != 0);
        Assert.assertEquals((Object)firstMemberId, (Object)joinResult.leaderId());
        Assert.assertEquals((Object)firstMemberId, (Object)otherJoinResult.leaderId());
        int nextGenerationId = joinResult.generationId();
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<Tuple2<byte[], Object>> followerSyncFuture = this.sendSyncGroupFollower(this.groupId(), nextGenerationId, otherJoinResult.memberId());
        Tuple2<byte[], Object> followerSyncResult = this.await(followerSyncFuture, this.DefaultSessionTimeout() + 100);
        Assert.assertEquals((long)Errors.REBALANCE_IN_PROGRESS.code(), (long)BoxesRunTime.unboxToShort((Object)followerSyncResult._2()));
    }

    @Test
    public void testSyncGroupFollowerAfterLeader() {
        JoinGroupResult firstJoinResult = this.joinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String firstMemberId = firstJoinResult.memberId();
        int firstGenerationId = firstJoinResult.generationId();
        Assert.assertEquals((Object)firstMemberId, (Object)firstJoinResult.leaderId());
        Assert.assertEquals((long)Errors.NONE.code(), (long)firstJoinResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> firstSyncResult = this.syncGroupLeader(this.groupId(), firstGenerationId, firstMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)firstMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)firstSyncResult._2()));
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> otherJoinFuture = this.sendJoinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> joinFuture = this.sendJoinGroup(this.groupId(), firstMemberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        JoinGroupResult joinResult = this.await(joinFuture, this.DefaultSessionTimeout() + 100);
        JoinGroupResult otherJoinResult = this.await(otherJoinFuture, this.DefaultSessionTimeout() + 100);
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinResult.errorCode());
        Assert.assertEquals((long)Errors.NONE.code(), (long)otherJoinResult.errorCode());
        Assert.assertTrue((joinResult.generationId() == otherJoinResult.generationId() ? 1 : 0) != 0);
        Assert.assertEquals((Object)firstMemberId, (Object)joinResult.leaderId());
        Assert.assertEquals((Object)firstMemberId, (Object)otherJoinResult.leaderId());
        int nextGenerationId = joinResult.generationId();
        String leaderId = firstMemberId;
        byte[] leaderAssignment = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte());
        String followerId = otherJoinResult.memberId();
        byte[] followerAssignment = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> leaderSyncResult = this.syncGroupLeader(this.groupId(), nextGenerationId, leaderId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)leaderId), (Object)leaderAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)followerId), (Object)followerAssignment)}))));
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)leaderSyncResult._2()));
        Assert.assertEquals((Object)leaderAssignment, (Object)leaderSyncResult._1());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> followerSyncResult = this.syncGroupFollower(this.groupId(), nextGenerationId, otherJoinResult.memberId());
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)followerSyncResult._2()));
        Assert.assertEquals((Object)followerAssignment, (Object)followerSyncResult._1());
    }

    @Test
    public void testSyncGroupLeaderAfterFollower() {
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String firstMemberId = joinGroupResult.memberId();
        int firstGenerationId = joinGroupResult.generationId();
        Assert.assertEquals((Object)firstMemberId, (Object)joinGroupResult.leaderId());
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), firstGenerationId, firstMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)firstMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> otherJoinFuture = this.sendJoinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> joinFuture = this.sendJoinGroup(this.groupId(), firstMemberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        JoinGroupResult joinResult = this.await(joinFuture, this.DefaultSessionTimeout() + 100);
        JoinGroupResult otherJoinResult = this.await(otherJoinFuture, this.DefaultSessionTimeout() + 100);
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinResult.errorCode());
        Assert.assertEquals((long)Errors.NONE.code(), (long)otherJoinResult.errorCode());
        Assert.assertTrue((joinResult.generationId() == otherJoinResult.generationId() ? 1 : 0) != 0);
        int nextGenerationId = joinResult.generationId();
        String leaderId = joinResult.leaderId();
        byte[] leaderAssignment = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte());
        String followerId = otherJoinResult.memberId();
        byte[] followerAssignment = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte());
        Assert.assertEquals((Object)firstMemberId, (Object)joinResult.leaderId());
        Assert.assertEquals((Object)firstMemberId, (Object)otherJoinResult.leaderId());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<Tuple2<byte[], Object>> followerSyncFuture = this.sendSyncGroupFollower(this.groupId(), nextGenerationId, followerId);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> leaderSyncResult = this.syncGroupLeader(this.groupId(), nextGenerationId, leaderId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)leaderId), (Object)leaderAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)followerId), (Object)followerAssignment)}))));
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)leaderSyncResult._2()));
        Assert.assertEquals((Object)leaderAssignment, (Object)leaderSyncResult._1());
        Tuple2<byte[], Object> followerSyncResult = this.await(followerSyncFuture, this.DefaultSessionTimeout() + 100);
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)followerSyncResult._2()));
        Assert.assertEquals((Object)followerAssignment, (Object)followerSyncResult._1());
    }

    @Test
    public void testCommitOffsetFromUnknownGroup() {
        int generationId = 1;
        TopicAndPartition tp = new TopicAndPartition("topic", 0);
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(0L);
        Map<TopicAndPartition, Object> commitOffsetResult = this.commitOffsets(this.groupId(), this.memberId(), generationId, (scala.collection.immutable.Map<TopicAndPartition, OffsetAndMetadata>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)tp), (Object)offset)}))));
        Assert.assertEquals((long)Errors.ILLEGAL_GENERATION.code(), (long)BoxesRunTime.unboxToShort((Object)commitOffsetResult.apply((Object)tp)));
    }

    @Test
    public void testCommitOffsetWithDefaultGeneration() {
        TopicAndPartition tp = new TopicAndPartition("topic", 0);
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(0L);
        Map<TopicAndPartition, Object> commitOffsetResult = this.commitOffsets(this.groupId(), "", -1, (scala.collection.immutable.Map<TopicAndPartition, OffsetAndMetadata>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)tp), (Object)offset)}))));
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)commitOffsetResult.apply((Object)tp)));
    }

    @Test
    public void testCommitOffsetInAwaitingSync() {
        String memberId = "";
        TopicAndPartition tp = new TopicAndPartition("topic", 0);
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(0L);
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedMemberId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Map<TopicAndPartition, Object> commitOffsetResult = this.commitOffsets(this.groupId(), assignedMemberId, generationId, (scala.collection.immutable.Map<TopicAndPartition, OffsetAndMetadata>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)tp), (Object)offset)}))));
        Assert.assertEquals((long)Errors.REBALANCE_IN_PROGRESS.code(), (long)BoxesRunTime.unboxToShort((Object)commitOffsetResult.apply((Object)tp)));
    }

    @Test
    public void testHeartbeatDuringRebalanceCausesRebalanceInProgress() {
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedConsumerId = joinGroupResult.memberId();
        int initialGenerationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        this.sendJoinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short heartbeatResult = this.heartbeat(this.groupId(), assignedConsumerId, initialGenerationId);
        Assert.assertEquals((long)Errors.REBALANCE_IN_PROGRESS.code(), (long)Short$.MODULE$.short2long(heartbeatResult));
    }

    @Test
    public void testGenerationIdIncrementsOnRebalance() {
        String memberId = "";
        String otherMemberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        int initialGenerationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)1L, (long)initialGenerationId);
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        JoinGroupResult otherJoinGroupResult = this.joinGroup(this.groupId(), otherMemberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        int nextGenerationId = otherJoinGroupResult.generationId();
        short otherJoinGroupErrorCode = otherJoinGroupResult.errorCode();
        Assert.assertEquals((long)2L, (long)nextGenerationId);
        Assert.assertEquals((long)Errors.NONE.code(), (long)otherJoinGroupErrorCode);
    }

    @Test
    public void testLeaveGroupWrongCoordinator() {
        String memberId = "";
        short leaveGroupResult = this.leaveGroup(this.otherGroupId(), memberId);
        Assert.assertEquals((long)Errors.NOT_COORDINATOR_FOR_GROUP.code(), (long)Short$.MODULE$.short2long(leaveGroupResult));
    }

    @Test
    public void testLeaveGroupUnknownGroup() {
        short leaveGroupResult = this.leaveGroup(this.groupId(), this.memberId());
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)Short$.MODULE$.short2long(leaveGroupResult));
    }

    @Test
    public void testLeaveGroupUnknownConsumerExistingGroup() {
        String memberId = "";
        String otherMemberId = "consumerId";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short leaveGroupResult = this.leaveGroup(this.groupId(), otherMemberId);
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)Short$.MODULE$.short2long(leaveGroupResult));
    }

    @Test
    public void testValidLeaveGroup() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedMemberId = joinGroupResult.memberId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short leaveGroupResult = this.leaveGroup(this.groupId(), assignedMemberId);
        Assert.assertEquals((long)Errors.NONE.code(), (long)Short$.MODULE$.short2long(leaveGroupResult));
    }

    @Test
    public void testListGroupsIncludesStableGroups() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedMemberId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), generationId, assignedMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)assignedMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        Tuple2 tuple2 = this.groupCoordinator().handleListGroups();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Errors error = (Errors)tuple2._1();
            List groups = (List)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)error, (Object)groups);
            Errors error2 = (Errors)tuple23._1();
            List groups2 = (List)tuple23._2();
            Assert.assertEquals((Object)Errors.NONE, (Object)error2);
            Assert.assertEquals((long)1L, (long)groups2.size());
            Assert.assertEquals((Object)new GroupOverview("groupId", "consumer"), (Object)groups2.apply(0));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testListGroupsIncludesRebalancingGroups() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        Tuple2 tuple2 = this.groupCoordinator().handleListGroups();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Errors error = (Errors)tuple2._1();
            List groups = (List)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)error, (Object)groups);
            Errors error2 = (Errors)tuple23._1();
            List groups2 = (List)tuple23._2();
            Assert.assertEquals((Object)Errors.NONE, (Object)error2);
            Assert.assertEquals((long)1L, (long)groups2.size());
            Assert.assertEquals((Object)new GroupOverview("groupId", "consumer"), (Object)groups2.apply(0));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testDescribeGroupWrongCoordinator() {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2 tuple2 = this.groupCoordinator().handleDescribeGroup(this.otherGroupId());
        if (tuple2 != null) {
            Errors error;
            Errors errors;
            Errors error2 = errors = (error = (Errors)tuple2._1());
            Assert.assertEquals((Object)Errors.NOT_COORDINATOR_FOR_GROUP, (Object)error2);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testDescribeGroupInactiveGroup() {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2 tuple2 = this.groupCoordinator().handleDescribeGroup(this.groupId());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Errors error = (Errors)tuple2._1();
            GroupSummary summary = (GroupSummary)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)error, (Object)summary);
            Errors error2 = (Errors)tuple23._1();
            GroupSummary summary2 = (GroupSummary)tuple23._2();
            Assert.assertEquals((Object)Errors.NONE, (Object)error2);
            Assert.assertEquals((Object)GroupCoordinator$.MODULE$.DeadGroup(), (Object)summary2);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testDescribeGroupStable() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedMemberId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), generationId, assignedMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)assignedMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2 tuple2 = this.groupCoordinator().handleDescribeGroup(this.groupId());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Errors error = (Errors)tuple2._1();
            GroupSummary summary = (GroupSummary)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)error, (Object)summary);
            Errors error2 = (Errors)tuple23._1();
            GroupSummary summary2 = (GroupSummary)tuple23._2();
            Assert.assertEquals((Object)Errors.NONE, (Object)error2);
            Assert.assertEquals((Object)this.protocolType(), (Object)summary2.protocolType());
            Assert.assertEquals((Object)"range", (Object)summary2.protocol());
            Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{assignedMemberId})), (Object)summary2.members().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(MemberSummary x$5) {
                    return x$5.memberId();
                }
            }, List$.MODULE$.canBuildFrom()));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testDescribeGroupRebalancing() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2 tuple2 = this.groupCoordinator().handleDescribeGroup(this.groupId());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Errors error = (Errors)tuple2._1();
            GroupSummary summary = (GroupSummary)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)error, (Object)summary);
            Errors error2 = (Errors)tuple23._1();
            GroupSummary summary2 = (GroupSummary)tuple23._2();
            Assert.assertEquals((Object)Errors.NONE, (Object)error2);
            Assert.assertEquals((Object)this.protocolType(), (Object)summary2.protocolType());
            Assert.assertEquals((Object)GroupCoordinator$.MODULE$.NoProtocol(), (Object)summary2.protocol());
            Assert.assertEquals((Object)AwaitingSync$.MODULE$.toString(), (Object)summary2.state());
            Assert.assertTrue((boolean)((LinearSeqOptimized)summary2.members().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(MemberSummary x$7) {
                    return x$7.memberId();
                }
            }, List$.MODULE$.canBuildFrom())).contains((Object)joinGroupResult.memberId()));
            Assert.assertTrue((boolean)summary2.members().forall((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(MemberSummary x$8) {
                    return Predef$.MODULE$.byteArrayOps(x$8.metadata()).isEmpty();
                }
            }));
            Assert.assertTrue((boolean)summary2.members().forall((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(MemberSummary x$9) {
                    return Predef$.MODULE$.byteArrayOps(x$9.assignment()).isEmpty();
                }
            }));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private Tuple2<Future<JoinGroupResult>, Function1<JoinGroupResult, BoxedUnit>> setupJoinGroupCallback() {
        Promise responsePromise = Promise$.MODULE$.apply();
        Future responseFuture = responsePromise.future();
        Serializable responseCallback = new Serializable(this, responsePromise){
            public static final long serialVersionUID = 0L;
            private final Promise responsePromise$1;

            public final void apply(JoinGroupResult x$10) {
                this.responsePromise$1.success((Object)x$10);
            }
            {
                this.responsePromise$1 = responsePromise$1;
            }
        };
        return new Tuple2((Object)responseFuture, (Object)responseCallback);
    }

    private Tuple2<Future<Tuple2<byte[], Object>>, Function2<byte[], Object, BoxedUnit>> setupSyncGroupCallback() {
        Promise responsePromise = Promise$.MODULE$.apply();
        Future responseFuture = responsePromise.future();
        Serializable responseCallback = new Serializable(this, responsePromise){
            public static final long serialVersionUID = 0L;
            private final Promise responsePromise$2;

            public final void apply(byte[] assignment, short errorCode) {
                this.responsePromise$2.success((Object)new Tuple2((Object)assignment, (Object)BoxesRunTime.boxToShort((short)errorCode)));
            }
            {
                this.responsePromise$2 = responsePromise$2;
            }
        };
        return new Tuple2((Object)responseFuture, (Object)responseCallback);
    }

    private Tuple2<Future<Object>, Function1<Object, BoxedUnit>> setupHeartbeatCallback() {
        Promise responsePromise = Promise$.MODULE$.apply();
        Future responseFuture = responsePromise.future();
        Serializable responseCallback = new Serializable(this, responsePromise){
            public static final long serialVersionUID = 0L;
            private final Promise responsePromise$3;

            public final void apply(short errorCode) {
                this.responsePromise$3.success((Object)BoxesRunTime.boxToShort((short)errorCode));
            }
            {
                this.responsePromise$3 = responsePromise$3;
            }
        };
        return new Tuple2((Object)responseFuture, (Object)responseCallback);
    }

    private Tuple2<Future<Map<TopicAndPartition, Object>>, Function1<Map<TopicAndPartition, Object>, BoxedUnit>> setupCommitOffsetsCallback() {
        Promise responsePromise = Promise$.MODULE$.apply();
        Future responseFuture = responsePromise.future();
        Serializable responseCallback = new Serializable(this, responsePromise){
            public static final long serialVersionUID = 0L;
            private final Promise responsePromise$4;

            public final void apply(Map<TopicAndPartition, Object> offsets) {
                this.responsePromise$4.success(offsets);
            }
            {
                this.responsePromise$4 = responsePromise$4;
            }
        };
        return new Tuple2((Object)responseFuture, (Object)responseCallback);
    }

    private Future<JoinGroupResult> sendJoinGroup(String groupId, String memberId, int sessionTimeout, String protocolType, List<Tuple2<String, byte[]>> protocols) {
        Tuple2<Future<JoinGroupResult>, Function1<JoinGroupResult, BoxedUnit>> tuple2 = this.setupJoinGroupCallback();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Future responseFuture = (Future)tuple2._1();
            Function1 responseCallback = (Function1)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)responseFuture, (Object)responseCallback);
            Future responseFuture2 = (Future)tuple23._1();
            Function1 responseCallback2 = (Function1)tuple23._2();
            EasyMock.replay((Object[])new Object[]{this.replicaManager()});
            this.groupCoordinator().handleJoinGroup(groupId, memberId, "clientId", "clientHost", sessionTimeout, protocolType, protocols, responseCallback2);
            return responseFuture2;
        }
        throw new MatchError(tuple2);
    }

    private Future<Tuple2<byte[], Object>> sendSyncGroupLeader(String groupId, int generation, String leaderId, Map<String, byte[]> assignment) {
        Tuple2<Future<Tuple2<byte[], Object>>, Function2<byte[], Object, BoxedUnit>> tuple2 = this.setupSyncGroupCallback();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Future responseFuture = (Future)tuple2._1();
            Function2 responseCallback = (Function2)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)responseFuture, (Object)responseCallback);
            Future responseFuture2 = (Future)tuple23._1();
            Function2 responseCallback2 = (Function2)tuple23._2();
            Capture capturedArgument = EasyMock.newCapture();
            this.replicaManager().appendMessages(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.anyBoolean(), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument));
            EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, capturedArgument){
                private final /* synthetic */ GroupCoordinatorResponseTest $outer;
                private final Capture capturedArgument$1;

                public void answer() {
                    ((Function1)this.capturedArgument$1.getValue()).apply((Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(GroupCoordinator$.MODULE$.GroupMetadataTopicName(), this.$outer.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId())), (Object)new ProducerResponseStatus(Errors.NONE.code(), 0L))})));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.capturedArgument$1 = capturedArgument$1;
                }
            });
            EasyMock.replay((Object[])new Object[]{this.replicaManager()});
            this.groupCoordinator().handleSyncGroup(groupId, generation, leaderId, assignment, responseCallback2);
            return responseFuture2;
        }
        throw new MatchError(tuple2);
    }

    private Future<Tuple2<byte[], Object>> sendSyncGroupFollower(String groupId, int generation, String memberId) {
        Tuple2<Future<Tuple2<byte[], Object>>, Function2<byte[], Object, BoxedUnit>> tuple2 = this.setupSyncGroupCallback();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Future responseFuture = (Future)tuple2._1();
            Function2 responseCallback = (Function2)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)responseFuture, (Object)responseCallback);
            Future responseFuture2 = (Future)tuple23._1();
            Function2 responseCallback2 = (Function2)tuple23._2();
            EasyMock.replay((Object[])new Object[]{this.replicaManager()});
            this.groupCoordinator().handleSyncGroup(groupId, generation, memberId, (Map)scala.collection.Map$.MODULE$.empty(), responseCallback2);
            return responseFuture2;
        }
        throw new MatchError(tuple2);
    }

    private JoinGroupResult joinGroup(String groupId, String memberId, int sessionTimeout, String protocolType, List<Tuple2<String, byte[]>> protocols) {
        Future<JoinGroupResult> responseFuture = this.sendJoinGroup(groupId, memberId, sessionTimeout, protocolType, protocols);
        return (JoinGroupResult)Await$.MODULE$.result(responseFuture, (Duration)Duration$.MODULE$.apply((long)(sessionTimeout + 100), TimeUnit.MILLISECONDS));
    }

    private Tuple2<byte[], Object> syncGroupFollower(String groupId, int generationId, String memberId) {
        Future<Tuple2<byte[], Object>> responseFuture = this.sendSyncGroupFollower(groupId, generationId, memberId);
        return (Tuple2)Await$.MODULE$.result(responseFuture, (Duration)Duration$.MODULE$.apply((long)(this.DefaultSessionTimeout() + 100), TimeUnit.MILLISECONDS));
    }

    private Tuple2<byte[], Object> syncGroupLeader(String groupId, int generationId, String memberId, Map<String, byte[]> assignment) {
        Future<Tuple2<byte[], Object>> responseFuture = this.sendSyncGroupLeader(groupId, generationId, memberId, assignment);
        return (Tuple2)Await$.MODULE$.result(responseFuture, (Duration)Duration$.MODULE$.apply((long)(this.DefaultSessionTimeout() + 100), TimeUnit.MILLISECONDS));
    }

    private short heartbeat(String groupId, String consumerId, int generationId) {
        Tuple2<Future<Object>, Function1<Object, BoxedUnit>> tuple2 = this.setupHeartbeatCallback();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Future responseFuture = (Future)tuple2._1();
            Function1 responseCallback = (Function1)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)responseFuture, (Object)responseCallback);
            Future responseFuture2 = (Future)tuple23._1();
            Function1 responseCallback2 = (Function1)tuple23._2();
            EasyMock.replay((Object[])new Object[]{this.replicaManager()});
            this.groupCoordinator().handleHeartbeat(groupId, consumerId, generationId, responseCallback2);
            return BoxesRunTime.unboxToShort((Object)Await$.MODULE$.result((Awaitable)responseFuture2, (Duration)Duration$.MODULE$.apply(40L, TimeUnit.MILLISECONDS)));
        }
        throw new MatchError(tuple2);
    }

    private <T> T await(Future<T> future, long millis) {
        return (T)Await$.MODULE$.result(future, (Duration)Duration$.MODULE$.apply(millis, TimeUnit.MILLISECONDS));
    }

    private Map<TopicAndPartition, Object> commitOffsets(String groupId, String consumerId, int generationId, scala.collection.immutable.Map<TopicAndPartition, OffsetAndMetadata> offsets) {
        Tuple2<Future<Map<TopicAndPartition, Object>>, Function1<Map<TopicAndPartition, Object>, BoxedUnit>> tuple2 = this.setupCommitOffsetsCallback();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Future responseFuture = (Future)tuple2._1();
            Function1 responseCallback = (Function1)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)responseFuture, (Object)responseCallback);
            Future responseFuture2 = (Future)tuple23._1();
            Function1 responseCallback2 = (Function1)tuple23._2();
            Capture capturedArgument = EasyMock.newCapture();
            this.replicaManager().appendMessages(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.anyBoolean(), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument));
            EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, capturedArgument){
                private final /* synthetic */ GroupCoordinatorResponseTest $outer;
                private final Capture capturedArgument$2;

                public void answer() {
                    ((Function1)this.capturedArgument$2.getValue()).apply((Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(GroupCoordinator$.MODULE$.GroupMetadataTopicName(), this.$outer.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId())), (Object)new ProducerResponseStatus(Errors.NONE.code(), 0L))})));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.capturedArgument$2 = capturedArgument$2;
                }
            });
            EasyMock.replay((Object[])new Object[]{this.replicaManager()});
            this.groupCoordinator().handleCommitOffsets(groupId, consumerId, generationId, offsets, responseCallback2);
            return (Map)Await$.MODULE$.result((Awaitable)responseFuture2, (Duration)Duration$.MODULE$.apply(40L, TimeUnit.MILLISECONDS));
        }
        throw new MatchError(tuple2);
    }

    private short leaveGroup(String groupId, String consumerId) {
        Tuple2<Future<Object>, Function1<Object, BoxedUnit>> tuple2 = this.setupHeartbeatCallback();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Future responseFuture = (Future)tuple2._1();
            Function1 responseCallback = (Function1)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)responseFuture, (Object)responseCallback);
            Future responseFuture2 = (Future)tuple23._1();
            Function1 responseCallback2 = (Function1)tuple23._2();
            EasyMock.expect((Object)this.replicaManager().getPartition(GroupCoordinator$.MODULE$.GroupMetadataTopicName(), this.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId())).andReturn((Object)None$.MODULE$);
            EasyMock.replay((Object[])new Object[]{this.replicaManager()});
            this.groupCoordinator().handleLeaveGroup(groupId, consumerId, responseCallback2);
            return BoxesRunTime.unboxToShort((Object)Await$.MODULE$.result((Awaitable)responseFuture2, (Duration)Duration$.MODULE$.apply(40L, TimeUnit.MILLISECONDS)));
        }
        throw new MatchError(tuple2);
    }

    public GroupCoordinatorResponseTest() {
        this.ClientId = "consumer-test";
        this.ClientHost = "localhost";
        this.ConsumerMinSessionTimeout = 10;
        this.ConsumerMaxSessionTimeout = 1000;
        this.DefaultSessionTimeout = 500;
        this.groupId = "groupId";
        this.protocolType = "consumer";
        this.memberId = "memberId";
        this.otherGroupId = "otherGroup";
    }
}

