/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Random;
import kafka.message.BufferingOutputStream;
import kafka.message.CompressionCodec;
import kafka.message.CompressionFactory$;
import kafka.message.Message;
import kafka.message.MessageWriter;
import kafka.message.NoCompressionCodec$;
import kafka.message.SnappyCompressionCodec$;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#T3tg\u0006<Wm\u0016:ji\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0004nKN\u001c\u0018mZ3\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001!\u0019!C\u00053\u0005\u0019!O\u001c3\u0016\u0003i\u0001\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\tU$\u0018\u000e\u001c\u0006\u0002?\u0005!!.\u0019<b\u0013\t\tCD\u0001\u0004SC:$w.\u001c\u0005\u0007G\u0001\u0001\u000b\u0011\u0002\u000e\u0002\tItG\r\t\u0005\u0006K\u0001!IAJ\u0001\u000e[.\u0014\u0016M\u001c3p[\u0006\u0013(/Y=\u0015\u0005\u001d\u0002\u0004c\u0001\u0015,[5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013FA\u0003BeJ\f\u0017\u0010\u0005\u0002)]%\u0011q&\u000b\u0002\u0005\u0005f$X\rC\u00032I\u0001\u0007!'\u0001\u0003tSj,\u0007C\u0001\u00154\u0013\t!\u0014FA\u0002J]RDQA\u000e\u0001\u0005\n]\n1#\\6NKN\u001c\u0018mZ3XSRDwK]5uKJ$B\u0001O\u001e>\u007fA\u0011a#O\u0005\u0003u\t\u0011q!T3tg\u0006<W\rC\u0004=kA\u0005\t\u0019A\u0014\u0002\u0007-,\u0017\u0010C\u0003?k\u0001\u0007q%A\u0003csR,7\u000fC\u0003Ak\u0001\u0007\u0011)A\u0003d_\u0012,7\r\u0005\u0002\u0017\u0005&\u00111I\u0001\u0002\u0011\u0007>l\u0007O]3tg&|gnQ8eK\u000eDQ!\u0012\u0001\u0005\n\u0019\u000b\u0001bY8naJ,7o\u001d\u000b\u0004O\u001dC\u0005\"\u0002 E\u0001\u00049\u0003\"\u0002!E\u0001\u0004\t\u0005\"\u0002&\u0001\t\u0013Y\u0015A\u00033fG>l\u0007O]3tgR\u0019q\u0005\u0014(\t\u000b5K\u0005\u0019A\u0014\u0002\u0015\r|W\u000e\u001d:fgN,G\rC\u0003A\u0013\u0002\u0007\u0011\tC\u0003Q\u0001\u0011%\u0011+A\u0004u_\u0006\u0013(/Y=\u0015\u0005\u001d\u0012\u0006\"B*P\u0001\u0004!\u0016AA5o!\t)\u0006,D\u0001W\u0015\t9f$\u0001\u0002j_&\u0011\u0011L\u0016\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0003Q\u0001\u0011%1\f\u0006\u0002(9\")QL\u0017a\u0001=\u0006\u0011!M\u0019\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003Cz\t1A\\5p\u0013\t\u0019\u0007M\u0001\u0006CsR,')\u001e4gKJDQ!\u001a\u0001\u0005\u0002\u0019\f\u0011\u0004^3ti\n+hMZ3sS:<w*\u001e;qkR\u001cFO]3b[R\tq\r\u0005\u0002)Q&\u0011\u0011.\u000b\u0002\u0005+:LG\u000f\u000b\u0002eWB\u0011AN\\\u0007\u0002[*\u00111BD\u0005\u0003_6\u0014A\u0001V3ti\")\u0011\u000f\u0001C\u0001M\u0006qB/Z:u/&$\bNT8D_6\u0004(/Z:tS>t\u0017\t\u001e;sS\n,H/\u001a\u0015\u0003a.DQ\u0001\u001e\u0001\u0005\u0002\u0019\fA\u0004^3ti^KG\u000f[\"p[B\u0014Xm]:j_:\fE\u000f\u001e:jEV$X\r\u000b\u0002tW\")q\u000f\u0001C\u0001M\u0006YA/Z:u/&$\bnS3zQ\t18\u000eC\u0004{\u0001E\u0005I\u0011B>\u0002;5\\W*Z:tC\u001e,w+\u001b;i/JLG/\u001a:%I\u00164\u0017-\u001e7uIE*\u0012\u0001 \u0016\u0003Ou\\\u0013A \t\u0004\u007f\u0006%QBAA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0004S\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0011\u0011\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class MessageWriterTest
extends JUnitSuite {
    private final Random kafka$message$MessageWriterTest$$rnd = new Random();

    public Random kafka$message$MessageWriterTest$$rnd() {
        return this.kafka$message$MessageWriterTest$$rnd;
    }

    private byte[] mkRandomArray(int size2) {
        return (byte[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MessageWriterTest $outer;

            public final byte apply(int x$1) {
                return (byte)this.$outer.kafka$message$MessageWriterTest$$rnd().nextInt(10);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte());
    }

    private Message mkMessageWithWriter(byte[] key, byte[] bytes, CompressionCodec codec) {
        MessageWriter writer = new MessageWriter(100);
        writer.write(key, codec, (Function1)new Serializable(this, bytes, codec){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MessageWriterTest $outer;
            private final byte[] bytes$1;
            private final CompressionCodec codec$1;

            public final void apply(OutputStream output) {
                CompressionCodec compressionCodec = this.codec$1;
                NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                OutputStream out = !(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null) ? output : CompressionFactory$.MODULE$.apply(this.codec$1, output);
                try {
                    int p = this.$outer.kafka$message$MessageWriterTest$$rnd().nextInt(this.bytes$1.length);
                    out.write(this.bytes$1, 0, p);
                    out.write(this.bytes$1, p, this.bytes$1.length - p);
                    return;
                }
                finally {
                    out.close();
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bytes$1 = bytes$1;
                this.codec$1 = codec$1;
            }
        });
        ByteBuffer bb = ByteBuffer.allocate(writer.size());
        writer.writeTo(bb);
        bb.rewind();
        return new Message(bb);
    }

    private byte[] mkMessageWithWriter$default$1() {
        return null;
    }

    private byte[] compress(byte[] bytes, CompressionCodec codec) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream out = CompressionFactory$.MODULE$.apply(codec, (OutputStream)baos);
        out.write(bytes);
        out.close();
        return baos.toByteArray();
    }

    private byte[] decompress(byte[] compressed, CompressionCodec codec) {
        return this.toArray(CompressionFactory$.MODULE$.apply(codec, (InputStream)new ByteArrayInputStream(compressed)));
    }

    private byte[] toArray(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[100];
        int amount = in.read(buf);
        while (amount >= 0) {
            out.write(buf, 0, amount);
            amount = in.read(buf);
        }
        return out.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    private byte[] toArray(ByteBuffer bb) {
        void var2_2;
        byte[] arr = new byte[bb.limit()];
        bb.get(arr);
        bb.rewind();
        return var2_2;
    }

    @Test
    public void testBufferingOutputStream() {
        BufferingOutputStream out = new BufferingOutputStream(50);
        out.write(0);
        out.write(1);
        out.write(2);
        BufferingOutputStream.ReservedOutput r = out.reserve(100);
        out.write((byte[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(103), 200).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply(int x$2) {
                return (byte)x$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte()));
        r.write((byte[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3), 103).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply(int x$3) {
                return (byte)x$3;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte()));
        ByteBuffer buf = ByteBuffer.allocate(out.size());
        out.writeTo(buf);
        buf.rewind();
        Assert.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply(int x$4) {
                return (byte)x$4;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()), (Object)Predef$.MODULE$.byteArrayOps(buf.array()).toSeq());
    }

    @Test
    public void testWithNoCompressionAttribute() {
        byte[] bytes;
        byte[] x$5 = bytes = this.mkRandomArray(4096);
        NoCompressionCodec$ x$6 = NoCompressionCodec$.MODULE$;
        byte[] x$7 = this.mkMessageWithWriter$default$1();
        Message actual = this.mkMessageWithWriter(x$7, x$5, (CompressionCodec)x$6);
        Message expected = new Message(bytes, (CompressionCodec)NoCompressionCodec$.MODULE$);
        Assert.assertEquals((Object)expected.buffer(), (Object)actual.buffer());
    }

    @Test
    public void testWithCompressionAttribute() {
        byte[] bytes;
        byte[] x$8 = bytes = this.mkRandomArray(4096);
        SnappyCompressionCodec$ x$9 = SnappyCompressionCodec$.MODULE$;
        byte[] x$10 = this.mkMessageWithWriter$default$1();
        Message actual = this.mkMessageWithWriter(x$10, x$8, (CompressionCodec)x$9);
        Message expected = new Message(this.compress(bytes, (CompressionCodec)SnappyCompressionCodec$.MODULE$), (CompressionCodec)SnappyCompressionCodec$.MODULE$);
        Assert.assertEquals((Object)Predef$.MODULE$.byteArrayOps(this.decompress(this.toArray(expected.payload()), (CompressionCodec)SnappyCompressionCodec$.MODULE$)).toSeq(), (Object)Predef$.MODULE$.byteArrayOps(this.decompress(this.toArray(actual.payload()), (CompressionCodec)SnappyCompressionCodec$.MODULE$)).toSeq());
    }

    @Test
    public void testWithKey() {
        byte[] bytes;
        byte[] key = this.mkRandomArray(123);
        byte[] x$11 = bytes = this.mkRandomArray(4096);
        byte[] x$12 = key;
        NoCompressionCodec$ x$13 = NoCompressionCodec$.MODULE$;
        Message actual = this.mkMessageWithWriter(x$12, x$11, (CompressionCodec)x$13);
        Message expected = new Message(bytes, key, (CompressionCodec)NoCompressionCodec$.MODULE$);
        Assert.assertEquals((Object)expected.buffer(), (Object)actual.buffer());
    }
}

