/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ProducerRequest;
import kafka.api.ProducerResponseStatus;
import kafka.api.SerializationTestUtils$;
import kafka.cluster.Partition;
import kafka.common.TopicAndPartition;
import kafka.log.LogManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.utils.MockScheduler;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.Test;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Map;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U2A!\u0001\u0002\u0001\u000f\t\u0011\"+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014H+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0001\u0016\u0003\u0015!x\u000e]5d+\u00051\u0002CA\f\u001d\u001b\u0005A\"BA\r\u001b\u0003\u0011a\u0017M\\4\u000b\u0003m\tAA[1wC&\u0011Q\u0004\u0007\u0002\u0007'R\u0014\u0018N\\4\t\r}\u0001\u0001\u0015!\u0003\u0017\u0003\u0019!x\u000e]5dA!)\u0011\u0005\u0001C\u0001E\u0005\tC/Z:u\u0011&<\u0007nV1uKJl\u0015M]6ESJ,7\r^8ss6\u000b\u0007\u000f]5oOR\t1\u0005\u0005\u0002\nI%\u0011QE\u0003\u0002\u0005+:LG\u000f\u000b\u0002!OA\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002Y\u0005\u0019qN]4\n\u00059J#\u0001\u0002+fgRDQ\u0001\r\u0001\u0005\u0002\t\n\u0011\u0006^3ti\"Kw\r[<bi\u0016\u0014X*\u0019:l%\u0016d\u0017\r^5wK\u0012K'/Z2u_JLX*\u00199qS:<\u0007FA\u0018(\u0011\u0015\u0019\u0004\u0001\"\u0001#\u0003]!Xm\u001d;JY2,w-\u00197SKF,\u0018N]3e\u0003\u000e\\7\u000f\u000b\u00023O\u0001")
public class ReplicaManagerTest {
    private final String topic;

    public String topic() {
        return this.topic;
    }

    @Test
    public void testHighWaterMarkDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ZkClient zkClient = (ZkClient)EasyMock.createMock(ZkClient.class);
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(zkClient, false);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$1) {
                return new File(x$1);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        kafka.utils.MockTime time = new kafka.utils.MockTime();
        MockTime jTime = new MockTime();
        Metrics metrics = new Metrics();
        ReplicaManager rm = new ReplicaManager(config, metrics, (kafka.utils.Time)time, (Time)jTime, zkUtils, (Scheduler)new MockScheduler(time), mockLogMgr, new AtomicBoolean(false), ReplicaManager$.MODULE$.$lessinit$greater$default$9());
        try {
            Partition partition = rm.getOrCreatePartition(this.topic(), 1);
            partition.getOrCreateReplica(1);
            rm.checkpointHighWatermarks();
            return;
        }
        finally {
            rm.shutdown(false);
            metrics.close();
        }
    }

    @Test
    public void testHighwaterMarkRelativeDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ZkClient zkClient = (ZkClient)EasyMock.createMock(ZkClient.class);
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(zkClient, false);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$2) {
                return new File(x$2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        kafka.utils.MockTime time = new kafka.utils.MockTime();
        MockTime jTime = new MockTime();
        Metrics metrics = new Metrics();
        ReplicaManager rm = new ReplicaManager(config, metrics, (kafka.utils.Time)time, (Time)jTime, zkUtils, (Scheduler)new MockScheduler(time), mockLogMgr, new AtomicBoolean(false), ReplicaManager$.MODULE$.$lessinit$greater$default$9());
        try {
            Partition partition = rm.getOrCreatePartition(this.topic(), 1);
            partition.getOrCreateReplica(1);
            rm.checkpointHighWatermarks();
            return;
        }
        finally {
            rm.shutdown(false);
            metrics.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIllegalRequiredAcks() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ZkClient zkClient = (ZkClient)EasyMock.createMock(ZkClient.class);
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(zkClient, false);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$3) {
                return new File(x$3);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        kafka.utils.MockTime time = new kafka.utils.MockTime();
        MockTime jTime = new MockTime();
        Metrics metrics = new Metrics();
        ReplicaManager rm = new ReplicaManager(config, metrics, (kafka.utils.Time)time, (Time)jTime, zkUtils, (Scheduler)new MockScheduler(time), mockLogMgr, new AtomicBoolean(false), Option$.MODULE$.apply((Object)this.getClass().getName()));
        try {
            ProducerRequest produceRequest = new ProducerRequest(1, "client 1", 3, 1000, SerializationTestUtils$.MODULE$.topicDataProducerRequest());
            rm.appendMessages(0L, (short)3, false, (Map)produceRequest.data(), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;

                public final void apply(Map<TopicAndPartition, ProducerResponseStatus> responseStatus) {
                    this.$outer.kafka$server$ReplicaManagerTest$$callback$1(responseStatus);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        catch (Throwable throwable) {
            void var8_8;
            void var9_9;
            var9_9.shutdown(false);
            var8_8.close();
            throw throwable;
        }
        rm.shutdown(false);
        metrics.close();
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    public final void kafka$server$ReplicaManagerTest$$callback$1(Map responseStatus) {
        Predef$.MODULE$.assert(((ProducerResponseStatus)responseStatus.values().head()).error() == Errors.INVALID_REQUIRED_ACKS.code());
    }

    public ReplicaManagerTest() {
        this.topic = "test-topic";
    }
}

