/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import joptsimple.OptionException;
import kafka.producer.ProducerConfig;
import kafka.tools.ConsoleProducer;
import kafka.tools.ConsoleProducer$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y2A!\u0001\u0002\u0001\u000f\t\u00192i\u001c8t_2,\u0007K]8ek\u000e,'\u000fV3ti*\u00111\u0001B\u0001\u0006i>|Gn\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0001\u0016\u0003%1\u0018\r\\5e\u0003J<7/F\u0001\u0017!\rIq#G\u0005\u00031)\u0011Q!\u0011:sCf\u0004\"AG\u000f\u000f\u0005%Y\u0012B\u0001\u000f\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011ad\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qQ\u0001BB\u0011\u0001A\u0003%a#\u0001\u0006wC2LG-\u0011:hg\u0002Bqa\t\u0001C\u0002\u0013\u0005Q#A\u0006j]Z\fG.\u001b3Be\u001e\u001c\bBB\u0013\u0001A\u0003%a#\u0001\u0007j]Z\fG.\u001b3Be\u001e\u001c\b\u0005C\u0003(\u0001\u0011\u0005\u0001&A\u000euKN$h+\u00197jI\u000e{gNZ5hg:+w\u000f\u0015:pIV\u001cWM\u001d\u000b\u0002SA\u0011\u0011BK\u0005\u0003W)\u0011A!\u00168ji\"\u0012a%\f\t\u0003]Mj\u0011a\f\u0006\u0003aE\nQA[;oSRT\u0011AM\u0001\u0004_J<\u0017B\u0001\u001b0\u0005\u0011!Vm\u001d;\t\u000bY\u0002A\u0011\u0001\u0015\u00027Q,7\u000f\u001e,bY&$7i\u001c8gS\u001e\u001cx\n\u001c3Qe>$WoY3sQ\t)T\u0006C\u0003:\u0001\u0011\u0005\u0001&\u0001\nuKN$\u0018J\u001c<bY&$7i\u001c8gS\u001e\u001c\bF\u0001\u001d.\u0011\u0015a\u0004\u0001\"\u0001)\u0003A!Xm\u001d;QCJ\u001cXmS3z!J|\u0007\u000f\u000b\u0002<[\u0001")
public class ConsoleProducerTest {
    private final String[] validArgs = (String[])((Object[])new String[]{"--broker-list", "localhost:1001,localhost:1002", "--topic", "t3", "--property", "parse.key=true", "--property", "key.separator=#"});
    private final String[] invalidArgs = (String[])((Object[])new String[]{"--t", "t3"});

    public String[] validArgs() {
        return this.validArgs;
    }

    public String[] invalidArgs() {
        return this.invalidArgs;
    }

    @Test
    public void testValidConfigsNewProducer() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.validArgs());
        new KafkaProducer(ConsoleProducer$.MODULE$.getNewProducerProps(config));
    }

    @Test
    public void testValidConfigsOldProducer() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.validArgs());
        new ProducerConfig(ConsoleProducer$.MODULE$.getOldProducerProps(config));
    }

    @Test
    public void testInvalidConfigs() {
        try {
            ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.invalidArgs());
            Assert.fail((String)"Should have thrown an UnrecognizedOptionException");
        }
        catch (OptionException optionException) {
            // empty catch block
        }
    }

    @Test
    public void testParseKeyProp() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.validArgs());
        ConsoleProducer.LineMessageReader reader = (ConsoleProducer.LineMessageReader)Class.forName(config.readerClass()).newInstance();
        reader.init(System.in, ConsoleProducer$.MODULE$.getReaderProps(config));
        String string = reader.keySeparator();
        String string2 = "#";
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        Predef$.MODULE$.assert(reader.parseKey());
    }
}

