/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.util.Collection;
import java.util.List;
import javax.security.auth.login.Configuration;
import kafka.consumer.ConsumerConfig;
import kafka.utils.JaasTestUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZKCheckedEphemeral;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZKEphemeralTest$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkConnection;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005t!B\u0001\u0003\u0011\u00039\u0011a\u0004.L\u000bBDW-\\3sC2$Vm\u001d;\u000b\u0005\r!\u0011A\u0001>l\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u00105.+\u0005\u000f[3nKJ\fG\u000eV3tiN\u0019\u0011\u0002\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\ti1#\u0003\u0002\u0015\u001d\ta1+\u001a:jC2L'0\u00192mK\")a#\u0003C\u0001/\u00051A(\u001b8jiz\"\u0012a\u0002\u0005\u00063%!\tAG\u0001\u0016K:\f'\r\\3TK\u000e,(/\u001b;z\u001fB$\u0018n\u001c8t+\u0005Y\u0002c\u0001\u000f\"G5\tQD\u0003\u0002\u001f?\u0005!Q\u000f^5m\u0015\u0005\u0001\u0013\u0001\u00026bm\u0006L!AI\u000f\u0003\u0015\r{G\u000e\\3di&|g\u000eE\u0002\u000eI\u0019J!!\n\b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%z\u0012\u0001\u00027b]\u001eL!a\u000b\u0015\u0003\u000f\t{w\u000e\\3b]\"\u0012\u0001$\f\t\u0003]\u0001s!aL\u001f\u000f\u0005ARdBA\u00198\u001d\t\u0011T'D\u00014\u0015\t!d!\u0001\u0004=e>|GOP\u0005\u0002m\u0005\u0019qN]4\n\u0005aJ\u0014!\u00026v]&$(\"\u0001\u001c\n\u0005mb\u0014a\u0002:v]:,'o\u001d\u0006\u0003qeJ!AP \u0002\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0015\tYD(\u0003\u0002B\u0005\nQ\u0001+\u0019:b[\u0016$XM]:\u000b\u0005yz\u0004b\u0002#\n\u0003\u0003%I!R\u0001\fe\u0016\fGMU3t_24X\rF\u0001G!\t9s)\u0003\u0002IQ\t1qJ\u00196fGR4AA\u0003\u0002\u0001\u0015N\u0019\u0011j\u0013*\u0011\u00051\u0003V\"A'\u000b\u0005ar%BA(:\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002R\u001b\nQ!*\u00168jiN+\u0018\u000e^3\u0011\u0005!\u0019\u0016B\u0001+\u0003\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\"Aa+\u0013BC\u0002\u0013\u0005q+\u0001\u0004tK\u000e,(/Z\u000b\u00021B\u0011Q\"W\u0005\u0003W9A\u0001bW%\u0003\u0002\u0003\u0006I\u0001W\u0001\bg\u0016\u001cWO]3!\u0011\u00151\u0012\n\"\u0001^)\tqv\f\u0005\u0002\t\u0013\")a\u000b\u0018a\u00011\"9\u0011-\u0013b\u0001\n\u0003\u0011\u0017\u0001\u00036bCN4\u0015\u000e\\3\u0016\u0003\r\u0004\"\u0001Z4\u000f\u00055)\u0017B\u00014\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001.\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019t\u0001BB6JA\u0003%1-A\u0005kC\u0006\u001ch)\u001b7fA!9Q.\u0013b\u0001\n\u0003\u0011\u0017\u0001D1vi\"\u0004&o\u001c<jI\u0016\u0014\bBB8JA\u0003%1-A\u0007bkRD\u0007K]8wS\u0012,'\u000f\t\u0005\bc&\u0003\r\u0011\"\u0001s\u0003IQ8nU3tg&|g\u000eV5nK>,H/T:\u0016\u0003M\u0004\"!\u0004;\n\u0005Ut!aA%oi\"9q/\u0013a\u0001\n\u0003A\u0018A\u0006>l'\u0016\u001c8/[8o)&lWm\\;u\u001bN|F%Z9\u0015\u0005ed\bCA\u0007{\u0013\tYhB\u0001\u0003V]&$\bbB?w\u0003\u0003\u0005\ra]\u0001\u0004q\u0012\n\u0004BB@JA\u0003&1/A\n{WN+7o]5p]RKW.Z8vi6\u001b\b\u0005C\u0004\u0002\u0004%#\t%!\u0002\u0002\u000bM,G/\u00169\u0015\u0003eDC!!\u0001\u0002\nA!\u00111BA\u0007\u001b\u0005a\u0014bAA\by\t1!)\u001a4pe\u0016Dq!a\u0005J\t\u0003\n)!\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011\t\t\"a\u0006\u0011\t\u0005-\u0011\u0011D\u0005\u0004\u00037a$!B!gi\u0016\u0014\bbBA\u0010\u0013\u0012\u0005\u0011\u0011E\u0001\u0019i\u0016\u001cH/\u00129iK6,'/\u00197O_\u0012,7\t\\3b]V\u0004X#A=)\t\u0005u\u0011Q\u0005\t\u0005\u0003\u0017\t9#C\u0002\u0002*q\u0012A\u0001V3ti\"9\u0011QF%\u0005\u0002\u0005\u0005\u0012A\u0006;fgRT6nV1uG\",G-\u00129iK6,'/\u00197)\t\u0005-\u0012Q\u0005\u0005\b\u0003gIE\u0011BA\u001b\u00031!Xm\u001d;De\u0016\fG/[8o)\rI\u0018q\u0007\u0005\b\u0003s\t\t\u00041\u0001d\u0003\u0011\u0001\u0018\r\u001e5\t\u000f\u0005u\u0012\n\"\u0001\u0002\"\u00059B/Z:u\u001fZ,'\u000f\\1qa&twmU3tg&|gn\u001d\u0015\u0005\u0003w\t)\u0003C\u0004\u0002D%#\t!!\t\u0002\u001fQ,7\u000f^*b[\u0016\u001cVm]:j_:DC!!\u0011\u0002&!:\u0011*!\u0013\u0002V\u0005]\u0003\u0003BA&\u0003#j!!!\u0014\u000b\u0007\u0005=C(\u0001\u0004sk:tWM]\u0005\u0005\u0003'\niEA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0005\u0005e\u0003\u0003BA.\u0003;j\u0011aP\u0005\u0004\u0003?z$!\u0004)be\u0006lW\r^3sSj,G\r")
public class ZKEphemeralTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final boolean secure;
    private final String jaasFile;
    private final String authProvider;
    private int zkSessionTimeoutMs;
    private EmbeddedZookeeper zookeeper;
    private int zkPort;
    private ZkUtils zkUtils;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Parameterized.Parameters
    public static Collection<Boolean[]> enableSecurityOptions() {
        return ZKEphemeralTest$.MODULE$.enableSecurityOptions();
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public int zkPort() {
        return this.zkPort;
    }

    @Override
    public void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    public String confFile() {
        return ZooKeeperTestHarness$class.confFile(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ZKEphemeralTest zKEphemeralTest = this;
        synchronized (zKEphemeralTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public boolean secure() {
        return this.secure;
    }

    public String jaasFile() {
        return this.jaasFile;
    }

    public String authProvider() {
        return this.authProvider;
    }

    public int zkSessionTimeoutMs() {
        return this.zkSessionTimeoutMs;
    }

    public void zkSessionTimeoutMs_$eq(int x$1) {
        this.zkSessionTimeoutMs = x$1;
    }

    @Override
    @Before
    public void setUp() {
        if (this.secure()) {
            Configuration.setConfiguration(null);
            System.setProperty("java.security.auth.login.config", this.jaasFile());
            System.setProperty(this.authProvider(), "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
            if (!JaasUtils.isZkSecurityEnabled()) {
                throw this.fail("Secure access not enabled");
            }
        }
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
        System.clearProperty("java.security.auth.login.config");
        System.clearProperty(this.authProvider());
        Configuration.setConfiguration(null);
    }

    @Test
    public void testEphemeralNodeCleanup() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), JaasUtils.isZkSecurityEnabled());
        try {
            ZkUtils qual$1 = zkUtils;
            String x$1 = "/tmp/zktest";
            String x$2 = "node created";
            List x$3 = qual$1.createEphemeralPathExpectConflict$default$3();
            qual$1.createEphemeralPathExpectConflict(x$1, x$2, x$3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String testData = null;
        testData = (String)zkUtils.readData("/tmp/zktest")._1();
        Assert.assertNotNull((Object)testData);
        zkUtils.close();
        zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), JaasUtils.isZkSecurityEnabled());
        boolean nodeExists = zkUtils.pathExists("/tmp/zktest");
        Assert.assertFalse((boolean)nodeExists);
    }

    @Test
    public void testZkWatchedEphemeral() {
        String path = "/zwe-test";
        this.testCreation(path);
        path = "/zwe-test-parent/zwe-test";
        this.testCreation(path);
    }

    private void testCreation(String path) {
        ZooKeeper zk = this.zkUtils().zkConnection().getZookeeper();
        ZKCheckedEphemeral zwe = new ZKCheckedEphemeral(path, "", zk, JaasUtils.isZkSecurityEnabled());
        BooleanRef created = new BooleanRef(false);
        int counter = 10;
        zk.exists(path, new Watcher(this, created){
            private final BooleanRef created$1;

            public void process(WatchedEvent event) {
                Watcher.Event.EventType eventType = event.getType();
                Watcher.Event.EventType eventType2 = Watcher.Event.EventType.NodeCreated;
                if (!(eventType != null ? !eventType.equals(eventType2) : eventType2 != null)) {
                    this.created$1.elem = true;
                }
            }
            {
                this.created$1 = created$1;
            }
        });
        zwe.create();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, path){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZKEphemeralTest $outer;
            private final String path$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkUtils().pathExists(this.path$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.path$1 = path$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Znode ", " wasn't created"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testOverlappingSessions() {
        ZkConnection zkConnection2;
        ZkConnection zkConnection;
        String path = "/zwe-test";
        ZooKeeper zk1 = this.zkUtils().zkConnection().getZookeeper();
        Tuple2 tuple2 = ZkUtils$.MODULE$.createZkClientAndConnection(this.zkConnect(), this.zkSessionTimeoutMs(), this.zkConnectionTimeout());
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        ZkConnection zkConnection22 = zkConnection = (zkConnection2 = (ZkConnection)tuple2._2());
        ZooKeeper zk2 = zkConnection22.getZookeeper();
        ZKCheckedEphemeral zwe = new ZKCheckedEphemeral(path, "", zk2, JaasUtils.isZkSecurityEnabled());
        zk1.create(path, (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        boolean gotException = false;
        try {
            zwe.create();
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            gotException = true;
        }
        Assert.assertTrue((boolean)gotException);
    }

    @Test
    public void testSameSession() {
        String path = "/zwe-test";
        ZooKeeper zk = this.zkUtils().zkConnection().getZookeeper();
        zk.create(path, (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        ZKCheckedEphemeral zwe = new ZKCheckedEphemeral(path, "", zk, JaasUtils.isZkSecurityEnabled());
        boolean gotException = false;
        try {
            zwe.create();
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            gotException = true;
        }
        Assert.assertFalse((boolean)gotException);
    }

    public ZKEphemeralTest(boolean secure) {
        this.secure = secure;
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.jaasFile = JaasTestUtils$.MODULE$.genZkFile();
        this.authProvider = "zookeeper.authProvider.1";
        this.zkSessionTimeoutMs = 1000;
    }
}

