/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import kafka.network.Acceptor;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor;
import kafka.network.RequestChannel;
import kafka.network.RequestMetrics;
import kafka.network.RequestMetrics$;
import kafka.network.SocketServer;
import kafka.network.SocketServerTest$;
import kafka.security.CredentialProvider;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0001\u0003\u0001\u001d\u0011\u0001cU8dW\u0016$8+\u001a:wKJ$Vm\u001d;\u000b\u0005\r!\u0011a\u00028fi^|'o\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!A\u0003&V]&$8+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001\u0005\b1\u0001\u0011\r\u0011\"\u0001\u001a\u0003\u0015\u0001(o\u001c9t+\u0005Q\u0002CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0011)H/\u001b7\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bBB\u0012\u0001A\u0003%!$\u0001\u0004qe>\u00048\u000f\t\u0005\bK\u0001\u0011\r\u0011\"\u0001'\u0003\u0019\u0019wN\u001c4jOV\tq\u0005\u0005\u0002)W5\t\u0011F\u0003\u0002+\t\u000511/\u001a:wKJL!\u0001L\u0015\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\u0007]\u0001\u0001\u000b\u0011B\u0014\u0002\u000f\r|gNZ5hA!9\u0001\u0007\u0001b\u0001\n\u0003\t\u0014aB7fiJL7m]\u000b\u0002eA\u00111GO\u0007\u0002i)\u0011\u0001'\u000e\u0006\u0003m]\naaY8n[>t'BA\u00039\u0015\tId\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003wQ\u0012q!T3ue&\u001c7\u000f\u0003\u0004>\u0001\u0001\u0006IAM\u0001\t[\u0016$(/[2tA!9q\b\u0001b\u0001\n\u0003\u0001\u0015AE2sK\u0012,g\u000e^5bYB\u0013xN^5eKJ,\u0012!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t\u0012\t\u0001b]3dkJLG/_\u0005\u0003\r\u000e\u0013!c\u0011:fI\u0016tG/[1m!J|g/\u001b3fe\"1\u0001\n\u0001Q\u0001\n\u0005\u000b1c\u0019:fI\u0016tG/[1m!J|g/\u001b3fe\u0002BqA\u000b\u0001C\u0002\u0013\u0005!*F\u0001L!\t1B*\u0003\u0002N\u0005\ta1k\\2lKR\u001cVM\u001d<fe\"1q\n\u0001Q\u0001\n-\u000bqa]3sm\u0016\u0014\b\u0005C\u0004R\u0001\t\u0007I\u0011\u0001*\u0002\u000fM|7m[3ugV\t1\u000bE\u0002U7vk\u0011!\u0016\u0006\u0003-^\u000bq!\\;uC\ndWM\u0003\u0002Y3\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003i\u000bQa]2bY\u0006L!\u0001X+\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003=\u0006l\u0011a\u0018\u0006\u0003Az\t1A\\3u\u0013\t\u0011wL\u0001\u0004T_\u000e\\W\r\u001e\u0005\u0007I\u0002\u0001\u000b\u0011B*\u0002\u0011M|7m[3ug\u0002BQA\u001a\u0001\u0005\u0002\u001d\f1b]3oIJ+\u0017/^3tiR!\u0001\u000e\u001c8w!\tI'.D\u0001Z\u0013\tY\u0017L\u0001\u0003V]&$\b\"B7f\u0001\u0004i\u0016AB:pG.,G\u000fC\u0003pK\u0002\u0007\u0001/A\u0004sKF,Xm\u001d;\u0011\u0007%\f8/\u0003\u0002s3\n)\u0011I\u001d:bsB\u0011\u0011\u000e^\u0005\u0003kf\u0013AAQ=uK\"9q/\u001aI\u0001\u0002\u0004A\u0018AA5e!\rI\u0017p_\u0005\u0003uf\u0013aa\u00149uS>t\u0007CA5}\u0013\ti\u0018LA\u0003TQ>\u0014H\u000f\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011A\u0001\u0010e\u0016\u001cW-\u001b<f%\u0016\u001c\bo\u001c8tKR\u0019\u0001/a\u0001\t\u000b5t\b\u0019A/\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n\u0005q\u0001O]8dKN\u001c(+Z9vKN$Hc\u00015\u0002\f!A\u0011QBA\u0003\u0001\u0004\ty!A\u0004dQ\u0006tg.\u001a7\u0011\u0007Y\t\t\"C\u0002\u0002\u0014\t\u0011aBU3rk\u0016\u001cHo\u00115b]:,G\u000eC\u0004\u0002\b\u0001!\t!a\u0006\u0015\u000b!\fI\"a\u0007\t\u0011\u00055\u0011Q\u0003a\u0001\u0003\u001fAqa\\A\u000b\u0001\u0004\ti\u0002\u0005\u0003\u0002 \u0005\u0015bb\u0001\f\u0002\"%\u0019\u00111\u0005\u0002\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&!\u0011qEA\u0015\u0005\u001d\u0011V-];fgRT1!a\t\u0003\u0011\u001d\ti\u0003\u0001C\u0001\u0003_\tqaY8o]\u0016\u001cG\u000fF\u0003^\u0003c\t)\u0004C\u0005\u00024\u0005-\u0002\u0013!a\u0001\u0017\u0006\t1\u000f\u0003\u0006\u00028\u0005-\u0002\u0013!a\u0001\u0003s\t\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\t\u0005\u0003w\ty$\u0004\u0002\u0002>)\u0019\u0011qG\u001b\n\t\u0005\u0005\u0013Q\b\u0002\u0011'\u0016\u001cWO]5usB\u0013x\u000e^8d_2Dq!!\u0012\u0001\t\u0003\t9%\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005A\u0007\u0006BA\"\u0003\u0017\u0002B!!\u0014\u0002R5\u0011\u0011q\n\u0006\u0003\u00179IA!a\u0015\u0002P\t)\u0011I\u001a;fe\"9\u0011q\u000b\u0001\u0005\n\u0005e\u0013\u0001\u00069s_\u0012,8-\u001a:SKF,Xm\u001d;CsR,7/F\u0001q\u0011\u001d\ti\u0006\u0001C\u0001\u0003\u000f\nQb]5na2,'+Z9vKN$\b\u0006BA.\u0003C\u0002B!!\u0014\u0002d%!\u0011QMA(\u0005\u0011!Vm\u001d;\t\u000f\u0005%\u0004\u0001\"\u0001\u0002H\u00059Bo\\8CS\u001e\u0014V-];fgRL5OU3kK\u000e$X\r\u001a\u0015\u0005\u0003O\n\t\u0007C\u0004\u0002p\u0001!\t!a\u0012\u0002#Q,7\u000f^$sC\u000e,g-\u001e7DY>\u001cX\r\u000b\u0003\u0002n\u0005\u0005\u0004bBA;\u0001\u0011\u0005\u0011qI\u0001\u001bi\u0016\u001cHoU8dW\u0016$8o\u00117pg\u0016|en\u00155vi\u0012|wO\u001c\u0015\u0005\u0003g\n\t\u0007C\u0004\u0002|\u0001!\t!a\u0012\u0002/Q,7\u000f^'bq\u000e{gN\\3di&|gn\u001d)fe&\u0003\b\u0006BA=\u0003CBq!!!\u0001\t\u0003\t9%\u0001\u0011uKN$X*\u0019=D_:tWm\u0019;j_:\u001c\b+\u001a:Ja>3XM\u001d:jI\u0016\u001c\b\u0006BA@\u0003CBq!a\"\u0001\t\u0003\t9%A\nuKN$8k\u001d7T_\u000e\\W\r^*feZ,'\u000f\u000b\u0003\u0002\u0006\u0006\u0005\u0004bBAG\u0001\u0011\u0005\u0011qI\u0001\u0015i\u0016\u001cHoU3tg&|g\u000e\u0015:j]\u000eL\u0007/\u00197)\t\u0005-\u0015\u0011\r\u0005\b\u0003'\u0003A\u0011AA$\u00031\"Xm\u001d;DY&,g\u000e\u001e#jg\u000e|gN\\3di&|g.\u00169eCR,7OU3rk\u0016\u001cH/T3ue&\u001c7\u000f\u000b\u0003\u0002\u0012\u0006\u0005\u0004bBAM\u0001\u0011\u0005\u0011qI\u00016i\u0016\u001cHO\u0011:pW\u0016\u00148+\u001a8e\u0003\u001a$XM]\"iC:tW\r\\\"m_N,G-\u00169eCR,7OU3rk\u0016\u001cH/T3ue&\u001c7\u000f\u000b\u0003\u0002\u0018\u0006\u0005\u0004bBAP\u0001\u0011\u0005\u0011qI\u0001\"i\u0016\u001cH/T3ue&\u001c7i\u001c7mK\u000e$\u0018n\u001c8BMR,'o\u00155vi\u0012|wO\u001c\u0015\u0005\u0003;\u000b\t\u0007C\u0004\u0002&\u0002!\t!a\u0012\u00021Q,7\u000f\u001e)s_\u000e,7o]8s\u001b\u0016$(/[2t)\u0006<7\u000f\u000b\u0003\u0002$\u0006\u0005\u0004\"CAV\u0001E\u0005I\u0011AAW\u0003U\u0019XM\u001c3SKF,Xm\u001d;%I\u00164\u0017-\u001e7uIM*\"!a,+\u0007a\f\tl\u000b\u0002\u00024B!\u0011QWA`\u001b\t\t9L\u0003\u0003\u0002:\u0006m\u0016!C;oG\",7m[3e\u0015\r\ti,W\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAa\u0003o\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t)\rAI\u0001\n\u0003\t9-A\td_:tWm\u0019;%I\u00164\u0017-\u001e7uIE*\"!!3+\u0007-\u000b\t\fC\u0005\u0002N\u0002\t\n\u0011\"\u0001\u0002P\u0006\t2m\u001c8oK\u000e$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005E'\u0006BA\u001d\u0003c\u0003")
public class SocketServerTest
extends JUnitSuite {
    private final Properties props;
    private final KafkaConfig config;
    private final Metrics metrics;
    private final CredentialProvider credentialProvider;
    private final SocketServer server;
    private final ArrayBuffer<Socket> sockets;

    public Properties props() {
        return this.props;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    public SocketServer server() {
        return this.server;
    }

    public ArrayBuffer<Socket> sockets() {
        return this.sockets;
    }

    public void sendRequest(Socket socket, byte[] request, Option<Object> id) {
        Option<Object> option;
        block4: {
            DataOutputStream outgoing;
            block3: {
                block2: {
                    outgoing = new DataOutputStream(socket.getOutputStream());
                    option = id;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    short id2 = BoxesRunTime.unboxToShort((Object)some.x());
                    outgoing.writeInt(request.length + 2);
                    outgoing.writeShort(id2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                outgoing.writeInt(request.length);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            outgoing.write(request);
            outgoing.flush();
            return;
        }
        throw new MatchError(option);
    }

    public Option<Object> sendRequest$default$3() {
        return None$.MODULE$;
    }

    public byte[] receiveResponse(Socket socket) {
        DataInputStream incoming = new DataInputStream(socket.getInputStream());
        int len = incoming.readInt();
        byte[] response = new byte[len];
        incoming.readFully(response);
        return response;
    }

    public void processRequest(RequestChannel channel) {
        RequestChannel.Request request = channel.receiveRequest(2000L);
        Assert.assertNotNull((String)"receiveRequest timed out", (Object)request);
        this.processRequest(channel, request);
    }

    public void processRequest(RequestChannel channel, RequestChannel.Request request) {
        ByteBuffer byteBuffer = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals())).serialize(request.header());
        byteBuffer.rewind();
        NetworkSend send = new NetworkSend(request.connectionId(), byteBuffer);
        channel.sendResponse(RequestChannel.Response$.MODULE$.apply(request, (Send)send));
    }

    /*
     * WARNING - void declaration
     */
    public Socket connect(SocketServer s, SecurityProtocol protocol) {
        void var3_3;
        Socket socket = new Socket("localhost", s.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)protocol)));
        this.sockets().$plus$eq((Object)socket);
        return var3_3;
    }

    public SocketServer connect$default$1() {
        return this.server();
    }

    public SecurityProtocol connect$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    @After
    public void tearDown() {
        this.metrics().close();
        this.server().shutdown();
        this.sockets().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Socket x$1) {
                x$1.close();
            }
        });
        this.sockets().clear();
    }

    private byte[] producerRequestBytes() {
        short apiKey = 0;
        int correlationId = -1;
        String clientId = "";
        int ackTimeoutMs = 10000;
        short ack = 0;
        ProduceRequest emptyRequest = (ProduceRequest)new ProduceRequest.Builder(2, ack, ackTimeoutMs, new HashMap()).build();
        RequestHeader emptyHeader = new RequestHeader(apiKey, emptyRequest.version(), clientId, correlationId);
        ByteBuffer byteBuffer = emptyRequest.serialize(emptyHeader);
        byteBuffer.rewind();
        byte[] serializedBytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(serializedBytes);
        return serializedBytes;
    }

    @Test
    public void simpleRequest() {
        SecurityProtocol x$22 = SecurityProtocol.PLAINTEXT;
        SocketServer x$23 = this.connect$default$1();
        Socket plainSocket = this.connect(x$23, x$22);
        SecurityProtocol x$24 = SecurityProtocol.TRACE;
        SocketServer x$25 = this.connect$default$1();
        Socket traceSocket = this.connect(x$25, x$24);
        byte[] serializedBytes = this.producerRequestBytes();
        this.sendRequest(plainSocket, serializedBytes, this.sendRequest$default$3());
        this.processRequest(this.server().requestChannel());
        Assert.assertEquals((Object)Predef$.MODULE$.byteArrayOps(serializedBytes).toSeq(), (Object)Predef$.MODULE$.byteArrayOps(this.receiveResponse(plainSocket)).toSeq());
        this.sendRequest(traceSocket, serializedBytes, this.sendRequest$default$3());
        this.processRequest(this.server().requestChannel());
        Assert.assertEquals((Object)Predef$.MODULE$.byteArrayOps(serializedBytes).toSeq(), (Object)Predef$.MODULE$.byteArrayOps(this.receiveResponse(traceSocket)).toSeq());
    }

    @Test
    public void tooBigRequestIsRejected() {
        byte[] tooManyBytes = new byte[Predef$.MODULE$.Integer2int(this.server().config().socketRequestMaxBytes()) + 1];
        new Random().nextBytes(tooManyBytes);
        Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());
        DataOutputStream outgoing = new DataOutputStream(socket.getOutputStream());
        outgoing.writeInt(tooManyBytes.length);
        try {
            outgoing.write(tooManyBytes);
            outgoing.flush();
            this.receiveResponse(socket);
        }
        catch (IOException iOException) {}
    }

    @Test
    public void testGracefulClose() {
        SecurityProtocol x$26 = SecurityProtocol.PLAINTEXT;
        SocketServer x$27 = this.connect$default$1();
        Socket plainSocket = this.connect(x$27, x$26);
        byte[] serializedBytes = this.producerRequestBytes();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, plainSocket, serializedBytes){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServerTest $outer;
            private final Socket plainSocket$1;
            private final byte[] serializedBytes$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                this.$outer.sendRequest(this.plainSocket$1, this.serializedBytes$1, this.$outer.sendRequest$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.plainSocket$1 = plainSocket$1;
                this.serializedBytes$1 = serializedBytes$1;
            }
        });
        plainSocket.close();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServerTest $outer;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                RequestChannel.Request request = this.$outer.server().requestChannel().receiveRequest(2000L);
                Assert.assertNotNull((String)"receiveRequest timed out", (Object)request);
                this.$outer.server().requestChannel().sendResponse(new RequestChannel.Response(request, (Option)None$.MODULE$, (RequestChannel.ResponseAction)RequestChannel.NoOpAction$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testSocketsCloseOnShutdown() {
        SecurityProtocol x$28 = SecurityProtocol.PLAINTEXT;
        SocketServer x$29 = this.connect$default$1();
        Socket plainSocket = this.connect(x$29, x$28);
        plainSocket.setTcpNoDelay(true);
        SecurityProtocol x$30 = SecurityProtocol.TRACE;
        SocketServer x$31 = this.connect$default$1();
        Socket traceSocket = this.connect(x$31, x$30);
        traceSocket.setTcpNoDelay(true);
        byte[] bytes = new byte[40];
        this.sendRequest(plainSocket, bytes, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)0)));
        this.sendRequest(traceSocket, bytes, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)0)));
        this.processRequest(this.server().requestChannel());
        Thread.sleep(200L);
        this.server().acceptors().values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Acceptor acceptor) {
                Assert.assertFalse((boolean)acceptor.serverChannel().socket().isClosed());
            }
        }, Iterable$.MODULE$.canBuildFrom());
        this.server().shutdown();
        byte[] largeChunkOfBytes = new byte[1000000];
        try {
            this.sendRequest(plainSocket, largeChunkOfBytes, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)0)));
            throw this.fail("expected exception when writing to closed plain socket", new Position("SocketServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
        }
        catch (IOException iOException) {
            try {
                this.sendRequest(traceSocket, largeChunkOfBytes, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)0)));
                throw this.fail("expected exception when writing to closed trace socket", new Position("SocketServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
            }
            catch (IOException iOException2) {
                return;
            }
        }
    }

    @Test
    public void testMaxConnectionsPerIp() {
        IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(this.server().config().maxConnectionsPerIp())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServerTest $outer;

            public final Socket apply(int x$2) {
                return this.$outer.connect(this.$outer.connect$default$1(), this.$outer.connect$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Socket conn = this.connect(this.connect$default$1(), this.connect$default$2());
        conn.setSoTimeout(3000);
        Assert.assertEquals((long)-1L, (long)conn.getInputStream().read());
        conn.close();
        InetAddress address = ((Socket)conns.head()).getInetAddress();
        ((Socket)conns.head()).close();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, conns, address){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServerTest $outer;
            private final IndexedSeq conns$1;
            private final InetAddress address$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.server().connectionCount(this.address$1) < this.conns$1.length();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.conns$1 = conns$1;
                this.address$1 = address$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to decrement connection count after close";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Socket conn2 = this.connect(this.connect$default$1(), this.connect$default$2());
        byte[] serializedBytes = this.producerRequestBytes();
        this.sendRequest(conn2, serializedBytes, this.sendRequest$default$3());
        RequestChannel.Request request = this.server().requestChannel().receiveRequest(2000L);
        Assert.assertNotNull((Object)request);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaxConnectionsPerIpOverrides() {
        int overrideNum = Predef$.MODULE$.Integer2int(this.server().config().maxConnectionsPerIp()) + 1;
        int x$32 = 0;
        String x$33 = TestUtils$.MODULE$.MockZkConnect();
        int x$34 = 0;
        boolean x$35 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$36 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$37 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$38 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$39 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$40 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$41 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$42 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$43 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$44 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$45 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$46 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$47 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties overrideProps = TestUtils$.MODULE$.createBrokerConfig(x$32, x$33, x$35, x$36, x$34, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47);
        overrideProps.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)overrideNum)})));
        Metrics serverMetrics = new Metrics();
        SocketServer overrideServer = new SocketServer(KafkaConfig$.MODULE$.fromProps(overrideProps), serverMetrics, Time.SYSTEM, this.credentialProvider());
        try {
            overrideServer.startup();
            IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), overrideNum).map((Function1)new Serializable(this, overrideServer){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SocketServerTest $outer;
                private final SocketServer overrideServer$1;

                public final Socket apply(int x$3) {
                    return this.$outer.connect(this.overrideServer$1, this.$outer.connect$default$2());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.overrideServer$1 = overrideServer$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            byte[] serializedBytes = this.producerRequestBytes();
            this.sendRequest((Socket)conns.last(), serializedBytes, this.sendRequest$default$3());
            RequestChannel.Request request = overrideServer.requestChannel().receiveRequest(2000L);
            Assert.assertNotNull((Object)request);
            Socket conn = this.connect(overrideServer, this.connect$default$2());
            conn.setSoTimeout(3000);
            Assert.assertEquals((long)-1L, (long)conn.getInputStream().read());
        }
        catch (Throwable throwable) {
            void var19_19;
            void var20_20;
            var20_20.shutdown();
            var19_19.close();
            throw throwable;
        }
        overrideServer.shutdown();
        serverMetrics.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSslSocketServer() {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        int x$48 = 0;
        String x$49 = TestUtils$.MODULE$.MockZkConnect();
        Some x$50 = new Some((Object)SecurityProtocol.SSL);
        Some x$51 = new Some((Object)trustStoreFile);
        boolean x$52 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$53 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        int x$54 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        Option<Properties> x$55 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$56 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$57 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$58 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$59 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$60 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$61 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$62 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$63 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties overrideProps = TestUtils$.MODULE$.createBrokerConfig(x$48, x$49, x$52, x$53, x$54, (Option<SecurityProtocol>)x$50, (Option<File>)x$51, x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63);
        overrideProps.put(KafkaConfig$.MODULE$.ListenersProp(), "SSL://localhost:0");
        Metrics serverMetrics = new Metrics();
        SocketServer overrideServer = new SocketServer(KafkaConfig$.MODULE$.fromProps(overrideProps), serverMetrics, Time.SYSTEM, this.credentialProvider());
        try {
            overrideServer.startup();
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, (TrustManager[])((Object[])new TrustManager[]{TestUtils$.MODULE$.trustAllCerts()}), new SecureRandom());
            SSLSocketFactory socketFactory = sslContext.getSocketFactory();
            SSLSocket sslSocket = (SSLSocket)socketFactory.createSocket("localhost", overrideServer.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL)));
            sslSocket.setNeedClientAuth(false);
            short apiKey = ApiKeys.PRODUCE.id;
            int correlationId = -1;
            String clientId = "";
            int ackTimeoutMs = 10000;
            short ack = 0;
            ProduceRequest emptyRequest = (ProduceRequest)new ProduceRequest.Builder(2, ack, ackTimeoutMs, new HashMap()).build();
            RequestHeader emptyHeader = new RequestHeader(apiKey, emptyRequest.version(), clientId, correlationId);
            ByteBuffer byteBuffer = emptyRequest.serialize(emptyHeader);
            byteBuffer.rewind();
            byte[] serializedBytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(serializedBytes);
            this.sendRequest(sslSocket, serializedBytes, this.sendRequest$default$3());
            this.processRequest(overrideServer.requestChannel());
            Assert.assertEquals((Object)Predef$.MODULE$.byteArrayOps(serializedBytes).toSeq(), (Object)Predef$.MODULE$.byteArrayOps(this.receiveResponse(sslSocket)).toSeq());
            sslSocket.close();
        }
        catch (Throwable throwable) {
            void var19_19;
            void var20_20;
            var20_20.shutdown();
            var19_19.close();
            throw throwable;
        }
        overrideServer.shutdown();
        serverMetrics.close();
    }

    @Test
    public void testSessionPrincipal() {
        Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());
        byte[] bytes = new byte[40];
        this.sendRequest(socket, bytes, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)0)));
        Assert.assertEquals((Object)KafkaPrincipal.ANONYMOUS, (Object)this.server().requestChannel().receiveRequest(2000L).session().principal());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClientDisconnectionUpdatesRequestMetrics() {
        int x$64 = 0;
        String x$65 = TestUtils$.MODULE$.MockZkConnect();
        int x$66 = 0;
        boolean x$67 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$68 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$69 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$70 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$71 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$72 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$73 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$74 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$75 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$76 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$77 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$78 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$79 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$64, x$65, x$67, x$68, x$66, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79);
        Metrics serverMetrics = new Metrics();
        ObjectRef conn = ObjectRef.create(null);
        SocketServer overrideServer = new SocketServer(this, props, serverMetrics, conn){
            public final ObjectRef conn$1;

            public Processor newProcessor(int id, ConnectionQuotas connectionQuotas, ListenerName listenerName, SecurityProtocol protocol) {
                return new Processor(this, id, connectionQuotas, listenerName, protocol){
                    private final /* synthetic */ $anon$2 $outer;

                    public void sendResponse(RequestChannel.Response response, Send responseSend) {
                        ((Socket)this.$outer.conn$1.elem).close();
                        super.sendResponse(response, responseSend);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super(id$1, $outer.time(), Predef$.MODULE$.Integer2int($outer.config().socketRequestMaxBytes()), $outer.requestChannel(), connectionQuotas$1, Predef$.MODULE$.Long2long($outer.config().connectionsMaxIdleMs()), listenerName$1, protocol$1, $outer.config(), $outer.metrics(), $outer.credentialProvider());
                    }
                };
            }
            {
                this.conn$1 = conn$1;
                super(KafkaConfig$.MODULE$.fromProps(props$1), serverMetrics$1, Time.SYSTEM, $outer.credentialProvider());
            }
        };
        try {
            overrideServer.startup();
            conn.elem = this.connect(overrideServer, this.connect$default$2());
            byte[] serializedBytes = this.producerRequestBytes();
            this.sendRequest((Socket)conn.elem, serializedBytes, this.sendRequest$default$3());
            RequestChannel channel = overrideServer.requestChannel();
            RequestChannel.Request request = channel.receiveRequest(2000L);
            RequestMetrics requestMetrics = (RequestMetrics)RequestMetrics$.MODULE$.metricsMap().apply((Object)ApiKeys.forId((int)request.requestId()).name);
            long expectedTotalTimeCount = this.kafka$network$SocketServerTest$$totalTimeHistCount$1(requestMetrics) + 1L;
            NetworkSend send = new NetworkSend(request.connectionId(), ByteBuffer.allocate(550000));
            channel.sendResponse(RequestChannel.Response$.MODULE$.apply(request, (Send)send));
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, requestMetrics, expectedTotalTimeCount){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SocketServerTest $outer;
                private final RequestMetrics requestMetrics$1;
                private final long expectedTotalTimeCount$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.$outer.kafka$network$SocketServerTest$$totalTimeHistCount$1(this.requestMetrics$1) == this.expectedTotalTimeCount$1;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.requestMetrics$1 = requestMetrics$1;
                    this.expectedTotalTimeCount$1 = expectedTotalTimeCount$1;
                }
            }, (Function0<String>)new Serializable(this, requestMetrics, expectedTotalTimeCount){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SocketServerTest $outer;
                private final RequestMetrics requestMetrics$1;
                private final long expectedTotalTimeCount$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request metrics not updated, expected: ", ", actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.expectedTotalTimeCount$1), BoxesRunTime.boxToLong((long)this.$outer.kafka$network$SocketServerTest$$totalTimeHistCount$1(this.requestMetrics$1))}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.requestMetrics$1 = requestMetrics$1;
                    this.expectedTotalTimeCount$1 = expectedTotalTimeCount$1;
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        }
        catch (Throwable throwable) {
            void var18_18;
            void var20_20;
            var20_20.shutdown();
            var18_18.close();
            throw throwable;
        }
        overrideServer.shutdown();
        serverMetrics.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerSendAfterChannelClosedUpdatesRequestMetrics() {
        int x$80 = 0;
        String x$81 = TestUtils$.MODULE$.MockZkConnect();
        int x$82 = 0;
        boolean x$83 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$84 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$85 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$86 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$87 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$88 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$89 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$90 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$91 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$92 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$93 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$94 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$95 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$80, x$81, x$83, x$84, x$82, x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$95);
        props.setProperty(KafkaConfig$.MODULE$.ConnectionsMaxIdleMsProp(), "100");
        Metrics serverMetrics = new Metrics();
        Socket conn = null;
        SocketServer overrideServer = new SocketServer(KafkaConfig$.MODULE$.fromProps(props), serverMetrics, Time.SYSTEM, this.credentialProvider());
        try {
            overrideServer.startup();
            conn = this.connect(overrideServer, this.connect$default$2());
            byte[] serializedBytes = this.producerRequestBytes();
            this.sendRequest(conn, serializedBytes, this.sendRequest$default$3());
            RequestChannel channel = overrideServer.requestChannel();
            RequestChannel.Request request = channel.receiveRequest(2000L);
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, overrideServer, request){
                public static final long serialVersionUID = 0L;
                private final SocketServer overrideServer$2;
                private final RequestChannel.Request request$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.overrideServer$2.processor(this.request$1.processor()).channel(this.request$1.connectionId()).isEmpty();
                }
                {
                    this.overrideServer$2 = overrideServer$2;
                    this.request$1 = request$1;
                }
            }, (Function0<String>)new Serializable(this, request){
                public static final long serialVersionUID = 0L;
                private final RequestChannel.Request request$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Idle connection `", "` was not closed by selector"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.request$1.connectionId()}));
                }
                {
                    this.request$1 = request$1;
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            RequestMetrics requestMetrics = (RequestMetrics)RequestMetrics$.MODULE$.metricsMap().apply((Object)ApiKeys.forId((int)request.requestId()).name);
            long expectedTotalTimeCount = this.kafka$network$SocketServerTest$$totalTimeHistCount$2(requestMetrics) + 1L;
            this.processRequest(channel, request);
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, requestMetrics, expectedTotalTimeCount){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SocketServerTest $outer;
                private final RequestMetrics requestMetrics$2;
                private final long expectedTotalTimeCount$2;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.$outer.kafka$network$SocketServerTest$$totalTimeHistCount$2(this.requestMetrics$2) == this.expectedTotalTimeCount$2;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.requestMetrics$2 = requestMetrics$2;
                    this.expectedTotalTimeCount$2 = expectedTotalTimeCount$2;
                }
            }, (Function0<String>)new Serializable(this, requestMetrics, expectedTotalTimeCount){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SocketServerTest $outer;
                private final RequestMetrics requestMetrics$2;
                private final long expectedTotalTimeCount$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request metrics not updated, expected: ", ", actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.expectedTotalTimeCount$2), BoxesRunTime.boxToLong((long)this.$outer.kafka$network$SocketServerTest$$totalTimeHistCount$2(this.requestMetrics$2))}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.requestMetrics$2 = requestMetrics$2;
                    this.expectedTotalTimeCount$2 = expectedTotalTimeCount$2;
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        }
        catch (Throwable throwable) {
            void var18_18;
            void var20_20;
            var20_20.shutdown();
            var18_18.close();
            throw throwable;
        }
        overrideServer.shutdown();
        serverMetrics.close();
    }

    @Test
    public void testMetricCollectionAfterShutdown() {
        this.server().shutdown();
        Map nonZeroMetricNamesAndValues = (Map)((TraversableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(com.yammer.metrics.Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(com.yammer.metrics.core.MetricName k) {
                return k.getName().endsWith("IdlePercent") || k.getName().endsWith("NetworkProcessorAvgIdlePercent");
            }
        }).collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<com.yammer.metrics.core.MetricName, Metric>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    com.yammer.metrics.core.MetricName k = (com.yammer.metrics.core.MetricName)A1._1();
                    Metric metric = (Metric)A1._2();
                    if (metric instanceof Gauge) {
                        Gauge gauge = (Gauge)metric;
                        object = new Tuple2((Object)k, (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)gauge.value())));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<com.yammer.metrics.core.MetricName, Metric> x1) {
                Metric metric;
                Tuple2<com.yammer.metrics.core.MetricName, Metric> tuple2 = x1;
                boolean bl = tuple2 != null && (metric = (Metric)tuple2._2()) instanceof Gauge;
                return bl;
            }
        }, Map$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<com.yammer.metrics.core.MetricName, Object> x0$1) {
                Tuple2<com.yammer.metrics.core.MetricName, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    double value = tuple2._2$mcD$sp();
                    boolean bl = value != 0.0;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)nonZeroMetricNamesAndValues);
    }

    @Test
    public void testProcessorMetricsTags() {
        Set kafkaMetricNames = (Set)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.metrics().metrics().keySet()).asScala()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$4) {
                return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(x$4.tags()).asScala()).get((Object)"listener").nonEmpty();
            }
        });
        Assert.assertFalse((boolean)kafkaMetricNames.isEmpty());
        scala.collection.immutable.Set expectedListeners = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PLAINTEXT", "TRACE"}));
        kafkaMetricNames.foreach((Function1)new Serializable(this, expectedListeners){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set expectedListeners$1;

            public final void apply(MetricName kafkaMetricName) {
                Assert.assertTrue((boolean)this.expectedListeners$1.contains(kafkaMetricName.tags().get("listener")));
            }
            {
                this.expectedListeners$1 = expectedListeners$1;
            }
        });
        Iterable yammerMetricsNames = (Iterable)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(com.yammer.metrics.Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(com.yammer.metrics.core.MetricName x$5) {
                return x$5.getType().equals("Processor");
            }
        }).collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<com.yammer.metrics.core.MetricName, Metric>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    com.yammer.metrics.core.MetricName k = (com.yammer.metrics.core.MetricName)A1._1();
                    if (A1._2() instanceof Gauge) {
                        object = k;
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<com.yammer.metrics.core.MetricName, Metric> x2) {
                Tuple2<com.yammer.metrics.core.MetricName, Metric> tuple2 = x2;
                boolean bl = tuple2 != null && tuple2._2() instanceof Gauge;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        Assert.assertFalse((boolean)yammerMetricsNames.isEmpty());
        yammerMetricsNames.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(com.yammer.metrics.core.MetricName yammerMetricName) {
                Assert.assertFalse((boolean)yammerMetricName.getMBeanName().contains("listener="));
            }
        });
    }

    public final long kafka$network$SocketServerTest$$totalTimeHistCount$1(RequestMetrics requestMetrics$1) {
        return requestMetrics$1.totalTimeHist().count();
    }

    public final long kafka$network$SocketServerTest$$totalTimeHistCount$2(RequestMetrics requestMetrics$2) {
        return requestMetrics$2.totalTimeHist().count();
    }

    public SocketServerTest() {
        int x$6 = 0;
        String x$7 = TestUtils$.MODULE$.MockZkConnect();
        int x$8 = 0;
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$11 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$12 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$13 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$15 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$16 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$17 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$18 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$19 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$20 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$21 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        this.props = TestUtils$.MODULE$.createBrokerConfig(x$6, x$7, x$9, x$10, x$8, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        this.props().put("listeners", "PLAINTEXT://localhost:0,TRACE://localhost:0");
        this.props().put("num.network.threads", "1");
        this.props().put("socket.send.buffer.bytes", "300000");
        this.props().put("socket.receive.buffer.bytes", "300000");
        this.props().put("queued.max.requests", "50");
        this.props().put("socket.request.max.bytes", "50");
        this.props().put("max.connections.per.ip", "5");
        this.props().put("connections.max.idle.ms", "60000");
        this.config = KafkaConfig$.MODULE$.fromProps(this.props());
        this.metrics = new Metrics();
        this.credentialProvider = new CredentialProvider(this.config().saslEnabledMechanisms());
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(com.yammer.metrics.Metrics.defaultRegistry().allMetrics().keySet()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(com.yammer.metrics.core.MetricName metricName) {
                com.yammer.metrics.Metrics.defaultRegistry().removeMetric(metricName);
            }
        });
        this.server = new SocketServer(this.config(), this.metrics(), Time.SYSTEM, this.credentialProvider());
        this.server().startup();
        this.sockets = new ArrayBuffer();
    }
}

