/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.checkpoints;

import java.io.IOException;
import kafka.server.checkpoints.CheckpointFile;
import kafka.server.checkpoints.CheckpointFileFormatter;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u00053A!\u0001\u0002\u0001\u0013\tArJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016$Vm\u001d;\u000b\u0005\r!\u0011aC2iK\u000e\\\u0007o\\5oiNT!!\u0002\u0004\u0002\rM,'O^3s\u0015\u00059\u0011!B6bM.\f7\u0001A\n\u0004\u0001)!\u0002CA\u0006\u0013\u001b\u0005a!BA\u0007\u000f\u0003\u0015QWO\\5u\u0015\ty\u0001#A\u0005tG\u0006d\u0017\r^3ti*\t\u0011#A\u0002pe\u001eL!a\u0005\u0007\u0003\u0015)+f.\u001b;Tk&$X\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\b\u0019><w-\u001b8h\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0003!\u0001\u0011\u0005\u0011%\u0001\u0014tQ>,H\u000e\u001a)feNL7\u000f^!oI>3XM]<sSR,\u0017I\u001c3SK2|\u0017\r\u001a$jY\u0016$\u0012A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0005+:LG\u000f\u000b\u0002 SA\u0011!\u0006L\u0007\u0002W)\u0011Q\u0002E\u0005\u0003[-\u0012A\u0001V3ti\")q\u0006\u0001C\u0001C\u0005I2\u000f[8vY\u0012D\u0015M\u001c3mK6+H\u000e^5qY\u0016d\u0015N\\3tQ\tq\u0013\u0006C\u00033\u0001\u0011\u0005\u0011%\u0001\u0011tQ>,H\u000e\u001a*fiV\u0014h.R7qifl\u0015\r\u001d$pe\u0016k\u0007\u000f^=GS2,\u0007FA\u0019*\u0011\u0015)\u0004\u0001\"\u0001\"\u0003\r\u001a\bn\\;mIRC'o\\<JMZ+'o]5p]&\u001bhj\u001c;SK\u000e|wM\\5tK\u0012DC\u0001N\u00158q\u0005AQ\r\u001f9fGR,GmI\u0001:!\tQt(D\u0001<\u0015\taT(\u0001\u0002j_*\ta(\u0001\u0003kCZ\f\u0017B\u0001!<\u0005-Iu*\u0012=dKB$\u0018n\u001c8")
public class OffsetCheckpointFileTest
extends JUnitSuite
implements Logging {
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        OffsetCheckpointFileTest offsetCheckpointFileTest = this;
        synchronized (offsetCheckpointFileTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Test
    public void shouldPersistAndOverwriteAndReloadFile() {
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils$.MODULE$.tempFile());
        Map offsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 2)), (Object)BoxesRunTime.boxToLong((long)10L))}));
        checkpoint.write(offsets);
        Assert.assertEquals((Object)offsets, (Object)checkpoint.read());
        Map offsets2 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)BoxesRunTime.boxToLong((long)15L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 3)), (Object)BoxesRunTime.boxToLong((long)20L))}));
        checkpoint.write(offsets2);
        Assert.assertEquals((Object)offsets2, (Object)checkpoint.read());
    }

    @Test
    public void shouldHandleMultipleLines() {
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils$.MODULE$.tempFile());
        Map offsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 6)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 7)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 8)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 4)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 9)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 10)), (Object)BoxesRunTime.boxToLong((long)10L))}));
        checkpoint.write(offsets);
        Assert.assertEquals((Object)offsets, (Object)checkpoint.read());
    }

    @Test
    public void shouldReturnEmptyMapForEmptyFile() {
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils$.MODULE$.tempFile());
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)checkpoint.read());
        checkpoint.write((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)checkpoint.read());
    }

    @Test(expected=IOException.class)
    public void shouldThrowIfVersionIsNotRecognised() {
        CheckpointFile checkpointFile = new CheckpointFile(TestUtils$.MODULE$.tempFile(), OffsetCheckpointFile$.MODULE$.CurrentVersion() + 1, (CheckpointFileFormatter)OffsetCheckpointFile.Formatter$.MODULE$);
        checkpointFile.write((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)BoxesRunTime.boxToLong((long)10L))})));
        new OffsetCheckpointFile(checkpointFile.file()).read();
    }

    public OffsetCheckpointFileTest() {
        Logging.class.$init$((Logging)this);
    }
}

