/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.ConsumerGroupCommand;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConsumerGroupCommand$
implements Logging {
    public static final ConsumerGroupCommand$ MODULE$;
    private final String MISSING_COLUMN_VALUE;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ConsumerGroupCommand$();
    }

    private Logger logger$lzycompute() {
        ConsumerGroupCommand$ consumerGroupCommand$ = this;
        synchronized (consumerGroupCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        block11: {
            ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(args);
            if (args.length == 0) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "List all consumer groups, describe a consumer group, delete consumer group info, or reset consumer group offsets.");
            }
            int actions = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.listOpt(), opts.describeOpt(), opts.deleteOpt(), opts.resetOffsetsOpt()}))).count((Function1)new Serializable(opts){
                public static final long serialVersionUID = 0L;
                private final ConsumerGroupCommand.ConsumerGroupCommandOptions opts$1;

                public final boolean apply(OptionSpec<?> x$1) {
                    return this.opts$1.options().has(x$1);
                }
                {
                    this.opts$1 = opts$1;
                }
            });
            if (actions != 1) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --list, --describe, --delete, --reset-offsets");
            }
            opts.checkArgs();
            ConsumerGroupCommand.ConsumerGroupService consumerGroupService = new ConsumerGroupCommand.ConsumerGroupService(opts);
            try {
                try {
                    if (opts.options().has((OptionSpec)opts.listOpt())) {
                        consumerGroupService.listGroups().foreach((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final void apply(String x$1) {
                                Predef$.MODULE$.println((Object)x$1);
                            }
                        });
                        break block11;
                    }
                    if (opts.options().has((OptionSpec)opts.describeOpt())) {
                        consumerGroupService.describeGroup();
                        break block11;
                    }
                    if (opts.options().has((OptionSpec)opts.deleteOpt())) {
                        consumerGroupService.deleteGroups();
                        break block11;
                    }
                    if (!opts.options().has((OptionSpec)opts.resetOffsetsOpt())) break block11;
                    Map<TopicPartition, OffsetAndMetadata> offsetsToReset = consumerGroupService.resetOffsets();
                    if (opts.options().has((OptionSpec)opts.exportOpt())) {
                        String exported = consumerGroupService.exportOffsetsToReset(offsetsToReset);
                        Predef$.MODULE$.println((Object)exported);
                        break block11;
                    }
                    this.printOffsetsToReset(offsetsToReset);
                }
                catch (Throwable throwable) {
                    this.printError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executing consumer group command failed due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{throwable.getMessage()})), (Option<Throwable>)new Some((Object)throwable));
                }
            }
            finally {
                consumerGroupService.close();
            }
        }
    }

    public String MISSING_COLUMN_VALUE() {
        return this.MISSING_COLUMN_VALUE;
    }

    public void printError(String msg, Option<Throwable> e) {
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg})));
        e.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Throwable x$2) {
                x$2.printStackTrace();
            }
        });
    }

    public Option<Throwable> printError$default$2() {
        return None$.MODULE$;
    }

    public Long convertTimestamp(String timeString) {
        Date date;
        String string = timeString;
        String string2 = string.split("T")[1].contains("+") || string.split("T")[1].contains("-") || string.split("T")[1].contains("Z") ? string.toString() : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "Z"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string}));
        String datetime = string2;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").parse(datetime);
        }
        catch (ParseException parseException) {
            date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX").parse(datetime);
        }
        Date date2 = date;
        return Predef$.MODULE$.long2Long(date2.getTime());
    }

    public void printOffsetsToReset(Map<TopicPartition, OffsetAndMetadata> groupAssignmentsToReset) {
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("\n%-30s %-10s %-15s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"TOPIC", "PARTITION", "NEW-OFFSET"})));
        groupAssignmentsToReset.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<TopicPartition, OffsetAndMetadata> x0$1) {
                Tuple2<TopicPartition, OffsetAndMetadata> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition consumerAssignment = (TopicPartition)tuple2._1();
                    OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)tuple2._2();
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%-30s %-10s %-15s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{consumerAssignment.topic(), BoxesRunTime.boxToInteger((int)consumerAssignment.partition()), BoxesRunTime.boxToLong((long)offsetAndMetadata.offset())})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    private ConsumerGroupCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.MISSING_COLUMN_VALUE = "-";
    }
}

