/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.TimeUnit;
import kafka.cluster.BrokerEndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndFetcherId;
import kafka.server.BrokerIdAndFetcherId;
import kafka.server.ClientIdTopicPartition;
import kafka.server.FetcherLagMetrics;
import kafka.server.InitialFetchState;
import kafka.server.OffsetAndEpoch;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed!B\u0001\u0003\u0003\u00039!AF!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:NC:\fw-\u001a:\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001)\"\u0001C\u001b\u0014\t\u0001Iq\"\u0006\t\u0003\u00155i\u0011a\u0003\u0006\u0002\u0019\u0005)1oY1mC&\u0011ab\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005A\u0019R\"A\t\u000b\u0005I!\u0011!B;uS2\u001c\u0018B\u0001\u000b\u0012\u0005\u001daunZ4j]\u001e\u0004\"AF\r\u000e\u0003]Q!\u0001\u0007\u0003\u0002\u000f5,GO]5dg&\u0011!d\u0006\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002\u0003\u000f\u0001\u0005\u000b\u0007I\u0011A\u000f\u0002\t9\fW.Z\u000b\u0002=A\u0011qD\t\b\u0003\u0015\u0001J!!I\u0006\u0002\rA\u0013X\rZ3g\u0013\t\u0019CE\u0001\u0004TiJLgn\u001a\u0006\u0003C-A\u0001B\n\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0006]\u0006lW\r\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005=\u0005A1\r\\5f]RLE\r\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0003-qW/\u001c$fi\u000eDWM]:\u0011\u0005)a\u0013BA\u0017\f\u0005\rIe\u000e\u001e\u0005\u0006_\u0001!\t\u0001M\u0001\u0007y%t\u0017\u000e\u001e \u0015\tErt\b\u0011\t\u0004e\u0001\u0019T\"\u0001\u0002\u0011\u0005Q*D\u0002\u0001\u0003\u0006m\u0001\u0011\ra\u000e\u0002\u0002)F\u0011\u0001h\u000f\t\u0003\u0015eJ!AO\u0006\u0003\u000f9{G\u000f[5oOB\u0011!\u0007P\u0005\u0003{\t\u0011Q#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG\rC\u0003\u001d]\u0001\u0007a\u0004C\u0003)]\u0001\u0007a\u0004C\u0003+]\u0001\u00071\u0006\u0003\u0005C\u0001\t\u0007I\u0011\u0001\u0002D\u0003A1W\r^2iKJ$\u0006N]3bI6\u000b\u0007/F\u0001E!\u0011)%\nT\u001a\u000e\u0003\u0019S!a\u0012%\u0002\u000f5,H/\u00192mK*\u0011\u0011jC\u0001\u000bG>dG.Z2uS>t\u0017BA&G\u0005\u001dA\u0015m\u001d5NCB\u0004\"AM'\n\u00059\u0013!\u0001\u0006\"s_.,'/\u00133B]\u00124U\r^2iKJLE\r\u0003\u0004Q\u0001\u0001\u0006I\u0001R\u0001\u0012M\u0016$8\r[3s)\"\u0014X-\u00193NCB\u0004\u0003b\u0002*\u0001\u0005\u0004%IaU\u0001\u0005Y>\u001c7.F\u0001U!\t)&,D\u0001W\u0015\t9\u0006,\u0001\u0003mC:<'\"A-\u0002\t)\fg/Y\u0005\u00037Z\u0013aa\u00142kK\u000e$\bBB/\u0001A\u0003%A+A\u0003m_\u000e\\\u0007\u0005C\u0004`\u0001\u0001\u0007I\u0011\u00021\u0002)9,XNR3uG\",'o\u001d)fe\n\u0013xn[3s+\u0005Y\u0003b\u00022\u0001\u0001\u0004%IaY\u0001\u0019]Vlg)\u001a;dQ\u0016\u00148\u000fU3s\u0005J|7.\u001a:`I\u0015\fHC\u00013h!\tQQ-\u0003\u0002g\u0017\t!QK\\5u\u0011\u001dA\u0017-!AA\u0002-\n1\u0001\u001f\u00132\u0011\u0019Q\u0007\u0001)Q\u0005W\u0005)b.^7GKR\u001c\u0007.\u001a:t!\u0016\u0014(I]8lKJ\u0004\u0003\"\u00027\u0001\t\u0003i\u0017\u0001\u0005:fg&TX\r\u00165sK\u0006$\u0007k\\8m)\t!g\u000eC\u0003pW\u0002\u00071&A\u0004oK^\u001c\u0016N_3\t\rE\u0004A\u0011\u0001\u0002s\u0003)9W\r\u001e$fi\u000eDWM\u001d\u000b\u0003gZ\u00042A\u0003;4\u0013\t)8B\u0001\u0004PaRLwN\u001c\u0005\u0006oB\u0004\r\u0001_\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\rI\u00181A\u0007\u0002u*\u00111\u0010`\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015i(B\u0001@\u0000\u0003\u0019\t\u0007/Y2iK*\u0011\u0011\u0011A\u0001\u0004_J<\u0017bAA\u0003u\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0002CA\u0005\u0001\u0011\u0005!!a\u0003\u0002\u0019\u001d,GOR3uG\",'/\u00133\u0015\u0007-\ni\u0001\u0003\u0004x\u0003\u000f\u0001\r\u0001\u001f\u0005\b\u0003#\u0001A\u0011AA\n\u0003mi\u0017M]6QCJ$\u0018\u000e^5p]N4uN\u001d+sk:\u001c\u0017\r^5p]R9A-!\u0006\u0002\u001a\u0005m\u0001bBA\f\u0003\u001f\u0001\raK\u0001\tEJ|7.\u001a:JI\"1q/a\u0004A\u0002aD\u0001\"!\b\u0002\u0010\u0001\u0007\u0011qD\u0001\u0011iJ,hnY1uS>twJ\u001a4tKR\u00042ACA\u0011\u0013\r\t\u0019c\u0003\u0002\u0005\u0019>tw\rC\u0004\u0002(\u00011\t!!\u000b\u0002'\r\u0014X-\u0019;f\r\u0016$8\r[3s)\"\u0014X-\u00193\u0015\u000bM\nY#a\f\t\u000f\u00055\u0012Q\u0005a\u0001W\u0005Ia-\u001a;dQ\u0016\u0014\u0018\n\u001a\u0005\t\u0003c\t)\u00031\u0001\u00024\u0005a1o\\;sG\u0016\u0014%o\\6feB!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:\u0011\tqa\u00197vgR,'/\u0003\u0003\u0002>\u0005]\"A\u0004\"s_.,'/\u00128e!>Lg\u000e\u001e\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0003]\tG\r\u001a$fi\u000eDWM\u001d$peB\u000b'\u000f^5uS>t7\u000fF\u0002e\u0003\u000bB\u0001\"a\u0012\u0002@\u0001\u0007\u0011\u0011J\u0001\u0014a\u0006\u0014H/\u001b;j_:\fe\u000eZ(gMN,Go\u001d\t\b\u0003\u0017\ni\u0005_A)\u001b\u0005A\u0015bAA(\u0011\n\u0019Q*\u00199\u0011\u0007I\n\u0019&C\u0002\u0002V\t\u0011\u0011#\u00138ji&\fGNR3uG\"\u001cF/\u0019;f\u0011\u001d\tI\u0006\u0001C\u0001\u00037\n!D]3n_Z,g)\u001a;dQ\u0016\u0014hi\u001c:QCJ$\u0018\u000e^5p]N$2\u0001ZA/\u0011!\ty&a\u0016A\u0002\u0005\u0005\u0014A\u00039beRLG/[8ogB)\u00111JA2q&\u0019\u0011Q\r%\u0003\u0007M+G\u000fC\u0004\u0002j\u0001!\t!a\u001b\u00025MDW\u000f\u001e3po:LE\r\\3GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ:\u0015\u0003\u0011Dq!a\u001c\u0001\t\u0003\tY'\u0001\tdY>\u001cX-\u00117m\r\u0016$8\r[3sg\u0002")
public abstract class AbstractFetcherManager<T extends AbstractFetcherThread>
implements KafkaMetricsGroup {
    private final String name;
    private final HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap;
    private final Object lock;
    private int numFetchersPerBroker;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.metricName(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.explicitMetricName(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    private Logger logger$lzycompute() {
        AbstractFetcherManager abstractFetcherManager = this;
        synchronized (abstractFetcherManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String name() {
        return this.name;
    }

    public HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap() {
        return this.fetcherThreadMap;
    }

    private Object lock() {
        return this.lock;
    }

    private int numFetchersPerBroker() {
        return this.numFetchersPerBroker;
    }

    private void numFetchersPerBroker_$eq(int x$1) {
        this.numFetchersPerBroker = x$1;
    }

    public void resizeThreadPool(int newSize) {
        Object object = this.lock();
        synchronized (object) {
            int currentSize = this.numFetchersPerBroker();
            this.info((Function0<String>)new Serializable(this, newSize, currentSize){
                public static final long serialVersionUID = 0L;
                private final int newSize$1;
                private final int currentSize$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resizing fetcher thread pool size from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.currentSize$1), BoxesRunTime.boxToInteger((int)this.newSize$1)}));
                }
                {
                    this.newSize$1 = newSize$1;
                    this.currentSize$1 = currentSize$1;
                }
            });
            this.numFetchersPerBroker_$eq(newSize);
            if (newSize != currentSize) {
                this.migratePartitions$1(newSize);
            }
            this.shutdownIdleFetcherThreads();
            return;
        }
    }

    public Option<T> getFetcher(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            int fetcherId = this.getFetcherId(topicPartition);
            Option option = this.fetcherThreadMap().values().find((Function1)new Serializable(this, topicPartition){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;

                public final boolean apply(T fetcherThread) {
                    return ((AbstractFetcherThread)fetcherThread).fetchState(this.topicPartition$1).isDefined();
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                }
            });
            return option;
        }
    }

    public int getFetcherId(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            Integer n = BoxesRunTime.boxToInteger((int)(Utils.abs((int)(31 * topicPartition.topic().hashCode() + topicPartition.partition())) % this.numFetchersPerBroker()));
            return BoxesRunTime.unboxToInt((Object)n);
        }
    }

    public void markPartitionsForTruncation(int brokerId, TopicPartition topicPartition, long truncationOffset) {
        Object object = this.lock();
        synchronized (object) {
            int fetcherId = this.getFetcherId(topicPartition);
            BrokerIdAndFetcherId brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerId, fetcherId);
            this.fetcherThreadMap().get((Object)brokerIdAndFetcherId).foreach((Function1)new Serializable(this, topicPartition, truncationOffset){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$2;
                private final long truncationOffset$1;

                public final void apply(T thread) {
                    ((AbstractFetcherThread)thread).markPartitionsForTruncation(this.topicPartition$2, this.truncationOffset$1);
                }
                {
                    this.topicPartition$2 = topicPartition$2;
                    this.truncationOffset$1 = truncationOffset$1;
                }
            });
            return;
        }
    }

    public abstract T createFetcherThread(int var1, BrokerEndPoint var2);

    public void addFetcherForPartitions(Map<TopicPartition, InitialFetchState> partitionAndOffsets) {
        Object object = this.lock();
        synchronized (object) {
            scala.collection.immutable.Map partitionsPerFetcher = partitionAndOffsets.groupBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AbstractFetcherManager $outer;

                public final BrokerAndFetcherId apply(Tuple2<TopicPartition, InitialFetchState> x0$2) {
                    Tuple2<TopicPartition, InitialFetchState> tuple2 = x0$2;
                    if (tuple2 != null) {
                        TopicPartition topicPartition = (TopicPartition)tuple2._1();
                        InitialFetchState brokerAndInitialFetchOffset = (InitialFetchState)tuple2._2();
                        BrokerAndFetcherId brokerAndFetcherId = new BrokerAndFetcherId(brokerAndInitialFetchOffset.leader(), this.$outer.getFetcherId(topicPartition));
                        return brokerAndFetcherId;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            partitionsPerFetcher.withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<BrokerAndFetcherId, Map<TopicPartition, InitialFetchState>> check$ifrefutable$1) {
                    Tuple2<BrokerAndFetcherId, Map<TopicPartition, InitialFetchState>> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AbstractFetcherManager $outer;

                public final void apply(Tuple2<BrokerAndFetcherId, Map<TopicPartition, InitialFetchState>> x$2) {
                    Tuple2<BrokerAndFetcherId, Map<TopicPartition, InitialFetchState>> tuple2;
                    block2: {
                        Option option;
                        block6: {
                            AbstractFetcherThread abstractFetcherThread;
                            Map initialFetchOffsets;
                            BrokerAndFetcherId brokerAndFetcherId;
                            block4: {
                                BrokerIdAndFetcherId brokerIdAndFetcherId;
                                block5: {
                                    Some some;
                                    boolean bl;
                                    block3: {
                                        tuple2 = x$2;
                                        if (tuple2 == null) break block2;
                                        brokerAndFetcherId = (BrokerAndFetcherId)tuple2._1();
                                        initialFetchOffsets = (Map)tuple2._2();
                                        brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerAndFetcherId.broker().id(), brokerAndFetcherId.fetcherId());
                                        bl = false;
                                        some = null;
                                        option = this.$outer.fetcherThreadMap().get((Object)brokerIdAndFetcherId);
                                        if (!(option instanceof Some)) break block3;
                                        bl = true;
                                        some = (Some)option;
                                        AbstractFetcherThread currentFetcherThread = (AbstractFetcherThread)some.x();
                                        BrokerEndPoint brokerEndPoint = currentFetcherThread.sourceBroker();
                                        BrokerEndPoint brokerEndPoint2 = brokerAndFetcherId.broker();
                                        if (brokerEndPoint != null ? !((Object)brokerEndPoint).equals(brokerEndPoint2) : brokerEndPoint2 != null) break block3;
                                        abstractFetcherThread = currentFetcherThread;
                                        break block4;
                                    }
                                    if (!bl) break block5;
                                    AbstractFetcherThread f = (AbstractFetcherThread)some.x();
                                    f.shutdown();
                                    abstractFetcherThread = this.$outer.kafka$server$AbstractFetcherManager$$addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
                                    break block4;
                                }
                                if (!None$.MODULE$.equals(option)) break block6;
                                abstractFetcherThread = this.$outer.kafka$server$AbstractFetcherManager$$addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
                            }
                            AbstractFetcherThread fetcherThread = abstractFetcherThread;
                            Map initialOffsetAndEpochs = (Map)initialFetchOffsets.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Tuple2<TopicPartition, OffsetAndEpoch> apply(Tuple2<TopicPartition, InitialFetchState> x0$3) {
                                    Tuple2<TopicPartition, InitialFetchState> tuple2 = x0$3;
                                    if (tuple2 != null) {
                                        TopicPartition tp = (TopicPartition)tuple2._1();
                                        InitialFetchState brokerAndInitOffset = (InitialFetchState)tuple2._2();
                                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetAndEpoch(brokerAndInitOffset.initOffset(), brokerAndInitOffset.currentLeaderEpoch()));
                                        return tuple22;
                                    }
                                    throw new MatchError(tuple2);
                                }
                            }, Map$.MODULE$.canBuildFrom());
                            fetcherThread.addPartitions((Map<TopicPartition, OffsetAndEpoch>)initialOffsetAndEpochs);
                            this.$outer.info((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final BrokerAndFetcherId brokerAndFetcherId$1;
                                private final Map initialOffsetAndEpochs$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Added fetcher to broker ", " for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.brokerAndFetcherId$1.broker(), this.initialOffsetAndEpochs$1}));
                                }
                                {
                                    this.brokerAndFetcherId$1 = brokerAndFetcherId$1;
                                    this.initialOffsetAndEpochs$1 = initialOffsetAndEpochs$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError((Object)option);
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
    }

    public void removeFetcherForPartitions(Set<TopicPartition> partitions) {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().values().foreach((Function1)new Serializable(this, partitions){
                public static final long serialVersionUID = 0L;
                private final Set partitions$1;

                public final void apply(T fetcher) {
                    ((AbstractFetcherThread)fetcher).removePartitions((Set<TopicPartition>)this.partitions$1);
                }
                {
                    this.partitions$1 = partitions$1;
                }
            });
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
            this.info((Function0<String>)new Serializable(this, partitions){
                public static final long serialVersionUID = 0L;
                private final Set partitions$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removed fetcher for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitions$1}));
                }
                {
                    this.partitions$1 = partitions$1;
                }
            });
            return;
        }
    }

    public void shutdownIdleFetcherThreads() {
        Object object = this.lock();
        synchronized (object) {
            HashSet keysToBeRemoved = new HashSet();
            this.fetcherThreadMap().withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<BrokerIdAndFetcherId, T> check$ifrefutable$2) {
                    Tuple2<BrokerIdAndFetcherId, T> tuple2 = check$ifrefutable$2;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, keysToBeRemoved){
                public static final long serialVersionUID = 0L;
                private final HashSet keysToBeRemoved$1;

                public final Object apply(Tuple2<BrokerIdAndFetcherId, T> x$3) {
                    Tuple2<BrokerIdAndFetcherId, T> tuple2 = x$3;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        BrokerIdAndFetcherId key = (BrokerIdAndFetcherId)tuple2._1();
                        AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
                        if (fetcher.partitionCount() <= 0) {
                            fetcher.shutdown();
                            boxedUnit = this.keysToBeRemoved$1.$plus$eq((Object)key);
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return boxedUnit2;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.keysToBeRemoved$1 = keysToBeRemoved$1;
                }
            });
            this.fetcherThreadMap().$minus$minus$eq((TraversableOnce)keysToBeRemoved);
            return;
        }
    }

    public void closeAllFetchers() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<BrokerIdAndFetcherId, T> check$ifrefutable$3) {
                    Tuple2<BrokerIdAndFetcherId, T> tuple2 = check$ifrefutable$3;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<BrokerIdAndFetcherId, T> x$4) {
                    Tuple2<BrokerIdAndFetcherId, T> tuple2 = x$4;
                    if (tuple2 != null) {
                        AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
                        boolean bl = fetcher.initiateShutdown();
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
            });
            this.fetcherThreadMap().withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<BrokerIdAndFetcherId, T> check$ifrefutable$4) {
                    Tuple2<BrokerIdAndFetcherId, T> tuple2 = check$ifrefutable$4;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<BrokerIdAndFetcherId, T> x$5) {
                    Tuple2<BrokerIdAndFetcherId, T> tuple2 = x$5;
                    if (tuple2 != null) {
                        AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
                        fetcher.shutdown();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            this.fetcherThreadMap().clear();
            return;
        }
    }

    private final void migratePartitions$1(int newSize) {
        this.fetcherThreadMap().foreach((Function1)new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractFetcherManager $outer;
            private final int newSize$2;

            public final void apply(Tuple2<BrokerIdAndFetcherId, T> x0$1) {
                Tuple2<BrokerIdAndFetcherId, T> tuple2 = x0$1;
                if (tuple2 != null) {
                    BrokerIdAndFetcherId id = (BrokerIdAndFetcherId)tuple2._1();
                    AbstractFetcherThread thread = (AbstractFetcherThread)tuple2._2();
                    Map<TopicPartition, InitialFetchState> removedPartitions = thread.partitionsAndOffsets();
                    this.$outer.removeFetcherForPartitions((Set<TopicPartition>)removedPartitions.keySet());
                    if (id.fetcherId() >= this.newSize$2) {
                        thread.shutdown();
                    }
                    this.$outer.addFetcherForPartitions(removedPartitions);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newSize$2 = newSize$2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final AbstractFetcherThread kafka$server$AbstractFetcherManager$$addAndStartFetcherThread$1(BrokerAndFetcherId brokerAndFetcherId, BrokerIdAndFetcherId brokerIdAndFetcherId) {
        void var3_3;
        T fetcherThread = this.createFetcherThread(brokerAndFetcherId.fetcherId(), brokerAndFetcherId.broker());
        this.fetcherThreadMap().put((Object)brokerIdAndFetcherId, fetcherThread);
        ((Thread)fetcherThread).start();
        return var3_3;
    }

    public AbstractFetcherManager(String name, String clientId2, int numFetchers) {
        this.name = name;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.fetcherThreadMap = new HashMap();
        this.lock = new Object();
        this.numFetchersPerBroker = numFetchers;
        this.logIdent_$eq(new StringBuilder().append((Object)"[").append((Object)name).append((Object)"] ").toString());
        this.newGauge("MaxLag", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public long value() {
                return BoxesRunTime.unboxToLong((Object)this.$outer.fetcherThreadMap().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(long curMaxAll, Tuple2<BrokerIdAndFetcherId, T> fetcherThreadMapEntry) {
                        return RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)((AbstractFetcherThread)fetcherThreadMapEntry._2()).fetcherLagStats().stats().foldLeft(BoxesRunTime.boxToLong((long)0L), new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(long curMaxThread, Tuple2<ClientIdTopicPartition, FetcherLagMetrics> fetcherLagStatsEntry) {
                                return RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(curMaxThread), ((FetcherLagMetrics)fetcherLagStatsEntry._2()).lag());
                            }
                        }))), curMaxAll);
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId2)}))));
        this.newGauge("MinFetchRate", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public double value() {
                double headRate = BoxesRunTime.unboxToDouble((Object)this.$outer.fetcherThreadMap().headOption().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<BrokerIdAndFetcherId, T> x$1) {
                        return ((AbstractFetcherThread)x$1._2()).fetcherStats().requestRate().oneMinuteRate();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return 0.0;
                    }
                }));
                return BoxesRunTime.unboxToDouble((Object)this.$outer.fetcherThreadMap().foldLeft((Object)BoxesRunTime.boxToDouble((double)headRate), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double curMinAll, Tuple2<BrokerIdAndFetcherId, T> fetcherThreadMapEntry) {
                        return RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(((AbstractFetcherThread)fetcherThreadMapEntry._2()).fetcherStats().requestRate().oneMinuteRate()), curMinAll);
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId2)}))));
    }
}

