/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.CachedPartition;
import kafka.server.EvictableKey;
import kafka.server.FetchSession;
import kafka.server.FetchSession$;
import kafka.server.LastUsedKey;
import kafka.utils.Logging$class;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.utils.ImplicitLinkedHashSet;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0001\u0003\u0001\u001d\u0011\u0011CR3uG\"\u001cVm]:j_:\u001c\u0015m\u00195f\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\t\u001dQ\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\u0011\u0005UAR\"\u0001\f\u000b\u0005]!\u0011aB7fiJL7m]\u0005\u00033Y\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0011!Y\u0002A!b\u0001\n\u0013a\u0012AC7bq\u0016sGO]5fgV\tQ\u0004\u0005\u0002\n=%\u0011qD\u0003\u0002\u0004\u0013:$\b\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002\u00175\f\u00070\u00128ue&,7\u000f\t\u0005\tG\u0001\u0011)\u0019!C\u0005I\u0005QQM^5di&|g.T:\u0016\u0003\u0015\u0002\"!\u0003\u0014\n\u0005\u001dR!\u0001\u0002'p]\u001eD\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006I!J\u0001\fKZL7\r^5p]6\u001b\b\u0005C\u0003,\u0001\u0011\u0005A&\u0001\u0004=S:LGO\u0010\u000b\u0004[=\u0002\u0004C\u0001\u0018\u0001\u001b\u0005\u0011\u0001\"B\u000e+\u0001\u0004i\u0002\"B\u0012+\u0001\u0004)\u0003b\u0002\u001a\u0001\u0001\u0004%I\u0001J\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\u000fQ\u0002\u0001\u0019!C\u0005k\u0005\tb.^7QCJ$\u0018\u000e^5p]N|F%Z9\u0015\u0005YJ\u0004CA\u00058\u0013\tA$B\u0001\u0003V]&$\bb\u0002\u001e4\u0003\u0003\u0005\r!J\u0001\u0004q\u0012\n\u0004B\u0002\u001f\u0001A\u0003&Q%\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\t\u000fy\u0002!\u0019!C\u0005\u007f\u0005A1/Z:tS>t7/F\u0001A!\u0011\te)\b%\u000e\u0003\tS!a\u0011#\u0002\u000f5,H/\u00192mK*\u0011QIC\u0001\u000bG>dG.Z2uS>t\u0017BA$C\u0005\u001dA\u0015m\u001d5NCB\u0004\"AL%\n\u0005)\u0013!\u0001\u0004$fi\u000eD7+Z:tS>t\u0007B\u0002'\u0001A\u0003%\u0001)A\u0005tKN\u001c\u0018n\u001c8tA!9a\n\u0001b\u0001\n\u0013y\u0015\u0001\u00037bgR,6/\u001a3\u0016\u0003A\u0003B!\u0015,Y\u00116\t!K\u0003\u0002T)\u0006!Q\u000f^5m\u0015\u0005)\u0016\u0001\u00026bm\u0006L!a\u0016*\u0003\u000fQ\u0013X-Z'baB\u0011a&W\u0005\u00035\n\u00111\u0002T1tiV\u001bX\rZ&fs\"1A\f\u0001Q\u0001\nA\u000b\u0011\u0002\\1tiV\u001bX\r\u001a\u0011\t\u000fy\u0003!\u0019!C\u0005?\u0006qQM^5di\u0006\u0014G.\u001a\"z\u00032dW#\u00011\u0011\tE3\u0016\r\u0013\t\u0003]\tL!a\u0019\u0002\u0003\u0019\u00153\u0018n\u0019;bE2,7*Z=\t\r\u0015\u0004\u0001\u0015!\u0003a\u0003=)g/[2uC\ndWMQ=BY2\u0004\u0003bB4\u0001\u0005\u0004%IaX\u0001\u0016KZL7\r^1cY\u0016\u0014\u0015\u0010\u0015:jm&dWmZ3e\u0011\u0019I\u0007\u0001)A\u0005A\u00061RM^5di\u0006\u0014G.\u001a\"z!JLg/\u001b7fO\u0016$\u0007\u0005C\u0004l\u0001\t\u0007I\u0011\u00017\u0002\u001d\u00154\u0018n\u0019;j_:\u001cX*\u001a;feV\tQ\u000e\u0005\u0002om6\tqN\u0003\u0002qc\u0006!1m\u001c:f\u0015\t9\"O\u0003\u0002ti\u00061\u00110Y7nKJT\u0011!^\u0001\u0004G>l\u0017BA<p\u0005\u0015iU\r^3s\u0011\u0019I\b\u0001)A\u0005[\u0006yQM^5di&|gn]'fi\u0016\u0014\b\u0005C\u0003|\u0001\u0011\u0005A0A\u0002hKR$2!`A\u0001!\rIa\u0010S\u0005\u0003\u007f*\u0011aa\u00149uS>t\u0007BBA\u0002u\u0002\u0007Q$A\u0005tKN\u001c\u0018n\u001c8JI\"1\u0011q\u0001\u0001\u0005\u0002q\tAa]5{K\"1\u00111\u0002\u0001\u0005\u0002\u0011\nq\u0002^8uC2\u0004\u0016M\u001d;ji&|gn\u001d\u0005\b\u0003\u001f\u0001A\u0011AA\t\u00031qWm^*fgNLwN\\%e)\u0005i\u0002bBA\u000b\u0001\u0011\u0005\u0011qC\u0001\u0013[\u0006L(-Z\"sK\u0006$XmU3tg&|g\u000eF\u0005\u001e\u00033\ti\"a\n\u0002*!9\u00111DA\n\u0001\u0004)\u0013a\u00018po\"A\u0011qDA\n\u0001\u0004\t\t#\u0001\u0006qe&4\u0018\u000e\\3hK\u0012\u00042!CA\u0012\u0013\r\t)C\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\t9!a\u0005A\u0002uA\u0001\"a\u000b\u0002\u0014\u0001\u0007\u0011QF\u0001\u0011GJ,\u0017\r^3QCJ$\u0018\u000e^5p]N\u0004R!CA\u0018\u0003gI1!!\r\u000b\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0003\u00026\u0005mbb\u0001\u0018\u00028%\u0019\u0011\u0011\b\u0002\u0002\u0019\u0019+Go\u00195TKN\u001c\u0018n\u001c8\n\t\u0005u\u0012q\b\u0002\n\u0007\u0006\u001b\u0005*R0N\u0003BS1!!\u000f\u0003\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000b\n\u0001\u0002\u001e:z\u000bZL7\r\u001e\u000b\t\u0003C\t9%!\u0013\u0002N!A\u0011qDA!\u0001\u0004\t\t\u0003C\u0004\u0002L\u0005\u0005\u0003\u0019A1\u0002\u0007-,\u0017\u0010C\u0004\u0002\u001c\u0005\u0005\u0003\u0019A\u0013\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T\u00051!/Z7pm\u0016$2!`A+\u0011\u001d\t\u0019!a\u0014A\u0002uAq!!\u0015\u0001\t\u0003\tI\u0006F\u0002~\u00037Bq!!\u0018\u0002X\u0001\u0007\u0001*A\u0004tKN\u001c\u0018n\u001c8\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d\u0005)Ao\\;dQR)a'!\u001a\u0002h!9\u0011QLA0\u0001\u0004A\u0005bBA\u000e\u0003?\u0002\r!\n")
public class FetchSessionCache
implements KafkaMetricsGroup {
    private final int maxEntries;
    private final long evictionMs;
    private long numPartitions;
    private final HashMap<Object, FetchSession> sessions;
    private final TreeMap<LastUsedKey, FetchSession> lastUsed;
    private final TreeMap<EvictableKey, FetchSession> evictableByAll;
    private final TreeMap<EvictableKey, FetchSession> evictableByPrivileged;
    private final Meter evictionsMeter;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.metricName(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.explicitMetricName(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    private Logger logger$lzycompute() {
        FetchSessionCache fetchSessionCache = this;
        synchronized (fetchSessionCache) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private int maxEntries() {
        return this.maxEntries;
    }

    private long evictionMs() {
        return this.evictionMs;
    }

    private long numPartitions() {
        return this.numPartitions;
    }

    private void numPartitions_$eq(long x$1) {
        this.numPartitions = x$1;
    }

    private HashMap<Object, FetchSession> sessions() {
        return this.sessions;
    }

    private TreeMap<LastUsedKey, FetchSession> lastUsed() {
        return this.lastUsed;
    }

    private TreeMap<EvictableKey, FetchSession> evictableByAll() {
        return this.evictableByAll;
    }

    private TreeMap<EvictableKey, FetchSession> evictableByPrivileged() {
        return this.evictableByPrivileged;
    }

    public Meter evictionsMeter() {
        return this.evictionsMeter;
    }

    public synchronized Option<FetchSession> get(int sessionId2) {
        return this.sessions().get((Object)BoxesRunTime.boxToInteger((int)sessionId2));
    }

    public synchronized int size() {
        return this.sessions().size();
    }

    public synchronized long totalPartitions() {
        return this.numPartitions();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized int newSessionId() {
        void var1_1;
        int id = 0;
        do {
            id = ThreadLocalRandom.current().nextInt(1, Integer.MAX_VALUE);
        } while (this.sessions().contains((Object)BoxesRunTime.boxToInteger((int)id)) || id == 0);
        return (int)var1_1;
    }

    public synchronized int maybeCreateSession(long now, boolean privileged, int size2, Function0<ImplicitLinkedHashSet<CachedPartition>> createPartitions2) {
        int n;
        if (this.sessions().size() < this.maxEntries() || this.tryEvict(privileged, new EvictableKey(privileged, size2, 0), now)) {
            ImplicitLinkedHashSet partitionMap = (ImplicitLinkedHashSet)createPartitions2.apply();
            FetchSession session = new FetchSession(this.newSessionId(), privileged, (ImplicitLinkedHashSet<CachedPartition>)partitionMap, now, now, FetchMetadata.nextEpoch((int)0));
            this.debug((Function0<String>)new Serializable(this, session){
                public static final long serialVersionUID = 0L;
                private final FetchSession session$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created fetch session ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.session$1.toString()}));
                }
                {
                    this.session$1 = session$1;
                }
            });
            this.sessions().put((Object)BoxesRunTime.boxToInteger((int)session.id()), (Object)session);
            this.touch(session, now);
            n = session.id();
        } else {
            this.debug((Function0<String>)new Serializable(this, privileged, size2){
                public static final long serialVersionUID = 0L;
                private final boolean privileged$1;
                private final int size$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No fetch session created for privileged=", ", size=", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)this.privileged$1), BoxesRunTime.boxToInteger((int)this.size$1)}));
                }
                {
                    this.privileged$1 = privileged$1;
                    this.size$1 = size$1;
                }
            });
            n = 0;
        }
        return n;
    }

    public synchronized boolean tryEvict(boolean privileged, EvictableKey key, long now) {
        boolean bl;
        Map.Entry<LastUsedKey, FetchSession> lastUsedEntry = this.lastUsed().firstEntry();
        if (lastUsedEntry == null) {
            this.trace((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "There are no cache entries to evict.";
                }
            });
            bl = false;
        } else if (now - lastUsedEntry.getKey().lastUsedMs() > this.evictionMs()) {
            FetchSession session = lastUsedEntry.getValue();
            this.trace((Function0<String>)new Serializable(this, session){
                public static final long serialVersionUID = 0L;
                private final FetchSession session$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Evicting stale FetchSession ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.session$2.id())}));
                }
                {
                    this.session$2 = session$2;
                }
            });
            this.remove(session);
            this.evictionsMeter().mark();
            bl = true;
        } else {
            TreeMap<EvictableKey, FetchSession> map = privileged ? this.evictableByPrivileged() : this.evictableByAll();
            Map.Entry<EvictableKey, FetchSession> evictableEntry = map.firstEntry();
            if (evictableEntry == null) {
                this.trace((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No evictable entries found.";
                    }
                });
                bl = false;
            } else if (key.compareTo(evictableEntry.getKey()) < 0) {
                this.trace((Function0<String>)new Serializable(this, key, evictableEntry){
                    public static final long serialVersionUID = 0L;
                    private final EvictableKey key$1;
                    private final Map.Entry evictableEntry$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't evict ", " with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.evictableEntry$1.getKey(), this.key$1.toString()}));
                    }
                    {
                        this.key$1 = key$1;
                        this.evictableEntry$1 = evictableEntry$1;
                    }
                });
                bl = false;
            } else {
                this.trace((Function0<String>)new Serializable(this, key, evictableEntry){
                    public static final long serialVersionUID = 0L;
                    private final EvictableKey key$1;
                    private final Map.Entry evictableEntry$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Evicting ", " with ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.evictableEntry$1.getKey(), this.key$1.toString()}));
                    }
                    {
                        this.key$1 = key$1;
                        this.evictableEntry$1 = evictableEntry$1;
                    }
                });
                this.remove(evictableEntry.getValue());
                this.evictionsMeter().mark();
                bl = true;
            }
        }
        return bl;
    }

    public synchronized Option<FetchSession> remove(int sessionId2) {
        Option<FetchSession> option;
        block4: {
            Option<FetchSession> option2;
            block3: {
                block2: {
                    option = this.get(sessionId2);
                    if (!None$.MODULE$.equals(option)) break block2;
                    option2 = None$.MODULE$;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                FetchSession session = (FetchSession)some.x();
                option2 = this.remove(session);
            }
            return option2;
        }
        throw new MatchError(option);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Option<FetchSession> remove(FetchSession session) {
        EvictableKey evictableKey;
        FetchSession fetchSession = session;
        synchronized (fetchSession) {
            this.lastUsed().remove(session.lastUsedKey());
            EvictableKey evictableKey2 = session.evictableKey();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : fetchSession
            evictableKey = evictableKey2;
            this.evictableByAll().remove(evictableKey);
        }
        this.evictableByPrivileged().remove(evictableKey);
        Option removeResult = this.sessions().remove((Object)BoxesRunTime.boxToInteger((int)session.id()));
        if (removeResult.isDefined()) {
            this.numPartitions_$eq(this.numPartitions() - (long)session.cachedSize());
        }
        return removeResult;
    }

    public synchronized void touch(FetchSession session, long now) {
        FetchSession fetchSession = session;
        synchronized (fetchSession) {
            this.lastUsed().remove(session.lastUsedKey());
            session.lastUsedMs_$eq(now);
            this.lastUsed().put(session.lastUsedKey(), session);
            int oldSize = session.cachedSize();
            if (oldSize != -1) {
                EvictableKey oldEvictableKey = session.evictableKey();
                this.evictableByPrivileged().remove(oldEvictableKey);
                this.evictableByAll().remove(oldEvictableKey);
                this.numPartitions_$eq(this.numPartitions() - (long)oldSize);
            }
            session.cachedSize_$eq(session.size());
            EvictableKey newEvictableKey = session.evictableKey();
            FetchSession fetchSession2 = session.privileged() && now - session.creationMs() <= this.evictionMs() ? BoxedUnit.UNIT : this.evictableByPrivileged().put(newEvictableKey, session);
            Object object = now - session.creationMs() > this.evictionMs() ? this.evictableByAll().put(newEvictableKey, session) : BoxedUnit.UNIT;
            this.numPartitions_$eq(this.numPartitions() + (long)session.cachedSize());
            return;
        }
    }

    public FetchSessionCache(int maxEntries, long evictionMs) {
        this.maxEntries = maxEntries;
        this.evictionMs = evictionMs;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.numPartitions = 0L;
        this.sessions = new HashMap();
        this.lastUsed = new TreeMap();
        this.evictableByAll = new TreeMap();
        this.evictableByPrivileged = new TreeMap();
        this.removeMetric(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_SESSISONS(), this.removeMetric$default$2());
        this.newGauge(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_SESSISONS(), new Gauge<Object>(this){
            private final /* synthetic */ FetchSessionCache $outer;

            public int value() {
                return this.$outer.size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.removeMetric(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_PARTITIONS_CACHED(), this.removeMetric$default$2());
        this.newGauge(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_PARTITIONS_CACHED(), new Gauge<Object>(this){
            private final /* synthetic */ FetchSessionCache $outer;

            public long value() {
                return this.$outer.totalPartitions();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.removeMetric(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_EVICTIONS_PER_SEC(), this.removeMetric$default$2());
        this.evictionsMeter = this.newMeter(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_EVICTIONS_PER_SEC(), FetchSession$.MODULE$.EVICTIONS(), TimeUnit.SECONDS, (Map<String, String>)Map$.MODULE$.empty());
    }
}

