/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.Defaults$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0007R3mKR,wJ\u001a4tKR\u001c8i\u001c8tk6,'o\u0012:pkB\u001cu.\\7b]\u0012Le\u000e^3he\u0006$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003\u0015\tG-\\5o\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0006\u000e\u0003\tI!a\u0003\u0002\u00031\r{gn];nKJ<%o\\;q\u0007>lW.\u00198e)\u0016\u001cH\u000fC\u0003\u000e\u0001\u0011\u0005a\"\u0001\u0004=S:LGO\u0010\u000b\u0002\u001fA\u0011\u0011\u0002\u0001\u0005\u0006#\u0001!\tAE\u0001\bO\u0016$\u0018I]4t)\r\u0019\u0002E\t\t\u0004)]IR\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005iibB\u0001\u000b\u001c\u0013\taR#\u0001\u0004Qe\u0016$WMZ\u0005\u0003=}\u0011aa\u0015;sS:<'B\u0001\u000f\u0016\u0011\u0015\t\u0003\u00031\u0001\u001a\u0003\u00159'o\\;q\u0011\u0015\u0019\u0003\u00031\u0001\u001a\u0003\u0015!x\u000e]5d\u0011\u0015)\u0003\u0001\"\u0001'\u0003\u0005\"Xm\u001d;EK2,G/Z(gMN,Go\u001d(p]\u0016C\u0018n\u001d;j]\u001e<%o\\;q)\u00059\u0003C\u0001\u000b)\u0013\tISC\u0001\u0003V]&$\bF\u0001\u0013,!\ta\u0013'D\u0001.\u0015\tqs&A\u0003kk:LGOC\u00011\u0003\ry'oZ\u0005\u0003e5\u0012A\u0001V3ti\")A\u0007\u0001C\u0001M\u0005AD/Z:u\t\u0016dW\r^3PM\u001a\u001cX\r^:PMN#\u0018M\u00197f\u0007>t7/^7fe\u001e\u0013x.\u001e9XSRDGk\u001c9jGB\u000b'\u000f^5uS>t\u0007FA\u001a,\u0011\u00159\u0004\u0001\"\u0001'\u0003M\"Xm\u001d;EK2,G/Z(gMN,Go](g'R\f'\r\\3D_:\u001cX/\\3s\u000fJ|W\u000f],ji\"$v\u000e]5d\u001f:d\u0017\u0010\u000b\u00027W!)!\b\u0001C\u0001M\u0005yD/Z:u\t\u0016dW\r^3PM\u001a\u001cX\r^:PMN#\u0018M\u00197f\u0007>t7/^7fe\u001e\u0013x.\u001e9XSRDWK\\6o_^tGk\u001c9jGB\u000b'\u000f^5uS>t\u0007FA\u001d,\u0011\u0015i\u0004\u0001\"\u0001'\u0003i\"Xm\u001d;EK2,G/Z(gMN,Go](g'R\f'\r\\3D_:\u001cX/\\3s\u000fJ|W\u000f],ji\",fn\u001b8po:$v\u000e]5d\u001f:d\u0017\u0010\u000b\u0002=W!)\u0001\t\u0001C\u0001M\u00059D/Z:u\t\u0016dW\r^3PM\u001a\u001cX\r^:PM\u0016k\u0007\u000f^=D_:\u001cX/\\3s\u000fJ|W\u000f],ji\"$v\u000e]5d!\u0006\u0014H/\u001b;j_:D#aP\u0016\t\u000b\r\u0003A\u0011\u0001\u0014\u0002eQ,7\u000f\u001e#fY\u0016$Xm\u00144gg\u0016$8o\u00144F[B$\u0018pQ8ogVlWM]$s_V\u0004x+\u001b;i)>\u0004\u0018nY(oYfD#AQ\u0016\t\u000b\u0019\u0003A\u0011\u0001\u0014\u0002}Q,7\u000f\u001e#fY\u0016$Xm\u00144gg\u0016$8o\u00144F[B$\u0018pQ8ogVlWM]$s_V\u0004x+\u001b;i+:\\gn\\<o)>\u0004\u0018n\u0019)beRLG/[8oQ\t)5\u0006C\u0003J\u0001\u0011\u0005a%A\u001duKN$H)\u001a7fi\u0016|eMZ:fiN|e-R7qif\u001cuN\\:v[\u0016\u0014xI]8va^KG\u000f[+oW:|wO\u001c+pa&\u001cwJ\u001c7zQ\tA5\u0006C\u0003M\u0001\u0011%Q*A\u000euKN$x+\u001b;i'R\f'\r\\3D_:\u001cX/\\3s\u000fJ|W\u000f\u001d\u000b\u0006O9\u0003Vk\u0016\u0005\u0006\u001f.\u0003\r!G\u0001\u000bS:\u0004X\u000f\u001e+pa&\u001c\u0007\"B)L\u0001\u0004\u0011\u0016AD5oaV$\b+\u0019:uSRLwN\u001c\t\u0003)MK!\u0001V\u000b\u0003\u0007%sG\u000fC\u0003W\u0017\u0002\u0007!+A\tfqB,7\r^3e!\u0006\u0014H/\u001b;j_:DQ\u0001W&A\u0002e\u000bQ\"\u001a=qK\u000e$X\rZ#se>\u0014\bC\u0001.c\u001b\u0005Y&B\u0001/^\u0003!\u0001(o\u001c;pG>d'B\u00010`\u0003\u0019\u0019w.\\7p]*\u0011Q\u0001\u0019\u0006\u0003C>\na!\u00199bG\",\u0017BA2\\\u0005\u0019)%O]8sg\")Q\r\u0001C\u0005M\u0006QB/Z:u/&$\b.R7qif\u001cuN\\:v[\u0016\u0014xI]8vaR)qe\u001a5jU\")q\n\u001aa\u00013!)\u0011\u000b\u001aa\u0001%\")a\u000b\u001aa\u0001%\")\u0001\f\u001aa\u00013\")A\u000e\u0001C\u0005[\u0006)B/Z:u/&$\bnQ8ogVlWM]$s_V\u0004HCB\u0014om^D\u0018\u0010C\u0003pW\u0002\u0007\u0001/A\txSRD7i\u001c8tk6,'o\u0012:pkB\u0004B\u0001F9tO%\u0011!/\u0006\u0002\n\rVt7\r^5p]F\u00022\u0001\u0006;(\u0013\t)XC\u0001\u0005=Eft\u0017-\\3?\u0011\u0015y5\u000e1\u0001\u001a\u0011\u0015\t6\u000e1\u0001S\u0011\u001516\u000e1\u0001S\u0011\u0015A6\u000e1\u0001Z\u0011\u0015Y\b\u0001\"\u0003'\u00035\u0001(o\u001c3vG\u0016\u0014VmY8sI\")Q\u0010\u0001C\u0005}\u00069r/\u001b;i'R\f'\r\\3D_:\u001cX/\\3s\u000fJ|W\u000f\u001d\u000b\u0003O}Dq!!\u0001}\t\u0003\u00071/\u0001\u0003c_\u0012L\bbBA\u0003\u0001\u0011%\u0011qA\u0001\u0017o&$\b.R7qif\u001cuN\\:v[\u0016\u0014xI]8vaR\u0019q%!\u0003\t\u0011\u0005\u0005\u00111\u0001CA\u0002MDq!!\u0004\u0001\t\u0013\ty!\u0001\bde\u0016\fG/\u001a)s_\u0012,8-\u001a:\u0015\t\u0005E\u0011\u0011\u0006\t\t\u0003'\ti\"!\t\u0002\"5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"\u0001\u0005qe>$WoY3s\u0015\r\tYbX\u0001\bG2LWM\u001c;t\u0013\u0011\ty\"!\u0006\u0003\u001b-\u000bgm[1Qe>$WoY3s!\u0011!r#a\t\u0011\u0007Q\t)#C\u0002\u0002(U\u0011AAQ=uK\"Q\u00111FA\u0006!\u0003\u0005\r!!\f\u0002\r\r|gNZ5h!\u0011\ty#!\u000f\u000e\u0005\u0005E\"\u0002BA\u001a\u0003k\tA!\u001e;jY*\u0011\u0011qG\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002<\u0005E\"A\u0003)s_B,'\u000f^5fg\"9\u0011q\b\u0001\u0005\n\u0005\u0005\u0013AD2sK\u0006$XmQ8ogVlWM\u001d\u000b\u0005\u0003\u0007\ny\u0005\u0005\u0005\u0002F\u0005-\u0013\u0011EA\u0011\u001b\t\t9E\u0003\u0003\u0002J\u0005e\u0011\u0001C2p]N,X.\u001a:\n\t\u00055\u0013q\t\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\t\u0015\u0005-\u0012Q\bI\u0001\u0002\u0004\ti\u0003C\u0005\u0002T\u0001\t\n\u0011\"\u0003\u0002V\u0005A2M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005]#\u0006BA\u0017\u00033Z#!a\u0017\u0011\t\u0005u\u0013qM\u0007\u0003\u0003?RA!!\u0019\u0002d\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003K*\u0012AC1o]>$\u0018\r^5p]&!\u0011\u0011NA0\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003[\u0002\u0011\u0013!C\u0005\u0003+\n\u0001d\u0019:fCR,7i\u001c8tk6,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0001")
public class DeleteOffsetsConsumerGroupCommandIntegrationTest
extends ConsumerGroupCommandTest {
    public String[] getArgs(String group, String topic) {
        return (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete-offsets", "--group", group, "--topic", topic});
    }

    @Test
    public void testDeleteOffsetsNonExistingGroup() {
        String group = "missing.group";
        String topic = "foo:1";
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(this.getArgs(group, topic));
        Tuple2 tuple2 = service.deleteOffsets(group, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        if (tuple2 != null) {
            Errors error;
            Errors errors;
            Errors error2 = errors = (error = (Errors)tuple2._1());
            Assert.assertEquals((Object)Errors.GROUP_ID_NOT_FOUND, (Object)error2);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testDeleteOffsetsOfStableConsumerGroupWithTopicPartition() {
        this.testWithStableConsumerGroup(this.topic(), 0, 0, Errors.GROUP_SUBSCRIBED_TO_TOPIC);
    }

    @Test
    public void testDeleteOffsetsOfStableConsumerGroupWithTopicOnly() {
        this.testWithStableConsumerGroup(this.topic(), -1, 0, Errors.GROUP_SUBSCRIBED_TO_TOPIC);
    }

    @Test
    public void testDeleteOffsetsOfStableConsumerGroupWithUnknownTopicPartition() {
        this.testWithStableConsumerGroup("foobar", 0, 0, Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testDeleteOffsetsOfStableConsumerGroupWithUnknownTopicOnly() {
        this.testWithStableConsumerGroup("foobar", -1, -1, Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testDeleteOffsetsOfEmptyConsumerGroupWithTopicPartition() {
        this.testWithEmptyConsumerGroup(this.topic(), 0, 0, Errors.NONE);
    }

    @Test
    public void testDeleteOffsetsOfEmptyConsumerGroupWithTopicOnly() {
        this.testWithEmptyConsumerGroup(this.topic(), -1, 0, Errors.NONE);
    }

    @Test
    public void testDeleteOffsetsOfEmptyConsumerGroupWithUnknownTopicPartition() {
        this.testWithEmptyConsumerGroup("foobar", 0, 0, Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testDeleteOffsetsOfEmptyConsumerGroupWithUnknownTopicOnly() {
        this.testWithEmptyConsumerGroup("foobar", -1, -1, Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    private void testWithStableConsumerGroup(String inputTopic, int inputPartition, int expectedPartition, Errors expectedError) {
        this.testWithConsumerGroup((Function1<Function0<BoxedUnit>, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteOffsetsConsumerGroupCommandIntegrationTest $outer;

            public final void apply(Function0<BoxedUnit> body) {
                this.$outer.kafka$admin$DeleteOffsetsConsumerGroupCommandIntegrationTest$$withStableConsumerGroup(body);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, inputTopic, inputPartition, expectedPartition, expectedError);
    }

    private void testWithEmptyConsumerGroup(String inputTopic, int inputPartition, int expectedPartition, Errors expectedError) {
        this.testWithConsumerGroup((Function1<Function0<BoxedUnit>, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteOffsetsConsumerGroupCommandIntegrationTest $outer;

            public final void apply(Function0<BoxedUnit> body) {
                this.$outer.kafka$admin$DeleteOffsetsConsumerGroupCommandIntegrationTest$$withEmptyConsumerGroup(body);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, inputTopic, inputPartition, expectedPartition, expectedError);
    }

    private void testWithConsumerGroup(Function1<Function0<BoxedUnit>, BoxedUnit> withConsumerGroup, String inputTopic, int inputPartition, int expectedPartition, Errors expectedError) {
        this.produceRecord();
        withConsumerGroup.apply((Object)new Serializable(this, inputTopic, inputPartition, expectedPartition, expectedError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteOffsetsConsumerGroupCommandIntegrationTest $outer;
            private final String inputTopic$1;
            private final int inputPartition$1;
            private final int expectedPartition$1;
            private final Errors expectedError$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String topic = this.inputPartition$1 >= 0 ? new StringBuilder().append((Object)this.inputTopic$1).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)this.inputPartition$1)).toString() : this.inputTopic$1;
                ConsumerGroupCommand.ConsumerGroupService service = this.$outer.getConsumerGroupService(this.$outer.getArgs(this.$outer.group(), topic));
                Tuple2 tuple2 = service.deleteOffsets(this.$outer.group(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Errors topLevelError = (Errors)tuple2._1();
                    Map partitions = (Map)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)topLevelError, (Object)partitions);
                    Errors topLevelError2 = (Errors)tuple23._1();
                    Map partitions2 = (Map)tuple23._2();
                    TopicPartition tp = new TopicPartition(this.inputTopic$1, this.expectedPartition$1);
                    if (this.inputPartition$1 >= 0) {
                        Assert.assertEquals((Object)this.expectedError$1, (Object)topLevelError2);
                    }
                    Errors errors = this.expectedError$1;
                    Errors errors2 = Errors.NONE;
                    if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                        Assert.assertNull((Object)partitions2.apply((Object)tp));
                    } else {
                        Assert.assertEquals((Object)this.expectedError$1.exception(), (Object)((Throwable)partitions2.apply((Object)tp)).getCause());
                    }
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inputTopic$1 = inputTopic$1;
                this.inputPartition$1 = inputPartition$1;
                this.expectedPartition$1 = expectedPartition$1;
                this.expectedError$1 = expectedError$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void produceRecord() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1());
        try {
            producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, null)).get();
        }
        catch (Throwable throwable) {
            void var1_1;
            Utils.closeQuietly((AutoCloseable)var1_1, (String)"producer");
            throw throwable;
        }
        Utils.closeQuietly(producer, (String)"producer");
    }

    /*
     * WARNING - void declaration
     */
    public void kafka$admin$DeleteOffsetsConsumerGroupCommandIntegrationTest$$withStableConsumerGroup(Function0<BoxedUnit> body) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumer(this.createConsumer$default$1());
        try {
            TestUtils$.MODULE$.subscribeAndWaitForRecords(this.topic(), consumer, TestUtils$.MODULE$.subscribeAndWaitForRecords$default$3());
            consumer.commitSync();
            body.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            void var2_2;
            Utils.closeQuietly((AutoCloseable)var2_2, (String)"consumer");
            throw throwable;
        }
        Utils.closeQuietly(consumer, (String)"consumer");
    }

    /*
     * WARNING - void declaration
     */
    public void kafka$admin$DeleteOffsetsConsumerGroupCommandIntegrationTest$$withEmptyConsumerGroup(Function0<BoxedUnit> body) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumer(this.createConsumer$default$1());
        try {
            TestUtils$.MODULE$.subscribeAndWaitForRecords(this.topic(), consumer, TestUtils$.MODULE$.subscribeAndWaitForRecords$default$3());
            consumer.commitSync();
        }
        catch (Throwable throwable) {
            void var2_2;
            Utils.closeQuietly((AutoCloseable)var2_2, (String)"consumer");
            throw throwable;
        }
        Utils.closeQuietly(consumer, (String)"consumer");
        body.apply$mcV$sp();
    }

    private KafkaProducer<byte[], byte[]> createProducer(Properties config) {
        config.putIfAbsent("bootstrap.servers", this.brokerList());
        config.putIfAbsent("acks", "-1");
        config.putIfAbsent("key.serializer", ByteArraySerializer.class.getName());
        config.putIfAbsent("value.serializer", ByteArraySerializer.class.getName());
        return new KafkaProducer(config);
    }

    private Properties createProducer$default$1() {
        return new Properties();
    }

    private KafkaConsumer<byte[], byte[]> createConsumer(Properties config) {
        config.putIfAbsent("bootstrap.servers", this.brokerList());
        config.putIfAbsent("auto.offset.reset", "earliest");
        config.putIfAbsent("group.id", this.group());
        config.putIfAbsent("key.deserializer", ByteArrayDeserializer.class.getName());
        config.putIfAbsent("value.deserializer", ByteArrayDeserializer.class.getName());
        config.putIfAbsent("max.poll.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)).toString());
        config.putIfAbsent("session.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.GroupMaxSessionTimeoutMs())).toString());
        return new KafkaConsumer(config);
    }

    private Properties createConsumer$default$1() {
        return new Properties();
    }
}

