/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.nio.file.Path;
import java.util.Properties;
import kafka.admin.LeaderElectionCommand$;
import kafka.admin.LeaderElectionCommandTest$;
import kafka.common.AdminCommandFailedException;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u0001\u0003\u0005\u001d\u0011\u0011\u0004T3bI\u0016\u0014X\t\\3di&|gnQ8n[\u0006tG\rV3ti*\u00111\u0001B\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\tYA!\u0001\u0002{W&\u0011QB\u0003\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0001\u0004%\t!F\u0001\bg\u0016\u0014h/\u001a:t+\u00051\u0002cA\f\u001d=5\t\u0001D\u0003\u0002\u001a5\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003m\tQa]2bY\u0006L!!\b\r\u0003\u0007M+\u0017\u000f\u0005\u0002 E5\t\u0001E\u0003\u0002\"\t\u000511/\u001a:wKJL!a\t\u0011\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\bK\u0001\u0001\r\u0011\"\u0001'\u0003-\u0019XM\u001d<feN|F%Z9\u0015\u0005\u001dZ\u0003C\u0001\u0015*\u001b\u0005Q\u0012B\u0001\u0016\u001b\u0005\u0011)f.\u001b;\t\u000f1\"\u0013\u0011!a\u0001-\u0005\u0019\u0001\u0010J\u0019\t\r9\u0002\u0001\u0015)\u0003\u0017\u0003!\u0019XM\u001d<feN\u0004\u0003b\u0002\u0019\u0001\u0005\u0004%\t!M\u0001\bEJ|7.\u001a:2+\u0005\u0011\u0004C\u0001\u00154\u0013\t!$DA\u0002J]RDaA\u000e\u0001!\u0002\u0013\u0011\u0014\u0001\u00032s_.,'/\r\u0011\t\u000fa\u0002!\u0019!C\u0001c\u00059!M]8lKJ\u0014\u0004B\u0002\u001e\u0001A\u0003%!'\u0001\u0005ce>\\WM\u001d\u001a!\u0011\u001da\u0004A1A\u0005\u0002E\nqA\u0019:pW\u0016\u00148\u0007\u0003\u0004?\u0001\u0001\u0006IAM\u0001\tEJ|7.\u001a:4A!)\u0001\t\u0001C!\u0003\u0006)1/\u001a;VaR\tq\u0005\u000b\u0002@\u0007B\u0011A)S\u0007\u0002\u000b*\u0011aiR\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0011\u0006\u0019qN]4\n\u0005)+%A\u0002\"fM>\u0014X\rC\u0003M\u0001\u0011\u0005\u0013)\u0001\u0005uK\u0006\u0014Hi\\<oQ\tYe\n\u0005\u0002E\u001f&\u0011\u0001+\u0012\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0006%\u0002!\t!Q\u0001\u0016i\u0016\u001cH/\u00117m)>\u0004\u0018n\u0019)beRLG/[8oQ\t\tF\u000b\u0005\u0002E+&\u0011a+\u0012\u0002\u0005)\u0016\u001cH\u000fC\u0003Y\u0001\u0011\u0005\u0011)\u0001\nuKN$Hk\u001c9jGB\u000b'\u000f^5uS>t\u0007FA,U\u0011\u0015Y\u0006\u0001\"\u0001B\u0003I!Xm\u001d;QCRDGk\u001c&t_:4\u0015\u000e\\3)\u0005i#\u0006\"\u00020\u0001\t\u0003\t\u0015\u0001\b;fgR\u0004&/\u001a4feJ,GMU3qY&\u001c\u0017-\u00127fGRLwN\u001c\u0015\u0003;RCQ!\u0019\u0001\u0005\u0002\u0005\u000b\u0011\u0004^3tiR{\u0007/[2XSRDw.\u001e;QCJ$\u0018\u000e^5p]\"\u0012\u0001\r\u0016\u0005\u0006I\u0002!\t!Q\u0001\u001ai\u0016\u001cH\u000fU1si&$\u0018n\u001c8XSRDw.\u001e;U_BL7\r\u000b\u0002d)\")q\r\u0001C\u0001\u0003\u0006)B/Z:u)>\u0004\u0018n\u0019#pKNtu\u000e^#ySN$\bF\u00014U\u0011\u0015Q\u0007\u0001\"\u0001B\u0003]!Xm\u001d;NSN\u001c\u0018N\\4FY\u0016\u001cG/[8o)f\u0004X\r\u000b\u0002j)\")Q\u000e\u0001C\u0001\u0003\u0006\u0011C/Z:u\u001b&\u001c8/\u001b8h)>\u0004\u0018n\u0019)beRLG/[8o'\u0016dWm\u0019;j_:D#\u0001\u001c+\t\u000bA\u0004A\u0011A!\u0002#Q,7\u000f^%om\u0006d\u0017\u000e\u001a\"s_.,'\u000f\u000b\u0002p)\u001e)1O\u0001E\u0001i\u0006IB*Z1eKJ,E.Z2uS>t7i\\7nC:$G+Z:u!\t\u0011ROB\u0003\u0002\u0005!\u0005ao\u0005\u0002voB\u0011\u0001\u0006_\u0005\u0003sj\u0011a!\u00118z%\u00164\u0007\"B\bv\t\u0003YH#\u0001;\t\u000bu,H\u0011\u0001@\u0002\u0019\r\u0014X-\u0019;f\u0007>tg-[4\u0015\u0007}\f\u0019\u0003\u0005\u0005\u0002\u0002\u0005\u001d\u0011QBA\n\u001d\rA\u00131A\u0005\u0004\u0003\u000bQ\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\n\u0005-!aA'ba*\u0019\u0011Q\u0001\u000e\u0011\t\u0005\u0005\u0011qB\u0005\u0005\u0003#\tYA\u0001\u0004TiJLgn\u001a\t\u0005\u0003+\ty\"\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0011\u0001\u00026bm\u0006LA!!\t\u0002\u0018\t1qJ\u00196fGRDQ\u0001\u0006?A\u0002YAq!a\nv\t\u0003\tI#\u0001\tc_>$8\u000f\u001e:baN+'O^3sgR!\u0011QBA\u0016\u0011\u0019!\u0012Q\u0005a\u0001-!9\u0011qF;\u0005\u0002\u0005E\u0012A\u0006;f[B$v\u000e]5d!\u0006\u0014H/\u001b;j_:4\u0015\u000e\\3\u0015\t\u0005M\u00121\t\t\u0005\u0003k\ty$\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003\u00111\u0017\u000e\\3\u000b\t\u0005u\u00121D\u0001\u0004]&|\u0017\u0002BA!\u0003o\u0011A\u0001U1uQ\"A\u0011QIA\u0017\u0001\u0004\t9%\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004b!!\u0001\u0002J\u00055\u0013\u0002BA&\u0003\u0017\u00111aU3u!\u0011\ty%a\u0017\u000e\u0005\u0005E#\u0002BA*\u0003+\naaY8n[>t'bA\u0003\u0002X)\u0019\u0011\u0011L$\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\ti&!\u0015\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0002")
public final class LeaderElectionCommandTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final int broker1;
    private final int broker2;
    private final int broker3;

    public static Path tempTopicPartitionFile(Set<TopicPartition> set) {
        return LeaderElectionCommandTest$.MODULE$.tempTopicPartitionFile(set);
    }

    public static String bootstrapServers(Seq<KafkaServer> seq) {
        return LeaderElectionCommandTest$.MODULE$.bootstrapServers(seq);
    }

    public static scala.collection.immutable.Map<String, Object> createConfig(Seq<KafkaServer> seq) {
        return LeaderElectionCommandTest$.MODULE$.createConfig(seq);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int broker1() {
        return this.broker1;
    }

    public int broker2() {
        return this.broker2;
    }

    public int broker3() {
        return this.broker3;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        this.servers_$eq((Seq<KafkaServer>)((Seq)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties config) {
                config.setProperty("auto.leader.rebalance.enable", "false");
                config.setProperty("controlled.shutdown.enable", "true");
                config.setProperty("controlled.shutdown.max.retries", "1");
                config.setProperty("controlled.shutdown.retry.backoff.ms", "1000");
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testAllTopicPartition() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(LeaderElectionCommandTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderElectionCommandTest $outer;

            public final void apply(AdminClient client) {
                String topic = "unclean-topic";
                int partition = 0;
                Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker2(), this.$outer.broker3()}));
                TestUtils$.MODULE$.createTopic(this.$outer.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment2)}))), this.$outer.servers());
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                TestUtils$.MODULE$.assertLeader((Admin)client, topicPartition, this.$outer.broker2());
                ((KafkaServer)this.$outer.servers().apply(this.$outer.broker3())).shutdown();
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3()}))));
                ((KafkaServer)this.$outer.servers().apply(this.$outer.broker2())).shutdown();
                TestUtils$.MODULE$.assertNoLeader((Admin)client, topicPartition);
                ((KafkaServer)this.$outer.servers().apply(this.$outer.broker3())).startup();
                LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.$outer.servers()), "--election-type", "unclean", "--all-topic-partitions"}));
                TestUtils$.MODULE$.assertLeader((Admin)client, topicPartition, this.$outer.broker3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testTopicPartition() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(LeaderElectionCommandTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderElectionCommandTest $outer;

            public final void apply(AdminClient client) {
                String topic = "unclean-topic";
                int partition = 0;
                Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker2(), this.$outer.broker3()}));
                TestUtils$.MODULE$.createTopic(this.$outer.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment2)}))), this.$outer.servers());
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                TestUtils$.MODULE$.assertLeader((Admin)client, topicPartition, this.$outer.broker2());
                ((KafkaServer)this.$outer.servers().apply(this.$outer.broker3())).shutdown();
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3()}))));
                ((KafkaServer)this.$outer.servers().apply(this.$outer.broker2())).shutdown();
                TestUtils$.MODULE$.assertNoLeader((Admin)client, topicPartition);
                ((KafkaServer)this.$outer.servers().apply(this.$outer.broker3())).startup();
                LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.$outer.servers()), "--election-type", "unclean", "--topic", topic, "--partition", ((Object)BoxesRunTime.boxToInteger((int)partition)).toString()}));
                TestUtils$.MODULE$.assertLeader((Admin)client, topicPartition, this.$outer.broker3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testPathToJsonFile() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(LeaderElectionCommandTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderElectionCommandTest $outer;

            public final void apply(AdminClient client) {
                String topic = "unclean-topic";
                int partition = 0;
                Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker2(), this.$outer.broker3()}));
                TestUtils$.MODULE$.createTopic(this.$outer.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment2)}))), this.$outer.servers());
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                TestUtils$.MODULE$.assertLeader((Admin)client, topicPartition, this.$outer.broker2());
                ((KafkaServer)this.$outer.servers().apply(this.$outer.broker3())).shutdown();
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3()}))));
                ((KafkaServer)this.$outer.servers().apply(this.$outer.broker2())).shutdown();
                TestUtils$.MODULE$.assertNoLeader((Admin)client, topicPartition);
                ((KafkaServer)this.$outer.servers().apply(this.$outer.broker3())).startup();
                Path topicPartitionPath = LeaderElectionCommandTest$.MODULE$.tempTopicPartitionFile((Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
                LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.$outer.servers()), "--election-type", "unclean", "--path-to-json-file", ((Object)topicPartitionPath).toString()}));
                TestUtils$.MODULE$.assertLeader((Admin)client, topicPartition, this.$outer.broker3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testPreferredReplicaElection() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(LeaderElectionCommandTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderElectionCommandTest $outer;

            public final void apply(AdminClient client) {
                String topic = "unclean-topic";
                int partition = 0;
                Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker2(), this.$outer.broker3()}));
                TestUtils$.MODULE$.createTopic(this.$outer.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment2)}))), this.$outer.servers());
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                TestUtils$.MODULE$.assertLeader((Admin)client, topicPartition, this.$outer.broker2());
                ((KafkaServer)this.$outer.servers().apply(this.$outer.broker2())).shutdown();
                TestUtils$.MODULE$.assertLeader((Admin)client, topicPartition, this.$outer.broker3());
                ((KafkaServer)this.$outer.servers().apply(this.$outer.broker2())).startup();
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker2()}))));
                LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.$outer.servers()), "--election-type", "preferred", "--all-topic-partitions"}));
                TestUtils$.MODULE$.assertLeader((Admin)client, topicPartition, this.$outer.broker2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testTopicWithoutPartition() {
        try {
            LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.servers()), "--election-type", "unclean", "--topic", "some-topic"}));
            Assert.fail();
        }
        catch (Throwable throwable) {
            Assert.assertTrue((boolean)throwable.getMessage().startsWith("Missing required option(s)"));
            Assert.assertTrue((boolean)throwable.getMessage().contains(" partition"));
        }
    }

    @Test
    public void testPartitionWithoutTopic() {
        try {
            LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.servers()), "--election-type", "unclean", "--all-topic-partitions", "--partition", "0"}));
            Assert.fail();
        }
        catch (Throwable throwable) {
            Assert.assertEquals((Object)"Option partition is only allowed if topic is used", (Object)throwable.getMessage());
        }
    }

    @Test
    public void testTopicDoesNotExist() {
        try {
            LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.servers()), "--election-type", "preferred", "--topic", "unknown-topic-name", "--partition", "0"}));
            Assert.fail();
        }
        catch (AdminCommandFailedException adminCommandFailedException) {
            Assert.assertTrue((boolean)(adminCommandFailedException.getSuppressed()[0] instanceof UnknownTopicOrPartitionException));
        }
    }

    @Test
    public void testMissingElectionType() {
        try {
            LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.servers()), "--topic", "some-topic", "--partition", "0"}));
            Assert.fail();
        }
        catch (Throwable throwable) {
            Assert.assertTrue((boolean)throwable.getMessage().startsWith("Missing required option(s)"));
            Assert.assertTrue((boolean)throwable.getMessage().contains(" election-type"));
        }
    }

    @Test
    public void testMissingTopicPartitionSelection() {
        try {
            LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.servers()), "--election-type", "preferred"}));
            Assert.fail();
        }
        catch (Throwable throwable) {
            Assert.assertTrue((boolean)throwable.getMessage().startsWith("One and only one of the following options is required: "));
            Assert.assertTrue((boolean)throwable.getMessage().contains(" all-topic-partitions"));
            Assert.assertTrue((boolean)throwable.getMessage().contains(" topic"));
            Assert.assertTrue((boolean)throwable.getMessage().contains(" path-to-json-file"));
        }
    }

    @Test
    public void testInvalidBroker() {
        try {
            LeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", "example.com:1234", "--election-type", "unclean", "--all-topic-partitions"}), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds());
            Assert.fail();
        }
        catch (AdminCommandFailedException adminCommandFailedException) {
            Assert.assertTrue((boolean)(adminCommandFailedException.getCause() instanceof TimeoutException));
        }
    }

    public LeaderElectionCommandTest() {
        this.broker1 = 0;
        this.broker2 = 1;
        this.broker3 = 2;
    }
}

