/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import kafka.api.AbstractConsumerTest;
import kafka.api.BaseConsumerTest;
import kafka.api.PlaintextConsumerTest$;
import kafka.api.PlaintextConsumerTest$DeserializerImpl$class;
import kafka.api.PlaintextConsumerTest$SerializerImpl$class;
import kafka.log.LogConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.ExtendedDeserializer;
import org.apache.kafka.common.serialization.ExtendedSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.apache.kafka.test.MockProducerInterceptor;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0015b\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003\u00157bS:$X\r\u001f;D_:\u001cX/\\3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0011\u0005\u0006\u001cXmQ8ogVlWM\u001d+fgRDQ!\u0004\u0001\u0005\u00029\ta\u0001P5oSRtD#A\b\u0011\u0005%\u0001\u0001\"B\t\u0001\t\u0003\u0011\u0012a\u0003;fgRDU-\u00193feN$\u0012a\u0005\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0005+:LG\u000f\u000b\u0002\u00115A\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002?\u0005\u0019qN]4\n\u0005\u0005b\"\u0001\u0002+fgR4qa\t\u0001\u0011\u0002\u0007\u0005AE\u0001\bTKJL\u0017\r\\5{KJLU\u000e\u001d7\u0014\u0007\t*S\u0006\u0005\u0002'W5\tqE\u0003\u0002)S\u0005!A.\u00198h\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001L\u0014\u0003\r=\u0013'.Z2u!\rqc\u0007O\u0007\u0002_)\u0011\u0001'M\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005I\u001a\u0014AB2p[6|gN\u0003\u0002\u0006i)\u0011QGH\u0001\u0007CB\f7\r[3\n\u0005]z#AC*fe&\fG.\u001b>feB\u0019A#O\u001e\n\u0005i*\"!B!se\u0006L\bC\u0001\u000b=\u0013\tiTC\u0001\u0003CsR,\u0007\"B #\t\u0003\u0011\u0012A\u0002\u0013j]&$H\u0005C\u0004BE\u0001\u0007I\u0011\u0001\"\u0002\u0015M,'/[1mSj,'/F\u0001D!\tqC)\u0003\u0002F_\t\u0019\")\u001f;f\u0003J\u0014\u0018-_*fe&\fG.\u001b>fe\"9qI\ta\u0001\n\u0003A\u0015AD:fe&\fG.\u001b>fe~#S-\u001d\u000b\u0003'%CqA\u0013$\u0002\u0002\u0003\u00071)A\u0002yIEBa\u0001\u0014\u0012!B\u0013\u0019\u0015aC:fe&\fG.\u001b>fe\u0002BQA\u0014\u0012\u0005B=\u000b\u0011b]3sS\u0006d\u0017N_3\u0015\ta\u0002\u0016,\u0019\u0005\u0006#6\u0003\rAU\u0001\u0006i>\u0004\u0018n\u0019\t\u0003'Zs!\u0001\u0006+\n\u0005U+\u0012A\u0002)sK\u0012,g-\u0003\u0002X1\n11\u000b\u001e:j]\u001eT!!V\u000b\t\u000bik\u0005\u0019A.\u0002\u000f!,\u0017\rZ3sgB\u0011AlX\u0007\u0002;*\u0011a,M\u0001\u0007Q\u0016\fG-\u001a:\n\u0005\u0001l&a\u0002%fC\u0012,'o\u001d\u0005\u0006E6\u0003\r\u0001O\u0001\u0005I\u0006$\u0018\rC\u0003eE\u0011\u0005S-A\u0005d_:4\u0017nZ;sKR\u00191C\u001a>\t\u000b\u001d\u001c\u0007\u0019\u00015\u0002\u000f\r|gNZ5hgB\u0012\u0011.\u001d\t\u0005U6\u0014v.D\u0001l\u0015\ta\u0017&\u0001\u0003vi&d\u0017B\u00018l\u0005\ri\u0015\r\u001d\t\u0003aFd\u0001\u0001B\u0005sM\u0006\u0005\t\u0011!B\u0001g\n\u0019q\fJ\u0019\u0012\u0005Q<\bC\u0001\u000bv\u0013\t1XCA\u0004O_RD\u0017N\\4\u0011\u0005QA\u0018BA=\u0016\u0005\r\te.\u001f\u0005\u0006w\u000e\u0004\r\u0001`\u0001\u0006SN\\U-\u001f\t\u0003)uL!A`\u000b\u0003\u000f\t{w\u000e\\3b]\"1\u0011\u0011\u0001\u0012\u0005BI\tQa\u00197pg\u0016DaA\u0014\u0012\u0005B\u0005\u0015A#\u0002\u001d\u0002\b\u0005%\u0001BB)\u0002\u0004\u0001\u0007!\u000b\u0003\u0004c\u0003\u0007\u0001\r\u0001\u000f\u0004\n\u0003\u001b\u0001\u0001\u0013aA\u0001\u0003\u001f\u0011\u0001\u0003R3tKJL\u0017\r\\5{KJLU\u000e\u001d7\u0014\u000b\u0005-Q%!\u0005\u0011\t9\n\u0019\u0002O\u0005\u0004\u0003+y#\u0001\u0004#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bBB \u0002\f\u0011\u0005!\u0003\u0003\u0006\u0002\u001c\u0005-\u0001\u0019!C\u0001\u0003;\tA\u0002Z3tKJL\u0017\r\\5{KJ,\"!a\b\u0011\u00079\n\t#C\u0002\u0002$=\u0012QCQ=uK\u0006\u0013(/Y=EKN,'/[1mSj,'\u000f\u0003\u0006\u0002(\u0005-\u0001\u0019!C\u0001\u0003S\t\u0001\u0003Z3tKJL\u0017\r\\5{KJ|F%Z9\u0015\u0007M\tY\u0003C\u0005K\u0003K\t\t\u00111\u0001\u0002 !I\u0011qFA\u0006A\u0003&\u0011qD\u0001\u000eI\u0016\u001cXM]5bY&TXM\u001d\u0011\t\u0011\u0005M\u00121\u0002C!\u0003k\t1\u0002Z3tKJL\u0017\r\\5{KR9\u0001(a\u000e\u0002:\u0005m\u0002BB)\u00022\u0001\u0007!\u000b\u0003\u0004[\u0003c\u0001\ra\u0017\u0005\u0007E\u0006E\u0002\u0019\u0001\u001d\t\u000f\u0011\fY\u0001\"\u0011\u0002@Q)1#!\u0011\u0002N!9q-!\u0010A\u0002\u0005\r\u0003\u0007BA#\u0003\u0013\u0002RA[7S\u0003\u000f\u00022\u0001]A%\t-\tY%!\u0011\u0002\u0002\u0003\u0005)\u0011A:\u0003\u0007}##\u0007\u0003\u0004|\u0003{\u0001\r\u0001 \u0005\b\u0003\u0003\tY\u0001\"\u0011\u0013\u0011!\t\u0019$a\u0003\u0005B\u0005MC#\u0002\u001d\u0002V\u0005]\u0003BB)\u0002R\u0001\u0007!\u000b\u0003\u0004c\u0003#\u0002\r\u0001\u000f\u0005\b\u00037\u0002A\u0011BA/\u0003}!Xm\u001d;IK\u0006$WM]:TKJL\u0017\r\\5{K\u0012+7/\u001a:jC2L'0\u001a\u000b\u0006'\u0005}\u0013\u0011\r\u0005\u0007\u0003\u0006e\u0003\u0019A\u0017\t\u0011\u0005m\u0011\u0011\fa\u0001\u0003#Aa!!\u001a\u0001\t\u0003\u0011\u0012!\n;fgR$U\r\u001d:fG\u0006$X\r\u001a)pY2\u0014En\\2lg\u001a{'/Q:tS\u001etW.\u001a8uQ\r\t\u0019G\u0007\u0015\t\u0003G\nY'!\u001d\u0002vA\u0019A#!\u001c\n\u0007\u0005=TC\u0001\u0006eKB\u0014XmY1uK\u0012\f#!a\u001d\u0002CA|G\u000e\u001c\u0015EkJ\fG/[8oS\u0001J7\u000f\t;iK\u0002\u0012X\r\u001d7bG\u0016lWM\u001c;\"\u0005\u0005]\u0014a\u0001\u001a/a!1\u00111\u0010\u0001\u0005\u0002I\t\u0011\u0006^3ti\"+\u0017\rZ3sg\u0016CH/\u001a8eK\u0012\u001cVM]5bY&TXM\u001d#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bfAA=5!B\u0011\u0011PA6\u0003\u0003\u000b))\t\u0002\u0002\u0004\u0006\u00115+\u001a:jC2L'0\u001a:!]><\b%\u001b8dYV$Wm\u001d\u0011bA\u0011,g-Y;mi\u0002jW\r\u001e5pI\u0002\"\b.\u0019;!aJ|g/\u001b3fg\u0002\"\b.\u001a\u0011iK\u0006$WM]:\"\u0005\u0005\u001d\u0015a\u0001\u001a/c!1\u00111\u0012\u0001\u0005\u0002I\t\u0011\u0005^3ti\"+\u0017\rZ3sgN+'/[1mSj,'\u000fR3tKJL\u0017\r\\5{KJD3!!#\u001b\u0011\u0019\t\t\n\u0001C\u0001%\u0005\u0011B/Z:u\u001b\u0006D\bk\u001c7m%\u0016\u001cwN\u001d3tQ\r\tyI\u0007\u0005\u0007\u0003/\u0003A\u0011\u0001\n\u0002+Q,7\u000f^'bqB{G\u000e\\%oi\u0016\u0014h/\u00197Ng\"\u001a\u0011Q\u0013\u000e\t\r\u0005u\u0005\u0001\"\u0001\u0013\u0003\u0019\"Xm\u001d;NCb\u0004v\u000e\u001c7J]R,'O^1m\u001bN$U\r\\1z\u0013:\u0014VM^8dCRLwN\u001c\u0015\u0004\u00037S\u0002BBAR\u0001\u0011\u0005!#\u0001\u0014uKN$X*\u0019=Q_2d\u0017J\u001c;feZ\fG.T:EK2\f\u00170\u00138BgNLwM\\7f]RD3!!)\u001b\u0011\u0019\tI\u000b\u0001C\u0001%\u0005)B/Z:u\u0003V$xnQ8n[&$xJ\\\"m_N,\u0007fAAT5!1\u0011q\u0016\u0001\u0005\u0002I\t\u0001\u0005^3ti\u0006+Ho\\\"p[6LGo\u00148DY>\u001cX-\u00114uKJ<\u0016m[3va\"\u001a\u0011Q\u0016\u000e\t\r\u0005U\u0006\u0001\"\u0001\u0013\u0003M!Xm\u001d;BkR|wJ\u001a4tKR\u0014Vm]3uQ\r\t\u0019L\u0007\u0005\u0007\u0003w\u0003A\u0011\u0001\n\u0002)Q,7\u000f^$s_V\u00048i\u001c8tk6\u0004H/[8oQ\r\tIL\u0007\u0005\u0007\u0003\u0003\u0004A\u0011\u0001\n\u0002/Q,7\u000f\u001e)biR,'O\\*vEN\u001c'/\u001b9uS>t\u0007fAA`5!1\u0011q\u0019\u0001\u0005\u0002I\t\u0011\u0005^3tiN+(m]3rk\u0016tG\u000fU1ui\u0016\u0014hnU;cg\u000e\u0014\u0018\u000e\u001d;j_:D3!!2\u001b\u0011\u0019\ti\r\u0001C\u0001%\u0005IB/Z:u!\u0006$H/\u001a:o+:\u001cXOY:de&\u0004H/[8oQ\r\tYM\u0007\u0005\u0007\u0003'\u0004A\u0011\u0001\n\u0002%Q,7\u000f^\"p[6LG/T3uC\u0012\fG/\u0019\u0015\u0004\u0003#T\u0002BBAm\u0001\u0011\u0005!#A\buKN$\u0018i]=oG\u000e{W.\\5uQ\r\t9N\u0007\u0005\u0007\u0003?\u0004A\u0011\u0001\n\u0002?Q,7\u000f^#ya\u0006tG-\u001b8h)>\u0004\u0018nY*vEN\u001c'/\u001b9uS>t7\u000fK\u0002\u0002^jAa!!:\u0001\t\u0003\u0011\u0012a\b;fgR\u001c\u0006N]5oW&tw\rV8qS\u000e\u001cVOY:de&\u0004H/[8og\"\u001a\u00111\u001d\u000e\t\r\u0005-\b\u0001\"\u0001\u0013\u0003E!Xm\u001d;QCJ$\u0018\u000e^5p]N4uN\u001d\u0015\u0004\u0003ST\u0002BBAy\u0001\u0011\u0005!#A\u000euKN$\b+\u0019:uSRLwN\\:G_J\fU\u000f^8De\u0016\fG/\u001a\u0015\u0004\u0003_T\u0002BBA|\u0001\u0011\u0005!#A\u000fuKN$\b+\u0019:uSRLwN\\:G_JLeN^1mS\u0012$v\u000e]5dQ\u001d\t)PGA~\u0003{\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0003\u0003\u007f\u0004BA!\u0001\u0003\b5\u0011!1\u0001\u0006\u0004\u0005\u000b\t\u0014AB3se>\u00148/\u0003\u0003\u0003\n\t\r!!F%om\u0006d\u0017\u000e\u001a+pa&\u001cW\t_2faRLwN\u001c\u0005\u0007\u0005\u001b\u0001A\u0011\u0001\n\u0002\u0011Q,7\u000f^*fK.D3Aa\u0003\u001b\u0011\u001d\u0011\u0019\u0002\u0001C\u0005\u0005+\tac]3oI\u000e{W\u000e\u001d:fgN,G-T3tg\u0006<Wm\u001d\u000b\u0006'\t]!\u0011\u0005\u0005\t\u00053\u0011\t\u00021\u0001\u0003\u001c\u0005Qa.^7SK\u000e|'\u000fZ:\u0011\u0007Q\u0011i\"C\u0002\u0003 U\u00111!\u00138u\u0011!\u0011\u0019C!\u0005A\u0002\t\u0015\u0012A\u0001;q!\u0011\u00119C!\u000b\u000e\u0003EJ1Aa\u000b2\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:DaAa\f\u0001\t\u0003\u0011\u0012!\u0006;fgR\u0004vn]5uS>t\u0017I\u001c3D_6l\u0017\u000e\u001e\u0015\u0004\u0005[Q\u0002B\u0002B\u001b\u0001\u0011\u0005!#A\u000euKN$\b+\u0019:uSRLwN\u001c)bkN,\u0017I\u001c3SKN,X.\u001a\u0015\u0004\u0005gQ\u0002B\u0002B\u001e\u0001\u0011\u0005!#\u0001\fuKN$h)\u001a;dQ&sg/\u00197jI>3gm]3uQ\r\u0011ID\u0007\u0005\u0007\u0005\u0003\u0002A\u0011\u0001\n\u0002MQ,7\u000f\u001e$fi\u000eD'+Z2pe\u0012d\u0015M]4feRC\u0017M\u001c$fi\u000eDW*\u0019=CsR,7\u000fK\u0002\u0003@iAqAa\u0012\u0001\t\u0013\u0011I%\u0001\tdQ\u0016\u001c7\u000eT1sO\u0016\u0014VmY8sIR\u00191Ca\u0013\t\u0011\t5#Q\ta\u0001\u00057\t!\u0003\u001d:pIV\u001cWM\u001d*fG>\u0014HmU5{K\"1!\u0011\u000b\u0001\u0005\u0002I\ta\u0006^3ti\u001a+Go\u00195I_:|WO]:GKR\u001c\u0007nU5{K&3G*\u0019:hKJ+7m\u001c:e\u001d>$h)\u001b:ti\"\u001a!q\n\u000e\t\u000f\t]\u0003\u0001\"\u0003\u0003Z\u0005Q3\r[3dW\u001a+Go\u00195I_:|WO]:TSj,\u0017J\u001a'be\u001e,'+Z2pe\u0012tu\u000e\u001e$jeN$HcA\n\u0003\\!A!Q\fB+\u0001\u0004\u0011Y\"A\fmCJ<W\r\u0015:pIV\u001cWM\u001d*fG>\u0014HmU5{K\"1!\u0011\r\u0001\u0005\u0002I\t1\b^3ti\u001a+Go\u00195I_:|WO]:NCb\u0004\u0016M\u001d;ji&|gNR3uG\"\u0014\u0015\u0010^3t\u0013\u001ad\u0015M]4f%\u0016\u001cwN\u001d3O_R4\u0015N]:uQ\r\u0011yF\u0007\u0005\u0007\u0005O\u0002A\u0011\u0001\n\u0002_Q,7\u000f\u001e$fi\u000eD'+Z2pe\u0012d\u0015M]4feRC\u0017M\\'bqB\u000b'\u000f^5uS>tg)\u001a;dQ\nKH/Z:)\u0007\t\u0015$\u0004\u0003\u0004\u0003n\u0001!\tAE\u0001*i\u0016\u001cH\u000fT8x\u001b\u0006Dh)\u001a;dQNK'0\u001a$peJ+\u0017/^3ti\u0006sG\rU1si&$\u0018n\u001c8)\u0007\t-$\u0004\u0003\u0004\u0003t\u0001!\tAE\u0001\u0019i\u0016\u001cHOU8v]\u0012\u0014vNY5o\u0003N\u001c\u0018n\u001a8nK:$\bf\u0001B95!1!\u0011\u0010\u0001\u0005\u0002I\tQ\u0005^3ti6+H\u000e^5D_:\u001cX/\\3s%>,h\u000e\u001a*pE&t\u0017i]:jO:lWM\u001c;)\u0007\t]$\u0004\u0003\u0004\u0003\u0000\u0001!\tAE\u0001\"i\u0016\u001cH/T;mi&\u001cuN\\:v[\u0016\u00148\u000b^5dWf\f5o]5h]6,g\u000e\u001e\u0015\u0004\u0005{R\u0002B\u0002BC\u0001\u0011\u0005!#\u0001\u0012uKN$X*\u001e7uS\u000e{gn];nKJ$UMZ1vYR\f5o]5h]6,g\u000e\u001e\u0015\u0004\u0005\u0007S\u0002B\u0002BF\u0001\u0011\u0005!#\u0001\u0017uKN$X*\u001e7uS\u000e{gn];nKJ\u001cVm]:j_:$\u0016.\\3pkR|en\u0015;paB{G\u000e\\5oO\"\u001a!\u0011\u0012\u000e\t\r\tE\u0005\u0001\"\u0001\u0013\u0003\u0019\"Xm\u001d;Nk2$\u0018nQ8ogVlWM]*fgNLwN\u001c+j[\u0016|W\u000f^(o\u00072|7/\u001a\u0015\u0004\u0005\u001fS\u0002B\u0002BL\u0001\u0011\u0005!#\u0001\tuKN$\u0018J\u001c;fe\u000e,\u0007\u000f^8sg\"\u001a!Q\u0013\u000e\t\r\tu\u0005\u0001\"\u0001\u0013\u0003]!Xm\u001d;BkR|7i\\7nSRLe\u000e^3sG\u0016\u0004H\u000fK\u0002\u0003\u001cjAaAa)\u0001\t\u0003\u0011\u0012!\t;fgRLe\u000e^3sG\u0016\u0004Ho\u001c:t/&$\bn\u0016:p]\u001e\\U-\u001f,bYV,\u0007f\u0001BQ5!1!\u0011\u0016\u0001\u0005\u0002I\t\u0011\u0005^3ti\u000e{gn];nK6+7o]1hKN<\u0016\u000e\u001e5De\u0016\fG/\u001a+j[\u0016D3Aa*\u001b\u0011\u0019\u0011y\u000b\u0001C\u0001%\u0005!C/Z:u\u0007>t7/^7f\u001b\u0016\u001c8/Y4fg^KG\u000f\u001b'pO\u0006\u0003\b/\u001a8e)&lW\rK\u0002\u0003.jAaA!.\u0001\t\u0003\u0011\u0012A\u0004;fgRd\u0015n\u001d;U_BL7m\u001d\u0015\u0004\u0005gS\u0002B\u0002B^\u0001\u0011\u0005!#A\nuKN$xJ\u001a4tKR\u001chi\u001c:US6,7\u000fK\u0002\u0003:jAaA!1\u0001\t\u0003\u0011\u0012a\u0007;fgR,\u0015M\u001d7jKN$xJ\u001d'bi\u0016\u001cHo\u00144gg\u0016$8\u000fK\u0002\u0003@jAaAa2\u0001\t\u0003\u0011\u0012\u0001\u0006;fgR,fn];cg\u000e\u0014\u0018NY3U_BL7\rK\u0002\u0003FjAaA!4\u0001\t\u0003\u0011\u0012!\n;fgR\u0004\u0016-^:f'R\fG/\u001a(piB\u0013Xm]3sm\u0016$')\u001f*fE\u0006d\u0017M\\2fQ\r\u0011YM\u0007\u0005\u0007\u0005'\u0004A\u0011\u0001\n\u00025Q,7\u000f^\"p[6LGo\u00159fG&4\u0017.\u001a3PM\u001a\u001cX\r^:)\u0007\tE'\u0004\u0003\u0004\u0003Z\u0002!\tAE\u0001\u001ai\u0016\u001cH/Q;u_\u000e{W.\\5u\u001f:\u0014VMY1mC:\u001cW\rK\u0002\u0003XjAaAa8\u0001\t\u0003\u0011\u0012a\f;fgR\u0004VM\u001d)beRLG/[8o\u0019\u0016\fG-T3ue&\u001c7o\u00117fC:,\u0006oV5uQN+(m]2sS\n,\u0007f\u0001Bo5!1!Q\u001d\u0001\u0005\u0002I\ta\u0006^3tiB+'\u000fU1si&$\u0018n\u001c8MC\u001elU\r\u001e:jGN\u001cE.Z1o+B<\u0016\u000e\u001e5Tk\n\u001c8M]5cK\"\u001a!1\u001d\u000e\t\r\t-\b\u0001\"\u0001\u0013\u00031\"Xm\u001d;QKJ\u0004\u0016M\u001d;ji&|g\u000eT3bI6+GO]5dg\u000ecW-\u00198Va^KG\u000f[!tg&<g\u000eK\u0002\u0003jjAaA!=\u0001\t\u0003\u0011\u0012a\u000b;fgR\u0004VM\u001d)beRLG/[8o\u0019\u0006<W*\u001a;sS\u000e\u001c8\t\\3b]V\u0003x+\u001b;i\u0003N\u001c\u0018n\u001a8)\u0007\t=(\u0004\u0003\u0004\u0003x\u0002!\tAE\u0001,i\u0016\u001cH\u000fU3s!\u0006\u0014H/\u001b;j_:d\u0015mZ'fiJL7m],iK:\u0014V-\u00193D_6l\u0017\u000e\u001e;fI\"\u001a!Q\u001f\u000e\t\r\tu\b\u0001\"\u0001\u0013\u0003\u0019\"Xm\u001d;QKJ\u0004\u0016M\u001d;ji&|g\u000eT3bI^KG\u000f['bqB{G\u000e\u001c*fG>\u0014Hm\u001d\u0015\u0004\u0005wT\u0002BBB\u0002\u0001\u0011\u0005!#A\u0013uKN$\b+\u001a:QCJ$\u0018\u000e^5p]2\u000bwmV5uQ6\u000b\u0007\u0010U8mYJ+7m\u001c:eg\"\u001a1\u0011\u0001\u000e\t\r\r%\u0001\u0001\"\u0001\u0013\u00039\"Xm\u001d;Rk>$\u0018-T3ue&\u001c7OT8u\u0007J,\u0017\r^3e\u0013\u001atu.U;pi\u0006\u001c8i\u001c8gS\u001e,(/\u001a3)\u0007\r\u001d!\u0004C\u0004\u0004\u0010\u0001!\ta!\u0005\u0002EI,h.T;mi&\u001cuN\\:v[\u0016\u00148+Z:tS>tG+[7f_V$H+Z:u)\r\u001921\u0003\u0005\b\u0007+\u0019i\u00011\u0001}\u00035\u0019Gn\\:f\u0007>t7/^7fe\"91\u0011\u0004\u0001\u0005\u0002\rm\u0011AE:vEN\u001c'/\u001b2f\u0007>t7/^7feN$ba!\b\u0004:\r=\u0003CBB\u0010\u0007S\u0019i#\u0004\u0002\u0004\")!11EB\u0013\u0003\u001diW\u000f^1cY\u0016T1aa\n\u0016\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0007W\u0019\tC\u0001\u0004Ck\u001a4WM\u001d\t\u0005\u0007_\u0019\t$D\u0001\u0001\u0013\u0011\u0019\u0019d!\u000e\u00031\r{gn];nKJ\f5o]5h]6,g\u000e\u001e)pY2,'/C\u0002\u00048\t\u0011A#\u00112tiJ\f7\r^\"p]N,X.\u001a:UKN$\b\u0002CB\u001e\u0007/\u0001\ra!\u0010\u0002\u001b\r|gn];nKJ<%o\\;q!\u0019\u0019yb!\u000b\u0004@A11\u0011IB&qaj!aa\u0011\u000b\t\r\u00153qI\u0001\tG>t7/^7fe*\u00191\u0011J\u001a\u0002\u000f\rd\u0017.\u001a8ug&!1QJB\"\u00055Y\u0015MZ6b\u0007>t7/^7fe\"A1\u0011KB\f\u0001\u0004\u0019\u0019&A\tu_BL7m\u001d+p'V\u00147o\u0019:jE\u0016\u0004Ra!\u0016\u0004fIsAaa\u0016\u0004b9!1\u0011LB0\u001b\t\u0019YFC\u0002\u0004^\u0019\ta\u0001\u0010:p_Rt\u0014\"\u0001\f\n\u0007\r\rT#A\u0004qC\u000e\\\u0017mZ3\n\t\r\u001d4\u0011\u000e\u0002\u0005\u0019&\u001cHOC\u0002\u0004dUAqa!\u001c\u0001\t\u0003\u0019y'A\rde\u0016\fG/\u001a+pa&\u001c\u0017I\u001c3TK:$'+Z2pe\u0012\u001cHCCB9\u0007o\u001a)i!#\u0004\u000eB)1ka\u001d\u0003&%\u00191Q\u000f-\u0003\u0007M+G\u000f\u0003\u0005\u0004z\r-\u0004\u0019AB>\u0003!\u0001(o\u001c3vG\u0016\u0014\bCBB?\u0007\u0003C\u0004(\u0004\u0002\u0004\u0000)!1\u0011PB$\u0013\u0011\u0019\u0019ia \u0003\u001b-\u000bgm[1Qe>$WoY3s\u0011\u001d\u00199ia\u001bA\u0002I\u000b\u0011\u0002^8qS\u000et\u0015-\\3\t\u0011\r-51\u000ea\u0001\u00057\tQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b\u0002CBH\u0007W\u0002\rAa\u0007\u0002'I,7m\u001c:egB+'\u000fU1si&$\u0018n\u001c8\t\u000f\rM\u0005\u0001\"\u0001\u0004\u0016\u000693M]3bi\u0016\u001cuN\\:v[\u0016\u0014xI]8va\u0006sGmV1ji\u001a{'/Q:tS\u001etW.\u001a8u)!\u00199j!(\u0004\"\u000e\r\u0006c\u0002\u000b\u0004\u001a\u000eu2QD\u0005\u0004\u00077+\"A\u0002+va2,'\u0007\u0003\u0005\u0004 \u000eE\u0005\u0019\u0001B\u000e\u00035\u0019wN\\:v[\u0016\u00148i\\;oi\"A1\u0011KBI\u0001\u0004\u0019\u0019\u0006\u0003\u0005\u0004&\u000eE\u0005\u0019AB9\u00035\u0019XOY:de&\u0004H/[8og\"91\u0011\u0016\u0001\u0005\u0002\r-\u0016\u0001N2iC:<WmQ8ogVlWM]$s_V\u00048+\u001e2tGJL\u0007\u000f^5p]\u0006sGMV1mS\u0012\fG/Z!tg&<g.\\3oiR91c!,\u00042\u000eM\u0006\u0002CBX\u0007O\u0003\ra!\b\u0002\u001f\r|gn];nKJ\u0004v\u000e\u001c7feND\u0001b!\u0015\u0004(\u0002\u000711\u000b\u0005\t\u0007K\u001b9\u000b1\u0001\u0004r!91q\u0017\u0001\u0005\u0002\re\u0016aL2iC:<WmQ8ogVlWM]*vEN\u001c'/\u001b9uS>t\u0017I\u001c3WC2LG-\u0019;f\u0003N\u001c\u0018n\u001a8nK:$XCBB^\u0007\u000f\u001ci\rF\u0005\u0014\u0007{\u001b\tna5\u0004X\"A1QIB[\u0001\u0004\u0019y\f\u0005\u0005\u0004B\r\u00057QYBf\u0013\u0011\u0019\u0019ma\u0011\u0003\u0011\r{gn];nKJ\u00042\u0001]Bd\t\u001d\u0019Im!.C\u0002M\u0014\u0011a\u0013\t\u0004a\u000e5GaBBh\u0007k\u0013\ra\u001d\u0002\u0002-\"A1\u0011KB[\u0001\u0004\u0019\u0019\u0006\u0003\u0005\u0004V\u000eU\u0006\u0019AB9\u0003I)\u0007\u0010]3di\u0016$\u0017i]:jO:lWM\u001c;\t\u0011\re7Q\u0017a\u0001\u00077\f\u0011C]3cC2\fgnY3MSN$XM\\3s!\u0011\u0019\te!8\n\t\r}71\t\u0002\u001a\u0007>t7/^7feJ+'-\u00197b]\u000e,G*[:uK:,'\u000fC\u0004\u0004d\u0002!Ia!:\u0002)\u0005<\u0018-\u001b;O_:,U\u000e\u001d;z%\u0016\u001cwN\u001d3t+\u0019\u00199o!=\u0004vR11\u0011^B|\u0007w\u0004\u0002b!\u0011\u0004l\u000e=81_\u0005\u0005\u0007[\u001c\u0019EA\bD_:\u001cX/\\3s%\u0016\u001cwN\u001d3t!\r\u00018\u0011\u001f\u0003\b\u0007\u0013\u001c\tO1\u0001t!\r\u00018Q\u001f\u0003\b\u0007\u001f\u001c\tO1\u0001t\u0011!\u0019)e!9A\u0002\re\b\u0003CB!\u0007\u0003\u001cyoa=\t\u0011\ru8\u0011\u001da\u0001\u0005K\t\u0011\u0002]1si&$\u0018n\u001c8\t\u000f\u0011\u0005\u0001\u0001\"\u0003\u0005\u0004\u0005y\u0011m^1ji\u0006\u001b8/[4o[\u0016tG\u000fF\u0003\u0014\t\u000b!9\u0002\u0003\u0005\u0004F\r}\b\u0019\u0001C\u0004a\u0019!I\u0001\"\u0004\u0005\u0014AA1\u0011IBa\t\u0017!\t\u0002E\u0002q\t\u001b!1\u0002b\u0004\u0005\u0006\u0005\u0005\t\u0011!B\u0001g\n\u0019q\fJ\u001a\u0011\u0007A$\u0019\u0002B\u0006\u0005\u0016\u0011\u0015\u0011\u0011!A\u0001\u0006\u0003\u0019(aA0%i!A1Q[B\u0000\u0001\u0004\u0019\t\b\u0003\u0004\u0005\u001c\u0001!\tAE\u0001\u001di\u0016\u001cHoQ8ogVl\u0017N\\4XSRDg*\u001e7m\u000fJ|W\u000f]%eQ\r!IB\u0007\u0005\u0007\tC\u0001A\u0011\u0001\n\u0002;Q,7\u000f^\"p]N,X.\u001b8h/&$\b.R7qif<%o\\;q\u0013\u0012D3\u0001b\b\u001b\u0001")
public class PlaintextConsumerTest
extends BaseConsumerTest {
    @Test
    public void testHeaders() {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        record.headers().add("headerKey", "headerValue".getBytes());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(record);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((long)1L, (long)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        ArrayBuffer records2 = this.consumeRecords(consumer, numRecords, this.consumeRecords$default$3());
        Assert.assertEquals((long)numRecords, (long)records2.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)new Serializable(this, records2){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer records$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ConsumerRecord record = (ConsumerRecord)this.records$1.apply(i);
                Header header = record.headers().lastHeader("headerKey");
                Assert.assertEquals((Object)"headerValue", (Object)(header == null ? null : new String(header.value())));
            }
            {
                this.records$1 = records$1;
            }
        });
    }

    private void testHeadersSerializeDeserialize(Serializer<byte[]> serializer, Deserializer<byte[]> deserializer) {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        KafkaProducer producer = this.createProducer(new ByteArraySerializer(), serializer, this.createProducer$default$3());
        producer.send(record);
        KafkaConsumer consumer = this.createConsumer(new ByteArrayDeserializer(), deserializer, this.createConsumer$default$3(), this.createConsumer$default$4());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((long)1L, (long)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        ArrayBuffer records2 = this.consumeRecords(consumer, numRecords, this.consumeRecords$default$3());
        Assert.assertEquals((long)numRecords, (long)records2.size());
    }

    @Test
    public void testDeprecatedPollBlocksForAssignment() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        consumer.poll(0L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala());
    }

    @Test
    public void testHeadersExtendedSerializerDeserializer() {
        ExtendedSerializer<byte[]> extendedSerializer = new ExtendedSerializer<byte[]>(this){
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private ByteArraySerializer serializer;

            public ByteArraySerializer serializer() {
                return this.serializer;
            }

            @TraitSetter
            public void serializer_$eq(ByteArraySerializer x$1) {
                this.serializer = x$1;
            }

            public byte[] serialize(String topic, Headers headers, byte[] data) {
                return PlaintextConsumerTest$SerializerImpl$class.serialize(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                PlaintextConsumerTest$SerializerImpl$class.configure(this, configs, isKey);
            }

            public void close() {
                PlaintextConsumerTest$SerializerImpl$class.close(this);
            }

            public byte[] serialize(String topic, byte[] data) {
                return PlaintextConsumerTest$SerializerImpl$class.serialize(this, topic, data);
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                PlaintextConsumerTest$SerializerImpl$class.$init$(this);
            }
        };
        ExtendedDeserializer<byte[]> extendedDeserializer = new ExtendedDeserializer<byte[]>(this){
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private ByteArrayDeserializer deserializer;

            public ByteArrayDeserializer deserializer() {
                return this.deserializer;
            }

            @TraitSetter
            public void deserializer_$eq(ByteArrayDeserializer x$1) {
                this.deserializer = x$1;
            }

            public byte[] deserialize(String topic, Headers headers, byte[] data) {
                return PlaintextConsumerTest$DeserializerImpl$class.deserialize(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                PlaintextConsumerTest$DeserializerImpl$class.configure(this, configs, isKey);
            }

            public void close() {
                PlaintextConsumerTest$DeserializerImpl$class.close(this);
            }

            public byte[] deserialize(String topic, byte[] data) {
                return PlaintextConsumerTest$DeserializerImpl$class.deserialize(this, topic, data);
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                PlaintextConsumerTest$DeserializerImpl$class.$init$(this);
            }
        };
        this.testHeadersSerializeDeserialize((Serializer<byte[]>)extendedSerializer, (Deserializer<byte[]>)extendedDeserializer);
    }

    @Test
    public void testHeadersSerializerDeserializer() {
        SerializerImpl extendedSerializer = new SerializerImpl(this){
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private ByteArraySerializer serializer;

            public ByteArraySerializer serializer() {
                return this.serializer;
            }

            @TraitSetter
            public void serializer_$eq(ByteArraySerializer x$1) {
                this.serializer = x$1;
            }

            public byte[] serialize(String topic, Headers headers, byte[] data) {
                return PlaintextConsumerTest$SerializerImpl$class.serialize(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                PlaintextConsumerTest$SerializerImpl$class.configure(this, configs, isKey);
            }

            public void close() {
                PlaintextConsumerTest$SerializerImpl$class.close(this);
            }

            public byte[] serialize(String topic, byte[] data) {
                return PlaintextConsumerTest$SerializerImpl$class.serialize(this, topic, data);
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                PlaintextConsumerTest$SerializerImpl$class.$init$(this);
            }
        };
        DeserializerImpl extendedDeserializer = new DeserializerImpl(this){
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private ByteArrayDeserializer deserializer;

            public ByteArrayDeserializer deserializer() {
                return this.deserializer;
            }

            @TraitSetter
            public void deserializer_$eq(ByteArrayDeserializer x$1) {
                this.deserializer = x$1;
            }

            public byte[] deserialize(String topic, Headers headers, byte[] data) {
                return PlaintextConsumerTest$DeserializerImpl$class.deserialize(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                PlaintextConsumerTest$DeserializerImpl$class.configure(this, configs, isKey);
            }

            public void close() {
                PlaintextConsumerTest$DeserializerImpl$class.close(this);
            }

            public byte[] deserialize(String topic, byte[] data) {
                return PlaintextConsumerTest$DeserializerImpl$class.deserialize(this, topic, data);
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                PlaintextConsumerTest$DeserializerImpl$class.$init$(this);
            }
        };
        this.testHeadersSerializeDeserialize(extendedSerializer, extendedDeserializer);
    }

    @Test
    public void testMaxPollRecords() {
        int maxPollRecords = 2;
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        this.consumerConfig().setProperty("max.poll.records", ((Object)BoxesRunTime.boxToInteger((int)maxPollRecords)).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        KafkaConsumer x$20 = consumer;
        int x$21 = numRecords;
        int x$22 = 0;
        int x$23 = maxPollRecords;
        int x$24 = this.consumeAndVerifyRecords$default$4();
        long x$25 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$26 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$27 = this.consumeAndVerifyRecords$default$7();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$20, x$21, x$22, x$24, x$25, x$26, x$27, x$23);
    }

    @Test
    public void testMaxPollIntervalMs() {
        this.consumerConfig().setProperty("max.poll.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)3000)).toString());
        this.consumerConfig().setProperty("heartbeat.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)500)).toString());
        this.consumerConfig().setProperty("session.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)2000)).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Assert.assertEquals((long)0L, (long)listener.callsToRevoked());
        Thread.sleep(3500L);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assert.assertEquals((long)2L, (long)listener.callsToAssigned());
        Assert.assertEquals((long)1L, (long)listener.callsToRevoked());
    }

    @Test
    public void testMaxPollIntervalMsDelayInRevocation() {
        this.consumerConfig().setProperty("max.poll.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)5000)).toString());
        this.consumerConfig().setProperty("heartbeat.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)500)).toString());
        this.consumerConfig().setProperty("session.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)1000)).toString());
        this.consumerConfig().setProperty("enable.auto.commit", ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        BooleanRef commitCompleted = BooleanRef.create((boolean)false);
        LongRef committedPosition = LongRef.create((long)-1L);
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this, consumer, commitCompleted, committedPosition){
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaConsumer consumer$1;
            private final BooleanRef commitCompleted$1;
            private final LongRef committedPosition$1;

            public void onPartitionsLost(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                if (!partitions.isEmpty() && partitions.contains(this.$outer.tp())) {
                    Utils.sleep((long)1500L);
                    this.committedPosition$1.elem = this.consumer$1.position(this.$outer.tp());
                    this.consumer$1.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.tp()), (Object)new OffsetAndMetadata(this.committedPosition$1.elem))}))).asJava());
                    this.commitCompleted$1.elem = true;
                }
                super.onPartitionsRevoked(partitions);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$1 = consumer$1;
                this.commitCompleted$1 = commitCompleted$1;
                this.committedPosition$1 = committedPosition$1;
            }
        };
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"otherTopic"}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assert.assertEquals((long)0L, (long)committedPosition.elem);
        Assert.assertTrue((boolean)commitCompleted.elem);
    }

    @Test
    public void testMaxPollIntervalMsDelayInAssignment() {
        this.consumerConfig().setProperty("max.poll.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)5000)).toString());
        this.consumerConfig().setProperty("heartbeat.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)500)).toString());
        this.consumerConfig().setProperty("session.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)1000)).toString());
        this.consumerConfig().setProperty("enable.auto.commit", ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this){

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                Utils.sleep((long)1500L);
                super.onPartitionsAssigned(partitions);
            }
        };
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        this.ensureNoRebalance((Consumer<?, ?>)consumer, listener);
    }

    @Test
    public void testAutoCommitOnClose() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.close();
        KafkaConsumer anotherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assert.assertEquals((long)300L, (long)((OffsetAndMetadata)anotherConsumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assert.assertEquals((long)500L, (long)((OffsetAndMetadata)anotherConsumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @Test
    public void testAutoCommitOnCloseAfterWakeup() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.wakeup();
        consumer.close();
        KafkaConsumer anotherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assert.assertEquals((long)300L, (long)((OffsetAndMetadata)anotherConsumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assert.assertEquals((long)500L, (long)((OffsetAndMetadata)anotherConsumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @Test
    public void testAutoOffsetReset() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 1, this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testGroupConsumption() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testPatternSubscription() {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.brokerCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 0));
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 1));
        String topic2 = "tblablak";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic2, 0));
        this.sendRecords(producer, 1000, new TopicPartition(topic2, 1));
        String topic3 = "tblab1";
        this.createTopic(topic3, 2, this.brokerCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic3, 0));
        this.sendRecords(producer, 1000, new TopicPartition(topic3, 1));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        Pattern pattern = Pattern.compile("t.*c");
        consumer.subscribe(pattern, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        scala.collection.immutable.Set assignment2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment2);
        String topic4 = "tsomec";
        this.createTopic(topic4, 2, this.brokerCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic4, 0));
        this.sendRecords(producer, 1000, new TopicPartition(topic4, 1));
        assignment2 = (scala.collection.immutable.Set)assignment2.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic4, 0), new TopicPartition(topic4, 1)})));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment2);
        consumer.unsubscribe();
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
    }

    @Test
    public void testSubsequentPatternSubscription() {
        this.consumerConfig().setProperty("metadata.max.age.ms", "30000");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        String fooTopic = "foo";
        this.createTopic(fooTopic, 1, this.brokerCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(fooTopic, 0));
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        Pattern pattern1 = Pattern.compile(".*o.*");
        consumer.subscribe(pattern1, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        scala.collection.immutable.Set assignment2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(fooTopic, 0)}));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment2);
        String barTopic = "bar";
        this.createTopic(barTopic, 1, this.brokerCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(barTopic, 0));
        Pattern pattern2 = Pattern.compile("...");
        consumer.subscribe(pattern2, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        assignment2 = (scala.collection.immutable.Set)assignment2.$minus$minus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)})));
        assignment2 = (scala.collection.immutable.Set)assignment2.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(barTopic, 0)})));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment2);
        consumer.unsubscribe();
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
    }

    @Test
    public void testPatternUnsubscription() {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.brokerCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 0));
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 1));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        consumer.subscribe(Pattern.compile("t.*c"), (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        scala.collection.immutable.Set assignment2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment2);
        consumer.unsubscribe();
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
    }

    @Test
    public void testCommitMetadata() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        OffsetAndMetadata syncMetadata = new OffsetAndMetadata(5L, Optional.of(Predef$.MODULE$.int2Integer(15)), "foo");
        consumer.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)syncMetadata)}))).asJava());
        Assert.assertEquals((Object)syncMetadata, consumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
        OffsetAndMetadata asyncMetadata = new OffsetAndMetadata(10L, "bar");
        this.sendAndAwaitAsyncCommit(consumer, (Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)asyncMetadata)}))));
        Assert.assertEquals((Object)asyncMetadata, consumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
        OffsetAndMetadata nullMetadata = new OffsetAndMetadata(5L, null);
        consumer.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)nullMetadata)}))).asJava());
        Assert.assertEquals((Object)nullMetadata, consumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
    }

    @Test
    public void testAsyncCommit() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        AbstractConsumerTest.CountConsumerCommitCallback callback2 = new AbstractConsumerTest.CountConsumerCommitCallback();
        int count = 5;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).foreach$mVc$sp((Function1)new Serializable(this, consumer, callback2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaConsumer consumer$3;
            private final AbstractConsumerTest.CountConsumerCommitCallback callback$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.consumer$3.commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.tp()), (Object)new OffsetAndMetadata((long)i))}))).asJava(), (OffsetCommitCallback)this.callback$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$3 = consumer$3;
                this.callback$1 = callback$1;
            }
        });
        TestUtils$.MODULE$.pollUntilTrue((Consumer<?, ?>)consumer, (Function0<Object>)new Serializable(this, callback2, count){
            public static final long serialVersionUID = 0L;
            private final AbstractConsumerTest.CountConsumerCommitCallback callback$1;
            private final int count$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.callback$1.successCount() >= this.count$1 || this.callback$1.lastError().isDefined();
            }
            {
                this.callback$1 = callback$1;
                this.count$1 = count$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to observe commit callback before timeout";
            }
        }, 10000L);
        Assert.assertEquals((Object)None$.MODULE$, callback2.lastError());
        Assert.assertEquals((long)count, (long)callback2.successCount());
        Assert.assertEquals((Object)new OffsetAndMetadata((long)count), consumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
    }

    @Test
    public void testExpandingTopicSubscriptions() {
        String otherTopic = "other";
        scala.collection.immutable.Set initialAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)initialAssignment);
        this.createTopic(otherTopic, 2, this.brokerCount(), this.createTopic$default$4());
        scala.collection.immutable.Set expandedAssignment = (scala.collection.immutable.Set)initialAssignment.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)})));
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), otherTopic}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)expandedAssignment);
    }

    @Test
    public void testShrinkingTopicSubscriptions() {
        String otherTopic = "other";
        this.createTopic(otherTopic, 2, this.brokerCount(), this.createTopic$default$4());
        scala.collection.immutable.Set initialAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)}));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), otherTopic}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)initialAssignment);
        scala.collection.immutable.Set shrunkenAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)shrunkenAssignment);
    }

    @Test
    public void testPartitionsFor() {
        int numParts = 2;
        this.createTopic("part-test", numParts, 1, this.createTopic$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        java.util.List parts = consumer.partitionsFor("part-test");
        Assert.assertNotNull((Object)parts);
        Assert.assertEquals((long)2L, (long)parts.size());
    }

    @Test
    public void testPartitionsForAutoCreate() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        java.util.List partitions = consumer.partitionsFor("non-exist-topic");
        Assert.assertFalse((boolean)partitions.isEmpty());
    }

    @Test(expected=InvalidTopicException.class)
    public void testPartitionsForInvalidTopic() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.partitionsFor(";3# ads,{234");
    }

    @Test
    public void testSeek() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        long totalRecords = 50L;
        long mid = totalRecords / 2L;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, (int)totalRecords, this.tp());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.seekToEnd((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((long)totalRecords, (long)consumer.position(this.tp()));
        Assert.assertTrue((boolean)consumer.poll(Duration.ofMillis(50L)).isEmpty());
        consumer.seekToBeginning((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((float)0.0f, (float)consumer.position(this.tp()), (float)0.0f);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        consumer.seek(this.tp(), mid);
        Assert.assertEquals((long)mid, (long)consumer.position(this.tp()));
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, (int)mid, (int)mid, mid, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.sendCompressedMessages((int)totalRecords, this.tp2());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        consumer.seekToEnd((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        Assert.assertEquals((long)totalRecords, (long)consumer.position(this.tp2()));
        Assert.assertTrue((boolean)consumer.poll(Duration.ofMillis(50L)).isEmpty());
        consumer.seekToBeginning((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        Assert.assertEquals((float)0.0f, (float)consumer.position(this.tp2()), (float)0.0f);
        KafkaConsumer x$28 = consumer;
        int x$29 = 1;
        int x$30 = 0;
        TopicPartition x$31 = this.tp2();
        int x$32 = this.consumeAndVerifyRecords$default$4();
        long x$33 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$34 = this.consumeAndVerifyRecords$default$6();
        int x$35 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$28, x$29, x$30, x$32, x$33, x$34, x$31, x$35);
        consumer.seek(this.tp2(), mid);
        Assert.assertEquals((long)mid, (long)consumer.position(this.tp2()));
        KafkaConsumer x$36 = consumer;
        int x$37 = 1;
        int x$38 = (int)mid;
        int x$39 = (int)mid;
        long x$40 = mid;
        TopicPartition x$41 = this.tp2();
        TimestampType x$42 = this.consumeAndVerifyRecords$default$6();
        int x$43 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$36, x$37, x$38, x$39, x$40, x$42, x$41, x$43);
    }

    private void sendCompressedMessages(int numRecords, TopicPartition tp) {
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", CompressionType.GZIP.name);
        producerProps.setProperty("linger.ms", ((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)).toString());
        Properties x$44 = producerProps;
        ByteArraySerializer x$45 = this.createProducer$default$1();
        ByteArraySerializer x$46 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$45, x$46, x$44);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(this, tp, producer){
            public static final long serialVersionUID = 0L;
            private final TopicPartition tp$1;
            private final KafkaProducer producer$1;

            public final Future<RecordMetadata> apply(int i) {
                return this.producer$1.send(new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), Predef$.MODULE$.long2Long((long)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes()));
            }
            {
                this.tp$1 = tp$1;
                this.producer$1 = producer$1;
            }
        });
        producer.close();
    }

    @Test
    public void testPositionAndCommit() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 5, this.tp());
        TopicPartition topicPartition = new TopicPartition(this.topic(), 15);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assert.assertNull(consumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))).asJava()).get(topicPartition));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, topicPartition, consumer){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$1;
            private final KafkaConsumer consumer$4;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.consumer$4.position(this.topicPartition$1);
            }
            {
                this.topicPartition$1 = topicPartition$1;
                this.consumer$4 = consumer$4;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630));
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((String)"position() on a partition that we are subscribed to should reset the offset", (long)0L, (long)consumer.position(this.tp()));
        consumer.commitSync();
        Assert.assertEquals((long)0L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 5, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        Assert.assertEquals((String)"After consuming 5 records, position should be 5", (long)5L, (long)consumer.position(this.tp()));
        consumer.commitSync();
        Assert.assertEquals((String)"Committed offset should be returned", (long)5L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        this.sendRecords(producer, 1, this.tp());
        KafkaConsumer otherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        otherConsumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)otherConsumer, 1, 5, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testPartitionPauseAndResume() {
        java.util.List partitions = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 5, this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)partitions);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 5, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        consumer.pause((Collection)partitions);
        this.sendRecords(producer, 5, this.tp());
        Assert.assertTrue((boolean)consumer.poll(Duration.ofMillis(100L)).isEmpty());
        consumer.resume((Collection)partitions);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 5, 5, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testFetchInvalidOffset() {
        this.consumerConfig().setProperty("auto.offset.reset", "none");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int totalRecords = 2;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, totalRecords, this.tp());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$5;

            public final ConsumerRecords<byte[], byte[]> apply() {
                return this.consumer$5.poll(Duration.ofMillis(50L));
            }
            {
                this.consumer$5 = consumer$5;
            }
        }, ClassTag$.MODULE$.apply(NoOffsetForPartitionException.class), new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 681));
        int outOfRangePos = totalRecords + 1;
        consumer.seek(this.tp(), (long)outOfRangePos);
        OffsetOutOfRangeException e = (OffsetOutOfRangeException)Assertions$.MODULE$.intercept((Function0)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$5;

            public final ConsumerRecords<byte[], byte[]> apply() {
                return this.consumer$5.poll(Duration.ofMillis(20000L));
            }
            {
                this.consumer$5 = consumer$5;
            }
        }, ClassTag$.MODULE$.apply(OffsetOutOfRangeException.class), new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
        java.util.Map outOfRangePartitions = e.offsetOutOfRangePartitions();
        Assert.assertNotNull((Object)outOfRangePartitions);
        Assert.assertEquals((long)1L, (long)outOfRangePartitions.size());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)outOfRangePos), outOfRangePartitions.get(this.tp()));
    }

    @Test
    public void testFetchRecordLargerThanFetchMaxBytes() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxFetchBytes)).toString());
        this.checkLargeRecord(maxFetchBytes + 1);
    }

    private void checkLargeRecord(int producerRecordSize) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)new byte[producerRecordSize]);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(record);
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records2 = consumer.poll(Duration.ofMillis(20000L));
        Assert.assertEquals((long)1L, (long)records2.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records2.iterator().next();
        Assert.assertEquals((long)0L, (long)consumerRecord.offset());
        Assert.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assert.assertEquals((long)this.tp().partition(), (long)consumerRecord.partition());
        Assert.assertArrayEquals((byte[])((byte[])record.key()), (byte[])((byte[])consumerRecord.key()));
        Assert.assertArrayEquals((byte[])((byte[])record.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @Test
    public void testFetchHonoursFetchSizeIfLargeRecordNotFirst() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxFetchBytes)).toString());
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxFetchBytes);
    }

    private void checkFetchHonoursSizeIfLargeRecordNotFirst(int largeProducerRecordSize) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        ProducerRecord smallRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"small".getBytes(), (Object)"value".getBytes());
        ProducerRecord largeRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"large".getBytes(), (Object)new byte[largeProducerRecordSize]);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(smallRecord).get();
        producer.send(largeRecord).get();
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records2 = consumer.poll(Duration.ofMillis(20000L));
        Assert.assertEquals((long)1L, (long)records2.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records2.iterator().next();
        Assert.assertEquals((long)0L, (long)consumerRecord.offset());
        Assert.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assert.assertEquals((long)this.tp().partition(), (long)consumerRecord.partition());
        Assert.assertArrayEquals((byte[])((byte[])smallRecord.key()), (byte[])((byte[])consumerRecord.key()));
        Assert.assertArrayEquals((byte[])((byte[])smallRecord.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @Test
    public void testFetchHonoursMaxPartitionFetchBytesIfLargeRecordNotFirst() {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxPartitionFetchBytes)).toString());
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxPartitionFetchBytes);
    }

    @Test
    public void testFetchRecordLargerThanMaxPartitionFetchBytes() {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxPartitionFetchBytes)).toString());
        this.checkLargeRecord(maxPartitionFetchBytes + 1);
    }

    @Test
    public void testLowMaxFetchSizeForRequestAndPartition() {
        this.consumerConfig().setProperty("fetch.max.bytes", "500");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", "100");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic1 = "topic1";
        String topic2 = "topic2";
        String topic3 = "topic3";
        int partitionCount = 30;
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}));
        topics.foreach((Function1)new Serializable(this, partitionCount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final int partitionCount$1;

            public final scala.collection.immutable.Map<Object, Object> apply(String topicName) {
                return this.$outer.createTopic(topicName, this.partitionCount$1, this.$outer.brokerCount(), this.$outer.createTopic$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionCount$1 = partitionCount$1;
            }
        });
        Seq partitions = (Seq)topics.flatMap((Function1)new Serializable(this, partitionCount){
            public static final long serialVersionUID = 0L;
            private final int partitionCount$1;

            public final IndexedSeq<TopicPartition> apply(String topic) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.partitionCount$1).map((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$3;

                    public final TopicPartition apply(int x$1) {
                        return new TopicPartition(this.topic$3, x$1);
                    }
                    {
                        this.topic$3 = topic$3;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.partitionCount$1 = partitionCount$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)partitions.toSet());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Seq producerRecords = (Seq)partitions.flatMap((Function1)new Serializable(this, partitionCount, producer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final int partitionCount$1;
            private final KafkaProducer producer$2;

            public final Seq<ProducerRecord<byte[], byte[]>> apply(TopicPartition x$2) {
                return this.$outer.sendRecords((KafkaProducer<byte[], byte[]>)this.producer$2, this.partitionCount$1, x$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionCount$1 = partitionCount$1;
                this.producer$2 = producer$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ArrayBuffer consumerRecords = this.consumeRecords(consumer, producerRecords.size(), this.consumeRecords$default$3());
        scala.collection.immutable.Set expected = ((TraversableOnce)producerRecords.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple5<String, Integer, String, String, Long> apply(ProducerRecord<byte[], byte[]> record) {
                return new Tuple5((Object)record.topic(), (Object)record.partition(), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)record.timestamp());
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set actual = ((TraversableOnce)consumerRecords.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple5<String, Object, String, String, Object> apply(ConsumerRecord<byte[], byte[]> record) {
                return new Tuple5((Object)record.topic(), (Object)BoxesRunTime.boxToInteger((int)record.partition()), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)BoxesRunTime.boxToLong((long)record.timestamp()));
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).toSet();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testRoundRobinAssignment() {
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic1 = "topic1";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set expectedAssignment = (scala.collection.immutable.Set)this.createTopicAndSendRecords(producer, topic1, 2, 100).$plus$plus(this.createTopicAndSendRecords(producer, topic2, 2, 100));
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)expectedAssignment);
        String topic3 = "topic3";
        this.createTopicAndSendRecords(producer, topic3, 2, 100);
        scala.collection.immutable.Set newExpectedAssignment = (scala.collection.immutable.Set)expectedAssignment.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic3, 0), new TopicPartition(topic3, 1)})));
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)newExpectedAssignment);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)expectedAssignment);
        consumer.unsubscribe();
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testMultiConsumerRoundRobinAssignment() {
        Tuple2 tuple22;
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        String topic1 = "topic1";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)this.createTopicAndSendRecords(producer, topic1, 5, 100).$plus$plus(this.createTopicAndSendRecords(producer, topic2, 8, 100));
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(10, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        if (tuple2 == null) throw new MatchError(tuple2);
        Buffer consumerGroup = (Buffer)tuple2._1();
        Buffer consumerPollers = (Buffer)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)consumerGroup, (Object)consumerPollers);
        Buffer consumerGroup2 = (Buffer)tuple23._1();
        Buffer consumerPollers2 = (Buffer)tuple23._2();
        try {
            this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4());
            this.addConsumersToGroupAndWaitForGroupAssignment(1, (Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup2, (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)subscriptions, "roundrobin-group");
        }
        catch (Throwable throwable) {
            void var11_11;
            var11_11.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(AbstractConsumerTest.ConsumerAssignmentPoller x$4) {
                    x$4.shutdown();
                }
            });
            throw throwable;
        }
        consumerPollers2.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    @Test
    public void testMultiConsumerStickyAssignment() {
        this.consumerConfig().setProperty("group.id", "sticky-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", StickyAssignor.class.getName());
        String topic = "single-topic";
        int rand = 1 + Random$.MODULE$.nextInt(10);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicAndSendRecords(producer, topic, rand * 10, 100);
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(9, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), partitions);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Buffer consumerGroup = (Buffer)tuple2._1();
            Buffer consumerPollers = (Buffer)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)consumerGroup, (Object)consumerPollers);
            Buffer consumerGroup2 = (Buffer)tuple23._1();
            Buffer consumerPollers2 = (Buffer)tuple23._2();
            this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, partitions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4());
            scala.collection.immutable.Map prePartition2PollerId = this.reverse$1(((TraversableOnce)consumerPollers2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, scala.collection.immutable.Set<TopicPartition>> apply(AbstractConsumerTest.ConsumerAssignmentPoller poller) {
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)poller.getId()), poller.consumerAssignment());
                }
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            this.addConsumersToGroupAndWaitForGroupAssignment(1, (Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup2, (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), partitions, "sticky-group");
            scala.collection.immutable.Map postPartition2PollerId = this.reverse$1(((TraversableOnce)consumerPollers2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, scala.collection.immutable.Set<TopicPartition>> apply(AbstractConsumerTest.ConsumerAssignmentPoller poller) {
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)poller.getId()), poller.consumerAssignment());
                }
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            scala.collection.immutable.Set keys = (scala.collection.immutable.Set)prePartition2PollerId.keySet().union((GenSet)postPartition2PollerId.keySet());
            IntRef changes = IntRef.create((int)0);
            keys.foreach((Function1)new Serializable(this, prePartition2PollerId, postPartition2PollerId, changes){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map prePartition2PollerId$1;
                private final scala.collection.immutable.Map postPartition2PollerId$1;
                private final IntRef changes$1;

                public final void apply(TopicPartition key) {
                    Option preVal = this.prePartition2PollerId$1.get((Object)key);
                    Option postVal = this.postPartition2PollerId$1.get((Object)key);
                    if (preVal.nonEmpty() && postVal.nonEmpty()) {
                        if (BoxesRunTime.unboxToLong((Object)preVal.get()) != BoxesRunTime.unboxToLong((Object)postVal.get())) {
                            ++this.changes$1.elem;
                        }
                    } else {
                        ++this.changes$1.elem;
                    }
                }
                {
                    this.prePartition2PollerId$1 = prePartition2PollerId$1;
                    this.postPartition2PollerId$1 = postPartition2PollerId$1;
                    this.changes$1 = changes$1;
                }
            });
            consumerPollers2.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(AbstractConsumerTest.ConsumerAssignmentPoller x$7) {
                    x$7.shutdown();
                }
            });
            Assert.assertEquals((String)"Expected only two topic partitions that have switched to other consumers.", (long)rand, (long)changes.elem);
            return;
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultiConsumerDefaultAssignment() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.tp());
        this.sendRecords(producer, 100, this.tp2());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(producer, topic1, 5, 100));
        Buffer consumersInGroup = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<KafkaConsumer<byte[], byte[]>>)consumersInGroup, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})));
        try {
            this.validateGroupAssignment(consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4());
            this.addConsumersToGroupAndWaitForGroupAssignment(2, (Buffer<KafkaConsumer<byte[], byte[]>>)consumersInGroup, consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})), (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.addConsumersToGroupAndWaitForGroupAssignment$default$6());
            String topic2 = "topic2";
            scala.collection.immutable.Set expandedSubscriptions = (scala.collection.immutable.Set)subscriptions.$plus$plus(this.createTopicAndSendRecords(producer, topic2, 3, 100));
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)expandedSubscriptions);
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(AbstractConsumerTest.ConsumerAssignmentPoller x$8) {
                    x$8.shutdown();
                }
            });
            throw throwable;
        }
        consumerPollers.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnStopPolling() {
        this.runMultiConsumerSessionTimeoutTest(false);
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnClose() {
        this.runMultiConsumerSessionTimeoutTest(true);
    }

    @Test
    public void testInterceptors() {
        String appendStr = "mock";
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
        Properties producerProps = new Properties();
        producerProps.put("interceptor.classes", MockProducerInterceptor.class.getName());
        producerProps.put("mock.interceptor.append", appendStr);
        KafkaProducer testProducer = this.createProducer(new StringSerializer(), new StringSerializer(), producerProps);
        int numRecords = 10;
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, testProducer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaProducer testProducer$1;

            public final Future<RecordMetadata> apply(int i) {
                return this.testProducer$1.send(new ProducerRecord(this.$outer.tp().topic(), Predef$.MODULE$.int2Integer(this.$outer.tp().partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.testProducer$1 = testProducer$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$9) {
                return x$9.get();
            }
        });
        Assert.assertEquals((long)numRecords, (long)MockProducerInterceptor.ONSEND_COUNT.intValue());
        Assert.assertEquals((long)numRecords, (long)MockProducerInterceptor.ON_SUCCESS_COUNT.intValue());
        try {
            testProducer.send(null);
            Assert.fail((String)"Should not allow sending a null record");
        }
        catch (Throwable throwable) {
            Assert.assertEquals((String)"Interceptor should be notified about exception", (long)1L, (long)MockProducerInterceptor.ON_ERROR_COUNT.intValue());
            Assert.assertEquals((String)"Interceptor should not receive metadata with an exception when record is null", (long)0L, (long)MockProducerInterceptor.ON_ERROR_WITH_METADATA_COUNT.intValue());
        }
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
        testConsumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        testConsumer.seek(this.tp(), 0L);
        ArrayBuffer records2 = this.consumeRecords(testConsumer, numRecords, this.consumeRecords$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)new Serializable(this, appendStr, records2){
            public static final long serialVersionUID = 0L;
            private final String appendStr$1;
            private final ArrayBuffer records$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ConsumerRecord record = (ConsumerRecord)this.records$2.apply(i);
                Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new String((String)record.key()));
                Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), this.appendStr$1})).toUpperCase(Locale.ROOT), (Object)new String((String)record.value()));
            }
            {
                this.appendStr$1 = appendStr$1;
                this.records$2 = records$2;
            }
        });
        int commitCountBefore = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        testConsumer.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(2L))}))).asJava());
        Assert.assertEquals((long)2L, (long)((OffsetAndMetadata)testConsumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assert.assertEquals((long)(commitCountBefore + 1), (long)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
        this.sendAndAwaitAsyncCommit(testConsumer, (Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new OffsetAndMetadata(5L))}))));
        Assert.assertEquals((long)5L, (long)((OffsetAndMetadata)testConsumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assert.assertEquals((long)(commitCountBefore + 2), (long)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
        testConsumer.close();
        testProducer.close();
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
    }

    @Test
    public void testAutoCommitIntercept() {
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4());
        int numRecords = 100;
        KafkaProducer testProducer = this.createProducer(new StringSerializer(), new StringSerializer(), this.createProducer$default$3());
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, testProducer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaProducer testProducer$2;

            public final Future<RecordMetadata> apply(int i) {
                return this.testProducer$2.send(new ProducerRecord(this.$outer.tp().topic(), Predef$.MODULE$.int2Integer(this.$outer.tp().partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.testProducer$2 = testProducer$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$10) {
                return x$10.get();
            }
        });
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(this, testConsumer){
            private final KafkaConsumer testConsumer$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.testConsumer$1.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.testConsumer$1 = testConsumer$1;
            }
        };
        this.changeConsumerSubscriptionAndValidateAssignment((Consumer)testConsumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))), rebalanceListener);
        testConsumer.seek(this.tp(), 10L);
        testConsumer.seek(this.tp2(), 20L);
        int commitCountBeforeRebalance = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        this.changeConsumerSubscriptionAndValidateAssignment((Consumer)testConsumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2})), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}))), rebalanceListener);
        Assert.assertEquals((long)10L, (long)((OffsetAndMetadata)testConsumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assert.assertEquals((long)20L, (long)((OffsetAndMetadata)testConsumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
        Assert.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeRebalance ? 1 : 0) != 0);
        int commitCountBeforeClose = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        testConsumer.close();
        Assert.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeClose ? 1 : 0) != 0);
        testProducer.close();
        MockConsumerInterceptor.resetCounters();
    }

    @Test
    public void testInterceptorsWithWrongKeyValue() {
        String appendStr = "mock";
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.brokerList());
        producerProps.put("interceptor.classes", "org.apache.kafka.test.MockProducerInterceptor");
        producerProps.put("mock.interceptor.append", appendStr);
        KafkaProducer testProducer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        testProducer.send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})).s((Seq)Nil$.MODULE$).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value will not be modified"})).s((Seq)Nil$.MODULE$).getBytes()));
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        testConsumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        testConsumer.seek(this.tp(), 0L);
        ArrayBuffer records2 = this.consumeRecords(testConsumer, 1, this.consumeRecords$default$3());
        ConsumerRecord record = (ConsumerRecord)records2.head();
        Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value will not be modified"})).s((Seq)Nil$.MODULE$), (Object)new String((byte[])record.value()));
    }

    @Test
    public void testConsumeMessagesWithCreateTime() {
        int numRecords = 50;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, 0, 0L, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.sendCompressedMessages(numRecords, this.tp2());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        KafkaConsumer x$47 = consumer;
        int x$48 = numRecords;
        TopicPartition x$49 = this.tp2();
        int x$50 = 0;
        int x$51 = 0;
        long x$52 = 0L;
        TimestampType x$53 = this.consumeAndVerifyRecords$default$6();
        int x$54 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$47, x$48, x$50, x$51, x$52, x$53, x$49, x$54);
    }

    @Test
    public void testConsumeMessagesWithLogAppendTime() {
        String topicName = "testConsumeMessagesWithLogAppendTime";
        Properties topicProps = new Properties();
        topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime");
        this.createTopic(topicName, 2, 2, topicProps);
        long startTime = System.currentTimeMillis();
        int numRecords = 50;
        TopicPartition tp1 = new TopicPartition(topicName, 0);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, tp1);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1}))).asJava());
        KafkaConsumer x$55 = consumer;
        int x$56 = numRecords;
        TopicPartition x$57 = tp1;
        int x$58 = 0;
        int x$59 = 0;
        long x$60 = startTime;
        TimestampType x$61 = TimestampType.LOG_APPEND_TIME;
        int x$62 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$55, x$56, x$58, x$59, x$60, x$61, x$57, x$62);
        TopicPartition tp2 = new TopicPartition(topicName, 1);
        this.sendCompressedMessages(numRecords, tp2);
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2}))).asJava());
        KafkaConsumer x$63 = consumer;
        int x$64 = numRecords;
        TopicPartition x$65 = tp2;
        int x$66 = 0;
        int x$67 = 0;
        long x$68 = startTime;
        TimestampType x$69 = TimestampType.LOG_APPEND_TIME;
        int x$70 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$63, x$64, x$66, x$67, x$68, x$69, x$65, x$70);
    }

    @Test
    public void testListTopics() {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        this.createTopic(topic1, numParts, 1, this.createTopic$default$4());
        this.createTopic(topic2, numParts, 1, this.createTopic$default$4());
        this.createTopic(topic3, numParts, 1, this.createTopic$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        java.util.Map topics = consumer.listTopics();
        Assert.assertNotNull((Object)topics);
        Assert.assertEquals((long)5L, (long)topics.size());
        Assert.assertEquals((long)5L, (long)topics.keySet().size());
        Assert.assertEquals((long)2L, (long)((java.util.List)topics.get(topic1)).size());
        Assert.assertEquals((long)2L, (long)((java.util.List)topics.get(topic2)).size());
        Assert.assertEquals((long)2L, (long)((java.util.List)topics.get(topic3)).size());
    }

    @Test
    public void testOffsetsForTimes() {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createTopic(topic1, numParts, 1, this.createTopic$default$4());
        this.createTopic(topic2, numParts, 1, props);
        this.createTopic(topic3, numParts, 1, this.createTopic$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, topic1, consumer){
            public static final long serialVersionUID = 0L;
            private final String topic1$1;
            private final KafkaConsumer consumer$6;

            public final java.util.Map<TopicPartition, OffsetAndTimestamp> apply() {
                return this.consumer$6.offsetsForTimes(Collections.singletonMap(new TopicPartition(this.topic1$1, 0), Predef$.MODULE$.long2Long(-1L)));
            }
            {
                this.topic1$1 = topic1$1;
                this.consumer$6 = consumer$6;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1202));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        HashMap timestampsToSearch = new HashMap();
        IntRef i = IntRef.create((int)0);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3})).foreach((Function1)new Serializable(this, numParts, producer, timestampsToSearch, i){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final int numParts$1;
            public final KafkaProducer producer$4;
            public final HashMap timestampsToSearch$1;
            public final IntRef i$1;

            public final void apply(String topic) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numParts$1).foreach$mVc$sp((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testOffsetsForTimes$2 $outer;
                    private final String topic$4;

                    public final void apply(int part) {
                        this.apply$mcVI$sp(part);
                    }

                    public void apply$mcVI$sp(int part) {
                        TopicPartition tp = new TopicPartition(this.topic$4, part);
                        this.$outer.kafka$api$PlaintextConsumerTest$$anonfun$$$outer().sendRecords((KafkaProducer<byte[], byte[]>)this.$outer.producer$4, 100, tp);
                        this.$outer.timestampsToSearch$1.put(tp, Predef$.MODULE$.long2Long((long)(this.$outer.i$1.elem * 20)));
                        ++this.$outer.i$1.elem;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.topic$4 = topic$4;
                    }
                });
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numParts$1 = numParts$1;
                this.producer$4 = producer$4;
                this.timestampsToSearch$1 = timestampsToSearch$1;
                this.i$1 = i$1;
            }
        });
        java.util.Map timestampOffsets = consumer.offsetsForTimes(timestampsToSearch);
        OffsetAndTimestamp timestampTopic1P0 = (OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 0));
        Assert.assertEquals((long)0L, (long)timestampTopic1P0.offset());
        Assert.assertEquals((long)0L, (long)timestampTopic1P0.timestamp());
        Assert.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTopic1P0.leaderEpoch());
        OffsetAndTimestamp timestampTopic1P1 = (OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 1));
        Assert.assertEquals((long)20L, (long)timestampTopic1P1.offset());
        Assert.assertEquals((long)20L, (long)timestampTopic1P1.timestamp());
        Assert.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTopic1P1.leaderEpoch());
        Assert.assertEquals((String)"null should be returned when message format is 0.9.0", null, timestampOffsets.get(new TopicPartition(topic2, 0)));
        Assert.assertEquals((String)"null should be returned when message format is 0.9.0", null, timestampOffsets.get(new TopicPartition(topic2, 1)));
        OffsetAndTimestamp timestampTopic3P0 = (OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic3, 0));
        Assert.assertEquals((long)80L, (long)timestampTopic3P0.offset());
        Assert.assertEquals((long)80L, (long)timestampTopic3P0.timestamp());
        Assert.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTopic3P0.leaderEpoch());
        Assert.assertEquals(null, timestampOffsets.get(new TopicPartition(topic3, 1)));
    }

    @Test
    public void testEarliestOrLatestOffsets() {
        String topic0 = "topicWithNewMessageFormat";
        String topic1 = "topicWithOldMessageFormat";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.createTopicAndSendRecords(producer, topic0, 2, 100);
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createTopic(topic1, 1, 1, props);
        this.sendRecords(producer, 100, new TopicPartition(topic1, 0));
        TopicPartition t0p0 = new TopicPartition(topic0, 0);
        TopicPartition t0p1 = new TopicPartition(topic0, 1);
        TopicPartition t1p0 = new TopicPartition(topic1, 0);
        java.util.Set partitions = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{t0p0, t0p1, t1p0}))).asJava();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        java.util.Map earliests = consumer.beginningOffsets((Collection)partitions);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), earliests.get(t0p0));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), earliests.get(t0p1));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), earliests.get(t1p0));
        java.util.Map latests = consumer.endOffsets((Collection)partitions);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)100L), latests.get(t0p0));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)100L), latests.get(t0p1));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)100L), latests.get(t1p0));
    }

    @Test
    public void testUnsubscribeTopic() {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
    }

    @Test
    public void testPauseStateNotPreservedByRebalance() {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 5, this.tp());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 5, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        consumer.pause((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic2"}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 0, 5, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testCommitSpecifiedOffsets() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 5, this.tp());
        this.sendRecords(producer, 7, this.tp2());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).asJava());
        long pos1 = consumer.position(this.tp());
        long pos2 = consumer.position(this.tp2());
        consumer.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(3L))}))).asJava());
        Assert.assertEquals((long)3L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assert.assertNull(consumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2()));
        Assert.assertEquals((long)pos1, (long)consumer.position(this.tp()));
        Assert.assertEquals((long)pos2, (long)consumer.position(this.tp2()));
        consumer.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp2(), (Object)new OffsetAndMetadata(5L))}))).asJava());
        Assert.assertEquals((long)3L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assert.assertEquals((long)5L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
        this.sendAndAwaitAsyncCommit(consumer, (Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2()), (Object)new OffsetAndMetadata(7L))}))));
        Assert.assertEquals((long)7L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @Test
    public void testAutoCommitOnRebalance() {
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4());
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(this, consumer){
            private final KafkaConsumer consumer$7;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.consumer$7.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.consumer$7 = consumer$7;
            }
        };
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), rebalanceListener);
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava(), rebalanceListener);
        scala.collection.immutable.Set newAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)newAssignment);
        Assert.assertEquals((long)300L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assert.assertEquals((long)500L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @Test
    public void testPerPartitionLeadMetricsCleanUpWithSubscribe() {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava(), (ConsumerRebalanceListener)listener);
        ConsumerRecords records2 = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        Assert.assertEquals((String)"should be assigned once", (long)1L, (long)listener.callsToAssigned());
        HashMap<String, String> tags1 = new HashMap<String, String>();
        tags1.put("client-id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        tags1.put("topic", this.tp().topic());
        tags1.put("partition", String.valueOf(this.tp().partition()));
        HashMap<String, String> tags2 = new HashMap<String, String>();
        tags2.put("client-id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        tags2.put("topic", this.tp2().topic());
        tags2.put("partition", String.valueOf(this.tp2().partition()));
        Metric fetchLead0 = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags1));
        Assert.assertNotNull((Object)fetchLead0);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The lead should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)records2.count())})), (Object)BoxesRunTime.boxToDouble((double)records2.count()), (Object)fetchLead0.metricValue());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic2}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assert.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags1)));
        Assert.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags2)));
    }

    @Test
    public void testPerPartitionLagMetricsCleanUpWithSubscribe() {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava(), (ConsumerRebalanceListener)listener);
        ConsumerRecords records2 = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        Assert.assertEquals((String)"should be assigned once", (long)1L, (long)listener.callsToAssigned());
        HashMap<String, String> tags1 = new HashMap<String, String>();
        tags1.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        tags1.put("topic", this.tp().topic());
        tags1.put("partition", String.valueOf(this.tp().partition()));
        HashMap<String, String> tags2 = new HashMap<String, String>();
        tags2.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        tags2.put("topic", this.tp2().topic());
        tags2.put("partition", String.valueOf(this.tp2().partition()));
        Metric fetchLag0 = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1));
        Assert.assertNotNull((Object)fetchLag0);
        int expectedLag = numMessages - records2.count();
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The lag should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedLag)})), (double)expectedLag, (double)BoxesRunTime.unboxToDouble((Object)fetchLag0.metricValue()), (double)this.epsilon());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic2}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assert.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1)));
        Assert.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags2)));
    }

    @Test
    public void testPerPartitionLeadMetricsCleanUpWithAssign() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.sendRecords(producer, numMessages, this.tp2());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records2 = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLead = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags));
        Assert.assertNotNull((Object)fetchLead);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The lead should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)records2.count())})), (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)records2.count()), (Object)fetchLead.metricValue()) ? 1 : 0) != 0);
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        this.awaitNonEmptyRecords((Consumer)consumer, this.tp2());
        Assert.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags)));
    }

    @Test
    public void testPerPartitionLagMetricsCleanUpWithAssign() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.sendRecords(producer, numMessages, this.tp2());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records2 = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assert.assertNotNull((Object)fetchLag);
        int expectedLag = numMessages - records2.count();
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The lag should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedLag)})), (double)expectedLag, (double)BoxesRunTime.unboxToDouble((Object)fetchLag.metricValue()), (double)this.epsilon());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        this.awaitNonEmptyRecords((Consumer)consumer, this.tp2());
        Assert.assertNull(consumer.metrics().get(new MetricName(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.tp()), ".records-lag"), "consumer-fetch-manager-metrics", "", tags)));
        Assert.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags)));
    }

    @Test
    public void testPerPartitionLagMetricsWhenReadCommitted() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.sendRecords(producer, numMessages, this.tp2());
        this.consumerConfig().setProperty("isolation.level", "read_committed");
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assert.assertNotNull((Object)fetchLag);
    }

    @Test
    public void testPerPartitionLeadWithMaxPollRecords() {
        int numMessages = 1000;
        int maxPollRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", ((Object)BoxesRunTime.boxToInteger((int)maxPollRecords)).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLeadWithMaxPollRecords");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric lead = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The lead should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxPollRecords)})), (BoxesRunTime.equals((Object)lead.metricValue(), (Object)BoxesRunTime.boxToInteger((int)maxPollRecords)) ? 1 : 0) != 0);
    }

    @Test
    public void testPerPartitionLagWithMaxPollRecords() {
        int numMessages = 1000;
        int maxPollRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", ((Object)BoxesRunTime.boxToInteger((int)maxPollRecords)).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records2 = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagWithMaxPollRecords");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric lag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The lag should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(numMessages - records2.count()))})), (double)(numMessages - records2.count()), (double)BoxesRunTime.unboxToDouble((Object)lag.metricValue()), (double)this.epsilon());
    }

    @Test
    public void testQuotaMetricsNotCreatedIfNoQuotasConfigured() {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.seek(this.tp(), 0L);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$11) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$11, "byte-rate", (QuotaType)QuotaType.Produce$.MODULE$, this.$outer.producerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$12) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$12, "throttle-time", (QuotaType)QuotaType.Produce$.MODULE$, this.$outer.producerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$13) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$13, "byte-rate", (QuotaType)QuotaType.Fetch$.MODULE$, this.$outer.consumerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$14) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$14, "throttle-time", (QuotaType)QuotaType.Fetch$.MODULE$, this.$outer.consumerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$15) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$15, "request-time", (QuotaType)QuotaType.Request$.MODULE$, this.$outer.producerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$16) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$16, "throttle-time", (QuotaType)QuotaType.Request$.MODULE$, this.$outer.producerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$17) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$17, "request-time", (QuotaType)QuotaType.Request$.MODULE$, this.$outer.consumerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$18) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$18, "throttle-time", (QuotaType)QuotaType.Request$.MODULE$, this.$outer.consumerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$19) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoExemptRequestMetric$1(x$19);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void runMultiConsumerSessionTimeoutTest(boolean closeConsumer) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.tp());
        this.sendRecords(producer, 100, this.tp2());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(producer, topic1, 6, 100));
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})), this.subscribeConsumerAndStartPolling$default$3()));
        consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})), this.subscribeConsumerAndStartPolling$default$3()));
        KafkaConsumer timeoutConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.ConsumerAssignmentPoller timeoutPoller = this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)timeoutConsumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})), this.subscribeConsumerAndStartPolling$default$3());
        consumerPollers.$plus$eq((Object)timeoutPoller);
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4());
        timeoutPoller.shutdown();
        consumerPollers.$minus$eq((Object)timeoutPoller);
        if (closeConsumer) {
            timeoutConsumer.close();
        }
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, (Option<String>)new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", " after one consumer left"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()}))), 3L * this.groupMaxSessionTimeoutMs());
        consumerPollers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(AbstractConsumerTest.ConsumerAssignmentPoller poller) {
                poller.shutdown();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> subscribeConsumers(Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, List<String> topicsToSubscribe) {
        void var3_3;
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumerGroup.foreach((Function1)new Serializable(this, topicsToSubscribe, consumerPollers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final List topicsToSubscribe$1;
            private final Buffer consumerPollers$2;

            public final Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> apply(KafkaConsumer<byte[], byte[]> consumer) {
                return this.consumerPollers$2.$plus$eq((Object)((Object)this.$outer.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)this.topicsToSubscribe$1, this.$outer.subscribeConsumerAndStartPolling$default$3())));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicsToSubscribe$1 = topicsToSubscribe$1;
                this.consumerPollers$2 = consumerPollers$2;
            }
        });
        return var3_3;
    }

    public scala.collection.immutable.Set<TopicPartition> createTopicAndSendRecords(KafkaProducer<byte[], byte[]> producer, String topicName, int numPartitions, int recordsPerPartition) {
        this.createTopic(topicName, numPartitions, this.brokerCount(), this.createTopic$default$4());
        ObjectRef parts = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)new Serializable(this, producer, topicName, recordsPerPartition, parts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaProducer producer$3;
            private final String topicName$1;
            private final int recordsPerPartition$1;
            private final ObjectRef parts$1;

            public final void apply(int partition) {
                this.apply$mcVI$sp(partition);
            }

            public void apply$mcVI$sp(int partition) {
                TopicPartition tp = new TopicPartition(this.topicName$1, partition);
                this.$outer.sendRecords((KafkaProducer<byte[], byte[]>)this.producer$3, this.recordsPerPartition$1, tp);
                this.parts$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)this.parts$1.elem).$plus((Object)tp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producer$3 = producer$3;
                this.topicName$1 = topicName$1;
                this.recordsPerPartition$1 = recordsPerPartition$1;
                this.parts$1 = parts$1;
            }
        });
        return (scala.collection.immutable.Set)parts.elem;
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> createConsumerGroupAndWaitForAssignment(int consumerCount, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Assert.assertTrue((consumerCount <= subscriptions.size() ? 1 : 0) != 0);
        Buffer consumerGroup = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), consumerCount).foreach((Function1)new Serializable(this, consumerGroup){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final Buffer consumerGroup$1;

            public final Buffer<KafkaConsumer<byte[], byte[]>> apply(int _) {
                return this.consumerGroup$1.$plus$eq(this.$outer.createConsumer(this.$outer.createConsumer$default$1(), this.$outer.createConsumer$default$2(), this.$outer.createConsumer$default$3(), this.$outer.createConsumer$default$4()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerGroup$1 = consumerGroup$1;
            }
        });
        Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup, topicsToSubscribe);
        return new Tuple2((Object)consumerGroup, consumerPollers);
    }

    public void changeConsumerGroupSubscriptionAndValidateAssignment(Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        consumerPollers.foreach((Function1)new Serializable(this, topicsToSubscribe){
            public static final long serialVersionUID = 0L;
            private final List topicsToSubscribe$2;

            public final void apply(AbstractConsumerTest.ConsumerAssignmentPoller poller) {
                poller.subscribe((List<String>)this.topicsToSubscribe$2);
            }
            {
                this.topicsToSubscribe$2 = topicsToSubscribe$2;
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerPollers){
            public static final long serialVersionUID = 0L;
            private final Buffer consumerPollers$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.consumerPollers$1.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(AbstractConsumerTest.ConsumerAssignmentPoller poller) {
                        return poller.isSubscribeRequestProcessed();
                    }
                });
            }
            {
                this.consumerPollers$1 = consumerPollers$1;
            }
        }, (Function0<String>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set subscriptions$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to call subscribe on all consumers in the group for subscription ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.subscriptions$1}));
            }
            {
                this.subscriptions$1 = subscriptions$1;
            }
        }, 1000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.validateGroupAssignment(consumerPollers, subscriptions, (Option<String>)new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", " after we changed subscription"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava()}))), this.validateGroupAssignment$default$4());
    }

    public <K, V> void changeConsumerSubscriptionAndValidateAssignment(Consumer<K, V> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> expectedAssignment, ConsumerRebalanceListener rebalanceListener) {
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), rebalanceListener);
        this.awaitAssignment(consumer, expectedAssignment);
    }

    private <K, V> ConsumerRecords<K, V> awaitNonEmptyRecords(Consumer<K, V> consumer, TopicPartition partition) {
        Object object = new Object();
        try {
            TestUtils$.MODULE$.pollRecordsUntilTrue(consumer, new Serializable(this, partition, object){
                public static final long serialVersionUID = 0L;
                private final TopicPartition partition$1;
                private final Object nonLocalReturnKey1$1;

                public final boolean apply(ConsumerRecords<K, V> polledRecords) {
                    if (((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(polledRecords.records(this.partition$1)).asScala()).nonEmpty()) {
                        throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, polledRecords);
                    }
                    return false;
                }
                {
                    this.partition$1 = partition$1;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            }, (Function0<String>)new Serializable(this, partition){
                public static final long serialVersionUID = 0L;
                private final TopicPartition partition$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumer did not consume any messages for partition ", " before timeout."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$1}));
                }
                {
                    this.partition$1 = partition$1;
                }
            }, TestUtils$.MODULE$.pollRecordsUntilTrue$default$4());
            throw new IllegalStateException("Should have timed out before reaching here");
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return (ConsumerRecords)nonLocalReturnControl.value();
            }
            throw nonLocalReturnControl;
        }
    }

    private void awaitAssignment(Consumer<?, ?> consumer, scala.collection.immutable.Set<TopicPartition> expectedAssignment) {
        TestUtils$.MODULE$.pollUntilTrue(consumer, (Function0<Object>)new Serializable(this, consumer, expectedAssignment){
            public static final long serialVersionUID = 0L;
            private final Consumer consumer$2;
            private final scala.collection.immutable.Set expectedAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                java.util.Set set = this.consumer$2.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expectedAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer$2 = consumer$2;
                this.expectedAssignment$1 = expectedAssignment$1;
            }
        }, (Function0<String>)new Serializable(this, consumer, expectedAssignment){
            public static final long serialVersionUID = 0L;
            private final Consumer consumer$2;
            private final scala.collection.immutable.Set expectedAssignment$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timed out while awaiting expected assignment ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.expectedAssignment$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The current assignment is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.consumer$2.assignment()}))).toString();
            }
            {
                this.consumer$2 = consumer$2;
                this.expectedAssignment$1 = expectedAssignment$1;
            }
        }, TestUtils$.MODULE$.pollUntilTrue$default$4());
    }

    @Test
    public void testConsumingWithNullGroupId() {
        String topic = "test_topic";
        int partition = 0;
        TopicPartition tp = new TopicPartition(topic, partition);
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final String topic$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().topicExists(this.topic$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to create topic";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k1".getBytes(), (Object)"v1".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k2".getBytes(), (Object)"v2".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k3".getBytes(), (Object)"v3".getBytes())).get();
        producer.close();
        Properties consumer1Config = new Properties(this.consumerConfig());
        consumer1Config.put("auto.offset.reset", "earliest");
        consumer1Config.put("client.id", "consumer1");
        Properties x$71 = consumer1Config;
        List x$72 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"group.id"}));
        ByteArrayDeserializer x$73 = this.createConsumer$default$1();
        ByteArrayDeserializer x$74 = this.createConsumer$default$2();
        KafkaConsumer consumer1 = this.createConsumer(x$73, x$74, x$71, (List<String>)x$72);
        Properties consumer2Config = new Properties(this.consumerConfig());
        consumer2Config.put("auto.offset.reset", "latest");
        consumer2Config.put("client.id", "consumer2");
        Properties x$75 = consumer2Config;
        List x$76 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"group.id"}));
        ByteArrayDeserializer x$77 = this.createConsumer$default$1();
        ByteArrayDeserializer x$78 = this.createConsumer$default$2();
        KafkaConsumer consumer2 = this.createConsumer(x$77, x$78, x$75, (List<String>)x$76);
        Properties consumer3Config = new Properties(this.consumerConfig());
        consumer3Config.put("client.id", "consumer3");
        Properties x$79 = consumer3Config;
        List x$80 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"group.id"}));
        ByteArrayDeserializer x$81 = this.createConsumer$default$1();
        ByteArrayDeserializer x$82 = this.createConsumer$default$2();
        KafkaConsumer consumer3 = this.createConsumer(x$81, x$82, x$79, (List<String>)x$80);
        consumer1.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        consumer2.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        consumer3.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        consumer3.seek(tp, 1L);
        int numRecords1 = consumer1.poll(Duration.ofMillis(5000L)).count();
        try {
            consumer1.commitSync();
            Assert.fail((String)"Expected offset commit to fail due to null group id");
        }
        catch (InvalidGroupIdException invalidGroupIdException) {
            // empty catch block
        }
        try {
            consumer2.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava());
            Assert.fail((String)"Expected committed offset fetch to fail due to null group id");
        }
        catch (InvalidGroupIdException invalidGroupIdException) {
            // empty catch block
        }
        int numRecords2 = consumer2.poll(Duration.ofMillis(5000L)).count();
        int numRecords3 = consumer3.poll(Duration.ofMillis(5000L)).count();
        consumer1.unsubscribe();
        consumer2.unsubscribe();
        consumer3.unsubscribe();
        consumer1.close();
        consumer2.close();
        consumer3.close();
        Assert.assertEquals((String)"Expected consumer1 to consume from earliest offset", (long)3L, (long)numRecords1);
        Assert.assertEquals((String)"Expected consumer2 to consume from latest offset", (long)0L, (long)numRecords2);
        Assert.assertEquals((String)"Expected consumer3 to consume from offset 1", (long)2L, (long)numRecords3);
    }

    @Test
    public void testConsumingWithEmptyGroupId() {
        String topic = "test_topic";
        int partition = 0;
        TopicPartition tp = new TopicPartition(topic, partition);
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final String topic$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().topicExists(this.topic$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to create topic";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k1".getBytes(), (Object)"v1".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k2".getBytes(), (Object)"v2".getBytes())).get();
        producer.close();
        Properties consumer1Config = new Properties(this.consumerConfig());
        consumer1Config.put("group.id", "");
        consumer1Config.put("client.id", "consumer1");
        consumer1Config.put("max.poll.records", "1");
        Properties x$83 = consumer1Config;
        ByteArrayDeserializer x$84 = this.createConsumer$default$1();
        ByteArrayDeserializer x$85 = this.createConsumer$default$2();
        List<String> x$86 = this.createConsumer$default$4();
        KafkaConsumer consumer1 = this.createConsumer(x$84, x$85, x$83, x$86);
        Properties consumer2Config = new Properties(this.consumerConfig());
        consumer2Config.put("auto.offset.reset", "latest");
        consumer2Config.put("group.id", "");
        consumer2Config.put("client.id", "consumer2");
        consumer2Config.put("max.poll.records", "1");
        Properties x$87 = consumer2Config;
        ByteArrayDeserializer x$88 = this.createConsumer$default$1();
        ByteArrayDeserializer x$89 = this.createConsumer$default$2();
        List<String> x$90 = this.createConsumer$default$4();
        KafkaConsumer consumer2 = this.createConsumer(x$88, x$89, x$87, x$90);
        consumer1.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        consumer2.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        ConsumerRecords records1 = consumer1.poll(Duration.ofMillis(5000L));
        consumer1.commitSync();
        ConsumerRecords records2 = consumer2.poll(Duration.ofMillis(5000L));
        consumer2.commitSync();
        consumer1.close();
        consumer2.close();
        Assert.assertTrue((String)"Expected consumer1 to consume one message from offset 0", (records1.count() == 1 && ((ConsumerRecord)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(records1.records(tp)).asScala()).head()).offset() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected consumer2 to consume one message from offset 1, which is the committed offset of consumer1", (records2.count() == 1 && ((ConsumerRecord)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(records2.records(tp)).asScala()).head()).offset() == 1L ? 1 : 0) != 0);
    }

    private final scala.collection.immutable.Map reverse$1(scala.collection.immutable.Map m) {
        return ((TraversableOnce)((SetLike)m.values().toSet().flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1)new Serializable(this, m){
            public static final long serialVersionUID = 0L;
            public final scala.collection.immutable.Map m$1;

            public final Tuple2<TopicPartition, Object> apply(TopicPartition v) {
                return new Tuple2((Object)v, ((IterableLike)this.m$1.keys().filter((Function1)new Serializable(this, v){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$reverse$1$1 $outer;
                    private final TopicPartition v$1;

                    public final boolean apply(long x$5) {
                        return this.apply$mcZJ$sp(x$5);
                    }

                    public boolean apply$mcZJ$sp(long x$5) {
                        return ((SetLike)this.$outer.m$1.apply((Object)BoxesRunTime.boxToLong((long)x$5))).contains((Object)this.v$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.v$1 = v$1;
                    }
                })).head());
            }
            {
                this.m$1 = m$1;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public final void kafka$api$PlaintextConsumerTest$$assertNoMetric$1(KafkaServer broker, String name, QuotaType quotaType, String clientId) {
        MetricName metricName = broker.metrics().metricName("throttle-time", quotaType.toString(), "", new String[]{"user", "", "client-id", clientId});
        Assert.assertNull((String)new StringBuilder().append((Object)"Metric should not hanve been created ").append((Object)metricName).toString(), (Object)broker.metrics().metric(metricName));
    }

    public final void kafka$api$PlaintextConsumerTest$$assertNoExemptRequestMetric$1(KafkaServer broker) {
        MetricName metricName = broker.metrics().metricName("exempt-request-time", QuotaType.Request$.MODULE$.toString(), "");
        Assert.assertNull((String)new StringBuilder().append((Object)"Metric should not hanve been created ").append((Object)metricName).toString(), (Object)broker.metrics().metric(metricName));
    }

    public interface SerializerImpl
    extends Serializer<byte[]> {
        public ByteArraySerializer serializer();

        @TraitSetter
        public void serializer_$eq(ByteArraySerializer var1);

        public byte[] serialize(String var1, Headers var2, byte[] var3);

        public void configure(java.util.Map<String, ?> var1, boolean var2);

        public void close();

        public byte[] serialize(String var1, byte[] var2);

        public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer();
    }

    public interface DeserializerImpl
    extends Deserializer<byte[]> {
        public ByteArrayDeserializer deserializer();

        @TraitSetter
        public void deserializer_$eq(ByteArrayDeserializer var1);

        public byte[] deserialize(String var1, Headers var2, byte[] var3);

        public void configure(java.util.Map<String, ?> var1, boolean var2);

        public void close();

        public byte[] deserialize(String var1, byte[] var2);

        public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer();
    }
}

