/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Collections;
import java.util.Properties;
import kafka.log.CleanerConfig;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.TimeIndex;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\t%b\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005!A/[7f+\u00051\u0002CA\f\u001b\u001b\u0005A\"BA\r\u0005\u0003\u0015)H/\u001b7t\u0013\tY\u0002D\u0001\u0005N_\u000e\\G+[7f\u0011\u0019i\u0002\u0001)A\u0005-\u0005)A/[7fA!9q\u0004\u0001b\u0001\n\u0003\u0001\u0013aD7bqJ{G\u000e\\%oi\u0016\u0014h/\u00197\u0016\u0003\u0005\u0002\"!\u0003\u0012\n\u0005\rR!aA%oi\"1Q\u0005\u0001Q\u0001\n\u0005\n\u0001#\\1y%>dG.\u00138uKJ4\u0018\r\u001c\u0011\t\u000f\u001d\u0002!\u0019!C\u0001A\u0005YQ.\u0019=M_\u001e\fu-Z't\u0011\u0019I\u0003\u0001)A\u0005C\u0005aQ.\u0019=M_\u001e\fu-Z'tA!91\u0006\u0001b\u0001\n\u0003a\u0013\u0001\u00037pOB\u0013x\u000e]:\u0016\u00035\u0002\"AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\tU$\u0018\u000e\u001c\u0006\u0002e\u0005!!.\u0019<b\u0013\t!tF\u0001\u0006Qe>\u0004XM\u001d;jKNDaA\u000e\u0001!\u0002\u0013i\u0013!\u00037pOB\u0013x\u000e]:!\u0011\u001dA\u0004A1A\u0005\u0002e\n\u0011\u0002\\8h\u0007>tg-[4\u0016\u0003i\u0002\"AE\u001e\n\u0005q\u0012!!\u0003'pO\u000e{gNZ5h\u0011\u0019q\u0004\u0001)A\u0005u\u0005QAn\\4D_:4\u0017n\u001a\u0011\t\u000f\u0001\u0003\u0001\u0019!C\u0001\u0003\u00061An\\4ESJ,\u0012A\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000bF\n!![8\n\u0005\u001d#%\u0001\u0002$jY\u0016Dq!\u0013\u0001A\u0002\u0013\u0005!*\u0001\u0006m_\u001e$\u0015N]0%KF$\"a\u0013(\u0011\u0005%a\u0015BA'\u000b\u0005\u0011)f.\u001b;\t\u000f=C\u0015\u0011!a\u0001\u0005\u0006\u0019\u0001\u0010J\u0019\t\rE\u0003\u0001\u0015)\u0003C\u0003\u001dawn\u001a#je\u0002Bqa\u0015\u0001A\u0002\u0013\u0005A+\u0001\u0006m_\u001el\u0015M\\1hKJ,\u0012!\u0016\t\u0003%YK!a\u0016\u0002\u0003\u00151{w-T1oC\u001e,'\u000fC\u0004Z\u0001\u0001\u0007I\u0011\u0001.\u0002\u001d1|w-T1oC\u001e,'o\u0018\u0013fcR\u00111j\u0017\u0005\b\u001fb\u000b\t\u00111\u0001V\u0011\u0019i\u0006\u0001)Q\u0005+\u0006YAn\\4NC:\fw-\u001a:!\u0011\u001dy\u0006A1A\u0005\u0002\u0001\fAA\\1nKV\t\u0011\r\u0005\u0002cK6\t1M\u0003\u0002ec\u0005!A.\u00198h\u0013\t17M\u0001\u0004TiJLgn\u001a\u0005\u0007Q\u0002\u0001\u000b\u0011B1\u0002\u000b9\fW.\u001a\u0011\t\u000f)\u0004!\u0019!C\u0001W\u0006Ib/\u001a:z\u0019\u0006\u0014x-\u001a'pO\u001acWo\u001d5J]R,'O^1m+\u0005a\u0007CA\u0005n\u0013\tq'B\u0001\u0003M_:<\u0007B\u00029\u0001A\u0003%A.\u0001\u000ewKJLH*\u0019:hK2{wM\u00127vg\"Le\u000e^3sm\u0006d\u0007\u0005C\u0003s\u0001\u0011\u00051/A\u0003tKR,\u0006\u000fF\u0001LQ\t\tX\u000f\u0005\u0002ww6\tqO\u0003\u0002ys\u0006)!.\u001e8ji*\t!0A\u0002pe\u001eL!\u0001`<\u0003\r\t+gm\u001c:f\u0011\u0015q\b\u0001\"\u0001t\u0003!!X-\u0019:E_^t\u0007fA?\u0002\u0002A\u0019a/a\u0001\n\u0007\u0005\u0015qOA\u0003BMR,'\u000f\u0003\u0004\u0002\n\u0001!\ta]\u0001\u000ei\u0016\u001cHo\u0011:fCR,Gj\\4)\t\u0005\u001d\u0011Q\u0002\t\u0004m\u0006=\u0011bAA\to\n!A+Z:u\u0011\u0019\t)\u0002\u0001C\u0001g\u0006qB/Z:u\u0007J,\u0017\r^3M_\u001e<\u0016\u000e\u001e5J]Z\fG.\u001b3M_\u001e$\u0015N\u001d\u0015\u0005\u0003'\ti\u0001\u0003\u0004\u0002\u001c\u0001!\ta]\u0001 i\u0016\u001cHo\u0011:fCR,Gj\\4XSRDGj\\4ESJ4\u0015\r\u001c7cC\u000e\\\u0007\u0006BA\r\u0003\u001bAa!!\t\u0001\t\u0003\u0019\u0018!\u0006;fgR<U\r\u001e(p]\u0016C\u0018n\u001d;f]Rdun\u001a\u0015\u0005\u0003?\ti\u0001\u0003\u0004\u0002(\u0001!\ta]\u0001\u001bi\u0016\u001cHo\u00117fC:,\b/\u0012=qSJ,GmU3h[\u0016tGo\u001d\u0015\u0005\u0003K\ti\u0001\u0003\u0004\u0002.\u0001!\ta]\u0001\"i\u0016\u001cHo\u00117fC:,\boU3h[\u0016tGo\u001d+p\u001b\u0006Lg\u000e^1j]NK'0\u001a\u0015\u0005\u0003W\ti\u0001\u0003\u0004\u00024\u0001!\ta]\u0001+i\u0016\u001cH\u000fR8fg:$8\t\\3b]2{wm],ji\"\u001cu.\u001c9bGR$U\r\\3uKB{G.[2zQ\u0011\t\t$!\u0004\t\r\u0005e\u0002\u0001\"\u0001t\u0003\u0011\"Xm\u001d;E_\u0016\u001ch\u000e^\"mK\u0006tGj\\4t/&$\bnQ8na\u0006\u001cG\u000fU8mS\u000eL\b\u0006BA\u001c\u0003\u001bAq!a\u0010\u0001\t\u0013\t\t%A\nuKN$Hi\\3t]R\u001cE.Z1o\u0019><7\u000fF\u0002L\u0003\u0007B\u0001\"!\u0012\u0002>\u0001\u0007\u0011qI\u0001\u0007a>d\u0017nY=\u0011\t\u0005%\u0013q\n\b\u0004\u0013\u0005-\u0013bAA'\u0015\u00051\u0001K]3eK\u001aL1AZA)\u0015\r\tiE\u0003\u0005\u0007\u0003+\u0002A\u0011A:\u0002%Q,7\u000f\u001e+j[\u0016\u0014\u0015m]3e\r2,8\u000f\u001b\u0015\u0005\u0003'\ni\u0001\u0003\u0004\u0002\\\u0001!\ta]\u0001\u001ai\u0016\u001cH\u000fT3bgRdu.\u00193fI\u0006\u001b8/[4o[\u0016tG\u000f\u000b\u0003\u0002Z\u00055\u0001BBA1\u0001\u0011\u00051/A\u0012uKN$Hk^8M_\u001el\u0015M\\1hKJ\u001cXk]5oON\u000bW.\u001a#je\u001a\u000b\u0017\u000e\\:)\t\u0005}\u0013Q\u0002\u0005\u0007\u0003O\u0002A\u0011A:\u00029Q,7\u000f^\"iK\u000e\\\u0007o\\5oiJ+7m\u001c<fef\u0004v.\u001b8ug\"\"\u0011QMA\u0007\u0011\u0019\ti\u0007\u0001C\u0001g\u0006iC/Z:u%\u0016\u001cwN^3ss\u0012K'/Z2u_JLX*\u00199qS:<w+\u001b;i)J\f\u0017\u000e\\5oONc\u0017m\u001d5)\t\u0005-\u0014Q\u0002\u0005\u0007\u0003g\u0002A\u0011A:\u0002cQ,7\u000f\u001e*fG>4XM]=ESJ,7\r^8ss6\u000b\u0007\u000f]5oO^KG\u000f\u001b*fY\u0006$\u0018N^3ESJ,7\r^8ss\"\"\u0011\u0011OA\u0007\u0011\u001d\tI\b\u0001C\u0005\u0003w\n\u0001D^3sS\u001aL8\t[3dWB|\u0017N\u001c;SK\u000e|g/\u001a:z)\u001dY\u0015QPAV\u0003[C\u0001\"a \u0002x\u0001\u0007\u0011\u0011Q\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB1\u00111QAJ\u00033sA!!\"\u0002\u0010:!\u0011qQAG\u001b\t\tIIC\u0002\u0002\f\u001a\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0007\u0005E%\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0015q\u0013\u0002\u0004'\u0016\f(bAAI\u0015A!\u00111TAT\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016AB2p[6|gNC\u0002\u0006\u0003GS1!!*z\u0003\u0019\t\u0007/Y2iK&!\u0011\u0011VAO\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:DaaUA<\u0001\u0004)\u0006B\u0002!\u0002x\u0001\u0007!\tC\u0004\u00022\u0002!I!a-\u0002!\r\u0014X-\u0019;f\u0019><W*\u00198bO\u0016\u0014HcA+\u00026\"Q\u0011qWAX!\u0003\u0005\r!!/\u0002\u000f1|w\rR5sgB)\u00111QAJ\u0005\"1\u0011Q\u0018\u0001\u0005\u0002M\f!\u0005^3ti\u001aKG.\u001a*fM\u0016\u0014XM\\2fg\u00063G/\u001a:Bgft7\rR3mKR,\u0007\u0006BA^\u0003\u001bAa!a1\u0001\t\u0003\u0019\u0018A\t;fgR\u001c%/Z1uK\u0006sG\rR3mKR,wJ^3sYfduN\\4U_BL7\r\u000b\u0003\u0002B\u00065\u0001BBAe\u0001\u0011\u00051/A\u0011uKN$8\t[3dWB|\u0017N\u001c;G_J|e\u000e\\=BM\u001a,7\r^3e\u0019><7\u000f\u000b\u0003\u0002H\u00065\u0001bBAh\u0001\u0011%\u0011\u0011[\u0001\be\u0016\fG\rT8h)!\t\u0019.a8\u0002h\u0006-\b\u0003BAk\u00037l!!a6\u000b\u0007\u0005eG!\u0001\u0004tKJ4XM]\u0005\u0005\u0003;\f9NA\u0007GKR\u001c\u0007\u000eR1uC&sgm\u001c\u0005\b\u0007\u00055\u0007\u0019AAq!\r\u0011\u00121]\u0005\u0004\u0003K\u0014!a\u0001'pO\"9\u0011\u0011^Ag\u0001\u0004a\u0017AB8gMN,G\u000fC\u0005\u0002n\u00065\u0007\u0013!a\u0001C\u0005IQ.\u0019=MK:<G\u000f\u001b\u0005\u0007\u0003c\u0004A\u0011A:\u0002KQ,7\u000f\u001e+pa&\u001c7i\u001c8gS\u001e\u001c\u0005.\u00198hKV\u0003H-\u0019;fg2{wmQ8oM&<\u0007\u0006BAx\u0003\u001bAa!a>\u0001\t\u0003\u0019\u0018!\b;fgR\u001cuN\u001c4jO\u000eC\u0017M\\4f\u000f\u0016$8o\u00117fC:,G-\u00169)\t\u0005U\u0018Q\u0002\u0005\u0007\u0003{\u0004A\u0011A:\u0002QQ,7\u000f\u001e\"s_.,'oQ8oM&<7\t[1oO\u0016$U\r\\5wKJ,G\rV8BY2dunZ:)\t\u0005m\u0018Q\u0002\u0005\u0007\u0005\u0007\u0001A\u0011A:\u0002YQ,7\u000f^\"p]\u001aLwm\u00115b]\u001e,7oV5uQ:{Gj\\4HKR$\u0018N\\4J]&$\u0018.\u00197ju\u0016$\u0007\u0006\u0002B\u0001\u0003\u001bA\u0011B!\u0003\u0001#\u0003%IAa\u0003\u00025\r\u0014X-\u0019;f\u0019><W*\u00198bO\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t5!\u0006BA]\u0005\u001fY#A!\u0005\u0011\t\tM!QD\u0007\u0003\u0005+QAAa\u0006\u0003\u001a\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00057Q\u0011AC1o]>$\u0018\r^5p]&!!q\u0004B\u000b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005G\u0001\u0011\u0013!C\u0005\u0005K\t\u0011C]3bI2{w\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u00119CK\u0002\"\u0005\u001f\u0001")
public class LogManagerTest {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
    }

    @After
    public void tearDown() {
        if (this.logManager() != null) {
            this.logManager().shutdown();
        }
        Utils.delete((File)this.logDir());
        this.logManager().liveLogDirs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File x$1) {
                Utils.delete((File)x$1);
            }
        });
    }

    @Test
    public void testCreateLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$13 = new TopicPartition(this.name(), 0);
        LogConfig x$14 = this.logConfig();
        boolean x$15 = qual$1.getOrCreateLog$default$3();
        boolean x$16 = qual$1.getOrCreateLog$default$4();
        Log log2 = qual$1.getOrCreateLog(x$13, x$14, x$15, x$16);
        Assert.assertEquals((long)1L, (long)this.logManager().liveLogDirs().size());
        File logFile = new File(this.logDir(), new StringBuilder().append((Object)this.name()).append((Object)"-0").toString());
        Assert.assertTrue((boolean)logFile.exists());
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
    }

    @Test
    public void testCreateLogWithInvalidLogDir() {
        Seq dirs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir(), new File("\u0000")}));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs));
        this.logManager().startup();
        LogManager qual$2 = this.logManager();
        TopicPartition x$17 = new TopicPartition(this.name(), 0);
        LogConfig x$18 = this.logConfig();
        boolean x$19 = true;
        boolean x$20 = qual$2.getOrCreateLog$default$4();
        Log log2 = qual$2.getOrCreateLog(x$17, x$18, x$19, x$20);
        File logFile = new File(this.logDir(), new StringBuilder().append((Object)this.name()).append((Object)"-0").toString());
        Assert.assertTrue((boolean)logFile.exists());
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
    }

    @Test
    public void testCreateLogWithLogDirFallback() {
        IndexedSeq dirs = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int x$1) {
                return ((Object)BoxesRunTime.boxToInteger((int)x$1)).toString();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final File apply(String x$2) {
                return this.$outer.logDir().toPath().resolve(x$2).toFile();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.logManager().shutdown();
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager((Seq<File>)dirs)));
        Set brokenDirs = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((LogManager)Mockito.doAnswer((Answer)new Answer<Try<File>>(this, dirs, brokenDirs){
            private final IndexedSeq dirs$1;
            private final Set brokenDirs$1;

            public Try<File> answer(InvocationOnMock invocation) {
                Failure failure;
                File logDir = (File)invocation.getArgument(0);
                if (this.brokenDirs$1.contains((Object)logDir) || this.brokenDirs$1.size() < this.dirs$1.length() / 2) {
                    this.brokenDirs$1.add((Object)logDir);
                    failure = new Failure(new Throwable("broken dir"));
                } else {
                    failure = (Try)invocation.callRealMethod();
                }
                return failure;
            }
            {
                this.dirs$1 = dirs$1;
                this.brokenDirs$1 = brokenDirs$1;
            }
        }).when((Object)this.logManager())).createLogDirectory((File)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.logManager().startup();
        LogManager qual$3 = this.logManager();
        TopicPartition x$21 = new TopicPartition(this.name(), 0);
        LogConfig x$22 = this.logConfig();
        boolean x$23 = true;
        boolean x$24 = qual$3.getOrCreateLog$default$4();
        qual$3.getOrCreateLog(x$21, x$22, x$23, x$24);
        Assert.assertEquals((long)(dirs.length() / 2), (long)brokenDirs.size());
        Serializable containsLogFile = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final boolean apply(File dir) {
                return new File(dir, new StringBuilder().append((Object)this.$outer.name()).append((Object)"-0").toString()).exists();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        Assert.assertEquals((String)"More than one log file created", (long)1L, (long)dirs.count((Function1)containsLogFile));
        Assert.assertFalse((boolean)brokenDirs.exists((Function1)containsLogFile));
    }

    @Test
    public void testGetNonExistentLog() {
        LogManager qual$4 = this.logManager();
        TopicPartition x$25 = new TopicPartition(this.name(), 0);
        boolean x$26 = qual$4.getLog$default$2();
        Option log2 = qual$4.getLog(x$25, x$26);
        Assert.assertEquals((String)"No log should be found.", (Object)None$.MODULE$, (Object)log2);
        File logFile = new File(this.logDir(), new StringBuilder().append((Object)this.name()).append((Object)"-0").toString());
        Assert.assertTrue((!logFile.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testCleanupExpiredSegments() {
        LogManager qual$5 = this.logManager();
        TopicPartition x$27 = new TopicPartition(this.name(), 0);
        LogConfig x$28 = this.logConfig();
        boolean x$29 = qual$5.getOrCreateLog$default$3();
        boolean x$30 = qual$5.getOrCreateLog$default$4();
        Log log2 = qual$5.getOrCreateLog(x$27, x$28, x$29, x$30);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)new Serializable(this, log2, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$1;
            private final LongRef offset$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                LogAppendInfo info = this.log$1.appendAsLeader(set, 0, this.log$1.appendAsLeader$default$3(), this.log$1.appendAsLeader$default$4());
                this.offset$1.elem = info.lastOffset();
            }
            {
                this.log$1 = log$1;
                this.offset$1 = offset$1;
            }
        });
        Assert.assertTrue((String)"There should be more than one segment now.", (log2.numberOfSegments() > 1 ? 1 : 0) != 0);
        log2.updateHighWatermark(log2.logEndOffset());
        log2.logSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final boolean apply(LogSegment x$3) {
                return x$3.log().file().setLastModified(this.$outer.time().milliseconds());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assert.assertEquals((String)"Now there should only be only one segment in the index.", (long)1L, (long)log2.numberOfSegments());
        this.time().sleep(Predef$.MODULE$.Long2long(log2.config().fileDeleteDelayMs()) + 1L);
        log2.logSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TimeIndex apply(LogSegment s) {
                s.lazyOffsetIndex().get();
                return (TimeIndex)s.lazyTimeIndex().get();
            }
        });
        Assert.assertEquals((String)"Files should have been deleted", (long)(log2.numberOfSegments() * 4 + 1), (long)log2.dir().list().length);
        Assert.assertEquals((String)"Should get empty fetch off new log.", (long)0L, (long)this.readLog(log2, offset.elem + 1L, this.readLog$default$3()).records().sizeInBytes());
        try {
            this.readLog(log2, 0L, this.readLog$default$3());
            Assert.fail((String)"Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {}
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
    }

    @Test
    public void testCleanupSegmentsToMaintainSize() {
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes();
        this.logManager().shutdown();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(10 * setSize));
        logProps.put(LogConfig$.MODULE$.RetentionBytesProp(), Predef$.MODULE$.long2Long(50L * (long)setSize + 10L));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        LogManager qual$6 = this.logManager();
        TopicPartition x$31 = new TopicPartition(this.name(), 0);
        LogConfig x$32 = config;
        boolean x$33 = qual$6.getOrCreateLog$default$3();
        boolean x$34 = qual$6.getOrCreateLog$default$4();
        Log log2 = qual$6.getOrCreateLog(x$31, x$32, x$33, x$34);
        LongRef offset = LongRef.create((long)0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, log2, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final LongRef offset$2;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                LogAppendInfo info = this.log$2.appendAsLeader(set, 0, this.log$2.appendAsLeader$default$3(), this.log$2.appendAsLeader$default$4());
                this.offset$2.elem = BoxesRunTime.unboxToLong((Object)info.firstOffset().get());
            }
            {
                this.log$2 = log$2;
                this.offset$2 = offset$2;
            }
        });
        log2.updateHighWatermark(log2.logEndOffset());
        Assert.assertEquals((String)"Check we have the expected number of segments.", (long)(numMessages * setSize / Predef$.MODULE$.Integer2int(config.segmentSize())), (long)log2.numberOfSegments());
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertEquals((String)"Now there should be exactly 6 segments", (long)6L, (long)log2.numberOfSegments());
        this.time().sleep(Predef$.MODULE$.Long2long(log2.config().fileDeleteDelayMs()) + 1L);
        Assert.assertEquals((String)"Files should have been deleted", (long)(log2.numberOfSegments() * 3 + 3), (long)log2.dir().list().length);
        Assert.assertEquals((String)"Should get empty fetch off new log.", (long)0L, (long)this.readLog(log2, offset.elem + 1L, this.readLog$default$3()).records().sizeInBytes());
        try {
            this.readLog(log2, 0L, this.readLog$default$3());
            Assert.fail((String)"Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {}
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
    }

    @Test
    public void testDoesntCleanLogsWithCompactDeletePolicy() {
        this.testDoesntCleanLogs(new StringBuilder().append((Object)LogConfig$.MODULE$.Compact()).append((Object)",").append((Object)LogConfig$.MODULE$.Delete()).toString());
    }

    @Test
    public void testDoesntCleanLogsWithCompactPolicy() {
        this.testDoesntCleanLogs(LogConfig$.MODULE$.Compact());
    }

    private void testDoesntCleanLogs(String policy) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), policy);
        LogManager qual$7 = this.logManager();
        TopicPartition x$35 = new TopicPartition(this.name(), 0);
        LogConfig x$36 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        boolean x$37 = qual$7.getOrCreateLog$default$3();
        boolean x$38 = qual$7.getOrCreateLog$default$4();
        Log log2 = qual$7.getOrCreateLog(x$35, x$36, x$37, x$38);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)new Serializable(this, log2, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$3;
            private final LongRef offset$3;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                LogAppendInfo info = this.log$3.appendAsLeader(set, 0, this.log$3.appendAsLeader$default$3(), this.log$3.appendAsLeader$default$4());
                this.offset$3.elem = info.lastOffset();
            }
            {
                this.log$3 = log$3;
                this.offset$3 = offset$3;
            }
        });
        int numSegments = log2.numberOfSegments();
        Assert.assertTrue((String)"There should be more than one segment now.", (log2.numberOfSegments() > 1 ? 1 : 0) != 0);
        log2.logSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final boolean apply(LogSegment x$4) {
                return x$4.log().file().setLastModified(this.$outer.time().milliseconds());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assert.assertEquals((String)"number of segments shouldn't have changed", (long)numSegments, (long)log2.numberOfSegments());
    }

    @Test
    public void testTimeBasedFlush() {
        this.logManager().shutdown();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMsProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        LogManager qual$8 = this.logManager();
        TopicPartition x$39 = new TopicPartition(this.name(), 0);
        LogConfig x$40 = config;
        boolean x$41 = qual$8.getOrCreateLog$default$3();
        boolean x$42 = qual$8.getOrCreateLog$default$4();
        Log log2 = qual$8.getOrCreateLog(x$39, x$40, x$41, x$42);
        long lastFlush = log2.lastFlushTime();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final Log log$4;

            public final LogAppendInfo apply(int _) {
                MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                return this.log$4.appendAsLeader(set, 0, this.log$4.appendAsLeader$default$3(), this.log$4.appendAsLeader$default$4());
            }
            {
                this.log$4 = log$4;
            }
        });
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertTrue((String)"Time based flush should have been triggered", (lastFlush != log2.lastFlushTime() ? 1 : 0) != 0);
    }

    @Test
    public void testLeastLoadedAssignment() {
        Seq dirs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{TestUtils$.MODULE$.tempDir(), TestUtils$.MODULE$.tempDir(), TestUtils$.MODULE$.tempDir()}));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final void apply(int partition) {
                this.apply$mcVI$sp(partition);
            }

            public void apply$mcVI$sp(int partition) {
                LogManager qual$9 = this.$outer.logManager();
                TopicPartition x$43 = new TopicPartition("test", partition);
                LogConfig x$44 = this.$outer.logConfig();
                boolean x$45 = qual$9.getOrCreateLog$default$3();
                boolean x$46 = qual$9.getOrCreateLog$default$4();
                qual$9.getOrCreateLog(x$43, x$44, x$45, x$46);
                Assert.assertEquals((String)"We should have created the right number of logs", (long)(partition + 1), (long)this.$outer.logManager().allLogs().size());
                Iterable counts = (Iterable)this.$outer.logManager().allLogs().groupBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Log x$5) {
                        return x$5.dir().getParent();
                    }
                }).values().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Iterable<Log> x$6) {
                        return x$6.size();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
                Assert.assertTrue((String)"Load should balance evenly", (BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        try {
            this.createLogManager(this.createLogManager$default$1());
            Assert.fail((String)"Should not be able to create a second log manager instance with the same data directory");
        }
        catch (KafkaException kafkaException) {}
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1), new TopicPartition("test-b", 1)}))), this.logManager(), this.logDir());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        this.logManager().shutdown();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{new File(new StringBuilder().append((Object)TestUtils$.MODULE$.tempDir().getAbsolutePath()).append((Object)File.separator).toString())}))), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4()));
        this.logManager().startup();
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1)}))), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{new File("data", this.logDir().getName()).getAbsoluteFile()})))));
        this.logManager().startup();
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1)}))), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    private void verifyCheckpointRecovery(Seq<TopicPartition> topicPartitions, LogManager logManager, File logDir) {
        Seq logs = (Seq)topicPartitions.map((Function1)new Serializable(this, logManager){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;
            private final LogManager logManager$1;

            public final Log apply(TopicPartition x$7) {
                return this.logManager$1.getOrCreateLog(x$7, this.$outer.logConfig(), this.logManager$1.getOrCreateLog$default$3(), this.logManager$1.getOrCreateLog$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logManager$1 = logManager$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        logs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Log log2) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1)new Serializable(this, log2){
                    public static final long serialVersionUID = 0L;
                    private final Log log$5;

                    public final LogAppendInfo apply(int _) {
                        return this.log$5.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, this.log$5.appendAsLeader$default$3(), this.log$5.appendAsLeader$default$4());
                    }
                    {
                        this.log$5 = log$5;
                    }
                });
                log2.flush();
            }
        });
        logManager.checkpointLogRecoveryOffsets();
        Map checkpoints = new OffsetCheckpointFile(new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)topicPartitions.zip((GenIterable)logs, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, checkpoints){
            public static final long serialVersionUID = 0L;
            private final Map checkpoints$1;

            public final void apply(Tuple2<TopicPartition, Log> x0$1) {
                Tuple2<TopicPartition, Log> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Log log2 = (Log)tuple2._2();
                    Assert.assertEquals((String)"Recovery point should equal checkpoint", (long)BoxesRunTime.unboxToLong((Object)this.checkpoints$1.apply((Object)tp)), (long)log2.recoveryPoint());
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)log2.minSnapshotsOffsetToRetain())), (Object)log2.oldestProducerSnapshotOffset());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.checkpoints$1 = checkpoints$1;
            }
        });
    }

    private LogManager createLogManager(Seq<File> logDirs) {
        LogConfig x$47 = this.logConfig();
        Seq<File> x$48 = logDirs;
        MockTime x$49 = this.time();
        CleanerConfig x$50 = TestUtils$.MODULE$.createLogManager$default$3();
        return TestUtils$.MODULE$.createLogManager(x$48, x$47, x$50, x$49);
    }

    private Seq<File> createLogManager$default$1() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}));
    }

    @Test
    public void testFileReferencesAfterAsyncDelete() {
        LogManager qual$10 = this.logManager();
        TopicPartition x$51 = new TopicPartition(this.name(), 0);
        LogConfig x$52 = this.logConfig();
        boolean x$53 = qual$10.getOrCreateLog$default$3();
        boolean x$54 = qual$10.getOrCreateLog$default$4();
        Log log2 = qual$10.getOrCreateLog(x$51, x$52, x$53, x$54);
        LogSegment activeSegment = log2.activeSegment();
        String logName = activeSegment.log().file().getName();
        String indexName = activeSegment.offsetIndex().file().getName();
        String timeIndexName = activeSegment.timeIndex().file().getName();
        String txnIndexName = activeSegment.txnIndex().file().getName();
        File[] indexFilesOnDiskBeforeDelete = (File[])Predef$.MODULE$.refArrayOps((Object[])activeSegment.log().file().getParentFile().listFiles()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$8) {
                return x$8.getName().endsWith("index");
            }
        });
        LogManager qual$11 = this.logManager();
        TopicPartition x$55 = new TopicPartition(this.name(), 0);
        boolean x$56 = qual$11.asyncDelete$default$2();
        Log removedLog = qual$11.asyncDelete(x$55, x$56);
        LogSegment removedSegment = removedLog.activeSegment();
        Seq indexFilesAfterDelete = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{removedSegment.lazyOffsetIndex().file(), removedSegment.lazyTimeIndex().file(), removedSegment.txnIndex().file()}));
        Assert.assertEquals((Object)new File(removedLog.dir(), logName), (Object)removedSegment.log().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), indexName), (Object)removedSegment.lazyOffsetIndex().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), timeIndexName), (Object)removedSegment.lazyTimeIndex().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), txnIndexName), (Object)removedSegment.txnIndex().file());
        Predef$.MODULE$.refArrayOps((Object[])indexFilesOnDiskBeforeDelete).foreach((Function1)new Serializable(this, indexFilesAfterDelete){
            public static final long serialVersionUID = 0L;
            private final Seq indexFilesAfterDelete$1;

            public final void apply(File fileBeforeDelete) {
                Option fileInIndex = this.indexFilesAfterDelete$1.find((Function1)new Serializable(this, fileBeforeDelete){
                    public static final long serialVersionUID = 0L;
                    private final File fileBeforeDelete$1;

                    public final boolean apply(File x$9) {
                        String string = x$9.getName();
                        String string2 = this.fileBeforeDelete$1.getName();
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.fileBeforeDelete$1 = fileBeforeDelete$1;
                    }
                });
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find index file ", " in indexFilesAfterDelete"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileBeforeDelete.getName()})), (Object)new Some((Object)fileBeforeDelete.getName()), (Object)fileInIndex.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(File x$10) {
                        return x$10.getName();
                    }
                }));
                Assert.assertNotEquals((String)"File reference was not updated in index", (Object)fileBeforeDelete.getAbsolutePath(), (Object)((File)fileInIndex.get()).getAbsolutePath());
            }
            {
                this.indexFilesAfterDelete$1 = indexFilesAfterDelete$1;
            }
        });
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertTrue((String)"Logs deleted too early", (boolean)this.logManager().hasLogsToBeDeleted());
        this.time().sleep(Predef$.MODULE$.Long2long(this.logManager().currentDefaultConfig().fileDeleteDelayMs()) - (long)this.logManager().InitialTaskDelayMs());
        Assert.assertFalse((String)"Logs not deleted", (boolean)this.logManager().hasLogsToBeDeleted());
    }

    @Test
    public void testCreateAndDeleteOverlyLongTopic() {
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(253, "x"));
        LogManager qual$12 = this.logManager();
        TopicPartition x$57 = new TopicPartition(invalidTopicName, 0);
        LogConfig x$58 = this.logConfig();
        boolean x$59 = qual$12.getOrCreateLog$default$3();
        boolean x$60 = qual$12.getOrCreateLog$default$4();
        qual$12.getOrCreateLog(x$57, x$58, x$59, x$60);
        LogManager qual$13 = this.logManager();
        TopicPartition x$61 = new TopicPartition(invalidTopicName, 0);
        boolean x$62 = qual$13.asyncDelete$default$2();
        qual$13.asyncDelete(x$61, x$62);
    }

    @Test
    public void testCheckpointForOnlyAffectedLogs() {
        Seq tps = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 0), new TopicPartition("test-a", 1), new TopicPartition("test-a", 2), new TopicPartition("test-b", 0), new TopicPartition("test-b", 1)}));
        Seq allLogs = (Seq)tps.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final Log apply(TopicPartition x$11) {
                LogManager qual$14 = this.$outer.logManager();
                TopicPartition x$63 = x$11;
                LogConfig x$64 = this.$outer.logConfig();
                boolean x$65 = qual$14.getOrCreateLog$default$3();
                boolean x$66 = qual$14.getOrCreateLog$default$4();
                return qual$14.getOrCreateLog(x$63, x$64, x$65, x$66);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        allLogs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Log log2) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1)new Serializable(this, log2){
                    public static final long serialVersionUID = 0L;
                    private final Log log$6;

                    public final LogAppendInfo apply(int _) {
                        return this.log$6.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, this.log$6.appendAsLeader$default$3(), this.log$6.appendAsLeader$default$4());
                    }
                    {
                        this.log$6 = log$6;
                    }
                });
                log2.flush();
            }
        });
        this.logManager().checkpointRecoveryOffsetsAndCleanSnapshot(this.logDir(), (Seq)allLogs.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Log x$12) {
                return x$12.dir().getName().contains("test-a");
            }
        }));
        Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)tps.zip((GenIterable)allLogs, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, checkpoints){
            public static final long serialVersionUID = 0L;
            private final Map checkpoints$2;

            public final void apply(Tuple2<TopicPartition, Log> x0$2) {
                Tuple2<TopicPartition, Log> tuple2 = x0$2;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Log log2 = (Log)tuple2._2();
                    Assert.assertEquals((String)"Recovery point should equal checkpoint", (long)BoxesRunTime.unboxToLong((Object)this.checkpoints$2.apply((Object)tp)), (long)log2.recoveryPoint());
                    if (tp.topic().equals("test-a")) {
                        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)log2.minSnapshotsOffsetToRetain())), (Object)log2.oldestProducerSnapshotOffset());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Assert.assertNotEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)log2.minSnapshotsOffsetToRetain())), (Object)log2.oldestProducerSnapshotOffset());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.checkpoints$2 = checkpoints$2;
            }
        });
    }

    private FetchDataInfo readLog(Log log2, long offset, int maxLength) {
        return log2.read(offset, maxLength, (FetchIsolation)FetchLogEnd$.MODULE$, true);
    }

    private int readLog$default$3() {
        return 1024;
    }

    @Test
    public void testTopicConfigChangeUpdatesLogConfig() {
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        Log mockLog = (Log)EasyMock.mock(Log.class);
        this.logManager().initializingLog(testTopicOnePartition);
        this.logManager().initializingLog(testTopicTwoPartition);
        this.logManager().topicConfigUpdated(testTopicOne);
        LogConfig logConfig = null;
        BooleanRef configUpdated = BooleanRef.create((boolean)false);
        this.logManager().finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog), (Function0)new Serializable(this, logConfig, configUpdated){
            public static final long serialVersionUID = 0L;
            private final LogConfig logConfig$1;
            private final BooleanRef configUpdated$1;

            public final LogConfig apply() {
                this.configUpdated$1.elem = true;
                return this.logConfig$1;
            }
            {
                this.logConfig$1 = logConfig$1;
                this.configUpdated$1 = configUpdated$1;
            }
        });
        Assert.assertTrue((boolean)configUpdated.elem);
        BooleanRef configNotUpdated = BooleanRef.create((boolean)true);
        this.logManager().finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog), (Function0)new Serializable(this, logConfig, configNotUpdated){
            public static final long serialVersionUID = 0L;
            private final LogConfig logConfig$1;
            private final BooleanRef configNotUpdated$1;

            public final LogConfig apply() {
                this.configNotUpdated$1.elem = false;
                return this.logConfig$1;
            }
            {
                this.logConfig$1 = logConfig$1;
                this.configNotUpdated$1 = configNotUpdated$1;
            }
        });
        Assert.assertTrue((boolean)configNotUpdated.elem);
    }

    @Test
    public void testConfigChangeGetsCleanedUp() {
        TopicPartition testTopicPartition2 = new TopicPartition("test-topic", 1);
        this.logManager().initializingLog(testTopicPartition2);
        LogConfig logConfig = null;
        BooleanRef configUpdateNotCalled = BooleanRef.create((boolean)true);
        this.logManager().finishedInitializingLog(testTopicPartition2, (Option)None$.MODULE$, (Function0)new Serializable(this, logConfig, configUpdateNotCalled){
            public static final long serialVersionUID = 0L;
            private final LogConfig logConfig$2;
            private final BooleanRef configUpdateNotCalled$1;

            public final LogConfig apply() {
                this.configUpdateNotCalled$1.elem = false;
                return this.logConfig$2;
            }
            {
                this.logConfig$2 = logConfig$2;
                this.configUpdateNotCalled$1 = configUpdateNotCalled$1;
            }
        });
        Assert.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
        Assert.assertTrue((boolean)configUpdateNotCalled.elem);
    }

    @Test
    public void testBrokerConfigChangeDeliveredToAllLogs() {
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        Log mockLog = (Log)EasyMock.mock(Log.class);
        this.logManager().initializingLog(testTopicOnePartition);
        this.logManager().initializingLog(testTopicTwoPartition);
        this.logManager().brokerConfigUpdated();
        LogConfig logConfig = null;
        IntRef totalChanges = IntRef.create((int)0);
        this.logManager().finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog), (Function0)new Serializable(this, logConfig, totalChanges){
            public static final long serialVersionUID = 0L;
            private final LogConfig logConfig$3;
            private final IntRef totalChanges$1;

            public final LogConfig apply() {
                ++this.totalChanges$1.elem;
                return this.logConfig$3;
            }
            {
                this.logConfig$3 = logConfig$3;
                this.totalChanges$1 = totalChanges$1;
            }
        });
        this.logManager().finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog), (Function0)new Serializable(this, logConfig, totalChanges){
            public static final long serialVersionUID = 0L;
            private final LogConfig logConfig$3;
            private final IntRef totalChanges$1;

            public final LogConfig apply() {
                ++this.totalChanges$1.elem;
                return this.logConfig$3;
            }
            {
                this.logConfig$3 = logConfig$3;
                this.totalChanges$1 = totalChanges$1;
            }
        });
        Assert.assertEquals((long)2L, (long)totalChanges.elem);
    }

    @Test
    public void testConfigChangesWithNoLogGettingInitialized() {
        this.logManager().brokerConfigUpdated();
        this.logManager().topicConfigUpdated("test-topic");
        Assert.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 600000;
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(4096));
        this.logProps().put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(this.maxLogAgeMs()));
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.logDir = null;
        this.logManager = null;
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
    }
}

