/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import kafka.log.Defaults$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogTest$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

public final class LogTest$ {
    public static final LogTest$ MODULE$;

    static {
        new LogTest$();
    }

    public LogConfig createLogConfig(long segmentMs, int segmentBytes, long retentionMs, long retentionBytes, long segmentJitterMs, String cleanupPolicy, int maxMessageBytes, int indexIntervalBytes, int segmentIndexBytes, String messageFormatVersion, long fileDeleteDelayMs) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentMsProp(), Predef$.MODULE$.long2Long(segmentMs));
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentBytes));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.long2Long(retentionMs));
        logProps.put(LogConfig$.MODULE$.RetentionBytesProp(), Predef$.MODULE$.long2Long(retentionBytes));
        logProps.put(LogConfig$.MODULE$.SegmentJitterMsProp(), Predef$.MODULE$.long2Long(segmentJitterMs));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(maxMessageBytes));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(indexIntervalBytes));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(segmentIndexBytes));
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), messageFormatVersion);
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.long2Long(fileDeleteDelayMs));
        return new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
    }

    public Log createLog(File dir, LogConfig config, BrokerTopicStats brokerTopicStats, Scheduler scheduler, Time time, long logStartOffset, long recoveryPoint, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs) {
        return Log$.MODULE$.apply(dir, config, logStartOffset, recoveryPoint, scheduler, brokerTopicStats, time, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, new LogDirFailureChannel(10));
    }

    public long createLogConfig$default$1() {
        return Defaults$.MODULE$.SegmentMs();
    }

    public int createLogConfig$default$2() {
        return Defaults$.MODULE$.SegmentSize();
    }

    public long createLogConfig$default$3() {
        return Defaults$.MODULE$.RetentionMs();
    }

    public long createLogConfig$default$4() {
        return Defaults$.MODULE$.RetentionSize();
    }

    public long createLogConfig$default$5() {
        return Defaults$.MODULE$.SegmentJitterMs();
    }

    public String createLogConfig$default$6() {
        return Defaults$.MODULE$.CleanupPolicy();
    }

    public int createLogConfig$default$7() {
        return Defaults$.MODULE$.MaxMessageSize();
    }

    public int createLogConfig$default$8() {
        return Defaults$.MODULE$.IndexInterval();
    }

    public int createLogConfig$default$9() {
        return Defaults$.MODULE$.MaxIndexSize();
    }

    public String createLogConfig$default$10() {
        return Defaults$.MODULE$.MessageFormatVersion();
    }

    public long createLogConfig$default$11() {
        return Defaults$.MODULE$.FileDeleteDelayMs();
    }

    public long createLog$default$6() {
        return 0L;
    }

    public long createLog$default$7() {
        return 0L;
    }

    public int createLog$default$8() {
        return 3600000;
    }

    public int createLog$default$9() {
        return LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    public boolean hasOffsetOverflow(Log log2) {
        return this.firstOverflowSegment(log2).isDefined();
    }

    public Option<LogSegment> firstOverflowSegment(Log log2) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            None$ none$;
            Object object = new Object();
            try {
                log2.logSegments().foreach((Function1)new Serializable(object){
                    public static final long serialVersionUID = 0L;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(LogSegment segment) {
                        Option overflowBatch = ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).find((Function1)new Serializable(this, segment){
                            public static final long serialVersionUID = 0L;
                            private final LogSegment segment$3;

                            public final boolean apply(FileLogInputStream.FileChannelRecordBatch batch) {
                                return LogTest$.MODULE$.kafka$log$LogTest$$hasOverflow$1(this.segment$3.baseOffset(), (RecordBatch)batch);
                            }
                            {
                                this.segment$3 = segment$3;
                            }
                        });
                        if (overflowBatch.isDefined()) {
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Some((Object)segment));
                        }
                    }
                    {
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                none$ = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                none$ = (Option)nonLocalReturnControl2.value();
            }
            return none$;
        }
        throw nonLocalReturnControl2;
    }

    public FileRecords kafka$log$LogTest$$rawSegment(File logDir, long baseOffset) {
        return FileRecords.open((File)Log$.MODULE$.logFile(logDir, baseOffset, Log$.MODULE$.logFile$default$3()));
    }

    public void initializeLogDirWithOverflowedSegment(File logDir) {
        long nextOffset = 0L;
        nextOffset = this.writeNormalSegment$1(nextOffset, logDir);
        nextOffset = this.writeOverflowSegment$1(nextOffset, logDir);
        this.writeNormalSegment$1(nextOffset, logDir);
    }

    public List<Record> allRecords(Log log2) {
        ListBuffer recordsFound = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        log2.logSegments().foreach((Function1)new Serializable(recordsFound){
            public static final long serialVersionUID = 0L;
            public final ListBuffer recordsFound$1;

            public final void apply(LogSegment logSegment) {
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(logSegment.log().batches()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.allRecords.1 $outer;

                    public final ListBuffer<Record> apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return this.$outer.recordsFound$1.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(batch.iterator()).asScala());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.recordsFound$1 = recordsFound$1;
            }
        });
        return recordsFound.toList();
    }

    public void verifyRecordsInLog(Log log2, List<Record> expectedRecords) {
        Assert.assertEquals(expectedRecords, this.allRecords(log2));
    }

    public Iterable<Object> keysInLog(Log log2) {
        return (Iterable)log2.logSegments().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment logSegment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(logSegment.log().batches()).asScala()).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return !batch.isControlBatch();
                    }
                }).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Object> apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Record record) {
                                return record.hasValue() && record.hasKey();
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(Record record) {
                                return new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2()))).toLong();
                            }
                        }, Iterable$.MODULE$.canBuildFrom());
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public Log recoverAndCheck(File logDir, LogConfig config, Iterable<Object> expectedKeys, BrokerTopicStats brokerTopicStats, Time time, Scheduler scheduler, boolean expectDeletedFiles) {
        Log recoveredLog = this.createLog(logDir, config, brokerTopicStats, scheduler, time, this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9());
        time.sleep(Predef$.MODULE$.Long2long(config.fileDeleteDelayMs()) + 1L);
        Predef$.MODULE$.refArrayOps((Object[])logDir.listFiles()).foreach((Function1)new Serializable(expectDeletedFiles){
            public static final long serialVersionUID = 0L;
            private final boolean expectDeletedFiles$1;

            public final void apply(File file) {
                if (!this.expectDeletedFiles$1) {
                    Assert.assertFalse((String)"Unexpected .deleted file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix()));
                }
                Assert.assertFalse((String)"Unexpected .cleaned file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.CleanedFileSuffix()));
                Assert.assertFalse((String)"Unexpected .swap file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.SwapFileSuffix()));
            }
            {
                this.expectDeletedFiles$1 = expectDeletedFiles$1;
            }
        });
        Assert.assertEquals(expectedKeys, this.keysInLog(recoveredLog));
        Assert.assertFalse((boolean)this.hasOffsetOverflow(recoveredLog));
        return recoveredLog;
    }

    public boolean recoverAndCheck$default$7() {
        return false;
    }

    public final boolean kafka$log$LogTest$$hasOverflow$1(long baseOffset, RecordBatch batch) {
        return batch.lastOffset() > baseOffset + Integer.MAX_VALUE || batch.baseOffset() < baseOffset;
    }

    private final SimpleRecord record$1(long offset) {
        byte[] data = ((Object)BoxesRunTime.boxToLong((long)offset)).toString().getBytes();
        return new SimpleRecord(data, data);
    }

    private final long writeSampleBatches$1(long baseOffset, FileRecords segment, File logDir$1) {
        segment.append(MemoryRecords.withRecords((long)baseOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{this.record$1(baseOffset)}));
        segment.append(MemoryRecords.withRecords((long)(baseOffset + 1L), (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{this.record$1(baseOffset + 1L), this.record$1(baseOffset + 2L)}));
        segment.append(MemoryRecords.withRecords((long)(baseOffset + Integer.MAX_VALUE - 1L), (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{this.record$1(baseOffset + Integer.MAX_VALUE - 1L)}));
        Log$.MODULE$.offsetIndexFile(logDir$1, baseOffset, Log$.MODULE$.offsetIndexFile$default$3()).createNewFile();
        Log$.MODULE$.timeIndexFile(logDir$1, baseOffset, Log$.MODULE$.timeIndexFile$default$3()).createNewFile();
        return baseOffset + Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    private final long writeNormalSegment$1(long baseOffset, File logDir$1) {
        long l;
        FileRecords segment = this.kafka$log$LogTest$$rawSegment(logDir$1, baseOffset);
        try {
            l = this.writeSampleBatches$1(baseOffset, segment, logDir$1);
        }
        catch (Throwable throwable) {
            void var4_3;
            var4_3.close();
            throw throwable;
        }
        segment.close();
        return l;
    }

    /*
     * WARNING - void declaration
     */
    private final long writeOverflowSegment$1(long baseOffset, File logDir$1) {
        long l;
        FileRecords segment = this.kafka$log$LogTest$$rawSegment(logDir$1, baseOffset);
        try {
            long nextOffset = this.writeSampleBatches$1(baseOffset, segment, logDir$1);
            l = this.writeSampleBatches$1(nextOffset, segment, logDir$1);
        }
        catch (Throwable throwable) {
            void var4_3;
            var4_3.close();
            throw throwable;
        }
        segment.close();
        return l;
    }

    private LogTest$() {
        MODULE$ = this;
    }
}

