/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import kafka.log.AppendOrigin;
import kafka.log.CompletedTxn;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager;
import kafka.log.TxnMetadata;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t\u001dh\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0004\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001A\u0002\u0013\u0005Q#\u0001\u0004m_\u001e$\u0015N]\u000b\u0002-A\u0011q\u0003H\u0007\u00021)\u0011\u0011DG\u0001\u0003S>T\u0011aG\u0001\u0005U\u00064\u0018-\u0003\u0002\u001e1\t!a)\u001b7f\u0011\u001dy\u0002\u00011A\u0005\u0002\u0001\n!\u0002\\8h\t&\u0014x\fJ3r)\t\tC\u0005\u0005\u0002\nE%\u00111E\u0003\u0002\u0005+:LG\u000fC\u0004&=\u0005\u0005\t\u0019\u0001\f\u0002\u0007a$\u0013\u0007\u0003\u0004(\u0001\u0001\u0006KAF\u0001\bY><G)\u001b:!\u0011\u001dI\u0003\u00011A\u0005\u0002)\nAb\u001d;bi\u0016l\u0015M\\1hKJ,\u0012a\u000b\t\u0003%1J!!\f\u0002\u0003)A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0011\u001dy\u0003\u00011A\u0005\u0002A\n\u0001c\u001d;bi\u0016l\u0015M\\1hKJ|F%Z9\u0015\u0005\u0005\n\u0004bB\u0013/\u0003\u0003\u0005\ra\u000b\u0005\u0007g\u0001\u0001\u000b\u0015B\u0016\u0002\u001bM$\u0018\r^3NC:\fw-\u001a:!\u0011\u001d)\u0004A1A\u0005\u0002Y\n\u0011\u0002]1si&$\u0018n\u001c8\u0016\u0003]\u0002\"\u0001\u000f!\u000e\u0003eR!AO\u001e\u0002\r\r|W.\\8o\u0015\t)AH\u0003\u0002>}\u00051\u0011\r]1dQ\u0016T\u0011aP\u0001\u0004_J<\u0017BA!:\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Daa\u0011\u0001!\u0002\u00139\u0014A\u00039beRLG/[8oA!9Q\t\u0001b\u0001\n\u00031\u0015A\u00039s_\u0012,8-\u001a:JIV\tq\t\u0005\u0002\n\u0011&\u0011\u0011J\u0003\u0002\u0005\u0019>tw\r\u0003\u0004L\u0001\u0001\u0006IaR\u0001\faJ|G-^2fe&#\u0007\u0005C\u0004N\u0001\t\u0007I\u0011\u0001(\u0002%5\f\u0007\u0010U5e\u000bb\u0004\u0018N]1uS>tWj]\u000b\u0002\u001fB\u0011\u0011\u0002U\u0005\u0003#*\u00111!\u00138u\u0011\u0019\u0019\u0006\u0001)A\u0005\u001f\u0006\u0019R.\u0019=QS\u0012,\u0005\u0010]5sCRLwN\\'tA!9Q\u000b\u0001b\u0001\n\u00031\u0016\u0001\u0002;j[\u0016,\u0012a\u0016\t\u00031nk\u0011!\u0017\u0006\u00035f\nQ!\u001e;jYNL!\u0001X-\u0003\u00115{7m\u001b+j[\u0016DaA\u0018\u0001!\u0002\u00139\u0016!\u0002;j[\u0016\u0004\u0003\"\u00021\u0001\t\u0003\t\u0017!B:fiV\u0003H#A\u0011)\u0005}\u001b\u0007C\u00013h\u001b\u0005)'B\u00014?\u0003\u0015QWO\\5u\u0013\tAWM\u0001\u0004CK\u001a|'/\u001a\u0005\u0006U\u0002!\t!Y\u0001\ti\u0016\f'\u000fR8x]\"\u0012\u0011\u000e\u001c\t\u0003I6L!A\\3\u0003\u000b\u00053G/\u001a:\t\u000bA\u0004A\u0011A1\u0002%Q,7\u000f\u001e\"bg&\u001c\u0017\nZ'baBLgn\u001a\u0015\u0003_J\u0004\"\u0001Z:\n\u0005Q,'\u0001\u0002+fgRDQA\u001e\u0001\u0005\u0002\u0005\fa\u0005^3ti\u0006\u0003\b/\u001a8e)btW*\u0019:lKJ<\u0016\u000e\u001e5O_B\u0013x\u000eZ;dKJ\u001cF/\u0019;fQ\t)(\u000fC\u0003z\u0001\u0011\u0005\u0011-\u0001\u0010uKN$\bK]8ek\u000e,'oU3rk\u0016t7-Z,sCB\f%o\\;oI\"\u0012\u0001P\u001d\u0005\u0006y\u0002!\t!Y\u0001.i\u0016\u001cH\u000f\u0015:pIV\u001cWM]*fcV,gnY3XSRDwK]1q\u0003J|WO\u001c3CCR\u001c\u0007NU3d_J$\u0007FA>s\u0011\u0015y\b\u0001\"\u0001b\u0003\u0015\"Xm\u001d;Qe>$WoY3s'\u0016\fX/\u001a8dK&sg/\u00197jI^\u0013\u0018\r]!s_VtG\r\u000b\u0004\u007fe\u0006\r\u0011QA\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012\u0011q\u0001\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011QB\u001d\u0002\r\u0015\u0014(o\u001c:t\u0013\u0011\t\t\"a\u0003\u00037=+Ho\u00144Pe\u0012,'oU3rk\u0016t7-Z#yG\u0016\u0004H/[8o\u0011\u0019\t)\u0002\u0001C\u0001C\u0006QC/Z:u\u001d>4\u0016\r\\5eCRLwN\\(o\r&\u00148\u000f^#oiJLx\u000b[3o\u0019>\fG-\u001b8h\u0019><\u0007fAA\ne\"1\u00111\u0004\u0001\u0005\u0002\u0005\f1\u0004^3ti\u000e{g\u000e\u001e:pYJ+7m\u001c:e\u0005Vl\u0007o]#q_\u000eD\u0007fAA\re\"1\u0011\u0011\u0005\u0001\u0005\u0002\u0005\f\u0001\u0005^3tiRChNR5sgR|eMZ:fi6+G/\u00193bi\u0006\u001c\u0015m\u00195fI\"\u001a\u0011q\u0004:\t\r\u0005\u001d\u0002\u0001\"\u0001b\u0003\u0001\"Xm\u001d;MCN$8\u000b^1cY\u0016|eMZ:fi\u000e{W\u000e\u001d7fi\u0016$G\u000b\u001f8)\u0007\u0005\u0015\"\u000f\u0003\u0004\u0002.\u0001!\t!Y\u0001\u001fi\u0016\u001cH\u000f\u0015:fa\u0006\u0014X-\u00169eCR,Gi\\3t\u001d>$X*\u001e;bi\u0016D3!a\u000bs\u0011\u0019\t\u0019\u0004\u0001C\u0001C\u0006qR\u000f\u001d3bi\u0016\u0004&o\u001c3vG\u0016\u0014HK]1og\u0006\u001cG/[8o'R\fG/\u001a\u0015\u0004\u0003c\u0011\bBBA\u001d\u0001\u0011\u0005\u0011-\u0001\u0017uKN$x*\u001e;PMN+\u0017/^3oG\u0016\fe\r^3s\u0007>tGO]8m%\u0016\u001cwN\u001d3Fa>\u001c\u0007NQ;na\"\u001a\u0011q\u0007:\t\r\u0005}\u0002\u0001\"\u0001b\u0003A\"Xm\u001d;O_:$&/\u00198tC\u000e$\u0018n\u001c8bY\u0006\u0003\b/\u001a8e/&$\bn\u00148h_&tw\r\u0016:b]N\f7\r^5p]\":\u0011Q\b:\u0002\u0004\u0005\r3EAA#!\u0011\tI!a\u0012\n\t\u0005%\u00131\u0002\u0002\u0019\u0013:4\u0018\r\\5e)bt7\u000b^1uK\u0016C8-\u001a9uS>t\u0007BBA'\u0001\u0011\u0005\u0011-A\u0018uKN$HK];oG\u0006$X-\u00118e%\u0016dw.\u00193SK6|g/Z:PkR|eMU1oO\u0016\u001cf.\u00199tQ>$8\u000fK\u0002\u0002LIDa!a\u0015\u0001\t\u0003\t\u0017\u0001\u0005;fgR$\u0016m[3T]\u0006\u00048\u000f[8uQ\r\t\tF\u001d\u0005\u0007\u00033\u0002A\u0011A1\u0002YQ,7\u000f\u001e*fG>4XM\u001d$s_6\u001cf.\u00199tQ>$XK\u001c4j]&\u001c\b.\u001a3Ue\u0006t7/Y2uS>t\u0007fAA,e\"1\u0011q\f\u0001\u0005\u0002\u0005\f!\u0006^3tiJ+7m\u001c<fe\u001a\u0013x.\\*oCB\u001c\bn\u001c;GS:L7\u000f[3e)J\fgn]1di&|g\u000eK\u0002\u0002^IDa!!\u001a\u0001\t\u0003\t\u0017a\n;fgR\u0014VmY8wKJ4%o\\7T]\u0006\u00048\u000f[8u\u000b6\u0004H/\u001f+sC:\u001c\u0018m\u0019;j_:D3!a\u0019s\u0011\u0019\tY\u0007\u0001C\u0001C\u0006AC/Z:u!J|G-^2feN#\u0018\r^3BMR,'OR3oG&tw-\u00112peRl\u0015M]6fe\"\u001a\u0011\u0011\u000e:\t\r\u0005E\u0004\u0001\"\u0001b\u0003u!Xm\u001d;SK6|g/Z#ya&\u0014X\r\u001a)jIN|eNU3m_\u0006$\u0007fBA8e\u0006\r\u0011QO\u0012\u0003\u0003o\u0002B!!\u0003\u0002z%!\u00111PA\u0006\u0005i)fn\u001b8po:\u0004&o\u001c3vG\u0016\u0014\u0018\nZ#yG\u0016\u0004H/[8o\u0011\u0019\ty\b\u0001C\u0001C\u0006iC/Z:u\u0003\u000e\u001cW\r\u001d;BaB,g\u000eZ,ji\"|W\u000f\u001e)s_\u0012,8-\u001a:Ti\u0006$Xm\u00148SKBd\u0017nY1)\u0007\u0005u$\u000f\u0003\u0004\u0002\u0006\u0002!\t!Y\u0001*i\u0016\u001cH/Q2dKB$\u0018\t\u001d9f]\u0012<\u0016\u000e\u001e5TKF,XM\\2f\u000f\u0006\u00048o\u00148SKBd\u0017nY1)\u0007\u0005\r%\u000f\u0003\u0004\u0002\f\u0002!\t!Y\u0001\u001ai\u0016\u001cH\u000fR3mKR,7K\\1qg\"|Go\u001d\"fM>\u0014X\rK\u0002\u0002\nJDa!!%\u0001\t\u0003\t\u0017\u0001\u0004;fgR$&/\u001e8dCR,\u0007fAAHe\"1\u0011q\u0013\u0001\u0005\u0002\u0005\fa\u0005^3ti\u001aK'o\u001d;V]N$\u0018M\u00197f\u001f\u001a47/\u001a;BMR,'\u000f\u0016:v]\u000e\fG/[8oQ\r\t)J\u001d\u0005\u0007\u0003;\u0003A\u0011A1\u0002]Q,7\u000f\u001e'pC\u00124%o\\7T]\u0006\u00048\u000f[8u%\u0016$\u0018-\u001b8t\u001d>tW\t\u001f9je\u0016$\u0007K]8ek\u000e,'o\u001d\u0015\u0004\u00037\u0013\bBBAR\u0001\u0011\u0005\u0011-A\u0011uKN$8k[5q':\f\u0007o\u001d5pi&3wJ\u001a4tKR,fn\u00195b]\u001e,G\rK\u0002\u0002\"JDa!!+\u0001\t\u0003\t\u0017a\u0004;fgR\u001cF/\u0019:u\u001f\u001a47/\u001a;)\u0007\u0005\u001d&\u000f\u0003\u0004\u00020\u0002!\t!Y\u0001\u0019i\u0016\u001cH\u000fU5e\u000bb\u0004\u0018N]1uS>tG+[7f_V$\bfBAWe\u0006\r\u0011Q\u000f\u0005\u0007\u0003k\u0003A\u0011A1\u0002/Q,7\u000f\u001e$jeN$XK\\:uC\ndWm\u00144gg\u0016$\bfAAZe\"1\u00111\u0018\u0001\u0005\u0002\u0005\fa\u0006^3tiB\u0013x\u000eZ;dKJ\u001cx+\u001b;i\u001f:<w.\u001b8h)J\fgn]1di&|gn\u001d#p]R,\u0005\u0010]5sK\"\u001a\u0011\u0011\u0018:\t\r\u0005\u0005\u0007\u0001\"\u0001b\u00035\"Xm\u001d;TKF,XM\\2f\u001d>$h+\u00197jI\u0006$X\r\u001a$pe\u001e\u0013x.\u001e9NKR\fG-\u0019;b)>\u0004\u0018n\u0019\u0015\u0004\u0003\u007f\u0013\bBBAd\u0001\u0011\u0005\u0011-\u0001\u000fuKN$x\n\u001c3Fa>\u001c\u0007NR8s\u0007>tGO]8m%\u0016\u001cwN\u001d3)\u000f\u0005\u0015'/a\u0001\u0002L\u000e\u0012\u0011Q\u001a\t\u0005\u0003\u0013\ty-\u0003\u0003\u0002R\u0006-!a\u0006)s_\u0012,8-\u001a:GK:\u001cW\rZ#yG\u0016\u0004H/[8o\u0011\u0019\t)\u000e\u0001C\u0001C\u00061B/Z:u\u0007>|'\u000fZ5oCR|'OR3oG&tw\rK\u0002\u0002TJDa!a7\u0001\t\u0003\t\u0017\u0001\t;fgR\u001cun\u001c:eS:\fGo\u001c:GK:\u001cW\rZ!gi\u0016\u0014(+\u001a7pC\u0012Ds!!7s\u0003\u0007\tyn\t\u0002\u0002bB!\u0011\u0011BAr\u0013\u0011\t)/a\u0003\u0003KQ\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_J4UM\\2fI\u0016C8-\u001a9uS>t\u0007BBAu\u0001\u0011\u0005\u0011-A\u000fuKN$Hj\\1e\rJ|W.R7qif\u001cf.\u00199tQ>$h)\u001b7fQ\r\t9O\u001d\u0005\u0007\u0003_\u0004A\u0011A1\u0002CQ,7\u000f\u001e'pC\u00124%o\\7UeVt7-\u0019;fINs\u0017\r]:i_R4\u0015\u000e\\3)\u0007\u00055(\u000f\u0003\u0004\u0002v\u0002!\t!Y\u0001 i\u0016\u001cH\u000fT8bI\u001a\u0013x.\\\"peJ,\b\u000f^*oCB\u001c\bn\u001c;GS2,\u0007fAAze\"1\u00111 \u0001\u0005\u0002\u0005\f1\u0004^3ti\u0006\u0003\b/\u001a8e\u000b6\u0004H/_\"p]R\u0014x\u000e\u001c\"bi\u000eD\u0007fAA}e\"9!\u0011\u0001\u0001\u0005\n\t\r\u0011a\u0007;fgRdu.\u00193Ge>l7i\u001c:skB$8K\\1qg\"|G\u000fF\u0002\"\u0005\u000bA\u0001Ba\u0002\u0002\u0000\u0002\u0007!\u0011B\u0001\u0010[\u0006\\WMR5mK\u000e{'O];qiB1\u0011Ba\u0003\u0003\u0010\u0005J1A!\u0004\u000b\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0003\u0012\tmQB\u0001B\n\u0015\u0011\u0011)Ba\u0006\u0002\u0011\rD\u0017M\u001c8fYNT1A!\u0007\u001b\u0003\rq\u0017n\\\u0005\u0005\u0005;\u0011\u0019BA\u0006GS2,7\t[1o]\u0016d\u0007b\u0002B\u0011\u0001\u0011%!1E\u0001\u0013CB\u0004XM\u001c3F]\u0012$\u0006P\\'be.,'\u000f\u0006\t\u0003&\tE\"Q\u0007B\u001c\u0005\u0003\u0012\tF!\u0016\u0003ZA1\u0011Ba\n\u0003,\u001dK1A!\u000b\u000b\u0005\u0019!V\u000f\u001d7feA\u0019!C!\f\n\u0007\t=\"A\u0001\u0007D_6\u0004H.\u001a;fIRCh\u000eC\u0004\u00034\t}\u0001\u0019A\u0016\u0002\u000f5\f\u0007\u000f]5oO\"1QIa\bA\u0002\u001dC\u0001B!\u000f\u0003 \u0001\u0007!1H\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0011\u0007%\u0011i$C\u0002\u0003@)\u0011Qa\u00155peRD\u0001Ba\u0011\u0003 \u0001\u0007!QI\u0001\fG>tGO]8m)f\u0004X\r\u0005\u0003\u0003H\t5SB\u0001B%\u0015\r\u0011Y%O\u0001\u0007e\u0016\u001cwN\u001d3\n\t\t=#\u0011\n\u0002\u0012\u0007>tGO]8m%\u0016\u001cwN\u001d3UsB,\u0007b\u0002B*\u0005?\u0001\raR\u0001\u0007_\u001a47/\u001a;\t\u0013\t]#q\u0004I\u0001\u0002\u0004y\u0015\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0011%\u0011YFa\b\u0011\u0002\u0003\u0007q)A\u0005uS6,7\u000f^1na\"9!q\f\u0001\u0005\n\t\u0005\u0014AB1qa\u0016tG\rF\t\"\u0005G\u0012)Ga\u001a\u0003j\t5$q\u000eB9\u0005wBa!\u000bB/\u0001\u0004Y\u0003BB#\u0003^\u0001\u0007q\t\u0003\u0005\u0003:\tu\u0003\u0019\u0001B\u001e\u0011\u001d\u0011YG!\u0018A\u0002=\u000b1a]3r\u0011\u001d\u0011\u0019F!\u0018A\u0002\u001dC\u0011Ba\u0017\u0003^A\u0005\t\u0019A$\t\u0015\tM$Q\fI\u0001\u0002\u0004\u0011)(A\bjgR\u0013\u0018M\\:bGRLwN\\1m!\rI!qO\u0005\u0004\u0005sR!a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0005{\u0012i\u0006%AA\u0002\t}\u0014AB8sS\u001eLg\u000eE\u0002\u0013\u0005\u0003K1Aa!\u0003\u00051\t\u0005\u000f]3oI>\u0013\u0018nZ5o\u0011\u001d\u0011y\u0006\u0001C\u0005\u0005\u000f#R\"\tBE\u0005\u0017\u0013iIa$\u0003\u0012\nm\u0005BB\u0015\u0003\u0006\u0002\u00071\u0006\u0003\u0004F\u0005\u000b\u0003\ra\u0012\u0005\t\u0005s\u0011)\t1\u0001\u0003<!9!1\u000bBC\u0001\u00049\u0005\u0002\u0003BJ\u0005\u000b\u0003\rA!&\u0002\u000b\t\fGo\u00195\u0011\t\t\u001d#qS\u0005\u0005\u00053\u0013IEA\u0006SK\u000e|'\u000f\u001a\"bi\u000eD\u0007\u0002\u0003B?\u0005\u000b\u0003\rAa \t\u000f\t}\u0005\u0001\"\u0003\u0003\"\u000612-\u001e:sK:$8K\\1qg\"|Go\u00144gg\u0016$8/\u0006\u0002\u0003$B)!Q\u0015BV\u000f:\u0019\u0011Ba*\n\u0007\t%&\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005[\u0013yKA\u0002TKRT1A!+\u000b\u0011%\u0011\u0019\fAI\u0001\n\u0013\u0011),\u0001\tbaB,g\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!q\u0017\u0016\u0004\u000f\ne6F\u0001B^!\u0011\u0011iLa2\u000e\u0005\t}&\u0002\u0002Ba\u0005\u0007\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0015'\"\u0001\u0006b]:|G/\u0019;j_:LAA!3\u0003@\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t5\u0007!%A\u0005\n\t=\u0017\u0001E1qa\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011\tN\u000b\u0003\u0003v\te\u0006\"\u0003Bk\u0001E\u0005I\u0011\u0002Bl\u0003A\t\u0007\u000f]3oI\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0003Z*\"!q\u0010B]\u0011%\u0011i\u000eAI\u0001\n\u0013\u0011y.\u0001\u000fbaB,g\u000eZ#oIRCh.T1sW\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\t\u0005(fA(\u0003:\"I!Q\u001d\u0001\u0012\u0002\u0013%!QW\u0001\u001dCB\u0004XM\u001c3F]\u0012$\u0006P\\'be.,'\u000f\n3fM\u0006,H\u000e\u001e\u00138\u0001")
public class ProducerStateManagerTest {
    private File logDir = null;
    private ProducerStateManager stateManager = null;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxPidExpirationMs;
    private final MockTime time = new MockTime();

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public ProducerStateManager stateManager() {
        return this.stateManager;
    }

    public void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    public long producerId() {
        return this.producerId;
    }

    public int maxPidExpirationMs() {
        return this.maxPidExpirationMs;
    }

    public MockTime time() {
        return this.time;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs()));
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, epoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short epoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), this.epoch$1, 1, 0L, 1L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$1 = epoch$1;
            }
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, epoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short epoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), this.epoch$1, 5, 0L, 2L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$1 = epoch$1;
            }
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, epoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short epoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), this.epoch$1, 0, 0L, 4L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$1 = epoch$1;
            }
        }, ClassTag$.MODULE$.apply(ProducerFencedException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
    }

    @Test
    public void testAppendTxnMarkerWithNoProducerState() {
        short producerEpoch = (short)2;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 27L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        ProducerStateEntry firstEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return Assertions$.MODULE$.fail("Expected last entry to be defined", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            }
        });
        Assert.assertEquals((long)producerEpoch, (long)firstEntry.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)firstEntry.producerId());
        Assert.assertEquals((long)-1L, (long)firstEntry.lastSeq());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), (short)0, 0, 0L, 4L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ProducerFencedException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, producerEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short producerEpoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), this.producerEpoch$1, 17, 0L, 4L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producerEpoch$1 = producerEpoch$1;
            }
        }, ClassTag$.MODULE$.apply(UnknownProducerIdException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), producerEpoch, 0, 39L, 4L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        ProducerStateEntry secondEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return Assertions$.MODULE$.fail("Expected last entry to be defined", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            }
        });
        Assert.assertEquals((long)producerEpoch, (long)secondEntry.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)secondEntry.producerId());
        Assert.assertEquals((long)0L, (long)secondEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$17 = this.stateManager();
        long x$18 = this.producerId();
        short x$19 = epoch;
        int x$20 = sequence;
        long x$21 = offset;
        AppendOrigin.Replication$ x$22 = AppendOrigin.Replication$.MODULE$;
        long x$23 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$24 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
        this.kafka$log$ProducerStateManagerTest$$append(x$17, x$18, x$19, x$20, x$21, x$23, x$24, (AppendOrigin)x$22);
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)0L, (long)lastEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWithWrapAroundBatchRecord() {
        short epoch = (short)15;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Replication$.MODULE$);
        appendInfo.appendDataBatch(epoch, 0x7FFFFFF5, 9, this.time().milliseconds(), new LogOffsetMetadata(2000L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 2020L, false);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0x7FFFFFF5L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)9L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)2000L, (long)lastEntry.firstDataOffset());
        Assert.assertEquals((long)2020L, (long)lastEntry.lastDataOffset());
    }

    @Test(expected=OutOfOrderSequenceException.class)
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$25 = this.stateManager();
        long x$26 = this.producerId();
        short x$27 = epoch;
        int x$28 = sequence;
        long x$29 = offset;
        AppendOrigin.Replication$ x$30 = AppendOrigin.Replication$.MODULE$;
        long x$31 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$32 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
        this.kafka$log$ProducerStateManagerTest$$append(x$25, x$26, x$27, x$28, x$29, x$31, x$32, (AppendOrigin)x$30);
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        short x$35 = epoch;
        int x$36 = sequence;
        long x$37 = offset;
        AppendOrigin.Replication$ x$38 = AppendOrigin.Replication$.MODULE$;
        long x$39 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$40 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
        this.kafka$log$ProducerStateManagerTest$$append(x$33, x$34, x$35, x$36, x$37, x$39, x$40, (AppendOrigin)x$38);
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)offset, (long)lastEntry.firstDataOffset());
    }

    @Test
    public void testControlRecordBumpsEpoch() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        short bumpedEpoch = (short)1;
        Tuple2<CompletedTxn, Object> tuple2 = this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        if (tuple2 != null) {
            Tuple2 tuple22;
            CompletedTxn completedTxn = (CompletedTxn)tuple2._1();
            long lastStableOffset = tuple2._2$mcJ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)completedTxn, (Object)BoxesRunTime.boxToLong((long)lastStableOffset));
            CompletedTxn completedTxn2 = (CompletedTxn)tuple23._1();
            long lastStableOffset2 = tuple23._2$mcJ$sp();
            Assert.assertEquals((long)1L, (long)completedTxn2.firstOffset());
            Assert.assertEquals((long)1L, (long)completedTxn2.lastOffset());
            Assert.assertEquals((long)2L, (long)lastStableOffset2);
            Assert.assertTrue((boolean)completedTxn2.isAborted());
            Assert.assertEquals((long)this.producerId(), (long)completedTxn2.producerId());
            Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
            Assert.assertTrue((boolean)maybeLastEntry.isDefined());
            ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
            Assert.assertEquals((long)bumpedEpoch, (long)lastEntry.producerEpoch());
            Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
            Assert.assertEquals((long)-1L, (long)lastEntry.firstSeq());
            Assert.assertEquals((long)-1L, (long)lastEntry.lastSeq());
            this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), bumpedEpoch, 0, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.stateManager().lastEntry(this.producerId()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(ProducerStateEntry x$2) {
                    return x$2.firstSeq();
                }
            }));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, this.time().milliseconds(), firstOffsetMetadata, offset, true);
        this.stateManager().update(producerAppendInfo);
        Assert.assertEquals((Object)new Some((Object)firstOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testLastStableOffsetCompletedTxn() {
        short producerEpoch = (short)0;
        long segmentBaseOffset = 990000L;
        long producerId1 = this.producerId();
        long startOffset1 = 992342L;
        this.beginTxn$1(producerId1, startOffset1, producerEpoch, segmentBaseOffset);
        long producerId2 = this.producerId() + 1L;
        long startOffset2 = startOffset1 + 25L;
        this.beginTxn$1(producerId2, startOffset2, producerEpoch, segmentBaseOffset);
        long producerId3 = this.producerId() + 2L;
        long startOffset3 = startOffset1 + 57L;
        this.beginTxn$1(producerId3, startOffset3, producerEpoch, segmentBaseOffset);
        long lastOffset1 = startOffset3 + 15L;
        CompletedTxn completedTxn1 = new CompletedTxn(producerId1, startOffset1, lastOffset1, false);
        Assert.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn1));
        this.stateManager().completeTxn(completedTxn1);
        this.stateManager().onHighWatermarkUpdated(lastOffset1 + 1L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$3) {
                return x$3.messageOffset();
            }
        }));
        long lastOffset3 = lastOffset1 + 20L;
        CompletedTxn completedTxn3 = new CompletedTxn(producerId3, startOffset3, lastOffset3, false);
        Assert.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn3));
        this.stateManager().completeTxn(completedTxn3);
        this.stateManager().onHighWatermarkUpdated(lastOffset3 + 1L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$4) {
                return x$4.messageOffset();
            }
        }));
        long lastOffset2 = lastOffset3 + 78L;
        CompletedTxn completedTxn2 = new CompletedTxn(producerId2, startOffset2, lastOffset2, false);
        Assert.assertEquals((long)(lastOffset2 + 1L), (long)this.stateManager().lastStableOffset(completedTxn2));
        this.stateManager().completeTxn(completedTxn2);
        this.stateManager().onHighWatermarkUpdated(lastOffset2 + 1L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendInfo.appendDataBatch(producerEpoch, 0, 5, this.time().milliseconds(), new LogOffsetMetadata(15L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 20L, false);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        nextAppendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 30L, false);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendInfo.appendDataBatch(producerEpoch, 1, 5, this.time().milliseconds(), new LogOffsetMetadata(16L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assert.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
        appendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 30L, true);
        lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        CompletedTxn completedTxn = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assert.assertEquals((long)this.producerId(), (long)completedTxn.producerId());
        Assert.assertEquals((long)16L, (long)completedTxn.firstOffset());
        Assert.assertEquals((long)40L, (long)completedTxn.lastOffset());
        Assert.assertFalse((boolean)completedTxn.isAborted());
        lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)coordinatorEpoch, (long)lastEntry.coordinatorEpoch());
        Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        short epoch = (short)0;
        ProducerStateManager x$41 = this.stateManager();
        long x$42 = this.producerId();
        short x$43 = epoch;
        int x$44 = 0;
        long x$45 = 0L;
        boolean x$46 = true;
        long x$47 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        AppendOrigin x$48 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$41, x$42, x$43, x$44, x$45, x$47, x$46, x$48);
        ProducerStateManager x$49 = this.stateManager();
        long x$50 = this.producerId();
        short x$51 = epoch;
        int x$52 = 1;
        long x$53 = 1L;
        boolean x$54 = true;
        long x$55 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        AppendOrigin x$56 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$49, x$50, x$51, x$52, x$53, x$55, x$54, x$56);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, bumpedEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short bumpedEpoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProducerStateManager x$57 = this.$outer.stateManager();
                long x$58 = this.$outer.producerId();
                short x$59 = this.bumpedEpoch$1;
                int x$60 = 2;
                long x$61 = 2L;
                boolean x$62 = true;
                long x$63 = this.$outer.kafka$log$ProducerStateManagerTest$$append$default$6();
                AppendOrigin x$64 = this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8();
                this.$outer.kafka$log$ProducerStateManagerTest$$append(x$57, x$58, x$59, x$60, x$61, x$63, x$62, x$64);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bumpedEpoch$1 = bumpedEpoch$1;
            }
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, bumpedEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short bumpedEpoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProducerStateManager x$65 = this.$outer.stateManager();
                long x$66 = this.$outer.producerId();
                short x$67 = (short)(this.bumpedEpoch$1 + 1);
                int x$68 = 2;
                long x$69 = 2L;
                boolean x$70 = true;
                long x$71 = this.$outer.kafka$log$ProducerStateManagerTest$$append$default$6();
                AppendOrigin x$72 = this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8();
                this.$outer.kafka$log$ProducerStateManagerTest$$append(x$65, x$66, x$67, x$68, x$69, x$71, x$70, x$72);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bumpedEpoch$1 = bumpedEpoch$1;
            }
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        ProducerStateManager x$73 = this.stateManager();
        long x$74 = this.producerId();
        short x$75 = bumpedEpoch;
        int x$76 = 0;
        long x$77 = 0L;
        boolean x$78 = true;
        long x$79 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        AppendOrigin x$80 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$73, x$74, x$75, x$76, x$77, x$79, x$78, x$80);
        Assert.assertEquals((long)bumpedEpoch, (long)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test(expected=InvalidTxnStateException.class)
    public void testNonTransactionalAppendWithOngoingTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$81 = this.stateManager();
        long x$82 = this.producerId();
        short x$83 = epoch;
        int x$84 = 0;
        long x$85 = 0L;
        boolean x$86 = true;
        long x$87 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        AppendOrigin x$88 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$81, x$82, x$83, x$84, x$85, x$87, x$86, x$88);
        ProducerStateManager x$89 = this.stateManager();
        long x$90 = this.producerId();
        short x$91 = epoch;
        int x$92 = 1;
        long x$93 = 1L;
        boolean x$94 = false;
        long x$95 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        AppendOrigin x$96 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$89, x$90, x$91, x$92, x$93, x$95, x$94, x$96);
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)this.stateManager().oldestSnapshotOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)3L)), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((String)"Directory doesn't contain a single file as expected", (long)1L, (long)this.logDir().list().length);
        Assert.assertTrue((String)"Snapshot file is empty", (((String)Predef$.MODULE$.refArrayOps((Object[])this.logDir().list()).head()).length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRecoverFromSnapshotUnfinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$97 = this.stateManager();
        long x$98 = this.producerId();
        short x$99 = epoch;
        int x$100 = 0;
        long x$101 = 0L;
        boolean x$102 = true;
        long x$103 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        AppendOrigin x$104 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$97, x$98, x$99, x$100, x$101, x$103, x$102, x$104);
        ProducerStateManager x$105 = this.stateManager();
        long x$106 = this.producerId();
        short x$107 = epoch;
        int x$108 = 1;
        long x$109 = 1L;
        boolean x$110 = true;
        long x$111 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        AppendOrigin x$112 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$105, x$106, x$107, x$108, x$109, x$111, x$110, x$112);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Option loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
        ProducerStateManager x$113 = recoveredMapping;
        long x$114 = this.producerId();
        short x$115 = epoch;
        int x$116 = 2;
        long x$117 = 2L;
        boolean x$118 = true;
        long x$119 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        AppendOrigin x$120 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$113, x$114, x$115, x$116, x$117, x$119, x$118, x$120);
    }

    @Test
    public void testRecoverFromSnapshotFinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$121 = this.stateManager();
        long x$122 = this.producerId();
        short x$123 = epoch;
        int x$124 = 0;
        long x$125 = 0L;
        boolean x$126 = true;
        long x$127 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        AppendOrigin x$128 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$121, x$122, x$123, x$124, x$125, x$127, x$126, x$128);
        ProducerStateManager x$129 = this.stateManager();
        long x$130 = this.producerId();
        short x$131 = epoch;
        int x$132 = 1;
        long x$133 = 1L;
        boolean x$134 = true;
        long x$135 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        AppendOrigin x$136 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$129, x$130, x$131, x$132, x$133, x$135, x$134, x$136);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.ABORT, 2L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Option loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assert.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testRecoverFromSnapshotEmptyTransaction() {
        short epoch = (short)0;
        long appendTimestamp = this.time().milliseconds();
        ProducerStateManager x$137 = this.stateManager();
        long x$138 = this.producerId();
        short x$139 = epoch;
        ControlRecordType x$140 = ControlRecordType.ABORT;
        long x$141 = 0L;
        long x$142 = appendTimestamp;
        int x$143 = this.appendEndTxnMarker$default$6();
        this.appendEndTxnMarker(x$137, x$138, x$139, x$140, x$141, x$143, x$142);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, this.time().milliseconds());
        Option lastEntry = recoveredMapping.lastEntry(this.producerId());
        Assert.assertTrue((boolean)lastEntry.isDefined());
        Assert.assertEquals((long)appendTimestamp, (long)((ProducerStateEntry)lastEntry.get()).lastTimestamp());
        Assert.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)lastEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testProducerStateAfterFencingAbortMarker() {
        short epoch = (short)0;
        ProducerStateManager x$144 = this.stateManager();
        long x$145 = this.producerId();
        short x$146 = epoch;
        int x$147 = 0;
        long x$148 = 0L;
        boolean x$149 = true;
        long x$150 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        AppendOrigin x$151 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$144, x$145, x$146, x$147, x$148, x$150, x$149, x$151);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)(epoch + 1), ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((long)-1L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)-1L, (long)lastEntry.firstDataOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test(expected=UnknownProducerIdException.class)
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.kafka$log$ProducerStateManagerTest$$append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assert.assertFalse((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateManager x$152 = recoveredMapping;
        long x$153 = this.producerId();
        short x$154 = epoch;
        int x$155 = sequence;
        long x$156 = 2L;
        long x$157 = 70001L;
        AppendOrigin.Replication$ x$158 = AppendOrigin.Replication$.MODULE$;
        boolean x$159 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
        this.kafka$log$ProducerStateManagerTest$$append(x$152, x$153, x$154, x$155, x$156, x$157, x$159, (AppendOrigin)x$158);
        Assert.assertTrue((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)Option$.MODULE$.option2Iterable(recoveredMapping.activeProducers().get((Object)BoxesRunTime.boxToLong((long)this.producerId()))).head();
        Assert.assertEquals((long)epoch, (long)producerStateEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)producerStateEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        int outOfOrderSequence = 3;
        try {
            ProducerStateManager x$160 = this.stateManager();
            long x$161 = this.producerId();
            short x$162 = epoch;
            int x$163 = outOfOrderSequence;
            long x$164 = 1L;
            long x$165 = 1L;
            AppendOrigin.Client$ x$166 = AppendOrigin.Client$.MODULE$;
            boolean x$167 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
            this.kafka$log$ProducerStateManagerTest$$append(x$160, x$161, x$162, x$163, x$164, x$165, x$167, (AppendOrigin)x$166);
            throw Assertions$.MODULE$.fail("Expected an OutOfOrderSequenceException to be raised.", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 540));
        }
        catch (Exception exception) {
            throw Assertions$.MODULE$.fail("Expected an OutOfOrderSequenceException to be raised.", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
        }
        catch (OutOfOrderSequenceException outOfOrderSequenceException) {
            Assert.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
            ProducerStateManager x$168 = this.stateManager();
            long x$169 = this.producerId();
            short x$170 = epoch;
            int x$171 = outOfOrderSequence;
            long x$172 = 1L;
            long x$173 = 1L;
            AppendOrigin.Replication$ x$174 = AppendOrigin.Replication$.MODULE$;
            boolean x$175 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
            this.kafka$log$ProducerStateManagerTest$$append(x$168, x$169, x$170, x$171, x$172, x$173, x$175, (AppendOrigin)x$174);
            Assert.assertEquals((long)outOfOrderSequence, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
            return;
        }
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
    }

    @Test
    public void testTruncate() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncate();
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$176 = this.stateManager();
        long x$177 = this.producerId();
        short x$178 = epoch;
        int x$179 = sequence;
        long x$180 = 99L;
        boolean x$181 = true;
        long x$182 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        AppendOrigin x$183 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$176, x$177, x$178, x$179, x$180, x$182, x$181, x$183);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$5) {
                return x$5.messageOffset();
            }
        }));
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$6) {
                return x$6.messageOffset();
            }
        }));
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$7) {
                return x$7.messageOffset();
            }
        }));
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$8) {
                return x$8.messageOffset();
            }
        }));
    }

    @Test
    public void testLoadFromSnapshotRetainsNonExpiredProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), pid1, epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), pid2, epoch, 0, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assert.assertEquals((long)2L, (long)this.stateManager().activeProducers().size());
        Option entry1 = this.stateManager().lastEntry(pid1);
        Assert.assertTrue((boolean)entry1.isDefined());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastSeq());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastDataOffset());
        Option entry2 = this.stateManager().lastEntry(pid2);
        Assert.assertTrue((boolean)entry2.isDefined());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)entry2.get()).lastSeq());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)entry2.get()).lastDataOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testStartOffset() {
        short epoch = (short)0;
        long pid2 = 2L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), pid2, epoch, 0, 0L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 1L, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 2L, 3L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 2, 3L, 4L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, epoch, pid2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short epoch$2;
            private final long pid2$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProducerStateManager recoveredMapping = new ProducerStateManager(this.$outer.partition(), this.$outer.logDir(), this.$outer.maxPidExpirationMs());
                recoveredMapping.truncateAndReload(0L, 1L, this.$outer.time().milliseconds());
                this.$outer.kafka$log$ProducerStateManagerTest$$append(recoveredMapping, this.pid2$1, this.epoch$2, 1, 4L, 5L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$2 = epoch$2;
                this.pid2$1 = pid2$1;
            }
        }, ClassTag$.MODULE$.apply(UnknownProducerIdException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 674));
    }

    @Test(expected=UnknownProducerIdException.class)
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, sequence + 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
    }

    @Test
    public void testFirstUnstableOffset() {
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$184 = this.stateManager();
        long x$185 = this.producerId();
        short x$186 = epoch;
        int x$187 = sequence;
        long x$188 = 99L;
        boolean x$189 = true;
        long x$190 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        AppendOrigin x$191 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$184, x$185, x$186, x$187, x$188, x$190, x$189, x$191);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$9) {
                return x$9.messageOffset();
            }
        }));
        long anotherPid = 2L;
        ProducerStateManager x$192 = this.stateManager();
        long x$193 = anotherPid;
        short x$194 = epoch;
        int x$195 = sequence;
        long x$196 = 105L;
        boolean x$197 = true;
        long x$198 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        AppendOrigin x$199 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$192, x$193, x$194, x$195, x$196, x$198, x$197, x$199);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$10) {
                return x$10.messageOffset();
            }
        }));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$11) {
                return x$11.messageOffset();
            }
        }));
        this.stateManager().onHighWatermarkUpdated(100L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$12) {
                return x$12.messageOffset();
            }
        }));
        this.stateManager().onHighWatermarkUpdated(110L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$13) {
                return x$13.messageOffset();
            }
        }));
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$14) {
                return x$14.messageOffset();
            }
        }));
        this.stateManager().onHighWatermarkUpdated(113L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$15) {
                return x$15.messageOffset();
            }
        }));
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$200 = this.stateManager();
        long x$201 = this.producerId();
        short x$202 = epoch;
        int x$203 = sequence;
        long x$204 = 99L;
        boolean x$205 = true;
        long x$206 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        AppendOrigin x$207 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$200, x$201, x$202, x$203, x$204, x$206, x$205, x$207);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxPidExpirationMs());
        short epoch = (short)0;
        ProducerStateManager x$208 = stateManager;
        long x$209 = this.producerId();
        short x$210 = epoch;
        int x$211 = -1;
        long x$212 = 99L;
        boolean x$213 = true;
        AppendOrigin.Coordinator$ x$214 = AppendOrigin.Coordinator$.MODULE$;
        long x$215 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        this.kafka$log$ProducerStateManagerTest$$append(x$208, x$209, x$210, x$211, x$212, x$215, x$213, (AppendOrigin)x$214);
        ProducerStateManager x$216 = stateManager;
        long x$217 = this.producerId();
        short x$218 = epoch;
        int x$219 = -1;
        long x$220 = 100L;
        boolean x$221 = true;
        AppendOrigin.Coordinator$ x$222 = AppendOrigin.Coordinator$.MODULE$;
        long x$223 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        this.kafka$log$ProducerStateManagerTest$$append(x$216, x$217, x$218, x$219, x$220, x$223, x$221, (AppendOrigin)x$222);
    }

    @Test(expected=ProducerFencedException.class)
    public void testOldEpochForControlRecord() {
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$224 = this.stateManager();
        long x$225 = this.producerId();
        short x$226 = epoch;
        int x$227 = sequence;
        long x$228 = 99L;
        boolean x$229 = true;
        long x$230 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        AppendOrigin x$231 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$224, x$225, x$226, x$227, x$228, x$230, x$229, x$231);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testCoordinatorFencing() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$232 = this.stateManager();
        long x$233 = this.producerId();
        short x$234 = epoch;
        int x$235 = sequence;
        long x$236 = 99L;
        boolean x$237 = true;
        long x$238 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        AppendOrigin x$239 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$232, x$233, x$234, x$235, x$236, x$238, x$237, x$239);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Option lastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)lastEntry.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(ProducerStateEntry x$16) {
                return x$16.coordinatorEpoch();
            }
        }));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        try {
            this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7());
            throw Assertions$.MODULE$.fail("Expected coordinator to be fenced", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 786));
        }
        catch (TransactionCoordinatorFencedException transactionCoordinatorFencedException) {
            return;
        }
    }

    @Test(expected=TransactionCoordinatorFencedException.class)
    public void testCoordinatorFencedAfterReload() {
        short producerEpoch = (short)0;
        ProducerStateManager x$240 = this.stateManager();
        long x$241 = this.producerId();
        short x$242 = producerEpoch;
        int x$243 = 0;
        long x$244 = 99L;
        boolean x$245 = true;
        long x$246 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        AppendOrigin x$247 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$240, x$241, x$242, x$243, x$244, x$246, x$245, x$247);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 2L, 70000L);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(FileChannel file) {
                file.truncate(0L);
            }
        });
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(FileChannel file) {
                Assert.assertTrue((file.size() > 2L ? 1 : 0) != 0);
                file.truncate(file.size() / 2L);
            }
        });
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(FileChannel file) {
                Assert.assertTrue((file.size() > 2L ? 1 : 0) != 0);
                file.write(ByteBuffer.wrap((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{37}), ClassTag$.MODULE$.Byte())), file.size() / 2L);
            }
        });
    }

    @Test
    public void testAppendEmptyControlBatch() {
        long producerId = 23423L;
        short producerEpoch = (short)145;
        int baseOffset = 15;
        RecordBatch batch = (RecordBatch)EasyMock.createMock(RecordBatch.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.expect((Object)batch.iterator()).andReturn(Collections.emptyIterator()).once();
        EasyMock.replay((Object[])new Object[]{batch});
        this.append(this.stateManager(), producerId, producerEpoch, baseOffset, batch, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Assert.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)this.stateManager().lastEntry(producerId).get()).currentTxnFirstOffset());
    }

    /*
     * WARNING - void declaration
     */
    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), producerId, epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), producerId, epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Option latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)latestSnapshotOffset);
        File snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)latestSnapshotOffset.get()));
        FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);
        try {
            makeFileCorrupt.apply((Object)channel);
        }
        catch (Throwable throwable) {
            void var7_6;
            var7_6.close();
            throw throwable;
        }
        channel.close();
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assert.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
        Assert.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Tuple2<CompletedTxn, Object> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        CompletedTxn completedTxn = producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp);
        mapping.update(producerAppendInfo);
        long lastStableOffset = mapping.lastStableOffset(completedTxn);
        mapping.completeTxn(completedTxn);
        mapping.updateMapEndOffset(offset + 1L);
        return new Tuple2((Object)completedTxn, (Object)BoxesRunTime.boxToLong((long)lastStableOffset));
    }

    public void kafka$log$ProducerStateManagerTest$$append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, timestamp, new LogOffsetMetadata(offset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, long offset, RecordBatch batch, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.append(batch, (Option)None$.MODULE$);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    public long kafka$log$ProducerStateManagerTest$$append$default$6() {
        return this.time().milliseconds();
    }

    public boolean kafka$log$ProducerStateManagerTest$$append$default$7() {
        return false;
    }

    public AppendOrigin kafka$log$ProducerStateManagerTest$$append$default$8() {
        return AppendOrigin.Client$.MODULE$;
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private Set<Object> currentSnapshotOffsets() {
        return Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFile(file);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).toSet();
    }

    private final void beginTxn$1(long producerId, long startOffset, short producerEpoch$2, long segmentBaseOffset$1) {
        int relativeOffset = (int)(startOffset - segmentBaseOffset$1);
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), producerId, ProducerStateEntry$.MODULE$.empty(producerId), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(startOffset, segmentBaseOffset$1, 50 * relativeOffset);
        producerAppendInfo.appendDataBatch(producerEpoch$2, 0, 0, this.time().milliseconds(), firstOffsetMetadata, startOffset, true);
        this.stateManager().update(producerAppendInfo);
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxPidExpirationMs = 60000;
    }
}

