/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import kafka.network.SocketServer;
import kafka.server.ApiVersionsRequestTest$;
import kafka.server.BaseRequestTest;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)<Q!\u0001\u0002\t\u0002\u001d\ta#\u00119j-\u0016\u00148/[8ogJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\t1\u0012\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u)\u0016\u001cHo\u0005\u0002\n\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aDQaE\u0005\u0005\u0002Q\ta\u0001P5oSRtD#A\u0004\t\u000bYIA\u0011A\f\u00027Y\fG.\u001b3bi\u0016\f\u0005/\u001b,feNLwN\\:SKN\u0004xN\\:f)\tA2\u0004\u0005\u0002\u000e3%\u0011!D\u0004\u0002\u0005+:LG\u000fC\u0003\u001d+\u0001\u0007Q$A\nba&4VM]:j_:\u001c(+Z:q_:\u001cX\r\u0005\u0002\u001fQ5\tqD\u0003\u0002!C\u0005A!/Z9vKN$8O\u0003\u0002#G\u000511m\\7n_:T!!\u0002\u0013\u000b\u0005\u00152\u0013AB1qC\u000eDWMC\u0001(\u0003\ry'oZ\u0005\u0003S}\u00111#\u00119j-\u0016\u00148/[8ogJ+7\u000f]8og\u00164AA\u0003\u0002\u0001WM\u0011!\u0006\f\t\u0003\u00115J!A\f\u0002\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgRDQa\u0005\u0016\u0005\u0002A\"\u0012!\r\t\u0003\u0011)BQa\r\u0016\u0005BQ\n1B\u0019:pW\u0016\u00148i\\;oiV\tQ\u0007\u0005\u0002\u000em%\u0011qG\u0004\u0002\u0004\u0013:$\b\"B\u001d+\t\u0003Q\u0014A\u0006;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;\u0015\u0003aA#\u0001\u000f\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}2\u0013!\u00026v]&$\u0018BA!?\u0005\u0011!Vm\u001d;\t\u000b\rSC\u0011\u0001\u001e\u0002YQ,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR<\u0016\u000e\u001e5V]N,\b\u000f]8si\u0016$g+\u001a:tS>t\u0007F\u0001\"=\u0011\u00151%\u0006\"\u0001;\u0003\t\"Xm\u001d;Ba&4VM]:j_:\u001c(+Z9vKN$h+\u00197jI\u0006$\u0018n\u001c8Wa!\u0012Q\t\u0010\u0005\u0006\u0013*\"\tAO\u0001#i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3tiZ\u000bG.\u001b3bi&|gNV\u001a)\u0005!c\u0004\"\u0002'+\t\u0013i\u0015AF:f]\u0012\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;\u0015\tuq5k\u0017\u0005\u0006\u001f.\u0003\r\u0001U\u0001\be\u0016\fX/Z:u!\tq\u0012+\u0003\u0002S?\t\u0011\u0012\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u\u0011\u001d!6\n%AA\u0002U\u000b!\"\u00199j-\u0016\u00148/[8o!\ria\u000bW\u0005\u0003/:\u0011aa\u00149uS>t\u0007CA\u0007Z\u0013\tQfBA\u0003TQ>\u0014H\u000fC\u0003]\u0017\u0002\u0007\u0001,A\bsKN\u0004xN\\:f-\u0016\u00148/[8o\u0011\u001dq&&%A\u0005\n}\u000b\u0001e]3oI\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\t\u0001M\u000b\u0002VC.\n!\r\u0005\u0002dQ6\tAM\u0003\u0002fM\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003O:\t!\"\u00198o_R\fG/[8o\u0013\tIGMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class ApiVersionsRequestTest
extends BaseRequestTest {
    public static void validateApiVersionsResponse(ApiVersionsResponse apiVersionsResponse) {
        ApiVersionsRequestTest$.MODULE$.validateApiVersionsResponse(apiVersionsResponse);
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    @Test
    public void testApiVersionsRequest() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, (Option<Object>)None$.MODULE$, request.version());
        ApiVersionsRequestTest$.MODULE$.validateApiVersionsResponse(apiVersionsResponse);
    }

    @Test
    public void testApiVersionsRequestWithUnsupportedVersion() {
        ApiVersionsRequest apiVersionsRequest = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)), (short)0);
        Assert.assertEquals((long)Errors.UNSUPPORTED_VERSION.code(), (long)apiVersionsResponse.data.errorCode());
        Assert.assertFalse((boolean)apiVersionsResponse.data.apiKeys().isEmpty());
        ApiVersionsResponseData.ApiVersionsResponseKey apiVersion = apiVersionsResponse.data.apiKeys().find(ApiKeys.API_VERSIONS.id);
        Assert.assertEquals((long)ApiKeys.API_VERSIONS.id, (long)apiVersion.apiKey());
        Assert.assertEquals((long)ApiKeys.API_VERSIONS.oldestVersion(), (long)apiVersion.minVersion());
        Assert.assertEquals((long)ApiKeys.API_VERSIONS.latestVersion(), (long)apiVersion.maxVersion());
    }

    @Test
    public void testApiVersionsRequestValidationV0() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)((short)0))), (short)0);
        ApiVersionsRequestTest$.MODULE$.validateApiVersionsResponse(apiVersionsResponse);
    }

    @Test
    public void testApiVersionsRequestValidationV3() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest(new ApiVersionsRequestData(), (short)3);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)((short)3))), (short)3);
        Assert.assertEquals((long)Errors.INVALID_REQUEST.code(), (long)apiVersionsResponse.data.errorCode());
    }

    private ApiVersionsResponse sendApiVersionsRequest(ApiVersionsRequest request, Option<Object> apiVersion, short responseVersion) {
        ApiVersionsRequest x$1 = request;
        ApiKeys x$2 = ApiKeys.API_VERSIONS;
        Option<Object> x$3 = apiVersion;
        SocketServer x$4 = this.connectAndSend$default$3();
        SecurityProtocol x$5 = this.connectAndSend$default$5();
        ByteBuffer response = this.connectAndSend((AbstractRequest)x$1, x$2, x$4, x$3, x$5);
        return ApiVersionsResponse.parse((ByteBuffer)response, (short)responseVersion);
    }

    private Option<Object> sendApiVersionsRequest$default$2() {
        return None$.MODULE$;
    }
}

