/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.network.SocketServer;
import kafka.server.BrokerShuttingDown$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.NotRunning$;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\tmb!B\u0001\u0003\u0003\u00039!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011aA1qS&\u0011QB\u0003\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0001\r\u0011\"\u0003\u0016\u00035\u0019wN\u001d:fY\u0006$\u0018n\u001c8JIV\ta\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0002J]RDq!\b\u0001A\u0002\u0013%a$A\td_J\u0014X\r\\1uS>t\u0017\nZ0%KF$\"a\b\u0012\u0011\u0005]\u0001\u0013BA\u0011\u0019\u0005\u0011)f.\u001b;\t\u000f\rb\u0012\u0011!a\u0001-\u0005\u0019\u0001\u0010J\u0019\t\r\u0015\u0002\u0001\u0015)\u0003\u0017\u00039\u0019wN\u001d:fY\u0006$\u0018n\u001c8JI\u0002BQa\n\u0001\u0005BU\t1B\u0019:pW\u0016\u00148i\\;oi\")\u0011\u0006\u0001C\tU\u00059\"M]8lKJ\u0004&o\u001c9feRLxJ^3se&$Wm\u001d\u000b\u0003?-BQ\u0001\f\u0015A\u00025\n!\u0002\u001d:pa\u0016\u0014H/[3t!\tq3'D\u00010\u0015\t\u0001\u0014'\u0001\u0003vi&d'\"\u0001\u001a\u0002\t)\fg/Y\u0005\u0003i=\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u00151\u0004\u0001\"\u00118\u00035iw\u000eZ5gs\u000e{gNZ5hgR\u0011q\u0004\u000f\u0005\u0006sU\u0002\rAO\u0001\u0006aJ|\u0007o\u001d\t\u0004wyjS\"\u0001\u001f\u000b\u0005uB\u0012AC2pY2,7\r^5p]&\u0011q\b\u0010\u0002\u0004'\u0016\f\b\"B!\u0001\t\u0003\u0011\u0015aD1osN{7m[3u'\u0016\u0014h/\u001a:\u0016\u0003\r\u0003\"\u0001R$\u000e\u0003\u0015S!A\u0012\u0003\u0002\u000f9,Go^8sW&\u0011\u0001*\u0012\u0002\r'>\u001c7.\u001a;TKJ4XM\u001d\u0005\u0006\u0015\u0002!\tAQ\u0001\u0017G>tGO]8mY\u0016\u00148k\\2lKR\u001cVM\u001d<fe\")A\n\u0001C\u0001\u0005\u0006Ibn\u001c;D_:$(o\u001c7mKJ\u001cvnY6fiN+'O^3s\u0011\u0015q\u0005\u0001\"\u0001P\u0003I\u0011'o\\6feN{7m[3u'\u0016\u0014h/\u001a:\u0015\u0005\r\u0003\u0006\"B)N\u0001\u00041\u0012\u0001\u00032s_.,'/\u00133\t\u000bM\u0003A\u0011\u0001+\u0002\u000f\r|gN\\3diR\u0019QkW/\u0011\u0005YKV\"A,\u000b\u0005a\u000b\u0014a\u00018fi&\u0011!l\u0016\u0002\u0007'>\u001c7.\u001a;\t\u000fq\u0013\u0006\u0013!a\u0001\u0007\u0006\t1\u000fC\u0004_%B\u0005\t\u0019A0\u0002\u0011A\u0014x\u000e^8d_2\u0004\"\u0001\u00197\u000e\u0003\u0005T!AY2\u0002\t\u0005,H\u000f\u001b\u0006\u0003I\u0016\f\u0001b]3dkJLG/\u001f\u0006\u0003M\u001e\faaY8n[>t'BA\u0003i\u0015\tI'.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0006\u0019qN]4\n\u00055\f'\u0001E*fGV\u0014\u0018\u000e^=Qe>$xnY8m\u0011\u0015y\u0007\u0001\"\u0003q\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0015\u0007}\t8\u000fC\u0003s]\u0002\u0007Q+\u0001\u0004t_\u000e\\W\r\u001e\u0005\u0006i:\u0004\r!^\u0001\be\u0016\fX/Z:u!\r9b\u000f_\u0005\u0003ob\u0011Q!\u0011:sCf\u0004\"aF=\n\u0005iD\"\u0001\u0002\"zi\u0016DQ\u0001 \u0001\u0005\nu\fqB]3dK&4XMU3ta>t7/\u001a\u000b\u0003kzDQA]>A\u0002UCq!!\u0001\u0001\t\u0003\t\u0019!A\tsKF,Xm\u001d;B]\u0012\u0014VmY3jm\u0016$R!^A\u0003\u0003\u000fAQA]@A\u0002UCQ\u0001^@A\u0002UDq!a\u0003\u0001\t\u0003\ti!\u0001\bd_:tWm\u0019;B]\u0012\u001cVM\u001c3\u0015\u0019\u0005=\u00111DA\u0015\u0003o\tY$a\u0013\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u00062\u0003\rq\u0017n\\\u0005\u0005\u00033\t\u0019B\u0001\u0006CsR,')\u001e4gKJDq\u0001^A\u0005\u0001\u0004\ti\u0002\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019#Z\u0001\te\u0016\fX/Z:ug&!\u0011qEA\u0011\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\b\u0002CA\u0016\u0003\u0013\u0001\r!!\f\u0002\r\u0005\u0004\u0018nS3z!\u0011\ty#a\r\u000e\u0005\u0005E\"B\u00010f\u0013\u0011\t)$!\r\u0003\u000f\u0005\u0003\u0018nS3zg\"I\u0011\u0011HA\u0005!\u0003\u0005\raQ\u0001\fI\u0016\u001cH/\u001b8bi&|g\u000e\u0003\u0006\u0002>\u0005%\u0001\u0013!a\u0001\u0003\u007f\t!\"\u00199j-\u0016\u00148/[8o!\u00159\u0012\u0011IA#\u0013\r\t\u0019\u0005\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007]\t9%C\u0002\u0002Ja\u0011Qa\u00155peRD\u0001BXA\u0005!\u0003\u0005\ra\u0018\u0005\b\u0003\u001f\u0002A\u0011AA)\u0003Q\u0019wN\u001c8fGR\fe\u000eZ*f]\u0012\u001cFO];diRa\u0011qBA*\u0003G\n)'a\u001a\u0002j!A\u0011QKA'\u0001\u0004\t9&A\u0007sKF,Xm\u001d;TiJ,8\r\u001e\t\u0005\u00033\ny&\u0004\u0002\u0002\\)!\u0011QLA\u0019\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\t'a\u0017\u0003\rM#(/^2u\u0011!\tY#!\u0014A\u0002\u00055\u0002\u0002CA\u001f\u0003\u001b\u0002\r!!\u0012\t\u0013\u0005e\u0012Q\nI\u0001\u0002\u0004\u0019\u0005\u0002\u00030\u0002NA\u0005\t\u0019A0\t\u000f\u00055\u0004\u0001\"\u0001\u0002p\u0005!1/\u001a8e)%y\u0012\u0011OA:\u0003k\n9\bC\u0004u\u0003W\u0002\r!!\b\t\u0011\u0005-\u00121\u000ea\u0001\u0003[AaA]A6\u0001\u0004)\u0006\u0002CA\u001f\u0003W\u0002\r!!\u0012\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~\u00059!/Z2fSZ,GCBA\b\u0003\u007f\n\t\t\u0003\u0004s\u0003s\u0002\r!\u0016\u0005\t\u0003\u0007\u000bI\b1\u0001\u0002F\u0005)\"/Z:q_:\u001cX\rS3bI\u0016\u0014h+\u001a:tS>t\u0007bBAD\u0001\u0011\u0005\u0011\u0011R\u0001\u000fg\u0016tG-\u00118e%\u0016\u001cW-\u001b<f))\ty!a#\u0002\u000e\u0006=\u0015\u0011\u0013\u0005\bi\u0006\u0015\u0005\u0019AA\u000f\u0011!\tY#!\"A\u0002\u00055\u0002B\u0002:\u0002\u0006\u0002\u0007Q\u000b\u0003\u0006\u0002>\u0005\u0015\u0005\u0013!a\u0001\u0003\u007fAq!!&\u0001\t\u0003\t9*A\bsKF,Xm\u001d;SKN\u0004xN\\:f))\t9&!'\u0002\u001c\u00065\u0016q\u0016\u0005\u0007e\u0006M\u0005\u0019A+\t\u0011\u0005u\u00151\u0013a\u0001\u0003?\u000b\u0001b\u00197jK:$\u0018\n\u001a\t\u0005\u0003C\u000b9KD\u0002\u0018\u0003GK1!!*\u0019\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011VAV\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0015\r\t\rQ\t\u0019\n1\u0001\u0017\u0011!\t\t,a%A\u0002\u0005M\u0016A\u0004:fcV,7\u000f\u001e\"vS2$WM\u001d\u0019\u0005\u0003k\u000b9\r\u0005\u0004\u00028\u0006u\u00161\u0019\b\u0005\u0003?\tI,\u0003\u0003\u0002<\u0006\u0005\u0012aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\n\t\u0005}\u0016\u0011\u0019\u0002\b\u0005VLG\u000eZ3s\u0015\u0011\tY,!\t\u0011\t\u0005\u0015\u0017q\u0019\u0007\u0001\t1\tI-a,\u0002\u0002\u0003\u0005)\u0011AAf\u0005\ryF%M\t\u0005\u0003\u001b\fi\u0002E\u0002\u0018\u0003\u001fL1!!5\u0019\u0005\u001dqu\u000e\u001e5j]\u001eDq!!6\u0001\t\u0003\t9.\u0001\u000btK:$7\u000b\u001e:vGR\fe\u000e\u001a*fG\u0016Lg/\u001a\u000b\u000b\u0003\u001f\tI.a7\u0002^\u0006}\u0007\u0002CA+\u0003'\u0004\r!a\u0016\t\u0011\u0005-\u00121\u001ba\u0001\u0003[AaA]Aj\u0001\u0004)\u0006\u0002CA\u001f\u0003'\u0004\r!!\u0012\t\u000f\u0005\r\b\u0001\"\u0005\u0002f\u0006\u00112o[5q%\u0016\u001c\bo\u001c8tK\"+\u0017\rZ3s)\u0019\ty!a:\u0002l\"9\u0011\u0011^Aq\u0001\u0004)\u0018\u0001\u0003:fgB|gn]3\t\u0011\u0005\r\u0015\u0011\u001da\u0001\u0003\u000bBq!a<\u0001\t\u0003\t\t0A\toKb$(+Z9vKN$\b*Z1eKJ$b!a=\u0002z\u0006m\b\u0003BA\u0010\u0003kLA!a>\u0002\"\ti!+Z9vKN$\b*Z1eKJD\u0001\"a\u000b\u0002n\u0002\u0007\u0011Q\u0006\u0005\t\u0003{\ti\u000f1\u0001\u0002F!I\u0011q \u0001\u0012\u0002\u0013\u0005!\u0011A\u0001\u0019G>tg.Z2u\u0003:$7+\u001a8eI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u0002U\r\u0019%QA\u0016\u0003\u0005\u000f\u0001BA!\u0003\u0003\u00145\u0011!1\u0002\u0006\u0005\u0005\u001b\u0011y!A\u0005v]\u000eDWmY6fI*\u0019!\u0011\u0003\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0016\t-!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!\u0011\u0004\u0001\u0012\u0002\u0013\u0005!1D\u0001\u0019G>tg.Z2u\u0003:$7+\u001a8eI\u0011,g-Y;mi\u0012\"TC\u0001B\u000fU\u0011\tyD!\u0002\t\u0013\t\u0005\u0002!%A\u0005\u0002\t\r\u0012\u0001G2p]:,7\r^!oIN+g\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!Q\u0005\u0016\u0004?\n\u0015\u0001\"\u0003B\u0015\u0001E\u0005I\u0011\u0001B\u0001\u0003E\u0019wN\u001c8fGR$C-\u001a4bk2$H%\r\u0005\n\u0005[\u0001\u0011\u0013!C\u0001\u0005G\t\u0011cY8o]\u0016\u001cG\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0011%\u0011\t\u0004AI\u0001\n\u0003\u0011Y\"\u0001\rtK:$\u0017I\u001c3SK\u000e,\u0017N^3%I\u00164\u0017-\u001e7uIQB\u0011B!\u000e\u0001#\u0003%\tA!\u0001\u0002=\r|gN\\3di\u0006sGmU3oIN#(/^2uI\u0011,g-Y;mi\u0012\"\u0004\"\u0003B\u001d\u0001E\u0005I\u0011\u0001B\u0012\u0003y\u0019wN\u001c8fGR\fe\u000eZ*f]\u0012\u001cFO];di\u0012\"WMZ1vYR$S\u0007")
public abstract class BaseRequestTest
extends IntegrationTestHarness {
    private int correlationId = 0;

    private int correlationId() {
        return this.correlationId;
    }

    private void correlationId_$eq(int x$1) {
        this.correlationId = x$1;
    }

    @Override
    public int brokerCount() {
        return 3;
    }

    public void brokerPropertyOverrides(Properties properties) {
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseRequestTest $outer;

            public final void apply(Properties p) {
                p.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
                this.$outer.brokerPropertyOverrides(p);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public SocketServer anySocketServer() {
        return (SocketServer)this.servers().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer server) {
                byte state = server.brokerState().currentState();
                return state != NotRunning$.MODULE$.state() && state != BrokerShuttingDown$.MODULE$.state();
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SocketServer apply(KafkaServer x$1) {
                return x$1.socketServer();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("No live broker is available");
            }
        });
    }

    public SocketServer controllerSocketServer() {
        return (SocketServer)this.servers().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer server) {
                return server.kafkaController().isActive();
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SocketServer apply(KafkaServer x$2) {
                return x$2.socketServer();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("No controller broker is available");
            }
        });
    }

    public SocketServer notControllerSocketServer() {
        return (SocketServer)this.servers().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer server) {
                return !server.kafkaController().isActive();
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SocketServer apply(KafkaServer x$3) {
                return x$3.socketServer();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("No non-controller broker is available");
            }
        });
    }

    public SocketServer brokerSocketServer(int brokerId) {
        return (SocketServer)this.servers().find((Function1)new Serializable(this, brokerId){
            public static final long serialVersionUID = 0L;
            private final int brokerId$1;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.brokerId$1;
            }
            {
                this.brokerId$1 = brokerId$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SocketServer apply(KafkaServer x$4) {
                return x$4.socketServer();
            }
        }).getOrElse((Function0)new Serializable(this, brokerId){
            public static final long serialVersionUID = 0L;
            private final int brokerId$1;

            public final Nothing$ apply() {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find broker with id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.brokerId$1)})));
            }
            {
                this.brokerId$1 = brokerId$1;
            }
        });
    }

    public Socket connect(SocketServer s, SecurityProtocol protocol) {
        return new Socket("localhost", s.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)protocol)));
    }

    public SocketServer connect$default$1() {
        return this.anySocketServer();
    }

    public SecurityProtocol connect$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    private void sendRequest(Socket socket, byte[] request) {
        DataOutputStream outgoing = new DataOutputStream(socket.getOutputStream());
        outgoing.writeInt(request.length);
        outgoing.write(request);
        outgoing.flush();
    }

    private byte[] receiveResponse(Socket socket) {
        DataInputStream incoming = new DataInputStream(socket.getInputStream());
        int len = incoming.readInt();
        byte[] response = new byte[len];
        incoming.readFully(response);
        return response;
    }

    public byte[] requestAndReceive(Socket socket, byte[] request) {
        this.sendRequest(socket, request);
        return this.receiveResponse(socket);
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer connectAndSend(AbstractRequest request, ApiKeys apiKey, SocketServer destination, Option<Object> apiVersion, SecurityProtocol protocol) {
        ByteBuffer byteBuffer;
        Socket socket = this.connect(destination, protocol);
        try {
            byteBuffer = this.sendAndReceive(request, apiKey, socket, apiVersion);
        }
        catch (Throwable throwable) {
            void var6_6;
            var6_6.close();
            throw throwable;
        }
        socket.close();
        return byteBuffer;
    }

    public SocketServer connectAndSend$default$3() {
        return this.anySocketServer();
    }

    public Option<Object> connectAndSend$default$4() {
        return None$.MODULE$;
    }

    public SecurityProtocol connectAndSend$default$5() {
        return SecurityProtocol.PLAINTEXT;
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer connectAndSendStruct(Struct requestStruct, ApiKeys apiKey, short apiVersion, SocketServer destination, SecurityProtocol protocol) {
        ByteBuffer byteBuffer;
        Socket socket = this.connect(destination, protocol);
        try {
            byteBuffer = this.sendStructAndReceive(requestStruct, apiKey, socket, apiVersion);
        }
        catch (Throwable throwable) {
            void var6_6;
            var6_6.close();
            throw throwable;
        }
        socket.close();
        return byteBuffer;
    }

    public SocketServer connectAndSendStruct$default$4() {
        return this.anySocketServer();
    }

    public SecurityProtocol connectAndSendStruct$default$5() {
        return SecurityProtocol.PLAINTEXT;
    }

    public void send(AbstractRequest request, ApiKeys apiKey, Socket socket, short apiVersion) {
        RequestHeader header = this.nextRequestHeader(apiKey, apiVersion);
        byte[] serializedBytes = request.serialize(header).array();
        this.sendRequest(socket, serializedBytes);
    }

    public ByteBuffer receive(Socket socket, short responseHeaderVersion) {
        byte[] response = this.receiveResponse(socket);
        return this.skipResponseHeader(response, responseHeaderVersion);
    }

    public ByteBuffer sendAndReceive(AbstractRequest request, ApiKeys apiKey, Socket socket, Option<Object> apiVersion) {
        short version = BoxesRunTime.unboxToShort((Object)apiVersion.getOrElse((Function0)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final AbstractRequest request$1;

            public final short apply() {
                return this.apply$mcS$sp();
            }

            public short apply$mcS$sp() {
                return this.request$1.version();
            }
            {
                this.request$1 = request$1;
            }
        }));
        this.send(request, apiKey, socket, version);
        byte[] response = this.receiveResponse(socket);
        return this.skipResponseHeader(response, apiKey.responseHeaderVersion(version));
    }

    public Option<Object> sendAndReceive$default$4() {
        return None$.MODULE$;
    }

    public Struct requestResponse(Socket socket, String clientId, int correlationId, AbstractRequest.Builder<? extends AbstractRequest> requestBuilder) {
        ApiKeys apiKey = requestBuilder.apiKey();
        AbstractRequest request = requestBuilder.build();
        RequestHeader header = new RequestHeader(apiKey, request.version(), clientId, correlationId);
        byte[] response = this.requestAndReceive(socket, request.serialize(header).array());
        ByteBuffer responseBuffer = this.skipResponseHeader(response, apiKey.responseHeaderVersion(request.version()));
        return apiKey.parseResponse(request.version(), responseBuffer);
    }

    public ByteBuffer sendStructAndReceive(Struct requestStruct, ApiKeys apiKey, Socket socket, short apiVersion) {
        RequestHeader header = this.nextRequestHeader(apiKey, apiVersion);
        byte[] serializedBytes = RequestUtils.serialize((Struct)header.toStruct(), (Struct)requestStruct).array();
        byte[] response = this.requestAndReceive(socket, serializedBytes);
        return this.skipResponseHeader(response, apiKey.responseHeaderVersion(apiVersion));
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer skipResponseHeader(byte[] response, short responseHeaderVersion) {
        void var3_3;
        ByteBuffer responseBuffer = ByteBuffer.wrap(response);
        ResponseHeader.parse((ByteBuffer)responseBuffer, (short)responseHeaderVersion);
        return var3_3;
    }

    public RequestHeader nextRequestHeader(ApiKeys apiKey, short apiVersion) {
        this.correlationId_$eq(this.correlationId() + 1);
        return new RequestHeader(apiKey, apiVersion, "client-id", this.correlationId());
    }
}

