/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaType;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tUh\u0001B\u0001\u0003\u0001\u001d\u0011ac\u00117jK:$\u0018+^8uC6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%I!F\u0001\u0005i&lW-F\u0001\u0017!\t9\u0012%D\u0001\u0019\u0015\tI\"$A\u0003vi&d7O\u0003\u0002\u001c9\u000511m\\7n_:T!!B\u000f\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0005\u0003Ea\u0011\u0001\"T8dWRKW.\u001a\u0005\u0007I\u0001\u0001\u000b\u0011\u0002\f\u0002\u000bQLW.\u001a\u0011\t\u000f\u0019\u0002!\u0019!C\u0005O\u00059Q.\u001a;sS\u000e\u001cX#\u0001\u0015\u0011\u0005%ZS\"\u0001\u0016\u000b\u0005\u0019R\u0012B\u0001\u0017+\u0005\u001diU\r\u001e:jGNDaA\f\u0001!\u0002\u0013A\u0013\u0001C7fiJL7m\u001d\u0011\t\u000fA\u0002!\u0019!C\u0005c\u000511m\u001c8gS\u001e,\u0012A\r\t\u0003%MJ!\u0001\u000e\u0002\u00031\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\"p]\u001aLw\r\u0003\u00047\u0001\u0001\u0006IAM\u0001\bG>tg-[4!\u0011\u001dA\u0004\u00011A\u0005\u0002e\nAB\\;n\u0007\u0006dGNY1dWN,\u0012A\u000f\t\u0003\u0013mJ!\u0001\u0010\u0006\u0003\u0007%sG\u000fC\u0004?\u0001\u0001\u0007I\u0011A \u0002!9,XnQ1mY\n\f7m[:`I\u0015\fHC\u0001!D!\tI\u0011)\u0003\u0002C\u0015\t!QK\\5u\u0011\u001d!U(!AA\u0002i\n1\u0001\u001f\u00132\u0011\u00191\u0005\u0001)Q\u0005u\u0005ia.^7DC2d'-Y2lg\u0002BQ\u0001\u0013\u0001\u0005\u0002%\u000b\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002\u0001\"\u0012qi\u0013\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d~\tQA[;oSRL!\u0001U'\u0003\u000b\u00053G/\u001a:\t\u000bI\u0003A\u0011A*\u0002\u0011\r\fG\u000e\u001c2bG.$\"\u0001\u0011+\t\u000bU\u000b\u0006\u0019\u0001,\u0002\u0011I,7\u000f]8og\u0016\u0004\"aV/\u000f\u0005a[V\"A-\u000b\u0005i#\u0011a\u00028fi^|'o[\u0005\u00039f\u000baBU3rk\u0016\u001cHo\u00115b]:,G.\u0003\u0002_?\nA!+Z:q_:\u001cXM\u0003\u0002]3\")\u0011\r\u0001C\u0005E\u0006a!-^5mIJ+\u0017/^3tiV\u00111-\u001b\u000b\u0005Ib\f\u0019\u0001\u0005\u0003\nK\u001e,\u0018B\u00014\u000b\u0005\u0019!V\u000f\u001d7feA\u0011\u0001.\u001b\u0007\u0001\t\u0015Q\u0007M1\u0001l\u0005\u0005!\u0016C\u00017p!\tIQ.\u0003\u0002o\u0015\t9aj\u001c;iS:<\u0007C\u00019t\u001b\u0005\t(B\u0001:\u001b\u0003!\u0011X-];fgR\u001c\u0018B\u0001;r\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\bCA,w\u0013\t9xLA\u0004SKF,Xm\u001d;\t\u000be\u0004\u0007\u0019\u0001>\u0002\u000f\t,\u0018\u000e\u001c3feB\u00191P`4\u000f\u0005Ad\u0018BA?r\u0003=\t%m\u001d;sC\u000e$(+Z9vKN$\u0018bA@\u0002\u0002\t9!)^5mI\u0016\u0014(BA?r\u0011%\t)\u0001\u0019I\u0001\u0002\u0004\t9!\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0005\u0003\u0002\n\u00055QBAA\u0006\u0015\tQ&$\u0003\u0003\u0002\u0010\u0005-!\u0001\u0004'jgR,g.\u001a:OC6,\u0007bBA\n\u0001\u0011%\u0011QC\u0001\f[\u0006L(-\u001a*fG>\u0014H\rF\u0005;\u0003/\t\t#a\r\u00028!A\u0011\u0011DA\t\u0001\u0004\tY\"\u0001\u0007rk>$\u0018-T1oC\u001e,'\u000fE\u0002\u0013\u0003;I1!a\b\u0003\u0005I\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:\t\u0011\u0005\r\u0012\u0011\u0003a\u0001\u0003K\tA!^:feB!\u0011qEA\u0017\u001d\rI\u0011\u0011F\u0005\u0004\u0003WQ\u0011A\u0002)sK\u0012,g-\u0003\u0003\u00020\u0005E\"AB*ue&twMC\u0002\u0002,)A\u0001\"!\u000e\u0002\u0012\u0001\u0007\u0011QE\u0001\tG2LWM\u001c;JI\"A\u0011\u0011HA\t\u0001\u0004\tY$A\u0003wC2,X\rE\u0002\n\u0003{I1!a\u0010\u000b\u0005\u0019!u.\u001e2mK\"9\u00111\t\u0001\u0005\n\u0005\u0015\u0013\u0001\u0003;ie>$H\u000f\\3\u0015\u0017\u0001\u000b9%!\u0013\u0002L\u00055\u0013\u0011\u000b\u0005\t\u00033\t\t\u00051\u0001\u0002\u001c!A\u00111EA!\u0001\u0004\t)\u0003\u0003\u0005\u00026\u0005\u0005\u0003\u0019AA\u0013\u0011\u001d\ty%!\u0011A\u0002i\na\u0002\u001e5s_R$H.\u001a+j[\u0016l5\u000f\u0003\u0005\u0002T\u0005\u0005\u0003\u0019AA+\u0003e\u0019\u0007.\u00198oK2$\u0006N]8ui2LgnZ\"bY2\u0014\u0017mY6\u0011\u000b%\t9F\u0016!\n\u0007\u0005e#BA\u0005Gk:\u001cG/[8oc!9\u0011Q\f\u0001\u0005\n\u0005}\u0013\u0001\u0005;fgR\fVo\u001c;b!\u0006\u00148/\u001b8h)-\u0001\u0015\u0011MA2\u0005\u0013\u0012iE!\u0015\t\rA\nY\u00061\u00013\u0011!\t)'a\u0017A\u0002\u0005\u001d\u0014aB2mS\u0016tG/\r\t\u0005\u0003S\nY'D\u0001\u0001\r\u0019\ti\u0007\u0001#\u0002p\tQQk]3s\u00072LWM\u001c;\u0014\u000f\u0005-\u0004\"!\u001d\u0002xA\u0019\u0011\"a\u001d\n\u0007\u0005U$BA\u0004Qe>$Wo\u0019;\u0011\u0007%\tI(C\u0002\u0002|)\u0011AbU3sS\u0006d\u0017N_1cY\u0016D1\"a\t\u0002l\tU\r\u0011\"\u0001\u0002\u0000U\u0011\u0011Q\u0005\u0005\f\u0003\u0007\u000bYG!E!\u0002\u0013\t)#A\u0003vg\u0016\u0014\b\u0005C\u0006\u00026\u0005-$Q3A\u0005\u0002\u0005}\u0004bCAE\u0003W\u0012\t\u0012)A\u0005\u0003K\t\u0011b\u00197jK:$\u0018\n\u001a\u0011\t\u0017\u00055\u00151\u000eBK\u0002\u0013\u0005\u0011qR\u0001\u000bG>tg-[4Vg\u0016\u0014XCAAI!\u0015I\u00111SA\u0013\u0013\r\t)J\u0003\u0002\u0007\u001fB$\u0018n\u001c8\t\u0017\u0005e\u00151\u000eB\tB\u0003%\u0011\u0011S\u0001\fG>tg-[4Vg\u0016\u0014\b\u0005C\u0006\u0002\u001e\u0006-$Q3A\u0005\u0002\u0005=\u0015AD2p]\u001aLwm\u00117jK:$\u0018\n\u001a\u0005\f\u0003C\u000bYG!E!\u0002\u0013\t\t*A\bd_:4\u0017nZ\"mS\u0016tG/\u00133!\u0011\u001dy\u00111\u000eC\u0001\u0003K#\"\"a\u001a\u0002(\u0006%\u00161VAW\u0011!\t\u0019#a)A\u0002\u0005\u0015\u0002\u0002CA\u001b\u0003G\u0003\r!!\n\t\u0015\u00055\u00151\u0015I\u0001\u0002\u0004\t\t\n\u0003\u0006\u0002\u001e\u0006\r\u0006\u0013!a\u0001\u0003#C\u0001\"!-\u0002l\u0011\u0005\u00111W\u0001\u0018g\u0006t\u0017\u000e^5{K\u0012\u001cuN\u001c4jO\u000ec\u0017.\u001a8u\u0013\u0012,\"!!.\u0011\u000b%\t\u0019*a.\u0011\t\u0005e\u00161Y\u0007\u0003\u0003wSA!!0\u0002@\u0006!A.\u00198h\u0015\t\t\t-\u0001\u0003kCZ\f\u0017\u0002BA\u0018\u0003wC!\"a2\u0002l\u0005\u0005I\u0011AAe\u0003\u0011\u0019w\u000e]=\u0015\u0015\u0005\u001d\u00141ZAg\u0003\u001f\f\t\u000e\u0003\u0006\u0002$\u0005\u0015\u0007\u0013!a\u0001\u0003KA!\"!\u000e\u0002FB\u0005\t\u0019AA\u0013\u0011)\ti)!2\u0011\u0002\u0003\u0007\u0011\u0011\u0013\u0005\u000b\u0003;\u000b)\r%AA\u0002\u0005E\u0005BCAk\u0003W\n\n\u0011\"\u0001\u0002X\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAmU\u0011\t)#a7,\u0005\u0005u\u0007\u0003BAp\u0003Sl!!!9\u000b\t\u0005\r\u0018Q]\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a:\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\f\tOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!\"a<\u0002lE\u0005I\u0011AAl\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB!\"a=\u0002lE\u0005I\u0011AA{\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a>+\t\u0005E\u00151\u001c\u0005\u000b\u0003w\fY'%A\u0005\u0002\u0005U\u0018AD2paf$C-\u001a4bk2$H\u0005\u000e\u0005\u000b\u0003\u007f\fY'!A\u0005B\t\u0005\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u00028\"I!QAA6\u0003\u0003%\t!O\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\u000b\u0005\u0013\tY'!A\u0005\u0002\t-\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u001b\u0011\u0019\u0002E\u0002\n\u0005\u001fI1A!\u0005\u000b\u0005\r\te.\u001f\u0005\t\t\n\u001d\u0011\u0011!a\u0001u!Q!qCA6\u0003\u0003%\tE!\u0007\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0007\u0011\r\tu!1\u0005B\u0007\u001b\t\u0011yBC\u0002\u0003\")\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)Ca\b\u0003\u0011%#XM]1u_JD!B!\u000b\u0002l\u0005\u0005I\u0011\u0001B\u0016\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\u0017\u0005g\u00012!\u0003B\u0018\u0013\r\u0011\tD\u0003\u0002\b\u0005>|G.Z1o\u0011%!%qEA\u0001\u0002\u0004\u0011i\u0001\u0003\u0006\u00038\u0005-\u0014\u0011!C!\u0005s\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002u!Q!QHA6\u0003\u0003%\tEa\u0010\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a.\t\u0015\t\r\u00131NA\u0001\n\u0003\u0012)%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005[\u00119\u0005C\u0005E\u0005\u0003\n\t\u00111\u0001\u0003\u000e!A!1JA.\u0001\u0004\t9'A\u0004dY&,g\u000e\u001e\u001a\t\u0011\t=\u00131\fa\u0001\u0003O\nAB]1oI>l7\t\\5f]RD\u0001Ba\u0015\u0002\\\u0001\u0007\u0011qM\u0001\u0014I\u00164\u0017-\u001e7u\u0007>tg-[4DY&,g\u000e\u001e\u0005\u0007\u0005/\u0002A\u0011A%\u00021Q,7\u000f^\"mS\u0016tG/\u00133Rk>$\u0018\rU1sg&tw\r\u000b\u0003\u0003V\tm\u0003c\u0001'\u0003^%\u0019!qL'\u0003\tQ+7\u000f\u001e\u0005\u0007\u0005G\u0002A\u0011A%\u0002)Q,7\u000f^+tKJ\fVo\u001c;b!\u0006\u00148/\u001b8hQ\u0011\u0011\tGa\u0017\t\r\t%\u0004\u0001\"\u0001J\u0003q!Xm\u001d;Vg\u0016\u00148\t\\5f]RLE-U;pi\u0006\u0004\u0016M]:j]\u001eDCAa\u001a\u0003\\!1!q\u000e\u0001\u0005\u0002%\u000bA\u0006^3tiV\u001bXM])v_R\f\u0007+\u0019:tS:<w+\u001b;i\t\u00164\u0017-\u001e7u\u00072LWM\u001c;JIF+x\u000e^1)\t\t5$1\f\u0005\u0007\u0005k\u0002A\u0011A%\u0002iQ,7\u000f^+tKJ\u001cE.[3oiF+x\u000e^1QCJ\u001c\u0018N\\4JI^KG\u000f\u001b#fM\u0006,H\u000e^\"mS\u0016tG/\u00133Rk>$\u0018\r\u000b\u0003\u0003t\tm\u0003B\u0002B>\u0001\u0011\u0005\u0011*A\ruKN$\u0018+^8uC\u000e{gNZ5h!J,7-\u001a3f]\u000e,\u0007\u0006\u0002B=\u00057BaA!!\u0001\t\u0003I\u0015A\u0005;fgR\fVo\u001c;b-&|G.\u0019;j_:DCAa \u0003\\!1!q\u0011\u0001\u0005\u0002%\u000b1\u0005^3tiJ+\u0017/^3tiB+'oY3oi\u0006<W-U;pi\u00064\u0016n\u001c7bi&|g\u000e\u000b\u0003\u0003\u0006\nm\u0003B\u0002BG\u0001\u0011\u0005\u0011*\u0001\u000fuKN$X\t\u001f9je\u0016$\u0006N]8ui2,G+[7f'\u0016t7o\u001c:)\t\t-%1\f\u0005\u0007\u0005'\u0003A\u0011A%\u0002-Q,7\u000f^#ya&\u0014X-U;pi\u0006\u001cVM\\:peNDCA!%\u0003\\!1!\u0011\u0014\u0001\u0005\u0002%\u000b\u0001\u0004^3ti\u000ec\u0017.\u001a8u\u0013\u0012tu\u000e^*b]&$\u0018N_3eQ\u0011\u00119Ja\u0017\b\u0013\t}\u0005!!A\t\n\t\u0005\u0016AC+tKJ\u001cE.[3oiB!\u0011\u0011\u000eBR\r%\ti\u0007AA\u0001\u0012\u0013\u0011)k\u0005\u0004\u0003$\n\u001d\u0016q\u000f\t\u000f\u0005S\u0013y+!\n\u0002&\u0005E\u0015\u0011SA4\u001b\t\u0011YKC\u0002\u0003.*\tqA];oi&lW-\u0003\u0003\u00032\n-&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oi!9qBa)\u0005\u0002\tUFC\u0001BQ\u0011)\u0011iDa)\u0002\u0002\u0013\u0015#q\b\u0005\u000b\u0005w\u0013\u0019+!A\u0005\u0002\nu\u0016!B1qa2LHCCA4\u0005\u007f\u0013\tMa1\u0003F\"A\u00111\u0005B]\u0001\u0004\t)\u0003\u0003\u0005\u00026\te\u0006\u0019AA\u0013\u0011)\tiI!/\u0011\u0002\u0003\u0007\u0011\u0011\u0013\u0005\u000b\u0003;\u0013I\f%AA\u0002\u0005E\u0005B\u0003Be\u0005G\u000b\t\u0011\"!\u0003L\u00069QO\\1qa2LH\u0003\u0002Bg\u0005+\u0004R!CAJ\u0005\u001f\u00042\"\u0003Bi\u0003K\t)#!%\u0002\u0012&\u0019!1\u001b\u0006\u0003\rQ+\b\u000f\\35\u0011)\u00119Na2\u0002\u0002\u0003\u0007\u0011qM\u0001\u0004q\u0012\u0002\u0004B\u0003Bn\u0005G\u000b\n\u0011\"\u0001\u0002v\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3\u0007\u0003\u0006\u0003`\n\r\u0016\u0013!C\u0001\u0003k\fq\"\u00199qYf$C-\u001a4bk2$H\u0005\u000e\u0005\u000b\u0005G\u0014\u0019+%A\u0005\u0002\u0005U\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3\u0007\u0003\u0006\u0003h\n\r\u0016\u0013!C\u0001\u0003k\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0004\"\u0003Bv\u0001E\u0005I\u0011\u0002Bw\u0003Y\u0011W/\u001b7e%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u0012T\u0003\u0002Bx\u0005g,\"A!=+\t\u0005\u001d\u00111\u001c\u0003\u0007U\n%(\u0019A6")
public class ClientQuotaManagerTest {
    private final MockTime kafka$server$ClientQuotaManagerTest$$time = new MockTime();
    private final Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.kafka$server$ClientQuotaManagerTest$$time());
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(500L, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
    private int numCallbacks = 0;
    private volatile ClientQuotaManagerTest$UserClient$ kafka$server$ClientQuotaManagerTest$$UserClient$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClientQuotaManagerTest$UserClient$ kafka$server$ClientQuotaManagerTest$$UserClient$lzycompute() {
        ClientQuotaManagerTest clientQuotaManagerTest = this;
        synchronized (clientQuotaManagerTest) {
            if (this.kafka$server$ClientQuotaManagerTest$$UserClient$module != null) return this.kafka$server$ClientQuotaManagerTest$$UserClient$module;
            this.kafka$server$ClientQuotaManagerTest$$UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            return this.kafka$server$ClientQuotaManagerTest$$UserClient$module;
        }
    }

    public MockTime kafka$server$ClientQuotaManagerTest$$time() {
        return this.kafka$server$ClientQuotaManagerTest$$time;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    public int numCallbacks() {
        return this.numCallbacks;
    }

    public void numCallbacks_$eq(int x$1) {
        this.numCallbacks = x$1;
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    public void callback(RequestChannel.Response response) {
        RequestChannel.Response response2;
        block4: {
            block3: {
                block2: {
                    response2 = response;
                    if (!(response2 instanceof RequestChannel.StartThrottlingResponse)) break block2;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(response2 instanceof RequestChannel.EndThrottlingResponse)) break block4;
                this.numCallbacks_$eq(this.numCallbacks() + 1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)response2);
    }

    private <T extends AbstractRequest> Tuple2<T, RequestChannel.Request> buildRequest(AbstractRequest.Builder<T> builder, ListenerName listenerName) {
        AbstractRequest request = builder.build();
        ByteBuffer buffer = request.serialize(new RequestHeader(builder.apiKey(), request.version(), "", 0));
        RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class);
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT);
        return new Tuple2((Object)request, (Object)new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, requestChannelMetrics));
    }

    private <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    public int kafka$server$ClientQuotaManagerTest$$maybeRecord(ClientQuotaManager quotaManager, String user, String clientId, double value) {
        KafkaPrincipal principal = new KafkaPrincipal("User", user);
        return quotaManager.maybeRecordAndGetThrottleTimeMs(new RequestChannel.Session(principal, null), clientId, value, this.kafka$server$ClientQuotaManagerTest$$time().milliseconds());
    }

    private void throttle(ClientQuotaManager quotaManager, String user, String clientId, int throttleTimeMs, Function1<RequestChannel.Response, BoxedUnit> channelThrottlingCallback) {
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)FetchRequest.Builder.forConsumer((int)0, (int)1000, new HashMap()), this.buildRequest$default$2());
        if (tuple2 != null) {
            RequestChannel.Request request;
            RequestChannel.Request request2;
            RequestChannel.Request request3 = request2 = (request = (RequestChannel.Request)tuple2._2());
            quotaManager.throttle(request3, throttleTimeMs, channelThrottlingCallback);
            return;
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(config, this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientMetrics.updateQuota(client2.configUser(), client2.configClientId(), client2.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)new StringBuilder().append((Object)"Default producer quota should be ").append((Object)BoxesRunTime.boxToLong((long)config.quotaBytesPerSecondDefault())).toString(), (double)config.quotaBytesPerSecondDefault(), (double)clientMetrics.quota(randomClient.user(), randomClient.clientId()).bound(), (double)0.0);
            Assert.assertEquals((String)"Should return the overridden value (2000)", (double)2000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            Assert.assertEquals((String)"Should return the overridden value (4000)", (double)4000.0, (double)clientMetrics.quota(client2.user(), client2.clientId()).bound(), (double)0.0);
            int throttleTimeMs = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, client1.user(), client1.clientId(), 2500 * config.numQuotaSamples());
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be > 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (3000)", (double)3000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, client1.user(), client1.clientId(), 0.0);
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (long)0L, (long)throttleTimeMs);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assert.assertEquals((String)"Should return the default value (500)", (double)500.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, client1.user(), client1.clientId(), 0.0);
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be > 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)None$.MODULE$);
            clientMetrics.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), defaultConfigClient.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (4000)", (double)4000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, client1.user(), client1.clientId(), 1000 * config.numQuotaSamples());
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (long)0L, (long)throttleTimeMs);
        }
        catch (Throwable throwable) {
            void var6_6;
            var6_6.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager quotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(2000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(3000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota$1("userA", "client1", 5000, 4500, false, quotaManager);
            this.checkQuota$1("userA", "client2", 4000, 4500, true, quotaManager);
            this.checkQuota$1("userA", "client3", 4000, 0, true, quotaManager);
            this.checkQuota$1("userA", "client1", 5000, 0, false, quotaManager);
            this.checkQuota$1("userB", "client1", 7000, 8000, true, quotaManager);
            this.checkQuota$1("userB", "client2", 8000, 7000, false, quotaManager);
            this.checkQuota$1("userB", "client3", 8000, 7000, false, quotaManager);
            this.checkQuota$1("userD", "client1", 3000, 3500, true, quotaManager);
            this.checkQuota$1("userD", "client2", 3000, 2500, false, quotaManager);
            this.checkQuota$1("userE", "client1", 3000, 2500, false, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$);
            this.checkQuota$1("userD", "client1", 1000, 0, false, quotaManager);
            this.checkQuota$1("userE", "client4", 1000, 1500, true, quotaManager);
            this.checkQuota$1("userF", "client4", 1000, 800, false, quotaManager);
            this.checkQuota$1("userF", "client5", 1000, 800, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota$1("userF", "client4", 2000, 0, false, quotaManager);
            this.checkQuota$1("userF", "client5", 2000, 0, false, quotaManager);
            this.checkQuota$1("userF", "client5", 2000, 2500, true, quotaManager);
            this.checkQuota$1("userG", "client5", 2000, 0, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota$1("userA", "client2", 8000, 0, false, quotaManager);
            this.checkQuota$1("userA", "client2", 8000, 4500, true, quotaManager);
            this.checkQuota$1("userA", "client1", 10000, 0, false, quotaManager);
            this.checkQuota$1("userA", "client1", 10000, 6000, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota$1("userA", "client6", 8000, 0, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota$1("userA", "client6", 11000, 8500, false, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(12000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota$1("userA", "client6", 12000, 4000, true, quotaManager);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown();
            throw throwable;
        }
        quotaManager.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaViolation() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Produce", ""));
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, clientMetrics){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager clientMetrics$1;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    Assert.assertEquals((long)0L, (long)this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.clientMetrics$1, "ANONYMOUS", "unknown", 400.0));
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.clientMetrics$1 = clientMetrics$1;
                }
            });
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.kafka$server$ClientQuotaManagerTest$$time().sleep(500L);
            int sleepTime = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 2300.0);
            Assert.assertEquals((String)"Should be throttled", (long)2100L, (long)sleepTime);
            this.throttle(clientMetrics, "ANONYMOYUS", "unknown", sleepTime, (Function1<RequestChannel.Response, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(RequestChannel.Response response) {
                    this.$outer.callback(response);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertEquals((long)1L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientMetrics.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)this.numCallbacks());
            this.kafka$server$ClientQuotaManagerTest$$time().sleep((long)sleepTime);
            clientMetrics.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assert.assertEquals((long)1L, (long)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, clientMetrics){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager clientMetrics$1;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.clientMetrics$1, "ANONYMOUS", "unknown", 400.0);
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.clientMetrics$1 = clientMetrics$1;
                }
            });
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 0.0));
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRequestPercentageQuotaViolation() {
        ClientRequestQuotaManager quotaManager = new ClientRequestQuotaManager(this.config(), this.metrics(), (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", (Option)None$.MODULE$);
        quotaManager.updateQuota((Option)new Some((Object)"ANONYMOUS"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)Quota.upperBound((double)1.0)));
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Request", ""));
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientRequestQuotaManager quotaManager$2;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    Assert.assertEquals((long)0L, (long)this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)this.quotaManager$2, "ANONYMOUS", "test-client", this.$outer.kafka$server$ClientQuotaManagerTest$$millisToPercent$1(4.0)));
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$2 = quotaManager$2;
                }
            });
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.kafka$server$ClientQuotaManagerTest$$time().sleep(500L);
            int throttleTime = this.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", this.kafka$server$ClientQuotaManagerTest$$millisToPercent$1(67.1));
            Assert.assertEquals((String)"Should be throttled", (long)210L, (long)throttleTime);
            this.throttle((ClientQuotaManager)quotaManager, "ANONYMOYUS", "test-client", throttleTime, (Function1<RequestChannel.Response, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(RequestChannel.Response response) {
                    this.$outer.callback(response);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertEquals((long)1L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            quotaManager.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)this.numCallbacks());
            this.kafka$server$ClientQuotaManagerTest$$time().sleep((long)throttleTime);
            quotaManager.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assert.assertEquals((long)1L, (long)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 11).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientRequestQuotaManager quotaManager$2;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)this.quotaManager$2, "ANONYMOUS", "test-client", this.$outer.kafka$server$ClientQuotaManagerTest$$millisToPercent$1(4.0));
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$2 = quotaManager$2;
                }
            });
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 0.0));
            Assert.assertEquals((long)1000L, (long)this.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", this.kafka$server$ClientQuotaManagerTest$$millisToPercent$1(500.0)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientRequestQuotaManager quotaManager$2;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                    Assert.assertEquals((long)1000L, (long)this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)this.quotaManager$2, "ANONYMOUS", "test-client", 0.0));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$2 = quotaManager$2;
                }
            });
            this.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 0.0));
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown();
            throw throwable;
        }
        quotaManager.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testExpireThrottleTimeSensor() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            int throttleTime = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", "client1", 10000.0);
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testExpireQuotaSensors() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            this.metrics().removeSensor("Produce-ANONYMOUS:client1");
            int throttleTime = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", "client1", 10000.0);
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = this.metrics().getSensor("Produce-:client1");
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClientIdNotSanitized() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        String clientId = "client@#$%";
        try {
            this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", clientId, 100.0);
            Sensor throttleTimeSensor = this.metrics().getSensor(new StringBuilder().append((Object)"ProduceThrottleTime-:").append((Object)clientId).toString());
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = this.metrics().getSensor(new StringBuilder().append((Object)"Produce-:").append((Object)clientId).toString());
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    public ClientQuotaManagerTest$UserClient$ kafka$server$ClientQuotaManagerTest$$UserClient() {
        return this.kafka$server$ClientQuotaManagerTest$$UserClient$module == null ? this.kafka$server$ClientQuotaManagerTest$$UserClient$lzycompute() : this.kafka$server$ClientQuotaManagerTest$$UserClient$module;
    }

    private final void checkQuota$1(String user, String clientId, int expectedBound, int value, boolean expectThrottle, ClientQuotaManager quotaManager$1) {
        Assert.assertEquals((double)expectedBound, (double)quotaManager$1.quota(user, clientId).bound(), (double)0.0);
        int throttleTimeMs = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(quotaManager$1, user, clientId, value * this.config().numQuotaSamples());
        if (expectThrottle) {
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be > 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (throttleTimeMs > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (long)0L, (long)throttleTimeMs);
        }
    }

    public final double kafka$server$ClientQuotaManagerTest$$millisToPercent$1(double millis) {
        return millis * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public class UserClient
    implements Product,
    Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public Option<String> sanitizedConfigClientId() {
            return this.configClientId().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String x) {
                    String string = x;
                    String string2 = ConfigEntityName$.MODULE$.Default();
                    return !(string != null ? !string.equals(string2) : string2 != null) ? ConfigEntityName$.MODULE$.Default() : Sanitizer.sanitize((String)x);
                }
            });
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 3: {
                    object = this.configClientId();
                    break;
                }
                case 2: {
                    object = this.configUser();
                    break;
                }
                case 1: {
                    object = this.clientId();
                    break;
                }
                case 0: {
                    object = this.user();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof UserClient)) return false;
            boolean bl = true;
            if (!bl) return false;
            UserClient userClient = (UserClient)x$1;
            String string = this.user();
            String string2 = userClient.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.clientId();
            String string4 = userClient.clientId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.configUser();
            Option<String> option2 = userClient.configUser();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.configClientId();
            Option<String> option4 = userClient.configClientId();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!userClient.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

