/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import java.util.Optional;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000193A!\u0001\u0002\u0001\u000f\t1B*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH\u000fC\u0003\u000e\u0001\u0011\u0005a\"\u0001\u0004=S:LGO\u0010\u000b\u0002\u001fA\u0011\u0011\u0002\u0001\u0005\u0006#\u0001!\tAE\u0001\u001ai\u0016\u001cH\u000fT5ti>3gm]3ug\u0016\u0013(o\u001c:D_\u0012,7\u000fF\u0001\u0014!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0011)f.\u001b;)\u0005AQ\u0002CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0015QWO\\5u\u0015\u0005y\u0012aA8sO&\u0011\u0011\u0005\b\u0002\u0005)\u0016\u001cH\u000fC\u0003$\u0001\u0011\u0005!#\u0001\u000euKN$8)\u001e:sK:$X\t]8dQZ\u000bG.\u001b3bi&|g\u000e\u000b\u0002#5!)a\u0005\u0001C\u0001%\u0005yB/Z:u%\u0016\u001c\bo\u001c8tK&s7\r\\;eKNdU-\u00193fe\u0016\u0003xn\u00195)\u0005\u0015R\u0002\"B\u0015\u0001\t\u0013Q\u0013aE1tg\u0016\u0014HOU3ta>t7/Z#se>\u0014H\u0003B\n,quBQ\u0001\f\u0015A\u00025\nQ!\u001a:s_J\u0004\"A\f\u001c\u000e\u0003=R!\u0001M\u0019\u0002\u0011A\u0014x\u000e^8d_2T!AM\u001a\u0002\r\r|W.\\8o\u0015\t)AG\u0003\u00026=\u00051\u0011\r]1dQ\u0016L!aN\u0018\u0003\r\u0015\u0013(o\u001c:t\u0011\u0015I\u0004\u00061\u0001;\u0003!\u0011'o\\6fe&#\u0007C\u0001\u000b<\u0013\taTCA\u0002J]RDQA\u0010\u0015A\u0002}\nqA]3rk\u0016\u001cH\u000f\u0005\u0002A\u00076\t\u0011I\u0003\u0002Cc\u0005A!/Z9vKN$8/\u0003\u0002E\u0003\n\tB*[:u\u001f\u001a47/\u001a;SKF,Xm\u001d;\t\u000b\u0019\u0003A\u0011B$\u0002\u0017M,g\u000e\u001a*fcV,7\u000f\u001e\u000b\u0004\u0011.k\u0005C\u0001!J\u0013\tQ\u0015I\u0001\nMSN$xJ\u001a4tKR\u0014Vm\u001d9p]N,\u0007\"\u0002'F\u0001\u0004Q\u0014\u0001\u00037fC\u0012,'/\u00133\t\u000by*\u0005\u0019A ")
public class ListOffsetsRequestTest
extends BaseRequestTest {
    @Test
    public void testListOffsetsErrorCodes() {
        String topic = "topic";
        TopicPartition partition = new TopicPartition(topic, 0);
        java.util.Map targetTimes = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)new ListOffsetRequest.PartitionData(-2L, Optional.of(Predef$.MODULE$.int2Integer(0))))}))).asJava();
        ListOffsetRequest consumerRequest = (ListOffsetRequest)ListOffsetRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(targetTimes).build();
        ListOffsetRequest replicaRequest = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)((KafkaServer)this.servers().head()).config().brokerId()).setTargetTimes(targetTimes).build();
        ListOffsetRequest debugReplicaRequest = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)-2).setTargetTimes(targetTimes).build();
        int randomBrokerId = ((KafkaServer)this.servers().head()).config().brokerId();
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, consumerRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, replicaRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, debugReplicaRequest);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Set replicas = this.zkClient().getReplicasForPartition(partition).toSet();
        int leader2 = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition.partition())));
        int follower2 = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)new Serializable(this, leader2){
            public static final long serialVersionUID = 0L;
            private final int leader$1;

            public final boolean apply(int x$1) {
                return this.apply$mcZI$sp(x$1);
            }

            public boolean apply$mcZI$sp(int x$1) {
                return x$1 != this.leader$1;
            }
            {
                this.leader$1 = leader$1;
            }
        }).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$2) {
                return x$2.config().brokerId();
            }
        }, Buffer$.MODULE$.canBuildFrom())).find((Function1)new Serializable(this, replicas){
            public static final long serialVersionUID = 0L;
            private final Set replicas$1;

            public final boolean apply(int x$3) {
                return this.apply$mcZI$sp(x$3);
            }

            public boolean apply$mcZI$sp(int x$3) {
                return !this.replicas$1.contains((Object)BoxesRunTime.boxToInteger((int)x$3));
            }
            {
                this.replicas$1 = replicas$1;
            }
        }).get());
        this.assertResponseError(Errors.NOT_LEADER_FOR_PARTITION, follower2, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_FOR_PARTITION, follower2, replicaRequest);
        this.assertResponseError(Errors.NONE, follower2, debugReplicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_FOR_PARTITION, nonReplica, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_FOR_PARTITION, nonReplica, replicaRequest);
        this.assertResponseError(Errors.REPLICA_NOT_AVAILABLE, nonReplica, debugReplicaRequest);
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_FOR_PARTITION, followerId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_FOR_PARTITION, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
    }

    @Test
    public void testResponseIncludesLeaderEpoch() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, 10, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        Assert.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), (Object)this.fetchOffsetAndEpoch$1(firstLeaderId, 0L, topicPartition));
        Assert.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), (Object)this.fetchOffsetAndEpoch$1(firstLeaderId, -2L, topicPartition));
        Assert.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), (Object)this.fetchOffsetAndEpoch$1(firstLeaderId, -1L, topicPartition));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        Assert.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), (Object)this.fetchOffsetAndEpoch$1(secondLeaderId, 0L, topicPartition));
        Assert.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), (Object)this.fetchOffsetAndEpoch$1(secondLeaderId, -2L, topicPartition));
        Assert.assertEquals((Object)new Tuple2.mcJI.sp(10L, secondLeaderEpoch), (Object)this.fetchOffsetAndEpoch$1(secondLeaderId, -1L, topicPartition));
    }

    private void assertResponseError(Errors error, int brokerId, ListOffsetRequest request) {
        ListOffsetResponse response = this.sendRequest(brokerId, request);
        Assert.assertEquals((long)request.partitionTimestamps().size(), (long)response.responseData().size());
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(response.responseData()).asScala()).values().foreach((Function1)new Serializable(this, error){
            public static final long serialVersionUID = 0L;
            private final Errors error$1;

            public final void apply(ListOffsetResponse.PartitionData partitionData) {
                Assert.assertEquals((Object)this.error$1, (Object)partitionData.error);
            }
            {
                this.error$1 = error$1;
            }
        });
    }

    private ListOffsetResponse sendRequest(int leaderId, ListOffsetRequest request) {
        SocketServer socketServer = this.brokerSocketServer(leaderId);
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.LIST_OFFSETS, socketServer, this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return ListOffsetResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private final void assertResponseErrorForEpoch$1(Errors error, int brokerId, Optional currentLeaderEpoch, TopicPartition topicPartition$1) {
        java.util.Map targetTimes = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition$1), (Object)new ListOffsetRequest.PartitionData(-2L, currentLeaderEpoch))}))).asJava();
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(targetTimes).build();
        this.assertResponseError(error, brokerId, request);
    }

    private final Tuple2 fetchOffsetAndEpoch$1(int serverId, long timestamp, TopicPartition topicPartition$2) {
        java.util.Map targetTimes = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition$2), (Object)new ListOffsetRequest.PartitionData(timestamp, Optional.empty()))}))).asJava();
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(targetTimes).build();
        ListOffsetResponse response = this.sendRequest(serverId, request);
        ListOffsetResponse.PartitionData partitionData = (ListOffsetResponse.PartitionData)response.responseData().get(topicPartition$2);
        Optional epochOpt = partitionData.leaderEpoch;
        Assert.assertTrue((boolean)epochOpt.isPresent());
        return new Tuple2.mcJI.sp(Predef$.MODULE$.Long2long(partitionData.offset), Predef$.MODULE$.Integer2int((Integer)epochOpt.get()));
    }
}

