/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.log.LogConfig$;
import kafka.message.ZStdCompressionCodec$;
import kafka.server.BaseRequestTest;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001\u000f\t\u0011\u0002K]8ek\u000e,'+Z9vKN$H+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI!\"D\u0001\u0003\u0013\tY!AA\bCCN,'+Z9vKN$H+Z:u\u0011\u0015i\u0001\u0001\"\u0001\u000f\u0003\u0019a\u0014N\\5u}Q\tq\u0002\u0005\u0002\n\u0001!9\u0011\u0003\u0001b\u0001\n\u0003\u0011\u0012!D7fiJL7m]&fsN+G/F\u0001\u0014!\r!2$H\u0007\u0002+)\u0011acF\u0001\b[V$\u0018M\u00197f\u0015\tA\u0012$\u0001\u0006d_2dWm\u0019;j_:T\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039U\u00111aU3u!\tqr%D\u0001 \u0015\t\u0001\u0013%\u0001\u0003d_J,'B\u0001\u0012$\u0003\u001diW\r\u001e:jGNT!\u0001J\u0013\u0002\re\fW.\\3s\u0015\u00051\u0013aA2p[&\u0011\u0001f\b\u0002\u000b\u001b\u0016$(/[2OC6,\u0007B\u0002\u0016\u0001A\u0003%1#\u0001\bnKR\u0014\u0018nY:LKf\u001cV\r\u001e\u0011\t\u000b1\u0002A\u0011A\u0017\u00021Q,7\u000f^*j[BdW\r\u0015:pIV\u001cWMU3rk\u0016\u001cH\u000fF\u0001/!\ty\u0003'D\u0001\u001a\u0013\t\t\u0014D\u0001\u0003V]&$\bFA\u00164!\t!\u0014(D\u00016\u0015\t1t'A\u0003kk:LGOC\u00019\u0003\ry'oZ\u0005\u0003uU\u0012A\u0001V3ti\")A\b\u0001C\u0001[\u0005yB/Z:u!J|G-^2f/&$\b.\u00138wC2LG\rV5nKN$\u0018-\u001c9)\u0005m\u001a\u0004\"B \u0001\t\u0003i\u0013a\u0006;fgR\u0004&o\u001c3vG\u0016$vNT8o%\u0016\u0004H.[2bQ\tq4\u0007C\u0003C\u0001\u0011%1)A\u0013de\u0016\fG/\u001a+pa&\u001c\u0017I\u001c3GS:$\u0007+\u0019:uSRLwN\\,ji\"dU-\u00193feR\u0011AI\u0013\t\u0005_\u0015;u)\u0003\u0002G3\t1A+\u001e9mKJ\u0002\"a\f%\n\u0005%K\"aA%oi\")1*\u0011a\u0001\u0019\u0006)Ao\u001c9jGB\u0011Q\n\u0015\b\u0003_9K!aT\r\u0002\rA\u0013X\rZ3g\u0013\t\t&K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001ffAQ\u0001\u0016\u0001\u0005\u00025\nA\u0004^3ti\u000e{'O];qi2SH\u0007\u0015:pIV\u001cWMU3rk\u0016\u001cH\u000f\u000b\u0002Tg!)q\u000b\u0001C\u0001[\u00051B/Z:u5N#F\t\u0015:pIV\u001cWMU3rk\u0016\u001cH\u000f\u000b\u0002Wg!)!\f\u0001C\u00057\u0006\u00112/\u001a8e!J|G-^2f%\u0016\fX/Z:u)\rav-\u001b\t\u0003;\u0016l\u0011A\u0018\u0006\u0003?\u0002\f\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003C\n\faaY8n[>t'BA\u0003d\u0015\t!w'\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003Mz\u0013q\u0002\u0015:pIV\u001cWMU3ta>t7/\u001a\u0005\u0006Qf\u0003\raR\u0001\tY\u0016\fG-\u001a:JI\")!.\u0017a\u0001W\u00069!/Z9vKN$\bCA/m\u0013\tigL\u0001\bQe>$WoY3SKF,Xm\u001d;")
public class ProduceRequestTest
extends BaseRequestTest {
    private final Set<MetricName> metricsKeySet = (Set)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala();

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    @Test
    public void testSimpleProduceRequest() {
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int partition = tuple2._1$mcI$sp();
            int leader2 = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(partition, leader2);
            int partition2 = sp3._1$mcI$sp();
            int leader3 = sp3._2$mcI$sp();
            this.sendAndCheck$1(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())}), 0L, partition2, leader3);
            this.sendAndCheck$1(MemoryRecords.withRecords((CompressionType)CompressionType.GZIP, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key1".getBytes(), "value1".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key2".getBytes(), "value2".getBytes())}), 1L, partition2, leader3);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testProduceWithInvalidTimestamp() {
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), "1000");
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), topicConfig);
        int leader2 = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        MemoryRecords records2 = this.createRecords$1((byte)2, System.currentTimeMillis() - 1001L, CompressionType.GZIP);
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records2)}));
        ProduceResponse produceResponse = this.sendProduceRequest(leader2, (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)3000, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava())).build());
        Tuple2 tuple2 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition tp = (TopicPartition)tuple2._1();
            ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)tp, (Object)partitionResponse);
            TopicPartition tp2 = (TopicPartition)tuple23._1();
            ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple23._2();
            Assert.assertEquals((Object)topicPartition, (Object)tp2);
            Assert.assertEquals((Object)Errors.INVALID_TIMESTAMP, (Object)partitionResponse2.error);
            Assert.assertEquals((long)1L, (long)partitionResponse2.recordErrors.size());
            Assert.assertEquals((long)0L, (long)((ProduceResponse.RecordError)partitionResponse2.recordErrors.get((int)0)).batchIndex);
            Assert.assertNull((Object)((ProduceResponse.RecordError)partitionResponse2.recordErrors.get((int)0)).message);
            Assert.assertNotNull((Object)partitionResponse2.errorMessage);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testProduceToNonReplica() {
        String topic = "topic";
        int partition = 0;
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int leader2 = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.servers().find((Function1)new Serializable(this, leader2){
            public static final long serialVersionUID = 0L;
            private final int leader$2;

            public final boolean apply(KafkaServer x$4) {
                return x$4.config().brokerId() != this.leader$2;
            }
            {
                this.leader$2 = leader$2;
            }
        });
        Assert.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaServer)nonReplicaOpt.get()).config().brokerId();
        MemoryRecords records2 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("key".getBytes(), "value".getBytes())});
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records2)}));
        ProduceRequest produceRequest = (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)3000, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava())).build();
        ProduceResponse produceResponse = this.sendProduceRequest(nonReplicaId, produceRequest);
        Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)((ProduceResponse.PartitionResponse)((Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)produceResponse.responses()).asScala()).head())._2()).error);
    }

    private Tuple2<Object, Object> createTopicAndFindPartitionWithLeader(String topic) {
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 3, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        return (Tuple2)partitionToLeader.collectFirst((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    int partition = A1._1$mcI$sp();
                    int leader2 = A1._2$mcI$sp();
                    if (leader2 != -1) {
                        object = new Tuple2.mcII.sp(partition, leader2);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                int leader2;
                Tuple2<Object, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (leader2 = tuple2._2$mcI$sp()) != -1;
                return bl;
            }
        }).getOrElse((Function0)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$1;

            public final Nothing$ apply() {
                return Assertions$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No leader elected for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1})), new Position("ProduceRequestTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            }
            {
                this.topic$1 = topic$1;
            }
        });
    }

    @Test
    public void testCorruptLz4ProduceRequest() {
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int partition = tuple2._1$mcI$sp();
            int leader2 = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(partition, leader2);
            int partition2 = sp3._1$mcI$sp();
            int leader3 = sp3._2$mcI$sp();
            int timestamp = 1000000;
            MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.LZ4, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord((long)timestamp, "key".getBytes(), "value".getBytes())});
            int lz4ChecksumOffset = 6;
            memoryRecords.buffer().array()[61 + lz4ChecksumOffset] = 0;
            TopicPartition topicPartition = new TopicPartition("topic", partition2);
            scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)memoryRecords)}));
            ProduceResponse produceResponse = this.sendProduceRequest(leader3, (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)3000, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava())).build());
            Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
            Tuple2 tuple22 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
            if (tuple22 != null) {
                Tuple2 tuple23;
                TopicPartition tp = (TopicPartition)tuple22._1();
                ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)tp, (Object)partitionResponse);
                TopicPartition tp2 = (TopicPartition)tuple24._1();
                ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple24._2();
                Assert.assertEquals((Object)topicPartition, (Object)tp2);
                Assert.assertEquals((Object)Errors.CORRUPT_MESSAGE, (Object)partitionResponse2.error);
                Assert.assertEquals((long)-1L, (long)partitionResponse2.baseOffset);
                Assert.assertEquals((long)-1L, (long)partitionResponse2.logAppendTime);
                Assert.assertEquals((long)this.metricsKeySet().count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MetricName x$7) {
                        return x$7.getMBeanName().endsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BrokerTopicStats$.MODULE$.InvalidMessageCrcRecordsPerSec()})));
                    }
                }), (long)1L);
                Assert.assertTrue((TestUtils$.MODULE$.meterCount(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BrokerTopicStats$.MODULE$.InvalidMessageCrcRecordsPerSec()}))) > 0L ? 1 : 0) != 0);
                return;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testZSTDProduceRequest() {
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.CompressionTypeProp(), ZStdCompressionCodec$.MODULE$.name());
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), topicConfig);
        int leader2 = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.ZSTD, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())});
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)memoryRecords)}));
        ProduceResponse res1 = this.sendProduceRequest(leader2, (ProduceRequest)new ProduceRequest.Builder(7, 7, -1, 3000, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava(), null).build());
        Tuple2 tuple2 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(res1.responses()).asScala()).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition tp1 = (TopicPartition)tuple2._1();
            ProduceResponse.PartitionResponse partitionResponse1 = (ProduceResponse.PartitionResponse)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)tp1, (Object)partitionResponse1);
            TopicPartition tp12 = (TopicPartition)tuple23._1();
            ProduceResponse.PartitionResponse partitionResponse12 = (ProduceResponse.PartitionResponse)tuple23._2();
            Assert.assertEquals((Object)topicPartition, (Object)tp12);
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionResponse12.error);
            Assert.assertEquals((long)0L, (long)partitionResponse12.baseOffset);
            Assert.assertEquals((long)-1L, (long)partitionResponse12.logAppendTime);
            ProduceResponse res2 = this.sendProduceRequest(leader2, new ProduceRequest.Builder(3, 3, -1, 3000, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava(), null).buildUnsafe((short)3));
            Tuple2 tuple24 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(res2.responses()).asScala()).head();
            if (tuple24 != null) {
                Tuple2 tuple25;
                TopicPartition tp2 = (TopicPartition)tuple24._1();
                ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)tp2, (Object)partitionResponse2);
                TopicPartition tp22 = (TopicPartition)tuple26._1();
                ProduceResponse.PartitionResponse partitionResponse22 = (ProduceResponse.PartitionResponse)tuple26._2();
                Assert.assertEquals((Object)topicPartition, (Object)tp22);
                Assert.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)partitionResponse22.error);
                return;
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    private ProduceResponse sendProduceRequest(int leaderId, ProduceRequest request) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.PRODUCE, this.brokerSocketServer(leaderId), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return ProduceResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private final ProduceResponse.PartitionResponse sendAndCheck$1(MemoryRecords memoryRecords, long expectedOffset, int partition$1, int leader$1) {
        TopicPartition topicPartition = new TopicPartition("topic", partition$1);
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)memoryRecords)}));
        ProduceResponse produceResponse = this.sendProduceRequest(leader$1, (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)3000, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava())).build());
        Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
        Tuple2 tuple2 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition tp = (TopicPartition)tuple2._1();
            ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)tp, (Object)partitionResponse);
            TopicPartition tp2 = (TopicPartition)tuple23._1();
            ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple23._2();
            Assert.assertEquals((Object)topicPartition, (Object)tp2);
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionResponse2.error);
            Assert.assertEquals((long)expectedOffset, (long)partitionResponse2.baseOffset);
            Assert.assertEquals((long)-1L, (long)partitionResponse2.logAppendTime);
            Assert.assertTrue((boolean)partitionResponse2.recordErrors.isEmpty());
            return partitionResponse2;
        }
        throw new MatchError((Object)tuple2);
    }

    private final MemoryRecords createRecords$1(byte magicValue, long timestamp, CompressionType codec) {
        ByteBuffer buf = ByteBuffer.allocate(512);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private final long createRecords$default$2$1() {
        return -1L;
    }
}

