/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.net.InetAddress;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kafka.api.Request$;
import kafka.cluster.Broker;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.AppendOrigin;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.ProducerStateManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.OffsetAndEpoch;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaManagerTest$;
import kafka.server.ReplicaManagerTest$$anon$4$;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.server.checkpoints.LazyOffsetCheckpoints;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.epoch.util.ReplicaFetcherMockBlockingSend;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.timer.MockTimer;
import kafka.utils.timer.Timer;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0011-b\u0001B\u0001\u0003\u0001\u001d\u0011!CU3qY&\u001c\u0017-T1oC\u001e,'\u000fV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005)Ao\u001c9jGV\ta\u0003\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005!A.\u00198h\u0015\u0005Y\u0012\u0001\u00026bm\u0006L!!\b\r\u0003\rM#(/\u001b8h\u0011\u0019y\u0002\u0001)A\u0005-\u00051Ao\u001c9jG\u0002Bq!\t\u0001C\u0002\u0013\u0005!%\u0001\u0003uS6,W#A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\"\u0011!B;uS2\u001c\u0018B\u0001\u0015&\u0005!iunY6US6,\u0007B\u0002\u0016\u0001A\u0003%1%A\u0003uS6,\u0007\u0005C\u0004-\u0001\t\u0007I\u0011A\u0017\u0002\u000f5,GO]5dgV\ta\u0006\u0005\u00020q5\t\u0001G\u0003\u0002-c)\u0011!gM\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015!$BA\u001b7\u0003\u0019\t\u0007/Y2iK*\tq'A\u0002pe\u001eL!!\u000f\u0019\u0003\u000f5+GO]5dg\"11\b\u0001Q\u0001\n9\n\u0001\"\\3ue&\u001c7\u000f\t\u0005\n{\u0001\u0001\r\u00111A\u0005\u0002y\nQb[1gW\u0006T6n\u00117jK:$X#A \u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t#\u0011A\u0001>l\u0013\t!\u0015IA\u0007LC\u001a\\\u0017MW6DY&,g\u000e\u001e\u0005\n\r\u0002\u0001\r\u00111A\u0005\u0002\u001d\u000b\u0011c[1gW\u0006T6n\u00117jK:$x\fJ3r)\tA5\n\u0005\u0002\n\u0013&\u0011!J\u0003\u0002\u0005+:LG\u000fC\u0004M\u000b\u0006\u0005\t\u0019A \u0002\u0007a$\u0013\u0007\u0003\u0004O\u0001\u0001\u0006KaP\u0001\u000fW\u000647.\u0019.l\u00072LWM\u001c;!\u0011\u001d\u0001\u0006A1A\u0005\u0002E\u000b\u0011B_6WKJ\u001c\u0018n\u001c8\u0016\u0003I\u0003\"!C*\n\u0005QS!aA%oi\"1a\u000b\u0001Q\u0001\nI\u000b!B_6WKJ\u001c\u0018n\u001c8!\u0011\u001dA\u0006A1A\u0005\u0002E\u000bQbY8se\u0016d\u0017\r^5p]&#\u0007B\u0002.\u0001A\u0003%!+\u0001\bd_J\u0014X\r\\1uS>t\u0017\n\u001a\u0011\t\u000fq\u0003\u0001\u0019!C\u0001#\u0006y1m\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000eC\u0004_\u0001\u0001\u0007I\u0011A0\u0002'\r|g\u000e\u001e:pY2,'/\u00129pG\"|F%Z9\u0015\u0005!\u0003\u0007b\u0002'^\u0003\u0003\u0005\rA\u0015\u0005\u0007E\u0002\u0001\u000b\u0015\u0002*\u0002!\r|g\u000e\u001e:pY2,'/\u00129pG\"\u0004\u0003b\u00023\u0001\u0005\u0004%\t!Z\u0001\fEJ|7.\u001a:Fa>\u001c\u0007.F\u0001g!\tIq-\u0003\u0002i\u0015\t!Aj\u001c8h\u0011\u0019Q\u0007\u0001)A\u0005M\u0006a!M]8lKJ,\u0005o\\2iA!)A\u000e\u0001C\u0001[\u0006)1/\u001a;VaR\t\u0001\n\u000b\u0002l_B\u0011\u0001o]\u0007\u0002c*\u0011!ON\u0001\u0006UVt\u0017\u000e^\u0005\u0003iF\u0014aAQ3g_J,\u0007\"\u0002<\u0001\t\u0003i\u0017\u0001\u0003;fCJ$un\u001e8)\u0005UD\bC\u00019z\u0013\tQ\u0018OA\u0003BMR,'\u000fC\u0003}\u0001\u0011\u0005Q.A\u0011uKN$\b*[4i/\u0006$XM]'be.$\u0015N]3di>\u0014\u00180T1qa&tw\r\u000b\u0002|}B\u0011\u0001o`\u0005\u0004\u0003\u0003\t(\u0001\u0002+fgRDa!!\u0002\u0001\t\u0003i\u0017!\u000b;fgRD\u0015n\u001a5xCR,'/T1sWJ+G.\u0019;jm\u0016$\u0015N]3di>\u0014\u00180T1qa&tw\rK\u0002\u0002\u0004yDa!a\u0003\u0001\t\u0003i\u0017a\u0006;fgRLE\u000e\\3hC2\u0014V-];je\u0016$\u0017iY6tQ\r\tIA \u0005\u0007\u0003#\u0001A\u0011A7\u0002IQ,7\u000f^\"mK\u0006\u0014\b+\u001e:hCR|'/_(o\u0005\u0016\u001cw.\\5oO\u001a{G\u000e\\8xKJD3!a\u0004\u007f\u0011\u0019\t9\u0002\u0001C\u0001[\u0006AD/Z:u%\u0016\u001cW-\u001b<f\u001fV$xJZ(sI\u0016\u00148+Z9vK:\u001cW-\u0012=dKB$\u0018n\u001c8XSRDGj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\bfAA\u000b}\"1\u0011Q\u0004\u0001\u0005\u00025\f!\u0005^3tiJ+\u0017\rZ\"p[6LG\u000f^3e\r\u0016$8\r\u001b'j[&$X\rZ!u\u0019N{\u0005fAA\u000e}\"1\u00111\u0005\u0001\u0005\u00025\f1\u0006^3ti\u0012+G.Y=fI\u001a+Go\u00195J]\u000edW\u000fZ3t\u0003\n|'\u000f^3e)J\fgn]1di&|gn\u001d\u0015\u0004\u0003Cq\bBBA\u0015\u0001\u0011\u0005Q.A\u0018uKN$h)\u001a;dQ\n+\u0017p\u001c8e\u0011&<\u0007nV1uKJl\u0017M]6SKR,(O\\#naRL(+Z:q_:\u001cX\rK\u0002\u0002(yDa!a\f\u0001\t\u0003i\u0017!\u000b;fgR4u\u000e\u001c7po\u0016\u00148\u000b^1uK:{G/\u00169eCR,G-\u00134M_\u001e\u0014V-\u00193GC&d7\u000fK\u0002\u0002.yDa!!\u000e\u0001\t\u0003i\u0017a\f;fgR4U\r^2i\u001b\u0016\u001c8/Y4fg^CWM\u001c(pi\u001a{G\u000e\\8xKJ4uN](oKB\u000b'\u000f^5uS>t\u0007fAA\u001a}\"1\u00111\b\u0001\u0005\u00025\fA\b^3ti\n+7m\\7f\r>dGn\\<fe^CWM\u001c'fC\u0012,'/S:V]\u000eD\u0017M\\4fI\n+H/T5tg\u0016$G*Z1eKJ,\u0006\u000fZ1uK\"\u001a\u0011\u0011\b@\t\r\u0005\u0005\u0003\u0001\"\u0001n\u0003M!Xm\u001d;SKBd\u0017nY1TK2,7\r^8sQ\r\tyD \u0005\u0007\u0003\u000f\u0002A\u0011A7\u0002=Q,7\u000f\u001e)sK\u001a,'O]3e%\u0016\u0004H.[2b\u0003N4u\u000e\u001c7po\u0016\u0014\bfAA#}\"1\u0011Q\n\u0001\u0005\u00025\fA\u0004^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\f\u0017i\u001d'fC\u0012,'\u000fK\u0002\u0002LyDa!a\u0015\u0001\t\u0003i\u0017A\u0007;fgR,fn\u001b8po:\u0014V\r\u001d7jG\u0006\u001cV\r\\3di>\u0014\bfBA)}\u0006]\u0013\u0011L\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012\u00111\f\t\u0004/\u0005u\u0013bAA01\t12\t\\1tg:{GOR8v]\u0012,\u0005pY3qi&|g\u000e\u0003\u0004\u0002d\u0001!\t!\\\u0001\u001bi\u0016\u001cH\u000fR3gCVdGOU3qY&\u001c\u0017mU3mK\u000e$xN\u001d\u0015\u0004\u0003Cr\bBBA5\u0001\u0011\u0005Q.\u0001\u0016uKN$h)\u001a;dQ\u001a{G\u000e\\8xKJtu\u000e^!mY><X\r\u001a$pe>cG-\u001a:DY&,g\u000e^:)\u0007\u0005\u001dd\u0010\u0003\u0004\u0002p\u0001!\t!\\\u00011i\u0016\u001cHOQ3d_6,gi\u001c7m_^,'o\u00165jY\u0016|E\u000eZ\"mS\u0016tGOR3uG\"Le\u000eU;sO\u0006$xN]=)\u0007\u00055d\u0010\u0003\u0004\u0002v\u0001!\t!\\\u00011i\u0016\u001cHOQ3d_6,gi\u001c7m_^,'o\u00165jY\u0016tUm^\"mS\u0016tGOR3uG\"Le\u000eU;sO\u0006$xN]=)\u0007\u0005Md\u0010\u0003\u0004\u0002|\u0001!\t!\\\u0001!i\u0016\u001cHOR3uG\"4%o\\7MK\u0006$WM]!mo\u0006L8/\u00117m_^,G\rK\u0002\u0002zyDa!!!\u0001\t\u0003i\u0017\u0001\n;fgR\u001cE.Z1s\r\u0016$8\r\u001b)ve\u001e\fGo\u001c:z\u001f:\u001cFo\u001c9SKBd\u0017nY1)\u0007\u0005}d\u0010\u0003\u0004\u0002\b\u0002!\t!\\\u0001'i\u0016\u001cHo\u00117fCJ\u0004&o\u001c3vG\u0016\u0004VO]4bi>\u0014\u0018p\u00148Ti>\u0004(+\u001a9mS\u000e\f\u0007fAAC}\"9\u0011Q\u0012\u0001\u0005\n\u0005=\u0015AE:f]\u0012\u0004&o\u001c3vG\u0016\u0014\u0018\t\u001d9f]\u0012$b!!%\u0002R\u0006m\u0007CBAJ\u0003C\u000b)+\u0004\u0002\u0002\u0016*!\u0011qSAM\u0003\u0019\tGo\\7jG*!\u00111TAO\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003?S\u0012\u0001B;uS2LA!a)\u0002\u0016\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0003\u0002(\u0006-g\u0002BAU\u0003\u000btA!a+\u0002B:!\u0011QVA`\u001d\u0011\ty+!0\u000f\t\u0005E\u00161\u0018\b\u0005\u0003g\u000bI,\u0004\u0002\u00026*\u0019\u0011q\u0017\u0004\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0014BA\u001b7\u0013\t)A'\u0003\u00023g%\u0019\u00111Y\u0019\u0002\u0011I,\u0017/^3tiNLA!a2\u0002J\u0006y\u0001K]8ek\u000e,'+Z:q_:\u001cXMC\u0002\u0002DFJA!!4\u0002P\n\t\u0002+\u0019:uSRLwN\u001c*fgB|gn]3\u000b\t\u0005\u001d\u0017\u0011\u001a\u0005\t\u0003'\fY\t1\u0001\u0002V\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bc\u0001\n\u0002X&\u0019\u0011\u0011\u001c\u0002\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\"A\u0011Q\\AF\u0001\u0004\ty.\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005\u0005\u00181]\u0007\u0002c%\u0019\u0011Q]\u0019\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011\u0011\u001e\u0001\u0005\n\u0005-\u0018!E:f]\u0012\u001cuN\\:v[\u0016\u0014h)\u001a;dQRa\u0011Q^A{\u0003o\fIP!\u0004\u0003$A1\u00111SAQ\u0003_\u00042AEAy\u0013\r\t\u0019P\u0001\u0002\u0013\r\u0016$8\r\u001b)beRLG/[8o\t\u0006$\u0018\r\u0003\u0005\u0002T\u0006\u001d\b\u0019AAk\u0011!\ti.a:A\u0002\u0005}\u0007\u0002CA~\u0003O\u0004\r!!@\u0002\u001bA\f'\u000f^5uS>tG)\u0019;b!\u0011\tyPa\u0002\u000f\t\t\u0005!1A\u0007\u0003\u0003\u0013LAA!\u0002\u0002J\u0006aa)\u001a;dQJ+\u0017/^3ti&!!\u0011\u0002B\u0006\u00055\u0001\u0016M\u001d;ji&|g\u000eR1uC*!!QAAe\u0011!\u0011y!a:A\u0002\tE\u0011!E2mS\u0016tG/T3uC\u0012\fG/Y(qiB)\u0011Ba\u0005\u0003\u0018%\u0019!Q\u0003\u0006\u0003\r=\u0003H/[8o!\u0011\u0011IBa\b\u000e\u0005\tm!b\u0001B\u000fc\u00059!/\u001a9mS\u000e\f\u0017\u0002\u0002B\u0011\u00057\u0011ab\u00117jK:$X*\u001a;bI\u0006$\u0018\rC\u0005\u0003&\u0005\u001d\b\u0013!a\u0001M\u00069A/[7f_V$\bb\u0002B\u0015\u0001\u0011%!1F\u0001#aJ,\u0007/\u0019:f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003:$Gj\\4NC:\fw-\u001a:\u0015!\t5\"q\bB!\u0005\u000b\u0012IE!\u0014\u0003Z\t\r\u0004cB\u0005\u00030\u0005U'1G\u0005\u0004\u0005cQ!A\u0002+va2,'\u0007\u0005\u0003\u00036\tmRB\u0001B\u001c\u0015\r\u0011I\u0004B\u0001\u0004Y><\u0017\u0002\u0002B\u001f\u0005o\u0011!\u0002T8h\u001b\u0006t\u0017mZ3s\u0011\u001d\tiNa\nA\u0002ICqAa\u0011\u0003(\u0001\u0007!+A\rmK\u0006$WM]#q_\u000eD\u0017J\u001c'fC\u0012,'/\u00118e\u0013N\u0014\bb\u0002B$\u0005O\u0001\rAU\u0001\u0011M>dGn\\<fe\n\u0013xn[3s\u0013\u0012DqAa\u0013\u0003(\u0001\u0007!+\u0001\bmK\u0006$WM\u001d\"s_.,'/\u00133\t\u0011\t=#q\u0005a\u0001\u0005#\nabY8v]R$un\u001e8MCR\u001c\u0007\u000e\u0005\u0003\u0003T\tUSBAAM\u0013\u0011\u00119&!'\u0003\u001d\r{WO\u001c;E_^tG*\u0019;dQ\"A!1\fB\u0014\u0001\u0004\u0011i&\u0001\tfqB,7\r\u001e+sk:\u001c\u0017\r^5p]B\u0019\u0011Ba\u0018\n\u0007\t\u0005$BA\u0004C_>dW-\u00198\t\u0015\t\u0015$q\u0005I\u0001\u0002\u0004\u00119'\u0001\u0006fqR\u0014\u0018\r\u0015:paN\u0004BA!\u001b\u0003l5\u0011\u0011QT\u0005\u0005\u0005[\niJ\u0001\u0006Qe>\u0004XM\u001d;jKNDqA!\u001d\u0001\t\u0013\u0011\u0019(\u0001\u000emK\u0006$WM]!oI&\u001b(\u000fU1si&$\u0018n\u001c8Ti\u0006$X\r\u0006\u0006\u0003v\t-%Q\u0012BI\u0005'\u0003BAa\u001e\u0003\u0006:!!\u0011\u0010B@\u001d\u0011\tYKa\u001f\n\u0007\tu\u0014'A\u0004nKN\u001c\u0018mZ3\n\t\t\u0005%1Q\u0001\u0018\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d*fcV,7\u000f\u001e#bi\u0006T1A! 2\u0013\u0011\u00119I!#\u000351+\u0017\rZ3s\u0003:$\u0017j\u001d:QCJ$\u0018\u000e^5p]N#\u0018\r^3\u000b\t\t\u0005%1\u0011\u0005\t\u0003;\u0014y\u00071\u0001\u0002`\"9!q\u0012B8\u0001\u0004\u0011\u0016a\u00037fC\u0012,'/\u00129pG\"DqAa\u0013\u0003p\u0001\u0007!\u000b\u0003\u0005\u0003\u0016\n=\u0004\u0019\u0001BL\u00039\tG.\u001b<f\u0005J|7.\u001a:JIN\u0004bA!'\u0003 \n\rVB\u0001BN\u0015\r\u0011iJC\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BQ\u00057\u00131aU3r!\r9\"QU\u0005\u0004\u0005OC\"aB%oi\u0016<WM\u001d\u0004\u0007\u0005W\u0003AA!,\u0003\u001d\r\u000bG\u000e\u001c2bG.\u0014Vm];miV!!q\u0016B_'\r\u0011I\u000b\u0003\u0005\b\u001f\t%F\u0011\u0001BZ)\t\u0011)\f\u0005\u0004\u00038\n%&\u0011X\u0007\u0002\u0001A!!1\u0018B_\u0019\u0001!\u0001Ba0\u0003*\n\u0007!\u0011\u0019\u0002\u0002)F!!1\u0019Be!\rI!QY\u0005\u0004\u0005\u000fT!a\u0002(pi\"Lgn\u001a\t\u0004\u0013\t-\u0017b\u0001Bg\u0015\t\u0019\u0011I\\=\t\u0015\tE'\u0011\u0016a\u0001\n\u0013\u0011\u0019.A\u0003wC2,X-\u0006\u0002\u0003VB)\u0011Ba\u0005\u0003:\"Q!\u0011\u001cBU\u0001\u0004%IAa7\u0002\u0013Y\fG.^3`I\u0015\fHc\u0001%\u0003^\"IAJa6\u0002\u0002\u0003\u0007!Q\u001b\u0005\n\u0005C\u0014I\u000b)Q\u0005\u0005+\faA^1mk\u0016\u0004\u0003B\u0003Bs\u0005S\u0003\r\u0011\"\u0003\u0003h\u0006\u0019a-\u001e8\u0016\u0005\t%\b#B\u0005\u0003\u0014\t-\bCB\u0005\u0003n\ne\u0006*C\u0002\u0003p*\u0011\u0011BR;oGRLwN\\\u0019\t\u0015\tM(\u0011\u0016a\u0001\n\u0013\u0011)0A\u0004gk:|F%Z9\u0015\u0007!\u00139\u0010C\u0005M\u0005c\f\t\u00111\u0001\u0003j\"I!1 BUA\u0003&!\u0011^\u0001\u0005MVt\u0007\u0005\u0003\u0005\u0003\u0000\n%F\u0011AB\u0001\u0003-\t7o]3si\u001aK'/\u001a3\u0016\u0005\te\u0006\u0002CB\u0003\u0005S#\taa\u0002\u0002\u000f%\u001ch)\u001b:fIV\u0011!Q\f\u0005\t\u0007\u0017\u0011I\u000b\"\u0001\u0004\u000e\u0005!a-\u001b:f)\rA5q\u0002\u0005\t\u0005#\u001cI\u00011\u0001\u0003:\"A11\u0003BU\t\u0003\u0019)\"\u0001\u0004p]\u001aK'/\u001a\u000b\u0005\u0005k\u001b9\u0002\u0003\u0005\u0003f\u000eE\u0001\u0019\u0001Bv\u0011\u001d\u0019Y\u0002\u0001C\u0005\u0007;\tQ\"\u00199qK:$'+Z2pe\u0012\u001cH\u0003DB\u0010\u0007C\u0019\u0019ca\n\u00048\r\u0005\u0003C\u0002B\\\u0005S\u000b)\u000b\u0003\u0005\u0002T\u000ee\u0001\u0019AAk\u0011!\u0019)c!\u0007A\u0002\u0005}\u0017!\u00039beRLG/[8o\u0011!\u0019Ic!\u0007A\u0002\r-\u0012a\u0002:fG>\u0014Hm\u001d\t\u0005\u0007[\u0019\u0019$\u0004\u0002\u00040)\u00191\u0011G\u0019\u0002\rI,7m\u001c:e\u0013\u0011\u0019)da\f\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011)\u0019Id!\u0007\u0011\u0002\u0003\u000711H\u0001\u0007_JLw-\u001b8\u0011\t\tU2QH\u0005\u0005\u0007\u007f\u00119D\u0001\u0007BaB,g\u000eZ(sS\u001eLg\u000e\u0003\u0006\u0004D\re\u0001\u0013!a\u0001\u0007\u000b\nAB]3rk&\u0014X\rZ!dWN\u00042!CB$\u0013\r\u0019IE\u0003\u0002\u0006'\"|'\u000f\u001e\u0005\b\u0007\u001b\u0002A\u0011BB(\u0003=1W\r^2i\u0003N\u001cuN\\:v[\u0016\u0014HCDB)\u0007'\u001a)fa\u0016\u0004^\r\u000541\u000e\t\u0007\u0005o\u0013I+a<\t\u0011\u0005M71\na\u0001\u0003+D\u0001b!\n\u0004L\u0001\u0007\u0011q\u001c\u0005\t\u0003w\u001cY\u00051\u0001\u0004ZA!11\fB\u0004\u001d\u0011\tIKa\u0001\t\u0013\r}31\nI\u0001\u0002\u0004\u0011\u0016\u0001C7j]\nKH/Z:\t\u0015\r\r41\nI\u0001\u0002\u0004\u0019)'\u0001\bjg>d\u0017\r^5p]2+g/\u001a7\u0011\t\t\u00051qM\u0005\u0005\u0007S\nIM\u0001\bJg>d\u0017\r^5p]2+g/\u001a7\t\u0015\r541\nI\u0001\u0002\u0004\u0011\t\"\u0001\bdY&,g\u000e^'fi\u0006$\u0017\r^1\t\u000f\rE\u0004\u0001\"\u0003\u0004t\u0005ya-\u001a;dQ\u0006\u001bhi\u001c7m_^,'\u000f\u0006\b\u0004R\rU4qOB=\u0007w\u001aiha \t\u0011\u0005M7q\u000ea\u0001\u0003+D\u0001b!\n\u0004p\u0001\u0007\u0011q\u001c\u0005\t\u0003w\u001cy\u00071\u0001\u0004Z!I1qLB8!\u0003\u0005\rA\u0015\u0005\u000b\u0007G\u001ay\u0007%AA\u0002\r\u0015\u0004BCB7\u0007_\u0002\n\u00111\u0001\u0003\u0012!911\u0011\u0001\u0005\n\r\u0015\u0015!\u00044fi\u000eDW*Z:tC\u001e,7\u000f\u0006\t\u0004R\r\u001d5\u0011RBG\u0007\u001f\u001b\tja%\u0004\u0016\"A\u00111[BA\u0001\u0004\t)\u000eC\u0004\u0004\f\u000e\u0005\u0005\u0019\u0001*\u0002\u0013I,\u0007\u000f\\5dC&#\u0007\u0002CB\u0013\u0007\u0003\u0003\r!a8\t\u0011\u0005m8\u0011\u0011a\u0001\u00073Bqaa\u0018\u0004\u0002\u0002\u0007!\u000b\u0003\u0005\u0004d\r\u0005\u0005\u0019AB3\u0011!\u0019ig!!A\u0002\tE\u0001bBBM\u0001\u0011%11T\u0001)g\u0016$X\u000f\u001d*fa2L7-Y'b]\u0006<WM],ji\"lunY6fIB+(oZ1u_JLWm\u001d\u000b\u0007\u0003+\u001cija+\t\u0011\r}5q\u0013a\u0001\u0007C\u000bQ\u0001^5nKJ\u0004Baa)\u0004(6\u00111Q\u0015\u0006\u0004\u0007?+\u0013\u0002BBU\u0007K\u0013\u0011\"T8dWRKW.\u001a:\t\u0015\tU5q\u0013I\u0001\u0002\u0004\u0019i\u000bE\u0003\u0003\u001a\n}%\u000b\u0003\u0004\u00042\u0002!\t!\\\u00010i\u0016\u001cHo\u00147e\u0019\u0016\fG-\u001a:M_N,7/T3ue&\u001c7o\u00165f]J+\u0017m]:jO:\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004\u0007_s\bBBB\\\u0001\u0011\u0005Q.A\u0019uKN$x\n\u001c3G_2dwn^3s\u0019>\u001cXm]'fiJL7m],iK:\u0014V-Y:tS\u001et\u0007+\u0019:uSRLwN\\:)\u0007\rUf\u0010C\u0004\u0004>\u0002!Iaa0\u0002sA\u0014X\r]1sK\u0012KgMZ3sK:$(+\u001a9mS\u000e\fW*\u00198bO\u0016\u00148oV5uQ6{7m[3e\u0005J|7.\u001a:U_BL7m\u0015;biN$\"a!1\u0011\u0017%\u0019\u0019-!6\u0002V\u000e\u001d7qY\u0005\u0004\u0007\u000bT!A\u0002+va2,G\u0007E\u0002\u0013\u0007\u0013L1aa3\u0003\u0005A\u0011%o\\6feR{\u0007/[2Ti\u0006$8\u000fC\u0005\u0004P\u0002\t\n\u0011\"\u0003\u0004R\u00069\u0012\r\u001d9f]\u0012\u0014VmY8sIN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007'TCaa\u000f\u0004V.\u00121q\u001b\t\u0005\u00073\u001c\u0019/\u0004\u0002\u0004\\*!1Q\\Bp\u0003%)hn\u00195fG.,GMC\u0002\u0004b*\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0019)oa7\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0004j\u0002\t\n\u0011\"\u0003\u0004l\u00069\u0012\r\u001d9f]\u0012\u0014VmY8sIN$C-\u001a4bk2$H%N\u000b\u0003\u0007[TCa!\u0012\u0004V\"I1\u0011\u001f\u0001\u0012\u0002\u0013%11_\u00013g\u0016$X\u000f\u001d*fa2L7-Y'b]\u0006<WM],ji\"lunY6fIB+(oZ1u_JLWm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u00111Q\u001f\u0016\u0005\u0007[\u001b)\u000eC\u0005\u0004z\u0002\t\n\u0011\"\u0003\u0004|\u0006Ib-\u001a;dQ\u0006\u001bhi\u001c7m_^,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019iPK\u0002S\u0007+D\u0011\u0002\"\u0001\u0001#\u0003%I\u0001b\u0001\u00023\u0019,Go\u00195Bg\u001a{G\u000e\\8xKJ$C-\u001a4bk2$H%N\u000b\u0003\t\u000bQCa!\u001a\u0004V\"IA\u0011\u0002\u0001\u0012\u0002\u0013%A1B\u0001\u001aM\u0016$8\r[!t\r>dGn\\<fe\u0012\"WMZ1vYR$c'\u0006\u0002\u0005\u000e)\"!\u0011CBk\u0011%!\t\u0002AI\u0001\n\u0013\u0019Y0A\rgKR\u001c\u0007.Q:D_:\u001cX/\\3sI\u0011,g-Y;mi\u0012\"\u0004\"\u0003C\u000b\u0001E\u0005I\u0011\u0002C\u0002\u0003e1W\r^2i\u0003N\u001cuN\\:v[\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\t\u0013\u0011e\u0001!%A\u0005\n\u0011-\u0011!\u00074fi\u000eD\u0017i]\"p]N,X.\u001a:%I\u00164\u0017-\u001e7uIYB\u0011\u0002\"\b\u0001#\u0003%I\u0001b\b\u0002YA\u0014X\r]1sKJ+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006sG\rT8h\u001b\u0006t\u0017mZ3sI\u0011,g-Y;mi\u0012:TC\u0001C\u0011U\u0011\u00119g!6\t\u0013\u0011\u0015\u0002!%A\u0005\n\u0011\u001d\u0012aG:f]\u0012\u001cuN\\:v[\u0016\u0014h)\u001a;dQ\u0012\"WMZ1vYR$S'\u0006\u0002\u0005*)\u001aam!6")
public class ReplicaManagerTest {
    private final String topic;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private KafkaZkClient kafkaZkClient;
    private final int zkVersion;
    private final int correlationId;
    private int controllerEpoch = 0;
    private final long brokerEpoch;

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public KafkaZkClient kafkaZkClient() {
        return this.kafkaZkClient;
    }

    public void kafkaZkClient_$eq(KafkaZkClient x$1) {
        this.kafkaZkClient = x$1;
    }

    public int zkVersion() {
        return this.zkVersion;
    }

    public int correlationId() {
        return this.correlationId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public void controllerEpoch_$eq(int x$1) {
        this.controllerEpoch = x$1;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    @Before
    public void setUp() {
        this.kafkaZkClient_$eq((KafkaZkClient)EasyMock.createMock(KafkaZkClient.class));
        EasyMock.expect((Object)this.kafkaZkClient().getEntityConfigs(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)new Properties()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.kafkaZkClient()});
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighWaterMarkDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$1) {
                return new File(x$1);
            }
        }, Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            Partition partition = rm.createPartition(new TopicPartition(this.topic(), 1));
            partition.createLogIfNotExists(1, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(rm.highWatermarkCheckpoints()));
            rm.checkpointHighWatermarks();
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighwaterMarkRelativeDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$2) {
                return new File(x$2);
            }
        }, Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            Partition partition = rm.createPartition(new TopicPartition(this.topic(), 1));
            partition.createLogIfNotExists(1, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(rm.highWatermarkCheckpoints()));
            rm.checkpointHighWatermarks();
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIllegalRequiredAcks() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$3) {
                return new File(x$3);
            }
        }, Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), Option$.MODULE$.apply((Object)this.getClass().getName()));
        try {
            rm.appendRecords(0L, (short)3, false, (AppendOrigin)AppendOrigin.Client$.MODULE$, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test1", 0)), (Object)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes())}))})), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;

                public final void apply(Map<TopicPartition, ProduceResponse.PartitionResponse> responseStatus) {
                    this.$outer.kafka$server$ReplicaManagerTest$$callback$1(responseStatus);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, rm.appendRecords$default$7(), rm.appendRecords$default$8());
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearPurgatoryOnBecomingFollower() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$4) {
                return new File(x$4);
            }
        }, Seq$.MODULE$.canBuildFrom())), new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2()), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(0, "host0", 0, TestUtils$.MODULE$.createBroker$default$4()), TestUtils$.MODULE$.createBroker(1, "host1", 1, TestUtils$.MODULE$.createBroker$default$4())}));
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache});
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), metadataCache, new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = rm.createPartition(new TopicPartition(this.topic(), 0));
            partition.createLogIfNotExists(0, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(rm.highWatermarkCheckpoints()));
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(false)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$5, Iterable<Partition> x$6) {
                }
            });
            rm.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localLogOrException();
            MemoryRecords records2 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes())});
            CallbackResult<ProduceResponse.PartitionResponse> appendResult = this.kafka$server$ReplicaManagerTest$$appendRecords(rm, new TopicPartition(this.topic(), 0), records2, this.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ProduceResponse.PartitionResponse response) {
                    Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)response.error);
                }
            });
            LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(1).setLeaderEpoch(1).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(false)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(1, leaderAndIsrRequest2, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$7, Iterable<Partition> x$8) {
                }
            });
            Assert.assertTrue((boolean)appendResult.isFired());
        }
        catch (Throwable throwable) {
            void var7_7;
            var7_7.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReceiveOutOfOrderSequenceExceptionWithLogStartOffset() {
        MockTimer timer2 = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer2, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.createPartition(new TopicPartition(this.topic(), 0));
            partition.createLogIfNotExists(0, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints()));
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$9, Iterable<Partition> x$10) {
                }
            });
            replicaManager.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localLogOrException();
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(this, replicaManager, producerId, epoch){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager replicaManager$1;
                private final long producerId$1;
                private final short epoch$1;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int sequence) {
                    MemoryRecords records2 = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)this.producerId$1, (short)this.epoch$1, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sequence)})).getBytes())});
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$1, new TopicPartition(this.$outer.topic(), 0), records2, this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.replicaManager$1 = replicaManager$1;
                    this.producerId$1 = producerId$1;
                    this.epoch$1 = epoch$1;
                }
            });
            Assert.assertEquals((long)0L, (long)partition.logStartOffset());
            int outOfRangeSequence = numRecords + 10;
            MemoryRecords record = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)epoch, (int)outOfRangeSequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)outOfRangeSequence)})).getBytes())});
            this.kafka$server$ReplicaManagerTest$$appendRecords(replicaManager, new TopicPartition(this.topic(), 0), record, this.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ProduceResponse.PartitionResponse response) {
                    Assert.assertEquals((Object)Errors.OUT_OF_ORDER_SEQUENCE_NUMBER, (Object)response.error);
                    Assert.assertEquals((long)0L, (long)response.logStartOffset);
                }
            });
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown(false);
            throw throwable;
        }
        replicaManager.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReadCommittedFetchLimitedAtLSO() {
        MockTimer timer2 = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer2, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.createPartition(new TopicPartition(this.topic(), 0));
            partition.createLogIfNotExists(0, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints()));
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$11, Iterable<Partition> x$12) {
                }
            });
            replicaManager.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localLogOrException();
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(this, replicaManager, producerId, epoch){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager replicaManager$2;
                private final long producerId$2;
                private final short epoch$2;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int sequence) {
                    MemoryRecords records2 = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)this.producerId$2, (short)this.epoch$2, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sequence)})).getBytes())});
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$2, new TopicPartition(this.$outer.topic(), 0), records2, this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.replicaManager$2 = replicaManager$2;
                    this.producerId$2 = producerId$2;
                    this.epoch$2 = epoch$2;
                }
            });
            ReplicaManager x$68 = replicaManager;
            TopicPartition x$69 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$70 = new FetchRequest.PartitionData((long)numRecords, 0L, 100000, Optional.empty());
            IsolationLevel x$71 = IsolationLevel.READ_UNCOMMITTED;
            int x$72 = this.fetchAsFollower$default$4();
            Option<ClientMetadata> x$73 = this.fetchAsFollower$default$6();
            this.fetchAsFollower(x$68, x$69, x$70, x$72, x$71, x$73);
            ReplicaManager x$74 = replicaManager;
            TopicPartition x$75 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$76 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$77 = IsolationLevel.READ_COMMITTED;
            int x$78 = this.fetchAsConsumer$default$4();
            Option<ClientMetadata> x$79 = this.fetchAsConsumer$default$6();
            CallbackResult<FetchPartitionData> consumerFetchResult = this.fetchAsConsumer(x$74, x$75, x$76, x$78, x$77, x$79);
            FetchPartitionData fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            ReplicaManager x$80 = replicaManager;
            TopicPartition x$81 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$82 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$83 = IsolationLevel.READ_COMMITTED;
            int x$84 = 1000;
            Option<ClientMetadata> x$85 = this.fetchAsConsumer$default$6();
            consumerFetchResult = this.fetchAsConsumer(x$80, x$81, x$82, x$84, x$83, x$85);
            Assert.assertFalse((boolean)consumerFetchResult.isFired());
            timer2.advanceClock(1001L);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
            MemoryRecords commitRecordBatch = MemoryRecords.withEndTransactionMarker((long)producerId, (short)epoch, (EndTransactionMarker)endTxnMarker);
            this.kafka$server$ReplicaManagerTest$$appendRecords(replicaManager, new TopicPartition(this.topic(), 0), commitRecordBatch, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, this.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ProduceResponse.PartitionResponse response) {
                    Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                }
            });
            ReplicaManager x$86 = replicaManager;
            TopicPartition x$87 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$88 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$89 = IsolationLevel.READ_COMMITTED;
            int x$90 = this.fetchAsConsumer$default$4();
            Option<ClientMetadata> x$91 = this.fetchAsConsumer$default$6();
            consumerFetchResult = this.fetchAsConsumer(x$86, x$87, x$88, x$90, x$89, x$91);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            ReplicaManager x$92 = replicaManager;
            TopicPartition x$93 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$94 = new FetchRequest.PartitionData((long)(numRecords + 1), 0L, 100000, Optional.empty());
            IsolationLevel x$95 = IsolationLevel.READ_UNCOMMITTED;
            int x$96 = this.fetchAsFollower$default$4();
            Option<ClientMetadata> x$97 = this.fetchAsFollower$default$6();
            this.fetchAsFollower(x$92, x$93, x$94, x$96, x$95, x$97);
            ReplicaManager x$98 = replicaManager;
            TopicPartition x$99 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$100 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$101 = IsolationLevel.READ_COMMITTED;
            int x$102 = this.fetchAsConsumer$default$4();
            Option<ClientMetadata> x$103 = this.fetchAsConsumer$default$6();
            consumerFetchResult = this.fetchAsConsumer(x$98, x$99, x$100, x$102, x$101, x$103);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(numRecords + 1))), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            Assert.assertEquals((long)(numRecords + 1), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).size());
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown(false);
            throw throwable;
        }
        replicaManager.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDelayedFetchIncludesAbortedTransactions() {
        MockTimer timer2 = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer2, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.createPartition(new TopicPartition(this.topic(), 0));
            partition.createLogIfNotExists(0, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints()));
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$13, Iterable<Partition> x$14) {
                }
            });
            replicaManager.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localLogOrException();
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(this, replicaManager, producerId, epoch){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager replicaManager$3;
                private final long producerId$3;
                private final short epoch$3;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int sequence) {
                    MemoryRecords records2 = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)this.producerId$3, (short)this.epoch$3, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sequence)})).getBytes())});
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$3, new TopicPartition(this.$outer.topic(), 0), records2, this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.replicaManager$3 = replicaManager$3;
                    this.producerId$3 = producerId$3;
                    this.epoch$3 = epoch$3;
                }
            });
            EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.ABORT, 0);
            MemoryRecords abortRecordBatch = MemoryRecords.withEndTransactionMarker((long)producerId, (short)epoch, (EndTransactionMarker)endTxnMarker);
            this.kafka$server$ReplicaManagerTest$$appendRecords(replicaManager, new TopicPartition(this.topic(), 0), abortRecordBatch, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, this.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ProduceResponse.PartitionResponse response) {
                    Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                }
            });
            ReplicaManager x$104 = replicaManager;
            TopicPartition x$105 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$106 = new FetchRequest.PartitionData((long)(numRecords + 1), 0L, 100000, Optional.empty());
            IsolationLevel x$107 = IsolationLevel.READ_UNCOMMITTED;
            int x$108 = this.fetchAsFollower$default$4();
            Option<ClientMetadata> x$109 = this.fetchAsFollower$default$6();
            this.fetchAsFollower(x$104, x$105, x$106, x$108, x$107, x$109);
            ReplicaManager x$110 = replicaManager;
            TopicPartition x$111 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$112 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$113 = IsolationLevel.READ_COMMITTED;
            int x$114 = 10000;
            Option<ClientMetadata> x$115 = this.fetchAsConsumer$default$6();
            CallbackResult<FetchPartitionData> fetchResult = this.fetchAsConsumer(x$110, x$111, x$112, x$114, x$113, x$115);
            Assert.assertFalse((boolean)fetchResult.isFired());
            timer2.advanceClock(1001L);
            FetchPartitionData fetchData = fetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(numRecords + 1))), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((long)(numRecords + 1), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().records()).asScala()).size());
            Assert.assertTrue((boolean)fetchData.abortedTransactions().isDefined());
            Assert.assertEquals((long)1L, (long)((SeqLike)fetchData.abortedTransactions().get()).size());
            FetchResponse.AbortedTransaction abortedTransaction = (FetchResponse.AbortedTransaction)((IterableLike)fetchData.abortedTransactions().get()).head();
            Assert.assertEquals((long)0L, (long)abortedTransaction.firstOffset);
            Assert.assertEquals((long)producerId, (long)abortedTransaction.producerId);
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown(false);
            throw throwable;
        }
        replicaManager.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchBeyondHighWatermarkReturnEmptyResponse() {
        ReplicaManager rm = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava();
            Partition partition = rm.createPartition(new TopicPartition(this.topic(), 0));
            partition.createLogIfNotExists(0, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(rm.highWatermarkCheckpoints()));
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(false)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1), new Node(2, "host2", 2)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$15, Iterable<Partition> x$16) {
                }
            });
            rm.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localLogOrException();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach((Function1)new Serializable(this, rm){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager rm$1;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int i) {
                    MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.rm$1, new TopicPartition(this.$outer.topic(), 0), records2, this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.rm$1 = rm$1;
                }
            });
            CallbackResult<FetchPartitionData> followerFetchResult = this.fetchAsFollower(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty()), this.fetchAsFollower$default$4(), this.fetchAsFollower$default$5(), this.fetchAsFollower$default$6());
            FetchPartitionData followerFetchData = followerFetchResult.assertFired();
            Assert.assertEquals((String)"Should not give an exception", (Object)Errors.NONE, (Object)followerFetchData.error());
            Assert.assertTrue((String)"Should return some data", (boolean)followerFetchData.records().batches().iterator().hasNext());
            CallbackResult<FetchPartitionData> consumerFetchResult = this.fetchAsConsumer(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty()), this.fetchAsConsumer$default$4(), this.fetchAsConsumer$default$5(), this.fetchAsConsumer$default$6());
            FetchPartitionData consumerFetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((String)"Should not give an exception", (Object)Errors.NONE, (Object)consumerFetchData.error());
            Assert.assertEquals((String)"Should return empty response", (Object)MemoryRecords.EMPTY, (Object)consumerFetchData.records());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFollowerStateNotUpdatedIfLogReadFails() {
        int maxFetchBytes = 0x100000;
        Seq aliveBrokersIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        int leaderEpoch = 5;
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)aliveBrokersIds);
        try {
            TopicPartition tp = new TopicPartition(this.topic(), 0);
            List replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)aliveBrokersIds.toList().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Integer apply(int x) {
                    return BoxesRunTime.boxToInteger((int)x);
                }
            }, List$.MODULE$.canBuildFrom())).asJava();
            LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrPartitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(0).setReplicas(replicas).setIsNew(true);
            LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{leaderAndIsrPartitionState}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            LeaderAndIsrResponse leaderAndIsrResponse = replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$17, Iterable<Partition> x$18) {
                }
            });
            Assert.assertEquals((Object)Errors.NONE, (Object)leaderAndIsrResponse.error());
            Assert.assertTrue((boolean)replicaManager.nonOfflinePartition(tp).isDefined());
            Partition partition = (Partition)replicaManager.nonOfflinePartition(tp).get();
            Assert.assertTrue((boolean)partition.getReplica(1).isDefined());
            Replica followerReplica = (Replica)partition.getReplica(1).get();
            Assert.assertEquals((long)-1L, (long)followerReplica.logStartOffset());
            Assert.assertEquals((long)-1L, (long)followerReplica.logEndOffset());
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).foreach((Function1)new Serializable(this, replicaManager, tp){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager replicaManager$4;
                private final TopicPartition tp$1;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int i) {
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$4, this.tp$1, TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.replicaManager$4 = replicaManager$4;
                    this.tp$1 = tp$1;
                }
            });
            ObjectRef successfulFetch = ObjectRef.create((Object)None$.MODULE$);
            FetchRequest.PartitionData validFetchPartitionData = new FetchRequest.PartitionData(0L, 0L, maxFetchBytes, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)));
            long x$116 = 0L;
            int x$117 = 1;
            int x$118 = 1;
            int x$119 = maxFetchBytes;
            boolean x$120 = false;
            Seq x$121 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)validFetchPartitionData)}));
            QuotaFactory.UnboundedQuota$ x$122 = QuotaFactory.UnboundedQuota$.MODULE$;
            IsolationLevel x$123 = IsolationLevel.READ_UNCOMMITTED;
            Serializable x$124 = new Serializable(this, tp, successfulFetch){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final TopicPartition tp$1;
                private final ObjectRef successfulFetch$1;

                public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> response) {
                    this.$outer.kafka$server$ReplicaManagerTest$$callback$2(response, this.tp$1, this.successfulFetch$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.tp$1 = tp$1;
                    this.successfulFetch$1 = successfulFetch$1;
                }
            };
            None$ x$125 = None$.MODULE$;
            replicaManager.fetchMessages(x$116, x$117, x$118, x$119, x$120, x$121, (ReplicaQuota)x$122, (Function1)x$124, x$123, (Option)x$125);
            Assert.assertTrue((boolean)((Option)successfulFetch.elem).isDefined());
            Assert.assertEquals((long)0L, (long)followerReplica.logStartOffset());
            Assert.assertEquals((long)0L, (long)followerReplica.logEndOffset());
            FetchRequest.PartitionData invalidFetchPartitionData = new FetchRequest.PartitionData(3L, 0L, maxFetchBytes, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)));
            long x$126 = 0L;
            int x$127 = 1;
            int x$128 = 1;
            int x$129 = maxFetchBytes;
            boolean x$130 = false;
            Seq x$131 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)invalidFetchPartitionData)}));
            QuotaFactory.UnboundedQuota$ x$132 = QuotaFactory.UnboundedQuota$.MODULE$;
            IsolationLevel x$133 = IsolationLevel.READ_UNCOMMITTED;
            Serializable x$134 = new Serializable(this, tp, successfulFetch){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final TopicPartition tp$1;
                private final ObjectRef successfulFetch$1;

                public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> response) {
                    this.$outer.kafka$server$ReplicaManagerTest$$callback$2(response, this.tp$1, this.successfulFetch$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.tp$1 = tp$1;
                    this.successfulFetch$1 = successfulFetch$1;
                }
            };
            None$ x$135 = None$.MODULE$;
            replicaManager.fetchMessages(x$126, x$127, x$128, x$129, x$130, x$131, (ReplicaQuota)x$132, (Function1)x$134, x$133, (Option)x$135);
            Assert.assertTrue((boolean)((Option)successfulFetch.elem).isDefined());
            Assert.assertEquals((long)0L, (long)followerReplica.logStartOffset());
            Assert.assertEquals((long)0L, (long)followerReplica.logEndOffset());
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.shutdown(false);
            throw throwable;
        }
        replicaManager.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchMessagesWhenNotFollowerForOnePartition() {
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        try {
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            TopicPartition tp1 = new TopicPartition(this.topic(), 1);
            LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
            replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
            replicaManager.createPartition(tp1).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
            List partition0Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            List partition1Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(2)}))).asJava();
            LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp1.topic()).setPartitionIndex(tp1.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(partition1Replicas).setZkVersion(0).setReplicas(partition1Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$21, Iterable<Partition> x$22) {
                }
            });
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach((Function1)new Serializable(this, replicaManager, tp0, tp1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager replicaManager$5;
                private final TopicPartition tp0$1;
                private final TopicPartition tp1$1;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int i) {
                    this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$5, this.tp0$1, TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$5, this.tp1$1, TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.replicaManager$5 = replicaManager$5;
                    this.tp0$1 = tp0$1;
                    this.tp1$1 = tp1$1;
                }
            });
            replicaManager.fetchMessages(1000L, 1, 0, Integer.MAX_VALUE, false, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty()))})), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, (Function1)new Serializable(this, tp0, tp1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final TopicPartition tp0$1;
                private final TopicPartition tp1$1;

                public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responseStatus) {
                    this.$outer.kafka$server$ReplicaManagerTest$$fetchCallback$1(responseStatus, this.tp0$1, this.tp1$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.tp0$1 = tp0$1;
                    this.tp1$1 = tp1$1;
                }
            }, IsolationLevel.READ_UNCOMMITTED, (Option)None$.MODULE$);
            Option tp0Log = replicaManager.localLog(tp0);
            Assert.assertTrue((boolean)tp0Log.isDefined());
            Assert.assertEquals((String)"hw should be incremented", (long)1L, (long)((Log)tp0Log.get()).highWatermark());
            replicaManager.localLog(tp1);
            Option tp1Replica = replicaManager.localLog(tp1);
            Assert.assertTrue((boolean)tp1Replica.isDefined());
            Assert.assertEquals((String)"hw should not be incremented", (long)0L, (long)((Log)tp1Replica.get()).highWatermark());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown(false);
            throw throwable;
        }
        replicaManager.shutdown(false);
    }

    @Test
    public void testBecomeFollowerWhenLeaderIsUnchangedButMissedLeaderUpdate() {
        int topicPartition = 0;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        Seq aliveBrokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(followerBrokerId), Predef$.MODULE$.int2Integer(leaderBrokerId)}));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Tuple2<ReplicaManager, LogManager> tuple2 = this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true, this.prepareReplicaManagerAndLogManager$default$7());
        if (tuple2 != null) {
            Tuple2 tuple22;
            ReplicaManager replicaManager = (ReplicaManager)tuple2._1();
            LogManager mockLogMgr = (LogManager)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)replicaManager, (Object)mockLogMgr);
            ReplicaManager replicaManager2 = (ReplicaManager)tuple23._1();
            LogManager mockLogMgr2 = (LogManager)tuple23._2();
            TopicPartition tp = new TopicPartition(this.topic(), topicPartition);
            Partition partition = replicaManager2.createPartition(tp);
            LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager2.highWatermarkCheckpoints());
            partition.createLogIfNotExists(followerBrokerId, false, false, (OffsetCheckpoints)offsetCheckpoints);
            partition.makeFollower(controllerId, this.leaderAndIsrPartitionState(tp, leaderEpoch, leaderBrokerId, (Seq<Integer>)aliveBrokerIds), this.correlationId(), (OffsetCheckpoints)offsetCheckpoints);
            LeaderAndIsrRequest leaderAndIsrRequest0 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, controllerEpoch, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{this.leaderAndIsrPartitionState(tp, leaderEpoch += leaderEpochIncrement, leaderBrokerId, (Seq<Integer>)aliveBrokerIds)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(followerBrokerId, "host1", 0), new Node(leaderBrokerId, "host2", 1)}))).asJava()).build();
            replicaManager2.becomeLeaderOrFollower(this.correlationId(), leaderAndIsrRequest0, (Function2)new Serializable(this, followerBrokerId){
                public static final long serialVersionUID = 0L;
                private final int followerBrokerId$1;

                public final void apply(Iterable<Partition> x$24, Iterable<Partition> followers) {
                    Assert.assertEquals((long)this.followerBrokerId$1, (long)((Partition)followers.head()).partitionId());
                }
                {
                    this.followerBrokerId$1 = followerBrokerId$1;
                }
            });
            Assert.assertTrue((boolean)countDownLatch.await(1000L, TimeUnit.MILLISECONDS));
            EasyMock.verify((Object[])new Object[]{mockLogMgr2});
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testReplicaSelector() {
        int topicPartition = 0;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        int controllerId = 0;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        Seq aliveBrokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(followerBrokerId), Predef$.MODULE$.int2Integer(leaderBrokerId)}));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Tuple2<ReplicaManager, LogManager> tuple2 = this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true, this.prepareReplicaManagerAndLogManager$default$7());
        if (tuple2 != null) {
            ReplicaManager replicaManager;
            ReplicaManager replicaManager2;
            ReplicaManager replicaManager3 = replicaManager2 = (replicaManager = (ReplicaManager)tuple2._1());
            TopicPartition tp = new TopicPartition(this.topic(), topicPartition);
            Partition partition = replicaManager3.createPartition(tp);
            LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager3.highWatermarkCheckpoints());
            partition.createLogIfNotExists(leaderBrokerId, false, false, (OffsetCheckpoints)offsetCheckpoints);
            partition.makeLeader(controllerId, this.leaderAndIsrPartitionState(tp, leaderEpoch, leaderBrokerId, (Seq<Integer>)aliveBrokerIds), this.correlationId(), (OffsetCheckpoints)offsetCheckpoints);
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            ClientMetadata.DefaultClientMetadata metadata = new ClientMetadata.DefaultClientMetadata("rack-a", "client-id", InetAddress.getByName("localhost"), KafkaPrincipal.ANONYMOUS, "default");
            Option preferredReadReplica = replicaManager3.findPreferredReadReplica(tp0, (ClientMetadata)metadata, Request$.MODULE$.OrdinaryConsumerId(), 1L, System.currentTimeMillis());
            Assert.assertFalse((boolean)preferredReadReplica.isDefined());
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testPreferredReplicaAsFollower() {
        int topicPartition = 0;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Tuple2<ReplicaManager, LogManager> tuple2 = this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true, this.prepareReplicaManagerAndLogManager$default$7());
        if (tuple2 != null) {
            ReplicaManager replicaManager;
            ReplicaManager replicaManager2;
            ReplicaManager replicaManager3 = replicaManager2 = (replicaManager = (ReplicaManager)tuple2._1());
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            replicaManager3.createPartition(new TopicPartition(this.topic(), 0));
            LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(1).setLeaderEpoch(1).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(false)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager3.becomeLeaderOrFollower(1, leaderAndIsrRequest2, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$25, Iterable<Partition> x$26) {
                }
            });
            ClientMetadata.DefaultClientMetadata metadata = new ClientMetadata.DefaultClientMetadata("rack-a", "client-id", InetAddress.getByName("localhost"), KafkaPrincipal.ANONYMOUS, "default");
            ReplicaManager x$136 = replicaManager3;
            TopicPartition x$137 = tp0;
            FetchRequest.PartitionData x$138 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            Some x$139 = new Some((Object)metadata);
            int x$140 = this.fetchAsConsumer$default$4();
            IsolationLevel x$141 = this.fetchAsConsumer$default$5();
            CallbackResult<FetchPartitionData> consumerResult = this.fetchAsConsumer(x$136, x$137, x$138, x$140, x$141, (Option<ClientMetadata>)x$139);
            Assert.assertTrue((boolean)consumerResult.isFired());
            Assert.assertTrue((boolean)consumerResult.assertFired().preferredReadReplica().isEmpty());
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testPreferredReplicaAsLeader() {
        int topicPartition = 0;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Tuple2<ReplicaManager, LogManager> tuple2 = this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true, this.prepareReplicaManagerAndLogManager$default$7());
        if (tuple2 != null) {
            ReplicaManager replicaManager;
            ReplicaManager replicaManager2;
            ReplicaManager replicaManager3 = replicaManager2 = (replicaManager = (ReplicaManager)tuple2._1());
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            replicaManager3.createPartition(new TopicPartition(this.topic(), 0));
            LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(1).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(false)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager3.becomeLeaderOrFollower(1, leaderAndIsrRequest2, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$27, Iterable<Partition> x$28) {
                }
            });
            ClientMetadata.DefaultClientMetadata metadata = new ClientMetadata.DefaultClientMetadata("rack-a", "client-id", InetAddress.getByName("localhost"), KafkaPrincipal.ANONYMOUS, "default");
            ReplicaManager x$142 = replicaManager3;
            TopicPartition x$143 = tp0;
            FetchRequest.PartitionData x$144 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            Some x$145 = new Some((Object)metadata);
            int x$146 = this.fetchAsConsumer$default$4();
            IsolationLevel x$147 = this.fetchAsConsumer$default$5();
            CallbackResult<FetchPartitionData> consumerResult = this.fetchAsConsumer(x$142, x$143, x$144, x$146, x$147, (Option<ClientMetadata>)x$145);
            Assert.assertTrue((boolean)consumerResult.isFired());
            Assert.assertFalse((boolean)consumerResult.assertFired().preferredReadReplica().isDefined());
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test(expected=ClassNotFoundException.class)
    public void testUnknownReplicaSelector() {
        int topicPartition = 0;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ReplicaSelectorClassProp(), "non-a-class");
        this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true, props);
    }

    @Test
    public void testDefaultReplicaSelector() {
        int topicPartition = 0;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Tuple2<ReplicaManager, LogManager> tuple2 = this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true, this.prepareReplicaManagerAndLogManager$default$7());
        if (tuple2 != null) {
            ReplicaManager replicaManager;
            ReplicaManager replicaManager2;
            ReplicaManager replicaManager3 = replicaManager2 = (replicaManager = (ReplicaManager)tuple2._1());
            Assert.assertFalse((boolean)replicaManager3.replicaSelectorOpt().isDefined());
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testFetchFollowerNotAllowedForOlderClients() {
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
        replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
        List partition0Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        LeaderAndIsrRequest becomeFollowerRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(1).setLeaderEpoch(0).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(0, becomeFollowerRequest, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Iterable<Partition> x$29, Iterable<Partition> x$30) {
            }
        });
        ClientMetadata.DefaultClientMetadata clientMetadata = new ClientMetadata.DefaultClientMetadata("", "", null, KafkaPrincipal.ANONYMOUS, "");
        FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(0)));
        AtomicReference<FetchPartitionData> fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)new Some((Object)clientMetadata), this.sendConsumerFetch$default$5());
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.NONE, (Object)fetchResult.get().error());
        partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(0)));
        fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)None$.MODULE$, this.sendConsumerFetch$default$5());
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)fetchResult.get().error());
    }

    @Test
    public void testBecomeFollowerWhileOldClientFetchInPurgatory() {
        MockTimer mockTimer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(mockTimer, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
        replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
        List partition0Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        LeaderAndIsrRequest becomeLeaderRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(1).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(1, becomeLeaderRequest, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Iterable<Partition> x$31, Iterable<Partition> x$32) {
            }
        });
        FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty());
        AtomicReference<FetchPartitionData> fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)None$.MODULE$, 10L);
        Assert.assertNull((Object)fetchResult.get());
        LeaderAndIsrRequest becomeFollowerRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(1).setLeaderEpoch(2).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(0, becomeFollowerRequest, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Iterable<Partition> x$33, Iterable<Partition> x$34) {
            }
        });
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)fetchResult.get().error());
    }

    @Test
    public void testBecomeFollowerWhileNewClientFetchInPurgatory() {
        MockTimer mockTimer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(mockTimer, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
        replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
        List partition0Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        LeaderAndIsrRequest becomeLeaderRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(1).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(1, becomeLeaderRequest, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Iterable<Partition> x$35, Iterable<Partition> x$36) {
            }
        });
        ClientMetadata.DefaultClientMetadata clientMetadata = new ClientMetadata.DefaultClientMetadata("", "", null, KafkaPrincipal.ANONYMOUS, "");
        FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(1)));
        AtomicReference<FetchPartitionData> fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)new Some((Object)clientMetadata), 10L);
        Assert.assertNull((Object)fetchResult.get());
        LeaderAndIsrRequest becomeFollowerRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(1).setLeaderEpoch(2).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(0, becomeFollowerRequest, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Iterable<Partition> x$37, Iterable<Partition> x$38) {
            }
        });
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)fetchResult.get().error());
    }

    @Test
    public void testFetchFromLeaderAlwaysAllowed() {
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
        replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
        List partition0Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        LeaderAndIsrRequest becomeLeaderRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(1).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(1, becomeLeaderRequest, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Iterable<Partition> x$39, Iterable<Partition> x$40) {
            }
        });
        ClientMetadata.DefaultClientMetadata clientMetadata = new ClientMetadata.DefaultClientMetadata("", "", null, KafkaPrincipal.ANONYMOUS, "");
        FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(1)));
        AtomicReference<FetchPartitionData> fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)new Some((Object)clientMetadata), this.sendConsumerFetch$default$5());
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.NONE, (Object)fetchResult.get().error());
        partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty());
        fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)new Some((Object)clientMetadata), this.sendConsumerFetch$default$5());
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.NONE, (Object)fetchResult.get().error());
    }

    @Test
    public void testClearFetchPurgatoryOnStopReplica() {
        MockTimer mockTimer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(mockTimer, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
        replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
        List partition0Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        LeaderAndIsrRequest becomeLeaderRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(1).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(1, becomeLeaderRequest, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Iterable<Partition> x$41, Iterable<Partition> x$42) {
            }
        });
        FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(1)));
        AtomicReference<FetchPartitionData> fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)None$.MODULE$, 10L);
        Assert.assertNull((Object)fetchResult.get());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.metadataCache().contains(tp0))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        replicaManager.stopReplica(tp0, true);
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)fetchResult.get().error());
    }

    @Test
    public void testClearProducePurgatoryOnStopReplica() {
        MockTimer mockTimer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(mockTimer, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
        replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
        List partition0Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        LeaderAndIsrRequest becomeLeaderRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(1).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(1, becomeLeaderRequest, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Iterable<Partition> x$43, Iterable<Partition> x$44) {
            }
        });
        AtomicReference<ProduceResponse.PartitionResponse> produceResult = this.sendProducerAppend(replicaManager, tp0);
        Assert.assertNull((Object)produceResult.get());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.metadataCache().contains(tp0))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        replicaManager.stopReplica(tp0, true);
        Assert.assertNotNull((Object)produceResult.get());
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)produceResult.get().error);
    }

    /*
     * WARNING - void declaration
     */
    private AtomicReference<ProduceResponse.PartitionResponse> sendProducerAppend(ReplicaManager replicaManager, TopicPartition topicPartition) {
        void var3_3;
        AtomicReference produceResult = new AtomicReference();
        MemoryRecords records2 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes()), new SimpleRecord("c".getBytes())});
        replicaManager.appendRecords(10L, (short)-1, false, (AppendOrigin)AppendOrigin.Client$.MODULE$, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records2)})), (Function1)new Serializable(this, topicPartition, produceResult){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerTest $outer;
            private final TopicPartition topicPartition$3;
            private final AtomicReference produceResult$1;

            public final void apply(Map<TopicPartition, ProduceResponse.PartitionResponse> response) {
                this.$outer.kafka$server$ReplicaManagerTest$$callback$3(response, this.topicPartition$3, this.produceResult$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$3 = topicPartition$3;
                this.produceResult$1 = produceResult$1;
            }
        }, replicaManager.appendRecords$default$7(), replicaManager.appendRecords$default$8());
        return var3_3;
    }

    private AtomicReference<FetchPartitionData> sendConsumerFetch(ReplicaManager replicaManager, TopicPartition topicPartition, FetchRequest.PartitionData partitionData, Option<ClientMetadata> clientMetadataOpt, long timeout) {
        AtomicReference<FetchPartitionData> fetchResult = new AtomicReference<FetchPartitionData>();
        long x$148 = timeout;
        int x$149 = Request$.MODULE$.OrdinaryConsumerId();
        int x$150 = 1;
        int x$151 = 100;
        boolean x$152 = false;
        Seq x$153 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)partitionData)}));
        QuotaFactory.UnboundedQuota$ x$154 = QuotaFactory.UnboundedQuota$.MODULE$;
        IsolationLevel x$155 = IsolationLevel.READ_UNCOMMITTED;
        Serializable x$156 = new Serializable(this, topicPartition, fetchResult){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerTest $outer;
            private final TopicPartition topicPartition$2;
            private final AtomicReference fetchResult$1;

            public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> response) {
                this.$outer.kafka$server$ReplicaManagerTest$$callback$4(response, this.topicPartition$2, this.fetchResult$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$2 = topicPartition$2;
                this.fetchResult$1 = fetchResult$1;
            }
        };
        Option<ClientMetadata> x$157 = clientMetadataOpt;
        replicaManager.fetchMessages(x$148, x$149, x$150, x$151, x$152, x$153, (ReplicaQuota)x$154, (Function1)x$156, x$155, x$157);
        return fetchResult;
    }

    private long sendConsumerFetch$default$5() {
        return 0L;
    }

    private Tuple2<ReplicaManager, LogManager> prepareReplicaManagerAndLogManager(int topicPartition, int leaderEpochInLeaderAndIsr, int followerBrokerId, int leaderBrokerId, CountDownLatch countDownLatch, boolean expectTruncation, Properties extraProps) {
        BoxedUnit boxedUnit;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        ((Growable)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(extraProps).asScala());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        int localLogOffset = 10;
        int offsetFromLeader = 5;
        int leaderEpochFromLeader = 3;
        MockScheduler mockScheduler = new MockScheduler((Time)this.time());
        BrokerTopicStats mockBrokerTopicStats = new BrokerTopicStats();
        LogDirFailureChannel mockLogDirFailureChannel = new LogDirFailureChannel(config.logDirs().size());
        Log mockLog = new Log(this, topicPartition, config, localLogOffset, leaderEpochFromLeader, mockScheduler, mockBrokerTopicStats, mockLogDirFailureChannel){
            private final int localLogOffset$1;
            private final int leaderEpochFromLeader$1;

            public Option<OffsetAndEpoch> endOffsetForEpoch(int leaderEpoch) {
                Assert.assertEquals((long)leaderEpoch, (long)this.leaderEpochFromLeader$1);
                return new Some((Object)new OffsetAndEpoch((long)this.localLogOffset$1, this.leaderEpochFromLeader$1));
            }

            public Option<Object> latestEpoch() {
                return new Some((Object)BoxesRunTime.boxToInteger((int)this.leaderEpochFromLeader$1));
            }

            public LogOffsetMetadata logEndOffsetMetadata() {
                return new LogOffsetMetadata((long)this.localLogOffset$1, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3());
            }

            public long logEndOffset() {
                return this.localLogOffset$1;
            }
            {
                this.localLogOffset$1 = localLogOffset$1;
                this.leaderEpochFromLeader$1 = leaderEpochFromLeader$1;
                super(new File(new File((String)config$1.logDirs().head()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$outer.topic()}))), LogConfig$.MODULE$.apply(), 0L, 0L, (Scheduler)mockScheduler$1, mockBrokerTopicStats$1, (Time)$outer.time(), 30000, 30000, new TopicPartition($outer.topic(), topicPartition$1), new ProducerStateManager(new TopicPartition($outer.topic(), topicPartition$1), new File(new File((String)config$1.logDirs().head()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$outer.topic(), BoxesRunTime.boxToInteger((int)topicPartition$1)}))), 30000), mockLogDirFailureChannel$1);
            }
        };
        TopicPartition topicPartitionObj = new TopicPartition(this.topic(), topicPartition);
        LogManager mockLogMgr = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)mockLogMgr.liveLogDirs()).andReturn(config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$45) {
                return new File(x$45).getAbsoluteFile();
            }
        }, Seq$.MODULE$.canBuildFrom())).anyTimes();
        EasyMock.expect((Object)mockLogMgr.currentDefaultConfig()).andReturn((Object)LogConfig$.MODULE$.apply());
        EasyMock.expect((Object)mockLogMgr.getOrCreateLog(topicPartitionObj, LogConfig$.MODULE$.apply(), false, false)).andReturn((Object)mockLog).anyTimes();
        if (expectTruncation) {
            mockLogMgr.truncateTo((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartitionObj), (Object)BoxesRunTime.boxToLong((long)offsetFromLeader))})), false);
            boxedUnit = EasyMock.expect((Object)BoxedUnit.UNIT).once();
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        mockLogMgr.initializingLog(topicPartitionObj);
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        mockLogMgr.finishedInitializingLog((TopicPartition)EasyMock.eq((Object)topicPartitionObj), (Option)EasyMock.anyObject(), (Function0)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockLogMgr});
        Seq aliveBrokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(followerBrokerId), Predef$.MODULE$.int2Integer(leaderBrokerId)}));
        Seq aliveBrokers = (Seq)aliveBrokerIds.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Broker apply(Integer brokerId) {
                return TestUtils$.MODULE$.createBroker(Predef$.MODULE$.Integer2int(brokerId), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{brokerId})), Predef$.MODULE$.Integer2int(brokerId), TestUtils$.MODULE$.createBroker$default$4());
            }
        }, Seq$.MODULE$.canBuildFrom());
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        aliveBrokerIds.foreach((Function1)new Serializable(this, metadataCache){
            public static final long serialVersionUID = 0L;
            private final MetadataCache metadataCache$1;

            public final IExpectationSetters<Option<Broker>> apply(Integer brokerId) {
                return EasyMock.expect((Object)this.metadataCache$1.getAliveBroker(BoxesRunTime.unboxToInt((Object)EasyMock.eq((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(brokerId)))))).andReturn((Object)Option$.MODULE$.apply((Object)TestUtils$.MODULE$.createBroker(Predef$.MODULE$.Integer2int(brokerId), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{brokerId})), Predef$.MODULE$.Integer2int(brokerId), TestUtils$.MODULE$.createBroker$default$4()))).anyTimes();
            }
            {
                this.metadataCache$1 = metadataCache$1;
            }
        });
        EasyMock.expect((Object)metadataCache.getPartitionReplicaEndpoints((TopicPartition)EasyMock.anyObject(), (ListenerName)EasyMock.anyObject())).andReturn((Object)((TraversableOnce)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)leaderBrokerId)), (Object)new Node(leaderBrokerId, "host1", 9092, "rack-a")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)followerBrokerId)), (Object)new Node(followerBrokerId, "host2", 9092, "rack-b"))}))).toMap(Predef$.MODULE$.$conforms())).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache});
        MockTimer timer2 = new MockTimer();
        String x$158 = "Produce";
        MockTimer x$159 = timer2;
        boolean x$160 = false;
        int x$161 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$162 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$163 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockProducePurgatory = new DelayedOperationPurgatory(x$158, (Timer)x$159, x$161, x$162, x$160, x$163);
        String x$164 = "Fetch";
        MockTimer x$165 = timer2;
        boolean x$166 = false;
        int x$167 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$168 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$169 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockFetchPurgatory = new DelayedOperationPurgatory(x$164, (Timer)x$165, x$167, x$168, x$166, x$169);
        String x$170 = "DeleteRecords";
        MockTimer x$171 = timer2;
        boolean x$172 = false;
        int x$173 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$174 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$175 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDeleteRecordsPurgatory = new DelayedOperationPurgatory(x$170, (Timer)x$171, x$173, x$174, x$172, x$175);
        String x$176 = "ElectLeader";
        MockTimer x$177 = timer2;
        boolean x$178 = false;
        int x$179 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$180 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$181 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockElectLeaderPurgatory = new DelayedOperationPurgatory(x$176, (Timer)x$177, x$179, x$180, x$178, x$181);
        QuotaFactory.QuotaManagers quota = QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), "");
        ReplicaFetcherMockBlockingSend blockingSend = new ReplicaFetcherMockBlockingSend((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartitionObj), (Object)new EpochEndOffset(leaderEpochFromLeader, (long)offsetFromLeader))}))).asJava(), new BrokerEndPoint(1, "host1", 1), (Time)this.time());
        ReplicaManager replicaManager = new ReplicaManager(this, topicPartition, leaderEpochInLeaderAndIsr, countDownLatch, config, mockScheduler, mockBrokerTopicStats, mockLogDirFailureChannel, mockLogMgr, metadataCache, mockProducePurgatory, mockFetchPurgatory, mockDeleteRecordsPurgatory, mockElectLeaderPurgatory, quota, blockingSend){
            private final /* synthetic */ ReplicaManagerTest $outer;
            public final int topicPartition$1;
            public final int leaderEpochInLeaderAndIsr$1;
            public final CountDownLatch countDownLatch$1;
            public final QuotaFactory.QuotaManagers quota$1;
            public final ReplicaFetcherMockBlockingSend blockingSend$1;

            public ReplicaFetcherManager createReplicaFetcherManager(Metrics metrics, Time time, Option<String> threadNamePrefix, ReplicationQuotaManager quotaManager) {
                return new ReplicaFetcherManager(this, metrics, time, threadNamePrefix, quotaManager){
                    private final /* synthetic */ $anon$4 $outer;
                    public final Metrics metrics$1;
                    public final Time time$1;

                    public ReplicaFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                        return new ReplicaFetcherThread(this, fetcherId, sourceBroker){
                            private final /* synthetic */ $anon$4$$anon$2 $outer;

                            public void doWork() {
                                OffsetAndEpoch initialOffset = new OffsetAndEpoch(0L, this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().leaderEpochInLeaderAndIsr$1);
                                this.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().kafka$server$ReplicaManagerTest$$anon$$$outer().topic(), this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().topicPartition$1)), (Object)initialOffset)})));
                                super.doWork();
                                this.initiateShutdown();
                                this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().countDownLatch$1.countDown();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ReplicaFetcherThread-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)fetcherId$1)})), fetcherId$1, sourceBroker$1, $outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().config(), $outer.failedPartitions(), $outer.replicaManager(), $outer.metrics$1, $outer.time$1, (ReplicaQuota)$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().quota$1.follower(), (Option)new Some((Object)$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().blockingSend$1));
                            }
                        };
                    }

                    public /* synthetic */ $anon$4 kafka$server$ReplicaManagerTest$$anon$$anon$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.metrics$1 = metrics$1;
                        this.time$1 = time$1;
                        super($outer.config(), (ReplicaManager)$outer, metrics$1, time$1, threadNamePrefix$1, quotaManager$1);
                    }
                };
            }

            public /* synthetic */ ReplicaManagerTest kafka$server$ReplicaManagerTest$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$1 = topicPartition$1;
                this.leaderEpochInLeaderAndIsr$1 = leaderEpochInLeaderAndIsr$1;
                this.countDownLatch$1 = countDownLatch$1;
                this.quota$1 = quota$1;
                this.blockingSend$1 = blockingSend$1;
                super(config$1, $outer.metrics(), (Time)$outer.time(), $outer.kafkaZkClient(), (Scheduler)mockScheduler$1, mockLogMgr$1, new AtomicBoolean(false), quota$1, mockBrokerTopicStats$1, metadataCache$1, mockLogDirFailureChannel$1, mockProducePurgatory$1, mockFetchPurgatory$1, mockDeleteRecordsPurgatory$1, mockElectLeaderPurgatory$1, Option$.MODULE$.apply((Object)$outer.getClass().getName()));
            }
        };
        return new Tuple2((Object)replicaManager, (Object)mockLogMgr);
    }

    private Properties prepareReplicaManagerAndLogManager$default$7() {
        return new Properties();
    }

    private LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrPartitionState(TopicPartition topicPartition, int leaderEpoch, int leaderBrokerId, Seq<Integer> aliveBrokerIds) {
        return new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(topicPartition.partition()).setControllerEpoch(this.controllerEpoch()).setLeader(leaderBrokerId).setLeaderEpoch(leaderEpoch).setIsr((List)JavaConverters$.MODULE$.seqAsJavaListConverter(aliveBrokerIds).asJava()).setZkVersion(this.zkVersion()).setReplicas((List)JavaConverters$.MODULE$.seqAsJavaListConverter(aliveBrokerIds).asJava()).setIsNew(false);
    }

    public CallbackResult<ProduceResponse.PartitionResponse> kafka$server$ReplicaManagerTest$$appendRecords(ReplicaManager replicaManager, TopicPartition partition, MemoryRecords records2, AppendOrigin origin, short requiredAcks) {
        CallbackResult<ProduceResponse.PartitionResponse> result = new CallbackResult<ProduceResponse.PartitionResponse>();
        replicaManager.appendRecords(1000L, requiredAcks, false, origin, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)records2)})), (Function1)new Serializable(this, partition, result){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerTest $outer;
            private final TopicPartition partition$1;
            private final CallbackResult result$1;

            public final void apply(Map<TopicPartition, ProduceResponse.PartitionResponse> responses) {
                this.$outer.kafka$server$ReplicaManagerTest$$appendCallback$1(responses, this.partition$1, this.result$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$1 = partition$1;
                this.result$1 = result$1;
            }
        }, replicaManager.appendRecords$default$7(), replicaManager.appendRecords$default$8());
        return result;
    }

    public AppendOrigin kafka$server$ReplicaManagerTest$$appendRecords$default$4() {
        return AppendOrigin.Client$.MODULE$;
    }

    public short kafka$server$ReplicaManagerTest$$appendRecords$default$5() {
        return -1;
    }

    private CallbackResult<FetchPartitionData> fetchAsConsumer(ReplicaManager replicaManager, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel, Option<ClientMetadata> clientMetadata) {
        return this.fetchMessages(replicaManager, -1, partition, partitionData, minBytes, isolationLevel, clientMetadata);
    }

    private int fetchAsConsumer$default$4() {
        return 0;
    }

    private IsolationLevel fetchAsConsumer$default$5() {
        return IsolationLevel.READ_UNCOMMITTED;
    }

    private Option<ClientMetadata> fetchAsConsumer$default$6() {
        return None$.MODULE$;
    }

    private CallbackResult<FetchPartitionData> fetchAsFollower(ReplicaManager replicaManager, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel, Option<ClientMetadata> clientMetadata) {
        return this.fetchMessages(replicaManager, 1, partition, partitionData, minBytes, isolationLevel, clientMetadata);
    }

    private int fetchAsFollower$default$4() {
        return 0;
    }

    private IsolationLevel fetchAsFollower$default$5() {
        return IsolationLevel.READ_UNCOMMITTED;
    }

    private Option<ClientMetadata> fetchAsFollower$default$6() {
        return None$.MODULE$;
    }

    private CallbackResult<FetchPartitionData> fetchMessages(ReplicaManager replicaManager, int replicaId, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel, Option<ClientMetadata> clientMetadata) {
        CallbackResult<FetchPartitionData> result = new CallbackResult<FetchPartitionData>();
        replicaManager.fetchMessages(1000L, replicaId, minBytes, Integer.MAX_VALUE, false, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)partitionData)})), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, (Function1)new Serializable(this, partition, result){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerTest $outer;
            private final TopicPartition partition$2;
            private final CallbackResult result$2;

            public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responseStatus) {
                this.$outer.kafka$server$ReplicaManagerTest$$fetchCallback$2(responseStatus, this.partition$2, this.result$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$2 = partition$2;
                this.result$2 = result$2;
            }
        }, isolationLevel, clientMetadata);
        return result;
    }

    private ReplicaManager setupReplicaManagerWithMockedPurgatories(MockTimer timer2, Seq<Object> aliveBrokerIds) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$47) {
                return new File(x$47);
            }
        }, Seq$.MODULE$.canBuildFrom())), new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2()), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)aliveBrokerIds.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Broker apply(int brokerId) {
                return TestUtils$.MODULE$.createBroker(brokerId, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)})), brokerId, TestUtils$.MODULE$.createBroker$default$4());
            }
        }, Seq$.MODULE$.canBuildFrom());
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        Mockito.when((Object)metadataCache.getAliveBrokers()).thenReturn((Object)aliveBrokers);
        aliveBrokerIds.foreach((Function1)new Serializable(this, metadataCache){
            public static final long serialVersionUID = 0L;
            private final MetadataCache metadataCache$2;

            public final OngoingStubbing<Option<Broker>> apply(int brokerId) {
                return Mockito.when((Object)this.metadataCache$2.getAliveBroker(brokerId)).thenReturn((Object)Option$.MODULE$.apply((Object)TestUtils$.MODULE$.createBroker(brokerId, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)})), brokerId, TestUtils$.MODULE$.createBroker$default$4())));
            }
            {
                this.metadataCache$2 = metadataCache$2;
            }
        });
        String x$182 = "Produce";
        MockTimer x$183 = timer2;
        boolean x$184 = false;
        int x$185 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$186 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$187 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockProducePurgatory = new DelayedOperationPurgatory(x$182, (Timer)x$183, x$185, x$186, x$184, x$187);
        String x$188 = "Fetch";
        MockTimer x$189 = timer2;
        boolean x$190 = false;
        int x$191 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$192 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$193 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockFetchPurgatory = new DelayedOperationPurgatory(x$188, (Timer)x$189, x$191, x$192, x$190, x$193);
        String x$194 = "DeleteRecords";
        MockTimer x$195 = timer2;
        boolean x$196 = false;
        int x$197 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$198 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$199 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDeleteRecordsPurgatory = new DelayedOperationPurgatory(x$194, (Timer)x$195, x$197, x$198, x$196, x$199);
        String x$200 = "DelayedElectLeader";
        MockTimer x$201 = timer2;
        boolean x$202 = false;
        int x$203 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$204 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$205 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDelayedElectLeaderPurgatory = new DelayedOperationPurgatory(x$200, (Timer)x$201, x$203, x$204, x$202, x$205);
        return new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), metadataCache, new LogDirFailureChannel(config.logDirs().size()), mockProducePurgatory, mockFetchPurgatory, mockDeleteRecordsPurgatory, mockDelayedElectLeaderPurgatory, Option$.MODULE$.apply((Object)this.getClass().getName()));
    }

    private Seq<Object> setupReplicaManagerWithMockedPurgatories$default$2() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testOldLeaderLosesMetricsWhenReassignPartitions() {
        Tuple3 tuple3;
        int controllerEpoch = 0;
        int leaderEpoch = 0;
        int leaderEpochIncrement = 1;
        int correlationId = 0;
        int controllerId = 0;
        Tuple4<ReplicaManager, ReplicaManager, BrokerTopicStats, BrokerTopicStats> tuple4 = this.prepareDifferentReplicaManagersWithMockedBrokerTopicStats();
        if (tuple4 == null) throw new MatchError(tuple4);
        ReplicaManager rm0 = (ReplicaManager)tuple4._1();
        ReplicaManager rm1 = (ReplicaManager)tuple4._2();
        BrokerTopicStats mockTopicStats1 = (BrokerTopicStats)tuple4._4();
        Tuple3 tuple32 = tuple3 = new Tuple3((Object)rm0, (Object)rm1, (Object)mockTopicStats1);
        ReplicaManager rm02 = (ReplicaManager)tuple32._1();
        ReplicaManager rm12 = (ReplicaManager)tuple32._2();
        BrokerTopicStats mockTopicStats12 = (BrokerTopicStats)tuple32._3();
        mockTopicStats12.removeOldLeaderMetrics(this.topic());
        EasyMock.expect((Object)BoxedUnit.UNIT).andVoid().once();
        EasyMock.replay((Object[])new Object[]{mockTopicStats12});
        try {
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            TopicPartition tp1 = new TopicPartition(this.topic(), 1);
            List partition0Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            List partition1Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)}))).asJava();
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, 0, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(leaderEpoch).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp1.topic()).setPartitionIndex(tp1.partition()).setControllerEpoch(controllerEpoch).setLeader(1).setLeaderEpoch(leaderEpoch).setIsr(partition1Replicas).setZkVersion(0).setReplicas(partition1Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host0", 0), new Node(1, "host1", 1)}))).asJava()).build();
            rm02.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$49, Iterable<Partition> x$50) {
                }
            });
            rm12.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$51, Iterable<Partition> x$52) {
                }
            });
            LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, controllerEpoch, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(leaderEpoch + leaderEpochIncrement).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp1.topic()).setPartitionIndex(tp1.partition()).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(leaderEpoch + leaderEpochIncrement).setIsr(partition1Replicas).setZkVersion(0).setReplicas(partition1Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host0", 0), new Node(1, "host1", 1)}))).asJava()).build();
            rm02.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest2, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$53, Iterable<Partition> x$54) {
                }
            });
            rm12.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest2, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$55, Iterable<Partition> x$56) {
                }
            });
        }
        catch (Throwable throwable) {
            void var13_13;
            void var12_12;
            var12_12.shutdown(var12_12.shutdown$default$1());
            var13_13.shutdown(var13_13.shutdown$default$1());
            throw throwable;
        }
        rm02.shutdown(rm02.shutdown$default$1());
        rm12.shutdown(rm12.shutdown$default$1());
        EasyMock.verify((Object[])new Object[]{mockTopicStats12});
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testOldFollowerLosesMetricsWhenReassignPartitions() {
        Tuple3 tuple3;
        int controllerEpoch = 0;
        int leaderEpoch = 0;
        int leaderEpochIncrement = 1;
        int correlationId = 0;
        int controllerId = 0;
        Tuple4<ReplicaManager, ReplicaManager, BrokerTopicStats, BrokerTopicStats> tuple4 = this.prepareDifferentReplicaManagersWithMockedBrokerTopicStats();
        if (tuple4 == null) throw new MatchError(tuple4);
        ReplicaManager rm0 = (ReplicaManager)tuple4._1();
        ReplicaManager rm1 = (ReplicaManager)tuple4._2();
        BrokerTopicStats mockTopicStats1 = (BrokerTopicStats)tuple4._4();
        Tuple3 tuple32 = tuple3 = new Tuple3((Object)rm0, (Object)rm1, (Object)mockTopicStats1);
        ReplicaManager rm02 = (ReplicaManager)tuple32._1();
        ReplicaManager rm12 = (ReplicaManager)tuple32._2();
        BrokerTopicStats mockTopicStats12 = (BrokerTopicStats)tuple32._3();
        mockTopicStats12.removeOldLeaderMetrics(this.topic());
        EasyMock.expect((Object)BoxedUnit.UNIT).andVoid().once();
        mockTopicStats12.removeOldFollowerMetrics(this.topic());
        EasyMock.expect((Object)BoxedUnit.UNIT).andVoid().once();
        EasyMock.replay((Object[])new Object[]{mockTopicStats12});
        try {
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            TopicPartition tp1 = new TopicPartition(this.topic(), 1);
            List partition0Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)}))).asJava();
            List partition1Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)}))).asJava();
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, 0, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(controllerEpoch).setLeader(1).setLeaderEpoch(leaderEpoch).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp1.topic()).setPartitionIndex(tp1.partition()).setControllerEpoch(controllerEpoch).setLeader(1).setLeaderEpoch(leaderEpoch).setIsr(partition1Replicas).setZkVersion(0).setReplicas(partition1Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host0", 0), new Node(1, "host1", 1)}))).asJava()).build();
            rm02.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$58, Iterable<Partition> x$59) {
                }
            });
            rm12.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$60, Iterable<Partition> x$61) {
                }
            });
            LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, controllerEpoch, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(leaderEpoch + leaderEpochIncrement).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp1.topic()).setPartitionIndex(tp1.partition()).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(leaderEpoch + leaderEpochIncrement).setIsr(partition1Replicas).setZkVersion(0).setReplicas(partition1Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host0", 0), new Node(1, "host1", 1)}))).asJava()).build();
            rm02.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest2, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$62, Iterable<Partition> x$63) {
                }
            });
            rm12.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest2, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$64, Iterable<Partition> x$65) {
                }
            });
        }
        catch (Throwable throwable) {
            void var13_13;
            void var12_12;
            var12_12.shutdown(var12_12.shutdown$default$1());
            var13_13.shutdown(var13_13.shutdown$default$1());
            throw throwable;
        }
        rm02.shutdown(rm02.shutdown$default$1());
        rm12.shutdown(rm12.shutdown$default$1());
        EasyMock.verify((Object[])new Object[]{mockTopicStats12});
    }

    private Tuple4<ReplicaManager, ReplicaManager, BrokerTopicStats, BrokerTopicStats> prepareDifferentReplicaManagersWithMockedBrokerTopicStats() {
        Properties props0 = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props0.put("log0.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        props1.put("log1.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config0 = KafkaConfig$.MODULE$.fromProps(props0);
        KafkaConfig config1 = KafkaConfig$.MODULE$.fromProps(props1);
        LogManager mockLogMgr0 = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config0.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$66) {
                return new File(x$66);
            }
        }, Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        LogManager mockLogMgr1 = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config1.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$67) {
                return new File(x$67);
            }
        }, Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        BrokerTopicStats mockTopicStats0 = (BrokerTopicStats)EasyMock.createMock(BrokerTopicStats.class);
        BrokerTopicStats mockTopicStats1 = (BrokerTopicStats)EasyMock.createMock(BrokerTopicStats.class);
        MetadataCache metadataCache0 = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        MetadataCache metadataCache1 = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        Seq aliveBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(0, "host0", 0, TestUtils$.MODULE$.createBroker$default$4()), TestUtils$.MODULE$.createBroker(1, "host1", 1, TestUtils$.MODULE$.createBroker$default$4())}));
        EasyMock.expect((Object)metadataCache0.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache0});
        EasyMock.expect((Object)metadataCache1.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache1});
        ReplicaManager rm0 = new ReplicaManager(config0, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr0, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config0, this.metrics(), (Time)this.time(), ""), mockTopicStats0, metadataCache0, new LogDirFailureChannel(config0.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        ReplicaManager rm1 = new ReplicaManager(config1, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr1, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config1, this.metrics(), (Time)this.time(), ""), mockTopicStats1, metadataCache1, new LogDirFailureChannel(config1.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        return new Tuple4((Object)rm0, (Object)rm1, (Object)mockTopicStats0, (Object)mockTopicStats1);
    }

    public final void kafka$server$ReplicaManagerTest$$callback$1(Map responseStatus) {
        Errors errors = ((ProduceResponse.PartitionResponse)responseStatus.values().head()).error;
        Errors errors2 = Errors.INVALID_REQUIRED_ACKS;
        Predef$.MODULE$.assert(!(errors != null ? !errors.equals(errors2) : errors2 != null));
    }

    public final void kafka$server$ReplicaManagerTest$$callback$2(Seq response, TopicPartition tp$1, ObjectRef successfulFetch$1) {
        successfulFetch$1.elem = response.headOption().filter((Function1)new Serializable(this, tp$1){
            public static final long serialVersionUID = 0L;
            private final TopicPartition tp$1;

            public final boolean apply(Tuple2<TopicPartition, FetchPartitionData> x$19) {
                Object object = x$19._1();
                TopicPartition topicPartition = this.tp$1;
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                this.tp$1 = tp$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final FetchPartitionData apply(Tuple2<TopicPartition, FetchPartitionData> x$20) {
                return (FetchPartitionData)x$20._2();
            }
        });
    }

    public final void kafka$server$ReplicaManagerTest$$fetchCallback$1(Seq responseStatus, TopicPartition tp0$1, TopicPartition tp1$1) {
        scala.collection.immutable.Map responseStatusMap = responseStatus.toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((long)2L, (long)responseStatus.size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0$1, tp1$1})), (Object)responseStatusMap.keySet());
        Option tp0Status = responseStatusMap.get((Object)tp0$1);
        Assert.assertTrue((boolean)tp0Status.isDefined());
        Assert.assertEquals((long)0L, (long)((FetchPartitionData)tp0Status.get()).highWatermark());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)((FetchPartitionData)tp0Status.get()).lastStableOffset());
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchPartitionData)tp0Status.get()).error());
        Assert.assertTrue((boolean)((FetchPartitionData)tp0Status.get()).records().batches().iterator().hasNext());
        Option tp1Status = responseStatusMap.get((Object)tp1$1);
        Assert.assertTrue((boolean)tp1Status.isDefined());
        Assert.assertEquals((long)0L, (long)((FetchPartitionData)tp1Status.get()).highWatermark());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)((FetchPartitionData)tp0Status.get()).lastStableOffset());
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchPartitionData)tp1Status.get()).error());
        Assert.assertFalse((boolean)((FetchPartitionData)tp1Status.get()).records().batches().iterator().hasNext());
    }

    public final void kafka$server$ReplicaManagerTest$$callback$3(Map response, TopicPartition topicPartition$3, AtomicReference produceResult$1) {
        produceResult$1.set(response.apply((Object)topicPartition$3));
    }

    public final void kafka$server$ReplicaManagerTest$$callback$4(Seq response, TopicPartition topicPartition$2, AtomicReference fetchResult$1) {
        fetchResult$1.set(response.toMap(Predef$.MODULE$.$conforms()).apply((Object)topicPartition$2));
    }

    public final void kafka$server$ReplicaManagerTest$$appendCallback$1(Map responses, TopicPartition partition$1, CallbackResult result$1) {
        Option response = responses.get((Object)partition$1);
        Assert.assertTrue((boolean)response.isDefined());
        result$1.fire(response.get());
    }

    public final void kafka$server$ReplicaManagerTest$$fetchCallback$2(Seq responseStatus, TopicPartition partition$2, CallbackResult result$2) {
        Assert.assertEquals((long)1L, (long)responseStatus.size());
        Tuple2 tuple2 = (Tuple2)responseStatus.head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            FetchPartitionData fetchData = (FetchPartitionData)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)fetchData);
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            FetchPartitionData fetchData2 = (FetchPartitionData)tuple23._2();
            Assert.assertEquals((Object)partition$2, (Object)topicPartition2);
            result$2.fire(fetchData2);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public ReplicaManagerTest() {
        this.topic = "test-topic";
        this.zkVersion = 0;
        this.correlationId = 0;
        this.brokerEpoch = 0L;
    }

    public class CallbackResult<T> {
        private Option<T> value;
        private Option<Function1<T, BoxedUnit>> fun;

        private Option<T> value() {
            return this.value;
        }

        private void value_$eq(Option<T> x$1) {
            this.value = x$1;
        }

        private Option<Function1<T, BoxedUnit>> fun() {
            return this.fun;
        }

        private void fun_$eq(Option<Function1<T, BoxedUnit>> x$1) {
            this.fun = x$1;
        }

        public T assertFired() {
            Assert.assertTrue((String)"Callback has not been fired", (boolean)this.isFired());
            return (T)this.value().get();
        }

        public boolean isFired() {
            return this.value().isDefined();
        }

        public void fire(T value) {
            this.value_$eq((Option<T>)new Some(value));
            this.fun().foreach((Function1)new Serializable(this, value){
                public static final long serialVersionUID = 0L;
                private final Object value$1;

                public final void apply(Function1<T, BoxedUnit> f) {
                    f.apply(this.value$1);
                }
                {
                    this.value$1 = value$1;
                }
            });
        }

        public CallbackResult<T> onFire(Function1<T, BoxedUnit> fun) {
            this.fun_$eq((Option<Function1<T, BoxedUnit>>)new Some(fun));
            if (this.isFired()) {
                this.fire(this.value().get());
            }
            return this;
        }

        public /* synthetic */ ReplicaManagerTest kafka$server$ReplicaManagerTest$CallbackResult$$$outer() {
            return ReplicaManagerTest.this;
        }

        public CallbackResult() {
            if (ReplicaManagerTest.this == null) {
                throw null;
            }
            this.value = None$.MODULE$;
            this.fun = None$.MODULE$;
        }
    }
}

