/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.net.InetSocketAddress;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zk.ZkFourLetterWords$;
import org.apache.kafka.common.utils.Utils;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}3A!\u0001\u0002\u0001\u000f\t\tR)\u001c2fI\u0012,GMW8pW\u0016,\u0007/\u001a:\u000b\u0005\r!\u0011A\u0001>l\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\b\u0019><w-\u001b8h\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t!\u0001C\u0004\u001b\u0001\t\u0007I\u0011A\u000e\u0002\u0017Mt\u0017\r]:i_R$\u0015N]\u000b\u00029A\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\u0003S>T\u0011!I\u0001\u0005U\u00064\u0018-\u0003\u0002$=\t!a)\u001b7f\u0011\u0019)\u0003\u0001)A\u00059\u0005a1O\\1qg\"|G\u000fR5sA!9q\u0005\u0001b\u0001\n\u0003Y\u0012A\u00027pO\u0012K'\u000f\u0003\u0004*\u0001\u0001\u0006I\u0001H\u0001\bY><G)\u001b:!\u0011\u001dY\u0003A1A\u0005\u00021\n\u0001\u0002^5dWRKW.Z\u000b\u0002[A\u0011\u0011BL\u0005\u0003_)\u00111!\u00138u\u0011\u0019\t\u0004\u0001)A\u0005[\u0005IA/[2l)&lW\r\t\u0005\bg\u0001\u0011\r\u0011\"\u00015\u0003%Qxn\\6fKB,'/F\u00016!\t1d(D\u00018\u0015\tA\u0014(\u0001\u0004tKJ4XM\u001d\u0006\u0003giR!a\u000f\u001f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0014aA8sO&\u0011qh\u000e\u0002\u00105>|7*Z3qKJ\u001cVM\u001d<fe\"1\u0011\t\u0001Q\u0001\nU\n!B_8pW\u0016,\u0007/\u001a:!\u0011\u001d\u0019\u0005A1A\u0005\u0002\u0011\u000bqAZ1di>\u0014\u00180F\u0001F!\t1d)\u0003\u0002Ho\t!b*S(TKJ4XM]\"oq:4\u0015m\u0019;pefDa!\u0013\u0001!\u0002\u0013)\u0015\u0001\u00034bGR|'/\u001f\u0011\t\u000f-\u0003!\u0019!C\u0005\u0019\u0006!\u0011\r\u001a3s+\u0005i\u0005C\u0001(R\u001b\u0005y%B\u0001)!\u0003\rqW\r^\u0005\u0003%>\u0013\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t\u0011\u0019!\u0006\u0001)A\u0005\u001b\u0006)\u0011\r\u001a3sA!9a\u000b\u0001b\u0001\n\u0003a\u0013\u0001\u00029peRDa\u0001\u0017\u0001!\u0002\u0013i\u0013!\u00029peR\u0004\u0003\"\u0002.\u0001\t\u0003Y\u0016\u0001C:ikR$wn\u001e8\u0015\u0003q\u0003\"!C/\n\u0005yS!\u0001B+oSR\u0004")
public class EmbeddedZookeeper
implements Logging {
    private final File snapshotDir;
    private final File logDir;
    private final int tickTime;
    private final ZooKeeperServer zookeeper;
    private final NIOServerCnxnFactory factory;
    private final InetSocketAddress addr;
    private final int port;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        EmbeddedZookeeper embeddedZookeeper = this;
        synchronized (embeddedZookeeper) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.class.msgWithLogIdent((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public File snapshotDir() {
        return this.snapshotDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public int tickTime() {
        return this.tickTime;
    }

    public ZooKeeperServer zookeeper() {
        return this.zookeeper;
    }

    public NIOServerCnxnFactory factory() {
        return this.factory;
    }

    private InetSocketAddress addr() {
        return this.addr;
    }

    public int port() {
        return this.port;
    }

    public void shutdown() {
        CoreUtils$.MODULE$.swallow((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EmbeddedZookeeper $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.factory().shutdown();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        package$.MODULE$.Iterator().continually((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EmbeddedZookeeper $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$zk$EmbeddedZookeeper$$isDown$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(boolean x) {
                return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
            }
        });
        CoreUtils$.MODULE$.swallow((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EmbeddedZookeeper $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.zookeeper().getZKDatabase().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        Utils.delete((File)this.logDir());
        Utils.delete((File)this.snapshotDir());
    }

    public final boolean kafka$zk$EmbeddedZookeeper$$isDown$1() {
        boolean bl;
        try {
            ZkFourLetterWords$.MODULE$.sendStat("127.0.0.1", this.port(), 3000);
            bl = false;
        }
        catch (Throwable throwable) {
            bl = true;
        }
        return bl;
    }

    public EmbeddedZookeeper() {
        Logging.class.$init$((Logging)this);
        this.snapshotDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.tempDir();
        this.tickTime = 800;
        System.setProperty("zookeeper.forceSync", "no");
        this.zookeeper = new ZooKeeperServer(this.snapshotDir(), this.logDir(), this.tickTime());
        this.factory = new NIOServerCnxnFactory();
        this.addr = new InetSocketAddress("127.0.0.1", TestUtils$.MODULE$.RandomPort());
        this.factory().configure(this.addr(), 0);
        this.factory().startup(this.zookeeper());
        this.port = this.zookeeper().getClientPort();
    }
}

