/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.OffsetAndMetadata;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.CompletingRebalance$;
import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupCoordinator$;
import kafka.coordinator.group.GroupMetadata$;
import kafka.coordinator.group.GroupOverview;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.GroupSummary;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.MemberSummary;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011-t!B\u0001\u0003\u0011\u0013I\u0011!D$s_V\u0004X*\u001a;bI\u0006$\u0018M\u0003\u0002\u0004\t\u0005)qM]8va*\u0011QAB\u0001\fG>|'\u000fZ5oCR|'OC\u0001\b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AC\u0006\u000e\u0003\t1Q\u0001\u0004\u0002\t\n5\u0011Qb\u0012:pkBlU\r^1eCR\f7CA\u0006\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\")Qc\u0003C\u0001-\u00051A(\u001b8jiz\"\u0012!\u0003\u0005\b1-\u0011\r\u0011\"\u0003\u001a\u0003M1\u0018\r\\5e!J,g/[8vgN#\u0018\r^3t+\u0005Q\u0002\u0003B\u000e#K!r!\u0001\b\u0011\u0011\u0005u\u0001R\"\u0001\u0010\u000b\u0005}A\u0011A\u0002\u001fs_>$h(\u0003\u0002\"!\u00051\u0001K]3eK\u001aL!a\t\u0013\u0003\u00075\u000b\u0007O\u0003\u0002\"!A\u0011!BJ\u0005\u0003O\t\u0011!b\u0012:pkB\u001cF/\u0019;f!\rY\u0012&J\u0005\u0003U\u0011\u00121aU3u\u0011\u0019a3\u0002)A\u00055\u0005!b/\u00197jIB\u0013XM^5pkN\u001cF/\u0019;fg\u0002BQAL\u0006\u0005\u0002=\n\u0011\u0002\\8bI\u001e\u0013x.\u001e9\u0015'A\"\u0019\u0006\"\u0016\u0005X\u0011eC1\fC/\t?\"\t\u0007\"\u001b\u0011\u0005)\td!\u0002\u0007\u0003\u0001\t\u00114cA\u0019\u000fgA\u0011AgN\u0007\u0002k)\u0011aGB\u0001\u0006kRLGn]\u0005\u0003qU\u0012q\u0001T8hO&tw\r\u0003\u0005;c\t\u0015\r\u0011\"\u0001<\u0003\u001d9'o\\;q\u0013\u0012,\u0012\u0001\u0010\t\u00037uJ!A\u0010\u0013\u0003\rM#(/\u001b8h\u0011!\u0001\u0015G!A!\u0002\u0013a\u0014\u0001C4s_V\u0004\u0018\n\u001a\u0011\t\u0011\t\u000b$\u0011!Q\u0001\n\u0015\nA\"\u001b8ji&\fGn\u0015;bi\u0016D\u0001\u0002R\u0019\u0003\u0002\u0003\u0006I!R\u0001\u0005i&lW\r\u0005\u0002G\u001f6\tqI\u0003\u00027\u0011*\u0011\u0011JS\u0001\u0007G>lWn\u001c8\u000b\u0005\u001dY%B\u0001'N\u0003\u0019\t\u0007/Y2iK*\ta*A\u0002pe\u001eL!\u0001U$\u0003\tQKW.\u001a\u0005\u0006+E\"\tA\u0015\u000b\u0005aM#V\u000bC\u0003;#\u0002\u0007A\bC\u0003C#\u0002\u0007Q\u0005C\u0003E#\u0002\u0007Q)\u0002\u0003Xc\u0001A&\u0001\u0004&pS:\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0003B\bZ7zK!A\u0017\t\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\u0006]\u0013\ti&AA\bK_&twI]8vaJ+7/\u001e7u!\tyq,\u0003\u0002a!\t!QK\\5u\u0011!\u0011\u0017G1A\u0005\u0002\t\u0019\u0017\u0001\u00027pG.,\u0012\u0001\u001a\t\u0003K:l\u0011A\u001a\u0006\u0003O\"\fQ\u0001\\8dWNT!!\u001b6\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002lY\u0006!Q\u000f^5m\u0015\u0005i\u0017\u0001\u00026bm\u0006L!a\u001c4\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0011\u0019\t\u0018\u0007)A\u0005I\u0006)An\\2lA!91/\ra\u0001\n\u0013!\u0018!B:uCR,W#A\u0013\t\u000fY\f\u0004\u0019!C\u0005o\u0006I1\u000f^1uK~#S-\u001d\u000b\u0003=bDq!_;\u0002\u0002\u0003\u0007Q%A\u0002yIEBaa_\u0019!B\u0013)\u0013AB:uCR,\u0007\u0005C\u0004~c\u0001\u0007I\u0011\u0001@\u0002+\r,(O]3oiN#\u0018\r^3US6,7\u000f^1naV\tq\u0010E\u0003\u0010\u0003\u0003\t)!C\u0002\u0002\u0004A\u0011aa\u00149uS>t\u0007cA\b\u0002\b%\u0019\u0011\u0011\u0002\t\u0003\t1{gn\u001a\u0005\n\u0003\u001b\t\u0004\u0019!C\u0001\u0003\u001f\t\u0011dY;se\u0016tGo\u0015;bi\u0016$\u0016.\\3ti\u0006l\u0007o\u0018\u0013fcR\u0019a,!\u0005\t\u0011e\fY!!AA\u0002}Dq!!\u00062A\u0003&q0\u0001\fdkJ\u0014XM\u001c;Ti\u0006$X\rV5nKN$\u0018-\u001c9!\u0011%\tI\"\ra\u0001\n\u0003\tY\"\u0001\u0007qe>$xnY8m)f\u0004X-\u0006\u0002\u0002\u001eA!q\"!\u0001=\u0011%\t\t#\ra\u0001\n\u0003\t\u0019#\u0001\tqe>$xnY8m)f\u0004Xm\u0018\u0013fcR\u0019a,!\n\t\u0013e\fy\"!AA\u0002\u0005u\u0001\u0002CA\u0015c\u0001\u0006K!!\b\u0002\u001bA\u0014x\u000e^8d_2$\u0016\u0010]3!\u0011%\ti#\ra\u0001\n\u0003\ty#\u0001\u0007hK:,'/\u0019;j_:LE-\u0006\u0002\u00022A\u0019q\"a\r\n\u0007\u0005U\u0002CA\u0002J]RD\u0011\"!\u000f2\u0001\u0004%\t!a\u000f\u0002!\u001d,g.\u001a:bi&|g.\u00133`I\u0015\fHc\u00010\u0002>!I\u00110a\u000e\u0002\u0002\u0003\u0007\u0011\u0011\u0007\u0005\t\u0003\u0003\n\u0004\u0015)\u0003\u00022\u0005iq-\u001a8fe\u0006$\u0018n\u001c8JI\u0002B\u0011\"!\u00122\u0001\u0004%I!a\u0007\u0002\u00111,\u0017\rZ3s\u0013\u0012D\u0011\"!\u00132\u0001\u0004%I!a\u0013\u0002\u00191,\u0017\rZ3s\u0013\u0012|F%Z9\u0015\u0007y\u000bi\u0005C\u0005z\u0003\u000f\n\t\u00111\u0001\u0002\u001e!A\u0011\u0011K\u0019!B\u0013\ti\"A\u0005mK\u0006$WM]%eA!I\u0011QK\u0019A\u0002\u0013%\u00111D\u0001\taJ|Go\\2pY\"I\u0011\u0011L\u0019A\u0002\u0013%\u00111L\u0001\raJ|Go\\2pY~#S-\u001d\u000b\u0004=\u0006u\u0003\"C=\u0002X\u0005\u0005\t\u0019AA\u000f\u0011!\t\t'\rQ!\n\u0005u\u0011!\u00039s_R|7m\u001c7!\u0011%\t)'\rb\u0001\n\u0013\t9'A\u0004nK6\u0014WM]:\u0016\u0005\u0005%\u0004cBA6\u0003kb\u0014\u0011P\u0007\u0003\u0003[RA!a\u001c\u0002r\u00059Q.\u001e;bE2,'bAA:!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0014Q\u000e\u0002\b\u0011\u0006\u001c\b.T1q!\rQ\u00111P\u0005\u0004\u0003{\u0012!AD'f[\n,'/T3uC\u0012\fG/\u0019\u0005\t\u0003\u0003\u000b\u0004\u0015!\u0003\u0002j\u0005AQ.Z7cKJ\u001c\b\u0005C\u0005\u0002\u0006F\u0002\r\u0011\"\u0003\u00020\u00051b.^7NK6\u0014WM]:Bo\u0006LG/\u001b8h\u0015>Lg\u000eC\u0005\u0002\nF\u0002\r\u0011\"\u0003\u0002\f\u0006Qb.^7NK6\u0014WM]:Bo\u0006LG/\u001b8h\u0015>Lgn\u0018\u0013fcR\u0019a,!$\t\u0013e\f9)!AA\u0002\u0005E\u0002\u0002CAIc\u0001\u0006K!!\r\u0002/9,X.T3nE\u0016\u00148/Q<bSRLgn\u001a&pS:\u0004\u0003\"CAKc\t\u0007I\u0011BAL\u0003I\u0019X\u000f\u001d9peR,G\r\u0015:pi>\u001cw\u000e\\:\u0016\u0005\u0005e\u0005cBA6\u00037c\u0014QT\u0005\u0004G\u00055\u0004\u0003BAP\u0003Kk!!!)\u000b\u0007\u0005\rF.\u0001\u0003mC:<\u0017\u0002BAT\u0003C\u0013q!\u00138uK\u001e,'\u000f\u0003\u0005\u0002,F\u0002\u000b\u0011BAM\u0003M\u0019X\u000f\u001d9peR,G\r\u0015:pi>\u001cw\u000e\\:!\u0011%\ty+\rb\u0001\n\u0013\t\t,A\u0004pM\u001a\u001cX\r^:\u0016\u0005\u0005M\u0006\u0003CA6\u0003k\n),!0\u0011\t\u0005]\u0016\u0011X\u0007\u0002\u0011&\u0019\u00111\u0018%\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0019!\"a0\n\u0007\u0005\u0005'AA\u000fD_6l\u0017\u000e\u001e*fG>\u0014H-T3uC\u0012\fG/Y!oI>3gm]3u\u0011!\t)-\rQ\u0001\n\u0005M\u0016\u0001C8gMN,Go\u001d\u0011\t\u0013\u0005%\u0017G1A\u0005\n\u0005-\u0017\u0001\u00069f]\u0012LgnZ(gMN,GoQ8n[&$8/\u0006\u0002\u0002NBA\u00111NA;\u0003k\u000by\r\u0005\u0003\u0002R\u0006UWBAAj\u0015\tIe!\u0003\u0003\u0002X\u0006M'!E(gMN,G/\u00118e\u001b\u0016$\u0018\rZ1uC\"A\u00111\\\u0019!\u0002\u0013\ti-A\u000bqK:$\u0017N\\4PM\u001a\u001cX\r^\"p[6LGo\u001d\u0011\t\u0013\u0005}\u0017G1A\u0005\n\u0005\u0005\u0018!\t9f]\u0012Lgn\u001a+sC:\u001c\u0018m\u0019;j_:\fGn\u00144gg\u0016$8i\\7nSR\u001cXCAAr!!\tY'!\u001e\u0002\u0006\u0005\u0015\b\u0003CA6\u00037\u000b),!0\t\u0011\u0005%\u0018\u0007)A\u0005\u0003G\f!\u0005]3oI&tw\r\u0016:b]N\f7\r^5p]\u0006dwJ\u001a4tKR\u001cu.\\7jiN\u0004\u0003\"CAwc\u0001\u0007I\u0011BAx\u0003\t\u0012XmY3jm\u0016$GK]1og\u0006\u001cG/[8oC2|eMZ:fi\u000e{W.\\5ugV\u0011\u0011\u0011\u001f\t\u0004\u001f\u0005M\u0018bAA{!\t9!i\\8mK\u0006t\u0007\"CA}c\u0001\u0007I\u0011BA~\u0003\u0019\u0012XmY3jm\u0016$GK]1og\u0006\u001cG/[8oC2|eMZ:fi\u000e{W.\\5ug~#S-\u001d\u000b\u0004=\u0006u\b\"C=\u0002x\u0006\u0005\t\u0019AAy\u0011!\u0011\t!\rQ!\n\u0005E\u0018a\t:fG\u0016Lg/\u001a3Ue\u0006t7/Y2uS>t\u0017\r\\(gMN,GoQ8n[&$8\u000f\t\u0005\n\u0005\u000b\t\u0004\u0019!C\u0005\u0003_\fQD]3dK&4X\rZ\"p]N,X.\u001a:PM\u001a\u001cX\r^\"p[6LGo\u001d\u0005\n\u0005\u0013\t\u0004\u0019!C\u0005\u0005\u0017\t\u0011E]3dK&4X\rZ\"p]N,X.\u001a:PM\u001a\u001cX\r^\"p[6LGo]0%KF$2A\u0018B\u0007\u0011%I(qAA\u0001\u0002\u0004\t\t\u0010\u0003\u0005\u0003\u0012E\u0002\u000b\u0015BAy\u0003y\u0011XmY3jm\u0016$7i\u001c8tk6,'o\u00144gg\u0016$8i\\7nSR\u001c\b\u0005C\u0005\u0003\u0016E\u0002\r\u0011\"\u0001\u0002p\u0006qa.Z<NK6\u0014WM]!eI\u0016$\u0007\"\u0003B\rc\u0001\u0007I\u0011\u0001B\u000e\u0003IqWm^'f[\n,'/\u00113eK\u0012|F%Z9\u0015\u0007y\u0013i\u0002C\u0005z\u0005/\t\t\u00111\u0001\u0002r\"A!\u0011E\u0019!B\u0013\t\t0A\boK^lU-\u001c2fe\u0006#G-\u001a3!\u0011\u001d\u0011)#\rC\u0001\u0005O\ta!\u001b8M_\u000e\\W\u0003\u0002B\u0015\u0005_!BAa\u000b\u0003BA!!Q\u0006B\u0018\u0019\u0001!\u0001B!\r\u0003$\t\u0007!1\u0007\u0002\u0002)F!!Q\u0007B\u001e!\ry!qG\u0005\u0004\u0005s\u0001\"a\u0002(pi\"Lgn\u001a\t\u0004\u001f\tu\u0012b\u0001B !\t\u0019\u0011I\\=\t\u0013\t\r#1\u0005CA\u0002\t\u0015\u0013a\u00014v]B)qBa\u0012\u0003,%\u0019!\u0011\n\t\u0003\u0011q\u0012\u0017P\\1nKzBqA!\u00142\t\u0003\u0011y%\u0001\u0002jgR!\u0011\u0011\u001fB)\u0011\u001d\u0011\u0019Fa\u0013A\u0002\u0015\n!b\u001a:pkB\u001cF/\u0019;f\u0011\u001d\u00119&\rC\u0001\u00053\n1A\\8u)\u0011\t\tPa\u0017\t\u000f\tM#Q\u000ba\u0001K!9!qL\u0019\u0005\u0002\t\u0005\u0014a\u00015bgR!\u0011\u0011\u001fB2\u0011\u001d\u0011)G!\u0018A\u0002q\n\u0001\"\\3nE\u0016\u0014\u0018\n\u001a\u0005\b\u0005S\nD\u0011\u0001B6\u0003\r9W\r\u001e\u000b\u0005\u0003s\u0012i\u0007C\u0004\u0003f\t\u001d\u0004\u0019\u0001\u001f\t\u000f\tE\u0014\u0007\"\u0001\u0003t\u0005A\u0011n\u001d'fC\u0012,'\u000f\u0006\u0003\u0002r\nU\u0004b\u0002B3\u0005_\u0002\r\u0001\u0010\u0005\u0007\u0005s\nD\u0011A\u001e\u0002\u00191,\u0017\rZ3s\u001fJtU\u000f\u001c7\t\r\tu\u0014\u0007\"\u0001<\u00039\u0001(o\u001c;pG>dwJ\u001d(vY2DqA!!2\t\u0003\u0011\u0019)\u0001\u0010dkJ\u0014XM\u001c;Ti\u0006$X\rV5nKN$\u0018-\u001c9Pe\u0012+g-Y;miV\u0011\u0011Q\u0001\u0005\b\u0005\u000f\u000bD\u0011\u0001BE\u0003\r\tG\r\u001a\u000b\u0006=\n-%q\u0012\u0005\t\u0005\u001b\u0013)\t1\u0001\u0002z\u00051Q.Z7cKJD!B!%\u0003\u0006B\u0005\t\u0019\u0001BJ\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0007c\u0001BK-6\t\u0011\u0007C\u0004\u0003\u001aF\"\tAa'\u0002\rI,Wn\u001c<f)\rq&Q\u0014\u0005\b\u0005K\u00129\n1\u0001=\u0011\u0019\u0011\t+\rC\u0001i\u0006a1-\u001e:sK:$8\u000b^1uK\"9!QU\u0019\u0005\u0002\t\u001d\u0016!\u00068pif+GOU3k_&tW\rZ'f[\n,'o]\u000b\u0003\u0005S\u0003bAa+\u00032\u0006edbA\b\u0003.&\u0019!q\u0016\t\u0002\u000fA\f7m[1hK&!!1\u0017B[\u0005\u0011a\u0015n\u001d;\u000b\u0007\t=\u0006\u0003C\u0004\u0003:F\"\t!a<\u0002'!\f7/\u00117m\u001b\u0016l'-\u001a:t\u0015>Lg.\u001a3\t\u000f\tu\u0016\u0007\"\u0001\u0003@\u0006Q\u0011\r\u001c7NK6\u0014WM]:\u0016\u0005\t\u0005\u0007#\u0002Bb\u0005\u000bdTBAA9\u0013\rQ\u0013\u0011\u000f\u0005\b\u0005\u0013\fD\u0011\u0001BT\u0003E\tG\u000e\\'f[\n,'/T3uC\u0012\fG/\u0019\u0005\b\u0005\u001b\fD\u0011AA\u0018\u0003I\u0011XMY1mC:\u001cW\rV5nK>,H/T:\t\u000f\tE\u0017\u0007\"\u0001\u0003T\u00061r-\u001a8fe\u0006$X-T3nE\u0016\u0014\u0018\nZ*vM\u001aL\u00070\u0006\u0002\u0003VB!\u0011q\u0014Bl\u0013\rq\u0014\u0011\u0015\u0005\b\u00057\fD\u0011AAx\u00031\u0019\u0017M\u001c*fE\u0006d\u0017M\\2f\u0011\u001d\u0011y.\rC\u0001\u0005C\fA\u0002\u001e:b]NLG/[8o)>$2A\u0018Br\u0011\u001d\u0011\u0019F!8A\u0002\u0015BaAa:2\t\u0003Y\u0014AD:fY\u0016\u001cG\u000f\u0015:pi>\u001cw\u000e\u001c\u0005\b\u0005W\fD\u0011\u0002Bw\u0003I\u0019\u0017M\u001c3jI\u0006$X\r\u0015:pi>\u001cw\u000e\\:\u0016\u0005\t=\b#\u0002By\u0005odTB\u0001Bz\u0015\u0011\u0011)0!\u001d\u0002\u0013%lW.\u001e;bE2,\u0017b\u0001\u0016\u0003t\"9!1`\u0019\u0005\u0002\tu\u0018!E:vaB|'\u000f^:Qe>$xnY8mgR!\u0011\u0011\u001fB\u0000\u0011!\u0019\tA!?A\u0002\r\r\u0011aD7f[\n,'\u000f\u0015:pi>\u001cw\u000e\\:\u0011\u0007mIC\bC\u0004\u0004\bE\"\ta!\u0003\u0002\u0019U\u0004H-\u0019;f\u001b\u0016l'-\u001a:\u0015\u000fy\u001bYa!\u0004\u0004,!A!QRB\u0003\u0001\u0004\tI\b\u0003\u0005\u0004\u0010\r\u0015\u0001\u0019AB\t\u0003%\u0001(o\u001c;pG>d7\u000f\u0005\u0004\u0004\u0014\tE6\u0011\u0004\b\u0005\u0007+\u0011iKD\u0002\u001e\u0007/I\u0011!\u0005\t\u0007\u001f\rmAha\b\n\u0007\ru\u0001C\u0001\u0004UkBdWM\r\t\u0006\u001f\r\u00052QE\u0005\u0004\u0007G\u0001\"!B!se\u0006L\bcA\b\u0004(%\u00191\u0011\u0006\t\u0003\t\tKH/\u001a\u0005\t\u0005#\u001b)\u00011\u0001\u0003\u0014\"91qF\u0019\u0005\u0002\rE\u0012AE5om>\\WMS8j]\u000e\u000bG\u000e\u001c2bG.$RAXB\u001a\u0007kA\u0001B!$\u0004.\u0001\u0007\u0011\u0011\u0010\u0005\b\u0007o\u0019i\u00031\u0001\\\u0003=Qw.\u001b8He>,\bOU3tk2$\bbBB\u001ec\u0011\u00051QH\u0001\u0013S:LGOT3yi\u001e+g.\u001a:bi&|g\u000eF\u0001_\u0011\u001d\u0019\t%\rC\u0001\u0007\u0007\nQcY;se\u0016tG/T3nE\u0016\u0014X*\u001a;bI\u0006$\u0018-\u0006\u0002\u0004FA)1D\t\u001f\u0004 !91\u0011J\u0019\u0005\u0002\r-\u0013aB:v[6\f'/_\u000b\u0003\u0007\u001b\u00022ACB(\u0013\r\u0019\tF\u0001\u0002\r\u000fJ|W\u000f]*v[6\f'/\u001f\u0005\b\u0007+\nD\u0011AB,\u0003!yg/\u001a:wS\u0016<XCAB-!\rQ11L\u0005\u0004\u0007;\u0012!!D$s_V\u0004xJ^3sm&,w\u000fC\u0004\u0004bE\"\taa\u0019\u0002#%t\u0017\u000e^5bY&TXm\u00144gg\u0016$8\u000fF\u0003_\u0007K\u001aY\u0007\u0003\u0005\u00020\u000e}\u0003\u0019AB4!!\u0011\u0019m!\u001b\u00026\u0006u\u0016bA\u0012\u0002r!A1QNB0\u0001\u0004\u0019y'A\tqK:$\u0017N\\4Uq:|eMZ:fiN\u0004ba\u0007\u0012\u0002\u0006\u0005\u0015\bbBB:c\u0011\u00051QO\u0001\u0015_:|eMZ:fi\u000e{W.\\5u\u0003B\u0004XM\u001c3\u0015\u000by\u001b9ha\u001f\t\u0011\re4\u0011\u000fa\u0001\u0003k\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0004~\rE\u0004\u0019AA_\u0003yygMZ:fi^KG\u000f[\"p[6LGOU3d_J$W*\u001a;bI\u0006$\u0018\rC\u0004\u0004\u0002F\"\taa!\u0002-\u0019\f\u0017\u000e\u001c)f]\u0012LgnZ(gMN,Go\u0016:ji\u0016$RAXBC\u0007\u000fC\u0001b!\u001f\u0004\u0000\u0001\u0007\u0011Q\u0017\u0005\t\u0007\u0013\u001by\b1\u0001\u0002P\u00061qN\u001a4tKRDqa!$2\t\u0003\u0019y)A\nqe\u0016\u0004\u0018M]3PM\u001a\u001cX\r^\"p[6LG\u000fF\u0002_\u0007#C\u0001\"a,\u0004\f\u0002\u000711\u0013\t\u00077\t\n),a4\t\u000f\r]\u0015\u0007\"\u0001\u0004\u001a\u00061\u0002O]3qCJ,G\u000b\u001f8PM\u001a\u001cX\r^\"p[6LG\u000fF\u0003_\u00077\u001by\n\u0003\u0005\u0004\u001e\u000eU\u0005\u0019AA\u0003\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0005\t\u0003_\u001b)\n1\u0001\u0004\u0014\"911U\u0019\u0005\u0002\u0005=\u0018A\t5bgJ+7-Z5wK\u0012\u001cuN\\:jgR,g\u000e^(gMN,GoQ8n[&$8\u000fC\u0004\u0004(F\"\ta!+\u00025\u0019\f\u0017\u000e\u001c)f]\u0012Lgn\u001a+y]>3gm]3u\u0007>lW.\u001b;\u0015\u000by\u001bYk!,\t\u0011\ru5Q\u0015a\u0001\u0003\u000bA\u0001b!\u001f\u0004&\u0002\u0007\u0011Q\u0017\u0005\b\u0007c\u000bD\u0011ABZ\u0003]yg\u000e\u0016=o\u001f\u001a47/\u001a;D_6l\u0017\u000e^!qa\u0016tG\rF\u0004_\u0007k\u001b9l!/\t\u0011\ru5q\u0016a\u0001\u0003\u000bA\u0001b!\u001f\u00040\u0002\u0007\u0011Q\u0017\u0005\t\u0007w\u001by\u000b1\u0001\u0002>\u0006i2m\\7nSR\u0014VmY8sI6+G/\u00193bi\u0006\fe\u000eZ(gMN,G\u000fC\u0004\u0004@F\"\ta!1\u0002=\r|W\u000e\u001d7fi\u0016\u0004VM\u001c3j]\u001e$\u0006P\\(gMN,GoQ8n[&$H#\u00020\u0004D\u000e\u0015\u0007\u0002CBO\u0007{\u0003\r!!\u0002\t\u0011\r\u001d7Q\u0018a\u0001\u0003c\f\u0001\"[:D_6l\u0017\u000e\u001e\u0005\b\u0007\u0017\fD\u0011ABg\u0003=\t7\r^5wKB\u0013x\u000eZ;dKJ\u001cXCABh!\u0019\u0011\u0019M!2\u0002\u0006!911[\u0019\u0005\u0002\rU\u0017a\t5bgB+g\u000eZ5oO>3gm]3u\u0007>lW.\u001b;t\rJ|W\u000e\u0015:pIV\u001cWM\u001d\u000b\u0005\u0003c\u001c9\u000e\u0003\u0005\u0004\u001e\u000eE\u0007\u0019AA\u0003\u0011\u001d\u0019Y.\rC\u0001\u0007;\f\u0001C]3n_Z,\u0017\t\u001c7PM\u001a\u001cX\r^:\u0015\u0005\r}\u0007\u0003\u0003By\u0007C\f),a4\n\u0007\r\u0012\u0019\u0010C\u0004\u0004fF\"\taa:\u0002\u001bI,Wn\u001c<f\u001f\u001a47/\u001a;t)\u0011\u0019yn!;\t\u0011\r-81\u001da\u0001\u0007[\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0007\u0005\u0007\u001cy/!.\n\t\rE\u0018\u0011\u000f\u0002\u0004'\u0016\f\bbBB{c\u0011\u00051q_\u0001\u0015e\u0016lwN^3FqBL'/\u001a3PM\u001a\u001cX\r^:\u0015\r\rM5\u0011`B\u007f\u0011!\u0019Ypa=A\u0002\u0005\u0015\u0011\u0001E2veJ,g\u000e\u001e+j[\u0016\u001cH/Y7q\u0011!\u0019ypa=A\u0002\u0005\u0015\u0011!E8gMN,GOU3uK:$\u0018n\u001c8Ng\"9A1A\u0019\u0005\u0002\u0011\u0015\u0011AC1mY>3gm]3ugV\u00111q\u001c\u0005\b\u0007\u0013\u000bD\u0011\u0001C\u0005)\u0011!Y\u0001\"\u0004\u0011\u000b=\t\t!a4\t\u0011\reDq\u0001a\u0001\u0003kC\u0001\u0002\"\u00052\t\u0003\u0011A1C\u0001\u0019_\u001a47/\u001a;XSRD'+Z2pe\u0012lU\r^1eCR\fG\u0003\u0002C\u000b\t/\u0001RaDA\u0001\u0003{C\u0001b!\u001f\u0005\u0010\u0001\u0007\u0011Q\u0017\u0005\b\t7\tD\u0011AA\u0018\u0003)qW/\\(gMN,Go\u001d\u0005\b\t?\tD\u0011AAx\u0003)A\u0017m](gMN,Go\u001d\u0005\b\tG\tD\u0011\u0002C\u0013\u0003U\t7o]3siZ\u000bG.\u001b3Ue\u0006t7/\u001b;j_:$2A\u0018C\u0014\u0011\u001d!I\u0003\"\tA\u0002\u0015\n1\u0002^1sO\u0016$8\u000b^1uK\"9AQF\u0019\u0005B\u0011=\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003qB\u0011\u0002b\r2#\u0003%\t\u0001\"\u000e\u0002\u001b\u0005$G\r\n3fM\u0006,H\u000e\u001e\u00133+\t!9D\u000b\u0003\u0003\u0014\u0012e2F\u0001C\u001e!\u0011!i\u0004b\u0012\u000e\u0005\u0011}\"\u0002\u0002C!\t\u0007\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0011\u0015\u0003#\u0001\u0006b]:|G/\u0019;j_:LA\u0001\"\u0013\u0005@\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3)\u0007E\"i\u0005E\u00025\t\u001fJ1\u0001\"\u00156\u00055qwN\u001c;ie\u0016\fGm]1gK\")!(\fa\u0001y!)!)\fa\u0001K!9\u0011QF\u0017A\u0002\u0005E\u0002BBA\r[\u0001\u0007A\b\u0003\u0004\u0002V5\u0002\r\u0001\u0010\u0005\u0007\u0003\u000bj\u0003\u0019\u0001\u001f\t\u000bul\u0003\u0019A@\t\u000f\u0005\u0015T\u00061\u0001\u0005dA111\u0003C3\u0003sJA\u0001b\u001a\u00036\nA\u0011\n^3sC\ndW\rC\u0003E[\u0001\u0007Q\t")
public class GroupMetadata
implements Logging {
    private final String groupId;
    private final Time time;
    private final ReentrantLock lock;
    private GroupState state;
    private Option<Object> currentStateTimestamp;
    private Option<String> protocolType;
    private int generationId;
    private Option<String> kafka$coordinator$group$GroupMetadata$$leaderId;
    private Option<String> kafka$coordinator$group$GroupMetadata$$protocol;
    private final HashMap<String, MemberMetadata> members;
    private int numMembersAwaitingJoin;
    private final scala.collection.mutable.Map<String, Integer> supportedProtocols;
    private final HashMap<TopicPartition, CommitRecordMetadataAndOffset> offsets;
    private final HashMap<TopicPartition, OffsetAndMetadata> pendingOffsetCommits;
    private final HashMap<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> pendingTransactionalOffsetCommits;
    private boolean receivedTransactionalOffsetCommits;
    private boolean receivedConsumerOffsetCommits;
    private boolean newMemberAdded;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static GroupMetadata loadGroup(String string, GroupState groupState, int n, String string2, String string3, String string4, Option<Object> option, Iterable<MemberMetadata> iterable, Time time) {
        return GroupMetadata$.MODULE$.loadGroup(string, groupState, n, string2, string3, string4, option, iterable, time);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        GroupMetadata groupMetadata = this;
        synchronized (groupMetadata) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String groupId() {
        return this.groupId;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    private GroupState state() {
        return this.state;
    }

    private void state_$eq(GroupState x$1) {
        this.state = x$1;
    }

    public Option<Object> currentStateTimestamp() {
        return this.currentStateTimestamp;
    }

    public void currentStateTimestamp_$eq(Option<Object> x$1) {
        this.currentStateTimestamp = x$1;
    }

    public Option<String> protocolType() {
        return this.protocolType;
    }

    public void protocolType_$eq(Option<String> x$1) {
        this.protocolType = x$1;
    }

    public int generationId() {
        return this.generationId;
    }

    public void generationId_$eq(int x$1) {
        this.generationId = x$1;
    }

    private Option<String> kafka$coordinator$group$GroupMetadata$$leaderId() {
        return this.kafka$coordinator$group$GroupMetadata$$leaderId;
    }

    public void kafka$coordinator$group$GroupMetadata$$leaderId_$eq(Option<String> x$1) {
        this.kafka$coordinator$group$GroupMetadata$$leaderId = x$1;
    }

    private Option<String> kafka$coordinator$group$GroupMetadata$$protocol() {
        return this.kafka$coordinator$group$GroupMetadata$$protocol;
    }

    public void kafka$coordinator$group$GroupMetadata$$protocol_$eq(Option<String> x$1) {
        this.kafka$coordinator$group$GroupMetadata$$protocol = x$1;
    }

    private HashMap<String, MemberMetadata> members() {
        return this.members;
    }

    private int numMembersAwaitingJoin() {
        return this.numMembersAwaitingJoin;
    }

    private void numMembersAwaitingJoin_$eq(int x$1) {
        this.numMembersAwaitingJoin = x$1;
    }

    private scala.collection.mutable.Map<String, Integer> supportedProtocols() {
        return this.supportedProtocols;
    }

    private HashMap<TopicPartition, CommitRecordMetadataAndOffset> offsets() {
        return this.offsets;
    }

    private HashMap<TopicPartition, OffsetAndMetadata> pendingOffsetCommits() {
        return this.pendingOffsetCommits;
    }

    private HashMap<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> pendingTransactionalOffsetCommits() {
        return this.pendingTransactionalOffsetCommits;
    }

    private boolean receivedTransactionalOffsetCommits() {
        return this.receivedTransactionalOffsetCommits;
    }

    private void receivedTransactionalOffsetCommits_$eq(boolean x$1) {
        this.receivedTransactionalOffsetCommits = x$1;
    }

    private boolean receivedConsumerOffsetCommits() {
        return this.receivedConsumerOffsetCommits;
    }

    private void receivedConsumerOffsetCommits_$eq(boolean x$1) {
        this.receivedConsumerOffsetCommits = x$1;
    }

    public boolean newMemberAdded() {
        return this.newMemberAdded;
    }

    public void newMemberAdded_$eq(boolean x$1) {
        this.newMemberAdded = x$1;
    }

    public <T> T inLock(Function0<T> fun) {
        return CoreUtils$.MODULE$.inLock(this.lock(), fun);
    }

    public boolean is(GroupState groupState) {
        GroupState groupState2 = this.state();
        GroupState groupState3 = groupState;
        return !(groupState2 != null ? !groupState2.equals(groupState3) : groupState3 != null);
    }

    public boolean not(GroupState groupState) {
        GroupState groupState2 = this.state();
        GroupState groupState3 = groupState;
        return groupState2 == null ? groupState3 != null : !groupState2.equals(groupState3);
    }

    public boolean has(String memberId) {
        return this.members().contains((Object)memberId);
    }

    public MemberMetadata get(String memberId) {
        return (MemberMetadata)this.members().apply((Object)memberId);
    }

    public boolean isLeader(String memberId) {
        return this.kafka$coordinator$group$GroupMetadata$$leaderId().contains((Object)memberId);
    }

    public String leaderOrNull() {
        return (String)this.kafka$coordinator$group$GroupMetadata$$leaderId().orNull(Predef$.MODULE$.$conforms());
    }

    public String protocolOrNull() {
        return (String)this.kafka$coordinator$group$GroupMetadata$$protocol().orNull(Predef$.MODULE$.$conforms());
    }

    public long currentStateTimestampOrDefault() {
        return BoxesRunTime.unboxToLong((Object)this.currentStateTimestamp().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
    }

    public void add(MemberMetadata member, Function1<JoinGroupResult, BoxedUnit> callback) {
        block2: {
            if (this.members().isEmpty()) {
                this.protocolType_$eq((Option<String>)new Some((Object)member.protocolType()));
            }
            String string = this.groupId();
            String string2 = member.groupId();
            Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
            Object object = this.protocolType().orNull(Predef$.MODULE$.$conforms());
            String string3 = member.protocolType();
            Predef$.MODULE$.assert(!(object != null ? !object.equals(string3) : string3 != null));
            Predef$.MODULE$.assert(this.supportsProtocols(member.protocols()));
            if (this.kafka$coordinator$group$GroupMetadata$$leaderId().isEmpty()) {
                this.kafka$coordinator$group$GroupMetadata$$leaderId_$eq((Option<String>)new Some((Object)member.memberId()));
            }
            this.members().put((Object)member.memberId(), (Object)member);
            member.supportedProtocols().foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                GroupMetadata.$anonfun$add$1(this, x0$3);
                return BoxedUnit.UNIT;
            });
            member.awaitingJoinCallback_$eq(callback);
            if (member.awaitingJoinCallback() == null) break block2;
            this.numMembersAwaitingJoin_$eq(this.numMembersAwaitingJoin() + 1);
        }
    }

    public Function1<JoinGroupResult, BoxedUnit> add$default$2() {
        return null;
    }

    public void remove(String memberId) {
        block0: {
            this.members().remove((Object)memberId).foreach((Function1 & Serializable & scala.Serializable)member -> {
                GroupMetadata.$anonfun$remove$1(this, member);
                return BoxedUnit.UNIT;
            });
            if (!this.isLeader(memberId)) break block0;
            this.kafka$coordinator$group$GroupMetadata$$leaderId_$eq((Option<String>)(this.members().isEmpty() ? None$.MODULE$ : new Some(this.members().keys().head())));
        }
    }

    public GroupState currentState() {
        return this.state();
    }

    public List<MemberMetadata> notYetRejoinedMembers() {
        return ((TraversableOnce)this.members().values().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)GroupMetadata.$anonfun$notYetRejoinedMembers$1(x$2)))).toList();
    }

    public boolean hasAllMembersJoined() {
        return this.members().size() <= this.numMembersAwaitingJoin();
    }

    public Set<String> allMembers() {
        return this.members().keySet();
    }

    public List<MemberMetadata> allMemberMetadata() {
        return this.members().values().toList();
    }

    public int rebalanceTimeoutMs() {
        return BoxesRunTime.unboxToInt((Object)this.members().values().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(timeout, member) -> BoxesRunTime.boxToInteger((int)RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)timeout)), member.rebalanceTimeoutMs()))));
    }

    public String generateMemberIdSuffix() {
        return UUID.randomUUID().toString();
    }

    public boolean canRebalance() {
        return ((SetLike)GroupMetadata$.MODULE$.kafka$coordinator$group$GroupMetadata$$validPreviousStates().apply((Object)PreparingRebalance$.MODULE$)).contains((Object)this.state());
    }

    public void transitionTo(GroupState groupState) {
        this.assertValidTransition(groupState);
        this.state_$eq(groupState);
        this.currentStateTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.time.milliseconds())));
    }

    public String selectProtocol() {
        if (this.members().isEmpty()) {
            throw new IllegalStateException("Cannot select protocol for empty group");
        }
        scala.collection.immutable.Set<String> candidates = this.candidateProtocols();
        List votes = ((TraversableLike)this.allMemberMetadata().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.vote(candidates), List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).mapValues((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size())).toList();
        return (String)((Tuple2)votes.maxBy((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$))._1();
    }

    private scala.collection.immutable.Set<String> candidateProtocols() {
        int numMembers = this.members().size();
        return ((TraversableOnce)((TraversableLike)this.supportedProtocols().filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)GroupMetadata.$anonfun$candidateProtocols$1(numMembers, x$6)))).map((Function1 & Serializable & scala.Serializable)x$7 -> (String)x$7._1(), Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    public boolean supportsProtocols(scala.collection.immutable.Set<String> memberProtocols) {
        int numMembers = this.members().size();
        return this.members().isEmpty() || memberProtocols.exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)GroupMetadata.$anonfun$supportsProtocols$1(this, numMembers, x$8)));
    }

    public void updateMember(MemberMetadata member, List<Tuple2<String, byte[]>> protocols, Function1<JoinGroupResult, BoxedUnit> callback) {
        member.supportedProtocols().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            GroupMetadata.$anonfun$updateMember$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        protocols.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            GroupMetadata.$anonfun$updateMember$2(this, x0$2);
            return BoxedUnit.UNIT;
        });
        member.supportedProtocols_$eq(protocols);
        if (callback != null && member.awaitingJoinCallback() == null) {
            this.numMembersAwaitingJoin_$eq(this.numMembersAwaitingJoin() + 1);
        } else if (callback == null && member.awaitingJoinCallback() != null) {
            this.numMembersAwaitingJoin_$eq(this.numMembersAwaitingJoin() - 1);
        }
        member.awaitingJoinCallback_$eq(callback);
    }

    public void invokeJoinCallback(MemberMetadata member, JoinGroupResult joinGroupResult) {
        block0: {
            if (member.awaitingJoinCallback() == null) break block0;
            member.awaitingJoinCallback().apply((Object)joinGroupResult);
            member.awaitingJoinCallback_$eq(null);
            this.numMembersAwaitingJoin_$eq(this.numMembersAwaitingJoin() - 1);
        }
    }

    public void initNextGeneration() {
        List<MemberMetadata> list = this.notYetRejoinedMembers();
        List list2 = List$.MODULE$.empty();
        Predef$.MODULE$.assert(!(list != null ? !list.equals((Object)list2) : list2 != null));
        if (this.members().nonEmpty()) {
            this.generationId_$eq(this.generationId() + 1);
            this.kafka$coordinator$group$GroupMetadata$$protocol_$eq((Option<String>)new Some((Object)this.selectProtocol()));
            this.transitionTo(CompletingRebalance$.MODULE$);
        } else {
            this.generationId_$eq(this.generationId() + 1);
            this.kafka$coordinator$group$GroupMetadata$$protocol_$eq((Option<String>)None$.MODULE$);
            this.transitionTo(Empty$.MODULE$);
        }
        this.receivedConsumerOffsetCommits_$eq(false);
        this.receivedTransactionalOffsetCommits_$eq(false);
    }

    public scala.collection.immutable.Map<String, byte[]> currentMemberMetadata() {
        if (this.is(Dead$.MODULE$) || this.is(PreparingRebalance$.MODULE$)) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Cannot obtain member metadata for group in state %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.state()})));
        }
        return ((TraversableOnce)this.members().map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String memberId = (String)tuple2._1();
            MemberMetadata memberMetadata = (MemberMetadata)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)memberId, (Object)memberMetadata.metadata((String)this.kafka$coordinator$group$GroupMetadata$$protocol().get()));
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public GroupSummary summary() {
        GroupSummary groupSummary;
        if (this.is(Stable$.MODULE$)) {
            String protocol = this.protocolOrNull();
            if (protocol == null) {
                throw new IllegalStateException("Invalid null group protocol for stable group");
            }
            Iterable members = (Iterable)this.members().values().map((Function1 & Serializable & scala.Serializable)member -> member.summary(protocol), scala.collection.Iterable$.MODULE$.canBuildFrom());
            groupSummary = new GroupSummary(this.state().toString(), (String)this.protocolType().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), protocol, (List<MemberSummary>)members.toList());
        } else {
            Iterable members = (Iterable)this.members().values().map((Function1 & Serializable & scala.Serializable)member -> member.summaryNoMetadata(), scala.collection.Iterable$.MODULE$.canBuildFrom());
            groupSummary = new GroupSummary(this.state().toString(), (String)this.protocolType().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), GroupCoordinator$.MODULE$.NoProtocol(), (List<MemberSummary>)members.toList());
        }
        return groupSummary;
    }

    public GroupOverview overview() {
        return new GroupOverview(this.groupId(), (String)this.protocolType().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
    }

    public void initializeOffsets(Map<TopicPartition, CommitRecordMetadataAndOffset> offsets, scala.collection.immutable.Map<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> pendingTxnOffsets) {
        this.offsets().$plus$plus$eq(offsets);
        this.pendingTransactionalOffsetCommits().$plus$plus$eq(pendingTxnOffsets);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onOffsetCommitAppend(TopicPartition topicPartition, CommitRecordMetadataAndOffset offsetWithCommitRecordMetadata) {
        Object object;
        if (this.pendingOffsetCommits().contains((Object)topicPartition)) {
            if (offsetWithCommitRecordMetadata.appendedBatchOffset().isEmpty()) {
                throw new IllegalStateException("Cannot complete offset commit write without providing the metadata of the record in the log.");
            }
            object = !this.offsets().contains((Object)topicPartition) || ((CommitRecordMetadataAndOffset)this.offsets().apply((Object)topicPartition)).olderThan(offsetWithCommitRecordMetadata) ? this.offsets().put((Object)topicPartition, (Object)offsetWithCommitRecordMetadata) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        Option option = this.pendingOffsetCommits().get((Object)topicPartition);
        if (option instanceof Some) {
            Some some = (Some)option;
            OffsetAndMetadata stagedOffset = (OffsetAndMetadata)some.value();
            OffsetAndMetadata offsetAndMetadata = offsetWithCommitRecordMetadata.offsetAndMetadata();
            OffsetAndMetadata offsetAndMetadata2 = stagedOffset;
            if (!(offsetAndMetadata != null ? !((Object)offsetAndMetadata).equals(offsetAndMetadata2) : offsetAndMetadata2 != null)) {
                this.pendingOffsetCommits().remove((Object)topicPartition);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void failPendingOffsetWrite(TopicPartition topicPartition, OffsetAndMetadata offset) {
        Option option = this.pendingOffsetCommits().get((Object)topicPartition);
        if (option instanceof Some) {
            Some some = (Some)option;
            OffsetAndMetadata pendingOffset = (OffsetAndMetadata)some.value();
            OffsetAndMetadata offsetAndMetadata = offset;
            OffsetAndMetadata offsetAndMetadata2 = pendingOffset;
            if (!(offsetAndMetadata != null ? !((Object)offsetAndMetadata).equals(offsetAndMetadata2) : offsetAndMetadata2 != null)) {
                this.pendingOffsetCommits().remove((Object)topicPartition);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void prepareOffsetCommit(scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.receivedConsumerOffsetCommits_$eq(true);
        this.pendingOffsetCommits().$plus$plus$eq(offsets);
    }

    public void prepareTxnOffsetCommit(long producerId, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("TxnOffsetCommit for producer ").append(producerId).append(" and group ").append(this.groupId()).append(" with offsets ").append(offsets).append(" is pending").toString());
        this.receivedTransactionalOffsetCommits_$eq(true);
        scala.collection.mutable.Map producerOffsets = (scala.collection.mutable.Map)this.pendingTransactionalOffsetCommits().getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)producerId), (Function0 & Serializable & scala.Serializable)() -> Map$.MODULE$.empty());
        offsets.foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)tuple2._2();
            Option option = producerOffsets.put((Object)topicPartition, (Object)new CommitRecordMetadataAndOffset((Option<Object>)None$.MODULE$, offsetAndMetadata));
            return option;
        });
    }

    public boolean hasReceivedConsistentOffsetCommits() {
        return !this.receivedConsumerOffsetCommits() || !this.receivedTransactionalOffsetCommits();
    }

    public void failPendingTxnOffsetCommit(long producerId, TopicPartition topicPartition) {
        Option option = this.pendingTransactionalOffsetCommits().get((Object)BoxesRunTime.boxToLong((long)producerId));
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            scala.collection.mutable.Map pendingOffsets = (scala.collection.mutable.Map)some.value();
            Option pendingOffsetCommit = pendingOffsets.remove((Object)topicPartition);
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("TxnOffsetCommit for producer ").append(producerId).append(" and group ").append(this.groupId()).append(" with offsets ").append(pendingOffsetCommit).append(" failed ").append("to be appended to the log").toString());
            if (pendingOffsets.isEmpty()) {
                this.pendingTransactionalOffsetCommits().remove((Object)BoxesRunTime.boxToLong((long)producerId));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void onTxnOffsetCommitAppend(long producerId, TopicPartition topicPartition, CommitRecordMetadataAndOffset commitRecordMetadataAndOffset) {
        block3: {
            block2: {
                var6_4 = this.pendingTransactionalOffsetCommits().get((Object)BoxesRunTime.boxToLong((long)producerId));
                if (!(var6_4 instanceof Some)) break block2;
                var7_5 = (Some)var6_4;
                pendingOffset = (scala.collection.mutable.Map)var7_5.value();
                if (!pendingOffset.contains((Object)topicPartition)) ** GOTO lbl-1000
                v0 = ((CommitRecordMetadataAndOffset)pendingOffset.apply((Object)topicPartition)).offsetAndMetadata();
                var9_7 = commitRecordMetadataAndOffset.offsetAndMetadata();
                if (!(v0 != null ? v0.equals(var9_7) == false : var9_7 != null)) {
                    pendingOffset.update((Object)topicPartition, (Object)commitRecordMetadataAndOffset);
                    v1 = BoxedUnit.UNIT;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = BoxedUnit.UNIT;
                }
                var5_8 = v1;
                break block3;
            }
            var5_9 = BoxedUnit.UNIT;
        }
    }

    public void completePendingTxnOffsetCommit(long producerId, boolean isCommit) {
        Option pendingOffsetsOpt = this.pendingTransactionalOffsetCommits().remove((Object)BoxesRunTime.boxToLong((long)producerId));
        if (isCommit) {
            pendingOffsetsOpt.foreach((Function1 & Serializable & scala.Serializable)pendingOffsets -> {
                pendingOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
                    BoxedUnit boxedUnit;
                    Tuple2 tuple2 = x0$7;
                    if (tuple2 != null) {
                        TopicPartition topicPartition = (TopicPartition)tuple2._1();
                        CommitRecordMetadataAndOffset commitRecordMetadataAndOffset = (CommitRecordMetadataAndOffset)tuple2._2();
                        if (commitRecordMetadataAndOffset.appendedBatchOffset().isEmpty()) {
                            throw new IllegalStateException(new StringBuilder(65).append("Trying to complete a transactional offset commit for producerId ").append(producerId$3).append(" ").append(new StringBuilder(89).append("and groupId ").append($this.groupId()).append(" even though the offset commit record itself hasn't been appended to the log.").toString()).toString());
                        }
                        Option currentOffsetOpt = $this.offsets().get((Object)topicPartition);
                        if (currentOffsetOpt.forall((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.olderThan(commitRecordMetadataAndOffset)))) {
                            $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("TxnOffsetCommit for producer ").append(producerId$3).append(" and group ").append($this.groupId()).append(" with offset ").append(commitRecordMetadataAndOffset).append(" ").append("committed and loaded into the cache.").toString());
                            boxedUnit = $this.offsets().put((Object)topicPartition, (Object)commitRecordMetadataAndOffset);
                        } else {
                            $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("TxnOffsetCommit for producer ").append(producerId$3).append(" and group ").append($this.groupId()).append(" with offset ").append(commitRecordMetadataAndOffset).append(" ").append(new StringBuilder(73).append("committed, but not loaded since its offset is older than current offset ").append(currentOffsetOpt).append(".").toString()).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return boxedUnit2;
                });
                return BoxedUnit.UNIT;
            });
        } else {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("TxnOffsetCommit for producer ").append(producerId).append(" and group ").append(this.groupId()).append(" with offsets ").append(pendingOffsetsOpt).append(" aborted").toString());
        }
    }

    public Set<Object> activeProducers() {
        return this.pendingTransactionalOffsetCommits().keySet();
    }

    public boolean hasPendingOffsetCommitsFromProducer(long producerId) {
        return this.pendingTransactionalOffsetCommits().contains((Object)BoxesRunTime.boxToLong((long)producerId));
    }

    public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> removeAllOffsets() {
        return this.removeOffsets((Seq<TopicPartition>)this.offsets().keySet().toSeq());
    }

    public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> removeOffsets(Seq<TopicPartition> topicPartitions) {
        return ((TraversableOnce)topicPartitions.flatMap((Function1 & Serializable & scala.Serializable)topicPartition -> {
            this.pendingOffsetCommits().remove(topicPartition);
            this.pendingTransactionalOffsetCommits().foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
                Tuple2 tuple2 = x0$8;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                scala.collection.mutable.Map pendingOffsets = (scala.collection.mutable.Map)tuple2._2();
                Option option = pendingOffsets.remove(topicPartition);
                return option;
            });
            Option removedOffset = this.offsets().remove(topicPartition);
            return Option$.MODULE$.option2Iterable(removedOffset.map((Function1 & Serializable & scala.Serializable)x$10 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), (Object)x$10.offsetAndMetadata())));
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> removeExpiredOffsets(long currentTimestamp, long offsetRetentionMs) {
        Option<String> option = this.protocolType();
        scala.collection.immutable.Map map = option instanceof Some && this.is(Empty$.MODULE$) ? this.getExpiredOffsets$1((Function1 & Serializable & scala.Serializable)commitRecordMetadataAndOffset -> BoxesRunTime.boxToLong((long)GroupMetadata.$anonfun$removeExpiredOffsets$3(this, commitRecordMetadataAndOffset)), currentTimestamp, offsetRetentionMs) : (None$.MODULE$.equals(option) ? this.getExpiredOffsets$1((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)GroupMetadata.$anonfun$removeExpiredOffsets$5(x$11)), currentTimestamp, offsetRetentionMs) : (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        scala.collection.immutable.Map expiredOffsets = map;
        if (expiredOffsets.nonEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Expired offsets from group '").append(this.groupId()).append("': ").append(expiredOffsets.keySet()).toString());
        }
        this.offsets().$minus$minus$eq((TraversableOnce)expiredOffsets.keySet());
        return expiredOffsets;
    }

    public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> allOffsets() {
        return ((TraversableOnce)this.offsets().map((Function1 & Serializable & scala.Serializable)x0$11 -> {
            Tuple2 tuple2 = x0$11;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            CommitRecordMetadataAndOffset commitRecordMetadataAndOffset = (CommitRecordMetadataAndOffset)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)commitRecordMetadataAndOffset.offsetAndMetadata());
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Option<OffsetAndMetadata> offset(TopicPartition topicPartition) {
        return this.offsets().get((Object)topicPartition).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.offsetAndMetadata());
    }

    public Option<CommitRecordMetadataAndOffset> offsetWithRecordMetadata(TopicPartition topicPartition) {
        return this.offsets().get((Object)topicPartition);
    }

    public int numOffsets() {
        return this.offsets().size();
    }

    public boolean hasOffsets() {
        return this.offsets().nonEmpty() || this.pendingOffsetCommits().nonEmpty() || this.pendingTransactionalOffsetCommits().nonEmpty();
    }

    private void assertValidTransition(GroupState targetState) {
        if (!((SetLike)GroupMetadata$.MODULE$.kafka$coordinator$group$GroupMetadata$$validPreviousStates().apply((Object)targetState)).contains((Object)this.state())) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Group %s should be in the %s states before moving to %s state. Instead it is in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.groupId(), ((TraversableOnce)GroupMetadata$.MODULE$.kafka$coordinator$group$GroupMetadata$$validPreviousStates().apply((Object)targetState)).mkString(","), targetState, this.state()})));
        }
    }

    public String toString() {
        return new StringBuilder(14).append("GroupMetadata(").append(new StringBuilder(10).append("groupId=").append(this.groupId()).append(", ").toString()).append(new StringBuilder(13).append("generation=").append(this.generationId()).append(", ").toString()).append(new StringBuilder(15).append("protocolType=").append(this.protocolType()).append(", ").toString()).append(new StringBuilder(15).append("currentState=").append(this.currentState()).append(", ").toString()).append(new StringBuilder(9).append("members=").append(this.members()).append(")").toString()).toString();
    }

    public static final /* synthetic */ void $anonfun$add$1(GroupMetadata $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String protocol = (String)tuple2._1();
        $this.supportedProtocols().update((Object)protocol, (Object)Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int((Integer)$this.supportedProtocols().apply((Object)protocol)) + 1));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$remove$2(GroupMetadata $this, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String protocol = (String)tuple2._1();
        $this.supportedProtocols().update((Object)protocol, (Object)Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int((Integer)$this.supportedProtocols().apply((Object)protocol)) - 1));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$remove$1(GroupMetadata $this, MemberMetadata member) {
        block0: {
            member.supportedProtocols().foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                GroupMetadata.$anonfun$remove$2($this, x0$4);
                return BoxedUnit.UNIT;
            });
            if (member.awaitingJoinCallback() == null) break block0;
            $this.numMembersAwaitingJoin_$eq($this.numMembersAwaitingJoin() - 1);
        }
    }

    public static final /* synthetic */ boolean $anonfun$notYetRejoinedMembers$1(MemberMetadata x$2) {
        return x$2.awaitingJoinCallback() == null;
    }

    public static final /* synthetic */ boolean $anonfun$candidateProtocols$1(int numMembers$2, Tuple2 x$6) {
        return BoxesRunTime.equals((Object)x$6._2(), (Object)BoxesRunTime.boxToInteger((int)numMembers$2));
    }

    public static final /* synthetic */ boolean $anonfun$supportsProtocols$1(GroupMetadata $this, int numMembers$1, String x$8) {
        return BoxesRunTime.equals((Object)$this.supportedProtocols().apply((Object)x$8), (Object)BoxesRunTime.boxToInteger((int)numMembers$1));
    }

    public static final /* synthetic */ void $anonfun$updateMember$1(GroupMetadata $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String protocol = (String)tuple2._1();
        $this.supportedProtocols().update((Object)protocol, (Object)Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int((Integer)$this.supportedProtocols().apply((Object)protocol)) - 1));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$updateMember$2(GroupMetadata $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String protocol = (String)tuple2._1();
        $this.supportedProtocols().update((Object)protocol, (Object)Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int((Integer)$this.supportedProtocols().apply((Object)protocol)) + 1));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$removeExpiredOffsets$1(GroupMetadata $this, long currentTimestamp$1, long offsetRetentionMs$1, Function1 baseTimestamp$1, Tuple2 x0$9) {
        Tuple2 tuple2 = x0$9;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        CommitRecordMetadataAndOffset commitRecordMetadataAndOffset = (CommitRecordMetadataAndOffset)tuple2._2();
        if ($this.pendingOffsetCommits().contains((Object)topicPartition)) return false;
        Option<Object> option = commitRecordMetadataAndOffset.offsetAndMetadata().expireTimestamp();
        if (None$.MODULE$.equals(option)) {
            if (currentTimestamp$1 - BoxesRunTime.unboxToLong((Object)baseTimestamp$1.apply((Object)commitRecordMetadataAndOffset)) < offsetRetentionMs$1) return false;
            return true;
        }
        if (!(option instanceof Some)) throw new MatchError(option);
        Some some = (Some)option;
        long expireTimestamp = BoxesRunTime.unboxToLong((Object)some.value());
        if (currentTimestamp$1 < expireTimestamp) return false;
        return true;
    }

    private final scala.collection.immutable.Map getExpiredOffsets$1(Function1 baseTimestamp, long currentTimestamp$1, long offsetRetentionMs$1) {
        return ((TraversableOnce)((TraversableLike)this.offsets().filter((Function1 & Serializable & scala.Serializable)x0$9 -> BoxesRunTime.boxToBoolean((boolean)GroupMetadata.$anonfun$removeExpiredOffsets$1(this, currentTimestamp$1, offsetRetentionMs$1, baseTimestamp, x0$9)))).map((Function1 & Serializable & scala.Serializable)x0$10 -> {
            Tuple2 tuple2 = x0$10;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            CommitRecordMetadataAndOffset commitRecordOffsetAndMetadata = (CommitRecordMetadataAndOffset)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)commitRecordOffsetAndMetadata.offsetAndMetadata());
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ long $anonfun$removeExpiredOffsets$3(GroupMetadata $this, CommitRecordMetadataAndOffset commitRecordMetadataAndOffset) {
        return BoxesRunTime.unboxToLong((Object)$this.currentStateTimestamp().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> commitRecordMetadataAndOffset.offsetAndMetadata().commitTimestamp()));
    }

    public static final /* synthetic */ long $anonfun$removeExpiredOffsets$5(CommitRecordMetadataAndOffset x$11) {
        return x$11.offsetAndMetadata().commitTimestamp();
    }

    public GroupMetadata(String groupId, GroupState initialState, Time time) {
        this.groupId = groupId;
        this.time = time;
        Logging.$init$(this);
        this.lock = new ReentrantLock();
        this.state = initialState;
        this.currentStateTimestamp = new Some((Object)BoxesRunTime.boxToLong((long)time.milliseconds()));
        this.protocolType = None$.MODULE$;
        this.generationId = 0;
        this.kafka$coordinator$group$GroupMetadata$$leaderId = None$.MODULE$;
        this.kafka$coordinator$group$GroupMetadata$$protocol = None$.MODULE$;
        this.members = new HashMap();
        this.numMembersAwaitingJoin = 0;
        this.supportedProtocols = new HashMap().withDefaultValue((Object)Predef$.MODULE$.int2Integer(0));
        this.offsets = new HashMap();
        this.pendingOffsetCommits = new HashMap();
        this.pendingTransactionalOffsetCommits = new HashMap();
        this.receivedTransactionalOffsetCommits = false;
        this.receivedConsumerOffsetCommits = false;
        this.newMemberAdded = false;
    }
}

