/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.util.Iterator;
import kafka.log.CompletedTxn;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.TxnMetadata;
import kafka.log.ValidationType;
import kafka.log.ValidationType$EpochOnly$;
import kafka.log.ValidationType$Full$;
import kafka.log.ValidationType$None$;
import kafka.server.LogOffsetMetadata;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ud!B\u0001\u0003\u0001\t1!A\u0005)s_\u0012,8-\u001a:BaB,g\u000eZ%oM>T!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b'\t\u0001q\u0001\u0005\u0002\t\u00175\t\u0011BC\u0001\u000b\u0003\u0015\u00198-\u00197b\u0013\ta\u0011B\u0001\u0004B]f\u0014VM\u001a\u0005\t\u001d\u0001\u0011)\u0019!C\u0001!\u0005Q\u0001O]8ek\u000e,'/\u00133\u0004\u0001U\t\u0011\u0003\u0005\u0002\t%%\u00111#\u0003\u0002\u0005\u0019>tw\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0012\u0003-\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0011\t\u0011]\u0001!Q1A\u0005\u0002a\tAbY;se\u0016tG/\u00128uef,\u0012!\u0007\t\u00035mi\u0011AA\u0005\u00039\t\u0011!\u0003\u0015:pIV\u001cWM]*uCR,WI\u001c;ss\"Aa\u0004\u0001B\u0001B\u0003%\u0011$A\u0007dkJ\u0014XM\u001c;F]R\u0014\u0018\u0010\t\u0005\tA\u0001\u0011)\u0019!C\u0001C\u0005qa/\u00197jI\u0006$\u0018n\u001c8UsB,W#\u0001\u0012\u0011\u0005i\u0019\u0013B\u0001\u0013\u0003\u000591\u0016\r\\5eCRLwN\u001c+za\u0016D\u0001B\n\u0001\u0003\u0002\u0003\u0006IAI\u0001\u0010m\u0006d\u0017\u000eZ1uS>tG+\u001f9fA!)\u0001\u0006\u0001C\u0001S\u00051A(\u001b8jiz\"BAK\u0016-[A\u0011!\u0004\u0001\u0005\u0006\u001d\u001d\u0002\r!\u0005\u0005\u0006/\u001d\u0002\r!\u0007\u0005\u0006A\u001d\u0002\rA\t\u0005\b_\u0001\u0011\r\u0011\"\u00031\u00031!(/\u00198tC\u000e$\u0018n\u001c8t+\u0005\t\u0004c\u0001\u001a8s5\t1G\u0003\u00025k\u00059Q.\u001e;bE2,'B\u0001\u001c\n\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003qM\u0012!\u0002T5ti\n+hMZ3s!\tQ\"(\u0003\u0002<\u0005\tYA\u000b\u001f8NKR\fG-\u0019;b\u0011\u0019i\u0004\u0001)A\u0005c\u0005iAO]1og\u0006\u001cG/[8og\u0002Bqa\u0010\u0001C\u0002\u0013%\u0001$\u0001\u0007va\u0012\fG/\u001a3F]R\u0014\u0018\u0010\u0003\u0004B\u0001\u0001\u0006I!G\u0001\u000ekB$\u0017\r^3e\u000b:$(/\u001f\u0011\t\u000b\r\u0003A\u0011\u0002#\u0002'5\f\u0017PY3WC2LG-\u0019;f\u0003B\u0004XM\u001c3\u0015\u0007\u0015CU\n\u0005\u0002\t\r&\u0011q)\u0003\u0002\u0005+:LG\u000fC\u0003J\u0005\u0002\u0007!*A\u0007qe>$WoY3s\u000bB|7\r\u001b\t\u0003\u0011-K!\u0001T\u0005\u0003\u000bMCwN\u001d;\t\u000b9\u0013\u0005\u0019A(\u0002\u0011\u0019L'o\u001d;TKF\u0004\"\u0001\u0003)\n\u0005EK!aA%oi\")1\u000b\u0001C\u0005)\u0006\u00112\r[3dWB\u0013x\u000eZ;dKJ,\u0005o\\2i)\t)U\u000bC\u0003J%\u0002\u0007!\nC\u0003X\u0001\u0011%\u0001,A\u0007dQ\u0016\u001c7nU3rk\u0016t7-\u001a\u000b\u0004\u000bfS\u0006\"B%W\u0001\u0004Q\u0005\"B.W\u0001\u0004y\u0015AD1qa\u0016tGMR5sgR\u001cV-\u001d\u0005\u0006;\u0002!IAX\u0001\u000bS:\u001cV-];f]\u000e,GcA0cIB\u0011\u0001\u0002Y\u0005\u0003C&\u0011qAQ8pY\u0016\fg\u000eC\u0003d9\u0002\u0007q*A\u0004mCN$8+Z9\t\u000b\u0015d\u0006\u0019A(\u0002\u000f9,\u0007\u0010^*fc\")q\r\u0001C\u0001Q\u00061\u0011\r\u001d9f]\u0012$\"![8\u0011\u0007!QG.\u0003\u0002l\u0013\t1q\n\u001d;j_:\u0004\"AG7\n\u00059\u0014!\u0001D\"p[BdW\r^3e)bt\u0007\"\u00029g\u0001\u0004\t\u0018!\u00022bi\u000eD\u0007C\u0001:}\u001b\u0005\u0019(B\u0001;v\u0003\u0019\u0011XmY8sI*\u0011ao^\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015A(BA={\u0003\u0019\t\u0007/Y2iK*\t10A\u0002pe\u001eL!!`:\u0003\u0017I+7m\u001c:e\u0005\u0006$8\r\u001b\u0005\u0006O\u0002!\ta \u000b\u000e\u000b\u0006\u0005\u0011QAA\u0004\u0003\u0013\ti!!\u0005\t\r\u0005\ra\u00101\u0001K\u0003\u0015)\u0007o\\2i\u0011\u0015qe\u00101\u0001P\u0011\u0015\u0019g\u00101\u0001P\u0011\u0019\tYA a\u0001#\u0005iA.Y:u)&lWm\u001d;b[BDa!a\u0004\u007f\u0001\u0004\t\u0012A\u00037bgR|eMZ:fi\"1\u00111\u0003@A\u0002}\u000bq\"[:Ue\u0006t7/Y2uS>t\u0017\r\u001c\u0005\b\u0003/\u0001A\u0011AA\r\u0003I\t\u0007\u000f]3oI\u0016sG\r\u0016=o\u001b\u0006\u00148.\u001a:\u0015\u00131\fY\"!\n\u0002(\u0005-\u0002\u0002CA\u000f\u0003+\u0001\r!a\b\u0002\u0019\u0015tG\r\u0016=o\u001b\u0006\u00148.\u001a:\u0011\u0007I\f\t#C\u0002\u0002$M\u0014A#\u00128e)J\fgn]1di&|g.T1sW\u0016\u0014\bBB%\u0002\u0016\u0001\u0007!\nC\u0004\u0002*\u0005U\u0001\u0019A\t\u0002\r=4gm]3u\u0011\u001d\ti#!\u0006A\u0002E\t\u0011\u0002^5nKN$\u0018-\u001c9\t\r\u0005E\u0002\u0001\"\u0001\u0019\u0003\u001d!x.\u00128uefDq!!\u000e\u0001\t\u0003\t9$A\nti\u0006\u0014H/\u001a3Ue\u0006t7/Y2uS>t7/\u0006\u0002\u0002:A)\u00111HA&s9!\u0011QHA$\u001d\u0011\ty$!\u0012\u000e\u0005\u0005\u0005#bAA\"\u001f\u00051AH]8pizJ\u0011AC\u0005\u0004\u0003\u0013J\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u001b\nyE\u0001\u0003MSN$(bAA%\u0013!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0013\u0001I7bs\n,7)Y2iKRChNR5sgR|eMZ:fi6+G/\u00193bi\u0006$2!RA,\u0011!\tI&!\u0015A\u0002\u0005m\u0013!\u00057pO>3gm]3u\u001b\u0016$\u0018\rZ1uCB!\u0011QLA2\u001b\t\tyFC\u0002\u0002b\u0011\taa]3sm\u0016\u0014\u0018\u0002BA3\u0003?\u0012\u0011\u0003T8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0011\u001d\tI\u0007\u0001C!\u0003W\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003[\u0002B!a\u001c\u0002x9!\u0011\u0011OA:!\r\ty$C\u0005\u0004\u0003kJ\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002z\u0005m$AB*ue&twMC\u0002\u0002v%\u0001")
public class ProducerAppendInfo {
    private final long producerId;
    private final ProducerStateEntry currentEntry;
    private final ValidationType validationType;
    private final ListBuffer<TxnMetadata> transactions;
    private final ProducerStateEntry updatedEntry;

    public long producerId() {
        return this.producerId;
    }

    public ProducerStateEntry currentEntry() {
        return this.currentEntry;
    }

    public ValidationType validationType() {
        return this.validationType;
    }

    private ListBuffer<TxnMetadata> transactions() {
        return this.transactions;
    }

    private ProducerStateEntry updatedEntry() {
        return this.updatedEntry;
    }

    private void maybeValidateAppend(short producerEpoch, int firstSeq) {
        ValidationType validationType = this.validationType();
        if (ValidationType$None$.MODULE$.equals(validationType)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ValidationType$EpochOnly$.MODULE$.equals(validationType)) {
            this.checkProducerEpoch(producerEpoch);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ValidationType$Full$.MODULE$.equals(validationType)) {
            this.checkProducerEpoch(producerEpoch);
            this.checkSequence(producerEpoch, firstSeq);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)validationType);
        }
    }

    private void checkProducerEpoch(short producerEpoch) {
        if (producerEpoch < this.updatedEntry().producerEpoch()) {
            throw new ProducerFencedException(new StringBuilder(72).append("Producer's epoch is no longer valid. There is probably another producer ").append(new StringBuilder(53).append("with a newer epoch. ").append(producerEpoch).append(" (request epoch), ").append(this.updatedEntry().producerEpoch()).append(" (server epoch)").toString()).toString());
        }
    }

    private void checkSequence(short producerEpoch, int appendFirstSeq) {
        if (producerEpoch != this.updatedEntry().producerEpoch()) {
            if (appendFirstSeq != 0) {
                if (this.updatedEntry().producerEpoch() != -1) {
                    throw new OutOfOrderSequenceException(new StringBuilder(40).append("Invalid sequence number for new epoch: ").append(producerEpoch).append(" ").append(new StringBuilder(31).append("(request epoch), ").append(appendFirstSeq).append(" (seq. number)").toString()).toString());
                }
                throw new UnknownProducerIdException(new StringBuilder(61).append("Found no record of producerId=").append(this.producerId()).append(" on the broker. It is possible ").append(new StringBuilder(95).append("that the last message with the producerId=").append(this.producerId()).append(" has been removed due to hitting the retention limit.").toString()).toString());
            }
        } else {
            int currentLastSeq;
            int n = !this.updatedEntry().isEmpty() ? this.updatedEntry().lastSeq() : (currentLastSeq = producerEpoch == this.currentEntry().producerEpoch() ? this.currentEntry().lastSeq() : -1);
            if (currentLastSeq == -1 && appendFirstSeq != 0) {
                throw new UnknownProducerIdException(new StringBuilder(45).append("Local producer state matches expected epoch ").append(producerEpoch).append(" ").append(new StringBuilder(64).append("for producerId=").append(this.producerId()).append(", but next expected sequence number is not known.").toString()).toString());
            }
            if (!this.inSequence(currentLastSeq, appendFirstSeq)) {
                throw new OutOfOrderSequenceException(new StringBuilder(47).append("Out of order sequence number for producerId ").append(this.producerId()).append(": ").append(appendFirstSeq).append(" ").append(new StringBuilder(54).append("(incoming seq. number), ").append(currentLastSeq).append(" (current end sequence number)").toString()).toString());
            }
        }
    }

    private boolean inSequence(int lastSeq, int nextSeq) {
        return (long)nextSeq == (long)lastSeq + 1L || nextSeq == 0 && lastSeq == Integer.MAX_VALUE;
    }

    public Option<CompletedTxn> append(RecordBatch batch) {
        None$ none$;
        if (batch.isControlBatch()) {
            Iterator recordIterator = batch.iterator();
            if (recordIterator.hasNext()) {
                Record record = (Record)recordIterator.next();
                EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize((Record)record);
                CompletedTxn completedTxn = this.appendEndTxnMarker(endTxnMarker, batch.producerEpoch(), batch.baseOffset(), record.timestamp());
                none$ = new Some((Object)completedTxn);
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            this.append(batch.producerEpoch(), batch.baseSequence(), batch.lastSequence(), batch.maxTimestamp(), batch.lastOffset(), batch.isTransactional());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void append(short epoch, int firstSeq, int lastSeq, long lastTimestamp, long lastOffset, boolean isTransactional) {
        this.maybeValidateAppend(epoch, firstSeq);
        this.updatedEntry().addBatch(epoch, lastSeq, lastOffset, lastSeq - firstSeq, lastTimestamp);
        Option<Object> option = this.updatedEntry().currentTxnFirstOffset();
        if (option instanceof Some && !isTransactional) {
            throw new InvalidTxnStateException(new StringBuilder(43).append("Expected transactional write from producer ").append(this.producerId()).toString());
        }
        if (None$.MODULE$.equals(option) && isTransactional) {
            long firstOffset = lastOffset - (long)(lastSeq - firstSeq);
            this.updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)firstOffset)));
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), firstOffset));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public CompletedTxn appendEndTxnMarker(EndTransactionMarker endTxnMarker, short producerEpoch, long offset, long timestamp) {
        long l;
        this.checkProducerEpoch(producerEpoch);
        if (this.updatedEntry().coordinatorEpoch() > endTxnMarker.coordinatorEpoch()) {
            throw new TransactionCoordinatorFencedException(new StringBuilder(28).append("Invalid coordinator epoch: ").append(endTxnMarker.coordinatorEpoch()).append(" ").append(new StringBuilder(20).append("(zombie), ").append(this.updatedEntry().coordinatorEpoch()).append(" (current)").toString()).toString());
        }
        this.updatedEntry().maybeUpdateEpoch(producerEpoch);
        Option<Object> option = this.updatedEntry().currentTxnFirstOffset();
        if (option instanceof Some) {
            long txnFirstOffset;
            Some some = (Some)option;
            l = txnFirstOffset = BoxesRunTime.unboxToLong((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), offset));
            l = offset;
        } else {
            throw new MatchError(option);
        }
        long firstOffset = l;
        this.updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)None$.MODULE$);
        this.updatedEntry().coordinatorEpoch_$eq(endTxnMarker.coordinatorEpoch());
        ControlRecordType controlRecordType = endTxnMarker.controlType();
        ControlRecordType controlRecordType2 = ControlRecordType.ABORT;
        return new CompletedTxn(this.producerId(), firstOffset, offset, !(controlRecordType != null ? !controlRecordType.equals(controlRecordType2) : controlRecordType2 != null));
    }

    public ProducerStateEntry toEntry() {
        return this.updatedEntry();
    }

    public List<TxnMetadata> startedTransactions() {
        return this.transactions().toList();
    }

    public void maybeCacheTxnFirstOffsetMetadata(LogOffsetMetadata logOffsetMetadata) {
        this.transactions().headOption().foreach((Function1 & Serializable & scala.Serializable)txn -> {
            ProducerAppendInfo.$anonfun$maybeCacheTxnFirstOffsetMetadata$1(logOffsetMetadata, txn);
            return BoxedUnit.UNIT;
        });
    }

    public String toString() {
        return new StringBuilder(19).append("ProducerAppendInfo(").append(new StringBuilder(13).append("producerId=").append(this.producerId()).append(", ").toString()).append(new StringBuilder(16).append("producerEpoch=").append(this.updatedEntry().producerEpoch()).append(", ").toString()).append(new StringBuilder(16).append("firstSequence=").append(this.updatedEntry().firstSeq()).append(", ").toString()).append(new StringBuilder(15).append("lastSequence=").append(this.updatedEntry().lastSeq()).append(", ").toString()).append(new StringBuilder(24).append("currentTxnFirstOffset=").append(this.updatedEntry().currentTxnFirstOffset()).append(", ").toString()).append(new StringBuilder(19).append("coordinatorEpoch=").append(this.updatedEntry().coordinatorEpoch()).append(", ").toString()).append(new StringBuilder(21).append("startedTransactions=").append(this.transactions()).append(")").toString()).toString();
    }

    public static final /* synthetic */ void $anonfun$maybeCacheTxnFirstOffsetMetadata$1(LogOffsetMetadata logOffsetMetadata$1, TxnMetadata txn) {
        block0: {
            if (txn.firstOffset().messageOffset() != logOffsetMetadata$1.messageOffset()) break block0;
            txn.firstOffset_$eq(logOffsetMetadata$1);
        }
    }

    public ProducerAppendInfo(long producerId, ProducerStateEntry currentEntry, ValidationType validationType) {
        this.producerId = producerId;
        this.currentEntry = currentEntry;
        this.validationType = validationType;
        this.transactions = (ListBuffer)ListBuffer$.MODULE$.empty();
        this.updatedEntry = ProducerStateEntry$.MODULE$.empty(producerId);
        this.updatedEntry().producerEpoch_$eq(currentEntry.producerEpoch());
        this.updatedEntry().coordinatorEpoch_$eq(currentEntry.coordinatorEpoch());
        this.updatedEntry().currentTxnFirstOffset_$eq(currentEntry.currentTxnFirstOffset());
    }
}

