/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$;
import kafka.network.Processor$ConnectionId$;
import kafka.network.RequestChannel;
import kafka.security.CredentialProvider;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\u0011}qAB\u0001\u0003\u0011\u0003!a!A\u0005Qe>\u001cWm]:pe*\u00111\u0001B\u0001\b]\u0016$xo\u001c:l\u0015\u0005)\u0011!B6bM.\f\u0007CA\u0004\t\u001b\u0005\u0011aAB\u0005\u0003\u0011\u0003!!BA\u0005Qe>\u001cWm]:peN\u0011\u0001b\u0003\t\u0003\u0019=i\u0011!\u0004\u0006\u0002\u001d\u0005)1oY1mC&\u0011\u0001#\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bIAA\u0011\u0001\u000b\u0002\rqJg.\u001b;?\u0007\u0001!\u0012A\u0002\u0005\b-!\u0011\r\u0011\"\u0001\u0018\u0003UIE\r\\3QKJ\u001cWM\u001c;NKR\u0014\u0018n\u0019(b[\u0016,\u0012\u0001\u0007\t\u00033yi\u0011A\u0007\u0006\u00037q\tA\u0001\\1oO*\tQ$\u0001\u0003kCZ\f\u0017BA\u0010\u001b\u0005\u0019\u0019FO]5oO\"1\u0011\u0005\u0003Q\u0001\na\ta#\u00133mKB+'oY3oi6+GO]5d\u001d\u0006lW\r\t\u0005\bG!\u0011\r\u0011\"\u0001\u0018\u0003eqU\r^<pe.\u0004&o\\2fgN|'/T3ue&\u001cG+Y4\t\r\u0015B\u0001\u0015!\u0003\u0019\u0003iqU\r^<pe.\u0004&o\\2fgN|'/T3ue&\u001cG+Y4!\u0011\u001d9\u0003B1A\u0005\u0002]\t\u0011\u0003T5ti\u0016tWM]'fiJL7\rV1h\u0011\u0019I\u0003\u0002)A\u00051\u0005\u0011B*[:uK:,'/T3ue&\u001cG+Y4!\r\u0015I!\u0001\u0001\u0003,'\rQCf\f\t\u0003\u000f5J!A\f\u0002\u0003)\u0005\u00137\u000f\u001e:bGR\u001cVM\u001d<feRC'/Z1e!\t\u00014'D\u00012\u0015\t\u0011D!A\u0004nKR\u0014\u0018nY:\n\u0005Q\n$!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\"AaG\u000bBC\u0002\u0013\u0005q'\u0001\u0002jIV\t\u0001\b\u0005\u0002\rs%\u0011!(\u0004\u0002\u0004\u0013:$\b\u0002\u0003\u001f+\u0005\u0003\u0005\u000b\u0011\u0002\u001d\u0002\u0007%$\u0007\u0005\u0003\u0005?U\t\u0005\t\u0015!\u0003@\u0003\u0011!\u0018.\\3\u0011\u0005\u0001SU\"A!\u000b\u0005\t\u001b\u0015!B;uS2\u001c(B\u0001#F\u0003\u0019\u0019w.\\7p]*\u0011QA\u0012\u0006\u0003\u000f\"\u000ba!\u00199bG\",'\"A%\u0002\u0007=\u0014x-\u0003\u0002L\u0003\n!A+[7f\u0011!i%F!A!\u0002\u0013A\u0014AD7bqJ+\u0017/^3tiNK'0\u001a\u0005\t\u001f*\u0012\t\u0011)A\u0005!\u0006q!/Z9vKN$8\t[1o]\u0016d\u0007CA\u0004R\u0013\t\u0011&A\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\t\u0011QS#\u0011!Q\u0001\nU\u000b\u0001cY8o]\u0016\u001cG/[8o#V|G/Y:\u0011\u0005\u001d1\u0016BA,\u0003\u0005A\u0019uN\u001c8fGRLwN\\)v_R\f7\u000f\u0003\u0005ZU\t\u0005\t\u0015!\u0003[\u0003Q\u0019wN\u001c8fGRLwN\\:NCbLE\r\\3NgB\u0011AbW\u0005\u000396\u0011A\u0001T8oO\"AaL\u000bB\u0001B\u0003%\u0001(A\u000egC&dW\rZ!vi\",g\u000e^5dCRLwN\u001c#fY\u0006LXj\u001d\u0005\tA*\u0012\t\u0011)A\u0005C\u0006aA.[:uK:,'OT1nKB\u0011!\rZ\u0007\u0002G*\u00111aQ\u0005\u0003K\u000e\u0014A\u0002T5ti\u0016tWM\u001d(b[\u0016D\u0001b\u001a\u0016\u0003\u0002\u0003\u0006I\u0001[\u0001\u0011g\u0016\u001cWO]5usB\u0013x\u000e^8d_2\u0004\"!\u001b8\u000e\u0003)T!a\u001b7\u0002\t\u0005,H\u000f\u001b\u0006\u0003[\u000e\u000b\u0001b]3dkJLG/_\u0005\u0003_*\u0014\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\t\u0011ET#\u0011!Q\u0001\nI\faaY8oM&<\u0007CA:w\u001b\u0005!(BA;\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011q\u000f\u001e\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u00053U\t\u0005\t\u0015!\u0003z!\tQH0D\u0001|\u0015\t\u00114)\u0003\u0002~w\n9Q*\u001a;sS\u000e\u001c\b\"C@+\u0005\u0003\u0005\u000b\u0011BA\u0001\u0003I\u0019'/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:\u0011\t\u0005\r\u0011qA\u0007\u0003\u0003\u000bQ!!\u001c\u0003\n\t\u0005%\u0011Q\u0001\u0002\u0013\u0007J,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'\u000f\u0003\u0006\u0002\u000e)\u0012\t\u0011)A\u0005\u0003\u001f\t!\"\\3n_JL\bk\\8m!\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000b\u0007\u00061Q.Z7pefLA!!\u0007\u0002\u0014\tQQ*Z7pef\u0004vn\u001c7\t\u0015\u0005u!F!A!\u0002\u0013\ty\"\u0001\u0006m_\u001e\u001cuN\u001c;fqR\u00042\u0001QA\u0011\u0013\r\t\u0019#\u0011\u0002\u000b\u0019><7i\u001c8uKb$\bB\u0002\n+\t\u0003\t9\u0003\u0006\u0010\u0002*\u0005-\u0012QFA\u0018\u0003c\t\u0019$!\u000e\u00028\u0005e\u00121HA\u001f\u0003\u007f\t\t%a\u0011\u0002FA\u0011qA\u000b\u0005\u0007m\u0005\u0015\u0002\u0019\u0001\u001d\t\ry\n)\u00031\u0001@\u0011\u0019i\u0015Q\u0005a\u0001q!1q*!\nA\u0002ACa\u0001VA\u0013\u0001\u0004)\u0006BB-\u0002&\u0001\u0007!\f\u0003\u0004_\u0003K\u0001\r\u0001\u000f\u0005\u0007A\u0006\u0015\u0002\u0019A1\t\r\u001d\f)\u00031\u0001i\u0011\u0019\t\u0018Q\u0005a\u0001e\"1!'!\nA\u0002eDqa`A\u0013\u0001\u0004\t\t\u0001\u0003\u0005\u0002\u000e\u0005\u0015\u0002\u0019AA\b\u0011!\ti\"!\nA\u0002\u0005}qaBA%U!%\u00111J\u0001\r\u0007>tg.Z2uS>t\u0017\n\u001a\t\u0005\u0003\u001b\ny%D\u0001+\r\u001d\t\tF\u000bE\u0005\u0003'\u0012AbQ8o]\u0016\u001cG/[8o\u0013\u0012\u001cR!a\u0014\f\u0003+\u00022\u0001DA,\u0013\r\tI&\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\b%\u0005=C\u0011AA/)\t\tY\u0005\u0003\u0005\u0002b\u0005=C\u0011AA2\u0003)1'o\\7TiJLgn\u001a\u000b\u0005\u0003K\u0012i\u0005E\u0003\r\u0003O\nY'C\u0002\u0002j5\u0011aa\u00149uS>t\u0007\u0003BA'\u0003[2q!!\u0015+\u0001\n\tygE\u0004\u0002n-\t\t(!\u0016\u0011\u00071\t\u0019(C\u0002\u0002v5\u0011q\u0001\u0015:pIV\u001cG\u000fC\u0006\u0002z\u00055$Q3A\u0005\u0002\u0005m\u0014!\u00037pG\u0006d\u0007j\\:u+\t\ti\b\u0005\u0003\u0002\u0000\u00055e\u0002BAA\u0003\u0013\u00032!a!\u000e\u001b\t\t)IC\u0002\u0002\bN\ta\u0001\u0010:p_Rt\u0014bAAF\u001b\u00051\u0001K]3eK\u001aL1aHAH\u0015\r\tY)\u0004\u0005\f\u0003'\u000biG!E!\u0002\u0013\ti(\u0001\u0006m_\u000e\fG\u000eS8ti\u0002B!\"a&\u0002n\tU\r\u0011\"\u00018\u0003%awnY1m!>\u0014H\u000f\u0003\u0006\u0002\u001c\u00065$\u0011#Q\u0001\na\n!\u0002\\8dC2\u0004vN\u001d;!\u0011-\ty*!\u001c\u0003\u0016\u0004%\t!a\u001f\u0002\u0015I,Wn\u001c;f\u0011>\u001cH\u000fC\u0006\u0002$\u00065$\u0011#Q\u0001\n\u0005u\u0014a\u0003:f[>$X\rS8ti\u0002B!\"a*\u0002n\tU\r\u0011\"\u00018\u0003)\u0011X-\\8uKB{'\u000f\u001e\u0005\u000b\u0003W\u000biG!E!\u0002\u0013A\u0014a\u0003:f[>$X\rU8si\u0002B!\"a,\u0002n\tU\r\u0011\"\u00018\u0003\u0015Ig\u000eZ3y\u0011)\t\u0019,!\u001c\u0003\u0012\u0003\u0006I\u0001O\u0001\u0007S:$W\r\u001f\u0011\t\u000fI\ti\u0007\"\u0001\u00028Ra\u00111NA]\u0003w\u000bi,a0\u0002B\"A\u0011\u0011PA[\u0001\u0004\ti\bC\u0004\u0002\u0018\u0006U\u0006\u0019\u0001\u001d\t\u0011\u0005}\u0015Q\u0017a\u0001\u0003{Bq!a*\u00026\u0002\u0007\u0001\bC\u0004\u00020\u0006U\u0006\u0019\u0001\u001d\t\u0011\u0005\u0015\u0017Q\u000eC!\u0003\u000f\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003{B!\"a3\u0002n\u0005\u0005I\u0011AAg\u0003\u0011\u0019w\u000e]=\u0015\u0019\u0005-\u0014qZAi\u0003'\f).a6\t\u0015\u0005e\u0014\u0011\u001aI\u0001\u0002\u0004\ti\bC\u0005\u0002\u0018\u0006%\u0007\u0013!a\u0001q!Q\u0011qTAe!\u0003\u0005\r!! \t\u0013\u0005\u001d\u0016\u0011\u001aI\u0001\u0002\u0004A\u0004\"CAX\u0003\u0013\u0004\n\u00111\u00019\u0011)\tY.!\u001c\u0012\u0002\u0013\u0005\u0011Q\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyN\u000b\u0003\u0002~\u0005\u00058FAAr!\u0011\t)/a<\u000e\u0005\u0005\u001d(\u0002BAu\u0003W\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055X\"\u0001\u0006b]:|G/\u0019;j_:LA!!=\u0002h\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005U\u0018QNI\u0001\n\u0003\t90\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005e(f\u0001\u001d\u0002b\"Q\u0011Q`A7#\u0003%\t!!8\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g!Q!\u0011AA7#\u0003%\t!a>\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i!Q!QAA7#\u0003%\t!a>\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%k!I!\u0011BA7\u0003\u0003%\teF\u0001\u000eaJ|G-^2u!J,g-\u001b=\t\u0013\t5\u0011QNA\u0001\n\u00039\u0014\u0001\u00049s_\u0012,8\r^!sSRL\bB\u0003B\t\u0003[\n\t\u0011\"\u0001\u0003\u0014\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\u000b\u00057\u00012\u0001\u0004B\f\u0013\r\u0011I\"\u0004\u0002\u0004\u0003:L\b\"\u0003B\u000f\u0005\u001f\t\t\u00111\u00019\u0003\rAH%\r\u0005\u000b\u0005C\ti'!A\u0005B\t\r\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u0015\u0002C\u0002B\u0014\u0005[\u0011)\"\u0004\u0002\u0003*)\u0019!1F\u0007\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00030\t%\"\u0001C%uKJ\fGo\u001c:\t\u0015\tM\u0012QNA\u0001\n\u0003\u0011)$\u0001\u0005dC:,\u0015/^1m)\u0011\u00119D!\u0010\u0011\u00071\u0011I$C\u0002\u0003<5\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u0003\u001e\tE\u0012\u0011!a\u0001\u0005+A!B!\u0011\u0002n\u0005\u0005I\u0011\tB\"\u0003!A\u0017m\u001d5D_\u0012,G#\u0001\u001d\t\u0015\t\u001d\u0013QNA\u0001\n\u0003\u0012I%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005o\u0011Y\u0005\u0003\u0006\u0003\u001e\t\u0015\u0013\u0011!a\u0001\u0005+A\u0001Ba\u0014\u0002`\u0001\u0007\u0011QP\u0001\u0002g\"Q!1KA(\u0003\u0003%\tI!\u0016\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0019\u0005-$q\u000bB-\u00057\u0012iFa\u0018\t\u0011\u0005e$\u0011\u000ba\u0001\u0003{Bq!a&\u0003R\u0001\u0007\u0001\b\u0003\u0005\u0002 \nE\u0003\u0019AA?\u0011\u001d\t9K!\u0015A\u0002aBq!a,\u0003R\u0001\u0007\u0001\b\u0003\u0006\u0003d\u0005=\u0013\u0011!CA\u0005K\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003h\t=\u0004#\u0002\u0007\u0002h\t%\u0004C\u0003\u0007\u0003l\u0005u\u0004(! 9q%\u0019!QN\u0007\u0003\rQ+\b\u000f\\36\u0011)\u0011\tH!\u0019\u0002\u0002\u0003\u0007\u00111N\u0001\u0004q\u0012\u0002\u0004\"\u0003B;U\t\u0007I\u0011\u0002B<\u00039qWm^\"p]:,7\r^5p]N,\"A!\u001f\u0011\r\tm$Q\u0011BE\u001b\t\u0011iH\u0003\u0003\u0003\u0000\t\u0005\u0015AC2p]\u000e,(O]3oi*\u0019!1\u0011\u000f\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005\u000f\u0013iHA\u000bD_:\u001cWO\u001d:f]Rd\u0015N\\6fIF+X-^3\u0011\t\t-%QS\u0007\u0003\u0005\u001bSAAa$\u0003\u0012\u0006A1\r[1o]\u0016d7OC\u0002\u0003\u0014r\t1A\\5p\u0013\u0011\u00119J!$\u0003\u001bM{7m[3u\u0007\"\fgN\\3m\u0011!\u0011YJ\u000bQ\u0001\n\te\u0014a\u00048fo\u000e{gN\\3di&|gn\u001d\u0011\t\u0013\t}%F1A\u0005\n\t\u0005\u0016!E5oM2Lw\r\u001b;SKN\u0004xN\\:fgV\u0011!1\u0015\t\t\u0005K\u0013Y+! \u000306\u0011!q\u0015\u0006\u0005\u0005S\u0013I#A\u0004nkR\f'\r\\3\n\t\t5&q\u0015\u0002\u0004\u001b\u0006\u0004\b\u0003\u0002BY\u0005os1a\u0002BZ\u0013\r\u0011)LA\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\u0011\u0011ILa/\u0003\u0011I+7\u000f]8og\u0016T1A!.\u0003\u0011!\u0011yL\u000bQ\u0001\n\t\r\u0016AE5oM2Lw\r\u001b;SKN\u0004xN\\:fg\u0002B\u0011Ba1+\u0005\u0004%IA!2\u0002\u001bI,7\u000f]8og\u0016\fV/Z;f+\t\u00119\r\u0005\u0004\u0003|\t%'qV\u0005\u0005\u0005\u0017\u0014iHA\nMS:\\W\r\u001a\"m_\u000e\\\u0017N\\4EKF,X\r\u0003\u0005\u0003P*\u0002\u000b\u0011\u0002Bd\u00039\u0011Xm\u001d9p]N,\u0017+^3vK\u0002B!Ba5+\u0005\u0004%\t\u0001\u0002Bk\u0003)iW\r\u001e:jGR\u000bwm]\u000b\u0003\u0005/\u0004bA!7\u0003\\bARB\u0001BA\u0013\u0011\u0011iK!!\t\u0011\t}'\u0006)A\u0005\u0005/\f1\"\\3ue&\u001cG+Y4tA!I!1\u001d\u0016C\u0002\u0013%!Q]\u0001\tg\u0016dWm\u0019;peV\u0011!q\u001d\t\u0004E\n%\u0018b\u0001BvG\nA1+\u001a7fGR|'\u000f\u0003\u0005\u0003p*\u0002\u000b\u0011\u0002Bt\u0003%\u0019X\r\\3di>\u0014\b\u0005\u0003\u0005\u0003t*\"\tB\u0001B{\u00039\u0019'/Z1uKN+G.Z2u_J$BAa:\u0003x\"A!\u0011 By\u0001\u0004\u0011Y0\u0001\bdQ\u0006tg.\u001a7Ck&dG-\u001a:\u0011\u0007\t\u0014i0C\u0002\u0003\u0000\u000e\u0014ab\u00115b]:,GNQ;jY\u0012,'\u000f\u0003\u0005\u0004\u0004)\u0002\r\u0011\"\u00038\u0003MqW\r\u001f;D_:tWm\u0019;j_:Le\u000eZ3y\u0011%\u00199A\u000ba\u0001\n\u0013\u0019I!A\foKb$8i\u001c8oK\u000e$\u0018n\u001c8J]\u0012,\u0007p\u0018\u0013fcR!11BB\t!\ra1QB\u0005\u0004\u0007\u001fi!\u0001B+oSRD\u0011B!\b\u0004\u0006\u0005\u0005\t\u0019\u0001\u001d\t\u000f\rU!\u0006)Q\u0005q\u0005!b.\u001a=u\u0007>tg.Z2uS>t\u0017J\u001c3fq\u0002Bqa!\u0007+\t\u0003\u001aY\"A\u0002sk:$\"aa\u0003\t\u000f\r}!\u0006\"\u0003\u0004\"\u0005\u0001\u0002O]8dKN\u001cX\t_2faRLwN\u001c\u000b\u0007\u0007\u0017\u0019\u0019ca\n\t\u0011\r\u00152Q\u0004a\u0001\u0003{\nA\"\u001a:s_JlUm]:bO\u0016D\u0001b!\u000b\u0004\u001e\u0001\u000711F\u0001\ni\"\u0014xn^1cY\u0016\u0004Ba!\f\u000489!1qFB\u001a\u001d\u0011\t\u0019i!\r\n\u00039I1a!\u000e\u000e\u0003\u001d\u0001\u0018mY6bO\u0016LAa!\u000f\u0004<\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0007ki\u0001bBB U\u0011%1\u0011I\u0001\u0018aJ|7-Z:t\u0007\"\fgN\\3m\u000bb\u001cW\r\u001d;j_:$\u0002ba\u0003\u0004D\r\u001d3\u0011\n\u0005\t\u0007\u000b\u001ai\u00041\u0001\u0002~\u0005I1\r[1o]\u0016d\u0017\n\u001a\u0005\t\u0007K\u0019i\u00041\u0001\u0002~!A1\u0011FB\u001f\u0001\u0004\u0019Y\u0003C\u0004\u0004N)\"Iaa\u0007\u0002'A\u0014xnY3tg:+wOU3ta>t7/Z:\t\u0011\rE#\u0006\"\u0005\u0003\u0007'\nAb]3oIJ+7\u000f]8og\u0016$baa\u0003\u0004V\re\u0003\u0002CB,\u0007\u001f\u0002\rAa,\u0002\u0011I,7\u000f]8og\u0016D\u0001ba\u0017\u0004P\u0001\u00071QL\u0001\re\u0016\u001c\bo\u001c8tKN+g\u000e\u001a\t\u0004E\u000e}\u0013bAB1G\n!1+\u001a8e\u0011\u001d\u0019)G\u000bC\u0005\u00077\tA\u0001]8mY\"91\u0011\u000e\u0016\u0005\n\rm\u0011\u0001\u00079s_\u000e,7o]\"p[BdW\r^3e%\u0016\u001cW-\u001b<fg\"91Q\u000e\u0016\u0005\n\rm\u0011!\u00069s_\u000e,7o]\"p[BdW\r^3e'\u0016tGm\u001d\u0005\b\u0007cRC\u0011BB:\u0003Q)\b\u000fZ1uKJ+\u0017/^3ti6+GO]5dgR!11BB;\u0011!\u00199fa\u001cA\u0002\t=\u0006bBB=U\u0011%11D\u0001\u0014aJ|7-Z:t\t&\u001c8m\u001c8oK\u000e$X\r\u001a\u0005\b\u0007{RC\u0011BB@\u0003\u0015\u0019Gn\\:f)\u0011\u0019Ya!!\t\u0011\r\r51\u0010a\u0001\u0003{\nAbY8o]\u0016\u001cG/[8o\u0013\u0012Dqaa\"+\t\u0003\u0019I)\u0001\u0004bG\u000e,\u0007\u000f\u001e\u000b\u0005\u0007\u0017\u0019Y\t\u0003\u0005\u0004\u000e\u000e\u0015\u0005\u0019\u0001BE\u00035\u0019xnY6fi\u000eC\u0017M\u001c8fY\"91\u0011\u0013\u0016\u0005\n\rm\u0011aF2p]\u001aLw-\u001e:f\u001d\u0016<8i\u001c8oK\u000e$\u0018n\u001c8t\u0011\u001d\u0019)J\u000bC\u0005\u00077\t\u0001b\u00197pg\u0016\fE\u000e\u001c\u0005\t\u0007\u0007SC\u0011\u0003\u0002\u0004\u001aR!\u0011QPBN\u0011!\u0019ija&A\u0002\r}\u0015AB:pG.,G\u000f\u0005\u0003\u0004\"\u000e\u001dVBABR\u0015\r\u0019)\u000bH\u0001\u0004]\u0016$\u0018\u0002BBU\u0007G\u0013aaU8dW\u0016$\b\u0002CBWU\u0011\u0005!aa,\u0002\u001f\u0015t\u0017/^3vKJ+7\u000f]8og\u0016$Baa\u0003\u00042\"A1qKBV\u0001\u0004\u0011y\u000bC\u0004\u00046*\"Iaa.\u0002\u001f\u0011,\u0017/^3vKJ+7\u000f]8og\u0016$\"Aa,\t\u000f\rm&\u0006\"\u0001\u0003o\u0005\t\"/Z:q_:\u001cX-U;fk\u0016\u001c\u0016N_3\t\u000f\r}&\u0006\"\u0001\u0003o\u0005)\u0012N\u001c4mS\u001eDGOU3ta>t7/Z\"pk:$\b\u0002CBbU\u0011\u0005!a!2\u0002)=\u0004XM\\(s\u00072|7/\u001b8h\u0007\"\fgN\\3m)\u0011\u00199ma4\u0011\u000b1\t9g!3\u0011\u0007\t\u001cY-C\u0002\u0004N\u000e\u0014AbS1gW\u0006\u001c\u0005.\u00198oK2D\u0001ba!\u0004B\u0002\u0007\u0011Q\u0010\u0005\b\u0007'TC\u0011BBk\u0003YA\u0017M\u001c3mK\u000eC\u0017M\u001c8fY6+H/Z#wK:$HCBB\u0006\u0007/\u001cI\u000e\u0003\u0005\u0004\u0004\u000eE\u0007\u0019AA?\u0011!\u0019Yn!5A\u0002\ru\u0017!B3wK:$\b\u0003BBp\u0007stAa!9\u0004v:!11]Bz\u001d\u0011\u0019)o!=\u000f\t\r\u001d8q\u001e\b\u0005\u0007S\u001ciO\u0004\u0003\u0002\u0004\u000e-\u0018\"A%\n\u0005\u001dC\u0015BA\u0003G\u0013\t!U)\u0003\u0002\u0004\u0007&\u00191q_2\u0002\u0019-\u000bgm[1DQ\u0006tg.\u001a7\n\t\rm8Q \u0002\u0011\u0007\"\fgN\\3m\u001bV$X-\u0012<f]RT1aa>d\u0011\u001d!\tA\u000bC\u0005\t\u0007\t\u0001\u0003\u001e:z+:lW\u000f^3DQ\u0006tg.\u001a7\u0015\t\r-AQ\u0001\u0005\t\u0007\u0007\u001by\u00101\u0001\u0002~!AA\u0011\u0002\u0016\u0005\u0002\t!Y!A\u0004dQ\u0006tg.\u001a7\u0015\t\r\u001dGQ\u0002\u0005\t\u0007\u0007#9\u00011\u0001\u0002~!AA\u0011\u0003\u0016\u0005\u0002\t!\u0019\"A\tok6\u001cF/Y4fIJ+7-Z5wKN$2\u0001\u000fC\u000b\u0011!\u0019\u0019\tb\u0004A\u0002\u0005u\u0004b\u0002C\rU\u0011\u000531D\u0001\u0007o\u0006\\W-\u001e9\t\u000f\u0011u!\u0006\"\u0011\u0004\u001c\u0005A1\u000f[;uI><h\u000e")
public class Processor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Processor$ConnectionId$ ConnectionId$module;
    private final int id;
    private final Time time;
    private final int maxRequestSize;
    private final RequestChannel requestChannel;
    private final ConnectionQuotas connectionQuotas;
    private final long connectionsMaxIdleMs;
    private final int failedAuthenticationDelayMs;
    private final ListenerName listenerName;
    private final SecurityProtocol securityProtocol;
    private final KafkaConfig config;
    public final Metrics kafka$network$Processor$$metrics;
    private final MemoryPool memoryPool;
    private final LogContext logContext;
    private final ConcurrentLinkedQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses;
    private final LinkedBlockingDeque<RequestChannel.Response> responseQueue;
    private final java.util.Map<String, String> metricTags;
    private final Selector selector;
    private int nextConnectionIndex;

    public static String ListenerMetricTag() {
        return Processor$.MODULE$.ListenerMetricTag();
    }

    public static String NetworkProcessorMetricTag() {
        return Processor$.MODULE$.NetworkProcessorMetricTag();
    }

    public static String IdlePercentMetricName() {
        return Processor$.MODULE$.IdlePercentMetricName();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    private Processor$ConnectionId$ ConnectionId() {
        if (this.ConnectionId$module == null) {
            this.ConnectionId$lzycompute$1();
        }
        return this.ConnectionId$module;
    }

    public int id() {
        return this.id;
    }

    private ConcurrentLinkedQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    private scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses() {
        return this.inflightResponses;
    }

    private LinkedBlockingDeque<RequestChannel.Response> responseQueue() {
        return this.responseQueue;
    }

    public java.util.Map<String, String> metricTags() {
        return this.metricTags;
    }

    private Selector selector() {
        return this.selector;
    }

    public Selector createSelector(ChannelBuilder channelBuilder) {
        ChannelBuilder channelBuilder2 = channelBuilder;
        if (channelBuilder2 instanceof Reconfigurable) {
            ChannelBuilder channelBuilder3 = channelBuilder2;
            this.config.addReconfigurable((Reconfigurable)channelBuilder3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return new Selector(this.maxRequestSize, this.connectionsMaxIdleMs, this.failedAuthenticationDelayMs, this.kafka$network$Processor$$metrics, this.time, "socket-server", this.metricTags(), false, true, channelBuilder, this.memoryPool, this.logContext);
    }

    private int nextConnectionIndex() {
        return this.nextConnectionIndex;
    }

    private void nextConnectionIndex_$eq(int x$1) {
        this.nextConnectionIndex = x$1;
    }

    @Override
    public void run() {
        block7: {
            this.startupComplete();
            block5: while (true) {
                while (this.isRunning()) {
                    try {
                        this.configureNewConnections();
                        this.processNewResponses();
                        this.poll();
                        this.processCompletedReceives();
                        this.processCompletedSends();
                        this.processDisconnected();
                        continue block5;
                    }
                    catch (Throwable e) {
                        this.processException("Processor got uncaught exception.", e);
                    }
                }
                break block7;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Closing selector - processor ").append(this.id()).toString());
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.closeAll(), this, Level.ERROR);
                this.shutdownComplete();
            }
        }
    }

    private void processException(String errorMessage, Throwable throwable) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof ControlThrowable) {
            ControlThrowable controlThrowable = (ControlThrowable)throwable2;
            throw (Throwable)controlThrowable;
        }
        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void processChannelException(String channelId, String errorMessage, Throwable throwable) {
        if (this.openOrClosingChannel(channelId).isDefined()) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Closing socket for ").append(channelId).append(" because of error").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
            this.close(channelId);
        }
        this.processException(errorMessage, throwable);
    }

    private void processNewResponses() {
        RequestChannel.Response currentResponse = null;
        while ((currentResponse = this.dequeueResponse()) != null) {
            String channelId = currentResponse.request().context().connectionId;
            try {
                BoxedUnit boxedUnit;
                RequestChannel.Response response = currentResponse;
                if (response instanceof RequestChannel.NoOpResponse) {
                    RequestChannel.NoOpResponse noOpResponse = (RequestChannel.NoOpResponse)response;
                    this.updateRequestMetrics(noOpResponse);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Socket server received empty response to send, registering for read: ").append(noOpResponse).toString());
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                    this.tryUnmuteChannel(channelId);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (response instanceof RequestChannel.SendResponse) {
                    RequestChannel.SendResponse sendResponse = (RequestChannel.SendResponse)response;
                    this.sendResponse(sendResponse, sendResponse.responseSend());
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (response instanceof RequestChannel.CloseConnectionResponse) {
                    RequestChannel.CloseConnectionResponse closeConnectionResponse = (RequestChannel.CloseConnectionResponse)response;
                    this.updateRequestMetrics(closeConnectionResponse);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing socket connection actively according to the response code.");
                    this.close(channelId);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (response instanceof RequestChannel.StartThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_STARTED);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (response instanceof RequestChannel.EndThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_ENDED);
                    this.tryUnmuteChannel(channelId);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new IllegalArgumentException(new StringBuilder(23).append("Unknown response type: ").append(currentResponse.getClass()).toString());
            }
            catch (Throwable e) {
                this.processChannelException(channelId, new StringBuilder(40).append("Exception while processing response for ").append(channelId).toString(), e);
            }
        }
    }

    public void sendResponse(RequestChannel.Response response, Send responseSend) {
        block1: {
            String connectionId = response.request().context().connectionId;
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Socket server received response to send to ").append(connectionId).append(", registering for write and sending data: ").append(response).toString());
            if (this.channel(connectionId).isEmpty()) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Attempting to send response via channel for which there is no open connection, connection id ").append(connectionId).toString());
                response.request().updateRequestMetrics(0L, response);
            }
            if (!this.openOrClosingChannel(connectionId).isDefined()) break block1;
            this.selector().send(responseSend);
            this.inflightResponses().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)connectionId), (Object)response));
        }
    }

    private void poll() {
        try {
            this.selector().poll(300L);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalStateException ? true : throwable2 instanceof IOException;
            if (bl) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Processor ").append(this.id()).append(" poll failed").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private void processCompletedReceives() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().completedReceives()).asScala()).foreach((Function1 & Serializable & scala.Serializable)receive -> {
            Processor.$anonfun$processCompletedReceives$1(this, receive);
            return BoxedUnit.UNIT;
        });
    }

    private void processCompletedSends() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().completedSends()).asScala()).foreach((Function1 & Serializable & scala.Serializable)send -> {
            Processor.$anonfun$processCompletedSends$1(this, send);
            return BoxedUnit.UNIT;
        });
    }

    private void updateRequestMetrics(RequestChannel.Response response) {
        RequestChannel.Request request = response.request();
        long networkThreadTimeNanos = BoxesRunTime.unboxToLong((Object)this.openOrClosingChannel(request.context().connectionId).fold((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L, (Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.getAndResetNetworkThreadTimeNanos())));
        request.updateRequestMetrics(networkThreadTimeNanos, response);
    }

    private void processDisconnected() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.selector().disconnected().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)connectionId -> {
            Processor.$anonfun$processDisconnected$1(this, connectionId);
            return BoxedUnit.UNIT;
        });
    }

    private void close(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable & scala.Serializable)channel -> {
            Processor.$anonfun$close$4(this, connectionId, channel);
            return BoxedUnit.UNIT;
        });
    }

    public void accept(SocketChannel socketChannel) {
        this.newConnections().add(socketChannel);
        this.wakeup();
    }

    private void configureNewConnections() {
        while (!this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Processor ").append(this.id()).append(" listening to new connection from ").append(channel.socket().getRemoteSocketAddress()).toString());
                this.selector().register(this.connectionId(channel.socket()), channel);
            }
            catch (Throwable e) {
                SocketAddress remoteAddress = channel.socket().getRemoteSocketAddress();
                this.close(channel);
                this.processException(new StringBuilder(34).append("Processor ").append(this.id()).append(" closed connection from ").append(remoteAddress).toString(), e);
            }
        }
    }

    private void closeAll() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().channels()).asScala()).foreach((Function1 & Serializable & scala.Serializable)channel -> {
            this.close(channel.id());
            return BoxedUnit.UNIT;
        });
        this.selector().close();
        this.removeMetric(Processor$.MODULE$.IdlePercentMetricName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)((Object)BoxesRunTime.boxToInteger((int)this.id())).toString())}))));
    }

    public String connectionId(Socket socket) {
        String localHost = socket.getLocalAddress().getHostAddress();
        int localPort = socket.getLocalPort();
        String remoteHost = socket.getInetAddress().getHostAddress();
        int remotePort = socket.getPort();
        String connId = new ConnectionId(this, localHost, localPort, remoteHost, remotePort, this.nextConnectionIndex()).toString();
        this.nextConnectionIndex_$eq(this.nextConnectionIndex() == Integer.MAX_VALUE ? 0 : this.nextConnectionIndex() + 1);
        return connId;
    }

    public void enqueueResponse(RequestChannel.Response response) {
        this.responseQueue().put(response);
        this.wakeup();
    }

    /*
     * WARNING - void declaration
     */
    private RequestChannel.Response dequeueResponse() {
        void var1_1;
        block0: {
            RequestChannel.Response response = this.responseQueue().poll();
            if (response == null) break block0;
            response.request().responseDequeueTimeNanos_$eq(Time.SYSTEM.nanoseconds());
        }
        return var1_1;
    }

    public int responseQueueSize() {
        return this.responseQueue().size();
    }

    public int inflightResponseCount() {
        return this.inflightResponses().size();
    }

    public Option<KafkaChannel> openOrClosingChannel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId)).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)this.selector().closingChannel(connectionId)));
    }

    private void handleChannelMuteEvent(String connectionId, KafkaChannel.ChannelMuteEvent event) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable & scala.Serializable)c -> {
            c.handleChannelMuteEvent(event);
            return BoxedUnit.UNIT;
        });
    }

    private void tryUnmuteChannel(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable & scala.Serializable)c -> {
            Processor.$anonfun$tryUnmuteChannel$1(this, c);
            return BoxedUnit.UNIT;
        });
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
    }

    public int numStagedReceives(String connectionId) {
        return BoxesRunTime.unboxToInt((Object)this.openOrClosingChannel(connectionId).map((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToInteger((int)Processor.$anonfun$numStagedReceives$1(this, c))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    @Override
    public void wakeup() {
        this.selector().wakeup();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.removeMetric("IdlePercent", (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor"), (Object)((Object)BoxesRunTime.boxToInteger((int)this.id())).toString())}))));
    }

    private final void ConnectionId$lzycompute$1() {
        Processor processor = this;
        synchronized (processor) {
            if (this.ConnectionId$module == null) {
                this.ConnectionId$module = new Processor$ConnectionId$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$processCompletedReceives$1(Processor $this, NetworkReceive receive) {
        try {
            Option<KafkaChannel> option = $this.openOrClosingChannel(receive.source());
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringBuilder(66).append("Channel ").append(receive.source()).append(" removed from selector before processing completed receive").toString());
                }
                throw new MatchError(option);
            }
            Some some = (Some)option;
            KafkaChannel channel = (KafkaChannel)some.value();
            RequestHeader header = RequestHeader.parse((ByteBuffer)receive.payload());
            String connectionId = receive.source();
            RequestContext context = new RequestContext(header, connectionId, channel.socketAddress(), channel.principal(), $this.listenerName, $this.securityProtocol);
            RequestChannel.Request req = new RequestChannel.Request($this.id(), context, $this.time.nanoseconds(), $this.memoryPool, receive.payload(), $this.requestChannel.metrics());
            $this.requestChannel.sendRequest(req);
            $this.selector().mute(connectionId);
            $this.handleChannelMuteEvent(connectionId, KafkaChannel.ChannelMuteEvent.REQUEST_RECEIVED);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        catch (Throwable e) {
            $this.processChannelException(receive.source(), new StringBuilder(40).append("Exception while processing request from ").append(receive.source()).toString(), e);
        }
    }

    public static final /* synthetic */ void $anonfun$processCompletedSends$1(Processor $this, Send send) {
        try {
            RequestChannel.Response response = (RequestChannel.Response)$this.inflightResponses().remove((Object)send.destination()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(51).append("Send for ").append(send.destination()).append(" completed, but not in `inflightResponses`").toString());
            });
            $this.updateRequestMetrics(response);
            response.onComplete().foreach((Function1 & Serializable & scala.Serializable)onComplete -> {
                onComplete.apply((Object)send);
                return BoxedUnit.UNIT;
            });
            $this.handleChannelMuteEvent(send.destination(), KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
            $this.tryUnmuteChannel(send.destination());
        }
        catch (Throwable e) {
            $this.processChannelException(send.destination(), new StringBuilder(45).append("Exception while processing completed send to ").append(send.destination()).toString(), e);
        }
    }

    public static final /* synthetic */ void $anonfun$processDisconnected$1(Processor $this, String connectionId) {
        try {
            String remoteHost = ((ConnectionId)$this.ConnectionId().fromString(connectionId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(36).append("connectionId has unexpected format: ").append(connectionId).toString());
            })).remoteHost();
            $this.inflightResponses().remove((Object)connectionId).foreach((Function1 & Serializable & scala.Serializable)response -> {
                $this.updateRequestMetrics(response);
                return BoxedUnit.UNIT;
            });
            $this.connectionQuotas.dec(InetAddress.getByName(remoteHost));
        }
        catch (Throwable e) {
            $this.processException(new StringBuilder(44).append("Exception while processing disconnection of ").append(connectionId).toString(), e);
        }
    }

    public static final /* synthetic */ void $anonfun$close$4(Processor $this, String connectionId$2, KafkaChannel channel) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Closing selector connection ").append(connectionId$2).toString());
        InetAddress address = channel.socketAddress();
        if (address != null) {
            $this.connectionQuotas.dec(address);
        }
        $this.selector().close(connectionId$2);
        $this.inflightResponses().remove((Object)connectionId$2).foreach((Function1 & Serializable & scala.Serializable)response -> {
            $this.updateRequestMetrics(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$tryUnmuteChannel$1(Processor $this, KafkaChannel c) {
        $this.selector().unmute(c.id());
    }

    public static final /* synthetic */ int $anonfun$numStagedReceives$1(Processor $this, KafkaChannel c) {
        return $this.selector().numStagedReceives(c);
    }

    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, int failedAuthenticationDelayMs, ListenerName listenerName, SecurityProtocol securityProtocol, KafkaConfig config, Metrics metrics, CredentialProvider credentialProvider, MemoryPool memoryPool, LogContext logContext) {
        this.id = id;
        this.time = time;
        this.maxRequestSize = maxRequestSize;
        this.requestChannel = requestChannel;
        this.connectionQuotas = connectionQuotas;
        this.connectionsMaxIdleMs = connectionsMaxIdleMs;
        this.failedAuthenticationDelayMs = failedAuthenticationDelayMs;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.config = config;
        this.kafka$network$Processor$$metrics = metrics;
        this.memoryPool = memoryPool;
        this.logContext = logContext;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.newConnections = new ConcurrentLinkedQueue();
        this.inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.responseQueue = new LinkedBlockingDeque();
        this.metricTags = (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)LinkedHashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)listenerName.value()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString())}))).asJava();
        this.newGauge(Processor$.MODULE$.IdlePercentMetricName(), new Gauge<Object>(this){
            private final /* synthetic */ Processor $outer;

            public double value() {
                return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)this.$outer.kafka$network$Processor$$metrics.metric(this.$outer.kafka$network$Processor$$metrics.metricName("io-wait-ratio", "socket-server-metrics", this.$outer.metricTags()))).fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToDouble((double)$anon$4.$anonfun$value$6(m))));
            }

            public static final /* synthetic */ double $anonfun$value$6(KafkaMetric m) {
                return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$5(), $anonfun$value$6$adapted(org.apache.kafka.common.metrics.KafkaMetric )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString())}))));
        ListenerName listenerName2 = listenerName;
        ListenerName listenerName3 = config.interBrokerListenerName();
        this.selector = this.createSelector(ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (!(listenerName2 != null ? !listenerName2.equals(listenerName3) : listenerName3 != null) ? 1 : 0) != 0, (SecurityProtocol)securityProtocol, (AbstractConfig)config, (CredentialCache)credentialProvider.credentialCache(), (DelegationTokenCache)credentialProvider.tokenCache()));
        this.nextConnectionIndex = 0;
    }

    public class ConnectionId
    implements Product,
    scala.Serializable {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;
        private final int index;
        public final /* synthetic */ Processor $outer;

        public String localHost() {
            return this.localHost;
        }

        public int localPort() {
            return this.localPort;
        }

        public String remoteHost() {
            return this.remoteHost;
        }

        public int remotePort() {
            return this.remotePort;
        }

        public int index() {
            return this.index;
        }

        public String toString() {
            return new StringBuilder(4).append(this.localHost()).append(":").append(this.localPort()).append("-").append(this.remoteHost()).append(":").append(this.remotePort()).append("-").append(this.index()).toString();
        }

        public ConnectionId copy(String localHost, int localPort, String remoteHost, int remotePort, int index) {
            return new ConnectionId(this.kafka$network$Processor$ConnectionId$$$outer(), localHost, localPort, remoteHost, remotePort, index);
        }

        public String copy$default$1() {
            return this.localHost();
        }

        public int copy$default$2() {
            return this.localPort();
        }

        public String copy$default$3() {
            return this.remoteHost();
        }

        public int copy$default$4() {
            return this.remotePort();
        }

        public int copy$default$5() {
            return this.index();
        }

        public String productPrefix() {
            return "ConnectionId";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.localHost();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.localPort());
                    break;
                }
                case 2: {
                    object = this.remoteHost();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToInteger((int)this.remotePort());
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToInteger((int)this.index());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConnectionId;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.localHost()));
            n = Statics.mix((int)n, (int)this.localPort());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.remoteHost()));
            n = Statics.mix((int)n, (int)this.remotePort());
            n = Statics.mix((int)n, (int)this.index());
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConnectionId)) return false;
            if (((ConnectionId)object).kafka$network$Processor$ConnectionId$$$outer() != this.kafka$network$Processor$ConnectionId$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ConnectionId connectionId = (ConnectionId)x$1;
            String string = this.localHost();
            String string2 = connectionId.localHost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.localPort() != connectionId.localPort()) return false;
            String string3 = this.remoteHost();
            String string4 = connectionId.remoteHost();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.remotePort() != connectionId.remotePort()) return false;
            if (this.index() != connectionId.index()) return false;
            if (!connectionId.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Processor kafka$network$Processor$ConnectionId$$$outer() {
            return this.$outer;
        }

        public ConnectionId(Processor $outer, String localHost, int localPort, String remoteHost, int remotePort, int index) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            this.index = index;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

