/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.ConfigType$;
import kafka.server.CreatePartitionsMetadata;
import kafka.server.DelayedCreatePartitions;
import kafka.server.DelayedDeleteTopics;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DeleteTopicMetadata;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.MetadataCache;
import kafka.server.TopicKey;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.ReassignmentInProgressException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t=g\u0001B\u0001\u0003\u0001\u001d\u0011A\"\u00113nS:l\u0015M\\1hKJT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0005\u0001!qA\u0003\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oOB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\b[\u0016$(/[2t\u0013\tIbCA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkBD\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u0007G>tg-[4\u0016\u0003u\u0001\"AH\u0010\u000e\u0003\tI!\u0001\t\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\tE\u0001\u0011\t\u0011)A\u0005;\u000591m\u001c8gS\u001e\u0004\u0003\u0002C\f\u0001\u0005\u000b\u0007I\u0011\u0001\u0013\u0016\u0003\u0015\u0002\"AJ\u0018\u000e\u0003\u001dR!a\u0006\u0015\u000b\u0005%R\u0013AB2p[6|gN\u0003\u0002\u0006W)\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0013\t\u0001tEA\u0004NKR\u0014\u0018nY:\t\u0011I\u0002!\u0011!Q\u0001\n\u0015\n\u0001\"\\3ue&\u001c7\u000f\t\u0005\ti\u0001\u0011)\u0019!C\u0001k\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012A\u000e\t\u0003=]J!\u0001\u000f\u0002\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0011!Q\u0004A!A!\u0002\u00131\u0014AD7fi\u0006$\u0017\r^1DC\u000eDW\r\t\u0005\ty\u0001\u0011)\u0019!C\u0001{\u0005A!p[\"mS\u0016tG/F\u0001?!\ty$)D\u0001A\u0015\t\tE!\u0001\u0002{W&\u00111\t\u0011\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\t\u0011\u0015\u0003!\u0011!Q\u0001\ny\n\u0011B_6DY&,g\u000e\u001e\u0011\t\u000b\u001d\u0003A\u0011\u0001%\u0002\rqJg.\u001b;?)\u0015I%j\u0013'N!\tq\u0002\u0001C\u0003\u001c\r\u0002\u0007Q\u0004C\u0003\u0018\r\u0002\u0007Q\u0005C\u00035\r\u0002\u0007a\u0007C\u0003=\r\u0002\u0007a\bC\u0004P\u0001\t\u0007I\u0011\u0002)\u0002\u001dQ|\u0007/[2QkJ<\u0017\r^8ssV\t\u0011\u000bE\u0002\u001f%RK!a\u0015\u0002\u00033\u0011+G.Y=fI>\u0003XM]1uS>t\u0007+\u001e:hCR|'/\u001f\t\u0003=UK!A\u0016\u0002\u0003!\u0011+G.Y=fI>\u0003XM]1uS>t\u0007B\u0002-\u0001A\u0003%\u0011+A\bu_BL7\rU;sO\u0006$xN]=!\u0011\u001dQ\u0006A1A\u0005\nm\u000bQ\"\u00193nS:T6n\u00117jK:$X#\u0001/\u0011\u0005}j\u0016B\u00010A\u00055\tE-\\5o5.\u001cE.[3oi\"1\u0001\r\u0001Q\u0001\nq\u000ba\"\u00193nS:T6n\u00117jK:$\b\u0005C\u0004c\u0001\t\u0007I\u0011B2\u0002#\r\u0014X-\u0019;f)>\u0004\u0018n\u0019)pY&\u001c\u00170F\u0001e!\rIQmZ\u0005\u0003M*\u0011aa\u00149uS>t\u0007C\u00015m\u001b\u0005I'B\u00016l\u0003\u0019\u0001x\u000e\\5ds*\u00111AK\u0005\u0003[&\u0014\u0011c\u0011:fCR,Gk\u001c9jGB{G.[2z\u0011\u0019y\u0007\u0001)A\u0005I\u0006\u00112M]3bi\u0016$v\u000e]5d!>d\u0017nY=!\u0011\u001d\t\bA1A\u0005\nI\f\u0011#\u00197uKJ\u001cuN\u001c4jOB{G.[2z+\u0005\u0019\bcA\u0005fiB\u0011\u0001.^\u0005\u0003m&\u0014\u0011#\u00117uKJ\u001cuN\u001c4jOB{G.[2z\u0011\u0019A\b\u0001)A\u0005g\u0006\u0011\u0012\r\u001c;fe\u000e{gNZ5h!>d\u0017nY=!\u0011\u0015Q\b\u0001\"\u0001|\u0003eA\u0017m\u001d#fY\u0006LX\r\u001a+pa&\u001cw\n]3sCRLwN\\:\u0016\u0003q\u0004\"!C?\n\u0005yT!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0003\u0005\"(/_\"p[BdW\r^3EK2\f\u00170\u001a3U_BL7m\u00149fe\u0006$\u0018n\u001c8t)\u0011\t)!a\u0003\u0011\u0007%\t9!C\u0002\u0002\n)\u0011A!\u00168ji\"9\u0011QB@A\u0002\u0005=\u0011!\u0002;pa&\u001c\u0007\u0003BA\t\u0003?qA!a\u0005\u0002\u001cA\u0019\u0011Q\u0003\u0006\u000e\u0005\u0005]!bAA\r\r\u00051AH]8pizJ1!!\b\u000b\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011EA\u0012\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0004\u0006\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*\u0005a1M]3bi\u0016$v\u000e]5dgRQ\u0011QAA\u0016\u0003k\tI$a\u001c\t\u0011\u00055\u0012Q\u0005a\u0001\u0003_\tq\u0001^5nK>,H\u000fE\u0002\n\u0003cI1!a\r\u000b\u0005\rIe\u000e\u001e\u0005\b\u0003o\t)\u00031\u0001}\u000311\u0018\r\\5eCR,wJ\u001c7z\u0011!\tY$!\nA\u0002\u0005u\u0012AC2sK\u0006$X-\u00138g_BA\u0011qHA#\u0003\u001f\tI%\u0004\u0002\u0002B)\u0019\u00111\t\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002H\u0005\u0005#aA'baB!\u00111JA5\u001d\u0011\ti%a\u0019\u000f\t\u0005=\u0013q\f\b\u0005\u0003#\niF\u0004\u0003\u0002T\u0005mc\u0002BA+\u00033rA!!\u0006\u0002X%\ta&\u0003\u0002-[%\u0011QaK\u0005\u0003S)J1!!\u0019)\u0003!\u0011X-];fgR\u001c\u0018\u0002BA3\u0003O\n1c\u0011:fCR,Gk\u001c9jGN\u0014V-];fgRT1!!\u0019)\u0013\u0011\tY'!\u001c\u0003\u0019Q{\u0007/[2EKR\f\u0017\u000e\\:\u000b\t\u0005\u0015\u0014q\r\u0005\t\u0003c\n)\u00031\u0001\u0002t\u0005\u0001\"/Z:q_:\u001cXmQ1mY\n\f7m\u001b\t\b\u0013\u0005U\u0014\u0011PA\u0003\u0013\r\t9H\u0003\u0002\n\rVt7\r^5p]F\u0002\u0002\"a\u0010\u0002F\u0005=\u00111\u0010\t\u0005\u0003{\ny(\u0004\u0002\u0002h%!\u0011\u0011QA4\u0005!\t\u0005/[#se>\u0014\bbBAC\u0001\u0011\u0005\u0011qQ\u0001\rI\u0016dW\r^3U_BL7m\u001d\u000b\t\u0003\u000b\tI)a#\u0002\u0016\"A\u0011QFAB\u0001\u0004\ty\u0003\u0003\u0005\u0002\u000e\u0006\r\u0005\u0019AAH\u0003\u0019!x\u000e]5dgB1\u0011qHAI\u0003\u001fIA!a%\u0002B\t\u00191+\u001a;\t\u0011\u0005E\u00141\u0011a\u0001\u0003/\u0003r!CA;\u00033\u000b)\u0001\u0005\u0005\u0002@\u0005\u0015\u0013qBAN!\u0011\ti*a)\u000e\u0005\u0005}%bAAQQ\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0002&\u0006}%AB#se>\u00148\u000fC\u0004\u0002*\u0002!\t!a+\u0002!\r\u0014X-\u0019;f!\u0006\u0014H/\u001b;j_:\u001cH\u0003DA\u0003\u0003[\u000by+a1\u0002F\u0006U\u0007\u0002CA\u0017\u0003O\u0003\r!a\f\t\u0011\u0005E\u0016q\u0015a\u0001\u0003g\u000bQB\\3x!\u0006\u0014H/\u001b;j_:\u001c\b\u0003CA \u0003\u000b\ny!!.\u0011\t\u0005]\u0016Q\u0018\b\u0005\u0003\u001b\nI,\u0003\u0003\u0002<\u0006\u001d\u0014aF\"sK\u0006$X\rU1si&$\u0018n\u001c8t%\u0016\fX/Z:u\u0013\u0011\ty,!1\u0003!A\u000b'\u000f^5uS>tG)\u001a;bS2\u001c(\u0002BA^\u0003OBq!a\u000e\u0002(\u0002\u0007A\u0010\u0003\u0005\u0002H\u0006\u001d\u0006\u0019AAe\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f!\u0011\tY-!5\u000e\u0005\u00055'bAAhQ\u00059a.\u001a;x_J\\\u0017\u0002BAj\u0003\u001b\u0014A\u0002T5ti\u0016tWM\u001d(b[\u0016D\u0001\"a6\u0002(\u0002\u0007\u00111O\u0001\tG\u0006dGNY1dW\"9\u00111\u001c\u0001\u0005\u0002\u0005u\u0017a\u00043fg\u000e\u0014\u0018NY3D_:4\u0017nZ:\u0015\r\u0005}\u0017\u0011 B\u0001!!\ty$!\u0012\u0002b\u0006-\b\u0003BAr\u0003Ol!!!:\u000b\u0005mA\u0013\u0002BAu\u0003K\u0014abQ8oM&<'+Z:pkJ\u001cW\r\u0005\u0003\u0002n\u0006Mh\u0002BA?\u0003_LA!!=\u0002h\u00059B)Z:de&\u0014WmQ8oM&<7OU3ta>t7/Z\u0005\u0005\u0003k\f9P\u0001\u0004D_:4\u0017n\u001a\u0006\u0005\u0003c\f9\u0007\u0003\u0005\u0002|\u0006e\u0007\u0019AA\u007f\u0003U\u0011Xm]8ve\u000e,Gk\\\"p]\u001aLwMT1nKN\u0004\u0002\"a\u0010\u0002F\u0005\u0005\u0018q \t\u0005\u0013\u0015\fy\tC\u0004\u0003\u0004\u0005e\u0007\u0019\u0001?\u0002\u001f%t7\r\\;eKNKhn\u001c8z[NDqAa\u0002\u0001\t\u0003\u0011I!\u0001\u0007bYR,'oQ8oM&<7\u000f\u0006\u0004\u0003\f\t5!q\u0004\t\t\u0003\u007f\t)%!9\u0002|!A!q\u0002B\u0003\u0001\u0004\u0011\t\"A\u0004d_:4\u0017nZ:\u0011\u0011\u0005}\u0012QIAq\u0005'\u0001BA!\u0006\u0003\u001c9!\u0011Q\u0010B\f\u0013\u0011\u0011I\"a\u001a\u0002'\u0005cG/\u001a:D_:4\u0017nZ:SKF,Xm\u001d;\n\t\u0005U(Q\u0004\u0006\u0005\u00053\t9\u0007C\u0004\u00028\t\u0015\u0001\u0019\u0001?\t\u000f\t\r\u0002\u0001\"\u0001\u0003&\u0005A1\u000f[;uI><h\u000e\u0006\u0002\u0002\u0006!9!\u0011\u0006\u0001\u0005\n\t-\u0012A\u0006:fg>,(oY3OC6,Gk\u001c\"s_.,'/\u00133\u0015\t\u0005=\"Q\u0006\u0005\t\u0005_\u00119\u00031\u0001\u0002\u0010\u0005a!/Z:pkJ\u001cWMT1nK\"9!1\u0007\u0001\u0005\n\tU\u0012A\u00042s_.,'oU=o_:LXn\u001d\u000b\u0005\u0005o\u0011I\u0005\u0005\u0004\u0003:\t\r\u0013q\u0002\b\u0005\u0005w\u0011yD\u0004\u0003\u0002\u0016\tu\u0012\"A\u0006\n\u0007\t\u0005#\"A\u0004qC\u000e\\\u0017mZ3\n\t\t\u0015#q\t\u0002\u0005\u0019&\u001cHOC\u0002\u0003B)A\u0001Ba\u0013\u00032\u0001\u0007\u0011qB\u0001\u0005]\u0006lW\rC\u0004\u0003P\u0001!IA!\u0015\u0002\u0015\r|gNZ5h)f\u0004X\r\u0006\u0004\u0003T\t\u0005$1\r\t\u0005\u0005+\u0012YF\u0004\u0003\u0002d\n]\u0013\u0002\u0002B-\u0003K\f\u0011bQ8oM&<G)\u001a4\n\t\tu#q\f\u0002\u0005)f\u0004XM\u0003\u0003\u0003Z\u0005\u0015\b\u0002\u0003B&\u0005\u001b\u0002\r!a\u0004\t\u0011\t\u0015$Q\na\u0001\u0005o\t\u0001b]=o_:LXn\u001d\u0005\b\u0005S\u0002A\u0011\u0002B6\u00039\u0019wN\u001c4jONKhn\u001c8z[N$\u0002B!\u001c\u0003v\t]$\u0011\u0010\t\u0007\u0005s\u0011\u0019Ea\u001c\u0011\t\u00055(\u0011O\u0005\u0005\u0005g\n9PA\u0007D_:4\u0017nZ*z]>t\u00170\u001c\u0005\t\u0005\u0017\u00129\u00071\u0001\u0002\u0010!A!Q\rB4\u0001\u0004\u00119\u0004C\u0004\u0003|\t\u001d\u0004\u0019\u0001?\u0002\u0017%\u001c8+\u001a8tSRLg/\u001a\u0005\b\u0005\u007f\u0002A\u0011\u0002BA\u0003Y\u0019'/Z1uKR{\u0007/[2D_:4\u0017nZ#oiJLH\u0003\u0003BB\u0005/\u00139Ka/\u0015\r\t\u0015%1\u0012BG!\u0011\tiOa\"\n\t\t%\u0015q\u001f\u0002\f\u0007>tg-[4F]R\u0014\u0018\u0010\u0003\u0005\u0003L\tu\u0004\u0019AA\b\u0011!\u0011yI! A\u0002\tE\u0015!\u0002<bYV,\u0007cA\u0005\u0003\u0014&\u0019!Q\u0013\u0006\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0003\u001a\nu\u0004\u0019\u0001BN\u0003%awnZ\"p]\u001aLw\r\u0005\u0003\u0003\u001e\n\rVB\u0001BP\u0015\r\u0011\t\u000bB\u0001\u0004Y><\u0017\u0002\u0002BS\u0005?\u0013\u0011\u0002T8h\u0007>tg-[4\t\u0011\t%&Q\u0010a\u0001\u0005W\u000b!\u0002^8qS\u000e\u0004&o\u001c9t!\u0011\u0011iKa.\u000e\u0005\t=&\u0002\u0002BY\u0005g\u000bA!\u001e;jY*\u0011!QW\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003:\n=&A\u0003)s_B,'\u000f^5fg\"9!1\u0001B?\u0001\u0004a\bb\u0002B`\u0001\u0011%!\u0011Y\u0001\u0018GJ,\u0017\r^3Ce>\\WM]\"p]\u001aLw-\u00128uef$bAa1\u0003J\n5GC\u0002BC\u0005\u000b\u00149\r\u0003\u0005\u0003L\tu\u0006\u0019AA\b\u0011!\u0011yI!0A\u0002\tE\u0005b\u0002Bf\u0005{\u0003\r\u0001`\u0001\u0010a\u0016\u0014(I]8lKJ\u001cuN\u001c4jO\"9!1\u0001B_\u0001\u0004a\b")
public class AdminManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MetadataCache metadataCache;
    private final KafkaZkClient zkClient;
    private final DelayedOperationPurgatory<DelayedOperation> topicPurgatory;
    private final AdminZkClient adminZkClient;
    private final Option<CreateTopicPolicy> createTopicPolicy;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AdminManager adminManager = this;
        synchronized (adminManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private DelayedOperationPurgatory<DelayedOperation> topicPurgatory() {
        return this.topicPurgatory;
    }

    private AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    private Option<CreateTopicPolicy> createTopicPolicy() {
        return this.createTopicPolicy;
    }

    private Option<AlterConfigPolicy> alterConfigPolicy() {
        return this.alterConfigPolicy;
    }

    public boolean hasDelayedTopicOperations() {
        return this.topicPurgatory().delayed() != 0;
    }

    public void tryCompleteDelayedTopicOperations(String topic) {
        TopicKey key = new TopicKey(topic);
        int completed = this.topicPurgatory().checkAndComplete(key);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Request key ").append(key.keyLabel()).append(" unblocked ").append(completed).append(" topic requests.").toString());
    }

    public void createTopics(int timeout, boolean validateOnly, Map<String, CreateTopicsRequest.TopicDetails> createInfo, Function1<Map<String, ApiError>, BoxedUnit> responseCallback) {
        Seq brokers = (Seq)this.metadataCache().getAliveBrokers().map((Function1 & Serializable & scala.Serializable)b -> new BrokerMetadata(b.id(), b.rack()), Seq$.MODULE$.canBuildFrom());
        Iterable metadata = (Iterable)createInfo.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CreatePartitionsMetadata createPartitionsMetadata;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String topic = (String)tuple2._1();
                CreateTopicsRequest.TopicDetails arguments = (CreateTopicsRequest.TopicDetails)tuple2._2();
                try {
                    Properties configs = new Properties();
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.configs).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String key = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        Object object = configs.setProperty(key, value);
                        return object;
                    });
                    LogConfig$.MODULE$.validate(configs);
                    if (!(arguments.numPartitions == -1 && arguments.replicationFactor == -1 || arguments.replicasAssignments.isEmpty())) {
                        throw new InvalidRequestException("Both numPartitions or replicationFactor and replicasAssignments were set. Both cannot be used at the same time.");
                    }
                    Map<Object, Seq<Object>> assignments = !arguments.replicasAssignments.isEmpty() ? (Map<Object, Seq<Object>>)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.replicasAssignments).asScala()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Integer partitionId = (Integer)tuple2._1();
                        java.util.List replicas = (java.util.List)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1), Buffer$.MODULE$.canBuildFrom()));
                        return tuple22;
                    }, Map$.MODULE$.canBuildFrom()) : AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)brokers, arguments.numPartitions, arguments.replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Assignments for topic ").append(topic).append(" are ").append(assignments).append(" ").toString());
                    Option<CreateTopicPolicy> option = this.createTopicPolicy();
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some = (Some)option;
                        CreateTopicPolicy policy = (CreateTopicPolicy)some.value();
                        this.adminZkClient().validateCreateOrUpdateTopic(topic, assignments, configs, false);
                        Integer numPartitions = arguments.numPartitions == -1 ? null : Predef$.MODULE$.int2Integer(arguments.numPartitions);
                        Short replicationFactor = arguments.replicationFactor == -1 ? null : Predef$.MODULE$.short2Short(arguments.replicationFactor);
                        java.util.Map replicaAssignments = arguments.replicasAssignments.isEmpty() ? null : arguments.replicasAssignments;
                        policy.validate(new CreateTopicPolicy.RequestMetadata(topic, numPartitions, replicationFactor, replicaAssignments, arguments.configs));
                        if (!validateOnly) {
                            this.adminZkClient().createOrUpdateTopicPartitionAssignmentPathInZK(topic, assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit;
                        if (validateOnly) {
                            this.adminZkClient().validateCreateOrUpdateTopic(topic, assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.adminZkClient().createOrUpdateTopicPartitionAssignmentPathInZK(topic, assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit;
                    } else {
                        throw new MatchError(option);
                    }
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, assignments, ApiError.NONE);
                }
                catch (ApiException e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Error processing create topic request for topic ").append(topic).append(" with arguments ").append(arguments).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), ApiError.fromThrowable((Throwable)e));
                }
                catch (ConfigException e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Error processing create topic request for topic ").append(topic).append(" with arguments ").append(arguments).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), ApiError.fromThrowable((Throwable)new InvalidConfigurationException(e.getMessage(), e.getCause())));
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Error processing create topic request for topic ").append(topic).append(" with arguments ").append(arguments).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), ApiError.fromThrowable((Throwable)e));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            CreatePartitionsMetadata createPartitionsMetadata2 = createPartitionsMetadata;
            return createPartitionsMetadata2;
        }, Iterable$.MODULE$.canBuildFrom());
        if (timeout <= 0 || validateOnly || !metadata.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createTopics$13(x$2)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)createTopicMetadata -> createTopicMetadata.error().isSuccess() && !validateOnly ? new Tuple2((Object)createTopicMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null)) : new Tuple2((Object)createTopicMetadata.topic(), (Object)createTopicMetadata.error()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
        } else {
            DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, (Seq<CreatePartitionsMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedCreateKeys = ((TraversableOnce)createInfo.keys().map((Function1 & Serializable & scala.Serializable)x$3 -> new TopicKey((String)x$3), Iterable$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
        }
    }

    public void deleteTopics(int timeout, Set<String> topics, Function1<Map<String, Errors>, BoxedUnit> responseCallback) {
        Set metadata = (Set)topics.map((Function1 & Serializable & scala.Serializable)topic -> {
            DeleteTopicMetadata deleteTopicMetadata;
            try {
                this.adminZkClient().deleteTopic((String)topic);
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Error processing delete topic request for topic ").append((String)topic).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.forException((Throwable)e));
            }
            return deleteTopicMetadata;
        }, Set$.MODULE$.canBuildFrom());
        if (timeout <= 0 || !metadata.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$deleteTopics$4(x$4)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)deleteTopicMetadata -> {
                Errors errors = deleteTopicMetadata.error();
                Errors errors2 = Errors.NONE;
                return !(errors != null ? !errors.equals(errors2) : errors2 != null) ? new Tuple2((Object)deleteTopicMetadata.topic(), (Object)Errors.REQUEST_TIMED_OUT) : new Tuple2((Object)deleteTopicMetadata.topic(), (Object)deleteTopicMetadata.error());
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
        } else {
            DelayedDeleteTopics delayedDelete = new DelayedDeleteTopics(timeout, (Seq<DeleteTopicMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedDeleteKeys = ((SetLike)topics.map((Function1 & Serializable & scala.Serializable)x$5 -> new TopicKey((String)x$5), Set$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedDelete, (Seq<Object>)delayedDeleteKeys);
        }
    }

    public void createPartitions(int timeout, Map<String, CreatePartitionsRequest.PartitionDetails> newPartitions, boolean validateOnly, ListenerName listenerName, Function1<Map<String, ApiError>, BoxedUnit> callback) {
        boolean reassignPartitionsInProgress = this.zkClient().reassignPartitionsInProgress();
        Seq<BrokerMetadata> allBrokers = this.adminZkClient().getBrokerMetadatas(this.adminZkClient().getBrokerMetadatas$default$1(), this.adminZkClient().getBrokerMetadatas$default$2());
        Seq allBrokerIds = (Seq)allBrokers.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()), Seq$.MODULE$.canBuildFrom());
        Iterable metadata = (Iterable)newPartitions.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            CreatePartitionsMetadata createPartitionsMetadata;
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                String topic = (String)tuple2._1();
                CreatePartitionsRequest.PartitionDetails newPartition = (CreatePartitionsRequest.PartitionDetails)tuple2._2();
                try {
                    if (reassignPartitionsInProgress) {
                        throw new ReassignmentInProgressException("A partition reassignment is in progress.");
                    }
                    scala.collection.immutable.Map existingAssignment = (scala.collection.immutable.Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)scala.collection.immutable.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                        Tuple2 tuple2 = x0$5;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        TopicPartition topicPartition = (TopicPartition)tuple2._1();
                        Seq replicas = (Seq)tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (Object)replicas);
                        return tuple22;
                    }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                    if (existingAssignment.isEmpty()) {
                        throw new UnknownTopicOrPartitionException(new StringBuilder(28).append("The topic '").append(topic).append("' does not exist.").toString());
                    }
                    int oldNumPartitions = existingAssignment.size();
                    int newNumPartitions = newPartition.totalCount();
                    int numPartitionsIncrement = newNumPartitions - oldNumPartitions;
                    if (numPartitionsIncrement < 0) {
                        throw new InvalidPartitionsException(new StringBuilder(69).append("Topic currently has ").append(oldNumPartitions).append(" partitions, which is higher than the requested ").append(newNumPartitions).append(".").toString());
                    }
                    if (numPartitionsIncrement == 0) {
                        throw new InvalidPartitionsException(new StringBuilder(30).append("Topic already has ").append(oldNumPartitions).append(" partitions.").toString());
                    }
                    Option reassignment = Option$.MODULE$.apply((Object)newPartition.newAssignments()).map((Function1 & Serializable & scala.Serializable)x$7 -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$7).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$8).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$9)), Buffer$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)assignments -> {
                        scala.collection.immutable.Set unknownBrokers = (scala.collection.immutable.Set)((TraversableOnce)assignments.flatten((Function1)Predef$.MODULE$.$conforms())).toSet().$minus$minus((GenTraversableOnce)allBrokerIds);
                        if (unknownBrokers.nonEmpty()) {
                            throw new InvalidReplicaAssignmentException(new StringBuilder(42).append("Unknown broker(s) in replica assignment: ").append(unknownBrokers.mkString(", ")).append(".").toString());
                        }
                        if (assignments.size() != numPartitionsIncrement) {
                            throw new InvalidReplicaAssignmentException(new StringBuilder(40).append("Increasing the number of partitions by ").append(numPartitionsIncrement).append(" ").append(new StringBuilder(26).append("but ").append(assignments.size()).append(" assignments provided.").toString()).toString());
                        }
                        return ((TraversableOnce)((TraversableLike)assignments.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$6 -> {
                            Tuple2 tuple2 = x0$6;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Buffer replicas = (Buffer)tuple2._1();
                            int index = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(existingAssignment.size() + index))), (Object)replicas);
                            return tuple22;
                        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    });
                    Map<Object, Seq<Object>> updatedReplicaAssignment = this.adminZkClient().addPartitions(topic, (Map<Object, Seq<Object>>)existingAssignment, allBrokers, newPartition.totalCount(), (Option<Map<Object, Seq<Object>>>)reassignment, validateOnly);
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, updatedReplicaAssignment, ApiError.NONE);
                }
                catch (AdminOperationException e) {
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)scala.collection.Map$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
                }
                catch (ApiException e) {
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)scala.collection.Map$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            CreatePartitionsMetadata createPartitionsMetadata2 = createPartitionsMetadata;
            return createPartitionsMetadata2;
        }, Iterable$.MODULE$.canBuildFrom());
        if (timeout <= 0 || validateOnly || !metadata.exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createPartitions$9(x$10)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)createPartitionMetadata -> createPartitionMetadata.error().isSuccess() && !validateOnly ? new Tuple2((Object)createPartitionMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null)) : new Tuple2((Object)createPartitionMetadata.topic(), (Object)createPartitionMetadata.error()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            callback.apply((Object)results);
        } else {
            DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, (Seq<CreatePartitionsMetadata>)metadata.toSeq(), this, callback);
            Seq delayedCreateKeys = ((SetLike)newPartitions.keySet().map((Function1 & Serializable & scala.Serializable)x$11 -> new TopicKey((String)x$11), Set$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
        }
    }

    public Map<ConfigResource, DescribeConfigsResponse.Config> describeConfigs(Map<ConfigResource, Option<Set<String>>> resourceToConfigNames, boolean includeSynonyms) {
        return ((TraversableOnce)resourceToConfigNames.map((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$7;
            if (tuple22 != null) {
                ConfigResource resource = (ConfigResource)tuple22._1();
                Option configNames = (Option)tuple22._2();
                try {
                    DescribeConfigsResponse.Config config;
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        DescribeConfigsResponse.Config config2;
                        String topic = resource.name();
                        Topic.validate((String)topic);
                        if (this.metadataCache().contains(topic)) {
                            Properties topicProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
                            LogConfig logConfig = LogConfig$.MODULE$.fromProps(KafkaServer$.MODULE$.copyKafkaConfigToLog(this.config()), topicProps);
                            config2 = AdminManager.createResponseConfig$1((Map)AdminManager.allConfigs$1(logConfig), (Function2 & Serializable & scala.Serializable)(name, value) -> this.createTopicConfigEntry(logConfig, topicProps, includeSynonyms, (String)name, value), configNames);
                        } else {
                            config2 = new DescribeConfigsResponse.Config(new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, null), Collections.emptyList());
                        }
                        config = config2;
                    } else if (ConfigResource.Type.BROKER.equals(type)) {
                        DescribeConfigsResponse.Config config3;
                        if (resource.name() == null || resource.name().isEmpty()) {
                            config3 = AdminManager.createResponseConfig$1(this.config().dynamicConfig().currentDynamicDefaultConfigs(), (Function2 & Serializable & scala.Serializable)(name, value) -> this.createBrokerConfigEntry(false, includeSynonyms, (String)name, value), configNames);
                        } else if (this.resourceNameToBrokerId(resource.name()) == this.config().brokerId()) {
                            config3 = AdminManager.createResponseConfig$1((Map)AdminManager.allConfigs$1(this.config()), (Function2 & Serializable & scala.Serializable)(name, value) -> this.createBrokerConfigEntry(true, includeSynonyms, (String)name, value), configNames);
                        } else {
                            throw new InvalidRequestException(new StringBuilder(67).append("Unexpected broker id, expected ").append(this.config().brokerId()).append(" or empty string, but received ").append(resource).append(".name").toString());
                        }
                        config = config3;
                    } else {
                        throw new InvalidRequestException(new StringBuilder(27).append("Unsupported resource type: ").append(type).toString());
                    }
                    DescribeConfigsResponse.Config resourceConfig = config;
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)resourceConfig);
                }
                catch (Throwable e) {
                    String message = new StringBuilder(55).append("Error processing describe configs request for resource ").append(resource).toString();
                    if (e instanceof ApiException) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    } else {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    }
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)new DescribeConfigsResponse.Config(ApiError.fromThrowable((Throwable)e), Collections.emptyList()));
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple23 = tuple2;
            return tuple23;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<ConfigResource, ApiError> alterConfigs(Map<ConfigResource, AlterConfigsRequest.Config> configs, boolean validateOnly) {
        return ((TraversableOnce)configs.map((Function1 & Serializable & scala.Serializable)x0$10 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$10;
            if (tuple22 != null) {
                ConfigResource resource = (ConfigResource)tuple22._1();
                AlterConfigsRequest.Config config = (AlterConfigsRequest.Config)tuple22._2();
                try {
                    Tuple2 tuple23;
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        String topic = resource.name();
                        Properties properties = new Properties();
                        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1 & Serializable & scala.Serializable)configEntry -> properties.setProperty(configEntry.name(), configEntry.value()));
                        this.adminZkClient().validateTopicConfig(topic, properties);
                        this.validateConfigPolicy$1(ConfigResource.Type.TOPIC, resource, config);
                        if (!validateOnly) {
                            this.adminZkClient().changeTopicConfig(topic, properties);
                        }
                        tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.NONE);
                    } else if (ConfigResource.Type.BROKER.equals(type)) {
                        None$ none$;
                        if (resource.name() == null || resource.name().isEmpty()) {
                            none$ = None$.MODULE$;
                        } else {
                            int id = this.resourceNameToBrokerId(resource.name());
                            if (id != this.config().brokerId()) {
                                throw new InvalidRequestException(new StringBuilder(51).append("Unexpected broker id, expected ").append(this.config().brokerId()).append(", but received ").append(resource).append(".name").toString());
                            }
                            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)id));
                        }
                        None$ brokerId = none$;
                        Properties configProps = new Properties();
                        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1 & Serializable & scala.Serializable)configEntry -> configProps.setProperty(configEntry.name(), configEntry.value()));
                        boolean perBrokerConfig = brokerId.nonEmpty();
                        this.config().dynamicConfig().validate(configProps, perBrokerConfig);
                        this.validateConfigPolicy$1(ConfigResource.Type.BROKER, resource, config);
                        if (!validateOnly) {
                            if (perBrokerConfig) {
                                this.config().dynamicConfig().reloadUpdatedFilesWithoutConfigChange(configProps);
                            }
                            this.adminZkClient().changeBrokerConfig((Option<Object>)brokerId, this.config().dynamicConfig().toPersistentProps(configProps, perBrokerConfig));
                        }
                        tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.NONE);
                    } else {
                        throw new InvalidRequestException(new StringBuilder(76).append("AlterConfigs is only supported for topics and brokers, but resource type is ").append(type).toString());
                    }
                    tuple2 = tuple23;
                }
                catch (Throwable throwable) {
                    Tuple2 tuple24;
                    Throwable throwable2 = throwable;
                    boolean bl = throwable2 instanceof ConfigException ? true : throwable2 instanceof IllegalArgumentException;
                    if (bl) {
                        String message = new StringBuilder(36).append("Invalid config value for resource ").append(resource).append(": ").append(throwable2.getMessage()).toString();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                        tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.fromThrowable((Throwable)new InvalidRequestException(message, throwable2)));
                    } else if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        String message = new StringBuilder(61).append("Error processing alter configs request for resource ").append(resource).append(", config ").append(config).toString();
                        if (throwable3 instanceof ApiException) {
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                        } else {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                        }
                        tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.fromThrowable((Throwable)throwable3));
                    } else {
                        throw throwable;
                    }
                    tuple2 = tuple24;
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple25 = tuple2;
            return tuple25;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public void shutdown() {
        this.topicPurgatory().shutdown();
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.createTopicPolicy().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.close();
            return BoxedUnit.UNIT;
        }), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterConfigPolicy().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            x$15.close();
            return BoxedUnit.UNIT;
        }), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    private int resourceNameToBrokerId(String resourceName) {
        int n;
        try {
            n = new StringOps(Predef$.MODULE$.augmentString(resourceName)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException(new StringBuilder(41).append("Broker id must be an integer, but it is: ").append(resourceName).toString());
        }
        return n;
    }

    private List<String> brokerSynonyms(String name) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
    }

    private ConfigDef.Type configType(String name, List<String> synonyms) {
        ConfigDef.Type configType = this.config().typeOf(name);
        return configType != null ? configType : (ConfigDef.Type)synonyms.iterator().map((Function1 & Serializable & scala.Serializable)x$1 -> this.config().typeOf((String)x$1)).find((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$configType$2(x$16))).orNull(Predef$.MODULE$.$conforms());
    }

    private List<DescribeConfigsResponse.ConfigSynonym> configSynonyms(String name2, List<String> synonyms, boolean isSensitive) {
        DynamicBrokerConfig dynamicConfig = this.config().dynamicConfig();
        Buffer allSynonyms = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Map<String, String> map = dynamicConfig.currentDynamicBrokerConfigs();
        synonyms.foreach((Function1 & Serializable & scala.Serializable)name -> {
            AdminManager.maybeAddSynonym$1(map, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        Map<String, String> map2 = dynamicConfig.currentDynamicDefaultConfigs();
        synonyms.foreach((Function1 & Serializable & scala.Serializable)name -> {
            AdminManager.maybeAddSynonym$1(map2, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        synonyms.foreach((Function1 & Serializable & scala.Serializable)name -> {
            AdminManager.maybeAddSynonym$1(dynamicConfig.staticBrokerConfigs(), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        synonyms.foreach((Function1 & Serializable & scala.Serializable)name -> {
            AdminManager.maybeAddSynonym$1(dynamicConfig.staticDefaultConfigs(), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        return ((TraversableOnce)allSynonyms.dropWhile((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$configSynonyms$6(name2, s)))).toList();
    }

    private DescribeConfigsResponse.ConfigEntry createTopicConfigEntry(LogConfig logConfig, Properties topicProps, boolean includeSynonyms, String name, Object value) {
        List list;
        ConfigDef.Type configEntryType;
        ConfigDef.Type type = configEntryType = logConfig.typeOf(name);
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        boolean isSensitive = !(type != null ? !type.equals(type2) : type2 != null);
        String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value, (ConfigDef.Type)configEntryType);
        List list2 = (List)LogConfig$.MODULE$.TopicConfigSynonyms().get((Object)name).map((Function1 & Serializable & scala.Serializable)s -> this.configSynonyms((String)s, this.brokerSynonyms((String)s), isSensitive)).getOrElse((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty());
        if (!topicProps.containsKey(name)) {
            list = list2;
        } else {
            DescribeConfigsResponse.ConfigSynonym configSynonym = new DescribeConfigsResponse.ConfigSynonym(name, valueAsString, DescribeConfigsResponse.ConfigSource.TOPIC_CONFIG);
            list = (List)list2.$plus$colon((Object)configSynonym, List$.MODULE$.canBuildFrom());
        }
        List allSynonyms = list;
        DescribeConfigsResponse.ConfigSource source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG : ((DescribeConfigsResponse.ConfigSynonym)allSynonyms.head()).source();
        List synonyms = !includeSynonyms ? List$.MODULE$.empty() : allSynonyms;
        return new DescribeConfigsResponse.ConfigEntry(name, valueAsString, source, isSensitive, false, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava());
    }

    private DescribeConfigsResponse.ConfigEntry createBrokerConfigEntry(boolean perBrokerConfig, boolean includeSynonyms, String name, Object value) {
        String string;
        boolean isSensitive;
        ConfigDef.Type configEntryType;
        List<String> allNames = this.brokerSynonyms(name);
        ConfigDef.Type type = configEntryType = this.configType(name, allNames);
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        boolean bl = !(type == null ? type2 != null : !type.equals(type2)) || configEntryType == null ? true : (isSensitive = false);
        if (isSensitive) {
            string = null;
        } else {
            String string2;
            Object object = value;
            String string3 = object instanceof String ? (string2 = (String)object) : ConfigDef.convertToString((Object)value, (ConfigDef.Type)configEntryType);
            string = string3;
        }
        String valueAsString = string;
        List allSynonyms = (List)this.configSynonyms(name, allNames, isSensitive).filter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createBrokerConfigEntry$1(perBrokerConfig, x$18)));
        List synonyms = !includeSynonyms ? List$.MODULE$.empty() : allSynonyms;
        DescribeConfigsResponse.ConfigSource source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG : ((DescribeConfigsResponse.ConfigSynonym)allSynonyms.head()).source();
        boolean readOnly = !allNames.exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createBrokerConfigEntry$2(elem)));
        return new DescribeConfigsResponse.ConfigEntry(name, valueAsString, source, isSensitive, readOnly, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$createTopics$13(CreatePartitionsMetadata x$2) {
        return x$2.error().is(Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$deleteTopics$4(DeleteTopicMetadata x$4) {
        Errors errors = x$4.error();
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createPartitions$9(CreatePartitionsMetadata x$10) {
        return x$10.error().is(Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$2(Tuple2 x$12) {
        return x$12._2() != null;
    }

    private static final scala.collection.mutable.Map allConfigs$1(AbstractConfig config) {
        return ((MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.originals()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$2(x$12)))).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.values()).asScala());
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$3(Option configNames$1, Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String configName = (String)tuple2._1();
        boolean bl = configNames$1.forall((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.contains((Object)configName)));
        return bl;
    }

    private static final DescribeConfigsResponse.Config createResponseConfig$1(Map configs, Function2 createConfigEntry, Option configNames$1) {
        IndexedSeq filteredConfigPairs = ((TraversableOnce)configs.filter((Function1 & Serializable & scala.Serializable)x0$8 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$3(configNames$1, x0$8)))).toIndexedSeq();
        IndexedSeq configEntries = (IndexedSeq)filteredConfigPairs.map((Function1 & Serializable & scala.Serializable)x0$9 -> {
            Tuple2 tuple2 = x0$9;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            Object value = tuple2._2();
            DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)createConfigEntry.apply((Object)name, value);
            return configEntry;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)configEntries).asJava());
    }

    private final void validateConfigPolicy$1(ConfigResource.Type resourceType, ConfigResource resource$1, AlterConfigsRequest.Config config$1) {
        Option<AlterConfigPolicy> option = this.alterConfigPolicy();
        if (option instanceof Some) {
            Some some = (Some)option;
            AlterConfigPolicy policy = (AlterConfigPolicy)some.value();
            scala.collection.immutable.Map configEntriesMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config$1.entries()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.name(), (Object)entry.value()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            policy.validate(new AlterConfigPolicy.RequestMetadata(new ConfigResource(resourceType, resource$1.name()), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)configEntriesMap).asJava()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ boolean $anonfun$configType$2(ConfigDef.Type x$16) {
        return x$16 != null;
    }

    private static final void maybeAddSynonym$1(Map map, DescribeConfigsResponse.ConfigSource source, String name, boolean isSensitive$1, Buffer allSynonyms$1) {
        map.get((Object)name).map((Function1 & Serializable & scala.Serializable)value -> {
            String configValue = isSensitive$1 ? null : value;
            return allSynonyms$1.$plus$eq((Object)new DescribeConfigsResponse.ConfigSynonym(name, configValue, source));
        });
    }

    public static final /* synthetic */ boolean $anonfun$configSynonyms$6(String name$1, DescribeConfigsResponse.ConfigSynonym s) {
        String string = s.name();
        String string2 = name$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$createBrokerConfigEntry$1(boolean perBrokerConfig$1, DescribeConfigsResponse.ConfigSynonym x$18) {
        if (perBrokerConfig$1) return true;
        DescribeConfigsResponse.ConfigSource configSource = x$18.source();
        DescribeConfigsResponse.ConfigSource configSource2 = DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG;
        if (configSource != null) {
            if (!configSource.equals(configSource2)) return false;
            return true;
        }
        if (configSource2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfigEntry$2(String elem) {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains((Object)elem);
    }

    public AdminManager(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, KafkaZkClient zkClient) {
        this.config = config;
        this.metrics = metrics;
        this.metadataCache = metadataCache;
        this.zkClient = zkClient;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.logIdent_$eq(new StringBuilder(28).append("[Admin Manager on Broker ").append(config.brokerId()).append("]: ").toString());
        this.topicPurgatory = DelayedOperationPurgatory$.MODULE$.apply("topic", config.brokerId(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5());
        this.adminZkClient = new AdminZkClient(zkClient);
        this.createTopicPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class));
        this.alterConfigPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class));
    }
}

