/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.QuotaType$Request$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0001\u0003\u0001\u001d\u0011\u0011d\u00117jK:$(+Z9vKN$\u0018+^8uC6\u000bg.Y4fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0013\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'\u000f\u0003\u0005\u000e\u0001\t\u0015\r\u0011\"\u0003\u000f\u0003\u0019\u0019wN\u001c4jOV\tq\u0002\u0005\u0002\n!%\u0011\u0011C\u0001\u0002\u0019\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'oQ8oM&<\u0007\u0002C\n\u0001\u0005\u0003\u0005\u000b\u0011B\b\u0002\u000f\r|gNZ5hA!AQ\u0003\u0001BC\u0002\u0013%a#A\u0004nKR\u0014\u0018nY:\u0016\u0003]\u0001\"\u0001G\u0011\u000e\u0003eQ!!\u0006\u000e\u000b\u0005ma\u0012AB2p[6|gN\u0003\u0002\u0006;)\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0013\t\u0011\u0013DA\u0004NKR\u0014\u0018nY:\t\u0011\u0011\u0002!\u0011!Q\u0001\n]\t\u0001\"\\3ue&\u001c7\u000f\t\u0005\tM\u0001\u0011)\u0019!C\u0005O\u0005!A/[7f+\u0005A\u0003CA\u0015-\u001b\u0005Q#BA\u0016\u001b\u0003\u0015)H/\u001b7t\u0013\ti#F\u0001\u0003US6,\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\u000bQLW.\u001a\u0011\t\u0011E\u0002!\u0011!Q\u0001\nI\n\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\u0011\u0005MbdB\u0001\u001b;!\t)\u0004(D\u00017\u0015\t9d!\u0001\u0004=e>|GO\u0010\u0006\u0002s\u0005)1oY1mC&\u00111\bO\u0001\u0007!J,G-\u001a4\n\u0005ur$AB*ue&twM\u0003\u0002<q!A\u0001\t\u0001B\u0001B\u0003%\u0011)A\u0007rk>$\u0018mQ1mY\n\f7m\u001b\t\u0004\u0005\u000e+U\"\u0001\u001d\n\u0005\u0011C$AB(qi&|g\u000e\u0005\u0002G\u00156\tqI\u0003\u0002I\u0013\u0006)\u0011/^8uC*\u00111\u0001H\u0005\u0003\u0017\u001e\u00131c\u00117jK:$\u0018+^8uC\u000e\u000bG\u000e\u001c2bG.DQ!\u0014\u0001\u0005\u00029\u000ba\u0001P5oSRtDCB(Q#J\u001bF\u000b\u0005\u0002\n\u0001!)Q\u0002\u0014a\u0001\u001f!)Q\u0003\u0014a\u0001/!)a\u0005\u0014a\u0001Q!)\u0011\u0007\u0014a\u0001e!)\u0001\t\u0014a\u0001\u0003\"9a\u000b\u0001b\u0001\n\u00039\u0016!E7bqRC'o\u001c;uY\u0016$\u0016.\\3NgV\t\u0001\f\u0005\u0002C3&\u0011!\f\u000f\u0002\u0005\u0019>tw\r\u0003\u0004]\u0001\u0001\u0006I\u0001W\u0001\u0013[\u0006DH\u000b\u001b:piRdW\rV5nK6\u001b\b\u0005C\u0003_\u0001\u0011\u0005q,\u0001\u0007fq\u0016l\u0007\u000f^*f]N|'/F\u0001a!\tA\u0012-\u0003\u0002c3\t11+\u001a8t_JDQ\u0001\u001a\u0001\u0005\u0002\u0015\fAB]3d_J$W\t_3naR$\"AZ5\u0011\u0005\t;\u0017B\u000159\u0005\u0011)f.\u001b;\t\u000b)\u001c\u0007\u0019A6\u0002\u000bY\fG.^3\u0011\u0005\tc\u0017BA79\u0005\u0019!u.\u001e2mK\")q\u000e\u0001C\u0001a\u0006yR.Y=cKJ+7m\u001c:e\u0003:$w)\u001a;UQJ|G\u000f\u001e7f)&lW-T:\u0015\u0005E$\bC\u0001\"s\u0013\t\u0019\bHA\u0002J]RDQ!\u001e8A\u0002Y\fqA]3rk\u0016\u001cH\u000f\u0005\u0002x{:\u0011\u0001p_\u0007\u0002s*\u0011!\u0010B\u0001\b]\u0016$xo\u001c:l\u0013\ta\u00180\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\u0005y|(a\u0002*fcV,7\u000f\u001e\u0006\u0003yfDq!a\u0001\u0001\t\u0003\t)!A\tnCf\u0014WMU3d_J$W\t_3naR$2AZA\u0004\u0011\u0019)\u0018\u0011\u0001a\u0001m\"9\u00111\u0002\u0001\u0005R\u00055\u0011\u0001\u0004;ie>$H\u000f\\3US6,Gc\u0001-\u0002\u0010!A\u0011\u0011CA\u0005\u0001\u0004\t\u0019\"\u0001\u0007dY&,g\u000e^'fiJL7\rE\u0002\u0019\u0003+I1!a\u0006\u001a\u0005-Y\u0015MZ6b\u001b\u0016$(/[2\t\u000f\u0005m\u0001\u0001\"\u0015\u0002\u001e\u0005!2\r\\5f]R\u0014\u0016\r^3NKR\u0014\u0018n\u0019(b[\u0016$B!a\b\u0002(A!\u0011\u0011EA\u0012\u001b\u0005Q\u0012bAA\u00135\tQQ*\u001a;sS\u000et\u0015-\\3\t\u0011\u0005%\u0012\u0011\u0004a\u0001\u0003W\tq\"];pi\u0006lU\r\u001e:jGR\u000bwm\u001d\t\u0006g\u00055\"GM\u0005\u0004\u0003_q$aA'ba\"9\u00111\u0007\u0001\u0005\n\u0005U\u0012\u0001E3yK6\u0004H/T3ue&\u001cg*Y7f+\t\ty\u0002C\u0004\u0002:\u0001!I!a\u000f\u0002!\u0015DX-\u001c9u'\u0016t7o\u001c:OC6,W#\u0001\u001a\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B\u0005\tb.\u00198pgR{\u0007+\u001a:dK:$\u0018mZ3\u0015\u0007-\f\u0019\u0005C\u0004\u0002F\u0005u\u0002\u0019\u0001-\u0002\u000b9\fgn\\:")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final Time time;
    private final long maxThrottleTimeMs;

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    public long maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    public Sensor exemptSensor() {
        return this.getOrCreateSensor(this.exemptSensorName(), this.exemptMetricName());
    }

    public void recordExempt(double value) {
        this.exemptSensor().record(value);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request) {
        int n;
        if (request.apiRemoteCompleteTimeNanos() == -1L) {
            request.apiRemoteCompleteTimeNanos_$eq(this.time().nanoseconds());
        }
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> this.recordNoThrottle(this.getOrCreateQuotaSensors(request.session(), request.header().clientId()), this.nanosToPercentage(timeNanos))));
            n = this.recordAndGetThrottleTimeMs(request.session(), request.header().clientId(), this.nanosToPercentage(request.requestThreadTimeNanos()), this.time().milliseconds());
        } else {
            n = 0;
        }
        return n;
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        block0: {
            if (!this.quotasEnabled()) break block0;
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> this.recordExempt(this.nanosToPercentage(timeNanos))));
            this.recordExempt(this.nanosToPercentage(request.requestThreadTimeNanos()));
        }
    }

    @Override
    public long throttleTime(KafkaMetric clientMetric) {
        return package$.MODULE$.min(super.throttleTime(clientMetric), this.maxThrottleTimeMs());
    }

    @Override
    public MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("request-time", QuotaType$Request$.MODULE$.toString(), "Tracking request-time per user/client-id", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(quotaMetricTags).asJava());
    }

    private MetricName exemptMetricName() {
        return this.metrics().metricName("exempt-request-time", QuotaType$Request$.MODULE$.toString(), "Tracking exempt-request-time utilization percentage");
    }

    private String exemptSensorName() {
        return new StringBuilder(7).append("exempt-").append(QuotaType$Request$.MODULE$).toString();
    }

    private double nanosToPercentage(long nanos) {
        return (double)nanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> quotaCallback) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        super(config, metrics, QuotaType$Request$.MODULE$, time, threadNamePrefix, quotaCallback);
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds());
    }
}

