/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import kafka.common.ZkNodeChangeNotificationListener;
import kafka.common.ZkNodeChangeNotificationListener$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.CreateTokenResult;
import kafka.server.DelegationTokenManager$;
import kafka.server.DelegationTokenManager$TokenChangedNotificationHandler$;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.DelegationTokenChangeNotificationSequenceZNode$;
import kafka.zk.DelegationTokenChangeNotificationZNode$;
import kafka.zk.DelegationTokensZNode$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.Time;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r]t!B\u0001\u0003\u0011\u00039\u0011A\u0006#fY\u0016<\u0017\r^5p]R{7.\u001a8NC:\fw-\u001a:\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001C\u0005\u000e\u0003\t1QA\u0003\u0002\t\u0002-\u0011a\u0003R3mK\u001e\fG/[8o)>\\WM\\'b]\u0006<WM]\n\u0003\u00131\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\n\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001d1\u0012B1A\u0005\u0002]\tA\u0003R3gCVdG\u000fS7bG\u0006cwm\u001c:ji\"lW#\u0001\r\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012\u0001\u00027b]\u001eT\u0011!H\u0001\u0005U\u00064\u0018-\u0003\u0002 5\t11\u000b\u001e:j]\u001eDa!I\u0005!\u0002\u0013A\u0012!\u0006#fM\u0006,H\u000e\u001e%nC\u000e\fEnZ8sSRDW\u000e\t\u0005\bG%\u0011\r\u0011\"\u0001\u0018\u0003!yuO\\3s\u0017\u0016L\bBB\u0013\nA\u0003%\u0001$A\u0005Po:,'oS3zA!9q%\u0003b\u0001\n\u00039\u0012a\u0003*f]\u0016<XM]:LKfDa!K\u0005!\u0002\u0013A\u0012\u0001\u0004*f]\u0016<XM]:LKf\u0004\u0003bB\u0016\n\u0005\u0004%\taF\u0001\u0012\u0013N\u001cX/\u001a+j[\u0016\u001cH/Y7q\u0017\u0016L\bBB\u0017\nA\u0003%\u0001$\u0001\nJgN,X\rV5nKN$\u0018-\u001c9LKf\u0004\u0003bB\u0018\n\u0005\u0004%\taF\u0001\u0010\u001b\u0006DH+[7fgR\fW\u000e]&fs\"1\u0011'\u0003Q\u0001\na\t\u0001#T1y)&lWm\u001d;b[B\\U-\u001f\u0011\t\u000fMJ!\u0019!C\u0001/\u0005\u0011R\t\u001f9jef$\u0016.\\3ti\u0006l\u0007oS3z\u0011\u0019)\u0014\u0002)A\u00051\u0005\u0019R\t\u001f9jef$\u0016.\\3ti\u0006l\u0007oS3zA!9q'\u0003b\u0001\n\u00039\u0012A\u0003+pW\u0016t\u0017\nZ&fs\"1\u0011(\u0003Q\u0001\na\t1\u0002V8lK:LEmS3zA!91(\u0003b\u0001\n\u00039\u0012A\u0003,feNLwN\\&fs\"1Q(\u0003Q\u0001\na\t1BV3sg&|gnS3zA!9q(\u0003b\u0001\n\u0003\u0001\u0015AD\"veJ,g\u000e\u001e,feNLwN\\\u000b\u0002\u0003B\u0011QBQ\u0005\u0003\u0007:\u00111!\u00138u\u0011\u0019)\u0015\u0002)A\u0005\u0003\u0006y1)\u001e:sK:$h+\u001a:tS>t\u0007\u0005C\u0004H\u0013\t\u0007I\u0011\u0001!\u0002\u001d\u0015\u0013(o\u001c:US6,7\u000f^1na\"1\u0011*\u0003Q\u0001\n\u0005\u000bq\"\u0012:s_J$\u0016.\\3ti\u0006l\u0007\u000f\t\u0005\u0006\u0017&!\t\u0001T\u0001\u000bGJ,\u0017\r^3I[\u0006\u001cGcA'T?B\u0019QB\u0014)\n\u0005=s!!B!se\u0006L\bCA\u0007R\u0013\t\u0011fB\u0001\u0003CsR,\u0007\"\u0002+K\u0001\u0004)\u0016a\u0002;pW\u0016t\u0017\n\u001a\t\u0003-vs!aV.\u0011\u0005asQ\"A-\u000b\u0005i3\u0011A\u0002\u001fs_>$h(\u0003\u0002]\u001d\u00051\u0001K]3eK\u001aL!a\b0\u000b\u0005qs\u0001\"\u00021K\u0001\u0004)\u0016!C:fGJ,GoS3z\u0011\u0015\u0011\u0017\u0002\"\u0001d\u0003=\u0019'/Z1uKN+7M]3u\u0017\u0016LHC\u00013m!\t)'.D\u0001g\u0015\t9\u0007.\u0001\u0004def\u0004Ho\u001c\u0006\u0002S\u0006)!.\u0019<bq&\u00111N\u001a\u0002\n'\u0016\u001c'/\u001a;LKfDQ!\\1A\u00025\u000b\u0001b[3zEf$Xm\u001d\u0005\u0006_&!\t\u0001]\u0001\u0011GJ,\u0017\r^3CCN,g\u0007\u000e%N\u0003\u000e#2!V9s\u0011\u0015!f\u000e1\u0001V\u0011\u0015\u0001g\u000e1\u0001e\u0011\u0015Y\u0015\u0002\"\u0001u)\riUO\u001e\u0005\u0006)N\u0004\r!\u0016\u0005\u0006AN\u0004\r\u0001\u001a\u0005\u0006q&!\t!_\u0001\u0014i>T5o\u001c8D_6\u0004\u0018\r^5cY\u0016l\u0015\r\u001d\u000b\u0004u\u0006\u0005\u0001\u0003\u0002,|+vL!\u0001 0\u0003\u00075\u000b\u0007\u000f\u0005\u0002\u000e}&\u0011qP\u0004\u0002\u0004\u0003:L\bbBA\u0002o\u0002\u0007\u0011QA\u0001\u0006i>\\WM\u001c\t\u0005\u0003\u000f\t\t#\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003)!W\r\\3hCRLwN\u001c\u0006\u0005\u0003\u0007\tyA\u0003\u0003\u0002\u0012\u0005M\u0011\u0001C:fGV\u0014\u0018\u000e^=\u000b\t\u0005U\u0011qC\u0001\u0007G>lWn\u001c8\u000b\u0007\u0015\tIB\u0003\u0003\u0002\u001c\u0005u\u0011AB1qC\u000eDWM\u0003\u0002\u0002 \u0005\u0019qN]4\n\t\u0005\r\u0012\u0011\u0002\u0002\u0010\t\u0016dWmZ1uS>tGk\\6f]\"9\u0011qE\u0005\u0005\u0002\u0005%\u0012!\u00034s_6\u0014\u0015\u0010^3t)\u0011\tY#a\u000e\u0011\u000b5\ti#!\r\n\u0007\u0005=bB\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u000f\t\u0019$\u0003\u0003\u00026\u0005%!\u0001\u0005+pW\u0016t\u0017J\u001c4pe6\fG/[8o\u0011\u001d\tI$!\nA\u00025\u000bQAY=uKNDq!!\u0010\n\t\u0003\ty$A\u0006gS2$XM\u001d+pW\u0016tGCCA!\u0003\u000f\n9&a\u001c\u0002rA\u0019Q\"a\u0011\n\u0007\u0005\u0015cBA\u0004C_>dW-\u00198\t\u0011\u0005%\u00131\ba\u0001\u0003\u0017\n!C]3rk\u0016\u001cH/\u001a3Qe&t7-\u001b9bYB!\u0011QJA*\u001b\t\tyE\u0003\u0003\u0002R\u0005=\u0011\u0001B1vi\"LA!!\u0016\u0002P\tq1*\u00194lCB\u0013\u0018N\\2ja\u0006d\u0007\u0002CA-\u0003w\u0001\r!a\u0017\u0002\r=<h.\u001a:t!\u0015i\u0011QFA/!\u0019\ty&!\u001b\u0002L9!\u0011\u0011MA3\u001d\rA\u00161M\u0005\u0002\u001f%\u0019\u0011q\r\b\u0002\u000fA\f7m[1hK&!\u00111NA7\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\u001dd\u0002\u0003\u0005\u0002\u0004\u0005m\u0002\u0019AA\u0019\u0011!\t\u0019(a\u000fA\u0002\u0005U\u0014AD1vi\"|'/\u001b>f)>\\WM\u001c\t\u0007\u001b\u0005]T+!\u0011\n\u0007\u0005edBA\u0005Gk:\u001cG/[8oc\u0019)!B\u0001\u0001\u0002~M9\u00111\u0010\u0007\u0002\u0000\u0005-\u0005\u0003BAA\u0003\u000fk!!a!\u000b\u0007\u0005\u0015E!A\u0003vi&d7/\u0003\u0003\u0002\n\u0006\r%a\u0002'pO\u001eLgn\u001a\t\u0005\u0003\u001b\u000b\u0019*\u0004\u0002\u0002\u0010*\u0019\u0011\u0011\u0013\u0003\u0002\u000f5,GO]5dg&!\u0011QSAH\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f\u001d\u0005\f\u00033\u000bYH!b\u0001\n\u0003\tY*\u0001\u0004d_:4\u0017nZ\u000b\u0003\u0003;\u00032\u0001CAP\u0013\r\t\tK\u0001\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0006\u0002&\u0006m$\u0011!Q\u0001\n\u0005u\u0015aB2p]\u001aLw\r\t\u0005\f\u0003S\u000bYH!b\u0001\n\u0003\tY+\u0001\u0006u_.,gnQ1dQ\u0016,\"!!,\u0011\t\u0005=\u0016QW\u0007\u0003\u0003cSA!a-\u0002\n\u0005I\u0011N\u001c;fe:\fGn]\u0005\u0005\u0003o\u000b\tL\u0001\u000bEK2,w-\u0019;j_:$vn[3o\u0007\u0006\u001c\u0007.\u001a\u0005\f\u0003w\u000bYH!A!\u0002\u0013\ti+A\u0006u_.,gnQ1dQ\u0016\u0004\u0003bCA`\u0003w\u0012)\u0019!C\u0001\u0003\u0003\fA\u0001^5nKV\u0011\u00111\u0019\t\u0005\u0003\u000b\fI-\u0004\u0002\u0002H*!\u0011QQA\n\u0013\u0011\tY-a2\u0003\tQKW.\u001a\u0005\f\u0003\u001f\fYH!A!\u0002\u0013\t\u0019-A\u0003uS6,\u0007\u0005C\u0006\u0002T\u0006m$Q1A\u0005\u0002\u0005U\u0017\u0001\u0003>l\u00072LWM\u001c;\u0016\u0005\u0005]\u0007\u0003BAm\u0003?l!!a7\u000b\u0007\u0005uG!\u0001\u0002{W&!\u0011\u0011]An\u00055Y\u0015MZ6b5.\u001cE.[3oi\"Y\u0011Q]A>\u0005\u0003\u0005\u000b\u0011BAl\u0003%Q8n\u00117jK:$\b\u0005C\u0004\u0014\u0003w\"\t!!;\u0015\u0015\u0005-\u0018Q^Ax\u0003c\f\u0019\u0010E\u0002\t\u0003wB\u0001\"!'\u0002h\u0002\u0007\u0011Q\u0014\u0005\t\u0003S\u000b9\u000f1\u0001\u0002.\"A\u0011qXAt\u0001\u0004\t\u0019\r\u0003\u0005\u0002T\u0006\u001d\b\u0019AAl\u000b\u001d\t90a\u001f\u0001\u0003s\u0014ac\u0011:fCR,'+Z:q_:\u001cXmQ1mY\n\f7m\u001b\t\b\u001b\u0005]\u00141 B\u0001!\rA\u0011Q`\u0005\u0004\u0003\u007f\u0014!!E\"sK\u0006$X\rV8lK:\u0014Vm];miB\u0019QBa\u0001\n\u0007\t\u0015aB\u0001\u0003V]&$Xa\u0002B\u0005\u0003w\u0002!1\u0002\u0002\u0016%\u0016tWm\u001e*fgB|gn]3DC2d'-Y2l!%i!Q\u0002B\t\u0005;\u0011\t!C\u0002\u0003\u00109\u0011\u0011BR;oGRLwN\u001c\u001a\u0011\t\tM!\u0011D\u0007\u0003\u0005+QAAa\u0006\u0002\u0014\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0003\u001c\tU!AB#se>\u00148\u000fE\u0002\u000e\u0005?I1A!\t\u000f\u0005\u0011auN\\4\u0006\u000f\t\u0015\u00121\u0010\u0001\u0003\f\t1R\t\u001f9je\u0016\u0014Vm\u001d9p]N,7)\u00197mE\u0006\u001c7.B\u0004\u0003*\u0005m\u0004Aa\u000b\u00031\u0011+7o\u0019:jE\u0016\u0014Vm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000eE\u0005\u000e\u0005\u001b\u0011\tB!\f\u0003\u0002A1\u0011qLA5\u0003\u000bA\u0011\u0002YA>\u0005\u0004%\tA!\r\u0016\u0003\u0011D\u0001B!\u000e\u0002|\u0001\u0006I\u0001Z\u0001\u000bg\u0016\u001c'/\u001a;LKf\u0004\u0003B\u0003B\u001d\u0003w\u0012\r\u0011\"\u0001\u0003<\u0005\u0001Bo\\6f]6\u000b\u0007\u0010T5gKRLW.Z\u000b\u0003\u0005;A\u0011Ba\u0010\u0002|\u0001\u0006IA!\b\u0002#Q|7.\u001a8NCbd\u0015NZ3uS6,\u0007\u0005\u0003\u0006\u0003D\u0005m$\u0019!C\u0001\u0005w\tQ\u0003Z3gCVdG\u000fV8lK:\u0014VM\\3x)&lW\rC\u0005\u0003H\u0005m\u0004\u0015!\u0003\u0003\u001e\u00051B-\u001a4bk2$Hk\\6f]J+g.Z<US6,\u0007\u0005\u0003\u0006\u0003L\u0005m$\u0019!C\u0001\u0005w\t\u0001\u0004^8lK:\u0014V-\\8wKJ\u001c6-\u00198J]R,'O^1m\u0011%\u0011y%a\u001f!\u0002\u0013\u0011i\"A\ru_.,gNU3n_Z,'oU2b]&sG/\u001a:wC2\u0004\u0003B\u0003B*\u0003w\u0012\r\u0011\"\u0003\u0003V\u0005!An\\2l+\t\u00119\u0006E\u0002\u001a\u00053J1Aa\u0017\u001b\u0005\u0019y%M[3di\"I!qLA>A\u0003%!qK\u0001\u0006Y>\u001c7\u000e\t\u0005\u000b\u0005G\nY\b1A\u0005\n\t\u0015\u0014a\u0005;pW\u0016t7\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014XC\u0001B4!\u0011\u0011IG!\u001c\u000e\u0005\t-$bAA\u000b\t%!!q\u000eB6\u0005\u0001R6NT8eK\u000eC\u0017M\\4f\u001d>$\u0018NZ5dCRLwN\u001c'jgR,g.\u001a:\t\u0015\tM\u00141\u0010a\u0001\n\u0013\u0011)(A\fu_.,gn\u00115b]\u001e,G*[:uK:,'o\u0018\u0013fcR!!\u0011\u0001B<\u0011)\u0011IH!\u001d\u0002\u0002\u0003\u0007!qM\u0001\u0004q\u0012\n\u0004\"\u0003B?\u0003w\u0002\u000b\u0015\u0002B4\u0003Q!xn[3o\u0007\"\fgnZ3MSN$XM\\3sA!A!\u0011QA>\t\u0003\u0011\u0019)A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\t\u0005\u0001\u0002\u0003BD\u0003w\"\tAa!\u0002\u0011MDW\u000f\u001e3po:D\u0001Ba#\u0002|\u0011%!1Q\u0001\nY>\fGmQ1dQ\u0016D\u0001Ba$\u0002|\u0011%!\u0011S\u0001\u000fO\u0016$Hk\\6f]\u001a\u0013x.\u001c.l)\u0011\u0011\u0019J!&\u0011\u000b5\ti#!\u0002\t\rQ\u0013i\t1\u0001V\u0011!\u0011I*a\u001f\u0005\n\tm\u0015aC;qI\u0006$XmQ1dQ\u0016$BA!\u0001\u0003\u001e\"A\u00111\u0001BL\u0001\u0004\t)\u0001\u0003\u0005\u0003\"\u0006mD\u0011\u0002BR\u0003]\u0001(/\u001a9be\u0016\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7\u000f\u0006\u0003\u0003&\nM\u0006#\u0002,|+\n\u001d\u0006\u0003\u0002BU\u0005_k!Aa+\u000b\t\t5\u0016qB\u0001\u0006g\u000e\u0014\u0018-\\\u0005\u0005\u0005c\u0013YKA\bTGJ\fWn\u0011:fI\u0016tG/[1m\u0011\u001d\u0011)La(A\u0002U\u000b!\u0002[7bGN#(/\u001b8h\u0011!\u0011I,a\u001f\u0005\u0002\tm\u0016aC2sK\u0006$X\rV8lK:$\"B!\u0001\u0003>\n\u0005'Q\u0019Be\u0011!\u0011yLa.A\u0002\u0005-\u0013!B8x]\u0016\u0014\b\u0002\u0003Bb\u0005o\u0003\r!!\u0018\u0002\u0011I,g.Z<feND\u0001Ba2\u00038\u0002\u0007!QD\u0001\u000e[\u0006DH*\u001b4f)&lW-T:\t\u0011\t-'q\u0017a\u0001\u0005\u001b\f\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\t\t=\u0017Q_\u0007\u0003\u0003wB\u0001Ba5\u0002|\u0011\u0005!Q[\u0001\u000be\u0016tWm\u001e+pW\u0016tGC\u0003B\u0001\u0005/\u0014YNa;\u0003p\"A!\u0011\u001cBi\u0001\u0004\tY%A\u0005qe&t7-\u001b9bY\"A!Q\u001cBi\u0001\u0004\u0011y.\u0001\u0003i[\u0006\u001c\u0007\u0003\u0002Bq\u0005Ol!Aa9\u000b\u0007\t\u0015H$A\u0002oS>LAA!;\u0003d\nQ!)\u001f;f\u0005V4g-\u001a:\t\u0011\t5(\u0011\u001ba\u0001\u0005;\tqB]3oK^d\u0015NZ3US6,Wj\u001d\u0005\t\u0005c\u0014\t\u000e1\u0001\u0003t\u0006i!/\u001a8fo\u000e\u000bG\u000e\u001c2bG.\u0004BAa4\u0003\b!A!q_A>\t\u0013\u0011I0A\u0006va\u0012\fG/\u001a+pW\u0016tG\u0003\u0002B\u0001\u0005wD\u0001\"a\u0001\u0003v\u0002\u0007\u0011Q\u0001\u0005\t\u0005\u007f\fY\b\"\u0003\u0004\u0002\u0005Aq-\u001a;U_.,g\u000e\u0006\u0003\u0003\u0014\u000e\r\u0001\u0002\u0003Bo\u0005{\u0004\rAa8\t\u0011\r\u001d\u00111\u0010C\u0005\u0007\u0013\ta\"\u00197m_^,G\rV8SK:,w\u000f\u0006\u0004\u0002B\r-1Q\u0002\u0005\t\u00053\u001c)\u00011\u0001\u0002L!A1qBB\u0003\u0001\u0004\t\t$A\u0005u_.,g.\u00138g_\"A!q`A>\t\u0003\u0019\u0019\u0002\u0006\u0003\u0003\u0014\u000eU\u0001B\u0002+\u0004\u0012\u0001\u0007Q\u000b\u0003\u0005\u0003\u0000\u0006mD\u0011BB\r)\u0011\t)aa\u0007\t\u0011\r=1q\u0003a\u0001\u0003cA\u0001ba\b\u0002|\u0011\u00051\u0011E\u0001\fKb\u0004\u0018N]3U_.,g\u000e\u0006\u0006\u0003\u0002\r\r2QEB\u0014\u0007WA\u0001B!7\u0004\u001e\u0001\u0007\u00111\n\u0005\t\u0005;\u001ci\u00021\u0001\u0003`\"A1\u0011FB\u000f\u0001\u0004\u0011i\"\u0001\tfqBL'/\u001a'jM\u0016$\u0016.\\3Ng\"A1QFB\u000f\u0001\u0004\u0019y#\u0001\ffqBL'/\u001a*fgB|gn]3DC2d'-Y2l!\u0011\u0011yMa\t\t\u0011\rM\u00121\u0010C\u0005\u0007k\t1B]3n_Z,Gk\\6f]R!!\u0011AB\u001c\u0011\u0019!6\u0011\u0007a\u0001+\"A11HA>\t\u0013\u0019i$A\u0006sK6|g/Z\"bG\",G\u0003\u0002B\u0001\u0007\u007fAa\u0001VB\u001d\u0001\u0004)\u0006\u0002CB\"\u0003w\"\tAa!\u0002\u0019\u0015D\b/\u001b:f)>\\WM\\:\t\u0011\r\u001d\u00131\u0010C\u0001\u0007\u0013\nacZ3u\u00032dGk\\6f]&sgm\u001c:nCRLwN\u001c\u000b\u0003\u0007\u0017\u0002b!a\u0018\u0002j\u0005E\u0002\u0002CB(\u0003w\"\ta!\u0015\u0002\u0013\u001d,G\u000fV8lK:\u001cH\u0003\u0002B\u0017\u0007'B\u0001\"!\u0010\u0004N\u0001\u00071Q\u000b\t\b\u001b\u0005]\u0014\u0011GA!\u000f!\u0019I&a\u001f\t\u0002\rm\u0013a\b+pW\u0016t7\t[1oO\u0016$gj\u001c;jM&\u001c\u0017\r^5p]\"\u000bg\u000e\u001a7feB!!qZB/\r!\u0019y&a\u001f\t\u0002\r\u0005$a\b+pW\u0016t7\t[1oO\u0016$gj\u001c;jM&\u001c\u0017\r^5p]\"\u000bg\u000e\u001a7feN)1Q\f\u0007\u0004dA!!\u0011NB3\u0013\u0011\u00199Ga\u001b\u0003'9{G/\u001b4jG\u0006$\u0018n\u001c8IC:$G.\u001a:\t\u000fM\u0019i\u0006\"\u0001\u0004lQ\u001111\f\u0005\t\u0007_\u001ai\u0006\"\u0011\u0004r\u0005\u0019\u0002O]8dKN\u001chj\u001c;jM&\u001c\u0017\r^5p]R!!\u0011AB:\u0011\u001d\u0019)h!\u001cA\u00025\u000bA\u0002^8lK:LEMQ=uKN\u0004")
public class DelegationTokenManager
implements KafkaMetricsGroup {
    private volatile DelegationTokenManager$TokenChangedNotificationHandler$ TokenChangedNotificationHandler$module;
    private final KafkaConfig config;
    private final DelegationTokenCache tokenCache;
    private final Time time;
    private final KafkaZkClient zkClient;
    private final SecretKey secretKey;
    private final long tokenMaxLifetime;
    private final long defaultTokenRenewTime;
    private final long tokenRemoverScanInterval;
    private final Object kafka$server$DelegationTokenManager$$lock;
    private ZkNodeChangeNotificationListener tokenChangeListener;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean filterToken(KafkaPrincipal kafkaPrincipal, Option<List<KafkaPrincipal>> option, TokenInformation tokenInformation, Function1<String, Object> function1) {
        return DelegationTokenManager$.MODULE$.filterToken(kafkaPrincipal, option, tokenInformation, function1);
    }

    public static Option<TokenInformation> fromBytes(byte[] byArray) {
        return DelegationTokenManager$.MODULE$.fromBytes(byArray);
    }

    public static scala.collection.immutable.Map<String, Object> toJsonCompatibleMap(DelegationToken delegationToken) {
        return DelegationTokenManager$.MODULE$.toJsonCompatibleMap(delegationToken);
    }

    public static byte[] createHmac(String string, SecretKey secretKey) {
        return DelegationTokenManager$.MODULE$.createHmac(string, secretKey);
    }

    public static String createBase64HMAC(String string, SecretKey secretKey) {
        return DelegationTokenManager$.MODULE$.createBase64HMAC(string, secretKey);
    }

    public static SecretKey createSecretKey(byte[] byArray) {
        return DelegationTokenManager$.MODULE$.createSecretKey(byArray);
    }

    public static byte[] createHmac(String string, String string2) {
        return DelegationTokenManager$.MODULE$.createHmac(string, string2);
    }

    public static int ErrorTimestamp() {
        return DelegationTokenManager$.MODULE$.ErrorTimestamp();
    }

    public static int CurrentVersion() {
        return DelegationTokenManager$.MODULE$.CurrentVersion();
    }

    public static String VersionKey() {
        return DelegationTokenManager$.MODULE$.VersionKey();
    }

    public static String TokenIdKey() {
        return DelegationTokenManager$.MODULE$.TokenIdKey();
    }

    public static String ExpiryTimestampKey() {
        return DelegationTokenManager$.MODULE$.ExpiryTimestampKey();
    }

    public static String MaxTimestampKey() {
        return DelegationTokenManager$.MODULE$.MaxTimestampKey();
    }

    public static String IssueTimestampKey() {
        return DelegationTokenManager$.MODULE$.IssueTimestampKey();
    }

    public static String RenewersKey() {
        return DelegationTokenManager$.MODULE$.RenewersKey();
    }

    public static String OwnerKey() {
        return DelegationTokenManager$.MODULE$.OwnerKey();
    }

    public static String DefaultHmacAlgorithm() {
        return DelegationTokenManager$.MODULE$.DefaultHmacAlgorithm();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public DelegationTokenManager$TokenChangedNotificationHandler$ TokenChangedNotificationHandler() {
        if (this.TokenChangedNotificationHandler$module == null) {
            this.TokenChangedNotificationHandler$lzycompute$1();
        }
        return this.TokenChangedNotificationHandler$module;
    }

    private Logger logger$lzycompute() {
        DelegationTokenManager delegationTokenManager = this;
        synchronized (delegationTokenManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public Time time() {
        return this.time;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public SecretKey secretKey() {
        return this.secretKey;
    }

    public long tokenMaxLifetime() {
        return this.tokenMaxLifetime;
    }

    public long defaultTokenRenewTime() {
        return this.defaultTokenRenewTime;
    }

    public long tokenRemoverScanInterval() {
        return this.tokenRemoverScanInterval;
    }

    public Object kafka$server$DelegationTokenManager$$lock() {
        return this.kafka$server$DelegationTokenManager$$lock;
    }

    private ZkNodeChangeNotificationListener tokenChangeListener() {
        return this.tokenChangeListener;
    }

    private void tokenChangeListener_$eq(ZkNodeChangeNotificationListener x$1) {
        this.tokenChangeListener = x$1;
    }

    public void startup() {
        block0: {
            if (!this.config().tokenAuthEnabled()) break block0;
            this.zkClient().createDelegationTokenPaths();
            this.loadCache();
            this.tokenChangeListener_$eq(new ZkNodeChangeNotificationListener(this.zkClient(), DelegationTokenChangeNotificationZNode$.MODULE$.path(), DelegationTokenChangeNotificationSequenceZNode$.MODULE$.SequenceNumberPrefix(), this.TokenChangedNotificationHandler(), ZkNodeChangeNotificationListener$.MODULE$.$lessinit$greater$default$5(), ZkNodeChangeNotificationListener$.MODULE$.$lessinit$greater$default$6()));
            this.tokenChangeListener().init();
        }
    }

    public void shutdown() {
        block0: {
            if (!this.config().tokenAuthEnabled() || this.tokenChangeListener() == null) break block0;
            this.tokenChangeListener().close();
        }
    }

    private void loadCache() {
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            Seq<String> tokens = this.zkClient().getChildren(DelegationTokensZNode$.MODULE$.path());
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Loading the token cache. Total token count : ").append(tokens.size()).toString());
            tokens.foreach((Function1 & Serializable & scala.Serializable)tokenId -> {
                DelegationTokenManager.$anonfun$loadCache$2(this, tokenId);
                return BoxedUnit.UNIT;
            });
        }
    }

    public Option<DelegationToken> kafka$server$DelegationTokenManager$$getTokenFromZk(String tokenId) {
        None$ none$;
        Option<TokenInformation> option = this.zkClient().getDelegationTokenInfo(tokenId);
        if (option instanceof Some) {
            Some some = (Some)option;
            TokenInformation tokenInformation = (TokenInformation)some.value();
            byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
            none$ = new Some((Object)new DelegationToken(tokenInformation, hmac));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public void kafka$server$DelegationTokenManager$$updateCache(DelegationToken token) {
        String hmacString = token.hmacAsBase64String();
        scala.collection.immutable.Map<String, ScramCredential> scramCredentialMap = this.prepareScramCredentials(hmacString);
        this.tokenCache().updateCache(token, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(scramCredentialMap).asJava());
    }

    private scala.collection.immutable.Map<String, ScramCredential> prepareScramCredentials(String hmacString) {
        scala.collection.mutable.Map scramCredentialMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ScramMechanism.values())).foreach((Function1 & Serializable & scala.Serializable)mechanism -> {
            scramCredentialMap.update((Object)mechanism.mechanismName(), (Object)DelegationTokenManager.scramCredential$1(mechanism, hmacString));
            return BoxedUnit.UNIT;
        });
        return scramCredentialMap.toMap(Predef$.MODULE$.$conforms());
    }

    public void createToken(KafkaPrincipal owner, List<KafkaPrincipal> renewers, long maxLifeTimeMs, Function1<CreateTokenResult, BoxedUnit> responseCallback) {
        if (!this.config().tokenAuthEnabled()) {
            responseCallback.apply((Object)new CreateTokenResult(-1L, -1L, -1L, "", (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), Errors.DELEGATION_TOKEN_AUTH_DISABLED));
        } else {
            Object object = this.kafka$server$DelegationTokenManager$$lock();
            synchronized (object) {
                String tokenId = CoreUtils$.MODULE$.generateUuidAsBase64();
                long issueTimeStamp = this.time().milliseconds();
                long maxLifeTime = maxLifeTimeMs <= 0L ? this.tokenMaxLifetime() : Math.min(maxLifeTimeMs, this.tokenMaxLifetime());
                long maxLifeTimeStamp = issueTimeStamp + maxLifeTime;
                long expiryTimeStamp = Math.min(maxLifeTimeStamp, issueTimeStamp + this.defaultTokenRenewTime());
                TokenInformation tokenInfo = new TokenInformation(tokenId, owner, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(renewers).asJava(), issueTimeStamp, maxLifeTimeStamp, expiryTimeStamp);
                byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
                DelegationToken token = new DelegationToken(tokenInfo, hmac);
                this.updateToken(token);
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Created a delegation token : ").append(tokenId).append(" for owner : ").append(owner).toString());
                responseCallback.apply((Object)new CreateTokenResult(issueTimeStamp, expiryTimeStamp, maxLifeTimeStamp, tokenId, hmac, Errors.NONE));
            }
        }
    }

    public void renewToken(KafkaPrincipal principal, ByteBuffer hmac, long renewLifeTimeMs, Function2<Errors, Object, BoxedUnit> renewCallback) {
        if (!this.config().tokenAuthEnabled()) {
            renewCallback.apply((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)BoxesRunTime.boxToLong((long)-1L));
        } else {
            Object object = this.kafka$server$DelegationTokenManager$$lock();
            synchronized (object) {
                Option<DelegationToken> option = this.getToken(hmac);
                if (option instanceof Some) {
                    BoxedUnit boxedUnit;
                    Some some = (Some)option;
                    DelegationToken token = (DelegationToken)some.value();
                    long now = this.time().milliseconds();
                    TokenInformation tokenInfo = token.tokenInfo();
                    if (!this.allowedToRenew(principal, tokenInfo)) {
                        boxedUnit = (BoxedUnit)renewCallback.apply((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)BoxesRunTime.boxToLong((long)-1L));
                    } else if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
                        boxedUnit = (BoxedUnit)renewCallback.apply((Object)Errors.DELEGATION_TOKEN_EXPIRED, (Object)BoxesRunTime.boxToLong((long)-1L));
                    } else {
                        long renewLifeTime = renewLifeTimeMs < 0L ? this.defaultTokenRenewTime() : renewLifeTimeMs;
                        long renewTimeStamp = now + renewLifeTime;
                        long expiryTimeStamp = Math.min(tokenInfo.maxTimestamp(), renewTimeStamp);
                        tokenInfo.setExpiryTimestamp(expiryTimeStamp);
                        this.updateToken(token);
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Delegation token renewed for token : ").append(tokenInfo.tokenId()).append(" for owner :").append(tokenInfo.owner()).toString());
                        boxedUnit = (BoxedUnit)renewCallback.apply((Object)Errors.NONE, (Object)BoxesRunTime.boxToLong((long)expiryTimeStamp));
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit = (BoxedUnit)renewCallback.apply((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)BoxesRunTime.boxToLong((long)-1L));
                } else {
                    throw new MatchError(option);
                }
            }
        }
    }

    private void updateToken(DelegationToken token) {
        this.zkClient().setOrCreateDelegationToken(token);
        this.kafka$server$DelegationTokenManager$$updateCache(token);
        this.zkClient().createTokenChangeNotification(token.tokenInfo().tokenId());
    }

    private Option<DelegationToken> getToken(ByteBuffer hmac) {
        None$ none$;
        block3: {
            try {
                byte[] byteArray = new byte[hmac.remaining()];
                hmac.get(byteArray);
                String base64Pwd = Base64.getEncoder().encodeToString(byteArray);
                TokenInformation tokenInfo = this.tokenCache().tokenForHmac(base64Pwd);
                if (tokenInfo == null) {
                    none$ = None$.MODULE$;
                    break block3;
                }
                none$ = new Some((Object)new DelegationToken(tokenInfo, byteArray));
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while getting token for hmac", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    private boolean allowedToRenew(KafkaPrincipal principal, TokenInformation tokenInfo) {
        return principal.equals((Object)tokenInfo.owner()) || ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(tokenInfo.renewers()).asScala()).toList().contains((Object)principal);
    }

    public Option<DelegationToken> getToken(String tokenId) {
        TokenInformation tokenInfo = this.tokenCache().token(tokenId);
        return tokenInfo != null ? new Some((Object)this.getToken(tokenInfo)) : None$.MODULE$;
    }

    private DelegationToken getToken(TokenInformation tokenInfo) {
        byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenInfo.tokenId(), this.secretKey());
        return new DelegationToken(tokenInfo, hmac);
    }

    public void expireToken(KafkaPrincipal principal, ByteBuffer hmac, long expireLifeTimeMs, Function2<Errors, Object, BoxedUnit> expireResponseCallback) {
        if (!this.config().tokenAuthEnabled()) {
            expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)BoxesRunTime.boxToLong((long)-1L));
        } else {
            Object object = this.kafka$server$DelegationTokenManager$$lock();
            synchronized (object) {
                Option<DelegationToken> option = this.getToken(hmac);
                if (option instanceof Some) {
                    BoxedUnit boxedUnit;
                    Some some = (Some)option;
                    DelegationToken token = (DelegationToken)some.value();
                    TokenInformation tokenInfo = token.tokenInfo();
                    long now = this.time().milliseconds();
                    if (!this.allowedToRenew(principal, tokenInfo)) {
                        boxedUnit = (BoxedUnit)expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)BoxesRunTime.boxToLong((long)-1L));
                    } else if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
                        boxedUnit = (BoxedUnit)expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_EXPIRED, (Object)BoxesRunTime.boxToLong((long)-1L));
                    } else if (expireLifeTimeMs < 0L) {
                        this.removeToken(tokenInfo.tokenId());
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Token expired for token : ").append(tokenInfo.tokenId()).append(" for owner :").append(tokenInfo.owner()).toString());
                        boxedUnit = (BoxedUnit)expireResponseCallback.apply((Object)Errors.NONE, (Object)BoxesRunTime.boxToLong((long)now));
                    } else {
                        long expiryTimeStamp = Math.min(tokenInfo.maxTimestamp(), now + expireLifeTimeMs);
                        tokenInfo.setExpiryTimestamp(expiryTimeStamp);
                        this.updateToken(token);
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Updated expiry time for token : ").append(tokenInfo.tokenId()).append(" for owner :").append(tokenInfo.owner()).toString());
                        boxedUnit = (BoxedUnit)expireResponseCallback.apply((Object)Errors.NONE, (Object)BoxesRunTime.boxToLong((long)expiryTimeStamp));
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit = (BoxedUnit)expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)BoxesRunTime.boxToLong((long)-1L));
                } else {
                    throw new MatchError(option);
                }
            }
        }
    }

    private void removeToken(String tokenId) {
        this.zkClient().deleteDelegationToken(tokenId);
        this.kafka$server$DelegationTokenManager$$removeCache(tokenId);
        this.zkClient().createTokenChangeNotification(tokenId);
    }

    public void kafka$server$DelegationTokenManager$$removeCache(String tokenId) {
        this.tokenCache().removeCache(tokenId);
    }

    public void expireTokens() {
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            this.getAllTokenInformation().foreach((Function1 & Serializable & scala.Serializable)tokenInfo -> {
                DelegationTokenManager.$anonfun$expireTokens$1(this, tokenInfo);
                return BoxedUnit.UNIT;
            });
        }
    }

    public List<TokenInformation> getAllTokenInformation() {
        return ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.tokenCache().tokens()).asScala()).toList();
    }

    public List<DelegationToken> getTokens(Function1<TokenInformation, Object> filterToken) {
        return (List)((List)this.getAllTokenInformation().filter(filterToken)).map((Function1 & Serializable & scala.Serializable)token -> this.getToken((TokenInformation)token), List$.MODULE$.canBuildFrom());
    }

    private final void TokenChangedNotificationHandler$lzycompute$1() {
        DelegationTokenManager delegationTokenManager = this;
        synchronized (delegationTokenManager) {
            if (this.TokenChangedNotificationHandler$module == null) {
                this.TokenChangedNotificationHandler$module = new DelegationTokenManager$TokenChangedNotificationHandler$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$loadCache$2(DelegationTokenManager $this, String tokenId) {
        block4: {
            try {
                Option<DelegationToken> option = $this.kafka$server$DelegationTokenManager$$getTokenFromZk(tokenId);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DelegationToken token = (DelegationToken)some.value();
                    $this.kafka$server$DelegationTokenManager$$updateCache(token);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                throw new MatchError(option);
            }
            catch (Throwable ex) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Error while getting Token for tokenId :").append(tokenId).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ex);
            }
        }
    }

    private static final ScramCredential scramCredential$1(ScramMechanism mechanism, String hmacString$1) {
        return new ScramFormatter(mechanism).generateCredential(hmacString$1, mechanism.minIterations());
    }

    public static final /* synthetic */ void $anonfun$expireTokens$1(DelegationTokenManager $this, TokenInformation tokenInfo) {
        block0: {
            long now = $this.time().milliseconds();
            if (tokenInfo.maxTimestamp() >= now && tokenInfo.expiryTimestamp() >= now) break block0;
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Delegation token expired for token : ").append(tokenInfo.tokenId()).append(" for owner :").append(tokenInfo.owner()).toString());
            $this.removeToken(tokenInfo.tokenId());
        }
    }

    public DelegationTokenManager(KafkaConfig config, DelegationTokenCache tokenCache, Time time, KafkaZkClient zkClient) {
        this.config = config;
        this.tokenCache = tokenCache;
        this.time = time;
        this.zkClient = zkClient;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.logIdent_$eq(new StringBuilder(28).append("[Token Manager on Broker ").append(config.brokerId()).append("]: ").toString());
        byte[] keyBytes = config.tokenAuthEnabled() ? config.delegationTokenMasterKey().value().getBytes(StandardCharsets.UTF_8) : null;
        this.secretKey = keyBytes == null || keyBytes.length == 0 ? null : DelegationTokenManager$.MODULE$.createSecretKey(keyBytes);
        this.tokenMaxLifetime = Predef$.MODULE$.Long2long(config.delegationTokenMaxLifeMs());
        this.defaultTokenRenewTime = Predef$.MODULE$.Long2long(config.delegationTokenExpiryTimeMs());
        this.tokenRemoverScanInterval = Predef$.MODULE$.Long2long(config.delegationTokenExpiryCheckIntervalMs());
        this.kafka$server$DelegationTokenManager$$lock = new Object();
        this.tokenChangeListener = null;
    }
}

