/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.StateChangeLogger;
import kafka.server.MetadataCache$MetadataSnapshot$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\u001dd\u0001B\u0001\u0003\u0001\u001d\u0011Q\"T3uC\u0012\fG/Y\"bG\",'BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Aa\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oO\"AQ\u0003\u0001B\u0001B\u0003%a#\u0001\u0005ce>\\WM]%e!\tIq#\u0003\u0002\u0019\u0015\t\u0019\u0011J\u001c;\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\tab\u0004\u0005\u0002\u001e\u00015\t!\u0001C\u0003\u00163\u0001\u0007a\u0003C\u0004!\u0001\t\u0007I\u0011B\u0011\u0002+A\f'\u000f^5uS>tW*\u001a;bI\u0006$\u0018\rT8dWV\t!\u0005\u0005\u0002$Y5\tAE\u0003\u0002&M\u0005)An\\2lg*\u0011q\u0005K\u0001\u000bG>t7-\u001e:sK:$(BA\u0015+\u0003\u0011)H/\u001b7\u000b\u0003-\nAA[1wC&\u0011Q\u0006\n\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\"1q\u0006\u0001Q\u0001\n\t\na\u0003]1si&$\u0018n\u001c8NKR\fG-\u0019;b\u0019>\u001c7\u000e\t\u0005\bc\u0001\u0001\r\u0011\"\u00033\u0003AiW\r^1eCR\f7K\\1qg\"|G/F\u00014!\t!T'D\u0001\u0001\r\u00111\u0004\u0001Q\u001c\u0003!5+G/\u00193bi\u0006\u001cf.\u00199tQ>$8\u0003B\u001b\tqm\u0002\"!C\u001d\n\u0005iR!a\u0002)s_\u0012,8\r\u001e\t\u0003\u0013qJ!!\u0010\u0006\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011}*$Q3A\u0005\u0002\u0001\u000bq\u0002]1si&$\u0018n\u001c8Ti\u0006$Xm]\u000b\u0002\u0003B!!iR%U\u001b\u0005\u0019%B\u0001#F\u0003\u001diW\u000f^1cY\u0016T!A\u0012\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002I\u0007\nI\u0011I\\=SK\u001al\u0015\r\u001d\t\u0003\u0015Fs!aS(\u0011\u00051SQ\"A'\u000b\u000593\u0011A\u0002\u001fs_>$h(\u0003\u0002Q\u0015\u00051\u0001K]3eK\u001aL!AU*\u0003\rM#(/\u001b8h\u0015\t\u0001&\u0002E\u0002C+^K!AV\"\u0003\u000f1{gnZ'baB\u0011\u0001,\u001a\b\u00033\u000el\u0011A\u0017\u0006\u00037r\u000b\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003;z\u000baaY8n[>t'BA\u0003`\u0015\t\u0001\u0017-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002E\u0006\u0019qN]4\n\u0005\u0011T\u0016!F+qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f^\u0005\u0003M\u001e\u0014a\u0002U1si&$\u0018n\u001c8Ti\u0006$XM\u0003\u0002e5\"A\u0011.\u000eB\tB\u0003%\u0011)\u0001\tqCJ$\u0018\u000e^5p]N#\u0018\r^3tA!A1.\u000eBK\u0002\u0013\u0005A.\u0001\u0007d_:$(o\u001c7mKJLE-F\u0001n!\rIaNF\u0005\u0003_*\u0011aa\u00149uS>t\u0007\u0002C96\u0005#\u0005\u000b\u0011B7\u0002\u001b\r|g\u000e\u001e:pY2,'/\u00133!\u0011!\u0019XG!f\u0001\n\u0003!\u0018\u0001D1mSZ,'I]8lKJ\u001cX#A;\u0011\u0007\t+f\u000f\u0005\u0002xu6\t\u0001P\u0003\u0002z\t\u000591\r\\;ti\u0016\u0014\u0018BA>y\u0005\u0019\u0011%o\\6fe\"AQ0\u000eB\tB\u0003%Q/A\u0007bY&4XM\u0011:pW\u0016\u00148\u000f\t\u0005\n\u007fV\u0012)\u001a!C\u0001\u0003\u0003\t!\"\u00197jm\u0016tu\u000eZ3t+\t\t\u0019\u0001\u0005\u0003C+\u0006\u0015\u0001\u0003CA\u0004\u0003\u0013\ti!!\u0007\u000e\u0003\u0015K1!a\u0003F\u0005\ri\u0015\r\u001d\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111\u0003/\u0002\u000f9,Go^8sW&!\u0011qCA\t\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f!\u0011\tY\"!\b\u000e\u0003qK1!a\b]\u0005\u0011qu\u000eZ3\t\u0015\u0005\rRG!E!\u0002\u0013\t\u0019!A\u0006bY&4XMT8eKN\u0004\u0003B\u0002\u000e6\t\u0003\t9\u0003F\u00054\u0003S\tY#!\f\u00020!1q(!\nA\u0002\u0005Caa[A\u0013\u0001\u0004i\u0007BB:\u0002&\u0001\u0007Q\u000fC\u0004\u0000\u0003K\u0001\r!a\u0001\t\u0013\u0005MR'!A\u0005\u0002\u0005U\u0012\u0001B2paf$\u0012bMA\u001c\u0003s\tY$!\u0010\t\u0011}\n\t\u0004%AA\u0002\u0005C\u0001b[A\u0019!\u0003\u0005\r!\u001c\u0005\tg\u0006E\u0002\u0013!a\u0001k\"Iq0!\r\u0011\u0002\u0003\u0007\u00111\u0001\u0005\n\u0003\u0003*\u0014\u0013!C\u0001\u0003\u0007\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002F)\u001a\u0011)a\u0012,\u0005\u0005%\u0003\u0003BA&\u0003+j!!!\u0014\u000b\t\u0005=\u0013\u0011K\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0015\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003/\niEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\u00176#\u0003%\t!!\u0018\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\f\u0016\u0004[\u0006\u001d\u0003\"CA2kE\u0005I\u0011AA3\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a\u001a+\u0007U\f9\u0005C\u0005\u0002lU\n\n\u0011\"\u0001\u0002n\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAA8U\u0011\t\u0019!a\u0012\t\u0013\u0005MT'!A\u0005B\u0005U\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002xA!\u0011\u0011PA@\u001b\t\tYHC\u0002\u0002~)\nA\u0001\\1oO&\u0019!+a\u001f\t\u0013\u0005\rU'!A\u0005\u0002\u0005\u0015\u0015\u0001\u00049s_\u0012,8\r^!sSRLX#\u0001\f\t\u0013\u0005%U'!A\u0005\u0002\u0005-\u0015A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u001b\u000b\u0019\nE\u0002\n\u0003\u001fK1!!%\u000b\u0005\r\te.\u001f\u0005\n\u0003+\u000b9)!AA\u0002Y\t1\u0001\u001f\u00132\u0011%\tI*NA\u0001\n\u0003\nY*A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\n\u0005\u0004\u0002\b\u0005}\u0015QR\u0005\u0004\u0003C+%\u0001C%uKJ\fGo\u001c:\t\u0013\u0005\u0015V'!A\u0005\u0002\u0005\u001d\u0016\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005%\u0016q\u0016\t\u0004\u0013\u0005-\u0016bAAW\u0015\t9!i\\8mK\u0006t\u0007BCAK\u0003G\u000b\t\u00111\u0001\u0002\u000e\"I\u00111W\u001b\u0002\u0002\u0013\u0005\u0013QW\u0001\tQ\u0006\u001c\bnQ8eKR\ta\u0003C\u0005\u0002:V\n\t\u0011\"\u0011\u0002<\u0006AAo\\*ue&tw\r\u0006\u0002\u0002x!I\u0011qX\u001b\u0002\u0002\u0013\u0005\u0013\u0011Y\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005%\u00161\u0019\u0005\u000b\u0003+\u000bi,!AA\u0002\u00055\u0005\"CAd\u0001\u0001\u0007I\u0011BAe\u0003QiW\r^1eCR\f7K\\1qg\"|Go\u0018\u0013fcR!\u00111ZAi!\rI\u0011QZ\u0005\u0004\u0003\u001fT!\u0001B+oSRD\u0011\"!&\u0002F\u0006\u0005\t\u0019A\u001a\t\u000f\u0005U\u0007\u0001)Q\u0005g\u0005\tR.\u001a;bI\u0006$\u0018m\u00158baNDw\u000e\u001e\u0011)\t\u0005M\u0017\u0011\u001c\t\u0004\u0013\u0005m\u0017bAAo\u0015\tAao\u001c7bi&dW\rC\u0005\u0002b\u0002\u0011\r\u0011\"\u0003\u0002d\u0006\t2\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0016\u0005\u0005\u0015\b\u0003BAt\u0003[l!!!;\u000b\u0007\u0005-H!\u0001\u0006d_:$(o\u001c7mKJLA!a<\u0002j\n\t2\u000b^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\t\u0011\u0005M\b\u0001)A\u0005\u0003K\f!c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3sA!9\u0011q\u001f\u0001\u0005\n\u0005e\u0018\u0001D4fi\u0016sG\r]8j]R\u001cHCCA~\u0005\u0003\u0011)Aa\u0007\u0003 A1\u0011qAA\u007f\u00033I1!a@F\u0005\r\u0019V-\u001d\u0005\b\u0005\u0007\t)\u00101\u00014\u0003!\u0019h.\u00199tQ>$\b\u0002\u0003B\u0004\u0003k\u0004\rA!\u0003\u0002\u000f\t\u0014xn[3sgB)!1\u0002B\u000b-9!!Q\u0002B\t\u001d\ra%qB\u0005\u0002\u0017%\u0019!1\u0003\u0006\u0002\u000fA\f7m[1hK&!!q\u0003B\r\u0005!IE/\u001a:bE2,'b\u0001B\n\u0015!A!QDA{\u0001\u0004\ti!\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0003\u0005\u0003\"\u0005U\b\u0019AAU\u0003i1\u0017\u000e\u001c;feVs\u0017M^1jY\u0006\u0014G.Z#oIB|\u0017N\u001c;t\u0011\u001d\u0011)\u0003\u0001C\u0005\u0005O\tAcZ3u!\u0006\u0014H/\u001b;j_:lU\r^1eCR\fG\u0003\u0004B\u0015\u0005w\u0011iD!\u0011\u0003D\t\u001d\u0003\u0003B\u0005o\u0005W\u0001bAa\u0003\u0003\u0016\t5\u0002\u0003\u0002B\u0018\u0005kq1!\u0017B\u0019\u0013\r\u0011\u0019DW\u0001\u0011\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016LAAa\u000e\u0003:\t\t\u0002+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1\u000b\u0007\tM\"\fC\u0004\u0003\u0004\t\r\u0002\u0019A\u001a\t\u000f\t}\"1\u0005a\u0001\u0013\u0006)Ao\u001c9jG\"A!Q\u0004B\u0012\u0001\u0004\ti\u0001\u0003\u0005\u0003F\t\r\u0002\u0019AAU\u0003e)'O]8s+:\fg/Y5mC\ndW-\u00128ea>Lg\u000e^:\t\u0011\t%#1\u0005a\u0001\u0003S\u000b\u0011$\u001a:s_J,f.\u0019<bS2\f'\r\\3MSN$XM\\3sg\"9!Q\n\u0001\u0005\n\t=\u0013\u0001E4fi\u0006c\u0017N^3F]\u0012\u0004x.\u001b8u)!\u0011\tFa\u0015\u0003V\t]\u0003\u0003B\u0005o\u00033AqAa\u0001\u0003L\u0001\u00071\u0007\u0003\u0004\u0016\u0005\u0017\u0002\rA\u0006\u0005\t\u0005;\u0011Y\u00051\u0001\u0002\u000e!9!1\f\u0001\u0005\u0002\tu\u0013\u0001E4fiR{\u0007/[2NKR\fG-\u0019;b))\u0011yFa\u001a\u0003r\tM$Q\u000f\t\u0007\u0003\u000f\tiP!\u0019\u0011\t\t=\"1M\u0005\u0005\u0005K\u0012IDA\u0007U_BL7-T3uC\u0012\fG/\u0019\u0005\t\u0005S\u0012I\u00061\u0001\u0003l\u00051Ao\u001c9jGN\u0004R!a\u0002\u0003n%K1Aa\u001cF\u0005\r\u0019V\r\u001e\u0005\t\u0005;\u0011I\u00061\u0001\u0002\u000e!Q!Q\tB-!\u0003\u0005\r!!+\t\u0015\t%#\u0011\fI\u0001\u0002\u0004\tI\u000bC\u0004\u0003z\u0001!\tAa\u001f\u0002\u0019\u001d,G/\u00117m)>\u0004\u0018nY:\u0015\u0005\t-\u0004b\u0002B=\u0001\u0011%!q\u0010\u000b\u0005\u0005W\u0012\t\tC\u0004\u0003\u0004\tu\u0004\u0019A\u001a\t\u000f\t\u0015\u0005\u0001\"\u0003\u0003\b\u0006\u0001r-\u001a;BY2\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0005\u0013\u0013\u0019\n\u0005\u0004K\u0005\u0017\u0013iiV\u0005\u0004\u0003\u0017\u0019\u0006\u0003BA\u000e\u0005\u001fK1A!%]\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:DqAa\u0001\u0003\u0004\u0002\u00071\u0007C\u0004\u0003\u0018\u0002!\tA!'\u0002)\u001d,GOT8o\u000bbL7\u000f^5oOR{\u0007/[2t)\u0011\u0011YGa'\t\u0011\t%$Q\u0013a\u0001\u0005WBqAa(\u0001\t\u0003\u0011\t+A\u0007jg\n\u0013xn[3s\u00032Lg/\u001a\u000b\u0005\u0003S\u0013\u0019\u000b\u0003\u0004\u0016\u0005;\u0003\rA\u0006\u0005\b\u0005O\u0003A\u0011\u0001BU\u0003=9W\r^!mSZ,'I]8lKJ\u001cXC\u0001BV!\u0015\t9!!@w\u0011\u001d\u0011y\u000b\u0001C\u0005\u0005c\u000b\u0001$\u00193e\u001fJ,\u0006\u000fZ1uKB\u000b'\u000f^5uS>t\u0017J\u001c4p))\tYMa-\u00036\n]&1\u0018\u0005\u0007\u007f\t5\u0006\u0019A!\t\u000f\t}\"Q\u0016a\u0001\u0013\"9!\u0011\u0018BW\u0001\u00041\u0012a\u00039beRLG/[8o\u0013\u0012DqA!0\u0003.\u0002\u0007q+A\u0005ti\u0006$X-\u00138g_\"9!\u0011\u0019\u0001\u0005\u0002\t\r\u0017\u0001E4fiB\u000b'\u000f^5uS>t\u0017J\u001c4p)\u0019\u0011)Ma2\u0003JB\u0019\u0011B\\,\t\u000f\t}\"q\u0018a\u0001\u0013\"9!\u0011\u0018B`\u0001\u00041\u0002b\u0002Bg\u0001\u0011\u0005!qZ\u0001\u001bO\u0016$\b+\u0019:uSRLwN\u001c'fC\u0012,'/\u00128ea>Lg\u000e\u001e\u000b\t\u0005#\u0012\tNa5\u0003V\"9!q\bBf\u0001\u0004I\u0005b\u0002B]\u0005\u0017\u0004\rA\u0006\u0005\t\u0005;\u0011Y\r1\u0001\u0002\u000e!1!\u0011\u001c\u0001\u0005\u00021\fqbZ3u\u0007>tGO]8mY\u0016\u0014\u0018\n\u001a\u0005\b\u0005;\u0004A\u0011\u0001Bp\u0003I9W\r^\"mkN$XM]'fi\u0006$\u0017\r^1\u0015\r\t\u0005(q\u001dBv!\u0011\tYBa9\n\u0007\t\u0015HLA\u0004DYV\u001cH/\u001a:\t\u000f\t%(1\u001ca\u0001\u0013\u0006I1\r\\;ti\u0016\u0014\u0018\n\u001a\u0005\t\u0005;\u0011Y\u000e1\u0001\u0002\u000e!9!q\u001e\u0001\u0005\u0002\tE\u0018AD;qI\u0006$X-T3uC\u0012\fG/\u0019\u000b\u0007\u0005g\u0014)P!?\u0011\r\u0005\u001d\u0011Q BG\u0011\u001d\u00119P!<A\u0002Y\tQbY8se\u0016d\u0017\r^5p]&#\u0007\u0002\u0003B~\u0005[\u0004\rA!@\u0002+U\u0004H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiB\u0019\u0011La@\n\u0007\r\u0005!LA\u000bVa\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;\t\u000f\r\u0015\u0001\u0001\"\u0001\u0004\b\u0005A1m\u001c8uC&t7\u000f\u0006\u0003\u0002*\u000e%\u0001b\u0002B \u0007\u0007\u0001\r!\u0013\u0005\b\u0007\u000b\u0001A\u0011AB\u0007)\u0011\tIka\u0004\t\u0011\rE11\u0002a\u0001\u0005\u001b\u000b!\u0001\u001e9\t\u000f\rU\u0001\u0001\"\u0003\u0004\u0018\u0005\u0019\"/Z7pm\u0016\u0004\u0016M\u001d;ji&|g.\u00138g_RA\u0011\u0011VB\r\u00077\u0019i\u0002\u0003\u0004@\u0007'\u0001\r!\u0011\u0005\b\u0005\u007f\u0019\u0019\u00021\u0001J\u0011\u001d\u0011Ila\u0005A\u0002Y9\u0011b!\t\u0001\u0003\u0003E\taa\t\u0002!5+G/\u00193bi\u0006\u001cf.\u00199tQ>$\bc\u0001\u001b\u0004&\u0019Aa\u0007AA\u0001\u0012\u0003\u00199cE\u0003\u0004&\r%2\b\u0005\u0006\u0004,\rE\u0012)\\;\u0002\u0004Mj!a!\f\u000b\u0007\r=\"\"A\u0004sk:$\u0018.\\3\n\t\rM2Q\u0006\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$\u0004b\u0002\u000e\u0004&\u0011\u00051q\u0007\u000b\u0003\u0007GA!\"!/\u0004&\u0005\u0005IQIA^\u0011)\u0019id!\n\u0002\u0002\u0013\u00055qH\u0001\u0006CB\u0004H.\u001f\u000b\ng\r\u000531IB#\u0007\u000fBaaPB\u001e\u0001\u0004\t\u0005BB6\u0004<\u0001\u0007Q\u000e\u0003\u0004t\u0007w\u0001\r!\u001e\u0005\b\u007f\u000em\u0002\u0019AA\u0002\u0011)\u0019Ye!\n\u0002\u0002\u0013\u00055QJ\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019yea\u0016\u0011\t%q7\u0011\u000b\t\t\u0013\rM\u0013)\\;\u0002\u0004%\u00191Q\u000b\u0006\u0003\rQ+\b\u000f\\35\u0011%\u0019If!\u0013\u0002\u0002\u0003\u00071'A\u0002yIAB\u0011b!\u0018\u0001#\u0003%\taa\u0018\u00025\u001d,G\u000fV8qS\u000elU\r^1eCR\fG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r\u0005$\u0006BAU\u0003\u000fB\u0011b!\u001a\u0001#\u0003%\taa\u0018\u00025\u001d,G\u000fV8qS\u000elU\r^1eCR\fG\u0005Z3gCVdG\u000f\n\u001b")
public class MetadataCache
implements Logging {
    private volatile MetadataCache$MetadataSnapshot$ MetadataSnapshot$module;
    private final int brokerId;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private volatile MetadataSnapshot metadataSnapshot;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public MetadataCache$MetadataSnapshot$ MetadataSnapshot() {
        if (this.MetadataSnapshot$module == null) {
            this.MetadataSnapshot$lzycompute$1();
        }
        return this.MetadataSnapshot$module;
    }

    private Logger logger$lzycompute() {
        MetadataCache metadataCache = this;
        synchronized (metadataCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    private void metadataSnapshot_$eq(MetadataSnapshot x$1) {
        this.metadataSnapshot = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private Seq<Node> getEndpoints(MetadataSnapshot snapshot, Iterable<Object> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        ArrayBuffer result = new ArrayBuffer(package$.MODULE$.min(snapshot.aliveBrokers().size(), brokers.size()));
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            None$ none$;
            Option<Node> option = this.getAliveEndpoint(snapshot, brokerId, listenerName);
            if (None$.MODULE$.equals(option)) {
                none$ = !filterUnavailableEndpoints ? new Some((Object)new Node(brokerId, "", -1)) : None$.MODULE$;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Node node = (Node)some.value();
                none$ = new Some((Object)node);
            } else {
                throw new MatchError(option);
            }
            None$ endpoint = none$;
            endpoint.foreach((Function1 & Serializable & scala.Serializable)elem -> result.$plus$eq(elem));
        });
        return result;
    }

    private Option<Iterable<MetadataResponse.PartitionMetadata>> getPartitionMetadata(MetadataSnapshot snapshot, String topic, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        return snapshot.partitionStates().get((Object)topic).map((Function1 & Serializable & scala.Serializable)partitions -> (Iterable)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MetadataResponse.PartitionMetadata partitionMetadata;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            long partitionId = tuple2._1$mcJ$sp();
            UpdateMetadataRequest.PartitionState partitionState = (UpdateMetadataRequest.PartitionState)tuple2._2();
            TopicPartition topicPartition = new TopicPartition(topic, (int)partitionId);
            int leaderBrokerId = partitionState.basePartitionState.leader;
            int leaderEpoch = partitionState.basePartitionState.leaderEpoch;
            Option<Node> maybeLeader = this.getAliveEndpoint(snapshot, leaderBrokerId, listenerName);
            Buffer replicas = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.basePartitionState.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$1)), Buffer$.MODULE$.canBuildFrom());
            Seq<Node> replicaInfo = this.getEndpoints(snapshot, (Iterable<Object>)replicas, listenerName, errorUnavailableEndpoints);
            Seq<Node> offlineReplicaInfo = this.getEndpoints(snapshot, (Iterable<Object>)((Iterable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.offlineReplicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2)), Buffer$.MODULE$.canBuildFrom())), listenerName, errorUnavailableEndpoints);
            Option<Node> option = maybeLeader;
            if (None$.MODULE$.equals(option)) {
                Errors errors;
                if (!snapshot.aliveBrokers().contains((long)$this.brokerId)) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Error while fetching metadata for ").append(topicPartition).append(": leader not available").toString());
                    errors = Errors.LEADER_NOT_AVAILABLE;
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Error while fetching metadata for ").append(topicPartition).append(": listener ").append(listenerName).append(" not found on leader ").append(leaderBrokerId).toString());
                    errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                }
                Errors error = errors;
                partitionMetadata = new MetadataResponse.PartitionMetadata(error, (int)partitionId, Node.noNode(), Optional.empty(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), Collections.emptyList(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                return partitionMetadata;
            } else {
                MetadataResponse.PartitionMetadata partitionMetadata2;
                if (!(option instanceof Some)) throw new MatchError(option);
                Some some = (Some)option;
                Node leader = (Node)some.value();
                Buffer isr = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.basePartitionState.isr).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3)), Buffer$.MODULE$.canBuildFrom());
                Seq<Node> isrInfo = this.getEndpoints(snapshot, (Iterable<Object>)isr, listenerName, errorUnavailableEndpoints);
                if (replicaInfo.size() < replicas.size()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                        Seq seq = (Seq)replicaInfo.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Seq$.MODULE$.canBuildFrom());
                        return new StringBuilder(74).append("Error while fetching metadata for ").append(topicPartition).append(": replica information not available for ").append(new StringBuilder(18).append("following brokers ").append(((TraversableOnce)replicas.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem)))).mkString(",")).toString()).toString();
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, (int)partitionId, leader, Optional.empty(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                } else if (isrInfo.size() < isr.size()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                        Seq seq = (Seq)isrInfo.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Seq$.MODULE$.canBuildFrom());
                        return new StringBuilder(82).append("Error while fetching metadata for ").append(topicPartition).append(": in sync replica information not available for ").append(new StringBuilder(18).append("following brokers ").append(((TraversableOnce)isr.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem)))).mkString(",")).toString()).toString();
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, (int)partitionId, leader, Optional.empty(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                } else {
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.NONE, (int)partitionId, leader, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                }
                partitionMetadata = partitionMetadata2;
            }
            return partitionMetadata;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom()));
    }

    private Option<Node> getAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.get((Object)listenerName));
    }

    public Seq<MetadataResponse.TopicMetadata> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.option2Iterable(this.getPartitionMetadata(snapshot, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable & scala.Serializable)partitionMetadata -> new MetadataResponse.TopicMetadata(Errors.NONE, topic, Topic.isInternal((String)topic), (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava()))), Seq$.MODULE$.canBuildFrom());
    }

    public boolean getTopicMetadata$default$3() {
        return false;
    }

    public boolean getTopicMetadata$default$4() {
        return false;
    }

    public Set<String> getAllTopics() {
        return this.getAllTopics(this.metadataSnapshot());
    }

    private Set<String> getAllTopics(MetadataSnapshot snapshot) {
        return snapshot.partitionStates().keySet();
    }

    private scala.collection.immutable.Map<TopicPartition, UpdateMetadataRequest.PartitionState> getAllPartitions(MetadataSnapshot snapshot) {
        return ((TraversableOnce)snapshot.partitionStates().flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String topic = (String)tuple2._1();
            LongMap partitionStates = (LongMap)tuple2._2();
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)partitionStates.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long partition = tuple2._1$mcJ$sp();
                UpdateMetadataRequest.PartitionState state = (UpdateMetadataRequest.PartitionState)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)new TopicPartition(topic, (int)partition), (Object)state);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            return map;
        }, AnyRefMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Set<String> getNonExistingTopics(Set<String> topics) {
        return (Set)topics.$minus$minus((GenTraversableOnce)this.metadataSnapshot().partitionStates().keySet());
    }

    public boolean isBrokerAlive(int brokerId) {
        return this.metadataSnapshot().aliveBrokers().contains((long)brokerId);
    }

    public Seq<Broker> getAliveBrokers() {
        return this.metadataSnapshot().aliveBrokers().values().toBuffer();
    }

    private void addOrUpdatePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> partitionStates, String topic, int partitionId, UpdateMetadataRequest.PartitionState stateInfo) {
        LongMap infos = (LongMap)partitionStates.getOrElseUpdate((Object)topic, (Function0 & Serializable & scala.Serializable)() -> LongMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        infos.update((long)partitionId, (Object)stateInfo);
    }

    public Option<UpdateMetadataRequest.PartitionState> getPartitionInfo(String topic, int partitionId) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.get((long)partitionId));
    }

    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return snapshot.partitionStates().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.get((long)partitionId)).map((Function1 & Serializable & scala.Serializable)partitionInfo -> {
            Node node;
            int leaderId = partitionInfo.basePartitionState.leader;
            Option option = snapshot.aliveNodes().get((long)leaderId);
            if (option instanceof Some) {
                Some some = (Some)option;
                Map nodeMap = (Map)some.value();
                node = (Node)nodeMap.getOrElse((Object)listenerName, (Function0 & Serializable & scala.Serializable)() -> Node.noNode());
            } else if (None$.MODULE$.equals(option)) {
                node = Node.noNode();
            } else {
                throw new MatchError((Object)option);
            }
            return node;
        });
    }

    public Option<Object> getControllerId() {
        return this.metadataSnapshot().controllerId();
    }

    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        LongMap nodes = (LongMap)snapshot.aliveNodes().map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long id = tuple2._1$mcJ$sp();
            Map nodes = (Map)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)id), nodes.get((Object)listenerName).orNull(Predef$.MODULE$.$conforms()));
            return tuple22;
        }, LongMap$.MODULE$.canBuildFrom());
        scala.collection.immutable.Iterable partitions = (scala.collection.immutable.Iterable)((TraversableLike)this.getAllPartitions(snapshot).filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$getClusterMetadata$2(x0$5)))).map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            UpdateMetadataRequest.PartitionState state = (UpdateMetadataRequest.PartitionState)tuple2._2();
            PartitionInfo partitionInfo = new PartitionInfo(tp.topic(), tp.partition(), MetadataCache.node$1(Predef$.MODULE$.int2Integer(state.basePartitionState.leader), nodes), (Node[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(state.basePartitionState.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)id -> MetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(state.basePartitionState.isr).asScala()).map((Function1 & Serializable & scala.Serializable)id -> MetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(state.offlineReplicas).asScala()).map((Function1 & Serializable & scala.Serializable)id -> MetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)));
            return partitionInfo;
        }, Iterable$.MODULE$.canBuildFrom());
        java.util.Set unauthorizedTopics = Collections.emptySet();
        java.util.Set internalTopics = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.getAllTopics(snapshot).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$getClusterMetadata$7(x$1)))).asJava();
        return new Cluster(clusterId, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)nodes.values().filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$getClusterMetadata$8(x$9)))).toList()).asJava(), (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)partitions.toList()).asJava(), unauthorizedTopics, internalTopics, (Node)snapshot.controllerId().map((Function1 & Serializable & scala.Serializable)id -> MetadataCache.node$1(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)id)), nodes)).orNull(Predef$.MODULE$.$conforms()));
    }

    public Seq<TopicPartition> updateMetadata(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        return (Seq)CoreUtils$.MODULE$.inWriteLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> {
            AnyRefMap partitionStates = new AnyRefMap(this.metadataSnapshot().partitionStates().size());
            this.metadataSnapshot().partitionStates().foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
                Tuple2 tuple2 = x0$7;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String topic = (String)tuple2._1();
                LongMap oldPartitionStates = (LongMap)tuple2._2();
                LongMap copy = new LongMap(oldPartitionStates.size());
                copy.$plus$plus$eq((TraversableOnce)oldPartitionStates);
                AnyRefMap anyRefMap = partitionStates.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)copy));
                return anyRefMap;
            });
            LongMap aliveBrokers = new LongMap(this.metadataSnapshot().aliveBrokers().size());
            LongMap aliveNodes = new LongMap(this.metadataSnapshot().aliveNodes().size());
            int n = updateMetadataRequest.controllerId();
            switch (n) {
                default: 
            }
            None$ controllerId = n < 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)n));
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(updateMetadataRequest.liveBrokers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)broker -> {
                MetadataCache.$anonfun$updateMetadata$3(aliveBrokers, aliveNodes, broker);
                return BoxedUnit.UNIT;
            });
            aliveNodes.get((long)$this.brokerId).foreach((Function1 & Serializable & scala.Serializable)listenerMap -> {
                MetadataCache.$anonfun$updateMetadata$5(this, aliveNodes, listenerMap);
                return BoxedUnit.UNIT;
            });
            ArrayBuffer deletedPartitions = new ArrayBuffer();
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(updateMetadataRequest.partitionStates()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
                BoxedUnit boxedUnit;
                Tuple2 tuple2 = x0$8;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    UpdateMetadataRequest.PartitionState info = (UpdateMetadataRequest.PartitionState)tuple2._2();
                    int controllerId = updateMetadataRequest.controllerId();
                    int controllerEpoch = updateMetadataRequest.controllerEpoch();
                    if (info.basePartitionState.leader == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                        this.removePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>>)partitionStates, tp.topic(), tp.partition());
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Deleted partition ").append(tp).append(" from metadata cache in response to UpdateMetadata ").append(new StringBuilder(55).append("request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId).toString()).toString());
                        boxedUnit = deletedPartitions.$plus$eq((Object)tp);
                    } else {
                        this.addOrUpdatePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>>)partitionStates, tp.topic(), tp.partition(), info);
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Cached leader info ").append(info).append(" for partition ").append(tp).append(" in response to ").append(new StringBuilder(70).append("UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId).toString()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            this.metadataSnapshot_$eq(new MetadataSnapshot(this, (AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>>)partitionStates, (Option<Object>)controllerId, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
            return deletedPartitions;
        });
    }

    public boolean contains(String topic) {
        return this.metadataSnapshot().partitionStates().contains((Object)topic);
    }

    public boolean contains(TopicPartition tp) {
        return this.getPartitionInfo(tp.topic(), tp.partition()).isDefined();
    }

    private boolean removePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> partitionStates, String topic, int partitionId) {
        return partitionStates.get((Object)topic).exists((Function1 & Serializable & scala.Serializable)infos -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$removePartitionInfo$1(partitionStates, topic, partitionId, infos)));
    }

    private final void MetadataSnapshot$lzycompute$1() {
        MetadataCache metadataCache = this;
        synchronized (metadataCache) {
            if (this.MetadataSnapshot$module == null) {
                this.MetadataSnapshot$module = new MetadataCache$MetadataSnapshot$(this);
            }
        }
    }

    private static final Node node$1(Integer id, LongMap nodes$1) {
        return (Node)nodes$1.get((long)Predef$.MODULE$.Integer2int(id)).orNull(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$2(Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        UpdateMetadataRequest.PartitionState state = (UpdateMetadataRequest.PartitionState)tuple2._2();
        boolean bl = state.basePartitionState.leader != LeaderAndIsr$.MODULE$.LeaderDuringDelete();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$7(String x$1) {
        return Topic.isInternal((String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$8(Node x$9) {
        return x$9 != null;
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$3(LongMap aliveBrokers$1, LongMap aliveNodes$1, UpdateMetadataRequest.Broker broker) {
        HashMap nodes = new HashMap();
        ArrayBuffer endPoints = new ArrayBuffer();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(broker.endPoints).asScala()).foreach((Function1 & Serializable & scala.Serializable)ep -> {
            endPoints.$plus$eq((Object)new EndPoint(ep.host, ep.port, ep.listenerName, ep.securityProtocol));
            return nodes.put(ep.listenerName, new Node(broker$1.id, ep.host, ep.port));
        });
        aliveBrokers$1.update((long)broker.id, (Object)new Broker(broker.id, (Seq<EndPoint>)endPoints, (Option<String>)Option$.MODULE$.apply((Object)broker.rack)));
        aliveNodes$1.update((long)broker.id, JavaConverters$.MODULE$.mapAsScalaMapConverter(nodes).asScala());
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$6(Set listeners$1, Map x$10) {
        Set set = x$10.keySet();
        Set set2 = listeners$1;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$5(MetadataCache $this, LongMap aliveNodes$1, Map listenerMap) {
        block0: {
            Set listeners = listenerMap.keySet();
            if (aliveNodes$1.values().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$updateMetadata$6(listeners, x$10)))) break block0;
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Listeners are not identical across brokers: ").append(aliveNodes$1).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$removePartitionInfo$1(AnyRefMap partitionStates$2, String topic$3, int partitionId$3, LongMap infos) {
        infos.remove((Object)BoxesRunTime.boxToLong((long)partitionId$3));
        Object object = infos.isEmpty() ? partitionStates$2.remove((Object)topic$3) : BoxedUnit.UNIT;
        return true;
    }

    public MetadataCache(int brokerId) {
        this.brokerId = brokerId;
        Logging.$init$(this);
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.metadataSnapshot = new MetadataSnapshot(this, (AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>>)AnyRefMap$.MODULE$.empty(), (Option<Object>)None$.MODULE$, (LongMap<Broker>)LongMap$.MODULE$.empty(), (LongMap<Map<ListenerName, Node>>)LongMap$.MODULE$.empty());
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }

    public class MetadataSnapshot
    implements Product,
    scala.Serializable {
        private final AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> partitionStates;
        private final Option<Object> controllerId;
        private final LongMap<Broker> aliveBrokers;
        private final LongMap<Map<ListenerName, Node>> aliveNodes;
        public final /* synthetic */ MetadataCache $outer;

        public AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> partitionStates() {
            return this.partitionStates;
        }

        public Option<Object> controllerId() {
            return this.controllerId;
        }

        public LongMap<Broker> aliveBrokers() {
            return this.aliveBrokers;
        }

        public LongMap<Map<ListenerName, Node>> aliveNodes() {
            return this.aliveNodes;
        }

        public MetadataSnapshot copy(AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> partitionStates, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            return new MetadataSnapshot(this.kafka$server$MetadataCache$MetadataSnapshot$$$outer(), partitionStates, controllerId, aliveBrokers, aliveNodes);
        }

        public AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> copy$default$1() {
            return this.partitionStates();
        }

        public Option<Object> copy$default$2() {
            return this.controllerId();
        }

        public LongMap<Broker> copy$default$3() {
            return this.aliveBrokers();
        }

        public LongMap<Map<ListenerName, Node>> copy$default$4() {
            return this.aliveNodes();
        }

        public String productPrefix() {
            return "MetadataSnapshot";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> anyRefMap;
            int n = x$1;
            switch (n) {
                case 0: {
                    anyRefMap = this.partitionStates();
                    break;
                }
                case 1: {
                    anyRefMap = this.controllerId();
                    break;
                }
                case 2: {
                    anyRefMap = this.aliveBrokers();
                    break;
                }
                case 3: {
                    anyRefMap = this.aliveNodes();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return anyRefMap;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MetadataSnapshot;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MetadataSnapshot)) return false;
            if (((MetadataSnapshot)object).kafka$server$MetadataCache$MetadataSnapshot$$$outer() != this.kafka$server$MetadataCache$MetadataSnapshot$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            MetadataSnapshot metadataSnapshot = (MetadataSnapshot)x$1;
            AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> anyRefMap = this.partitionStates();
            AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> anyRefMap2 = metadataSnapshot.partitionStates();
            if (anyRefMap == null) {
                if (anyRefMap2 != null) {
                    return false;
                }
            } else if (!anyRefMap.equals(anyRefMap2)) return false;
            Option<Object> option = this.controllerId();
            Option<Object> option2 = metadataSnapshot.controllerId();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            LongMap<Broker> longMap = this.aliveBrokers();
            LongMap<Broker> longMap2 = metadataSnapshot.aliveBrokers();
            if (longMap == null) {
                if (longMap2 != null) {
                    return false;
                }
            } else if (!longMap.equals(longMap2)) return false;
            LongMap<Map<ListenerName, Node>> longMap3 = this.aliveNodes();
            LongMap<Map<ListenerName, Node>> longMap4 = metadataSnapshot.aliveNodes();
            if (longMap3 == null) {
                if (longMap4 != null) {
                    return false;
                }
            } else if (!longMap3.equals(longMap4)) return false;
            if (!metadataSnapshot.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ MetadataCache kafka$server$MetadataCache$MetadataSnapshot$$$outer() {
            return this.$outer;
        }

        public MetadataSnapshot(MetadataCache $outer, AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> partitionStates, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            this.partitionStates = partitionStates;
            this.controllerId = controllerId;
            this.aliveBrokers = aliveBrokers;
            this.aliveNodes = aliveNodes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

