/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.checkpoints;

import com.typesafe.scalalogging.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.CheckpointFileFormatter;
import kafka.utils.Logging;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0001\u0003\u0001%\u0011ab\u00115fG.\u0004x.\u001b8u\r&dWM\u0003\u0002\u0004\t\u0005Y1\r[3dWB|\u0017N\u001c;t\u0015\t)a!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000f\u0005)1.\u00194lC\u000e\u0001QC\u0001\u00062'\r\u00011\"\u0005\t\u0003\u0019=i\u0011!\u0004\u0006\u0002\u001d\u0005)1oY1mC&\u0011\u0001#\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005I)R\"A\n\u000b\u0005Q1\u0011!B;uS2\u001c\u0018B\u0001\f\u0014\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0006\u0004%\t!G\u0001\u0005M&dW-F\u0001\u001b!\tY\u0002%D\u0001\u001d\u0015\tib$\u0001\u0002j_*\tq$\u0001\u0003kCZ\f\u0017BA\u0011\u001d\u0005\u00111\u0015\u000e\\3\t\u0011\r\u0002!\u0011!Q\u0001\ni\tQAZ5mK\u0002B\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\bm\u0016\u00148/[8o!\taq%\u0003\u0002)\u001b\t\u0019\u0011J\u001c;\t\u0011)\u0002!\u0011!Q\u0001\n-\n\u0011BZ8s[\u0006$H/\u001a:\u0011\u00071js&D\u0001\u0003\u0013\tq#AA\fDQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3G_Jl\u0017\r\u001e;feB\u0011\u0001'\r\u0007\u0001\t\u0015\u0011\u0004A1\u00014\u0005\u0005!\u0016C\u0001\u001b8!\taQ'\u0003\u00027\u001b\t9aj\u001c;iS:<\u0007C\u0001\u00079\u0013\tITBA\u0002B]fD\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001P\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0011\u0005urT\"\u0001\u0003\n\u0005}\"!\u0001\u0006'pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G\u000e\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0003\u0019awn\u001a#jeB\u00111I\u0013\b\u0003\t\"\u0003\"!R\u0007\u000e\u0003\u0019S!a\u0012\u0005\u0002\rq\u0012xn\u001c;?\u0013\tIU\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u00172\u0013aa\u0015;sS:<'BA%\u000e\u0011\u0015q\u0005\u0001\"\u0001P\u0003\u0019a\u0014N\\5u}Q1\u0001+\u0015*T)V\u00032\u0001\f\u00010\u0011\u0015AR\n1\u0001\u001b\u0011\u0015)S\n1\u0001'\u0011\u0015QS\n1\u0001,\u0011\u0015YT\n1\u0001=\u0011\u0015\tU\n1\u0001C\u0011\u001d9\u0006A1A\u0005\na\u000bA\u0001]1uQV\t\u0011\f\u0005\u0002[=6\t1L\u0003\u0002\u00199*\u0011QLH\u0001\u0004]&|\u0017BA0\\\u0005\u0011\u0001\u0016\r\u001e5\t\r\u0005\u0004\u0001\u0015!\u0003Z\u0003\u0015\u0001\u0018\r\u001e5!\u0011\u001d\u0019\u0007A1A\u0005\na\u000b\u0001\u0002^3naB\u000bG\u000f\u001b\u0005\u0007K\u0002\u0001\u000b\u0011B-\u0002\u0013Q,W\u000e\u001d)bi\"\u0004\u0003bB4\u0001\u0005\u0004%I\u0001[\u0001\u0005Y>\u001c7.F\u0001j!\tQW.D\u0001l\u0015\tag$\u0001\u0003mC:<\u0017B\u00018l\u0005\u0019y%M[3di\"1\u0001\u000f\u0001Q\u0001\n%\fQ\u0001\\8dW\u0002BQA\u001d\u0001\u0005\u0002M\fQa\u001e:ji\u0016$\"\u0001^<\u0011\u00051)\u0018B\u0001<\u000e\u0005\u0011)f.\u001b;\t\u000ba\f\b\u0019A=\u0002\u000f\u0015tGO]5fgB\u0019!0`\u0018\u000e\u0003mT!\u0001`\u0007\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\u007fw\n\u00191+Z9\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004\u0005!!/Z1e)\u0005I\b")
public class CheckpointFile<T>
implements Logging {
    private final File file;
    private final int version;
    private final CheckpointFileFormatter<T> formatter;
    private final LogDirFailureChannel logDirFailureChannel;
    private final String logDir;
    private final Path path;
    private final Path tempPath;
    private final Object lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        CheckpointFile checkpointFile = this;
        synchronized (checkpointFile) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File file() {
        return this.file;
    }

    private Path path() {
        return this.path;
    }

    private Path tempPath() {
        return this.tempPath;
    }

    private Object lock() {
        return this.lock;
    }

    public void write(Seq<T> entries) {
        Object object = this.lock();
        synchronized (object) {
            this.liftedTree1$1(entries);
        }
    }

    public Seq<T> read() {
        Seq seq;
        Object object = new Object();
        try {
            Object object2 = this.lock();
            synchronized (object2) {
                Seq seq2 = this.liftedTree2$1(object);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                seq = seq2;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                seq = (Seq)ex.value();
            }
            throw ex;
        }
        return seq;
    }

    public static final /* synthetic */ void $anonfun$write$1(CheckpointFile $this, BufferedWriter writer$1, Object entry) {
        writer$1.write($this.formatter.toLine(entry));
        writer$1.newLine();
    }

    private final void liftedTree1$1(Seq entries$1) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.tempPath().toFile());
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8));){
                writer.write(((Object)BoxesRunTime.boxToInteger((int)this.version)).toString());
                writer.newLine();
                writer.write(((Object)BoxesRunTime.boxToInteger((int)entries$1.size())).toString());
                writer.newLine();
                entries$1.foreach((Function1 & Serializable & scala.Serializable)entry -> {
                    CheckpointFile.$anonfun$write$1(this, writer, entry);
                    return BoxedUnit.UNIT;
                });
                writer.flush();
                fileOutputStream.getFD().sync();
            }
            Utils.atomicMoveWithFallback((Path)this.tempPath(), (Path)this.path());
        }
        catch (IOException e) {
            String msg = new StringBuilder(39).append("Error while writing to checkpoint file ").append(this.file().getAbsolutePath()).toString();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }

    private final IOException malformedLineException$1(String line) {
        return new IOException(new StringBuilder(39).append("Malformed line in checkpoint file (").append(this.file().getAbsolutePath()).append("): ").append(line).append("'").toString());
    }

    private final Seq liftedTree2$1(Object nonLocalReturnKey1$1) {
        Buffer buffer;
        block15: {
            try {
                String line = null;
                try (BufferedReader reader = Files.newBufferedReader(this.path());){
                    try {
                        line = reader.readLine();
                        if (line == null) {
                            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)Seq$.MODULE$.empty());
                        }
                        int n = new StringOps(Predef$.MODULE$.augmentString(line)).toInt();
                        switch (n) {
                            default: 
                        }
                        if (n == this.version) {
                            line = reader.readLine();
                            if (line == null) {
                                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)Seq$.MODULE$.empty());
                            }
                            int expectedSize = new StringOps(Predef$.MODULE$.augmentString(line)).toInt();
                            Buffer entries = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                            line = reader.readLine();
                            while (line != null) {
                                Option<T> entry = this.formatter.fromLine(line);
                                Option<T> option = entry;
                                if (option instanceof Some) {
                                    Some some = (Some)option;
                                    Object e = some.value();
                                    entries.$plus$eq(e);
                                    line = reader.readLine();
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    continue;
                                }
                                throw this.malformedLineException$1(line);
                            }
                            if (entries.size() != expectedSize) {
                                throw new IOException(new StringBuilder(56).append("Expected ").append(expectedSize).append(" entries in checkpoint file (").append(this.file().getAbsolutePath()).append("), but found only ").append(entries.size()).toString());
                            }
                            buffer = entries;
                            break block15;
                        }
                        throw new IOException(new StringBuilder(48).append("Unrecognized version of the checkpoint file (").append(this.file().getAbsolutePath()).append("): ").append(this.version).toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw this.malformedLineException$1(line);
                    }
                }
            }
            catch (IOException e) {
                String msg = new StringBuilder(36).append("Error while reading checkpoint file ").append(this.file().getAbsolutePath()).toString();
                this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
                throw new KafkaStorageException(msg, (Throwable)e);
            }
        }
        return buffer;
    }

    public CheckpointFile(File file, int version, CheckpointFileFormatter<T> formatter, LogDirFailureChannel logDirFailureChannel, String logDir) {
        Object object;
        this.file = file;
        this.version = version;
        this.formatter = formatter;
        this.logDirFailureChannel = logDirFailureChannel;
        this.logDir = logDir;
        Logging.$init$(this);
        this.path = file.toPath().toAbsolutePath();
        this.tempPath = Paths.get(new StringBuilder(4).append(((Object)this.path()).toString()).append(".tmp").toString(), new String[0]);
        this.lock = new Object();
        try {
            object = Files.createFile(file.toPath(), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            object = BoxedUnit.UNIT;
        }
    }
}

