/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Properties;
import joptsimple.OptionException;
import kafka.common.MessageReader;
import kafka.tools.ConsoleProducer;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.utils.Utils;

public final class ConsoleProducer$ {
    public static ConsoleProducer$ MODULE$;

    static {
        new ConsoleProducer$();
    }

    public void main(String[] args) {
        try {
            ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(args);
            MessageReader reader = (MessageReader)Class.forName(config.readerClass()).newInstance();
            reader.init(System.in, this.getReaderProps(config));
            KafkaProducer producer = new KafkaProducer(this.producerProps(config));
            Runtime.getRuntime().addShutdownHook(new Thread(producer){
                private final KafkaProducer producer$1;

                public void run() {
                    this.producer$1.close();
                }
                {
                    this.producer$1 = producer$1;
                }
            });
            ProducerRecord<byte[], byte[]> record = null;
            while (true) {
                if ((record = reader.readMessage()) != null) {
                    this.send((KafkaProducer<byte[], byte[]>)producer, record, config.sync());
                }
                if (record != null) {
                    continue;
                }
                break;
            }
        }
        catch (OptionException e) {
            System.err.println(e.getMessage());
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
    }

    private void send(KafkaProducer<byte[], byte[]> producer, ProducerRecord<byte[], byte[]> record, boolean sync) {
        if (sync) {
            producer.send(record).get();
        } else {
            producer.send(record, (Callback)new ErrorLoggingCallback(record.topic(), (byte[])record.key(), (byte[])record.value(), false));
        }
    }

    /*
     * WARNING - void declaration
     */
    public Properties getReaderProps(ConsoleProducer.ProducerConfig config) {
        void var2_2;
        Properties props = new Properties();
        props.put("topic", config.topic());
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(config.cmdLineProps());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Properties producerProps(ConsoleProducer.ProducerConfig config) {
        void var2_2;
        Properties props = config.options().has(config.producerConfigOpt()) ? Utils.loadProps((String)((String)config.options().valueOf(config.producerConfigOpt()))) : new Properties();
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(config.extraProducerProps());
        props.put("bootstrap.servers", config.brokerList());
        props.put("compression.type", config.compressionCodec());
        props.put("send.buffer.bytes", config.socketBuffer().toString());
        props.put("retry.backoff.ms", config.retryBackoffMs().toString());
        props.put("metadata.max.age.ms", config.metadataExpiryMs().toString());
        props.put("max.block.ms", config.maxBlockMs().toString());
        props.put("acks", config.requestRequiredAcks());
        props.put("request.timeout.ms", config.requestTimeoutMs().toString());
        props.put("retries", config.messageSendMaxRetries().toString());
        props.put("linger.ms", config.sendTimeout().toString());
        props.put("buffer.memory", config.maxMemoryBytes().toString());
        props.put("batch.size", config.maxPartitionMemoryBytes().toString());
        props.put("client.id", "console-producer");
        props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        return var2_2;
    }

    private ConsoleProducer$() {
        MODULE$ = this;
    }
}

