/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import kafka.api.Request$;
import kafka.tools.ReplicaBuffer;
import kafka.tools.ReplicaFetcherBlockingSend;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0005\u000f\tq!+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014(BA\u0002\u0005\u0003\u0015!xn\u001c7t\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u000bU$\u0018\u000e\\:\n\u00055Q!AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012D\u0011b\u0004\u0001\u0003\u0002\u0003\u0006I\u0001E\u000f\u0002\t9\fW.\u001a\t\u0003#iq!A\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U1\u0011A\u0002\u001fs_>$hHC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIb#\u0001\u0004Qe\u0016$WMZ\u0005\u00037q\u0011aa\u0015;sS:<'BA\r\u0017\u0013\tyA\u0002\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u00031\u0019x.\u001e:dK\n\u0013xn[3s!\t\t\u0013&D\u0001#\u0015\t\u0019C%\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u0015R!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sO&\u0011!F\t\u0002\u0005\u001d>$W\r\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\bc\u0001\u00184m9\u0011q&\r\b\u0003'AJ\u0011aF\u0005\u0003eY\tq\u0001]1dW\u0006<W-\u0003\u00025k\tA\u0011\n^3sC\ndWM\u0003\u00023-A\u0011\u0011eN\u0005\u0003q\t\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u00035\u0011X\r\u001d7jG\u0006\u0014UO\u001a4feB\u0011A(P\u0007\u0002\u0005%\u0011aH\u0001\u0002\u000e%\u0016\u0004H.[2b\u0005V4g-\u001a:\t\u0011\u0001\u0003!\u0011!Q\u0001\n\u0005\u000bQb]8dW\u0016$H+[7f_V$\bC\u0001\"D\u001b\u00051\u0012B\u0001#\u0017\u0005\rIe\u000e\u001e\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u0003\u0006\u00012o\\2lKR\u0014UO\u001a4feNK'0\u001a\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0003\u0006Ia-\u001a;dQNK'0\u001a\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0003\u00069Q.\u0019=XC&$\b\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B!\u0002\u00115LgNQ=uKND\u0001B\u0014\u0001\u0003\u0002\u0003\u0006IaT\u0001\u000fI>4VM]5gS\u000e\fG/[8o!\t\u0011\u0005+\u0003\u0002R-\t9!i\\8mK\u0006t\u0007\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002+\u0002\u001d\r|gn];nKJ\u001cuN\u001c4jOB\u0011QKW\u0007\u0002-*\u0011q\u000bW\u0001\u0005kRLGNC\u0001Z\u0003\u0011Q\u0017M^1\n\u0005m3&A\u0003)s_B,'\u000f^5fg\"AQ\f\u0001B\u0001B\u0003%\u0011)A\u0005gKR\u001c\u0007.\u001a:JI\")q\f\u0001C\u0001A\u00061A(\u001b8jiz\"R\"\u00192dI\u00164w\r[5kW2l\u0007C\u0001\u001f\u0001\u0011\u0015ya\f1\u0001\u0011\u0011\u0015yb\f1\u0001!\u0011\u0015ac\f1\u0001.\u0011\u0015Qd\f1\u0001<\u0011\u0015\u0001e\f1\u0001B\u0011\u00151e\f1\u0001B\u0011\u0015Ae\f1\u0001B\u0011\u0015Qe\f1\u0001B\u0011\u0015ae\f1\u0001B\u0011\u0015qe\f1\u0001P\u0011\u0015\u0019f\f1\u0001U\u0011\u0015if\f1\u0001B\u0011\u001dy\u0007A1A\u0005\nA\fQBZ3uG\",e\u000e\u001a9pS:$X#A9\u0011\u0005q\u0012\u0018BA:\u0003\u0005i\u0011V\r\u001d7jG\u00064U\r^2iKJ\u0014En\\2lS:<7+\u001a8e\u0011\u0019)\b\u0001)A\u0005c\u0006qa-\u001a;dQ\u0016sG\r]8j]R\u0004\u0003\"B<\u0001\t\u0003B\u0018A\u00023p/>\u00148\u000eF\u0001z!\t\u0011%0\u0003\u0002|-\t!QK\\5u\u0001")
public class ReplicaFetcher
extends ShutdownableThread {
    private final Node sourceBroker;
    private final Iterable<TopicPartition> topicPartitions;
    private final ReplicaBuffer replicaBuffer;
    private final int fetchSize;
    private final int maxWait;
    private final int minBytes;
    private final boolean doVerification;
    private final ReplicaFetcherBlockingSend fetchEndpoint;

    private ReplicaFetcherBlockingSend fetchEndpoint() {
        return this.fetchEndpoint;
    }

    @Override
    public void doWork() {
        CountDownLatch verificationBarrier;
        CountDownLatch fetcherBarrier;
        block7: {
            block6: {
                fetcherBarrier = this.replicaBuffer.getFetcherBarrier();
                verificationBarrier = this.replicaBuffer.getVerificationBarrier();
                LinkedHashMap requestMap = new LinkedHashMap();
                this.topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> requestMap.put(topicPartition, new FetchRequest.PartitionData($this.replicaBuffer.getOffset((TopicPartition)topicPartition), 0L, $this.fetchSize, Optional.empty())));
                FetchRequest.Builder fetchRequestBuilder = FetchRequest.Builder.forReplica((short)ApiKeys.FETCH.latestVersion(), (int)Request$.MODULE$.DebuggingConsumerId(), (int)this.maxWait, (int)this.minBytes, requestMap);
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Issuing fetch request ");
                FetchResponse fetchResponse = null;
                try {
                    ClientResponse clientResponse = this.fetchEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequestBuilder);
                    fetchResponse = (FetchResponse)clientResponse.responseBody();
                }
                finally {
                    if (fetchResponse != null) {
                    }
                    break block6;
                }
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)fetchResponse.responseData()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                    ReplicaFetcher.$anonfun$doWork$3(this, x0$5);
                    return BoxedUnit.UNIT;
                });
                break block7;
            }
            FetchResponse.PartitionData emptyResponse = new FetchResponse.PartitionData(Errors.NONE, -1L, -1L, -1L, null, (BaseRecords)MemoryRecords.EMPTY);
            this.topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicAndPartition -> {
                this.replicaBuffer.addFetchedData(topicAndPartition, this.sourceBroker.id(), (FetchResponse.PartitionData<MemoryRecords>)emptyResponse);
                return BoxedUnit.UNIT;
            });
        }
        fetcherBarrier.countDown();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Done fetching");
        fetcherBarrier.await();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ready for verification");
        if (this.doVerification) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Do verification");
            this.replicaBuffer.verifyCheckSum((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x -> {
                Predef$.MODULE$.println(x);
                return BoxedUnit.UNIT;
            });
            this.replicaBuffer.createNewFetcherBarrier();
            this.replicaBuffer.createNewVerificationBarrier();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Created new barrier");
            verificationBarrier.countDown();
        }
        verificationBarrier.await();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Done verification");
    }

    public static final /* synthetic */ void $anonfun$doWork$3(ReplicaFetcher $this, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)tuple2._2();
        $this.replicaBuffer.addFetchedData(tp, $this.sourceBroker.id(), (FetchResponse.PartitionData<MemoryRecords>)partitionData);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ReplicaFetcher(String name, Node sourceBroker, Iterable<TopicPartition> topicPartitions, ReplicaBuffer replicaBuffer, int socketTimeout, int socketBufferSize, int fetchSize, int maxWait, int minBytes, boolean doVerification, Properties consumerConfig, int fetcherId) {
        this.sourceBroker = sourceBroker;
        this.topicPartitions = topicPartitions;
        this.replicaBuffer = replicaBuffer;
        this.fetchSize = fetchSize;
        this.maxWait = maxWait;
        this.minBytes = minBytes;
        this.doVerification = doVerification;
        super(name, ShutdownableThread$.MODULE$.$lessinit$greater$default$2());
        this.fetchEndpoint = new ReplicaFetcherBlockingSend(sourceBroker, new ConsumerConfig(consumerConfig), new Metrics(), Time.SYSTEM, fetcherId, new StringBuilder(16).append("broker-").append(Request$.MODULE$.DebuggingConsumerId()).append("-fetcher-").append(fetcherId).toString());
    }
}

