/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import kafka.TestLinearWriteSpeed$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogManager$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Scheduler;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\ru!\u0002\u0016,\u0011\u0003qc!\u0002\u0019,\u0011\u0003\t\u0004\"\u0002\u001d\u0002\t\u0003I\u0004\"\u0002\u001e\u0002\t\u0003YdaB(\u0002!\u0003\r\n\u0001\u0015\u0005\u0006#\u00121\tA\u0015\u0005\u0006-\u00121\ta\u0016\u0004\u00051\u0006\u0001\u0011\f\u0003\u0005]\u000f\t\u0015\r\u0011\"\u0001^\u0011!1wA!A!\u0002\u0013q\u0006\u0002C4\b\u0005\u0003\u0005\u000b\u0011\u00025\t\u0011-<!Q1A\u0005\u00021D\u0001b]\u0004\u0003\u0002\u0003\u0006I!\u001c\u0005\u0006q\u001d!\t\u0001\u001e\u0005\bs\u001e\u0011\r\u0011\"\u0001{\u0011\u0019qx\u0001)A\u0005w\"Aqp\u0002b\u0001\n\u0003\t\t\u0001\u0003\u0005\u0002\n\u001d\u0001\u000b\u0011BA\u0002\u0011\u0015\tv\u0001\"\u0001S\u0011\u00151v\u0001\"\u0001X\r\u0019\tY!\u0001\u0001\u0002\u000e!AA\f\u0006BC\u0002\u0013\u0005Q\f\u0003\u0005g)\t\u0005\t\u0015!\u0003_\u0011!YGC!b\u0001\n\u0003a\u0007\u0002C:\u0015\u0005\u0003\u0005\u000b\u0011B7\t\ra\"B\u0011AA\b\u0011%\t9\u0002\u0006b\u0001\n\u0003\tI\u0002\u0003\u0005\u0002(Q\u0001\u000b\u0011BA\u000e\u0011\u0015\tF\u0003\"\u0001S\u0011\u00151F\u0003\"\u0001X\r\u0019\tI#\u0001\u0001\u0002,!I\u0011Q\u0006\u0010\u0003\u0006\u0004%\t!\u0018\u0005\n\u0003_q\"\u0011!Q\u0001\nyC!\"!\r\u001f\u0005\u0003\u0005\u000b\u0011BA\u001a\u0011)\tyD\bB\u0001B\u0003%\u0011\u0011\t\u0005\u000b\u0003\u001br\"Q1A\u0005\u0002\u0005=\u0003BCA6=\t\u0005\t\u0015!\u0003\u0002R!1\u0001H\bC\u0001\u0003[B\u0011\"!\u000f\u001f\u0005\u0004%\t!!\u001f\t\u0011\u0005\u0005e\u0004)A\u0005\u0003wBQ!\u0015\u0010\u0005\u0002ICQA\u0016\u0010\u0005\u0002]\u000bA\u0003V3ti2Kg.Z1s/JLG/Z*qK\u0016$'\"\u0001\u0017\u0002\u000b-\fgm[1\u0004\u0001A\u0011q&A\u0007\u0002W\t!B+Z:u\u0019&tW-\u0019:Xe&$Xm\u00159fK\u0012\u001c\"!\u0001\u001a\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta&\u0001\u0003nC&tGC\u0001\u001f@!\t\u0019T(\u0003\u0002?i\t!QK\\5u\u0011\u0015\u00015\u00011\u0001B\u0003\u0011\t'oZ:\u0011\u0007M\u0012E)\u0003\u0002Di\t)\u0011I\u001d:bsB\u0011Q\t\u0014\b\u0003\r*\u0003\"a\u0012\u001b\u000e\u0003!S!!S\u0017\u0002\rq\u0012xn\u001c;?\u0013\tYE'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001b:\u0013aa\u0015;sS:<'BA&5\u0005!9&/\u001b;bE2,7C\u0001\u00033\u0003\u00159(/\u001b;f)\u0005\u0019\u0006CA\u001aU\u0013\t)FGA\u0002J]R\fQa\u00197pg\u0016$\u0012\u0001\u0010\u0002\r\u001b6\f\u0007o\u0016:ji\u0006\u0014G.Z\n\u0004\u000fIR\u0006CA.\u0005\u001b\u0005\t\u0011\u0001\u00024jY\u0016,\u0012A\u0018\t\u0003?\u0012l\u0011\u0001\u0019\u0006\u0003C\n\f!![8\u000b\u0003\r\fAA[1wC&\u0011Q\r\u0019\u0002\u0005\r&dW-A\u0003gS2,\u0007%\u0001\u0003tSj,\u0007CA\u001aj\u0013\tQGG\u0001\u0003M_:<\u0017aB2p]R,g\u000e^\u000b\u0002[B\u0011a.]\u0007\u0002_*\u0011\u0001OY\u0001\u0004]&|\u0017B\u0001:p\u0005)\u0011\u0015\u0010^3Ck\u001a4WM]\u0001\tG>tG/\u001a8uAQ!QO^<y!\tYv\u0001C\u0003]\u001b\u0001\u0007a\fC\u0003h\u001b\u0001\u0007\u0001\u000eC\u0003l\u001b\u0001\u0007Q.A\u0002sC\u001a,\u0012a\u001f\t\u0003?rL!! 1\u0003!I\u000bg\u000eZ8n\u0003\u000e\u001cWm]:GS2,\u0017\u0001\u0002:bM\u0002\naAY;gM\u0016\u0014XCAA\u0002!\rq\u0017QA\u0005\u0004\u0003\u000fy'\u0001E'baB,GMQ=uK\n+hMZ3s\u0003\u001d\u0011WO\u001a4fe\u0002\u0012qb\u00115b]:,Gn\u0016:ji\u0006\u0014G.Z\n\u0004)IRFCBA\t\u0003'\t)\u0002\u0005\u0002\\)!)A,\u0007a\u0001=\")1.\u0007a\u0001[\u000691\r[1o]\u0016dWCAA\u000e!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011_\u0006A1\r[1o]\u0016d7/\u0003\u0003\u0002&\u0005}!a\u0003$jY\u0016\u001c\u0005.\u00198oK2\f\u0001b\u00195b]:,G\u000e\t\u0002\f\u0019><wK]5uC\ndWmE\u0002\u001fei\u000b1\u0001Z5s\u0003\u0011!\u0017N\u001d\u0011\u0002\r\r|gNZ5h!\u0011\t)$a\u000f\u000e\u0005\u0005]\"bAA\u001dW\u0005\u0019An\\4\n\t\u0005u\u0012q\u0007\u0002\n\u0019><7i\u001c8gS\u001e\f\u0011b]2iK\u0012,H.\u001a:\u0011\t\u0005\r\u0013\u0011J\u0007\u0003\u0003\u000bR1!a\u0012,\u0003\u0015)H/\u001b7t\u0013\u0011\tY%!\u0012\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018\u0001C7fgN\fw-Z:\u0016\u0005\u0005E\u0003\u0003BA*\u0003Oj!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\u0007e\u0016\u001cwN\u001d3\u000b\t\u0005m\u0013QL\u0001\u0007G>lWn\u001c8\u000b\u00071\nyF\u0003\u0003\u0002b\u0005\r\u0014AB1qC\u000eDWM\u0003\u0002\u0002f\u0005\u0019qN]4\n\t\u0005%\u0014Q\u000b\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\u0002\u00135,7o]1hKN\u0004CCCA8\u0003c\n\u0019(!\u001e\u0002xA\u00111L\b\u0005\u0007\u0003[)\u0003\u0019\u00010\t\u000f\u0005ER\u00051\u0001\u00024!9\u0011qH\u0013A\u0002\u0005\u0005\u0003bBA'K\u0001\u0007\u0011\u0011K\u000b\u0003\u0003w\u0002B!!\u000e\u0002~%!\u0011qPA\u001c\u0005\raunZ\u0001\u0005Y><\u0007\u0005")
public final class TestLinearWriteSpeed {
    public static void main(String[] stringArray) {
        TestLinearWriteSpeed$.MODULE$.main(stringArray);
    }

    public static class ChannelWritable
    implements Writable {
        private final File file;
        private final ByteBuffer content;
        private final FileChannel channel;

        public File file() {
            return this.file;
        }

        public ByteBuffer content() {
            return this.content;
        }

        public FileChannel channel() {
            return this.channel;
        }

        @Override
        public int write() {
            this.channel().write(this.content());
            this.content().rewind();
            return this.content().limit();
        }

        @Override
        public void close() {
            this.channel().close();
            Utils.delete((File)this.file());
        }

        public ChannelWritable(File file, ByteBuffer content) {
            this.file = file;
            this.content = content;
            file.deleteOnExit();
            this.channel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        }
    }

    public static class LogWritable
    implements Writable {
        private final File dir;
        private final MemoryRecords messages;
        private final Log log;

        public File dir() {
            return this.dir;
        }

        public MemoryRecords messages() {
            return this.messages;
        }

        public Log log() {
            return this.log;
        }

        @Override
        public int write() {
            this.log().appendAsLeader(this.messages(), 0, this.log().appendAsLeader$default$3(), this.log().appendAsLeader$default$4());
            return this.messages().sizeInBytes();
        }

        @Override
        public void close() {
            this.log().close();
            Utils.delete((File)this.log().dir());
        }

        public LogWritable(File dir, LogConfig config, Scheduler scheduler, MemoryRecords messages) {
            this.dir = dir;
            this.messages = messages;
            Utils.delete((File)dir);
            this.log = Log$.MODULE$.apply(dir, config, 0L, 0L, scheduler, new BrokerTopicStats(), Time.SYSTEM, 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), new LogDirFailureChannel(10));
        }
    }

    public static class MmapWritable
    implements Writable {
        private final File file;
        private final ByteBuffer content;
        private final RandomAccessFile raf;
        private final MappedByteBuffer buffer;

        public File file() {
            return this.file;
        }

        public ByteBuffer content() {
            return this.content;
        }

        public RandomAccessFile raf() {
            return this.raf;
        }

        public MappedByteBuffer buffer() {
            return this.buffer;
        }

        @Override
        public int write() {
            this.buffer().put(this.content());
            this.content().rewind();
            return this.content().limit();
        }

        @Override
        public void close() {
            this.raf().close();
            Utils.delete((File)this.file());
        }

        public MmapWritable(File file, long size, ByteBuffer content) {
            this.file = file;
            this.content = content;
            file.deleteOnExit();
            this.raf = new RandomAccessFile(file, "rw");
            this.raf().setLength(size);
            this.buffer = this.raf().getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.raf().length());
        }
    }

    public static interface Writable {
        public int write();

        public void close();
    }
}

