/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0015d\u0001\u0002\u00192\u0001YBQa\u000f\u0001\u0005\u0002qBqA\u0010\u0001C\u0002\u0013\u0005q\b\u0003\u0004I\u0001\u0001\u0006I\u0001\u0011\u0005\b\u0013\u0002\u0011\r\u0011\"\u0001K\u0011\u0019\t\u0006\u0001)A\u0005\u0017\"9!\u000b\u0001b\u0001\n\u0003Q\u0005BB*\u0001A\u0003%1\nC\u0003U\u0001\u0011\u0005S\u000bC\u0003e\u0001\u0011%Q\rC\u0003u\u0001\u0011%Q\u000fC\u0003\u007f\u0001\u0011%q\u0010C\u0004\u0002\b\u0001!I!!\u0003\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005=\u0001bBA\u0017\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003c\u0001A\u0011AA\b\u0011\u001d\t)\u0004\u0001C\u0001\u0003\u001fAq!!\u000f\u0001\t\u0003\ty\u0001C\u0004\u0002>\u0001!\t!a\u0004\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002\u0010!9\u0011Q\t\u0001\u0005\u0002\u0005=\u0001bBA%\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003\u001b\u0002A\u0011AA\b\u0011\u001d\t\t\u0006\u0001C\u0001\u0003\u001fAq!!\u0016\u0001\t\u0003\ty\u0001C\u0004\u0002Z\u0001!\t!a\u0004\t\u000f\u0005u\u0003\u0001\"\u0001\u0002\u0010!9\u0011\u0011\r\u0001\u0005\u0002\u0005=\u0001bBA3\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003S\u0002A\u0011AA\b\u0011\u001d\ti\u0007\u0001C\u0001\u0003\u001fAq!!\u001d\u0001\t\u0003\ty\u0001C\u0004\u0002v\u0001!\t!a\u0004\t\u000f\u0005e\u0004\u0001\"\u0001\u0002\u0010!9\u0011Q\u0010\u0001\u0005\u0002\u0005=\u0001bBAA\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003+\u0003A\u0011BAL\u0011\u001d\t9\u000b\u0001C\u0005\u0003SC\u0011\"a.\u0001#\u0003%I!!/\t\u000f\u0005=\u0007\u0001\"\u0003\u0002R\"I\u0011\u0011\u001d\u0001\u0012\u0002\u0013%\u00111\u001d\u0005\n\u0003O\u0004\u0011\u0013!C\u0005\u0003GDq!!;\u0001\t\u0013\tY\u000fC\u0005\u0003\u0002\u0001\t\n\u0011\"\u0003\u0003\u0004!I!q\u0001\u0001\u0012\u0002\u0013%!\u0011\u0002\u0005\b\u0005\u001b\u0001A\u0011\u0002B\b\u0011\u001d\u0011I\u0005\u0001C\u0005\u0005\u0017\u0012ADU3tKR\u001cuN\\:v[\u0016\u0014xI]8va>3gm]3u)\u0016\u001cHO\u0003\u00023g\u0005)\u0011\rZ7j]*\tA'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00019\u0004C\u0001\u001d:\u001b\u0005\t\u0014B\u0001\u001e2\u0005a\u0019uN\\:v[\u0016\u0014xI]8va\u000e{W.\\1oIR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0002\"\u0001\u000f\u0001\u0002\u001f=4XM\u001d:jI&tw\r\u0015:paN,\u0012\u0001\u0011\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bA!\u001e;jY*\tQ)\u0001\u0003kCZ\f\u0017BA$C\u0005)\u0001&o\u001c9feRLWm]\u0001\u0011_Z,'O]5eS:<\u0007K]8qg\u0002\na\u0001^8qS\u000e\fT#A&\u0011\u00051{U\"A'\u000b\u00059#\u0015\u0001\u00027b]\u001eL!\u0001U'\u0003\rM#(/\u001b8h\u0003\u001d!x\u000e]5dc\u0001\na\u0001^8qS\u000e\u0014\u0014a\u0002;pa&\u001c'\u0007I\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\ta\u000bE\u0002X9zk\u0011\u0001\u0017\u0006\u00033j\u000b!bY8mY\u0016\u001cG/[8o\u0015\u0005Y\u0016!B:dC2\f\u0017BA/Y\u0005\r\u0019V-\u001d\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003CN\naa]3sm\u0016\u0014\u0018BA2a\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0013\t\f7/[2Be\u001e\u001cX#\u00014\u0011\u0007\u001dD'.D\u0001[\u0013\tI'LA\u0003BeJ\f\u0017\u0010\u0005\u0002le:\u0011A\u000e\u001d\t\u0003[jk\u0011A\u001c\u0006\u0003_V\na\u0001\u0010:p_Rt\u0014BA9[\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001k\u001d\u0006\u0003cj\u000b!CY;jY\u0012\f%oZ:G_J<%o\\;qgR\u0019aM^=\t\u000b]T\u0001\u0019\u0001=\u0002\r\u001d\u0014x.\u001e9t!\r9FL\u001b\u0005\u0006u*\u0001\ra_\u0001\u0005CJ<7\u000fE\u0002hy*L!! .\u0003\u0015q\u0012X\r]3bi\u0016$g(A\tck&dG-\u0011:hg\u001a{'o\u0012:pkB$RAZA\u0001\u0003\u000bAa!a\u0001\f\u0001\u0004Q\u0017!B4s_V\u0004\b\"\u0002>\f\u0001\u0004Y\u0018!\u00062vS2$\u0017I]4t\r>\u0014\u0018\t\u001c7He>,\bo\u001d\u000b\u0004M\u0006-\u0001\"\u0002>\r\u0001\u0004Y\u0018\u0001\t;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t\u001d>$X\t_5ti&twm\u0012:pkB$\"!!\u0005\u0011\u0007\u001d\f\u0019\"C\u0002\u0002\u0016i\u0013A!\u00168ji\"\u001aQ\"!\u0007\u0011\t\u0005m\u0011QE\u0007\u0003\u0003;QA!a\b\u0002\"\u0005)!.\u001e8ji*\u0011\u00111E\u0001\u0004_J<\u0017\u0002BA\u0014\u0003;\u0011A\u0001V3ti\u0006iB/Z:u%\u0016\u001cX\r^(gMN,Go]#ySN$\u0018N\\4U_BL7\rK\u0002\u000f\u00033\t1\u0006^3tiJ+7/\u001a;PM\u001a\u001cX\r^:Fq&\u001cH/\u001b8h)>\u0004\u0018nY*fY\u0016\u001cG/\u001a3He>,\bo\u001d\u0015\u0004\u001f\u0005e\u0011A\n;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t\u000bbL7\u000f^5oOR{\u0007/[2BY2<%o\\;qg\"\u001a\u0001#!\u0007\u0002EQ,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001c\u0018\t\u001c7U_BL7m]!mY\u001e\u0013x.\u001e9tQ\r\t\u0012\u0011D\u0001 i\u0016\u001cHOU3tKR|eMZ:fiN$v\u000eT8dC2$\u0015\r^3US6,\u0007f\u0001\n\u0002\u001a\u0005yB/Z:u%\u0016\u001cX\r^(gMN,Go\u001d+p5>tW\r\u001a#bi\u0016$\u0016.\\3)\u0007M\tI\"\u0001\u000euKN$(+Z:fi>3gm]3ug\nKH)\u001e:bi&|g\u000eK\u0002\u0015\u00033\tA\u0005^3tiJ+7/\u001a;PM\u001a\u001cX\r^:Cs\u0012+(/\u0019;j_:$v.R1sY&,7\u000f\u001e\u0015\u0004+\u0005e\u0011A\u0007;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t)>,\u0015M\u001d7jKN$\bf\u0001\f\u0002\u001a\u0005AB/Z:u%\u0016\u001cX\r^(gMN,Go\u001d+p\u0019\u0006$Xm\u001d;)\u0007]\tI\"A\u0010uKN$(+Z:fi>3gm]3ugR{7)\u001e:sK:$xJ\u001a4tKRD3\u0001GA\r\u0003\u0001\"Xm\u001d;SKN,Go\u00144gg\u0016$8\u000fV8Ta\u0016\u001c\u0017NZ5d\u001f\u001a47/\u001a;)\u0007e\tI\"A\ruKN$(+Z:fi>3gm]3ugNC\u0017N\u001a;QYV\u001c\bf\u0001\u000e\u0002\u001a\u0005QB/Z:u%\u0016\u001cX\r^(gMN,Go]*iS\u001a$X*\u001b8vg\"\u001a1$!\u0007\u0002QQ,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001c8\u000b[5gi\nKHj\\<feRC\u0017M\\#be2LWm\u001d;)\u0007q\tI\"A\u0014uKN$(+Z:fi>3gm]3ugNC\u0017N\u001a;Cs\"Kw\r[3s)\"\fg\u000eT1uKN$\bfA\u000f\u0002\u001a\u0005!C/Z:u%\u0016\u001cX\r^(gMN,Go\u001d+p\u000b\u0006\u0014H.[3ti>swJ\\3U_BL7\rK\u0002\u001f\u00033\t\u0001\u0007^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_\u0016\u000b'\u000f\\5fgR|en\u00148f)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007fA\u0010\u0002\u001a\u0005\u0011C/Z:u%\u0016\u001cX\r^(gMN,Go\u001d+p\u000b\u0006\u0014H.[3ti>sGk\u001c9jGND3\u0001IA\r\u0003=\"Xm\u001d;SKN,Go\u00144gg\u0016$8\u000fV8FCJd\u0017.Z:u\u001f:$v\u000e]5dg\u0006sG\rU1si&$\u0018n\u001c8tQ\r\t\u0013\u0011D\u0001/i\u0016\u001cHOU3tKR|eMZ:fiN,\u0005\u0010]8si&k\u0007o\u001c:u!2\fgnU5oO2,wI]8va\u0006\u0013x\rK\u0002#\u00033\t\u0001\u0005^3tiJ+7/\u001a;PM\u001a\u001cX\r^:FqB|'\u000f^%na>\u0014H\u000f\u00157b]\"\u001a1%!\u0007\u0002UQ,7\u000f\u001e*fg\u0016$x+\u001b;i+:\u0014XmY8h]&TX\r\u001a(fo\u000e{gn];nKJ|\u0005\u000f^5p]\":A%!\u0007\u0002\u0006\u0006\u001d\u0015\u0001C3ya\u0016\u001cG/\u001a3$\u0005\u0005%\u0005\u0003BAF\u0003#k!!!$\u000b\u0005\u0005=\u0015A\u00036paR\u001c\u0018.\u001c9mK&!\u00111SAG\u0005=y\u0005\u000f^5p]\u0016C8-\u001a9uS>t\u0017a\u00049s_\u0012,8-Z'fgN\fw-Z:\u0015\r\u0005E\u0011\u0011TAO\u0011\u0019\tY*\na\u0001U\u0006)Ao\u001c9jG\"9\u0011qT\u0013A\u0002\u0005\u0005\u0016a\u00038v[6+7o]1hKN\u00042aZAR\u0013\r\t)K\u0017\u0002\u0004\u0013:$\u0018!\u00079s_\u0012,8-Z\"p]N,X.Z!oINCW\u000f\u001e3po:$\"\"!\u0005\u0002,\u00065\u0016qVAZ\u0011\u0019\tYJ\na\u0001U\"1\u00111\u0001\u0014A\u0002)Dq!!-'\u0001\u0004\t\t+A\u0007u_R\fG.T3tg\u0006<Wm\u001d\u0005\n\u0003k3\u0003\u0013!a\u0001\u0003C\u000bAB\\;n\u0007>t7/^7feN\f1\u0005\u001d:pIV\u001cWmQ8ogVlW-\u00118e'\",H\u000fZ8x]\u0012\"WMZ1vYR$C'\u0006\u0002\u0002<*\"\u0011\u0011UA_W\t\ty\f\u0005\u0003\u0002B\u0006-WBAAb\u0015\u0011\t)-a2\u0002\u0013Ut7\r[3dW\u0016$'bAAe5\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00171\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!F1xC&$8i\u001c8tk6,'\u000f\u0015:pOJ,7o\u001d\u000b\t\u0003#\t\u0019.!6\u0002X\"A\u00111\u0014\u0015\u0011\u0002\u0003\u0007!\u000e\u0003\u0005\u0002\u0004!\u0002\n\u00111\u0001k\u0011\u001d\tI\u000e\u000ba\u0001\u00037\fQaY8v]R\u00042aZAo\u0013\r\tyN\u0017\u0002\u0005\u0019>tw-A\u0010bo\u0006LGoQ8ogVlWM\u001d)s_\u001e\u0014Xm]:%I\u00164\u0017-\u001e7uIE*\"!!:+\u0007)\fi,A\u0010bo\u0006LGoQ8ogVlWM\u001d)s_\u001e\u0014Xm]:%I\u00164\u0017-\u001e7uII\nQC]3tKR\fe\u000eZ!tg\u0016\u0014Ho\u00144gg\u0016$8\u000f\u0006\u0006\u0002\u0012\u00055\u0018q^Az\u0003{DQA_\u0016A\u0002\u0019Dq!!=,\u0001\u0004\tY.\u0001\bfqB,7\r^3e\u001f\u001a47/\u001a;\t\u0013\u0005U8\u0006%AA\u0002\u0005]\u0018A\u00023ssJ+h\u000eE\u0002h\u0003sL1!a?[\u0005\u001d\u0011un\u001c7fC:D\u0001\"a@,!\u0003\u0005\r\u0001_\u0001\u0007i>\u0004\u0018nY:\u0002?I,7/\u001a;B]\u0012\f5o]3si>3gm]3ug\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0006)\"\u0011q_A_\u0003}\u0011Xm]3u\u0003:$\u0017i]:feR|eMZ:fiN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005\u0017Q3\u0001_A_\u0003y\u0011Xm]3u\u0003:$\u0017i]:feR|eMZ:fiN\u001cu.\\7jiR,G\r\u0006\u0005\u0002\u0012\tE!1\u0006B$\u0011\u001d\u0011\u0019B\fa\u0001\u0005+\tAcY8ogVlWM]$s_V\u00048+\u001a:wS\u000e,\u0007\u0003\u0002B\f\u0005KqAA!\u0007\u0003\"9!!1\u0004B\u0010\u001d\ri'QD\u0005\u0002i%\u0011!gM\u0005\u0004\u0005G\t\u0014\u0001F\"p]N,X.\u001a:He>,\boQ8n[\u0006tG-\u0003\u0003\u0003(\t%\"\u0001F\"p]N,X.\u001a:He>,\boU3sm&\u001cWMC\u0002\u0003$EBqA!\f/\u0001\u0004\u0011y#A\bfqB,7\r^3e\u001f\u001a47/\u001a;t!\u001dY'\u0011\u0007B\u001b\u00037L1Aa\rt\u0005\ri\u0015\r\u001d\t\u0005\u0005o\u0011\u0019%\u0004\u0002\u0003:)!!1\bB\u001f\u0003\u0019\u0019w.\\7p]*\u0019AGa\u0010\u000b\t\t\u0005\u0013\u0011E\u0001\u0007CB\f7\r[3\n\t\t\u0015#\u0011\b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\tYJ\fa\u0001U\u0006a!/Z:fi>3gm]3ugR!!Q\nB2!\u00199&q\n6\u0003R%\u0019!1\u0007-\u0011\u000f]\u0013yE!\u000e\u0003TA!!Q\u000bB0\u001b\t\u00119F\u0003\u0003\u0003Z\tm\u0013\u0001C2p]N,X.\u001a:\u000b\t\tu#QH\u0001\bG2LWM\u001c;t\u0013\u0011\u0011\tGa\u0016\u0003#=3gm]3u\u0003:$W*\u001a;bI\u0006$\u0018\rC\u0004\u0003\u0014=\u0002\rA!\u0006")
public class ResetConsumerGroupOffsetTest
extends ConsumerGroupCommandTest {
    private final Properties overridingProps = new Properties();
    private final String topic1;
    private final String topic2;

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    private String[] basicArgs() {
        return (String[])((Object[])new String[]{"--reset-offsets", "--bootstrap-server", this.brokerList(), "--timeout", ((Object)BoxesRunTime.boxToLong((long)15000L)).toString()});
    }

    private String[] buildArgsForGroups(Seq<String> groups, Seq<String> args) {
        String[] groupArgs = (String[])((TraversableOnce)groups.flatMap((Function1 & Serializable & scala.Serializable)group -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--group", group})), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.basicArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])groupArgs)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus(args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    private String[] buildArgsForGroup(String group, Seq<String> args) {
        return this.buildArgsForGroups((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{group}))), args);
    }

    private String[] buildArgsForAllGroups(Seq<String> args) {
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.basicArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--all-groups"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus(args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    @Test
    public void testResetOffsetsNotExistingGroup() {
        String group = "missing.group";
        String[] args = this.buildArgsForGroup(group, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-current", "--execute"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = consumerGroupCommand.collectGroupState(group).coordinator().host();
            String string2 = "localhost";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Can't find a coordinator", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Map resetOffsets = (Map)consumerGroupCommand.resetOffsets().apply((Object)group);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)resetOffsets);
        String x$1 = group;
        String x$2 = this.committedOffsets$default$1();
        Assert.assertEquals((Object)resetOffsets, this.committedOffsets(x$2, x$1));
    }

    @Test
    public void testResetOffsetsExistingTopic() {
        String group = "new.group";
        String[] args = this.buildArgsForGroup(group, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", this.topic(), "--to-offset", "50"}));
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsExistingTopicSelectedGroups() {
        this.produceMessages(this.topic(), 100);
        IndexedSeq groups = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)id -> ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsExistingTopicSelectedGroups$1(this, BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        String[] args = this.buildArgsForGroups((Seq<String>)groups, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", this.topic(), "--to-offset", "50"}));
        this.resetAndAssertOffsets(args, 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsExistingTopicAllGroups() {
        String[] args = this.buildArgsForAllGroups((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", this.topic(), "--to-offset", "50"}));
        this.produceMessages(this.topic(), 100);
        ((IterableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)x$2 -> ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsExistingTopicAllGroups$1(this, BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)group -> {
            ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsExistingTopicAllGroups$2(this, group);
            return BoxedUnit.UNIT;
        });
        this.resetAndAssertOffsets(args, 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsAllTopicsAllGroups() {
        String[] args = this.buildArgsForAllGroups((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-offset", "50"}));
        IndexedSeq topics = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)x$3 -> ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsAllTopicsAllGroups$1(this, BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq groups = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)x$4 -> ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsAllTopicsAllGroups$2(this, BoxesRunTime.unboxToInt((Object)x$4)), IndexedSeq$.MODULE$.canBuildFrom());
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            this.produceMessages(topic, 100);
            return BoxedUnit.UNIT;
        });
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            groups.foreach((Function1 & Serializable & scala.Serializable)group -> {
                ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsAllTopicsAllGroups$5($this, topic, group);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.resetAndAssertOffsets(args, 50L, true, (Seq<String>)topics);
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, true, (Seq<String>)topics);
        String[] x$42 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        long x$5 = 50L;
        IndexedSeq x$6 = topics;
        boolean x$7 = this.resetAndAssertOffsets$default$3();
        this.resetAndAssertOffsets(x$42, x$5, x$7, (Seq<String>)x$6);
    }

    @Test
    public void testResetOffsetsToLocalDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        this.produceMessages(this.topic(), 100);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        long x$1 = 100L;
        String x$2 = this.awaitConsumerProgress$default$1();
        String x$3 = this.awaitConsumerProgress$default$2();
        this.awaitConsumerProgress(x$2, x$3, x$1);
        executor.shutdown();
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-datetime", format.format(calendar.getTime()), "--execute"}));
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToZonedDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        this.produceMessages(this.topic(), 50);
        Date checkpoint = new Date();
        this.produceMessages(this.topic(), 50);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        long x$1 = 100L;
        String x$2 = this.awaitConsumerProgress$default$1();
        String x$3 = this.awaitConsumerProgress$default$2();
        this.awaitConsumerProgress(x$2, x$3, x$1);
        executor.shutdown();
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-datetime", format.format(checkpoint), "--execute"}));
        this.resetAndAssertOffsets(args, 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDuration() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--by-duration", "PT1M", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDurationToEarliest() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--by-duration", "PT0.1S", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 100L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliest() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-earliest", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToLatest() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-latest", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 200L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToCurrentOffset() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-current", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 100L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToSpecificOffset() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-offset", "1", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 1L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftPlus() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--shift-by", "50", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 150L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftMinus() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--shift-by", "-50", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftByLowerThanEarliest() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--shift-by", "-150", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftByHigherThanLatest() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--shift-by", "150", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 200L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopic() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", this.topic(), "--to-earliest", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopicAndPartition() {
        String topic = "bar";
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", new StringBuilder(2).append(topic).append(":1").toString(), "--to-earliest", "--execute"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic, this.group(), 100, 2);
        scala.collection.immutable.Map<TopicPartition, Object> priorCommittedOffsets = this.committedOffsets(topic, this.committedOffsets$default$2());
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        scala.collection.immutable.Map expectedOffsets = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), priorCommittedOffsets.apply((Object)tp0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))}));
        this.resetAndAssertOffsetsCommitted(consumerGroupCommand, (scala.collection.immutable.Map<TopicPartition, Object>)expectedOffsets, topic);
        this.adminZkClient().deleteTopic(topic);
    }

    @Test
    public void testResetOffsetsToEarliestOnTopics() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", topic1, "--topic", topic2, "--to-earliest", "--execute"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic1, this.group(), 100, 1);
        this.produceConsumeAndShutdown(topic2, this.group(), 100, 1);
        TopicPartition tp1 = new TopicPartition(topic1, 0);
        TopicPartition tp2 = new TopicPartition(topic2, 0);
        scala.collection.immutable.Map allResetOffsets = ((MapLike)this.resetOffsets(consumerGroupCommand).apply((Object)this.group())).mapValues((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.offset())).toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))})), (Object)allResetOffsets);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))})), this.committedOffsets(topic1, this.committedOffsets$default$2()));
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))})), this.committedOffsets(topic2, this.committedOffsets$default$2()));
        this.adminZkClient().deleteTopic(topic1);
        this.adminZkClient().deleteTopic(topic2);
    }

    @Test
    public void testResetOffsetsToEarliestOnTopicsAndPartitions() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 2, 1, this.createTopic$default$4());
        this.createTopic(topic2, 2, 1, this.createTopic$default$4());
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", new StringBuilder(2).append(topic1).append(":1").toString(), "--topic", new StringBuilder(2).append(topic2).append(":1").toString(), "--to-earliest", "--execute"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic1, this.group(), 100, 2);
        this.produceConsumeAndShutdown(topic2, this.group(), 100, 2);
        scala.collection.immutable.Map<TopicPartition, Object> priorCommittedOffsets1 = this.committedOffsets(topic1, this.committedOffsets$default$2());
        scala.collection.immutable.Map<TopicPartition, Object> priorCommittedOffsets2 = this.committedOffsets(topic2, this.committedOffsets$default$2());
        TopicPartition tp1 = new TopicPartition(topic1, 1);
        TopicPartition tp2 = new TopicPartition(topic2, 1);
        scala.collection.immutable.Map allResetOffsets = ((MapLike)this.resetOffsets(consumerGroupCommand).apply((Object)this.group())).mapValues((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.offset())).toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToInteger((int)0))})), (Object)allResetOffsets);
        Assert.assertEquals((Object)priorCommittedOffsets1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))), this.committedOffsets(topic1, this.committedOffsets$default$2()));
        Assert.assertEquals((Object)priorCommittedOffsets2.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))), this.committedOffsets(topic2, this.committedOffsets$default$2()));
        this.adminZkClient().deleteTopic(topic1);
        this.adminZkClient().deleteTopic(topic2);
    }

    @Test
    public void testResetOffsetsExportImportPlanSingleGroupArg() {
        String topic = "bar";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        String[] cgcArgs = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-offset", "2", "--export"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        this.produceConsumeAndShutdown(topic, this.group(), 100, 2);
        File file = File.createTempFile("reset", ".csv");
        file.deleteOnExit();
        Map exportedOffsets = consumerGroupCommand.resetOffsets();
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(consumerGroupCommand.exportOffsetsToCsv(exportedOffsets));
        bw.close();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)exportedOffsets.apply((Object)this.group())).mapValues((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.offset())).toMap(Predef$.MODULE$.$conforms()));
        String[] cgcArgsExec = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommandExec = this.getConsumerGroupService(cgcArgsExec);
        Map importedOffsets = consumerGroupCommandExec.resetOffsets();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)importedOffsets.apply((Object)this.group())).mapValues((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.offset())).toMap(Predef$.MODULE$.$conforms()));
        this.adminZkClient().deleteTopic(topic);
    }

    @Test
    public void testResetOffsetsExportImportPlan() {
        String group1 = new StringBuilder(1).append(this.group()).append("1").toString();
        String group2 = new StringBuilder(1).append(this.group()).append("2").toString();
        String topic1 = "bar1";
        String topic2 = "bar2";
        TopicPartition t1p0 = new TopicPartition(topic1, 0);
        TopicPartition t1p1 = new TopicPartition(topic1, 1);
        TopicPartition t2p0 = new TopicPartition(topic2, 0);
        TopicPartition t2p1 = new TopicPartition(topic2, 1);
        this.createTopic(topic1, 2, 1, this.createTopic$default$4());
        this.createTopic(topic2, 2, 1, this.createTopic$default$4());
        String[] cgcArgs = this.buildArgsForGroups((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{group1, group2}))), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-offset", "2", "--export"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        this.produceConsumeAndShutdown(topic1, group1, 100, 2);
        this.produceConsumeAndShutdown(topic2, group2, 100, 5);
        File file = File.createTempFile("reset", ".csv");
        file.deleteOnExit();
        Map exportedOffsets = consumerGroupCommand.resetOffsets();
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(consumerGroupCommand.exportOffsetsToCsv(exportedOffsets));
        bw.close();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)exportedOffsets.apply((Object)group1)).mapValues((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.offset())).toMap(Predef$.MODULE$.$conforms()));
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)exportedOffsets.apply((Object)group2)).mapValues((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.offset())).toMap(Predef$.MODULE$.$conforms()));
        String[] cgcArgsExec = this.buildArgsForGroups((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{group1, group2}))), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommandExec = this.getConsumerGroupService(cgcArgsExec);
        Map importedOffsets = consumerGroupCommandExec.resetOffsets();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)importedOffsets.apply((Object)group1)).mapValues((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.offset())).toMap(Predef$.MODULE$.$conforms()));
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)importedOffsets.apply((Object)group2)).mapValues((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.offset())).toMap(Predef$.MODULE$.$conforms()));
        String[] cgcArgsExec2 = this.buildArgsForGroup(group1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommandExec2 = this.getConsumerGroupService(cgcArgsExec2);
        Map importedOffsets2 = consumerGroupCommandExec2.resetOffsets();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)importedOffsets2.apply((Object)group1)).mapValues((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.offset())).toMap(Predef$.MODULE$.$conforms()));
        this.adminZkClient().deleteTopic(this.topic());
    }

    @Test(expected=OptionException.class)
    public void testResetWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--new-consumer", "--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "2", "--export"});
        this.getConsumerGroupService(cgcArgs);
    }

    private void produceMessages(String topic, int numMessages) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1 & Serializable & scala.Serializable)x$14 -> ResetConsumerGroupOffsetTest.$anonfun$produceMessages$1(topic, BoxesRunTime.unboxToInt((Object)x$14)), IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), (Seq<ProducerRecord<byte[], byte[]>>)records, 1);
    }

    private void produceConsumeAndShutdown(String topic, String group, int totalMessages, int numConsumers) {
        this.produceMessages(topic, totalMessages);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(numConsumers, topic, group, this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        this.awaitConsumerProgress(topic, group, totalMessages);
        executor.shutdown();
    }

    private int produceConsumeAndShutdown$default$4() {
        return 1;
    }

    private void awaitConsumerProgress(String topic, String group, long count) {
        try (KafkaConsumer<String, String> consumer = this.createNoAutoCommitConsumer(group);){
            scala.collection.immutable.Set partitions = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(consumer.partitionsFor(topic)).asScala()).map((Function1 & Serializable & scala.Serializable)partitionInfo -> new TopicPartition(partitionInfo.topic(), partitionInfo.partition()), Buffer$.MODULE$.canBuildFrom())).toSet();
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                Iterable committed = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(consumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)partitions).asJava()).values()).asScala();
                long total = BoxesRunTime.unboxToLong((Object)committed.foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToLong((long)ResetConsumerGroupOffsetTest.$anonfun$awaitConsumerProgress$3(BoxesRunTime.unboxToLong((Object)x0$1), x1$1))));
                return total == count;
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append("Expected that consumer group has consumed all messages from topic/partition. ").append("Expected offset: ").append(count).append(". Actual offset: ").append(this.committedOffsets(topic, group).values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        }
    }

    private String awaitConsumerProgress$default$1() {
        return this.topic();
    }

    private String awaitConsumerProgress$default$2() {
        return this.group();
    }

    private void resetAndAssertOffsets(String[] args, long expectedOffset, boolean dryRun, Seq<String> topics) {
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        scala.collection.immutable.Map expectedOffsets = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, 0)), (Object)BoxesRunTime.boxToLong((long)expectedOffset))}))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map<String, Map<TopicPartition, OffsetAndMetadata>> resetOffsetsResultByGroup = this.resetOffsets(consumerGroupCommand);
        try {
            topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
                ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsets$2(this, resetOffsetsResultByGroup, expectedOffsets, dryRun, topic);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            consumerGroupCommand.close();
        }
    }

    private boolean resetAndAssertOffsets$default$3() {
        return false;
    }

    private Seq<String> resetAndAssertOffsets$default$4() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}));
    }

    private void resetAndAssertOffsetsCommitted(ConsumerGroupCommand.ConsumerGroupService consumerGroupService, scala.collection.immutable.Map<TopicPartition, Object> expectedOffsets, String topic) {
        Map<String, Map<TopicPartition, OffsetAndMetadata>> allResetOffsets = this.resetOffsets(consumerGroupService);
        allResetOffsets.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsetsCommitted$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
            ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsetsCommitted$2(this, expectedOffsets, topic, x$19);
            return BoxedUnit.UNIT;
        });
    }

    private Map<String, Map<TopicPartition, OffsetAndMetadata>> resetOffsets(ConsumerGroupCommand.ConsumerGroupService consumerGroupService) {
        return consumerGroupService.resetOffsets();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ String $anonfun$testResetOffsetsExistingTopicSelectedGroups$1(ResetConsumerGroupOffsetTest $this, int id) {
        void var2_2;
        String group = new StringBuilder(0).append($this.group()).append(id).toString();
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(1, $this.topic(), group, $this.addConsumerGroupExecutor$default$4(), $this.addConsumerGroupExecutor$default$5(), $this.addConsumerGroupExecutor$default$6());
        long x$1 = 100L;
        String x$2 = group;
        String x$3 = $this.awaitConsumerProgress$default$1();
        $this.awaitConsumerProgress(x$3, x$2, x$1);
        executor.shutdown();
        return var2_2;
    }

    public static final /* synthetic */ String $anonfun$testResetOffsetsExistingTopicAllGroups$1(ResetConsumerGroupOffsetTest $this, int x$2) {
        return new StringBuilder(0).append($this.group()).append(x$2).toString();
    }

    public static final /* synthetic */ void $anonfun$testResetOffsetsExistingTopicAllGroups$2(ResetConsumerGroupOffsetTest $this, String group) {
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(1, $this.topic(), group, $this.addConsumerGroupExecutor$default$4(), $this.addConsumerGroupExecutor$default$5(), $this.addConsumerGroupExecutor$default$6());
        long x$1 = 100L;
        String x$2 = group;
        String x$3 = $this.awaitConsumerProgress$default$1();
        $this.awaitConsumerProgress(x$3, x$2, x$1);
        executor.shutdown();
    }

    public static final /* synthetic */ String $anonfun$testResetOffsetsAllTopicsAllGroups$1(ResetConsumerGroupOffsetTest $this, int x$3) {
        return new StringBuilder(0).append($this.topic()).append(x$3).toString();
    }

    public static final /* synthetic */ String $anonfun$testResetOffsetsAllTopicsAllGroups$2(ResetConsumerGroupOffsetTest $this, int x$4) {
        return new StringBuilder(0).append($this.group()).append(x$4).toString();
    }

    public static final /* synthetic */ void $anonfun$testResetOffsetsAllTopicsAllGroups$5(ResetConsumerGroupOffsetTest $this, String topic$1, String group) {
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(3, topic$1, group, $this.addConsumerGroupExecutor$default$4(), $this.addConsumerGroupExecutor$default$5(), $this.addConsumerGroupExecutor$default$6());
        String x$1 = topic$1;
        long x$2 = 100L;
        String x$3 = group;
        $this.awaitConsumerProgress(x$1, x$3, x$2);
        executor.shutdown();
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceMessages$1(String topic$2, int x$14) {
        return new ProducerRecord(topic$2, (Object)new byte[100000]);
    }

    public static final /* synthetic */ long $anonfun$awaitConsumerProgress$3(long x0$1, OffsetAndMetadata x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long currentSum = tuple2._1$mcJ$sp();
        OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)tuple2._2();
        long l = currentSum + BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)offsetAndMetadata).map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)x$15.offset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        return l;
    }

    public static final /* synthetic */ boolean $anonfun$resetAndAssertOffsets$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$resetAndAssertOffsets$5(String topic$4, Tuple2 partitionInfo) {
        String string = ((TopicPartition)partitionInfo._1()).topic();
        String string2 = topic$4;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsets$4(ResetConsumerGroupOffsetTest $this, String topic$4, scala.collection.immutable.Map expectedOffsets$1, boolean dryRun$1, Tuple2 x$17) {
        Tuple2 tuple2 = x$17;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String group = (String)tuple2._1();
        Map partitionInfo2 = (Map)tuple2._2();
        scala.collection.immutable.Map<TopicPartition, Object> priorOffsets = $this.committedOffsets(topic$4, group);
        Assert.assertEquals((Object)expectedOffsets$1.apply((Object)topic$4), (Object)((MapLike)partitionInfo2.filter((Function1 & Serializable & scala.Serializable)partitionInfo -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsets$5(topic$4, partitionInfo)))).mapValues((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.offset())).toMap(Predef$.MODULE$.$conforms()));
        Assert.assertEquals(dryRun$1 ? priorOffsets : expectedOffsets$1.apply((Object)topic$4), $this.committedOffsets(topic$4, group));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsets$2(ResetConsumerGroupOffsetTest $this, Map resetOffsetsResultByGroup$1, scala.collection.immutable.Map expectedOffsets$1, boolean dryRun$1, String topic) {
        resetOffsetsResultByGroup$1.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsets$3(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsets$4($this, topic, expectedOffsets$1, dryRun$1, x$17);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$resetAndAssertOffsetsCommitted$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$resetAndAssertOffsetsCommitted$3(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsetsCommitted$4(ResetConsumerGroupOffsetTest $this, scala.collection.immutable.Map expectedOffsets$2, String topic$5, String group$3, Tuple2 x$18) {
        Tuple2 tuple2 = x$18;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        OffsetAndMetadata offsetMetadata = (OffsetAndMetadata)tuple2._2();
        Assert.assertEquals((long)offsetMetadata.offset(), (long)BoxesRunTime.unboxToLong((Object)expectedOffsets$2.apply((Object)tp)));
        Assert.assertEquals((Object)expectedOffsets$2, $this.committedOffsets(topic$5, group$3));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsetsCommitted$2(ResetConsumerGroupOffsetTest $this, scala.collection.immutable.Map expectedOffsets$2, String topic$5, Tuple2 x$19) {
        Tuple2 tuple2 = x$19;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String group = (String)tuple2._1();
        Map offsetsInfo = (Map)tuple2._2();
        offsetsInfo.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsetsCommitted$3(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
            ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsetsCommitted$4($this, expectedOffsets$2, topic$5, group, x$18);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ResetConsumerGroupOffsetTest() {
        this.topic1 = "foo1";
        this.topic2 = "foo2";
    }
}

