/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_9_0$;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerParameterizedIntegrationTest$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001\u0002\r\u001a\u0001yA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\u0006c\u0001!\tA\r\u0005\bk\u0001\u0011\r\u0011\"\u00017\u0011\u0019!\u0005\u0001)A\u0005o!9Q\t\u0001b\u0001\n\u00031\u0005BB'\u0001A\u0003%q\tC\u0004O\u0001\t\u0007I\u0011A(\t\ra\u0003\u0001\u0015!\u0003Q\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015)\u0007\u0001\"\u0001[\u0011\u00159\u0007\u0001\"\u0001[\u0011\u0015I\u0007\u0001\"\u0001[\u0011\u0015Y\u0007\u0001\"\u0001[\u0011\u0015i\u0007\u0001\"\u0003o\u0011\u0015Y\b\u0001\"\u0003}\u0011\u001d\ti\u0002\u0001C\u0005\u0003?Aq!a\u000e\u0001\t\u0013\tI\u0004C\u0004\u0002>\u0001!I!a\u0010\t\u0013\u0005m\u0003!%A\u0005\n\u0005usaBAI3!\u0005\u00111\u0013\u0004\u00071eA\t!!&\t\rE*B\u0011AAO\u0011\u001d\ty*\u0006C\u0001\u0003C\u0013a\u0005T8h\u00072,\u0017M\\3s!\u0006\u0014\u0018-\\3uKJL'0\u001a3J]R,wM]1uS>tG+Z:u\u0015\tQ2$A\u0002m_\u001eT\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0004\u0005\u0002!C5\t\u0011$\u0003\u0002#3\t\t\u0013IY:ue\u0006\u001cG\u000fT8h\u00072,\u0017M\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti\u0006\u00012m\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\t\u0003K9r!A\n\u0017\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%j\u0012A\u0002\u001fs_>$hHC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#&\u0001\u0004Qe\u0016$WMZ\u0005\u0003_A\u0012aa\u0015;sS:<'BA\u0017+\u0003\u0019a\u0014N\\5u}Q\u00111\u0007\u000e\t\u0003A\u0001AQa\t\u0002A\u0002\u0011\nQaY8eK\u000e,\u0012a\u000e\t\u0003q\tk\u0011!\u000f\u0006\u0003um\naA]3d_J$'B\u0001\u001f>\u0003\u0019\u0019w.\\7p]*\u0011AD\u0010\u0006\u0003\u007f\u0001\u000ba!\u00199bG\",'\"A!\u0002\u0007=\u0014x-\u0003\u0002Ds\ty1i\\7qe\u0016\u001c8/[8o)f\u0004X-\u0001\u0004d_\u0012,7\rI\u0001\u0005i&lW-F\u0001H!\tA5*D\u0001J\u0015\tQ5$A\u0003vi&d7/\u0003\u0002M\u0013\nAQj\\2l)&lW-A\u0003uS6,\u0007%A\bu_BL7\rU1si&$\u0018n\u001c8t+\u0005\u0001\u0006cA)S)6\t!&\u0003\u0002TU\t)\u0011I\u001d:bsB\u0011QKV\u0007\u0002w%\u0011qk\u000f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b%A\u0006dY\u0016\fg.\u001a:UKN$H#A.\u0011\u0005Ec\u0016BA/+\u0005\u0011)f.\u001b;)\u0005%y\u0006C\u00011d\u001b\u0005\t'B\u00012A\u0003\u0015QWO\\5u\u0013\t!\u0017M\u0001\u0003UKN$\u0018a\n;fgR\u001cE.Z1og\u000e{WNY5oK\u0012\u001cu.\u001c9bGR\fe\u000e\u001a#fY\u0016$X\rV8qS\u000eD#AC0\u0002=Q,7\u000f^\"mK\u0006tWM],ji\"lUm]:bO\u00164uN]7biZ\u0003\u0004FA\u0006`\u00039\"Xm\u001d;DY\u0016\fg.\u001b8h\u001d\u0016\u001cH/\u001a3NKN\u001c\u0018mZ3t/&$\b.T;mi&\u0004H.\u001a,feNLwN\\:)\u00051y\u0016aF2mK\u0006tWM]\"p]\u001aLw-\u00169eCR,G+Z:uQ\tiq,\u0001\tdQ\u0016\u001c7\u000eT1ti\u000ecW-\u00198fIR!1l\\9w\u0011\u0015\u0001h\u00021\u0001%\u0003\u0015!x\u000e]5d\u0011\u0015\u0011h\u00021\u0001t\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0011\u0005E#\u0018BA;+\u0005\rIe\u000e\u001e\u0005\u0006o:\u0001\r\u0001_\u0001\u000bM&\u00148\u000f\u001e#jeRL\bCA)z\u0013\tQ(F\u0001\u0003M_:<\u0017AG2iK\u000e\\Gj\\4BMR,'/\u00119qK:$\u0017N\\4EkB\u001cHCB.~\u0003\u0007\t9\u0001C\u0003\u001b\u001f\u0001\u0007a\u0010\u0005\u0002!\u007f&\u0019\u0011\u0011A\r\u0003\u00071{w\r\u0003\u0004\u0002\u0006=\u0001\r\u0001_\u0001\ngR\f'\u000f^*ju\u0016Dq!!\u0003\u0010\u0001\u0004\tY!A\u0004baB,g\u000eZ:\u0011\r\u00055\u00111CA\f\u001b\t\tyAC\u0002\u0002\u0012)\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)\"a\u0004\u0003\u0007M+\u0017\u000f\u0005\u0004R\u00033\u0019H\u0005_\u0005\u0004\u00037Q#A\u0002+va2,7'A\u0003u_6\u000b\u0007\u000f\u0006\u0003\u0002\"\u00055\u0002cBA\u0007\u0003G\u0019\u0018qE\u0005\u0005\u0003K\tyAA\u0002NCB\u0004R!UA\u0015IaL1!a\u000b+\u0005\u0019!V\u000f\u001d7fe!9\u0011q\u0006\tA\u0002\u0005E\u0012\u0001C7fgN\fw-Z:\u0011\r\u00055\u00111GA\f\u0013\u0011\t)$a\u0004\u0003\u0011%#XM]1cY\u0016\f1B]3bI\u001a\u0013x.\u001c'pOR!\u0011\u0011GA\u001e\u0011\u0015Q\u0012\u00031\u0001\u007f\u0003e9(/\u001b;f\tV\u00048oU5oO2,W*Z:tC\u001e,7+\u001a;\u0015\u001d\u0005-\u0011\u0011IA#\u0003\u0013\nY%!\u0014\u0002R!1\u00111\t\nA\u0002M\fqA\\;n\u0017\u0016L8\u000f\u0003\u0004\u0002HI\u0001\ra]\u0001\b]VlG)\u001e9t\u0011\u0015Q\"\u00031\u0001\u007f\u0011\u0015)$\u00031\u00018\u0011!\tyE\u0005I\u0001\u0002\u0004\u0019\u0018\u0001C:uCJ$8*Z=\t\u000f\u0005M#\u00031\u0001\u0002V\u0005QQ.Y4jGZ\u000bG.^3\u0011\u0007E\u000b9&C\u0002\u0002Z)\u0012AAQ=uK\u0006\u0019sO]5uK\u0012+\bo]*j]\u001edW-T3tg\u0006<WmU3uI\u0011,g-Y;mi\u0012*TCAA0U\r\u0019\u0018\u0011M\u0016\u0003\u0003G\u0002B!!\u001a\u0002p5\u0011\u0011q\r\u0006\u0005\u0003S\nY'A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u000e\u0016\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002r\u0005\u001d$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\":\u0001!!\u001e\u0002\u0002\u0006\r\u0005\u0003BA<\u0003{j!!!\u001f\u000b\u0007\u0005m\u0014-\u0001\u0004sk:tWM]\u0005\u0005\u0003\u007f\nIHA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0005\u0005\u0015\u0005\u0003BAD\u0003\u001bk!!!#\u000b\u0007\u0005-\u0015-A\u0004sk:tWM]:\n\t\u0005=\u0015\u0011\u0012\u0002\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\u0002M1{wm\u00117fC:,'\u000fU1sC6,G/\u001a:ju\u0016$\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000f\u0005\u0002!+M\u0019Q#a&\u0011\u0007E\u000bI*C\u0002\u0002\u001c*\u0012a!\u00118z%\u00164GCAAJ\u0003)\u0001\u0018M]1nKR,'o]\u000b\u0003\u0003G\u0003b!!*\u00020\u0006MVBAAT\u0015\u0011\tI+a+\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003[\u000bAA[1wC&!\u0011\u0011WAT\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0004#J#\u0003fA\f\u00028B!\u0011\u0011XAf\u001d\u0011\tY,a2\u000f\t\u0005u\u0016Q\u0019\b\u0005\u0003\u007f\u000b\u0019MD\u0002(\u0003\u0003L\u0011!Q\u0005\u0003E\u0002K1!a#b\u0013\u0011\tI-!#\u0002\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0013\u0011\ti-a4\u0003\u0015A\u000b'/Y7fi\u0016\u00148O\u0003\u0003\u0002J\u0006%\u0005")
public class LogCleanerParameterizedIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final CompressionType codec;
    private final MockTime time;
    private final TopicPartition[] topicPartitions;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return LogCleanerParameterizedIntegrationTest$.MODULE$.parameters();
    }

    @Override
    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @Test
    public void cleanerTest() {
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
        Tuple2 tuple23 = tuple22;
        String largeMessageValue2 = (String)tuple23._1();
        MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
        int maxMessageSize = largeMessageSet2.sizeInBytes();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$22 = maxMessageSize;
        float x$3 = this.makeCleaner$default$2();
        int x$4 = this.makeCleaner$default$3();
        long x$5 = this.makeCleaner$default$4();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$3, x$4, x$5, x$22, x$6, x$7, x$8, x$9, x$10, x$11));
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> appends = this.writeDups(100, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString(), (startSize > (long)compactedSize ? 1 : 0) != 0);
        this.checkLogAfterAppendingDups(log, startSize, appends);
        LogAppendInfo appendInfo = log.appendAsLeader(largeMessageSet2, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        long largeMessageOffset = BoxesRunTime.unboxToLong((Object)appendInfo.firstOffset().get());
        int x$12 = largeMessageKey + 1;
        int x$13 = 100;
        int x$14 = 3;
        Log x$15 = log;
        CompressionType x$16 = this.codec();
        byte x$17 = this.writeDups$default$6();
        Seq<Tuple3<Object, String, Object>> dups = this.writeDups(x$13, x$14, x$15, x$16, x$12, x$17);
        Seq appends2 = (Seq)((TraversableLike)appends.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset))})), Seq$.MODULE$.canBuildFrom())).$plus$plus(dups, Seq$.MODULE$.canBuildFrom());
        long firstDirty2 = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty2);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
        this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
        this.cleaner().updateCheckpoints(this.logDir());
        Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), this.cleaner().cleanerManager().offsetCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        Assert.assertFalse((boolean)checkpoints.contains((Object)this.topicPartitions()[0]));
    }

    @Test
    public void testCleansCombinedCompactAndDeleteTopic() {
        Log log;
        Properties logProps = new Properties();
        Integer retentionMs = Predef$.MODULE$.int2Integer(100000);
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), retentionMs);
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact,delete");
        Tuple2 tuple2 = this.runCleanerAndCheckCompacted$1(100, logProps);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Log log2 = log = (Log)tuple2._1();
        Log log3 = log2;
        long endOffset = log3.logEndOffset();
        log3.logSegments().foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.lastModified_$eq(this.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(retentionMs))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> log3.logStartOffset() == endOffset, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Timed out waiting for deletion of old segments", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertEquals((long)1L, (long)log3.numberOfSegments());
        this.cleaner().shutdown();
        Tuple2 tuple22 = this.runCleanerAndCheckCompacted$1(20, logProps);
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Log log22 = (Log)tuple22._1();
        Seq messages = (Seq)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)log22, (Object)messages);
        Tuple2 tuple24 = tuple23;
        Log log23 = (Log)tuple24._1();
        Seq messages2 = (Seq)tuple24._2();
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log23);
        Assert.assertEquals((String)"Contents of the map shouldn't change", this.toMap((Iterable<Tuple3<Object, String, Object>>)messages2), this.toMap(read));
    }

    @Test
    public void testCleanerWithMessageFormatV0() {
        CompressionType compressionType = this.codec();
        CompressionType compressionType2 = CompressionType.ZSTD;
        if (!(compressionType != null ? !compressionType.equals(compressionType2) : compressionType2 != null)) {
            return;
        }
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)0);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
        Tuple2 tuple23 = tuple22;
        String largeMessageValue2 = (String)tuple23._1();
        MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
        CompressionType compressionType3 = this.codec();
        int n = CompressionType.NONE.equals(compressionType3) ? largeMessageSet2.sizeInBytes() : largeMessageSet2.sizeInBytes() + 5;
        int maxMessageSize = n;
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$2 = maxMessageSize;
        float x$3 = this.makeCleaner$default$2();
        int x$4 = this.makeCleaner$default$3();
        long x$5 = this.makeCleaner$default$4();
        long x$6 = this.makeCleaner$default$6();
        int x$72 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$3, x$4, x$5, x$2, x$6, x$72, x$8, x$9, x$10, x$11));
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        int x$12 = maxMessageSize;
        Properties x$13 = this.logConfigProperties$default$1();
        float x$14 = this.logConfigProperties$default$3();
        long x$15 = this.logConfigProperties$default$4();
        int x$16 = this.logConfigProperties$default$5();
        int x$17 = this.logConfigProperties$default$6();
        long x$18 = this.logConfigProperties$default$7();
        Properties props = this.logConfigProperties(x$13, x$12, x$14, x$15, x$16, x$17, x$18);
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
        log.config_$eq(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$19 = 100;
        int x$20 = 3;
        Log x$21 = log;
        CompressionType x$22 = this.codec();
        byte x$23 = 0;
        int x$24 = this.writeDups$default$5();
        Seq<Tuple3<Object, String, Object>> appends = this.writeDups(x$19, x$20, x$21, x$22, x$24, x$23);
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString(), (startSize > (long)compactedSize ? 1 : 0) != 0);
        this.checkLogAfterAppendingDups(log, startSize, appends);
        int x$25 = 40;
        int x$26 = 3;
        Log x$27 = log;
        CompressionType x$28 = this.codec();
        byte x$29 = 0;
        int x$30 = this.writeDups$default$5();
        Seq<Tuple3<Object, String, Object>> dupsV0 = this.writeDups(x$25, x$26, x$27, x$28, x$30, x$29);
        LogAppendInfo appendInfo = log.appendAsLeader(largeMessageSet2, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        long largeMessageOffset = BoxesRunTime.unboxToLong((Object)appendInfo.firstOffset().get());
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_11_0_IV0$.MODULE$.version());
        log.config_$eq(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$31 = 30;
        int x$32 = 40;
        int x$33 = 3;
        Log x$34 = log;
        CompressionType x$35 = this.codec();
        byte x$36 = 1;
        Seq<Tuple3<Object, String, Object>> dupsV1 = this.writeDups(x$32, x$33, x$34, x$35, x$31, x$36);
        int x$37 = 15;
        int x$38 = 5;
        int x$39 = 3;
        Log x$40 = log;
        CompressionType x$41 = this.codec();
        byte x$42 = 2;
        Seq<Tuple3<Object, String, Object>> dupsV2 = this.writeDups(x$38, x$39, x$40, x$41, x$37, x$42);
        Seq appends2 = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)appends.$plus$plus(dupsV0, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset))})), Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV1, Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV2, Seq$.MODULE$.canBuildFrom());
        long firstDirty2 = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty2);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
    }

    @Test
    public void testCleaningNestedMessagesWithMultipleVersions() {
        CompressionType compressionType = this.codec();
        CompressionType compressionType2 = CompressionType.ZSTD;
        if (!(compressionType != null ? !compressionType.equals(compressionType2) : compressionType2 != null)) {
            return;
        }
        int maxMessageSize = 192;
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$2 = maxMessageSize;
        int x$3 = 256;
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$4();
        long x$7 = this.makeCleaner$default$6();
        int x$82 = this.makeCleaner$default$7();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, x$6, x$2, x$7, x$82, x$3, x$9, x$10, x$11));
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        int x$12 = maxMessageSize;
        int x$13 = 256;
        Properties x$14 = this.logConfigProperties$default$1();
        float x$15 = this.logConfigProperties$default$3();
        long x$16 = this.logConfigProperties$default$4();
        int x$17 = this.logConfigProperties$default$5();
        long x$18 = this.logConfigProperties$default$7();
        Properties props = this.logConfigProperties(x$14, x$12, x$15, x$16, x$17, x$13, x$18);
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
        log.config_$eq(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$19 = 2;
        int x$20 = 3;
        Log x$21 = log;
        CompressionType x$22 = this.codec();
        byte x$23 = 0;
        int x$24 = this.writeDupsSingleMessageSet$default$5();
        Seq appendsV0 = this.writeDupsSingleMessageSet(x$19, x$20, x$21, x$22, x$24, x$23);
        int x$25 = 2;
        int x$26 = 3;
        int x$27 = 2;
        Log x$28 = log;
        CompressionType x$29 = this.codec();
        byte x$30 = 0;
        appendsV0 = (Seq)appendsV0.$plus$plus(this.writeDupsSingleMessageSet(x$25, x$27, x$28, x$29, x$26, x$30), Seq$.MODULE$.canBuildFrom());
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_10_0_IV1$.MODULE$.version());
        log.config_$eq(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$31 = 4;
        int x$32 = 2;
        int x$33 = 2;
        Log x$34 = log;
        CompressionType x$35 = this.codec();
        byte x$36 = 1;
        Seq appendsV1 = this.writeDupsSingleMessageSet(x$32, x$33, x$34, x$35, x$31, x$36);
        int x$37 = 4;
        int x$38 = 2;
        int x$39 = 2;
        Log x$40 = log;
        CompressionType x$41 = this.codec();
        byte x$42 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$38, x$39, x$40, x$41, x$37, x$42), Seq$.MODULE$.canBuildFrom());
        int x$43 = 6;
        int x$44 = 2;
        int x$45 = 2;
        Log x$46 = log;
        CompressionType x$47 = this.codec();
        byte x$48 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$44, x$45, x$46, x$47, x$43, x$48), Seq$.MODULE$.canBuildFrom());
        Seq appends = (Seq)appendsV0.$plus$plus((GenTraversableOnce)appendsV1, Seq$.MODULE$.canBuildFrom());
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        Assert.assertTrue((firstDirty > (long)appendsV0.size() ? 1 : 0) != 0);
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString(), (startSize > (long)compactedSize ? 1 : 0) != 0);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends);
    }

    @Test
    public void cleanerConfigUpdateTest() {
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
        Tuple2 tuple23 = tuple22;
        String largeMessageValue2 = (String)tuple23._1();
        MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
        int maxMessageSize = largeMessageSet2.sizeInBytes();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        long x$2 = 1L;
        int x$3 = maxMessageSize;
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        float x$5 = this.makeCleaner$default$2();
        int x$6 = this.makeCleaner$default$3();
        long x$7 = this.makeCleaner$default$6();
        int x$8 = this.makeCleaner$default$7();
        int x$9 = this.makeCleaner$default$8();
        long x$102 = this.makeCleaner$default$9();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$5, x$6, x$2, x$3, x$7, x$8, x$9, x$102, (Option<Object>)x$4, x$11));
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        this.writeDups(100, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        this.cleaner().startup();
        Assert.assertEquals((long)1L, (long)this.cleaner().cleanerCount());
        long firstDirty = log.activeSegment().baseOffset();
        TopicPartition topicPartition = new TopicPartition("log", 0);
        this.cleaner().awaitCleaned(topicPartition, firstDirty, 10L);
        Assert.assertTrue((String)"Should not have cleaned", (boolean)this.cleaner().cleanerManager().allCleanerCheckpoints().isEmpty());
        KafkaConfig oldConfig = LogCleanerParameterizedIntegrationTest.kafkaConfigWithCleanerConfig$1(this.cleaner().currentConfig());
        KafkaConfig newConfig = LogCleanerParameterizedIntegrationTest.kafkaConfigWithCleanerConfig$1(new CleanerConfig(2, this.cleaner().currentConfig().dedupeBufferSize(), this.cleaner().currentConfig().dedupeBufferLoadFactor(), 100000, this.cleaner().currentConfig().maxMessageSize(), this.cleaner().currentConfig().maxIoBytesPerSecond(), this.cleaner().currentConfig().backOffMs(), CleanerConfig$.MODULE$.apply$default$8(), CleanerConfig$.MODULE$.apply$default$9()));
        this.cleaner().reconfigure(oldConfig, newConfig);
        Assert.assertEquals((long)2L, (long)this.cleaner().cleanerCount());
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString(), (startSize > (long)compactedSize ? 1 : 0) != 0);
    }

    private void checkLastCleaned(String topic, int partitionId, long firstDirty) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$1 = topicPartition;
        long x$2 = firstDirty;
        long x$3 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$1, x$2, x$3);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)topicPartition));
        Assert.assertTrue((String)new StringBuilder(65).append("log cleaner should have processed up to offset ").append(firstDirty).append(", but lastCleaned=").append(lastCleaned).toString(), (lastCleaned >= firstDirty ? 1 : 0) != 0);
    }

    private void checkLogAfterAppendingDups(Log log, long startSize, Seq<Tuple3<Object, String, Object>> appends) {
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log);
        Assert.assertEquals((String)"Contents of the map shouldn't change", this.toMap((Iterable<Tuple3<Object, String, Object>>)appends), this.toMap(read));
        Assert.assertTrue((startSize > log.size() ? 1 : 0) != 0);
    }

    private Map<Object, Tuple2<String, Object>> toMap(Iterable<Tuple3<Object, String, Object>> messages) {
        return ((TraversableOnce)messages.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            int key = BoxesRunTime.unboxToInt((Object)tuple3._1());
            String value = (String)tuple3._2();
            long offset = BoxesRunTime.unboxToLong((Object)tuple3._3());
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)new Tuple2((Object)value, (Object)BoxesRunTime.boxToLong((long)offset)));
            return tuple2;
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Iterable<Tuple3<Object, String, Object>> readFromLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)deepLogEntry -> {
            int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(deepLogEntry.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            String value = TestUtils$.MODULE$.readString(deepLogEntry.value(), TestUtils$.MODULE$.readString$default$2());
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)deepLogEntry.offset()));
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<Object, String, Object>> writeDupsSingleMessageSet(int numKeys, int numDups, Log log, CompressionType codec, int startKey, byte magicValue) {
        IndexedSeq kvs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> LogCleanerParameterizedIntegrationTest.$anonfun$writeDupsSingleMessageSet$1(this, startKey, numKeys, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq records = (IndexedSeq)kvs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int key = tuple2._1$mcI$sp();
            String payload = (String)tuple2._2();
            SimpleRecord simpleRecord = new SimpleRecord(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), payload.toString().getBytes());
            return simpleRecord;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        LogAppendInfo appendInfo = log.appendAsLeader(MemoryRecords.withRecords((byte)magicValue, (CompressionType)codec, (SimpleRecord[])((SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        NumericRange.Inclusive offsets = new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)appendInfo.firstOffset().get()))).to((Object)BoxesRunTime.boxToLong((long)appendInfo.lastOffset()));
        return (Seq)((TraversableLike)kvs.zip((GenIterable)offsets, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 kv = (Tuple2)tuple2._1();
            long offset = tuple2._2$mcJ$sp();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp()), kv._2(), (Object)BoxesRunTime.boxToLong((long)offset));
            return tuple3;
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private int writeDupsSingleMessageSet$default$5() {
        return 0;
    }

    private final Tuple2 runCleanerAndCheckCompacted$1(int numKeys, Properties logProps$1) {
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.topicPartitions())).take(1));
        Properties x$2 = logProps$1;
        long x$32 = 100L;
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        int x$6 = this.makeCleaner$default$5();
        long x$7 = this.makeCleaner$default$6();
        int x$8 = this.makeCleaner$default$7();
        int x$9 = this.makeCleaner$default$8();
        long x$10 = this.makeCleaner$default$9();
        Option<Object> x$11 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, x$32, x$6, x$7, x$8, x$9, x$10, x$11, x$2));
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> messages = this.writeDups(numKeys, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        log.updateHighWatermark(log.logEndOffset());
        long firstDirty = log.activeSegment().baseOffset();
        this.cleaner().startup();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString(), (startSize > (long)compactedSize ? 1 : 0) != 0);
        return new Tuple2((Object)log, messages);
    }

    private static final KafkaConfig kafkaConfigWithCleanerConfig$1(CleanerConfig cleanerConfig) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.LogCleanerThreadsProp(), ((Object)BoxesRunTime.boxToInteger((int)cleanerConfig.numThreads())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), ((Object)BoxesRunTime.boxToLong((long)cleanerConfig.dedupeBufferSize())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferLoadFactorProp(), ((Object)BoxesRunTime.boxToDouble((double)cleanerConfig.dedupeBufferLoadFactor())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerIoBufferSizeProp(), ((Object)BoxesRunTime.boxToInteger((int)cleanerConfig.ioBufferSize())).toString());
        props.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)cleanerConfig.maxMessageSize())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp(), ((Object)BoxesRunTime.boxToLong((long)cleanerConfig.backOffMs())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerIoMaxBytesPerSecondProp(), ((Object)BoxesRunTime.boxToDouble((double)cleanerConfig.maxIoBytesPerSecond())).toString());
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDupsSingleMessageSet$2(LogCleanerParameterizedIntegrationTest $this, int key) {
        String payload = ((Object)BoxesRunTime.boxToInteger((int)$this.counter())).toString();
        $this.incCounter();
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)key), (Object)payload);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDupsSingleMessageSet$1(LogCleanerParameterizedIntegrationTest $this, int startKey$1, int numKeys$1, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startKey$1), startKey$1 + numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> LogCleanerParameterizedIntegrationTest.$anonfun$writeDupsSingleMessageSet$2($this, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public LogCleanerParameterizedIntegrationTest(String compressionCodec) {
        this.codec = CompressionType.forName((String)compressionCodec);
        this.time = new MockTime();
        this.topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
    }
}

