/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.security.auth.Resource$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclAuthorizer$;
import kafka.security.authorizer.AuthorizerUtils$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ZkAclStore;
import kafka.zk.ZkAclStore$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenRequest$;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataRequest$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\ref\u0001B1c\u0001%DQ\u0001\u001d\u0001\u0005\u0002EDq\u0001\u001e\u0001C\u0002\u0013%Q\u000fC\u0004\u0002\b\u0001\u0001\u000b\u0011\u0002<\t\u0011\u0005%\u0001A1A\u0005\nUDq!a\u0003\u0001A\u0003%a\u000f\u0003\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0003v\u0011\u001d\ty\u0001\u0001Q\u0001\nYD\u0011\"!\u0005\u0001\u0005\u0004%I!a\u0005\t\u0011\u0005\u0005\u0002\u0001)A\u0005\u0003+A\u0011\"a\t\u0001\u0005\u0004%I!a\u0005\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u0003+A\u0011\"a\n\u0001\u0005\u0004%I!a\u0005\t\u0011\u0005%\u0002\u0001)A\u0005\u0003+A\u0011\"a\u000b\u0001\u0005\u0004%I!!\f\t\u0011\u0005u\u0002\u0001)A\u0005\u0003_A\u0011\"a\u0010\u0001\u0005\u0004%I!!\u0011\t\u0011\u0005%\u0003\u0001)A\u0005\u0003\u0007B\u0011\"a\u0013\u0001\u0005\u0004%I!!\u0011\t\u0011\u00055\u0003\u0001)A\u0005\u0003\u0007B1\"a\u0007\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0014!Y\u0011q\n\u0001A\u0002\u0003\u0007I\u0011BA)\u0011-\t\u0019\u0007\u0001a\u0001\u0002\u0003\u0006K!!\u0006\t\u0013\u0005\u0015\u0004A1A\u0005\n\u0005\u001d\u0004\u0002CA=\u0001\u0001\u0006I!!\u001b\t\u0013\u0005m\u0004A1A\u0005\n\u0005\u001d\u0004\u0002CA?\u0001\u0001\u0006I!!\u001b\t\u0013\u0005}\u0004A1A\u0005\n\u00055\u0002\u0002CAA\u0001\u0001\u0006I!a\f\t\u0013\u0005\r\u0005A1A\u0005\n\u0005\u0015\u0005\u0002CAJ\u0001\u0001\u0006I!a\"\t\u0017\u0005U\u0005\u00011AA\u0002\u0013%\u0011q\u0013\u0005\f\u0003K\u0003\u0001\u0019!a\u0001\n\u0013\t9\u000bC\u0006\u0002,\u0002\u0001\r\u0011!Q!\n\u0005e\u0005bCAW\u0001\u0001\u0007\t\u0019!C\u0005\u0003_C1\"!0\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002@\"Y\u00111\u0019\u0001A\u0002\u0003\u0005\u000b\u0015BAY\r\u0019\t)\r\u0001\u0001\u0002H\"Q\u0011\u0011Z\u0013\u0003\u0002\u0003\u0006I!a3\t\u0015\u0005}WE!A!\u0002\u0013\tY\r\u0003\u0004qK\u0011\u0005\u0011\u0011\u001d\u0005\b\u0003W,C\u0011IAw\u0011\u001d\ty\u0010\u0001C!\u0005\u0003AqA!\u0005\u0001\t\u0003\u0012\t\u0001C\u0004\u0003\u001c\u0001!\tA!\u0001\t\u000f\tm\u0002\u0001\"\u0001\u0003\u0002!9!q\b\u0001\u0005\u0002\t\u0005\u0001b\u0002B\"\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005\u000f\u0002A\u0011\u0001B\u0001\u0011\u001d\u0011Y\u0005\u0001C\u0001\u0005\u0003AqAa\u0014\u0001\t\u0003\u0011\t\u0001C\u0004\u0003T\u0001!\tA!\u0001\t\u000f\t]\u0003\u0001\"\u0001\u0003\u0002!9!1\f\u0001\u0005\u0002\t\u0005\u0001b\u0002B0\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005G\u0002A\u0011\u0001B\u0001\u0011\u001d\u00119\u0007\u0001C\u0001\u0005\u0003AqAa\u001b\u0001\t\u0003\u0011\t\u0001C\u0004\u0003p\u0001!\tA!\u0001\t\u000f\tM\u0004\u0001\"\u0001\u0003\u0002!9!q\u000f\u0001\u0005\u0002\t\u0005\u0001b\u0002B>\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005\u007f\u0002A\u0011\u0001B\u0001\u0011\u001d\u0011\u0019\t\u0001C\u0005\u0005\u000bCqAa'\u0001\t\u0013\u0011i\nC\u0004\u0003&\u0002!\tA!\u0001\t\u000f\t%\u0006\u0001\"\u0001\u0003\u0002!9!Q\u0016\u0001\u0005\u0002\t\u0005\u0001b\u0002BY\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005k\u0003A\u0011\u0001B\u0001\u0011\u001d\u0011I\f\u0001C\u0001\u0005\u0003AqA!0\u0001\t\u0003\u0011\t\u0001C\u0004\u0003B\u0002!\tA!\u0001\t\u000f\t\u0015\u0007\u0001\"\u0001\u0003\u0002!9!\u0011\u001a\u0001\u0005\u0002\t\u0005\u0001b\u0002Bg\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005#\u0004A\u0011\u0001B\u0001\u0011\u001d\u0011)\u000e\u0001C\u0001\u0005\u0003AqA!7\u0001\t\u0003\u0011\t\u0001C\u0004\u0003^\u0002!\tA!\u0001\t\u000f\t\u0005\b\u0001\"\u0001\u0003\u0002!9!Q\u001d\u0001\u0005\u0002\t\u0005\u0001b\u0002Bu\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005[\u0004A\u0011\u0001B\u0001\u0011\u001d\u0011\t\u0010\u0001C\u0005\u0005gDqaa\u0003\u0001\t\u0013\u0019i\u0001C\u0004\u0004\u001a\u0001!Iaa\u0007\t\u0013\r5\u0002!%A\u0005\n\r=\u0002bBB#\u0001\u0011%1q\t\u0005\n\u0007W\u0002\u0011\u0013!C\u0005\u0007[Bqa!\u001d\u0001\t\u0013\u0019\u0019\bC\u0004\u0004\u0000\u0001!Ia!!\t\u000f\r5\u0005\u0001\"\u0003\u0004\u0010\"91q\u0013\u0001\u0005\n\re\u0005bBBL\u0001\u0011%1q\u0014\u0005\b\u0007/\u0003A\u0011BBW\u0011\u001d\u0019\t\f\u0001C\u0005\u0007g\u0013\u0011#Q2m\u0003V$\bn\u001c:ju\u0016\u0014H+Z:u\u0015\t\u0019G-\u0001\u0006bkRDwN]5{KJT!!\u001a4\u0002\u0011M,7-\u001e:jifT\u0011aZ\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u000e\u0005\u0002l]6\tAN\u0003\u0002nM\u0006\u0011!p[\u0005\u0003_2\u0014ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001s!\t\u0019\b!D\u0001c\u00031\tG\u000e\\8x%\u0016\fG-Q2m+\u00051\bcA<\u0002\u00045\t\u0001P\u0003\u0002zu\u0006\u0019\u0011m\u00197\u000b\u0005md\u0018AB2p[6|gN\u0003\u0002h{*\u0011ap`\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\u0005\u0011aA8sO&\u0019\u0011Q\u0001=\u0003%\u0005\u001b7-Z:t\u0007>tGO]8m\u000b:$(/_\u0001\u000eC2dwn\u001e*fC\u0012\f5\r\u001c\u0011\u0002\u001b\u0005dGn\\<Xe&$X-Q2m\u00039\tG\u000e\\8x/JLG/Z!dY\u0002\n1\u0002Z3osJ+\u0017\rZ!dY\u0006aA-\u001a8z%\u0016\fG-Q2mA\u0005\u0001r/\u001b7e\u0007\u0006\u0014HMU3t_V\u00148-Z\u000b\u0003\u0003+\u0001B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037Q\u0018\u0001\u0003:fg>,(oY3\n\t\u0005}\u0011\u0011\u0004\u0002\u0010%\u0016\u001cx.\u001e:dKB\u000bG\u000f^3s]\u0006\tr/\u001b7e\u0007\u0006\u0014HMU3t_V\u00148-\u001a\u0011\u0002!A\u0014XMZ5yK\u0012\u0014Vm]8ve\u000e,\u0017!\u00059sK\u001aL\u00070\u001a3SKN|WO]2fA\u0005y1\r\\;ti\u0016\u0014(+Z:pkJ\u001cW-\u0001\tdYV\u001cH/\u001a:SKN|WO]2fA\u0005\tr/\u001b7eG\u0006\u0014H\r\u0015:j]\u000eL\u0007/\u00197\u0016\u0005\u0005=\u0002\u0003BA\u0019\u0003si!!a\r\u000b\t\u0005U\u0012qG\u0001\u0005CV$\bN\u0003\u0002fu&!\u00111HA\u001a\u00059Y\u0015MZ6b!JLgnY5qC2\f!c^5mI\u000e\f'\u000f\u001a)sS:\u001c\u0017\u000e]1mA\u0005i\u0011m\u00197BkRDwN]5{KJ,\"!a\u0011\u0011\u0007M\f)%C\u0002\u0002H\t\u0014Q\"Q2m\u0003V$\bn\u001c:ju\u0016\u0014\u0018AD1dY\u0006+H\u000f[8sSj,'\u000fI\u0001\u000fC\u000ed\u0017)\u001e;i_JL'0\u001a:3\u0003=\t7\r\\!vi\"|'/\u001b>feJ\u0002\u0013\u0001\u0004:fg>,(oY3`I\u0015\fH\u0003BA*\u0003?\u0002B!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0003\u00033\nQa]2bY\u0006LA!!\u0018\u0002X\t!QK\\5u\u0011%\t\t'FA\u0001\u0002\u0004\t)\"A\u0002yIE\n\u0011B]3t_V\u00148-\u001a\u0011\u0002\u0015M,\b/\u001a:Vg\u0016\u00148/\u0006\u0002\u0002jA!\u00111NA;\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014\u0001\u00027b]\u001eT!!a\u001d\u0002\t)\fg/Y\u0005\u0005\u0003o\niG\u0001\u0004TiJLgnZ\u0001\fgV\u0004XM]+tKJ\u001c\b%\u0001\u0005vg\u0016\u0014h.Y7f\u0003%)8/\u001a:oC6,\u0007%A\u0005qe&t7-\u001b9bY\u0006Q\u0001O]5oG&\u0004\u0018\r\u001c\u0011\u0002\u001dI,\u0017/^3ti\u000e{g\u000e^3yiV\u0011\u0011q\u0011\t\u0005\u0003\u0013\u000by)\u0004\u0002\u0002\f*\u0019\u0011Q\u0012>\u0002\u0011I,\u0017/^3tiNLA!!%\u0002\f\nq!+Z9vKN$8i\u001c8uKb$\u0018a\u0004:fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u0011\u0002\r\r|gNZ5h+\t\tI\n\u0005\u0003\u0002\u001c\u0006\u0005VBAAO\u0015\r\tyJZ\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005\r\u0016Q\u0014\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0006d_:4\u0017nZ0%KF$B!a\u0015\u0002*\"I\u0011\u0011\r\u0011\u0002\u0002\u0003\u0007\u0011\u0011T\u0001\bG>tg-[4!\u0003=Qxn\\&fKB,'o\u00117jK:$XCAAY!\u0011\t\u0019,!/\u000e\u0005\u0005U&bAA\\M\u0006I!p\\8lK\u0016\u0004XM]\u0005\u0005\u0003w\u000b)LA\b[_>\\U-\u001a9fe\u000ec\u0017.\u001a8u\u0003MQxn\\&fKB,'o\u00117jK:$x\fJ3r)\u0011\t\u0019&!1\t\u0013\u0005\u00054%!AA\u0002\u0005E\u0016\u0001\u0005>p_.+W\r]3s\u00072LWM\u001c;!\u0005=\u0019Uo\u001d;p[B\u0013\u0018N\\2ja\u0006d7cA\u0013\u00020\u0005i\u0001O]5oG&\u0004\u0018\r\u001c+za\u0016\u0004B!!4\u0002\\:!\u0011qZAl!\u0011\t\t.a\u0016\u000e\u0005\u0005M'bAAkQ\u00061AH]8pizJA!!7\u0002X\u00051\u0001K]3eK\u001aLA!a\u001e\u0002^*!\u0011\u0011\\A,\u0003\u0011q\u0017-\\3\u0015\r\u0005\r\u0018q]Au!\r\t)/J\u0007\u0002\u0001!9\u0011\u0011\u001a\u0015A\u0002\u0005-\u0007bBApQ\u0001\u0007\u00111Z\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005=\u0018Q\u001f\t\u0005\u0003+\n\t0\u0003\u0003\u0002t\u0006]#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003oL\u0003\u0019AA}\u0003\u0005y\u0007\u0003BA+\u0003wLA!!@\u0002X\t\u0019\u0011I\\=\u0002\u000bM,G/\u00169\u0015\u0005\u0005M\u0003f\u0001\u0016\u0003\u0006A!!q\u0001B\u0007\u001b\t\u0011IAC\u0002\u0003\f}\fQA[;oSRLAAa\u0004\u0003\n\t1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004W\tU\u0001\u0003\u0002B\u0004\u0005/IAA!\u0007\u0003\n\t)\u0011I\u001a;fe\u00069C/Z:u\u0003V$\bn\u001c:ju\u0016$\u0006N]8xg>sgj\u001c8MSR,'/\u00197SKN|WO]2fQ\u001da#q\u0004B\u0013\u0005O\u0001BAa\u0002\u0003\"%!!1\u0005B\u0005\u0005\u0011!Vm\u001d;\u0002\u0011\u0015D\b/Z2uK\u0012\u001c#A!\u000b\u0011\t\t-\"Q\u0007\b\u0005\u0005[\u0011\tD\u0004\u0003\u0002R\n=\u0012BAA-\u0013\u0011\u0011\u0019$a\u0016\u0002\u000fA\f7m[1hK&!!q\u0007B\u001d\u0005aIE\u000e\\3hC2\f%oZ;nK:$X\t_2faRLwN\u001c\u0006\u0005\u0005g\t9&\u0001\u0012uKN$\u0018)\u001e;i_JL'0Z,ji\",U\u000e\u001d;z%\u0016\u001cx.\u001e:dK:\u000bW.\u001a\u0015\u0004[\t}\u0011a\u0007;fgR,U\u000e\u001d;z\u0003\u000edG\u000b\u001b:poN,\u0005pY3qi&|g\u000eK\u0002/\u0005?\tA\u0002^3tiR{\u0007/[2BG2D3a\fB\u0010\u0003\t\"Xm\u001d;BY2|w/Q2dKN\u001cx+\u001b;i\u0007V\u001cHo\\7Qe&t7-\u001b9bY\"\u001a\u0001Ga\b\u0002/Q,7\u000f\u001e#f]f$\u0016m[3t!J,7-\u001a3f]\u000e,\u0007fA\u0019\u0003 \u0005\u0011B/Z:u\u00032dwn^!mY\u0006\u001b7-Z:tQ\r\u0011$qD\u0001\u0017i\u0016\u001cHoU;qKJ,6/\u001a:ICN\f5mY3tg\"\u001a1Ga\b\u0002SQ,7\u000f^*va\u0016\u0014Xk]3s/&$\bnQ;ti>l\u0007K]5oG&\u0004\u0018\r\u001c%bg\u0006\u001b7-Z:tQ\r!$qD\u0001\u0011i\u0016\u001cHoV5mI\u000e\u000b'\u000fZ!dYND3!\u000eB\u0010\u00039!Xm\u001d;O_\u0006\u001bGNR8v]\u0012D3A\u000eB\u0010\u0003Y!Xm\u001d;O_\u0006\u001bGNR8v]\u0012|e/\u001a:sS\u0012,\u0007fA\u001c\u0003 \u0005)B/Z:u\u0003\u000edW*\u00198bO\u0016lWM\u001c;B!&\u001b\bf\u0001\u001d\u0003 \u0005iA/Z:u\u0019>\fGmQ1dQ\u0016D3!\u000fB\u0010\u0003a!Xm\u001d;DQ\u0006tw-\u001a'jgR,g.\u001a:US6Lgn\u001a\u0015\u0004u\t}\u0011!\f;fgRdunY1m\u0007>t7-\u001e:sK:$Xj\u001c3jM&\u001c\u0017\r^5p]>3'+Z:pkJ\u001cW-Q2mg\"\u001a1Ha\b\u0002gQ,7\u000f\u001e#jgR\u0014\u0018NY;uK\u0012\u001cuN\\2veJ,g\u000e^'pI&4\u0017nY1uS>twJ\u001a*fg>,(oY3BG2\u001c\bf\u0001\u001f\u0003 \u0005iC/Z:u\u0011&<\u0007nQ8oGV\u0014(/\u001a8ds6{G-\u001b4jG\u0006$\u0018n\u001c8PMJ+7o\\;sG\u0016\f5\r\\:)\u0007u\u0012y\"\u0001\nuKN$\u0018i\u00197J]\",'/\u001b;b]\u000e,\u0007f\u0001 \u0003 \u00059B/Z:u\u00136\u0004H.[2bi&|gn](g\u00032dwn\u001e\u000b\u0007\u0003'\u00129I!%\t\u000f\t%u\b1\u0001\u0003\f\u0006A\u0001/\u0019:f]R|\u0005\u000fE\u0002x\u0005\u001bK1Aa$y\u00051\t5\r\\(qKJ\fG/[8o\u0011\u001d\u0011\u0019j\u0010a\u0001\u0005+\u000b!\"\u00197m_^,Gm\u00149t!\u0019\tiMa&\u0003\f&!!\u0011TAo\u0005\r\u0019V\r^\u0001\u0017i\u0016\u001cH/S7qY&\u001c\u0017\r^5p]N|e\rR3osR1\u00111\u000bBP\u0005CCqA!#A\u0001\u0004\u0011Y\tC\u0004\u0003$\u0002\u0003\rA!&\u0002\u0013\u0011,g.[3e\u001fB\u001c\u0018!\u000b;fgRD\u0015n\u001a5D_:\u001cWO\u001d:f]\u000eLH)\u001a7fi&|gn\u00144SKN|WO]2f\u0003\u000ed7\u000fK\u0002B\u0005?\t1\u0007^3ti\u0006\u001b7-Z:t\u00032dwn^3e\u0013\u001a\fE\u000e\\8x\u0003\u000edW\t_5tiN|enV5mI\u000e\f'\u000f\u001a*fg>,(oY3)\u0007\t\u0013y\"A\u0010uKN$H)\u001a7fi\u0016\f5\r\\(o/&dGmY1sIJ+7o\\;sG\u0016D3a\u0011B\u0010\u0003\t\"Xm\u001d;EK2,G/Z!mY\u0006\u001bGn\u00148XS2$7-\u0019:e%\u0016\u001cx.\u001e:dK\"\u001aAIa\b\u0002gQ,7\u000f^!dG\u0016\u001c8/\u00117m_^,G-\u00134BY2|w/Q2m\u000bbL7\u000f^:P]B\u0013XMZ5yK\u0012\u0014Vm]8ve\u000e,\u0007fA#\u0003 \u0005yB/Z:u\t\u0016dW\r^3BG2|e\u000e\u0015:fM&DX\r\u001a*fg>,(oY3)\u0007\u0019\u0013y\"\u0001\u0012uKN$H)\u001a7fi\u0016\fE\u000e\\!dY>s\u0007K]3gSb,GMU3t_V\u00148-\u001a\u0015\u0004\u000f\n}\u0011\u0001\b;fgR\fE\rZ!dYN|e\u000eT5uKJ\fGNU3t_V\u00148-\u001a\u0015\u0004\u0011\n}\u0011!\b;fgR\fE\rZ!dYN|enV5mI\u000e\f'\u000f\u001a*fg>,(oY3)\u0007%\u0013y\"A\u000fuKN$\u0018\t\u001a3BG2\u001cxJ\u001c)sK\u001aL\u00070\u001a3SKN|WO]2fQ\rQ%qD\u0001\"i\u0016\u001cH/Q;uQ>\u0014\u0018N_3XSRD\u0007K]3gSb,GMU3t_V\u00148-\u001a\u0015\u0004\u0017\n}\u0011a\b;fgR\u001c\u0016N\\4mK\u000eC\u0017M]1di\u0016\u0014(+Z:pkJ\u001cW-Q2mg\"\u001aAJa\b\u0002)Q,7\u000f^$fi\u0006\u001bGn\u001d)sS:\u001c\u0017\u000e]1mQ\ri%qD\u0001\u000fi\u0016\u001cH/Q2mg\u001aKG\u000e^3sQ\rq%qD\u0001=i\u0016\u001cH\u000f\u00165s_^\u001cxJ\\!eIB\u0013XMZ5yK\u0012\f5\r\\%g\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c,feNLwN\u001c+p_2{w\u000fK\u0002P\u0005?\t1\b^3ti^\u0013\u0018\u000e^3t\u000bb$XM\u001c3fI\u0006\u001bGn\u00115b]\u001e,WI^3oi&3\u0017J\u001c;fe\n\u0013xn[3s!J|Go\\2pY:{GoU3uQ\r\u0001&qD\u0001Fi\u0016\u001cHo\u0016:ji\u0016\u001cX\t\u001f;f]\u0012,G-Q2m\u0007\"\fgnZ3Fm\u0016tGo\u00165f]&sG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7Bi2+\u0017m\u001d;LC\u001a\\\u0017M\u0016\u001a)\u0007E\u0013y\"\u0001=uKN$xK]5uKNd\u0015\u000e^3sC2<&/\u001b;fg2KG/\u001a:bY\u0006\u001bGn\u00115b]\u001e,WI^3oi^CWM\\%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>dG*Z:t)\"\fgnS1gW\u00064&'\u001a:bY\u0006\u001bGn\u00115b]\u001e,7OR8s\u001f2$WM\u001d)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8tQ\r\u0011&qD\u0001@i\u0016\u001cHo\u0016:ji\u0016\u001cH*\u001b;fe\u0006d\u0017i\u00197DQ\u0006tw-Z#wK:$x\u000b[3o\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\\%t\u0017\u000647.\u0019,3Q\r\u0019&qD\u0001#O&4XM\\!vi\"|'/\u001b>fe^KG\u000f\u001b)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8\u0015\t\u0005M#Q\u001f\u0005\b\u0005o$\u0006\u0019\u0001B}\u0003=\u0001(o\u001c;pG>dg+\u001a:tS>t\u0007CBA+\u0005w\u0014y0\u0003\u0003\u0003~\u0006]#AB(qi&|g\u000e\u0005\u0003\u0004\u0002\r\u001dQBAB\u0002\u0015\r\u0019)AZ\u0001\u0004CBL\u0017\u0002BB\u0005\u0007\u0007\u0011!\"\u00119j-\u0016\u00148/[8o\u0003e9W\r^!dY\u000eC\u0017M\\4f\u000bZ,g\u000e^!t'R\u0014\u0018N\\4\u0015\t\u0005%4q\u0002\u0005\b\u0007#)\u0006\u0019AB\n\u0003-\u0001\u0018\r\u001e;fe:$\u0016\u0010]3\u0011\t\u0005]1QC\u0005\u0005\u0007/\tIBA\u0006QCR$XM\u001d8UsB,\u0017AE2iC:<W-Q2m\u0003:$g+\u001a:jMf$\"b!\b\u0004 \r\r2qEB\u0016!\u0015\tiMa&w\u0011\u001d\u0019\tC\u0016a\u0001\u0007;\tAb\u001c:jO&t\u0017\r\\!dYNDqa!\nW\u0001\u0004\u0019i\"A\u0005bI\u0012,G-Q2mg\"91\u0011\u0006,A\u0002\ru\u0011a\u0003:f[>4X\rZ!dYND\u0011\"a\u0007W!\u0003\u0005\r!!\u0006\u00029\rD\u0017M\\4f\u0003\u000ed\u0017I\u001c3WKJLg-\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u00111\u0011\u0007\u0016\u0005\u0003+\u0019\u0019d\u000b\u0002\u00046A!1qGB!\u001b\t\u0019ID\u0003\u0003\u0004<\ru\u0012!C;oG\",7m[3e\u0015\u0011\u0019y$a\u0016\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004D\re\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\tb.Z<SKF,Xm\u001d;D_:$X\r\u001f;\u0015\u0011\u0005\u001d5\u0011JB&\u00077Bq!a Y\u0001\u0004\ty\u0003C\u0004\u0004Na\u0003\raa\u0014\u0002\u001b\rd\u0017.\u001a8u\u0003\u0012$'/Z:t!\u0011\u0019\tfa\u0016\u000e\u0005\rM#\u0002BB+\u0003c\n1A\\3u\u0013\u0011\u0019Ifa\u0015\u0003\u0017%sW\r^!eIJ,7o\u001d\u0005\n\u0007;B\u0006\u0013!a\u0001\u0007?\na!\u00199j\u0017\u0016L\b\u0003BB1\u0007Oj!aa\u0019\u000b\u0007\r\u0015$0\u0001\u0005qe>$xnY8m\u0013\u0011\u0019Iga\u0019\u0003\u000f\u0005\u0003\u0018nS3zg\u0006Yb.Z<SKF,Xm\u001d;D_:$X\r\u001f;%I\u00164\u0017-\u001e7uIM*\"aa\u001c+\t\r}31G\u0001\nCV$\bn\u001c:ju\u0016$\"\"a<\u0004v\r]4\u0011PB?\u0011\u0019\u0019'\f1\u0001\u0002D!9\u00111\u0011.A\u0002\u0005\u001d\u0005bBB>5\u0002\u0007!1R\u0001\n_B,'/\u0019;j_:Dq!a\u0007[\u0001\u0004\t)\"A\u0004bI\u0012\f5\r\\:\u0015\u0011\u0005M31QBC\u0007\u0013CaaY.A\u0002\u0005\r\u0003bBBD7\u0002\u00071QD\u0001\u0005C\u000e,7\u000fC\u0004\u0004\fn\u0003\r!!\u0006\u0002\u001fI,7o\\;sG\u0016\u0004\u0016\r\u001e;fe:\f!B]3n_Z,\u0017i\u00197t)!\tyo!%\u0004\u0014\u000eU\u0005BB2]\u0001\u0004\t\u0019\u0005C\u0004\u0004\br\u0003\ra!\b\t\u000f\r-E\f1\u0001\u0002\u0016\u00059q-\u001a;BG2\u001cHCBB\u000f\u00077\u001bi\n\u0003\u0004d;\u0002\u0007\u00111\t\u0005\b\u0007\u0017k\u0006\u0019AA\u000b)\u0019\u0019\tk!+\u0004,B1\u0011Q\u001aBL\u0007G\u00032a^BS\u0013\r\u00199\u000b\u001f\u0002\u000b\u0003\u000ed')\u001b8eS:<\u0007BB2_\u0001\u0004\t\u0019\u0005C\u0004\u0002\u0000y\u0003\r!a\f\u0015\t\r\u00056q\u0016\u0005\u0007G~\u0003\r!a\u0011\u0002\u000fY\fG.\u001b3PaR!\u0011q^B[\u0011\u001d\u00199\f\u0019a\u0001\u0005\u0017\u000b!a\u001c9")
public class AclAuthorizerTest
extends ZooKeeperTestHarness {
    private final AccessControlEntry allowReadAcl = new AccessControlEntry(AuthorizerUtils$.MODULE$.WildcardPrincipal(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
    private final AccessControlEntry allowWriteAcl = new AccessControlEntry(AuthorizerUtils$.MODULE$.WildcardPrincipal(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
    private final AccessControlEntry denyReadAcl = new AccessControlEntry(AuthorizerUtils$.MODULE$.WildcardPrincipal(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
    private final ResourcePattern wildCardResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
    private final ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.PREFIXED);
    private final ResourcePattern clusterResource = new ResourcePattern(ResourceType.CLUSTER, Resource$.MODULE$.ClusterResourceName(), PatternType.LITERAL);
    private final KafkaPrincipal wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AuthorizerUtils$.MODULE$.WildcardPrincipal());
    private final AclAuthorizer aclAuthorizer = new AclAuthorizer();
    private final AclAuthorizer aclAuthorizer2 = new AclAuthorizer();
    private ResourcePattern resource;
    private final String superUsers;
    private final String username;
    private final KafkaPrincipal principal = new KafkaPrincipal("User", this.username());
    private final RequestContext requestContext = this.newRequestContext(this.principal(), InetAddress.getByName("192.168.0.1"), this.newRequestContext$default$3());
    private KafkaConfig config;
    private ZooKeeperClient zooKeeperClient;

    private AccessControlEntry allowReadAcl() {
        return this.allowReadAcl;
    }

    private AccessControlEntry allowWriteAcl() {
        return this.allowWriteAcl;
    }

    private AccessControlEntry denyReadAcl() {
        return this.denyReadAcl;
    }

    private ResourcePattern wildCardResource() {
        return this.wildCardResource;
    }

    private ResourcePattern prefixedResource() {
        return this.prefixedResource;
    }

    private ResourcePattern clusterResource() {
        return this.clusterResource;
    }

    private KafkaPrincipal wildcardPrincipal() {
        return this.wildcardPrincipal;
    }

    private AclAuthorizer aclAuthorizer() {
        return this.aclAuthorizer;
    }

    private AclAuthorizer aclAuthorizer2() {
        return this.aclAuthorizer2;
    }

    private ResourcePattern resource() {
        return this.resource;
    }

    private void resource_$eq(ResourcePattern x$1) {
        this.resource = x$1;
    }

    private String superUsers() {
        return this.superUsers;
    }

    private String username() {
        return this.username;
    }

    private KafkaPrincipal principal() {
        return this.principal;
    }

    private RequestContext requestContext() {
        return this.requestContext;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    private ZooKeeperClient zooKeeperClient() {
        return this.zooKeeperClient;
    }

    private void zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.zooKeeperClient = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.aclAuthorizer().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        this.aclAuthorizer2().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(AclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.aclAuthorizer().configure(this.config().originals());
        this.aclAuthorizer2().configure(this.config().originals());
        this.resource_$eq(new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL));
        this.zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "kafka.test", "AclAuthorizerTest"));
    }

    @Override
    @After
    public void tearDown() {
        this.aclAuthorizer().close();
        this.aclAuthorizer2().close();
        this.zooKeeperClient().close();
        super.tearDown();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAuthorizeThrowsOnNonLiteralResource() {
        this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "something", PatternType.PREFIXED));
    }

    @Test
    public void testAuthorizeWithEmptyResourceName() {
        Assert.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL));
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
    }

    @Test
    public void testEmptyAclThrowsException() {
        ApiException e = (ApiException)((Object)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)), ClassTag$.MODULE$.apply(ApiException.class), new Position("AclAuthorizerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120)));
        Assert.assertTrue((String)new StringBuilder(21).append("Unexpected exception ").append((Object)e).toString(), (boolean)(e.getCause() instanceof IllegalArgumentException));
    }

    @Test
    public void testTopicAcl() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "rob");
        KafkaPrincipal user3 = new KafkaPrincipal("User", "batman");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl4 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl5 = new AccessControlEntry(user1.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AccessControlEntry acl6 = new AccessControlEntry(user2.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl7 = new AccessControlEntry(user3.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4, acl5, acl6, acl7}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext host2Context = this.newRequestContext(user1, host2, this.newRequestContext$default$3());
        Assert.assertTrue((String)"User1 should have READ access from host2", (boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.READ, this.resource()));
        Assert.assertFalse((String)"User1 should not have READ access from host1 due to denyAcl", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()));
        Assert.assertTrue((String)"User1 should have WRITE access from host1", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.WRITE, this.resource()));
        Assert.assertFalse((String)"User1 should not have WRITE access from host2 as no allow acl is defined", (boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.WRITE, this.resource()));
        Assert.assertTrue((String)"User1 should not have DESCRIBE access from host1", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.DESCRIBE, this.resource()));
        Assert.assertTrue((String)"User1 should have DESCRIBE access from host2", (boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.DESCRIBE, this.resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host1", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.ALTER, this.resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host2", (boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.ALTER, this.resource()));
        RequestContext user2Context = this.newRequestContext(user2, host1, this.newRequestContext$default$3());
        RequestContext user3Context = this.newRequestContext(user3, host1, this.newRequestContext$default$3());
        Assert.assertTrue((String)"User2 should have DESCRIBE access from host1", (boolean)this.authorize(this.aclAuthorizer(), user2Context, AclOperation.DESCRIBE, this.resource()));
        Assert.assertTrue((String)"User3 should have DESCRIBE access from host2", (boolean)this.authorize(this.aclAuthorizer(), user3Context, AclOperation.DESCRIBE, this.resource()));
        Assert.assertTrue((String)"User2 should have READ access from host1", (boolean)this.authorize(this.aclAuthorizer(), user2Context, AclOperation.READ, this.resource()));
        Assert.assertTrue((String)"User3 should have WRITE access from host2", (boolean)this.authorize(this.aclAuthorizer(), user3Context, AclOperation.WRITE, this.resource()));
    }

    @Test
    public void testAllowAccessWithCustomPrincipal() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        CustomPrincipal customUserPrincipal = new CustomPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl2 = new AccessControlEntry(user.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext host1Context = this.newRequestContext(customUserPrincipal, host1, this.newRequestContext$default$3());
        RequestContext host2Context = this.newRequestContext(customUserPrincipal, host2, this.newRequestContext$default$3());
        Assert.assertTrue((String)"User1 should have READ access from host2", (boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.READ, this.resource()));
        Assert.assertFalse((String)"User1 should not have READ access from host1 due to denyAcl", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()));
    }

    @Test
    public void testDenyTakesPrecedence() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.2.1");
        RequestContext session = this.newRequestContext(user, host, this.newRequestContext$default$3());
        AccessControlEntry allowAll = new AccessControlEntry(AuthorizerUtils$.MODULE$.WildcardPrincipal(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        AccessControlEntry denyAcl = new AccessControlEntry(user.toString(), host.getHostAddress(), AclOperation.ALL, AclPermissionType.DENY);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAll, denyAcl}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        Assert.assertFalse((String)"deny should take precedence over allow.", (boolean)this.authorize(this.aclAuthorizer(), session, AclOperation.READ, this.resource()));
    }

    @Test
    public void testAllowAllAccess() {
        AccessControlEntry allowAllAcl = new AccessControlEntry(AuthorizerUtils$.MODULE$.WildcardPrincipal(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext context = this.newRequestContext(new KafkaPrincipal("User", "random"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assert.assertTrue((String)"allow all acl should allow access to all.", (boolean)this.authorize(this.aclAuthorizer(), context, AclOperation.READ, this.resource()));
    }

    @Test
    public void testSuperUserHasAccess() {
        AccessControlEntry denyAllAcl = new AccessControlEntry(AuthorizerUtils$.MODULE$.WildcardPrincipal(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext session1 = this.newRequestContext(new KafkaPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        RequestContext session2 = this.newRequestContext(new KafkaPrincipal("User", "superuser2"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.authorize(this.aclAuthorizer(), session1, AclOperation.READ, this.resource()));
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.authorize(this.aclAuthorizer(), session2, AclOperation.READ, this.resource()));
    }

    @Test
    public void testSuperUserWithCustomPrincipalHasAccess() {
        AccessControlEntry denyAllAcl = new AccessControlEntry(AuthorizerUtils$.MODULE$.WildcardPrincipal(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext session = this.newRequestContext(new CustomPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assert.assertTrue((String)"superuser with custom principal always has access, no matter what acls.", (boolean)this.authorize(this.aclAuthorizer(), session, AclOperation.READ, this.resource()));
    }

    @Test
    public void testWildCardAcls() {
        Assert.assertFalse((String)"when acls = [], authorizer should fail close.", (boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        AccessControlEntry readAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        Set<AccessControlEntry> acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{readAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Assert.assertTrue((String)"User1 should have READ access from host1", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()));
        AccessControlEntry writeAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{writeAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        AccessControlEntry denyWriteOnWildCardResourceAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyWriteOnWildCardResourceAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assert.assertFalse((String)"User1 should not have WRITE access from host1", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.WRITE, this.resource()));
    }

    @Test
    public void testNoAclFound() {
        Assert.assertFalse((String)"when acls = [], authorizer should deny op.", (boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testNoAclFoundOverride() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(AclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (AclAuthorizer testAuthorizer = new AclAuthorizer();){
            testAuthorizer.configure(cfg.originals());
            Assert.assertTrue((String)"when acls = null or [],  authorizer should allow op with allow.everyone = true.", (boolean)this.authorize(testAuthorizer, this.requestContext(), AclOperation.READ, this.resource()));
        }
    }

    @Test
    public void testAclManagementAPIs() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        String host1 = "host1";
        String host2 = "host2";
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host1, AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user2.toString(), host2, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl4 = new AccessControlEntry(user2.toString(), host2, AclOperation.WRITE, AclPermissionType.ALLOW);
        Set<AccessControlEntry> acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        AccessControlEntry acl5 = new AccessControlEntry(user2.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        acls = this.changeAclAndVerify(acls, (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl5}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Object object = ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))).map((Function1 & Serializable & scala.Serializable)acl -> new AclBinding(this.resource(), acl), Set$.MODULE$.canBuildFrom());
            Set<AclBinding> set = this.getAcls(this.aclAuthorizer(), user1);
            return !(object != null ? !object.equals(set) : set != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "changes not propagated in timeout period", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Object object = ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3, acl4, acl5}))).map((Function1 & Serializable & scala.Serializable)acl -> new AclBinding(this.resource(), acl), Set$.MODULE$.canBuildFrom());
            Set<AclBinding> set = this.getAcls(this.aclAuthorizer(), user2);
            return !(object != null ? !object.equals(set) : set != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "changes not propagated in timeout period", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Map resourceToAcls = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.CLUSTER, "*", PatternType.LITERAL)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL)), acls), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.GROUP, "test-ConsumerGroup", PatternType.LITERAL)), acls)}));
        resourceToAcls.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ResourcePattern key = (ResourcePattern)tuple2._1();
            Set value = (Set)tuple2._2();
            Set<AccessControlEntry> set = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)value, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), key);
            return set;
        });
        Set expectedAcls = ((TraversableOnce)resourceToAcls.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.resource()), acls)).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ResourcePattern res = (ResourcePattern)tuple2._1();
            Set resAcls = (Set)tuple2._2();
            Set set = (Set)resAcls.map((Function1 & Serializable & scala.Serializable)acl -> new AclBinding(res, acl), Set$.MODULE$.canBuildFrom());
            return set;
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set set = expectedAcls;
            Set<AclBinding> set2 = this.getAcls(this.aclAuthorizer());
            return !(set != null ? !set.equals(set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "changes not propagated in timeout period.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        acls = this.changeAclAndVerify(acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl5}))), this.changeAclAndVerify$default$4());
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer(), this.resource());
        Assert.assertTrue((!this.zkClient().resourceExists(AuthorizerUtils$.MODULE$.convertToResource(this.resource())) ? 1 : 0) != 0);
        acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), acls, this.changeAclAndVerify$default$4());
        Assert.assertTrue((!this.zkClient().resourceExists(AuthorizerUtils$.MODULE$.convertToResource(this.resource())) ? 1 : 0) != 0);
    }

    @Test
    public void testLoadCache() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), "host-1", AclOperation.READ, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.resource());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, "test-2", PatternType.LITERAL);
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), "host3", AclOperation.READ, AclPermissionType.DENY);
        Set acls1 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)acls1, resource1);
        this.zkClient().deleteAclChangeNotifications();
        try (AclAuthorizer authorizer = new AclAuthorizer();){
            authorizer.configure(this.config().originals());
            Assert.assertEquals((Object)acls, this.getAcls(authorizer, this.resource()));
            Assert.assertEquals((Object)acls1, this.getAcls(authorizer, resource1));
        }
    }

    @Test
    public void testChangeListenerTiming() {
        Semaphore configureSemaphore = new Semaphore(0);
        Semaphore listenerSemaphore = new Semaphore(0);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AclAuthorizer aclAuthorizer3 = new AclAuthorizer(null, configureSemaphore, listenerSemaphore){
            private final Semaphore configureSemaphore$1;
            private final Semaphore listenerSemaphore$1;

            public void startZkChangeListeners() {
                this.configureSemaphore$1.release();
                this.listenerSemaphore$1.acquireUninterruptibly();
                super.startZkChangeListeners();
            }
            {
                this.configureSemaphore$1 = configureSemaphore$1;
                this.listenerSemaphore$1 = listenerSemaphore$1;
            }
        };
        try {
            Future<?> future = executor.submit(CoreUtils$.MODULE$.runnable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> aclAuthorizer3.configure(this.config().originals())));
            configureSemaphore.acquire();
            KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
            Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user1.toString(), "host-1", AclOperation.READ, AclPermissionType.DENY)}));
            this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.resource());
            listenerSemaphore.release();
            future.get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)acls, this.getAcls(aclAuthorizer3, this.resource()));
        }
        finally {
            aclAuthorizer3.close();
            executor.shutdownNow();
        }
    }

    @Test
    public void testLocalConcurrentModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), commonResource);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer(), commonResource);
    }

    @Test
    public void testDistributedConcurrentModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), commonResource);
        this.addAcls(this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer2(), commonResource);
        KafkaPrincipal user3 = new KafkaPrincipal("User", "joe");
        AccessControlEntry acl3 = new AccessControlEntry(user3.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3}))), commonResource);
        boolean deleted = this.removeAcls(this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3}))), commonResource);
        Assert.assertTrue((String)"The authorizer should see a value that needs to be deleted", (boolean)deleted);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer2(), commonResource);
    }

    @Test
    public void testHighConcurrencyModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        IndexedSeq acls = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable & scala.Serializable)i -> AclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq concurrentFuctions = (IndexedSeq)acls.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AccessControlEntry acl = (AccessControlEntry)tuple2._1();
            int aclId = tuple2._2$mcI$sp();
            Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> {
                if (aclId % 2 == 0) {
                    this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), commonResource);
                } else {
                    this.addAcls(this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), commonResource);
                }
                return aclId % 10 == 0 ? BoxesRunTime.boxToBoolean((boolean)this.removeAcls(this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), commonResource)) : BoxedUnit.UNIT;
            };
            return intersect;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Set expectedAcls = ((TraversableOnce)((TraversableLike)acls.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$4(x0$2)))).map((Function1 & Serializable & scala.Serializable)x$1 -> (AccessControlEntry)x$1._1(), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)expectedAcls, (Authorizer)this.aclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)expectedAcls, (Authorizer)this.aclAuthorizer2(), commonResource);
    }

    @Test
    public void testAclInheritance() {
        this.testImplicationsOfAllow(AclOperation.ALL, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE}))));
        this.testImplicationsOfDeny(AclOperation.ALL, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE}))));
        this.testImplicationsOfAllow(AclOperation.READ, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.WRITE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.DELETE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.ALTER, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfDeny(AclOperation.DESCRIBE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        this.testImplicationsOfAllow(AclOperation.ALTER_CONFIGS, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE_CONFIGS}))));
        this.testImplicationsOfDeny(AclOperation.DESCRIBE_CONFIGS, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
    }

    private void testImplicationsOfAllow(AclOperation parentOp, Set<AclOperation> allowedOps) {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.3.1");
        RequestContext hostContext = this.newRequestContext(user, host, this.newRequestContext$default$3());
        AccessControlEntry acl = new AccessControlEntry(user.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), parentOp, AclPermissionType.ALLOW);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), this.clusterResource());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])AclOperation.values())).filter((Function1 & Serializable & scala.Serializable)op -> BoxesRunTime.boxToBoolean((boolean)this.validOp(op))))).foreach((Function1 & Serializable & scala.Serializable)op -> {
            AclAuthorizerTest.$anonfun$testImplicationsOfAllow$2(this, hostContext, allowedOps, parentOp, op);
            return BoxedUnit.UNIT;
        });
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), this.clusterResource());
    }

    private void testImplicationsOfDeny(AclOperation parentOp, Set<AclOperation> deniedOps) {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user1.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), parentOp, AclPermissionType.DENY), new AccessControlEntry(user1.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW)}));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.clusterResource());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])AclOperation.values())).filter((Function1 & Serializable & scala.Serializable)op -> BoxesRunTime.boxToBoolean((boolean)this.validOp(op))))).foreach((Function1 & Serializable & scala.Serializable)op -> {
            AclAuthorizerTest.$anonfun$testImplicationsOfDeny$2(this, host1Context, deniedOps, parentOp, op);
            return BoxedUnit.UNIT;
        });
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.clusterResource());
    }

    @Test
    public void testHighConcurrencyDeletionOfResourceAcls() {
        AccessControlEntry acl = new AccessControlEntry(new KafkaPrincipal("User", this.username()).toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        IndexedSeq concurrentFuctions = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable & scala.Serializable)x$2 -> AclAuthorizerTest.$anonfun$testHighConcurrencyDeletionOfResourceAcls$1(this, acl, BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer(), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer2(), this.resource());
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnWildcardResource() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testDeleteAclOnWildcardResource() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.wildCardResource());
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()})), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
    }

    @Test
    public void testDeleteAllAclOnWildcardResource() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer()));
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnPrefixedResource() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testDeleteAclOnPrefixedResource() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()})), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testDeleteAllAclOnPrefixedResource() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.prefixedResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer()));
    }

    @Test
    public void testAddAclsOnLiteralResource() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.resource());
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.resource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.aclAuthorizer(), this.resource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnWildcardResource() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.wildCardResource());
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.wildCardResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.resource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnPrefixedResource() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.prefixedResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.resource()));
    }

    @Test
    public void testAuthorizeWithPrefixedResource() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.LITERAL));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.PREFIXED));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(8).append("foo-").append(UUID.randomUUID()).append("-zzz").toString(), PatternType.PREFIXED));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(5).append("fooo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("fo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("fop-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("fon-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "fon-", PatternType.PREFIXED));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testSingleCharacterResourceAcls() {
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL));
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL)));
        Assert.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL)));
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "_", PatternType.PREFIXED));
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_foo", PatternType.LITERAL)));
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_", PatternType.LITERAL)));
        Assert.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo_", PatternType.LITERAL)));
    }

    @Test
    public void testGetAclsPrincipal() {
        AccessControlEntry aclOnSpecificPrincipal = new AccessControlEntry(this.principal().toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnSpecificPrincipal}))), this.resource());
        Assert.assertEquals((String)"acl on specific should not be returned for wildcard request", (long)0L, (long)this.getAcls(this.aclAuthorizer(), this.wildcardPrincipal()).size());
        Assert.assertEquals((String)"acl on specific should be returned for specific request", (long)1L, (long)this.getAcls(this.aclAuthorizer(), this.principal()).size());
        Assert.assertEquals((String)"acl on specific should be returned for different principal instance", (long)1L, (long)this.getAcls(this.aclAuthorizer(), new KafkaPrincipal(this.principal().getPrincipalType(), this.principal().getName())).size());
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        AccessControlEntry aclOnWildcardPrincipal = new AccessControlEntry(AuthorizerUtils$.MODULE$.WildcardPrincipal(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnWildcardPrincipal}))), this.resource());
        Assert.assertEquals((String)"acl on wildcard should be returned for wildcard request", (long)1L, (long)this.getAcls(this.aclAuthorizer(), this.wildcardPrincipal()).size());
        Assert.assertEquals((String)"acl on wildcard should not be returned for specific request", (long)0L, (long)this.getAcls(this.aclAuthorizer(), this.principal()).size());
    }

    @Test
    public void testAclsFilter() {
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        AclBinding acl1 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding acl2 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW));
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(this.principal().toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(this.wildcardPrincipal().toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.aclAuthorizer().createAcls((AuthorizableRequestContext)this.requestContext(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)acl1, (List)new .colon.colon((Object)acl2, (List)new .colon.colon((Object)acl3, (List)new .colon.colon((Object)acl4, (List)Nil$.MODULE$))))).asJava());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2, acl3, acl4})), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(AclBindingFilter.ANY)).asScala()).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2})), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(new AclBindingFilter(resource1.toFilter(), AccessControlEntryFilter.ANY))).asScala()).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl4})), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(new AclBindingFilter(prefixedResource.toFilter(), AccessControlEntryFilter.ANY))).asScala()).toSet());
        AclBindingFilter matchingFilter = new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, resource2.name(), PatternType.MATCH), AccessControlEntryFilter.ANY);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4})), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(matchingFilter)).asScala()).toSet());
        .colon.colon filters = new .colon.colon((Object)matchingFilter, (List)new .colon.colon((Object)acl1.toFilter(), (List)new .colon.colon((Object)new AclBindingFilter(resource2.toFilter(), AccessControlEntryFilter.ANY), (List)new .colon.colon((Object)new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "baz", PatternType.ANY), AccessControlEntryFilter.ANY), (List)Nil$.MODULE$))));
        Buffer deleteResults = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.aclAuthorizer().deleteAcls((AuthorizableRequestContext)this.requestContext(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)filters).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> (AclDeleteResult)x$3.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)List$.MODULE$.empty(), (Object)deleteResults.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testAclsFilter$2(x$4))));
        filters.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(i)).aclBindingDeleteResults()).asScala()).toSet().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testAclsFilter$4(x$5)))));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(0)).aclBindingDeleteResults()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.aclBinding(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(1)).aclBindingDeleteResults()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.aclBinding(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(2)).aclBindingDeleteResults()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.aclBinding(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(3)).aclBindingDeleteResults()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.aclBinding(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testThrowsOnAddPrefixedAclIfInterBrokerProtocolVersionTooLow() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        ApiException e = (ApiException)((Object)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED)), ClassTag$.MODULE$.apply(ApiException.class), new Position("AclAuthorizerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725)));
        Assert.assertTrue((String)new StringBuilder(21).append("Unexpected exception ").append((Object)e).toString(), (boolean)(e.getCause() instanceof UnsupportedVersionException));
    }

    @Test
    public void testWritesExtendedAclChangeEventIfInterBrokerProtocolNotSet() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.empty());
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(AuthorizerUtils$.MODULE$.convertToResource(resource)).bytes(), StandardCharsets.UTF_8);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesExtendedAclChangeEventWhenInterBrokerProtocolAtLeastKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(AuthorizerUtils$.MODULE$.convertToResource(resource)).bytes(), StandardCharsets.UTF_8);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralWritesLiteralAclChangeEventWhenInterBrokerProtocolLessThanKafkaV2eralAclChangesForOlderProtocolVersions() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(AuthorizerUtils$.MODULE$.convertToResource(resource)).bytes(), StandardCharsets.UTF_8);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralAclChangeEventWhenInterBrokerProtocolIsKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(AuthorizerUtils$.MODULE$.convertToResource(resource)).bytes(), StandardCharsets.UTF_8);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private void givenAuthorizerWithProtocolVersion(Option<ApiVersion> protocolVersion) {
        this.aclAuthorizer().close();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(AclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        protocolVersion.foreach((Function1 & Serializable & scala.Serializable)version -> props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), version.toString()));
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.aclAuthorizer().configure(this.config().originals());
    }

    private String getAclChangeEventAsString(PatternType patternType) {
        ZkAclStore store = ZkAclStore$.MODULE$.apply(patternType);
        GetChildrenResponse children = (GetChildrenResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(store.changeStore().aclChangePath(), GetChildrenRequest$.MODULE$.apply$default$2()));
        children.maybeThrow();
        Assert.assertEquals((String)"Expecting 1 change event", (long)1L, (long)children.children().size());
        GetDataResponse data = (GetDataResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(new StringBuilder(1).append(store.changeStore().aclChangePath()).append("/").append(children.children().head()).toString(), GetDataRequest$.MODULE$.apply$default$2()));
        data.maybeThrow();
        return new String(data.data(), StandardCharsets.UTF_8);
    }

    private Set<AccessControlEntry> changeAclAndVerify(Set<AccessControlEntry> originalAcls, Set<AccessControlEntry> addedAcls, Set<AccessControlEntry> removedAcls, ResourcePattern resource) {
        Set acls = originalAcls;
        if (addedAcls.nonEmpty()) {
            this.addAcls(this.aclAuthorizer(), addedAcls, resource);
            acls = (Set)acls.$plus$plus(addedAcls);
        }
        if (removedAcls.nonEmpty()) {
            this.removeAcls(this.aclAuthorizer(), removedAcls, resource);
            acls = (Set)acls.$minus$minus(removedAcls);
        }
        TestUtils$.MODULE$.waitAndVerifyAcls(acls, (Authorizer)this.aclAuthorizer(), resource);
        return acls;
    }

    private ResourcePattern changeAclAndVerify$default$4() {
        return this.resource();
    }

    private RequestContext newRequestContext(KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        RequestHeader header = new RequestHeader(apiKey, 2, "", 1);
        return new RequestContext(header, "", clientAddress, principal, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
    }

    private ApiKeys newRequestContext$default$3() {
        return ApiKeys.PRODUCE;
    }

    private boolean authorize(AclAuthorizer authorizer, RequestContext requestContext, AclOperation operation, ResourcePattern resource) {
        Action action = new Action(operation, resource, 1, true, true);
        Object object = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(authorizer.authorize((AuthorizableRequestContext)requestContext, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)action, (List)Nil$.MODULE$)).asJava())).asScala()).head();
        AuthorizationResult authorizationResult = AuthorizationResult.ALLOWED;
        return !(object != null ? !object.equals(authorizationResult) : authorizationResult != null);
    }

    private void addAcls(AclAuthorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set bindings = (Set)aces.map((Function1 & Serializable & scala.Serializable)ace -> new AclBinding(resourcePattern, ace), Set$.MODULE$.canBuildFrom());
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(authorizer.createAcls((AuthorizableRequestContext)this.requestContext(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bindings.toList()).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> (AclCreateResult)x$10.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)result -> {
            AclAuthorizerTest.$anonfun$addAcls$3(result);
            return BoxedUnit.UNIT;
        });
    }

    private boolean removeAcls(AclAuthorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set bindings = aces.isEmpty() ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY)})) : (Set)aces.map((Function1 & Serializable & scala.Serializable)ace -> new AclBinding(resourcePattern, ace).toFilter(), Set$.MODULE$.canBuildFrom());
        return ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(authorizer.deleteAcls((AuthorizableRequestContext)this.requestContext(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bindings.toList()).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> (AclDeleteResult)x$11.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$removeAcls$3(result)));
    }

    private Set<AccessControlEntry> getAcls(AclAuthorizer authorizer, ResourcePattern resourcePattern) {
        Set acls = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY))).asScala()).toSet();
        return (Set)acls.map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.entry(), Set$.MODULE$.canBuildFrom());
    }

    private Set<AclBinding> getAcls(AclAuthorizer authorizer, KafkaPrincipal principal) {
        AclBindingFilter filter = new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(principal.toString(), null, AclOperation.ANY, AclPermissionType.ANY));
        return ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(filter)).asScala()).toSet();
    }

    private Set<AclBinding> getAcls(AclAuthorizer authorizer) {
        return ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(AclBindingFilter.ANY)).asScala()).toSet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validOp(AclOperation op) {
        AclOperation aclOperation = op;
        AclOperation aclOperation2 = AclOperation.ANY;
        if (aclOperation == null) {
            if (aclOperation2 == null) return false;
        } else if (aclOperation.equals(aclOperation2)) return false;
        AclOperation aclOperation3 = op;
        AclOperation aclOperation4 = AclOperation.UNKNOWN;
        if (aclOperation3 == null) {
            if (aclOperation4 == null) return false;
            return true;
        } else if (aclOperation3.equals(aclOperation4)) return false;
        return true;
    }

    public static final /* synthetic */ Tuple2 $anonfun$testHighConcurrencyModificationOfResourceAcls$1(int i) {
        KafkaPrincipal useri = new KafkaPrincipal("User", ((Object)BoxesRunTime.boxToInteger((int)i)).toString());
        return new Tuple2((Object)new AccessControlEntry(useri.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW), (Object)BoxesRunTime.boxToInteger((int)i));
    }

    public static final /* synthetic */ boolean $anonfun$testHighConcurrencyModificationOfResourceAcls$4(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int aclId = tuple2._2$mcI$sp();
        boolean bl = aclId % 10 != 0;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$testImplicationsOfAllow$2(AclAuthorizerTest $this, RequestContext hostContext$1, Set allowedOps$1, AclOperation parentOp$1, AclOperation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.authorize($this.aclAuthorizer(), hostContext$1, op, $this.clusterResource());
                if (allowedOps$1.contains((Object)op)) break block2;
                AclOperation aclOperation = op;
                AclOperation aclOperation2 = parentOp$1;
                if (aclOperation != null ? !aclOperation.equals(aclOperation2) : aclOperation2 != null) break block3;
            }
            Assert.assertTrue((String)new StringBuilder(26).append("ALLOW ").append(parentOp$1).append(" should imply ALLOW ").append(op).toString(), (boolean)authorized);
            return;
        }
        Assert.assertFalse((String)new StringBuilder(30).append("ALLOW ").append(parentOp$1).append(" should not imply ALLOW ").append(op).toString(), (boolean)authorized);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$testImplicationsOfDeny$2(AclAuthorizerTest $this, RequestContext host1Context$1, Set deniedOps$1, AclOperation parentOp$2, AclOperation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.authorize($this.aclAuthorizer(), host1Context$1, op, $this.clusterResource());
                if (deniedOps$1.contains((Object)op)) break block2;
                AclOperation aclOperation = op;
                AclOperation aclOperation2 = parentOp$2;
                if (aclOperation != null ? !aclOperation.equals(aclOperation2) : aclOperation2 != null) break block3;
            }
            Assert.assertFalse((String)new StringBuilder(24).append("DENY ").append(parentOp$2).append(" should imply DENY ").append(op).toString(), (boolean)authorized);
            return;
        }
        Assert.assertTrue((String)new StringBuilder(28).append("DENY ").append(parentOp$2).append(" should not imply DENY ").append(op).toString(), (boolean)authorized);
    }

    public static final /* synthetic */ Function0 $anonfun$testHighConcurrencyDeletionOfResourceAcls$1(AclAuthorizerTest $this, AccessControlEntry acl$2, int x$2) {
        return (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            $this.addAcls($this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl$2}))), $this.resource());
            return $this.removeAcls($this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl$2}))), $this.resource());
        };
    }

    public static final /* synthetic */ boolean $anonfun$testAclsFilter$2(AclDeleteResult x$4) {
        return x$4.exception().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testAclsFilter$4(AclDeleteResult.AclBindingDeleteResult x$5) {
        return x$5.exception().isPresent();
    }

    public static final /* synthetic */ void $anonfun$addAcls$3(AclCreateResult result) {
        OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(result.exception())).foreach((Function1 & Serializable & scala.Serializable)e -> {
            throw e;
        });
    }

    public static final /* synthetic */ void $anonfun$removeAcls$5(AclDeleteResult.AclBindingDeleteResult r) {
        OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(r.exception())).foreach((Function1 & Serializable & scala.Serializable)e -> {
            throw e;
        });
    }

    public static final /* synthetic */ boolean $anonfun$removeAcls$7(AclDeleteResult.AclBindingDeleteResult x$12) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$12.exception())).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$removeAcls$3(AclDeleteResult result) {
        OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(result.exception())).foreach((Function1 & Serializable & scala.Serializable)e -> {
            throw e;
        });
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(result.aclBindingDeleteResults()).asScala()).foreach((Function1 & Serializable & scala.Serializable)r -> {
            AclAuthorizerTest.$anonfun$removeAcls$5(r);
            return BoxedUnit.UNIT;
        });
        return ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(result.aclBindingDeleteResults()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$removeAcls$7(x$12)));
    }

    public AclAuthorizerTest() {
        this.superUsers = "User:superuser1; User:superuser2";
        this.username = "alice";
    }

    public class CustomPrincipal
    extends KafkaPrincipal {
        public boolean equals(Object o) {
            return false;
        }

        public /* synthetic */ AclAuthorizerTest kafka$security$authorizer$AclAuthorizerTest$CustomPrincipal$$$outer() {
            return AclAuthorizerTest.this;
        }

        public CustomPrincipal(String principalType, String name) {
            if (AclAuthorizerTest.this == null) {
                throw null;
            }
            super(principalType, name);
        }
    }
}

