/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.checkpoints;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.CheckpointFile;
import kafka.server.checkpoints.CheckpointFileFormatter;
import kafka.server.checkpoints.LazyOffsetCheckpoints;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00193A\u0001C\u0005\u0001!!)Q\u0004\u0001C\u0001=!)\u0011\u0005\u0001C\u0001E!)q\u0006\u0001C\u0001E!)\u0011\u0007\u0001C\u0001E!)1\u0007\u0001C\u0001E!)!\t\u0001C\u0001E!)A\t\u0001C\u0001E\tArJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016$Vm\u001d;\u000b\u0005)Y\u0011aC2iK\u000e\\\u0007o\\5oiNT!\u0001D\u0007\u0002\rM,'O^3s\u0015\u0005q\u0011!B6bM.\f7\u0001A\n\u0004\u0001E9\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\r\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\u001b\u0005)Q\u000f^5mg&\u0011A$\u0007\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t\u0011\"\u0001\u0014tQ>,H\u000e\u001a)feNL7\u000f^!oI>3XM]<sSR,\u0017I\u001c3SK2|\u0017\r\u001a$jY\u0016$\u0012a\t\t\u0003%\u0011J!!J\n\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\u001d\u0002\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\u000b),h.\u001b;\u000b\u00031\n1a\u001c:h\u0013\tq\u0013F\u0001\u0003UKN$\u0018!G:i_VdG\rS1oI2,W*\u001e7uSBdW\rT5oKND#aA\u0014\u0002AMDw.\u001e7e%\u0016$XO\u001d8F[B$\u00180T1q\r>\u0014X)\u001c9us\u001aKG.\u001a\u0015\u0003\t\u001d\n1e\u001d5pk2$G\u000b\u001b:po&3g+\u001a:tS>t\u0017j\u001d(piJ+7m\\4oSN,G\r\u000b\u0003\u0006OU2\u0014\u0001C3ya\u0016\u001cG/\u001a3$\u0003]\u0002\"\u0001\u000f!\u000e\u0003eR!AO\u001e\u0002\r\u0015\u0014(o\u001c:t\u0015\taT(\u0001\u0004d_6lwN\u001c\u0006\u0003\u001dyR!aP\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\t\u0015HA\u000bLC\u001a\\\u0017m\u0015;pe\u0006<W-\u0012=dKB$\u0018n\u001c8\u00021Q,7\u000f\u001e'buf|eMZ:fi\u000eCWmY6q_&tG\u000f\u000b\u0002\u0007O\u0005IC/Z:u\u0019\u0006T\u0018p\u00144gg\u0016$8\t[3dWB|\u0017N\u001c;GS2,\u0017J\u001c<bY&$Gj\\4ESJD#aB\u0014")
public class OffsetCheckpointFileTest
implements Logging {
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        OffsetCheckpointFileTest offsetCheckpointFileTest = this;
        synchronized (offsetCheckpointFileTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Test
    public void shouldPersistAndOverwriteAndReloadFile() {
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils$.MODULE$.tempFile(), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        Map offsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 2)), (Object)BoxesRunTime.boxToLong((long)10L))}));
        checkpoint.write(offsets);
        Assert.assertEquals((Object)offsets, (Object)checkpoint.read());
        Map offsets2 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)BoxesRunTime.boxToLong((long)15L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 3)), (Object)BoxesRunTime.boxToLong((long)20L))}));
        checkpoint.write(offsets2);
        Assert.assertEquals((Object)offsets2, (Object)checkpoint.read());
    }

    @Test
    public void shouldHandleMultipleLines() {
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils$.MODULE$.tempFile(), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        Map offsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 6)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 7)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 8)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 4)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 9)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 10)), (Object)BoxesRunTime.boxToLong((long)10L))}));
        checkpoint.write(offsets);
        Assert.assertEquals((Object)offsets, (Object)checkpoint.read());
    }

    @Test
    public void shouldReturnEmptyMapForEmptyFile() {
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils$.MODULE$.tempFile(), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)checkpoint.read());
        checkpoint.write((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)checkpoint.read());
    }

    @Test(expected=KafkaStorageException.class)
    public void shouldThrowIfVersionIsNotRecognised() {
        File file = TestUtils$.MODULE$.tempFile();
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        CheckpointFile checkpointFile = new CheckpointFile(file, OffsetCheckpointFile$.MODULE$.CurrentVersion() + 1, (CheckpointFileFormatter)OffsetCheckpointFile.Formatter$.MODULE$, logDirFailureChannel, file.getParent());
        checkpointFile.write((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)BoxesRunTime.boxToLong((long)10L))})));
        new OffsetCheckpointFile(checkpointFile.file(), logDirFailureChannel).read();
    }

    @Test
    public void testLazyOffsetCheckpoint() {
        String logDir = "/tmp/kafka-logs";
        OffsetCheckpointFile mockCheckpointFile = (OffsetCheckpointFile)Mockito.mock(OffsetCheckpointFile.class);
        LazyOffsetCheckpoints lazyCheckpoints = new LazyOffsetCheckpoints((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir), (Object)mockCheckpointFile)})));
        ((OffsetCheckpointFile)Mockito.verify((Object)mockCheckpointFile, (VerificationMode)Mockito.never())).read();
        TopicPartition partition0 = new TopicPartition("foo", 0);
        TopicPartition partition1 = new TopicPartition("foo", 1);
        TopicPartition partition2 = new TopicPartition("foo", 2);
        Mockito.when((Object)mockCheckpointFile.read()).thenReturn((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)BoxesRunTime.boxToLong((long)1000L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition1), (Object)BoxesRunTime.boxToLong((long)2000L))})));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)1000L)), (Object)lazyCheckpoints.fetch(logDir, partition0));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2000L)), (Object)lazyCheckpoints.fetch(logDir, partition1));
        Assert.assertEquals((Object)None$.MODULE$, (Object)lazyCheckpoints.fetch(logDir, partition2));
        ((OffsetCheckpointFile)Mockito.verify((Object)mockCheckpointFile, (VerificationMode)Mockito.times((int)1))).read();
    }

    @Test
    public void testLazyOffsetCheckpointFileInvalidLogDir() {
        String logDir = "/tmp/kafka-logs";
        OffsetCheckpointFile mockCheckpointFile = (OffsetCheckpointFile)Mockito.mock(OffsetCheckpointFile.class);
        LazyOffsetCheckpoints lazyCheckpoints = new LazyOffsetCheckpoints((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir), (Object)mockCheckpointFile)})));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> lazyCheckpoints.fetch("/invalid/kafka-logs", new TopicPartition("foo", 0)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("OffsetCheckpointFileTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
    }

    public OffsetCheckpointFileTest() {
        Logging.$init$((Logging)this);
    }
}

