/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509TrustManager;
import kafka.admin.BrokerMetadata;
import kafka.api.ApiVersion$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.api.Request$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.Partition;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.security.auth.Acl;
import kafka.security.auth.Resource;
import kafka.server.BrokerState;
import kafka.server.BrokerTopicStats;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.JaasTestUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.zk.AdminZkClient;
import kafka.zk.BrokerIdsZNode$;
import kafka.zk.BrokerInfo$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkData$;
import kafka.zk.ZkVersion$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;
import org.junit.Assert;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenSeq;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Properties$;

public final class TestUtils$
implements Logging {
    public static TestUtils$ MODULE$;
    private final Random random;
    private final int RandomPort;
    private final int IncorrectBrokerPort;
    private final int MockZkPort;
    private final String MockZkConnect;
    private final String SslCertificateCn;
    private final String kafka$utils$TestUtils$$transactionStatusKey;
    private final byte[] kafka$utils$TestUtils$$committedValue;
    private final byte[] kafka$utils$TestUtils$$abortedValue;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new TestUtils$();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        TestUtils$ testUtils$ = this;
        synchronized (testUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Random random() {
        return this.random;
    }

    public int RandomPort() {
        return this.RandomPort;
    }

    public int IncorrectBrokerPort() {
        return this.IncorrectBrokerPort;
    }

    public int MockZkPort() {
        return this.MockZkPort;
    }

    public String MockZkConnect() {
        return this.MockZkConnect;
    }

    public String SslCertificateCn() {
        return this.SslCertificateCn;
    }

    public String kafka$utils$TestUtils$$transactionStatusKey() {
        return this.kafka$utils$TestUtils$$transactionStatusKey;
    }

    public byte[] kafka$utils$TestUtils$$committedValue() {
        return this.kafka$utils$TestUtils$$committedValue;
    }

    public byte[] kafka$utils$TestUtils$$abortedValue() {
        return this.kafka$utils$TestUtils$$abortedValue;
    }

    public File tempDir() {
        return TestUtils.tempDirectory();
    }

    public String tempTopic() {
        return new java.lang.StringBuilder(9).append("testTopic").append(this.random().nextInt(1000000)).toString();
    }

    public File tempRelativeDir(String parent) {
        File parentFile = new File(parent);
        parentFile.mkdirs();
        return TestUtils.tempDirectory((Path)parentFile.toPath(), null);
    }

    /*
     * WARNING - void declaration
     */
    public File randomPartitionLogDir(File parentDir) {
        void var3_3;
        int attempts = 1000;
        File f = (File)scala.package$.MODULE$.Iterator().continually((Function0 & Serializable & scala.Serializable)() -> new File(parentDir, new java.lang.StringBuilder(6).append("kafka-").append(MODULE$.random().nextInt(1000000)).toString())).take(attempts).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.mkdir())).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new java.lang.StringBuilder(42).append("Failed to create directory after ").append(attempts).append(" attempts").toString()));
        f.deleteOnExit();
        return var3_3;
    }

    public File tempFile() {
        return TestUtils.tempFile();
    }

    public FileChannel tempChannel() {
        return FileChannel.open(this.tempFile().toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
    }

    public KafkaServer createServer(KafkaConfig config, Time time) {
        return this.createServer(config, time, (Option<String>)None$.MODULE$);
    }

    public KafkaServer createServer(KafkaConfig config, Option<String> threadNamePrefix) {
        return this.createServer(config, Time.SYSTEM, threadNamePrefix);
    }

    public KafkaServer createServer(KafkaConfig config, Time time, Option<String> threadNamePrefix) {
        KafkaServer server = new KafkaServer(config, time, threadNamePrefix, KafkaServer$.MODULE$.$lessinit$greater$default$4());
        server.startup();
        return server;
    }

    public Time createServer$default$2() {
        return Time.SYSTEM;
    }

    public int boundPort(KafkaServer server, SecurityProtocol securityProtocol) {
        return server.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol));
    }

    public SecurityProtocol boundPort$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Broker createBroker(int id, String host, int port, SecurityProtocol securityProtocol) {
        return new Broker(id, host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
    }

    public SecurityProtocol createBroker$default$4() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Tuple2<Broker, Object> createBrokerAndEpoch(int id, String host, int port, SecurityProtocol securityProtocol, long epoch) {
        return new Tuple2((Object)new Broker(id, host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol), (Object)BoxesRunTime.boxToLong((long)epoch));
    }

    public SecurityProtocol createBrokerAndEpoch$default$4() {
        return SecurityProtocol.PLAINTEXT;
    }

    public long createBrokerAndEpoch$default$5() {
        return 0L;
    }

    public Seq<Properties> createBrokerConfigs(int numConfigs, String zkConnect, boolean enableControlledShutdown, boolean enableDeleteTopic, Option<SecurityProtocol> interBrokerSecurityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, boolean enablePlaintext, boolean enableSsl, boolean enableSaslPlaintext, boolean enableSaslSsl, Map<Object, String> rackInfo, int logDirCount, boolean enableToken, int numPartitions, short defaultReplicationFactor) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numConfigs).map((Function1 & Serializable & scala.Serializable)node -> TestUtils$.$anonfun$createBrokerConfigs$1(zkConnect, enableControlledShutdown, enableDeleteTopic, interBrokerSecurityProtocol, trustStoreFile, saslProperties, enablePlaintext, enableSsl, enableSaslPlaintext, enableSaslSsl, rackInfo, logDirCount, enableToken, numPartitions, defaultReplicationFactor, BoxesRunTime.unboxToInt((Object)node)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public String getBrokerListStrFromServers(Seq<KafkaServer> servers, SecurityProtocol protocol) {
        return ((TraversableOnce)servers.map((Function1 & Serializable & scala.Serializable)s -> {
            EndPoint listener = (EndPoint)s.config().advertisedListeners().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$getBrokerListStrFromServers$2(protocol, x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new java.lang.StringBuilder(47).append("Could not find listener with security protocol ").append(protocol).toString()));
            return Utils.formatAddress((String)listener.host(), (Integer)Predef$.MODULE$.int2Integer(MODULE$.boundPort((KafkaServer)s, protocol)));
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public SecurityProtocol getBrokerListStrFromServers$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    public String bootstrapServers(Seq<KafkaServer> servers, ListenerName listenerName) {
        return ((TraversableOnce)servers.map((Function1 & Serializable & scala.Serializable)s -> {
            EndPoint listener = (EndPoint)s.config().advertisedListeners().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$bootstrapServers$2(listenerName, x$3))).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new java.lang.StringBuilder(34).append("Could not find listener with name ").append(listenerName.value()).toString()));
            return Utils.formatAddress((String)listener.host(), (Integer)Predef$.MODULE$.int2Integer(s.boundPort(listenerName)));
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public void shutdownServers(Seq<KafkaServer> servers) {
        Future future = Future$.MODULE$.traverse(servers, (Function1 & Serializable & scala.Serializable)s -> Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            s.shutdown();
            CoreUtils$.MODULE$.delete(s.config().logDirs());
        }, ExecutionContext.Implicits$.MODULE$.global()), Seq$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global());
        Await$.MODULE$.result((Awaitable)future, (Duration)FiniteDuration$.MODULE$.apply(5L, TimeUnit.MINUTES));
    }

    public Properties createBrokerConfig(int nodeId, String zkConnect, boolean enableControlledShutdown, boolean enableDeleteTopic, int port, Option<SecurityProtocol> interBrokerSecurityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, boolean enablePlaintext, boolean enableSaslPlaintext, int saslPlaintextPort, boolean enableSsl, int sslPort, boolean enableSaslSsl, int saslSslPort, Option<String> rack, int logDirCount, boolean enableToken, int numPartitions, short defaultReplicationFactor) {
        Object object;
        ArrayBuffer protocolAndPorts = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Object object2 = enablePlaintext || TestUtils$.shouldEnable$1(SecurityProtocol.PLAINTEXT, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)BoxesRunTime.boxToInteger((int)port))) : BoxedUnit.UNIT;
        Object object3 = enableSsl || TestUtils$.shouldEnable$1(SecurityProtocol.SSL, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SSL), (Object)BoxesRunTime.boxToInteger((int)sslPort))) : BoxedUnit.UNIT;
        Object object4 = enableSaslPlaintext || TestUtils$.shouldEnable$1(SecurityProtocol.SASL_PLAINTEXT, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SASL_PLAINTEXT), (Object)BoxesRunTime.boxToInteger((int)saslPlaintextPort))) : BoxedUnit.UNIT;
        Object object5 = enableSaslSsl || TestUtils$.shouldEnable$1(SecurityProtocol.SASL_SSL, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SASL_SSL), (Object)BoxesRunTime.boxToInteger((int)saslSslPort))) : BoxedUnit.UNIT;
        String listeners = ((TraversableOnce)protocolAndPorts.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SecurityProtocol protocol = (SecurityProtocol)tuple2._1();
            int port = tuple2._2$mcI$sp();
            String string = new java.lang.StringBuilder(13).append(protocol.name).append("://localhost:").append(port).toString();
            return string;
        }, ArrayBuffer$.MODULE$.canBuildFrom())).mkString(",");
        Properties props = new Properties();
        Object object6 = nodeId >= 0 ? props.put(KafkaConfig$.MODULE$.BrokerIdProp(), ((Object)BoxesRunTime.boxToInteger((int)nodeId)).toString()) : BoxedUnit.UNIT;
        props.put(KafkaConfig$.MODULE$.ListenersProp(), listeners);
        if (logDirCount > 1) {
            String logDirs = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), logDirCount).toList().map((Function1 & Serializable & scala.Serializable)i -> TestUtils$.$anonfun$createBrokerConfig$4(BoxesRunTime.unboxToInt((Object)i)), List$.MODULE$.canBuildFrom())).mkString(",");
            object = props.put(KafkaConfig$.MODULE$.LogDirsProp(), logDirs);
        } else {
            object = props.put(KafkaConfig$.MODULE$.LogDirProp(), this.tempDir().getAbsolutePath());
        }
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), zkConnect);
        props.put(KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp(), "10000");
        props.put(KafkaConfig$.MODULE$.ReplicaSocketTimeoutMsProp(), "1500");
        props.put(KafkaConfig$.MODULE$.ControllerSocketTimeoutMsProp(), "1500");
        props.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)enableControlledShutdown)).toString());
        props.put(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)enableDeleteTopic)).toString());
        props.put(KafkaConfig$.MODULE$.LogDeleteDelayMsProp(), "1000");
        props.put(KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp(), "100");
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "2097152");
        props.put(KafkaConfig$.MODULE$.LogMessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        props.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
        Object object7 = !props.containsKey(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp()) ? props.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "5") : BoxedUnit.UNIT;
        Object object8 = !props.containsKey(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp()) ? props.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0") : BoxedUnit.UNIT;
        rack.foreach((Function1 & Serializable & scala.Serializable)x$5 -> props.put(KafkaConfig$.MODULE$.RackProp(), x$5));
        if (protocolAndPorts.exists((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$createBrokerConfig$6(x0$2)))) {
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(this.sslConfigs(Mode.SERVER, false, trustStoreFile, new java.lang.StringBuilder(6).append("server").append(nodeId).toString(), this.sslConfigs$default$5()));
        }
        if (protocolAndPorts.exists((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$createBrokerConfig$7(x0$3)))) {
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(JaasTestUtils$.MODULE$.saslConfigs(saslProperties));
        }
        interBrokerSecurityProtocol.foreach((Function1 & Serializable & scala.Serializable)protocol -> props.put(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp(), protocol.name));
        Object object9 = enableToken ? props.put(KafkaConfig$.MODULE$.DelegationTokenMasterKeyProp(), "masterkey") : BoxedUnit.UNIT;
        props.put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString());
        props.put(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), ((Object)BoxesRunTime.boxToShort((short)defaultReplicationFactor)).toString());
        return props;
    }

    public boolean createBrokerConfigs$default$3() {
        return true;
    }

    public boolean createBrokerConfigs$default$4() {
        return true;
    }

    public Option<SecurityProtocol> createBrokerConfigs$default$5() {
        return None$.MODULE$;
    }

    public Option<File> createBrokerConfigs$default$6() {
        return None$.MODULE$;
    }

    public Option<Properties> createBrokerConfigs$default$7() {
        return None$.MODULE$;
    }

    public boolean createBrokerConfigs$default$8() {
        return true;
    }

    public boolean createBrokerConfigs$default$9() {
        return false;
    }

    public boolean createBrokerConfigs$default$10() {
        return false;
    }

    public boolean createBrokerConfigs$default$11() {
        return false;
    }

    public Map<Object, String> createBrokerConfigs$default$12() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public int createBrokerConfigs$default$13() {
        return 1;
    }

    public boolean createBrokerConfigs$default$14() {
        return false;
    }

    public int createBrokerConfigs$default$15() {
        return 1;
    }

    public short createBrokerConfigs$default$16() {
        return 1;
    }

    public boolean createBrokerConfig$default$3() {
        return true;
    }

    public boolean createBrokerConfig$default$4() {
        return true;
    }

    public int createBrokerConfig$default$5() {
        return this.RandomPort();
    }

    public Option<SecurityProtocol> createBrokerConfig$default$6() {
        return None$.MODULE$;
    }

    public Option<File> createBrokerConfig$default$7() {
        return None$.MODULE$;
    }

    public Option<Properties> createBrokerConfig$default$8() {
        return None$.MODULE$;
    }

    public boolean createBrokerConfig$default$9() {
        return true;
    }

    public boolean createBrokerConfig$default$10() {
        return false;
    }

    public int createBrokerConfig$default$11() {
        return this.RandomPort();
    }

    public boolean createBrokerConfig$default$12() {
        return false;
    }

    public int createBrokerConfig$default$13() {
        return this.RandomPort();
    }

    public boolean createBrokerConfig$default$14() {
        return false;
    }

    public int createBrokerConfig$default$15() {
        return this.RandomPort();
    }

    public Option<String> createBrokerConfig$default$16() {
        return None$.MODULE$;
    }

    public int createBrokerConfig$default$17() {
        return 1;
    }

    public boolean createBrokerConfig$default$18() {
        return false;
    }

    public int createBrokerConfig$default$19() {
        return 1;
    }

    public short createBrokerConfig$default$20() {
        return 1;
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(KafkaZkClient zkClient, String topic, int numPartitions, int replicationFactor, Seq<KafkaServer> servers, Properties topicConfig) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean hasSessionExpirationException = false;
            try {
                adminZkClient.createTopic(topic, numPartitions, replicationFactor, topicConfig, adminZkClient.createTopic$default$5());
            }
            catch (KeeperException.SessionExpiredException sessionExpiredException) {
                hasSessionExpirationException = true;
            }
            catch (Throwable e) {
                throw e;
            }
            return !hasSessionExpirationException;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(19).append("Can't create topic ").append(topic).toString(), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable & scala.Serializable)i -> TestUtils$.$anonfun$createTopic$3(servers, topic, zkClient, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(KafkaZkClient zkClient, String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Seq<KafkaServer> servers) {
        return this.createTopic(zkClient, topic, partitionReplicaAssignment, servers, new Properties());
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(KafkaZkClient zkClient, String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Seq<KafkaServer> servers, Properties topicConfig) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean hasSessionExpirationException = false;
            try {
                adminZkClient.createTopicWithAssignment(topic, topicConfig, partitionReplicaAssignment);
            }
            catch (KeeperException.SessionExpiredException sessionExpiredException) {
                hasSessionExpirationException = true;
            }
            catch (Throwable e) {
                throw e;
            }
            return !hasSessionExpirationException;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(19).append("Can't create topic ").append(topic).toString(), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        return ((TraversableOnce)partitionReplicaAssignment.keySet().map((Function1 & Serializable & scala.Serializable)i -> TestUtils$.$anonfun$createTopic$6(servers, topic, zkClient, BoxesRunTime.unboxToInt((Object)i)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public int createTopic$default$3() {
        return 1;
    }

    public int createTopic$default$4() {
        return 1;
    }

    public Properties createTopic$default$6() {
        return new Properties();
    }

    public void createOffsetsTopic(KafkaZkClient zkClient, Seq<KafkaServer> servers) {
        KafkaServer server = (KafkaServer)servers.head();
        this.createTopic(zkClient, "__consumer_offsets", Predef$.MODULE$.Integer2int(server.config().getInt(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp())), Predef$.MODULE$.Short2short(server.config().getShort(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp())), servers, server.groupCoordinator().offsetsTopicConfigs());
    }

    public MemoryRecords singletonRecords(byte[] value, byte[] key, CompressionType codec, long timestamp, byte magicValue) {
        return this.records((Iterable<SimpleRecord>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(timestamp, key, value)}))), magicValue, codec, this.records$default$4(), this.records$default$5(), this.records$default$6(), this.records$default$7(), this.records$default$8());
    }

    public byte[] singletonRecords$default$2() {
        return null;
    }

    public CompressionType singletonRecords$default$3() {
        return CompressionType.NONE;
    }

    public long singletonRecords$default$4() {
        return -1L;
    }

    public byte singletonRecords$default$5() {
        return 2;
    }

    public MemoryRecords recordsWithValues(byte magicValue, CompressionType codec, Seq<byte[]> values) {
        return this.records((Iterable<SimpleRecord>)((Iterable)values.map((Function1 & Serializable & scala.Serializable)value -> new SimpleRecord(value), Seq$.MODULE$.canBuildFrom())), magicValue, codec, this.records$default$4(), this.records$default$5(), this.records$default$6(), this.records$default$7(), this.records$default$8());
    }

    public MemoryRecords records(Iterable<SimpleRecord> records, byte magicValue, CompressionType codec, long producerId, short producerEpoch, int sequence, long baseOffset, int partitionLeaderEpoch) {
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset, (long)System.currentTimeMillis(), (long)producerId, (short)producerEpoch, (int)sequence, (boolean)false, (int)partitionLeaderEpoch);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.append(x$1));
        return builder.build();
    }

    public byte records$default$2() {
        return 2;
    }

    public CompressionType records$default$3() {
        return CompressionType.NONE;
    }

    public long records$default$4() {
        return -1L;
    }

    public short records$default$5() {
        return -1;
    }

    public int records$default$6() {
        return -1;
    }

    public long records$default$7() {
        return 0L;
    }

    public int records$default$8() {
        return -1;
    }

    public byte[] randomBytes(int numBytes) {
        return TestUtils.randomBytes((int)numBytes);
    }

    public String randomString(int len) {
        return TestUtils.randomString((int)len);
    }

    public void checkEquals(ByteBuffer b1, ByteBuffer b2) {
        Assert.assertEquals((String)"Buffers should have equal length", (long)(b1.limit() - b1.position()), (long)(b2.limit() - b2.position()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), b1.limit() - b1.position()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((String)new java.lang.StringBuilder(21).append("byte ").append(i).append(" byte not equal.").toString(), (long)b1.get(b1.position() + i), (long)b2.get(b1.position() + i)));
    }

    public <T> void checkEquals(Iterator<T> expected, Iterator<T> actual) {
        block4: {
            int length = 0;
            while (expected.hasNext() && actual.hasNext()) {
                ++length;
                Assert.assertEquals((Object)expected.next(), (Object)actual.next());
            }
            if (expected.hasNext()) {
                int length1 = length;
                while (expected.hasNext()) {
                    expected.next();
                    ++length1;
                }
                Assert.assertFalse((String)new java.lang.StringBuilder(50).append("Iterators have uneven length-- first has more: ").append(length1).append(" > ").append(length).toString(), (boolean)true);
            }
            if (!actual.hasNext()) break block4;
            int length2 = length;
            while (actual.hasNext()) {
                actual.next();
                ++length2;
            }
            Assert.assertFalse((String)new java.lang.StringBuilder(51).append("Iterators have uneven length-- second has more: ").append(length2).append(" > ").append(length).toString(), (boolean)true);
        }
    }

    public <T> void checkLength(Iterator<T> s1, int expectedLength) {
        int n = 0;
        while (s1.hasNext()) {
            ++n;
            s1.next();
        }
        Assert.assertEquals((long)expectedLength, (long)n);
    }

    public <T> void checkEquals(java.util.Iterator<T> s1, java.util.Iterator<T> s2) {
        while (s1.hasNext() && s2.hasNext()) {
            Assert.assertEquals(s1.next(), s2.next());
        }
        Assert.assertFalse((String)"Iterators have uneven length--first has more", (boolean)s1.hasNext());
        Assert.assertFalse((String)"Iterators have uneven length--second has more", (boolean)s2.hasNext());
    }

    public <T> Iterator<T> stackedIterator(Seq<Iterator<T>> s) {
        return new Iterator<T>(s){
            private Iterator<T> cur;
            private final Iterator<Iterator<T>> topIterator;

            public Iterator<T> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<T> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<T> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<T> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<T> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<T, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<T, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<T> filter(Function1<T, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<T, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<T> withFilter(Function1<T, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<T> filterNot(Function1<T, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<T, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, T, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<T, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<T> takeWhile(Function1<T, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> partition(Function1<T, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> span(Function1<T, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<T> dropWhile(Function1<T, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<T, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<T, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<T, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<T, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<T, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<T> find(Function1<T, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<T, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<T, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<T> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<T>, Iterator<T>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<T> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<T> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<T> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<T> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<T, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<T, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, T, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<T, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, T, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<T, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, T, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public <B> T min(Ordering<B> cmp) {
                return (T)TraversableOnce.min$((TraversableOnce)this, cmp);
            }

            public <B> T max(Ordering<B> cmp) {
                return (T)TraversableOnce.max$((TraversableOnce)this, cmp);
            }

            public <B> T maxBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.maxBy$((TraversableOnce)this, f, cmp);
            }

            public <B> T minBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.minBy$((TraversableOnce)this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<T> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<T> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<T> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<T> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<T> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, T, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<T, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            private Iterator<T> cur() {
                return this.cur;
            }

            private void cur_$eq(Iterator<T> x$1) {
                this.cur = x$1;
            }

            private Iterator<Iterator<T>> topIterator() {
                return this.topIterator;
            }

            public boolean hasNext() {
                while (true) {
                    if (this.cur() == null) {
                        if (this.topIterator().hasNext()) {
                            this.cur_$eq((Iterator)this.topIterator().next());
                        } else {
                            return false;
                        }
                    }
                    if (this.cur().hasNext()) {
                        return true;
                    }
                    this.cur_$eq(null);
                }
            }

            public T next() {
                return (T)this.cur().next();
            }
            {
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                this.cur = null;
                this.topIterator = s$2.iterator();
            }
        };
    }

    public String hexString(byte[] bytes) {
        return this.hexString(ByteBuffer.wrap(bytes));
    }

    public String hexString(ByteBuffer buffer) {
        StringBuilder builder = new StringBuilder("0x");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), buffer.limit()).foreach((Function1 & Serializable & scala.Serializable)i -> builder.append(String.format("%x", buffer.get(buffer.position() + BoxesRunTime.unboxToInt((Object)i)))));
        return builder.toString();
    }

    public Properties securityConfigs(Mode mode, SecurityProtocol securityProtocol, Option<File> trustStoreFile, String certAlias, String certCn, Option<Properties> saslProperties) {
        Properties props = new Properties();
        if (this.usesSslTransportLayer(securityProtocol)) {
            SecurityProtocol securityProtocol2 = securityProtocol;
            SecurityProtocol securityProtocol3 = SecurityProtocol.SSL;
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(this.sslConfigs(mode, !(securityProtocol2 != null ? !securityProtocol2.equals(securityProtocol3) : securityProtocol3 != null), trustStoreFile, certAlias, certCn));
        }
        if (this.usesSaslAuthentication(securityProtocol)) {
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(JaasTestUtils$.MODULE$.saslConfigs(saslProperties));
        }
        props.put("security.protocol", securityProtocol.name);
        return props;
    }

    public Properties producerSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "producer", this.SslCertificateCn(), saslProperties);
    }

    public <K, V> KafkaProducer<K, V> createProducer(String brokerList, int acks, long maxBlockMs, long bufferSize, int retries, int deliveryTimeoutMs, int lingerMs, int batchSize, String compressionType, int requestTimeoutMs, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", brokerList);
        producerProps.put("acks", ((Object)BoxesRunTime.boxToInteger((int)acks)).toString());
        producerProps.put("max.block.ms", ((Object)BoxesRunTime.boxToLong((long)maxBlockMs)).toString());
        producerProps.put("buffer.memory", ((Object)BoxesRunTime.boxToLong((long)bufferSize)).toString());
        producerProps.put("retries", ((Object)BoxesRunTime.boxToInteger((int)retries)).toString());
        producerProps.put("delivery.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)deliveryTimeoutMs)).toString());
        producerProps.put("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)requestTimeoutMs)).toString());
        producerProps.put("linger.ms", ((Object)BoxesRunTime.boxToInteger((int)lingerMs)).toString());
        producerProps.put("batch.size", ((Object)BoxesRunTime.boxToInteger((int)batchSize)).toString());
        producerProps.put("compression.type", compressionType);
        Implicits$.MODULE$.PropertiesOps(producerProps).$plus$plus$eq(this.producerSecurityConfigs(securityProtocol, trustStoreFile, saslProperties));
        return new KafkaProducer(producerProps, keySerializer, valueSerializer);
    }

    public <K, V> int createProducer$default$2() {
        return -1;
    }

    public <K, V> long createProducer$default$3() {
        return 60000L;
    }

    public <K, V> long createProducer$default$4() {
        return 0x100000L;
    }

    public <K, V> int createProducer$default$5() {
        return Integer.MAX_VALUE;
    }

    public <K, V> int createProducer$default$6() {
        return 30000;
    }

    public <K, V> int createProducer$default$7() {
        return 0;
    }

    public <K, V> int createProducer$default$8() {
        return 16384;
    }

    public <K, V> String createProducer$default$9() {
        return "none";
    }

    public <K, V> int createProducer$default$10() {
        return 20000;
    }

    public <K, V> SecurityProtocol createProducer$default$11() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V> Option<File> createProducer$default$12() {
        return None$.MODULE$;
    }

    public <K, V> Option<Properties> createProducer$default$13() {
        return None$.MODULE$;
    }

    public <K, V> ByteArraySerializer createProducer$default$14() {
        return new ByteArraySerializer();
    }

    public <K, V> ByteArraySerializer createProducer$default$15() {
        return new ByteArraySerializer();
    }

    public boolean usesSslTransportLayer(SecurityProtocol securityProtocol) {
        SecurityProtocol securityProtocol2 = securityProtocol;
        boolean bl = SecurityProtocol.SSL.equals(securityProtocol2) ? true : SecurityProtocol.SASL_SSL.equals(securityProtocol2);
        boolean bl2 = bl;
        return bl2;
    }

    public boolean usesSaslAuthentication(SecurityProtocol securityProtocol) {
        SecurityProtocol securityProtocol2 = securityProtocol;
        boolean bl = SecurityProtocol.SASL_PLAINTEXT.equals(securityProtocol2) ? true : SecurityProtocol.SASL_SSL.equals(securityProtocol2);
        boolean bl2 = bl;
        return bl2;
    }

    public Properties consumerSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "consumer", this.SslCertificateCn(), saslProperties);
    }

    public Properties adminClientSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "admin-client", this.SslCertificateCn(), saslProperties);
    }

    public <K, V> KafkaConsumer<K, V> createConsumer(String brokerList, String groupId, String autoOffsetReset, boolean enableAutoCommit, boolean readCommitted, int maxPollRecords, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        Properties consumerProps = new Properties();
        consumerProps.put("bootstrap.servers", brokerList);
        consumerProps.put("auto.offset.reset", autoOffsetReset);
        consumerProps.put("group.id", groupId);
        consumerProps.put("enable.auto.commit", ((Object)BoxesRunTime.boxToBoolean((boolean)enableAutoCommit)).toString());
        consumerProps.put("max.poll.records", ((Object)BoxesRunTime.boxToInteger((int)maxPollRecords)).toString());
        consumerProps.put("isolation.level", readCommitted ? "read_committed" : "read_uncommitted");
        Implicits$.MODULE$.PropertiesOps(consumerProps).$plus$plus$eq(this.consumerSecurityConfigs(securityProtocol, trustStoreFile, saslProperties));
        return new KafkaConsumer(consumerProps, keyDeserializer, valueDeserializer);
    }

    public <K, V> String createConsumer$default$2() {
        return "group";
    }

    public <K, V> String createConsumer$default$3() {
        return "earliest";
    }

    public <K, V> boolean createConsumer$default$4() {
        return true;
    }

    public <K, V> boolean createConsumer$default$5() {
        return false;
    }

    public <K, V> int createConsumer$default$6() {
        return 500;
    }

    public <K, V> SecurityProtocol createConsumer$default$7() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V> Option<File> createConsumer$default$8() {
        return None$.MODULE$;
    }

    public <K, V> Option<Properties> createConsumer$default$9() {
        return None$.MODULE$;
    }

    public <K, V> ByteArrayDeserializer createConsumer$default$10() {
        return new ByteArrayDeserializer();
    }

    public <K, V> ByteArrayDeserializer createConsumer$default$11() {
        return new ByteArrayDeserializer();
    }

    public Seq<Broker> createBrokersInZk(KafkaZkClient zkClient, Seq<Object> ids) {
        return this.createBrokersInZk((Seq<BrokerMetadata>)((Seq)ids.map((Function1 & Serializable & scala.Serializable)x$6 -> TestUtils$.$anonfun$createBrokersInZk$1(BoxesRunTime.unboxToInt((Object)x$6)), Seq$.MODULE$.canBuildFrom())), zkClient);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Broker> createBrokersInZk(Seq<BrokerMetadata> brokerMetadatas, KafkaZkClient zkClient) {
        void var3_3;
        zkClient.makeSurePersistentPathExists(BrokerIdsZNode$.MODULE$.path());
        Seq brokers = (Seq)brokerMetadatas.map((Function1 & Serializable & scala.Serializable)b -> {
            SecurityProtocol protocol = SecurityProtocol.PLAINTEXT;
            ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)protocol);
            return new Broker(b.id(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{new EndPoint("localhost", 6667, listenerName, protocol)})), b.rack());
        }, Seq$.MODULE$.canBuildFrom());
        brokers.foreach((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToLong((long)zkClient.registerBroker(BrokerInfo$.MODULE$.apply(new Broker(b.id(), b.endPoints(), b.rack()), ApiVersion$.MODULE$.latestVersion(), -1))));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Broker> deleteBrokersInZk(KafkaZkClient zkClient, Seq<Object> ids) {
        void var3_3;
        Seq brokers = (Seq)ids.map((Function1 & Serializable & scala.Serializable)x$7 -> TestUtils$.MODULE$.createBroker(BoxesRunTime.unboxToInt((Object)x$7), "localhost", 6667, SecurityProtocol.PLAINTEXT), Seq$.MODULE$.canBuildFrom());
        ids.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)b -> zkClient.deletePath(new java.lang.StringBuilder(1).append(BrokerIdsZNode$.MODULE$.path()).append("/").append(b).toString(), zkClient.deletePath$default$2(), zkClient.deletePath$default$3()));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> getMsgStrings(int n) {
        void var2_2;
        ListBuffer buffer = new ListBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach((Function1 & Serializable & scala.Serializable)i -> buffer.$plus$eq((Object)new java.lang.StringBuilder(3).append("msg").append(BoxesRunTime.unboxToInt((Object)i)).toString()));
        return var2_2;
    }

    public void makeLeaderForPartition(KafkaZkClient zkClient, String topic, scala.collection.immutable.Map<Object, Object> leaderPerPartitionMap, int controllerEpoch) {
        scala.collection.immutable.Map newLeaderIsrAndControllerEpochs = (scala.collection.immutable.Map)leaderPerPartitionMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int partition = tuple2._1$mcI$sp();
            int leader = tuple2._2$mcI$sp();
            TopicPartition topicPartition = new TopicPartition(topic, partition);
            LeaderAndIsr newLeaderAndIsr = (LeaderAndIsr)zkClient.getTopicPartitionState(topicPartition).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.leaderAndIsr().newLeader(leader)).getOrElse((Function0 & Serializable & scala.Serializable)() -> LeaderAndIsr$.MODULE$.apply(leader, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}))));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new LeaderIsrAndControllerEpoch(newLeaderAndIsr, controllerEpoch));
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        zkClient.setTopicPartitionStatesRaw((Map)newLeaderIsrAndControllerEpochs, ZkVersion$.MODULE$.MatchAnyVersion());
    }

    /*
     * Unable to fully structure code
     */
    public int waitUntilLeaderIsElectedOrChanged(KafkaZkClient zkClient, String topic, int partition, long timeoutMs, Option<Object> oldLeaderOpt, Option<Object> newLeaderOpt) {
        Predef$.MODULE$.require(oldLeaderOpt.isDefined() == false || newLeaderOpt.isDefined() == false, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$1(), ()Ljava/lang/String;)());
        startTime = System.currentTimeMillis();
        topicPartition = new TopicPartition(topic, partition);
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$2(org.apache.kafka.common.TopicPartition scala.Option scala.Option ), ()Ljava/lang/String;)((TopicPartition)topicPartition, oldLeaderOpt, newLeaderOpt));
        leader = ObjectRef.create((Object)None$.MODULE$);
        electedOrChangedLeader = None$.MODULE$;
        while (electedOrChangedLeader.isEmpty() && System.currentTimeMillis() < startTime + timeoutMs) {
            block9: {
                block5: {
                    block7: {
                        block8: {
                            block6: {
                                leader.elem = zkClient.getLeaderForPartition(topicPartition);
                                var15_13 = (Option)leader.elem;
                                if (!(var15_13 instanceof Some)) break block5;
                                var16_14 = (Some)var15_13;
                                l = BoxesRunTime.unboxToInt((Object)var16_14.value());
                                var18_16 = new Tuple2(newLeaderOpt, oldLeaderOpt);
                                if (var18_16 == null || !((var19_17 = (Option)var18_16._1()) instanceof Some) || (newLeader = BoxesRunTime.unboxToInt((Object)(var20_18 = (Some)var19_17).value())) != l) break block6;
                                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$3(int org.apache.kafka.common.TopicPartition ), ()Ljava/lang/String;)((int)l, (TopicPartition)topicPartition));
                                electedOrChangedLeader = (Option)leader.elem;
                                var9_12 = BoxedUnit.UNIT;
                                break block7;
                            }
                            if (var18_16 == null || !((var22_20 = (Option)var18_16._2()) instanceof Some) || (oldLeader = BoxesRunTime.unboxToInt((Object)(var23_21 = (Some)var22_20).value())) == l) break block8;
                            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$4(org.apache.kafka.common.TopicPartition int int ), ()Ljava/lang/String;)((TopicPartition)topicPartition, (int)oldLeader, (int)l));
                            electedOrChangedLeader = (Option)leader.elem;
                            var9_12 = BoxedUnit.UNIT;
                            break block7;
                        }
                        if (var18_16 == null) ** GOTO lbl-1000
                        var25_23 = (Option)var18_16._1();
                        var26_24 = (Option)var18_16._2();
                        if (None$.MODULE$.equals(var25_23) && None$.MODULE$.equals(var26_24)) {
                            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$5(int org.apache.kafka.common.TopicPartition ), ()Ljava/lang/String;)((int)l, (TopicPartition)topicPartition));
                            electedOrChangedLeader = (Option)leader.elem;
                            var9_12 = BoxedUnit.UNIT;
                        } else lbl-1000:
                        // 2 sources

                        {
                            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$6(org.apache.kafka.common.TopicPartition int ), ()Ljava/lang/String;)((TopicPartition)topicPartition, (int)l));
                            var9_12 = BoxedUnit.UNIT;
                        }
                    }
                    var8_11 = BoxedUnit.UNIT;
                    break block9;
                }
                if (None$.MODULE$.equals(var15_13)) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$7(org.apache.kafka.common.TopicPartition ), ()Ljava/lang/String;)((TopicPartition)topicPartition));
                    var8_11 = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)var15_13);
                }
            }
            Thread.sleep(package$.MODULE$.min(timeoutMs, 100L));
        }
        return BoxesRunTime.unboxToInt((Object)electedOrChangedLeader.getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$8(scala.Option scala.Option long org.apache.kafka.common.TopicPartition scala.runtime.ObjectRef ), ()Lscala/runtime/Nothing$;)(newLeaderOpt, oldLeaderOpt, (long)timeoutMs, (TopicPartition)topicPartition, (ObjectRef)leader)));
    }

    public long waitUntilLeaderIsElectedOrChanged$default$4() {
        return 30000L;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged$default$6() {
        return None$.MODULE$;
    }

    public void retry(long maxWaitMs, Function0<BoxedUnit> block) {
        LongRef wait = LongRef.create((long)1L);
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                block.apply$mcV$sp();
                return;
            }
            catch (AssertionError e) {
                long elapsed = System.currentTimeMillis() - startTime;
                if (elapsed > maxWaitMs) {
                    throw e;
                }
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(49).append("Attempt failed, sleeping for ").append(wait$1.elem).append(", and then retrying.").toString());
                Thread.sleep(wait.elem);
                wait.elem += package$.MODULE$.min(wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public void pollUntilTrue(Consumer<?, ?> consumer, Function0<Object> action, Function0<String> msg, long waitTimeMs) {
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$1 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(java.time.Duration.ofMillis(100L));
            return action.apply$mcZ$sp();
        };
        Function0<String> x$2 = msg;
        long x$3 = 0L;
        long x$4 = waitTimeMs;
        this.waitUntilTrue((Function0<Object>)x$1, x$2, x$4, x$3);
    }

    public long pollUntilTrue$default$4() {
        return 15000L;
    }

    public <K, V> void pollRecordsUntilTrue(Consumer<K, V> consumer, Function1<ConsumerRecords<K, V>, Object> action, Function0<String> msg, long waitTimeMs) {
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$1 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ConsumerRecords records = consumer.poll(java.time.Duration.ofMillis(100L));
            return BoxesRunTime.unboxToBoolean((Object)action.apply((Object)records));
        };
        Function0<String> x$2 = msg;
        long x$3 = 0L;
        long x$4 = waitTimeMs;
        this.waitUntilTrue((Function0<Object>)x$1, x$2, x$4, x$3);
    }

    public <K, V> long pollRecordsUntilTrue$default$4() {
        return 15000L;
    }

    public void subscribeAndWaitForRecords(String topic, KafkaConsumer<byte[], byte[]> consumer, long waitTimeMs) {
        consumer.subscribe(Collections.singletonList(topic));
        this.pollRecordsUntilTrue((Consumer)consumer, (Function1)(Function1 & Serializable & scala.Serializable)records -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$subscribeAndWaitForRecords$1(records)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected records", waitTimeMs);
    }

    public long subscribeAndWaitForRecords$default$3() {
        return 15000L;
    }

    public <T> T awaitValue(Function0<Option<T>> func, Function0<String> msg, long waitTimeMs) {
        ObjectRef value = ObjectRef.create((Object)None$.MODULE$);
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            value$1.elem = (Option)func.apply();
            return ((Option)value$1.elem).isDefined();
        }, msg, waitTimeMs, this.waitUntilTrue$default$4());
        return (T)((Option)value.elem).get();
    }

    public <T> long awaitValue$default$3() {
        return 15000L;
    }

    public void waitUntilTrue(Function0<Object> condition, Function0<String> msg, long waitTimeMs, long pause) {
        long startTime = System.currentTimeMillis();
        while (!condition.apply$mcZ$sp()) {
            if (System.currentTimeMillis() > startTime + waitTimeMs) {
                throw Assertions$.MODULE$.fail((String)msg.apply(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTimeMs), pause));
        }
        return;
    }

    public long waitUntilTrue$default$3() {
        return 15000L;
    }

    public long waitUntilTrue$default$4() {
        return 100L;
    }

    public <T> Tuple2<T, Object> computeUntilTrue(Function0<T> compute, long waitTime, long pause, Function1<T, Object> predicate) {
        long startTime = System.currentTimeMillis();
        Object result;
        while (!BoxesRunTime.unboxToBoolean((Object)predicate.apply(result = compute.apply()))) {
            if (System.currentTimeMillis() > startTime + waitTime) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTime), pause));
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public <T> long computeUntilTrue$default$2() {
        return 15000L;
    }

    public <T> long computeUntilTrue$default$3() {
        return 100L;
    }

    public boolean isLeaderLocalOnBroker(String topic, int partitionId, KafkaServer server) {
        return server.replicaManager().nonOfflinePartition(new TopicPartition(topic, partitionId)).exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$isLeaderLocalOnBroker$1(x$9)));
    }

    public int findLeaderEpoch(int brokerId, TopicPartition topicPartition, Iterable<KafkaServer> servers) {
        Option leaderServer = servers.find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$findLeaderEpoch$1(brokerId, x$10)));
        Partition leaderPartition = (Partition)leaderServer.flatMap((Function1 & Serializable & scala.Serializable)x$11 -> x$11.replicaManager().nonOfflinePartition(topicPartition)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail(new java.lang.StringBuilder(42).append("Failed to find expected replica on broker ").append(brokerId).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 881)));
        return leaderPartition.getLeaderEpoch();
    }

    public int findFollowerId(TopicPartition topicPartition, Iterable<KafkaServer> servers) {
        Option followerOpt = servers.find((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$findFollowerId$1(topicPartition, server)));
        return BoxesRunTime.unboxToInt((Object)followerOpt.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$findFollowerId$2(x$12))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail(new java.lang.StringBuilder(30).append("Unable to locate follower for ").append(topicPartition).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 895))));
    }

    public void waitUntilBrokerMetadataIsPropagated(Seq<KafkaServer> servers, long timeout) {
        Set expectedBrokerIds = ((TraversableOnce)servers.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$waitUntilBrokerMetadataIsPropagated$1(x$13)), Seq$.MODULE$.canBuildFrom())).toSet();
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilBrokerMetadataIsPropagated$3(expectedBrokerIds, server))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Timed out waiting for broker metadata to propagate to all servers", timeout, this.waitUntilTrue$default$4());
    }

    public long waitUntilBrokerMetadataIsPropagated$default$2() {
        return 15000L;
    }

    public int waitUntilMetadataIsPropagated(Seq<KafkaServer> servers, String topic, int partition, long timeout) {
        IntRef leader = IntRef.create((int)-1);
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilMetadataIsPropagated$2(topic, partition, leader, server))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Partition [%s,%d] metadata not propagated after %d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToLong((long)timeout)})), timeout, this.waitUntilTrue$default$4());
        return leader.elem;
    }

    public long waitUntilMetadataIsPropagated$default$4() {
        return 15000L;
    }

    public int waitUntilControllerElected(KafkaZkClient zkClient, long timeout) {
        Option controllerId;
        Tuple2 tuple2 = this.computeUntilTrue((Function0 & Serializable & scala.Serializable)() -> zkClient.getControllerId(), timeout, this.computeUntilTrue$default$3(), (Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.isDefined()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option option = controllerId = (Option)tuple2._1();
        Option controllerId2 = option;
        return BoxesRunTime.unboxToInt((Object)controllerId2.getOrElse((Function0 & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail(new java.lang.StringBuilder(32).append("Controller not elected after ").append(timeout).append(" ms").toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 942))));
    }

    public long waitUntilControllerElected$default$2() {
        return 15000L;
    }

    public int awaitLeaderChange(Seq<KafkaServer> servers, TopicPartition tp, int oldLeader, long timeout) {
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> TestUtils$.newLeaderExists$1(servers, oldLeader, tp).isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(54).append("Did not observe leader change for partition ").append(tp).append(" after ").append(timeout).append(" ms").toString(), timeout, this.waitUntilTrue$default$4());
        return BoxesRunTime.unboxToInt((Object)TestUtils$.newLeaderExists$1(servers, oldLeader, tp).get());
    }

    public long awaitLeaderChange$default$4() {
        return 15000L;
    }

    public int waitUntilLeaderIsKnown(Seq<KafkaServer> servers, TopicPartition tp, long timeout) {
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> TestUtils$.leaderIfExists$1(servers, tp).isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(41).append("Partition ").append(tp).append(" leaders not made yet after ").append(timeout).append(" ms").toString(), timeout, this.waitUntilTrue$default$4());
        return BoxesRunTime.unboxToInt((Object)TestUtils$.leaderIfExists$1(servers, tp).get());
    }

    public long waitUntilLeaderIsKnown$default$3() {
        return 15000L;
    }

    public void writeNonsenseToFile(File fileName, long position, int size) {
        RandomAccessFile file = new RandomAccessFile(fileName, "rw");
        file.seek(position);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> file.writeByte(MODULE$.random().nextInt(255)));
        file.close();
    }

    public void appendNonsenseToFile(File file, int size) {
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), StandardOpenOption.APPEND);){
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> outputStream.write(MODULE$.random().nextInt(255)));
        }
    }

    public void checkForPhantomInSyncReplicas(KafkaZkClient zkClient, String topic, int partitionToBeReassigned, Seq<Object> assignedReplicas) {
        Option inSyncReplicas = zkClient.getInSyncReplicasForPartition(new TopicPartition(topic, partitionToBeReassigned));
        Set phantomInSyncReplicas = (Set)((TraversableOnce)inSyncReplicas.get()).toSet().$minus$minus((GenTraversableOnce)assignedReplicas.toSet());
        Assert.assertTrue((String)new StringOps(Predef$.MODULE$.augmentString("All in sync replicas %s must be in the assigned replica list %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inSyncReplicas, assignedReplicas})), (boolean)phantomInSyncReplicas.isEmpty());
    }

    public void ensureNoUnderReplicatedPartitions(KafkaZkClient zkClient, String topic, int partitionToBeReassigned, Seq<Object> assignedReplicas, Seq<KafkaServer> servers) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionToBeReassigned);
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Option inSyncReplicas = zkClient.getInSyncReplicasForPartition(topicPartition);
            return ((SeqLike)inSyncReplicas.get()).size() == assignedReplicas.size();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is under replicated")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned)})), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        ObjectRef leader = ObjectRef.create((Object)None$.MODULE$);
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            leader$4.elem = zkClient.getLeaderForPartition(topicPartition);
            return ((Option)leader$4.elem).isDefined();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is unavailable")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned)})), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            KafkaServer leaderBroker = (KafkaServer)((IterableLike)servers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$ensureNoUnderReplicatedPartitions$6(leader, s)))).head();
            return leaderBroker.replicaManager().underReplicatedPartitionCount() == 0;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is under-replicated as reported by the leader %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned), ((Option)leader$4.elem).get()})), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
    }

    public void assertNoNonDaemonThreads(String threadNamePrefix) {
        int threadCount = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(Thread.getAllStackTraces().keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$assertNoNonDaemonThreads$1(threadNamePrefix, t)));
        Assert.assertEquals((long)0L, (long)threadCount);
    }

    public String allThreadStackTraces() {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Thread.getAllStackTraces()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Thread thread = (Thread)tuple2._1();
            StackTraceElement[] stackTrace = (StackTraceElement[])tuple2._2();
            String string = new java.lang.StringBuilder(2).append(thread.getName()).append("\n\t").append(((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stackTrace)).toList().map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.toString(), List$.MODULE$.canBuildFrom())).mkString("\n\t")).toString();
            return string;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public LogManager createLogManager(Seq<File> logDirs, LogConfig defaultConfig, CleanerConfig cleanerConfig, MockTime time) {
        Seq x$10 = (Seq)logDirs.map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.getAbsoluteFile(), Seq$.MODULE$.canBuildFrom());
        WrappedArray x$11 = Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)));
        Map x$12 = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        LogConfig x$13 = defaultConfig;
        CleanerConfig x$14 = cleanerConfig;
        int x$15 = 4;
        long x$16 = 1000L;
        long x$17 = 10000L;
        long x$18 = 10000L;
        long x$19 = 1000L;
        int x$20 = 3600000;
        MockScheduler x$212 = time.scheduler();
        MockTime x$22 = time;
        BrokerState x$23 = new BrokerState();
        BrokerTopicStats x$24 = new BrokerTopicStats();
        LogDirFailureChannel x$25 = new LogDirFailureChannel(logDirs.size());
        return new LogManager(x$10, (Seq)x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, (Scheduler)x$212, x$23, x$24, x$25, (Time)x$22);
    }

    public Seq<File> createLogManager$default$1() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public LogConfig createLogManager$default$2() {
        return LogConfig$.MODULE$.apply();
    }

    public CleanerConfig createLogManager$default$3() {
        boolean x$1 = false;
        int x$2 = CleanerConfig$.MODULE$.apply$default$1();
        long x$3 = CleanerConfig$.MODULE$.apply$default$2();
        double x$4 = CleanerConfig$.MODULE$.apply$default$3();
        int x$5 = CleanerConfig$.MODULE$.apply$default$4();
        int x$6 = CleanerConfig$.MODULE$.apply$default$5();
        double x$7 = CleanerConfig$.MODULE$.apply$default$6();
        long x$8 = CleanerConfig$.MODULE$.apply$default$7();
        String x$9 = CleanerConfig$.MODULE$.apply$default$9();
        return new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9);
    }

    public MockTime createLogManager$default$4() {
        return new MockTime();
    }

    public void produceMessages(Seq<KafkaServer> servers, Seq<ProducerRecord<byte[], byte[]>> records, int acks) {
        try (KafkaProducer producer = this.createProducer(this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2()), acks, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7(), this.createProducer$default$8(), this.createProducer$default$9(), this.createProducer$default$10(), this.createProducer$default$11(), this.createProducer$default$12(), this.createProducer$default$13(), (Serializer)this.createProducer$default$14(), (Serializer)this.createProducer$default$15());){
            Seq futures = (Seq)records.map((Function1 & Serializable & scala.Serializable)x$1 -> producer.send(x$1), Seq$.MODULE$.canBuildFrom());
            futures.foreach((Function1 & Serializable & scala.Serializable)x$22 -> (RecordMetadata)x$22.get());
        }
        Seq topics = (Seq)((SeqLike)records.map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.topic(), Seq$.MODULE$.canBuildFrom())).distinct();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(26).append("Sent ").append(records.size()).append(" messages for topics ").append(topics.mkString(",")).toString());
    }

    public Seq<String> generateAndProduceMessages(Seq<KafkaServer> servers, String topic, int numMessages, int acks) {
        IndexedSeq values = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1 & Serializable & scala.Serializable)x -> TestUtils$.$anonfun$generateAndProduceMessages$1(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom());
        IntegerSerializer intSerializer = new IntegerSerializer();
        IndexedSeq records = (IndexedSeq)((TraversableLike)values.zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String v = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            ProducerRecord producerRecord = new ProducerRecord(topic, (Object)intSerializer.serialize(topic, Predef$.MODULE$.int2Integer(i)), (Object)v.getBytes());
            return producerRecord;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.produceMessages(servers, (Seq<ProducerRecord<byte[], byte[]>>)records, acks);
        return values;
    }

    public int generateAndProduceMessages$default$4() {
        return -1;
    }

    public void produceMessage(Seq<KafkaServer> servers, String topic, String message, int deliveryTimeoutMs, int requestTimeoutMs) {
        String x$1 = this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2());
        int x$2 = deliveryTimeoutMs;
        int x$3 = requestTimeoutMs;
        int x$4 = this.createProducer$default$2();
        long x$5 = this.createProducer$default$3();
        long x$6 = this.createProducer$default$4();
        int x$7 = this.createProducer$default$5();
        int x$8 = this.createProducer$default$7();
        int x$9 = this.createProducer$default$8();
        String x$10 = this.createProducer$default$9();
        SecurityProtocol x$11 = this.createProducer$default$11();
        Option<File> x$12 = this.createProducer$default$12();
        Option<Properties> x$13 = this.createProducer$default$13();
        ByteArraySerializer x$14 = this.createProducer$default$14();
        ByteArraySerializer x$15 = this.createProducer$default$15();
        try (KafkaProducer producer = this.createProducer(x$1, x$4, x$5, x$6, x$7, x$2, x$8, x$9, x$10, x$3, x$11, x$12, x$13, (Serializer)x$14, (Serializer)x$15);){
            producer.send(new ProducerRecord(topic, (Object)topic.getBytes(), (Object)message.getBytes())).get();
        }
    }

    public int produceMessages$default$3() {
        return -1;
    }

    public int produceMessage$default$4() {
        return 30000;
    }

    public int produceMessage$default$5() {
        return 20000;
    }

    public void verifyTopicDeletion(KafkaZkClient zkClient, String topic, int numPartitions, Seq<KafkaServer> servers) {
        IndexedSeq topicPartitions = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable & scala.Serializable)x$24 -> TestUtils$.$anonfun$verifyTopicDeletion$1(topic, BoxesRunTime.unboxToInt((Object)x$24)), IndexedSeq$.MODULE$.canBuildFrom());
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !zkClient.isTopicMarkedForDeletion(topic), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Admin path /admin/delete_topics/%s path not deleted even after a replica is restarted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !zkClient.topicExists(topic), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Topic path /brokers/topics/%s not deleted after /admin/delete_topics/%s path is deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, topic})), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)topicPartitions.forall((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$8(server, tp))))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replica manager's should have deleted all of this topic's partitions", this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)servers.forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)topicPartitions.forall((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$11(server, tp))))));
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)topicPartitions.forall((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$14(server, tp))))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cleaner offset for deleted partition should have been removed", this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$19(topicPartitions, server))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to soft-delete the data to a delete directory", this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$24(topicPartitions, server))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to hard-delete the delete directory", this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
    }

    public String readString(ByteBuffer buffer, String encoding) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes, encoding);
    }

    public String readString$default$2() {
        return Charset.defaultCharset().toString();
    }

    /*
     * WARNING - void declaration
     */
    public Properties copyOf(Properties props) {
        void var2_2;
        Properties copy = new Properties();
        Implicits$.MODULE$.PropertiesOps(copy).$plus$plus$eq(props);
        return var2_2;
    }

    public Properties sslConfigs(Mode mode, boolean clientCert, Option<File> trustStoreFile, String certAlias, String certCn) {
        File trustStore = (File)trustStoreFile.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("SSL enabled but no trustStoreFile provided");
        });
        java.util.Map sslConfigs = TestSslUtils.createSslConfig((boolean)clientCert, (boolean)true, (Mode)mode, (File)trustStore, (String)certAlias, (String)certCn);
        Properties sslProps = new Properties();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(sslConfigs).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Object v = tuple2._2();
            Object object = sslProps.put(k, v);
            return object;
        });
        return sslProps;
    }

    public String sslConfigs$default$5() {
        return this.SslCertificateCn();
    }

    /*
     * WARNING - void declaration
     */
    public X509TrustManager trustAllCerts() {
        void var1_1;
        X509TrustManager trustManager = new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        };
        return var1_1;
    }

    public void waitAndVerifyAcls(Set<AccessControlEntry> expected, Authorizer authorizer, ResourcePattern resource) {
        String newLine = Properties$.MODULE$.lineSeparator();
        AclBindingFilter filter = new AclBindingFilter(resource.toFilter(), AccessControlEntryFilter.ANY);
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set set = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(filter)).asScala()).map((Function1 & Serializable & scala.Serializable)x$25 -> x$25.entry(), Iterable$.MODULE$.canBuildFrom())).toSet();
            Set set2 = expected;
            return !(set != null ? !set.equals(set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(22).append("expected acls:").append(expected.mkString(new java.lang.StringBuilder(1).append(newLine).append("\t").toString(), new java.lang.StringBuilder(1).append(newLine).append("\t").toString(), newLine)).append("but got:").append(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(filter)).asScala()).map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.entry(), Iterable$.MODULE$.canBuildFrom())).mkString(new java.lang.StringBuilder(1).append(newLine).append("\t").toString(), new java.lang.StringBuilder(1).append(newLine).append("\t").toString(), newLine)).toString(), 15000L, this.waitUntilTrue$default$4());
    }

    public void waitAndVerifyAcls(Set<Acl> expected, kafka.security.auth.Authorizer authorizer, Resource resource) {
        String newLine = Properties$.MODULE$.lineSeparator();
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set set = authorizer.getAcls(resource);
            Set set2 = expected;
            return !(set != null ? !set.equals(set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(22).append("expected acls:").append(expected.mkString(new java.lang.StringBuilder(1).append(newLine).append("\t").toString(), new java.lang.StringBuilder(1).append(newLine).append("\t").toString(), newLine)).append("but got:").append(authorizer.getAcls(resource).mkString(new java.lang.StringBuilder(1).append(newLine).append("\t").toString(), new java.lang.StringBuilder(1).append(newLine).append("\t").toString(), newLine)).toString(), 15000L, this.waitUntilTrue$default$4());
    }

    public boolean isAclSecure(ACL acl, boolean sensitive) {
        boolean bl;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(4).append("ACL ").append(acl).toString());
        int n = acl.getPerms();
        switch (n) {
            case 1: {
                if (!sensitive) {
                    String string = acl.getId().getScheme();
                    String string2 = "world";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        bl = true;
                        break;
                    }
                }
                bl = false;
                break;
            }
            case 31: {
                String string = acl.getId().getScheme();
                String string3 = "sasl";
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
                break;
            }
        }
        return bl;
    }

    public boolean isAclUnsecure(ACL acl) {
        boolean bl;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(4).append("ACL ").append(acl).toString());
        int n = acl.getPerms();
        switch (n) {
            case 31: {
                String string = acl.getId().getScheme();
                String string2 = "world";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
                break;
            }
        }
        return bl;
    }

    private Seq<String> secureZkPaths(KafkaZkClient zkClient) {
        Seq topLevelPaths = (Seq)ZkData$.MODULE$.SecureRootPaths().$plus$plus((GenTraversableOnce)ZkData$.MODULE$.SensitiveRootPaths(), Seq$.MODULE$.canBuildFrom());
        return (Seq)topLevelPaths.flatMap((Function1 & Serializable & scala.Serializable)path -> TestUtils$.subPaths$1(path, zkClient), Seq$.MODULE$.canBuildFrom());
    }

    public void verifySecureZkAcls(KafkaZkClient zkClient, int usersWithAccess) {
        this.secureZkPaths(zkClient).foreach((Function1 & Serializable & scala.Serializable)path -> {
            TestUtils$.$anonfun$verifySecureZkAcls$1(zkClient, usersWithAccess, path);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyUnsecureZkAcls(KafkaZkClient zkClient) {
        this.secureZkPaths(zkClient).foreach((Function1 & Serializable & scala.Serializable)path -> {
            TestUtils$.$anonfun$verifyUnsecureZkAcls$1(zkClient, path);
            return BoxedUnit.UNIT;
        });
    }

    public void assertConcurrent(String message, Seq<Function0<Object>> functions, int timeoutMs) {
        int numThreads = functions.size();
        ExecutorService threadPool = Executors.newFixedThreadPool(numThreads);
        ArrayBuffer exceptions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            ArrayBuffer arrayBuffer;
            try {
                java.util.List runnables = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)functions.map((Function1 & Serializable & scala.Serializable)function -> new Callable<BoxedUnit>(function){
                    private final Function0 function$1;

                    public void call() {
                        this.function$1.apply();
                    }
                    {
                        this.function$1 = function$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).asJava();
                Buffer futures = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(threadPool.invokeAll(runnables, timeoutMs, TimeUnit.MILLISECONDS)).asScala();
                futures.foreach((Function1 & Serializable & scala.Serializable)future -> {
                    Object object;
                    if (future.isCancelled()) {
                        TestUtils$.failWithTimeout$1(message, timeoutMs);
                        object = BoxedUnit.UNIT;
                    } else {
                        try {
                            object = future.get();
                        }
                        catch (Exception e) {
                            object = exceptions.$plus$eq((Object)e);
                        }
                    }
                    return object;
                });
                arrayBuffer = BoxedUnit.UNIT;
            }
            catch (InterruptedException interruptedException) {
                TestUtils$.failWithTimeout$1(message, timeoutMs);
                arrayBuffer = BoxedUnit.UNIT;
            }
            catch (Throwable e) {
                arrayBuffer = exceptions.$plus$eq((Object)e);
            }
        }
        finally {
            threadPool.shutdownNow();
        }
        Assert.assertTrue((String)new java.lang.StringBuilder(26).append(message).append(" failed with exception(s) ").append(exceptions).toString(), (boolean)exceptions.isEmpty());
    }

    public <K, V> Seq<ConsumerRecord<byte[], byte[]>> consumeTopicRecords(Seq<KafkaServer> servers, String topic, int numMessages, String groupId, SecurityProtocol securityProtocol, Option<File> trustStoreFile, long waitTime) {
        Seq<ConsumerRecord<K, V>> seq;
        String x$1 = this.getBrokerListStrFromServers(servers, securityProtocol);
        String x$2 = groupId;
        SecurityProtocol x$3 = securityProtocol;
        Option<File> x$4 = trustStoreFile;
        String x$5 = this.createConsumer$default$3();
        boolean x$6 = this.createConsumer$default$4();
        boolean x$7 = this.createConsumer$default$5();
        int x$8 = this.createConsumer$default$6();
        Option<Properties> x$9 = this.createConsumer$default$9();
        ByteArrayDeserializer x$10 = this.createConsumer$default$10();
        ByteArrayDeserializer x$11 = this.createConsumer$default$11();
        try (KafkaConsumer<K, V> consumer = this.createConsumer(x$1, x$2, x$5, x$6, x$7, x$8, x$3, x$4, x$9, (Deserializer<K>)x$10, (Deserializer<V>)x$11);){
            consumer.subscribe(Collections.singleton(topic));
            seq = this.consumeRecords((Consumer<K, V>)consumer, numMessages, waitTime);
        }
        return seq;
    }

    public <K, V> String consumeTopicRecords$default$4() {
        return "group";
    }

    public <K, V> SecurityProtocol consumeTopicRecords$default$5() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V> Option<File> consumeTopicRecords$default$6() {
        return None$.MODULE$;
    }

    public <K, V> long consumeTopicRecords$default$7() {
        return 15000L;
    }

    public <K, V> Seq<ConsumerRecord<K, V>> pollUntilAtLeastNumRecords(Consumer<K, V> consumer, int numRecords, long waitTimeMs) {
        ArrayBuffer records = new ArrayBuffer();
        Consumer<K, V> x$1 = consumer;
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)polledRecords -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.pollAction$1(polledRecords, records, numRecords));
        long x$3 = waitTimeMs;
        Function0 & Serializable & scala.Serializable x$4 = (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(65).append("Consumed ").append(records.size()).append(" records before timeout instead of the expected ").append(numRecords).append(" records").toString();
        this.pollRecordsUntilTrue(x$1, x$2, (Function0<String>)x$4, x$3);
        return records;
    }

    public <K, V> long pollUntilAtLeastNumRecords$default$3() {
        return 15000L;
    }

    public <K, V> Seq<ConsumerRecord<K, V>> consumeRecords(Consumer<K, V> consumer, int numRecords, long waitTimeMs) {
        Seq<ConsumerRecord<K, V>> records = this.pollUntilAtLeastNumRecords(consumer, numRecords, waitTimeMs);
        Assert.assertEquals((String)"Consumed more records than expected", (long)numRecords, (long)records.size());
        return records;
    }

    public <K, V> long consumeRecords$default$3() {
        return 15000L;
    }

    public <K, V> Seq<ConsumerRecord<K, V>> consumeRecordsFor(KafkaConsumer<K, V> consumer, long duration) {
        long startTime = System.currentTimeMillis();
        ArrayBuffer records = new ArrayBuffer();
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            records.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(java.time.Duration.ofMillis(50L))).asScala());
            return System.currentTimeMillis() - startTime > duration;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(52).append("The timeout ").append(duration).append(" was greater than the maximum wait time.").toString(), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        return records;
    }

    public <K, V> long consumeRecordsFor$default$2() {
        return 15000L;
    }

    public KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId, Seq<KafkaServer> servers, int batchSize, long transactionTimeoutMs, long maxBlockMs) {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2()));
        props.put("acks", "all");
        props.put("batch.size", ((Object)BoxesRunTime.boxToInteger((int)batchSize)).toString());
        props.put("transactional.id", transactionalId);
        props.put("enable.idempotence", "true");
        props.put("transaction.timeout.ms", ((Object)BoxesRunTime.boxToLong((long)transactionTimeoutMs)).toString());
        props.put("max.block.ms", ((Object)BoxesRunTime.boxToLong((long)maxBlockMs)).toString());
        return new KafkaProducer(props, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
    }

    public int createTransactionalProducer$default$3() {
        return 16384;
    }

    public long createTransactionalProducer$default$4() {
        return 60000L;
    }

    public long createTransactionalProducer$default$5() {
        return 60000L;
    }

    public void seedTopicWithNumberedRecords(String topic, int numRecords, Seq<KafkaServer> servers) {
        Properties props = new Properties();
        props.put("enable.idempotence", "true");
        props.put("bootstrap.servers", this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2()));
        try (KafkaProducer producer = new KafkaProducer(props, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());){
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(topic, (Object)TestUtils$.MODULE$.asBytes(((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString()), (Object)TestUtils$.MODULE$.asBytes(((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString()))));
            producer.flush();
        }
    }

    private String asString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private byte[] asBytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public String assertCommittedAndGetValue(ConsumerRecord<byte[], byte[]> record) {
        Option option = ((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(record.headers().headers(this.kafka$utils$TestUtils$$transactionStatusKey())).asScala()).headOption();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw Assertions$.MODULE$.fail("expected the record header to include an expected transaction status, but received nothing.", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1411));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Header header = (Header)some.value();
        Assert.assertEquals((String)new java.lang.StringBuilder(57).append("Got ").append(this.asString(header.value())).append(" but expected the value to indicate ").append("committed status.").toString(), (Object)this.asString(this.kafka$utils$TestUtils$$committedValue()), (Object)this.asString(header.value()));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return this.recordValueAsString(record);
    }

    public String recordValueAsString(ConsumerRecord<byte[], byte[]> record) {
        return this.asString((byte[])record.value());
    }

    public ProducerRecord<byte[], byte[]> producerRecordWithExpectedTransactionStatus(String topic, byte[] key, byte[] value, boolean willBeCommitted) {
        Header header = new Header(willBeCommitted){
            private final boolean willBeCommitted$1;

            public String key() {
                return TestUtils$.MODULE$.kafka$utils$TestUtils$$transactionStatusKey();
            }

            public byte[] value() {
                return this.willBeCommitted$1 ? TestUtils$.MODULE$.kafka$utils$TestUtils$$committedValue() : TestUtils$.MODULE$.kafka$utils$TestUtils$$abortedValue();
            }
            {
                this.willBeCommitted$1 = willBeCommitted$1;
            }
        };
        return new ProducerRecord(topic, null, (Object)key, (Object)value, Collections.singleton(header));
    }

    public ProducerRecord<byte[], byte[]> producerRecordWithExpectedTransactionStatus(String topic, String key, String value, boolean willBeCommitted) {
        return this.producerRecordWithExpectedTransactionStatus(topic, this.asBytes(key), this.asBytes(value), willBeCommitted);
    }

    public Map<TopicPartition, OffsetAndMetadata> consumerPositions(KafkaConsumer<byte[], byte[]> consumer) {
        HashMap offsetsToCommit = new HashMap();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala()).foreach((Function1 & Serializable & scala.Serializable)topicPartition -> offsetsToCommit.put(topicPartition, (Object)new OffsetAndMetadata(consumer.position(topicPartition))));
        return offsetsToCommit.toMap(Predef$.MODULE$.$conforms());
    }

    public void resetToCommittedPositions(KafkaConsumer<byte[], byte[]> consumer) {
        Map committed = ((MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.committed(consumer.assignment())).asScala()).filter((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$resetToCommittedPositions$1(x$28)))).mapValues((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToLong((long)x$29.offset()));
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala()).foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            TestUtils$.$anonfun$resetToCommittedPositions$3(committed, consumer, topicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public AlterConfigsResult alterConfigs(Seq<KafkaServer> servers, Admin adminClient, Properties props, boolean perBrokerConfig) {
        java.util.List configEntries = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            ConfigEntry configEntry = new ConfigEntry(k, v);
            return configEntry;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toList()).asJava();
        Config newConfig = new Config((Collection)configEntries);
        java.util.Map configs = perBrokerConfig ? (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)servers.map((Function1 & Serializable & scala.Serializable)server -> {
            ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)server.config().brokerId())).toString());
            return new Tuple2((Object)resource, (Object)newConfig);
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava() : (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "")), (Object)newConfig)}))).asJava();
        return adminClient.alterConfigs(configs);
    }

    public AlterConfigsResult incrementalAlterConfigs(Seq<KafkaServer> servers, Admin adminClient, Properties props, boolean perBrokerConfig, AlterConfigOp.OpType opType) {
        Collection configEntries = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry(k, v), opType);
            return alterConfigOp;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toList()).asJavaCollection();
        java.util.Map configs = perBrokerConfig ? (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)servers.map((Function1 & Serializable & scala.Serializable)server -> {
            ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)server.config().brokerId())).toString());
            return new Tuple2((Object)resource, (Object)configEntries);
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava() : (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "")), (Object)configEntries)}))).asJava();
        return adminClient.incrementalAlterConfigs(configs);
    }

    public AlterConfigOp.OpType incrementalAlterConfigs$default$5() {
        return AlterConfigOp.OpType.SET;
    }

    public AlterConfigsResult alterTopicConfigs(Admin adminClient, String topic, Properties topicConfigs) {
        java.util.List configEntries = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(topicConfigs).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            ConfigEntry configEntry = new ConfigEntry(k, v);
            return configEntry;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toList()).asJava();
        Config newConfig = new Config((Collection)configEntries);
        java.util.Map configs = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, topic)), (Object)newConfig)}))).asJava();
        return adminClient.alterConfigs(configs);
    }

    public void assertLeader(Admin client, TopicPartition topicPartition, int expectedLeader) {
        this.waitForLeaderToBecome(client, topicPartition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)expectedLeader)));
    }

    public void assertNoLeader(Admin client, TopicPartition topicPartition) {
        this.waitForLeaderToBecome(client, topicPartition, (Option<Object>)None$.MODULE$);
    }

    public void waitForLeaderToBecome(Admin client, TopicPartition topicPartition, Option<Object> leader) {
        String topic = topicPartition.topic();
        int partition = topicPartition.partition();
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            block4: {
                try {
                    TopicDescription topicResult = (TopicDescription)((java.util.Map)client.describeTopics(Arrays.asList((Object[])new String[]{topic})).all().get()).get(topic);
                    TopicPartitionInfo partitionResult = (TopicPartitionInfo)topicResult.partitions().get(partition);
                    Option option = Option$.MODULE$.apply((Object)partitionResult.leader()).map((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToInteger((int)x$30.id()));
                    Option option2 = leader;
                    if (!(option != null ? !option.equals(option2) : option2 != null)) {
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
                catch (Throwable throwable) {
                    ExecutionException executionException;
                    Throwable throwable2 = throwable;
                    if (!(throwable2 instanceof ExecutionException) || !((executionException = (ExecutionException)throwable2).getCause() instanceof UnknownTopicOrPartitionException)) {
                        throw throwable;
                    }
                    boolean bl2 = false;
                    bl = bl2;
                }
            }
            return bl;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Timed out waiting for leader metadata", this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
    }

    public void waitForBrokersOutOfIsr(Admin client, Set<TopicPartition> partition, Set<Object> brokerIds) {
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.mutable.Map description = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)client.describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)partition.map((Function1 & Serializable & scala.Serializable)x$31 -> x$31.topic(), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).asJava()).all().get()).asScala();
            Set isr = ((TraversableOnce)((TraversableLike)description.values().flatMap((Function1 & Serializable & scala.Serializable)x$32 -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$32.partitions()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$33 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$33.isr()).asScala(), Buffer$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToInteger((int)x$34.id()), Iterable$.MODULE$.canBuildFrom())).toSet();
            return ((SetLike)brokerIds.intersect((GenSet)isr)).isEmpty();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(46).append("Expected brokers ").append(brokerIds).append(" to no longer in the ISR for ").append(partition).toString(), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
    }

    public void waitForBrokersInIsr(Admin client, TopicPartition partition, Set<Object> brokerIds) {
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.mutable.Map description = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)client.describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{partition.topic()}))).asJava()).all().get()).asScala();
            Set isr = ((TraversableOnce)((TraversableLike)description.values().flatMap((Function1 & Serializable & scala.Serializable)x$35 -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$35.partitions()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$36 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$36.isr()).asScala(), Buffer$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$37 -> BoxesRunTime.boxToInteger((int)x$37.id()), Iterable$.MODULE$.canBuildFrom())).toSet();
            return brokerIds.subsetOf((GenSet)isr);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(39).append("Expected brokers ").append(brokerIds).append(" to be in the ISR for ").append(partition).toString(), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
    }

    public String grabConsoleOutput(Function0<BoxedUnit> f) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)out, f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return out.toString();
    }

    public String grabConsoleError(Function0<BoxedUnit> f) {
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withErr((OutputStream)err, f);
        }
        finally {
            Console$.MODULE$.err().flush();
        }
        return err.toString();
    }

    public Tuple2<String, String> grabConsoleOutputAndError(Function0<BoxedUnit> f) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)out, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Console$.MODULE$.withErr((OutputStream)err, f));
        }
        finally {
            Console$.MODULE$.out().flush();
            Console$.MODULE$.err().flush();
        }
        return new Tuple2((Object)out.toString(), (Object)err.toString());
    }

    public void assertFutureExceptionTypeEquals(KafkaFuture<?> future, Class<? extends Throwable> clazz, Option<String> expectedErrorMessage) {
        try {
            future.get();
            throw Assertions$.MODULE$.fail("Expected CompletableFuture.get to return an exception", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1585));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((String)new java.lang.StringBuilder(41).append("Expected an exception of type ").append(clazz.getName()).append("; got type ").append(cause.getClass().getName()).toString(), (boolean)clazz.isInstance(cause));
            expectedErrorMessage.foreach((Function1 & Serializable & scala.Serializable)message -> {
                TestUtils$.$anonfun$assertFutureExceptionTypeEquals$1(cause, message);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Option<String> assertFutureExceptionTypeEquals$default$3() {
        return None$.MODULE$;
    }

    public long totalMetricValue(KafkaServer server, String metricName) {
        java.util.Map allMetrics = server.metrics().metrics();
        double total2 = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(allMetrics.values()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$38 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$totalMetricValue$1(metricName, x$38)))).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(total, metric) -> BoxesRunTime.boxToDouble((double)TestUtils$.$anonfun$totalMetricValue$2(BoxesRunTime.unboxToDouble((Object)total), metric))));
        return (long)total2;
    }

    public long meterCount(String metricName) {
        return ((Meter)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$39 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$meterCount$1(metricName, x$39))).values().headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail(new java.lang.StringBuilder(22).append("Unable to find metric ").append(metricName).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1608)))).count();
    }

    public void clearYammerMetrics() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)metricName -> {
            TestUtils$.$anonfun$clearYammerMetrics$1(metricName);
            return BoxedUnit.UNIT;
        });
    }

    public String stringifyTopicPartitions(Set<TopicPartition> partitions) {
        return Json$.MODULE$.legacyEncodeAsString((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), partitions.map((Function1 & Serializable & scala.Serializable)tp -> (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)tp.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)tp.partition()))})), scala.collection.immutable.Set$.MODULE$.canBuildFrom()))})));
    }

    public <R extends AutoCloseable, A> A resource(R resource, Function1<R, A> func) {
        Object object;
        try {
            object = func.apply(resource);
        }
        finally {
            resource.close();
        }
        return (A)object;
    }

    public void throttleAllBrokersReplication(Admin adminClient, Seq<Object> brokerIds, int throttleBytes) {
        Collection throttleConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), ((Object)BoxesRunTime.boxToInteger((int)throttleBytes)).toString()), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), ((Object)BoxesRunTime.boxToInteger((int)throttleBytes)).toString()), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        adminClient.incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)brokerIds.map((Function1 & Serializable & scala.Serializable)brokerId -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)brokerId))).toString())), (Object)throttleConfigs), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava()).all().get();
    }

    public void resetBrokersThrottle(Admin adminClient, Seq<Object> brokerIds) {
        this.throttleAllBrokersReplication(adminClient, brokerIds, Integer.MAX_VALUE);
    }

    public void assignThrottledPartitionReplicas(Admin adminClient, Map<TopicPartition, Seq<Object>> allReplicasByPartition) {
        scala.collection.immutable.Map throttles = (scala.collection.immutable.Map)allReplicasByPartition.groupBy((Function1 & Serializable & scala.Serializable)x$40 -> ((TopicPartition)x$40._1()).topic()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String topic = (String)tuple2._1();
            Map replicasByPartition = (Map)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, topic)), (Object)JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), MODULE$.formatReplicaThrottles((Map<TopicPartition, Seq<Object>>)replicasByPartition)), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), MODULE$.formatReplicaThrottles((Map<TopicPartition, Seq<Object>>)replicasByPartition)), AlterConfigOp.OpType.SET)}))).asJavaCollection());
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        adminClient.incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)throttles).asJava()).all().get();
    }

    public void removePartitionReplicaThrottles(Admin adminClient, Set<TopicPartition> partitions) {
        scala.collection.immutable.Map throttles = ((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, tp.topic())), (Object)JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), ""), AlterConfigOp.OpType.DELETE), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), ""), AlterConfigOp.OpType.DELETE)}))).asJavaCollection()), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        adminClient.incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)throttles).asJava()).all().get();
    }

    public String formatReplicaThrottles(Map<TopicPartition, Seq<Object>> moves) {
        return ((TraversableOnce)moves.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Seq assignment = (Seq)tuple2._2();
            Seq seq = (Seq)assignment.map((Function1 & Serializable & scala.Serializable)replicaId -> TestUtils$.$anonfun$formatReplicaThrottles$2(tp, BoxesRunTime.unboxToInt((Object)replicaId)), Seq$.MODULE$.canBuildFrom());
            return seq;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
    }

    public static final /* synthetic */ Properties $anonfun$createBrokerConfigs$1(String zkConnect$1, boolean enableControlledShutdown$1, boolean enableDeleteTopic$1, Option interBrokerSecurityProtocol$1, Option trustStoreFile$1, Option saslProperties$1, boolean enablePlaintext$1, boolean enableSsl$1, boolean enableSaslPlaintext$1, boolean enableSaslSsl$1, Map rackInfo$1, int logDirCount$1, boolean enableToken$1, int numPartitions$1, short defaultReplicationFactor$1, int node) {
        int x$1 = node;
        String x$2 = zkConnect$1;
        boolean x$3 = enableControlledShutdown$1;
        boolean x$4 = enableDeleteTopic$1;
        int x$5 = MODULE$.RandomPort();
        Option x$6 = interBrokerSecurityProtocol$1;
        Option x$7 = trustStoreFile$1;
        Option x$8 = saslProperties$1;
        boolean x$9 = enablePlaintext$1;
        boolean x$10 = enableSsl$1;
        boolean x$11 = enableSaslPlaintext$1;
        boolean x$12 = enableSaslSsl$1;
        Option x$13 = rackInfo$1.get((Object)BoxesRunTime.boxToInteger((int)node));
        int x$14 = logDirCount$1;
        boolean x$15 = enableToken$1;
        int x$16 = numPartitions$1;
        short x$17 = defaultReplicationFactor$1;
        int x$18 = MODULE$.createBrokerConfig$default$11();
        int x$19 = MODULE$.createBrokerConfig$default$13();
        int x$20 = MODULE$.createBrokerConfig$default$15();
        return MODULE$.createBrokerConfig(x$1, x$2, x$3, x$4, x$5, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$11, x$18, x$10, x$19, x$12, x$20, (Option<String>)x$13, x$14, x$15, x$16, x$17);
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerListStrFromServers$2(SecurityProtocol protocol$1, EndPoint x$2) {
        SecurityProtocol securityProtocol = x$2.securityProtocol();
        SecurityProtocol securityProtocol2 = protocol$1;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$bootstrapServers$2(ListenerName listenerName$1, EndPoint x$3) {
        ListenerName listenerName = x$3.listenerName();
        ListenerName listenerName2 = listenerName$1;
        return !(listenerName != null ? !listenerName.equals(listenerName2) : listenerName2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfig$2(SecurityProtocol protocol$2, SecurityProtocol x$4) {
        SecurityProtocol securityProtocol = x$4;
        SecurityProtocol securityProtocol2 = protocol$2;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    private static final boolean shouldEnable$1(SecurityProtocol protocol, Option interBrokerSecurityProtocol$2) {
        return BoxesRunTime.unboxToBoolean((Object)interBrokerSecurityProtocol$2.fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$createBrokerConfig$2(protocol, x$4))));
    }

    public static final /* synthetic */ Object $anonfun$createBrokerConfig$4(int i) {
        return i % 2 == 0 ? MODULE$.tempDir().getAbsolutePath() : MODULE$.tempRelativeDir("data");
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfig$6(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SecurityProtocol protocol = (SecurityProtocol)tuple2._1();
        boolean bl = MODULE$.usesSslTransportLayer(protocol);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfig$7(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SecurityProtocol protocol = (SecurityProtocol)tuple2._1();
        boolean bl = MODULE$.usesSaslAuthentication(protocol);
        return bl;
    }

    public static final /* synthetic */ Tuple2 $anonfun$createTopic$3(Seq servers$1, String topic$1, KafkaZkClient zkClient$1, int i) {
        MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)servers$1, topic$1, i, MODULE$.waitUntilMetadataIsPropagated$default$4());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)i)), (Object)BoxesRunTime.boxToInteger((int)MODULE$.waitUntilLeaderIsElectedOrChanged(zkClient$1, topic$1, i, MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), MODULE$.waitUntilLeaderIsElectedOrChanged$default$6())));
    }

    public static final /* synthetic */ Tuple2 $anonfun$createTopic$6(Seq servers$2, String topic$2, KafkaZkClient zkClient$2, int i) {
        MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)servers$2, topic$2, i, MODULE$.waitUntilMetadataIsPropagated$default$4());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)i)), (Object)BoxesRunTime.boxToInteger((int)MODULE$.waitUntilLeaderIsElectedOrChanged(zkClient$2, topic$2, i, MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), MODULE$.waitUntilLeaderIsElectedOrChanged$default$6())));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$createBrokersInZk$1(int x$6) {
        return new BrokerMetadata(x$6, (Option)None$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$1() {
        return "Can't define both the old and the new leader";
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$2(TopicPartition topicPartition$1, Option oldLeaderOpt$1, Option newLeaderOpt$1) {
        return new java.lang.StringBuilder(90).append("Waiting for leader to be elected or changed for partition ").append(topicPartition$1).append(", old leader is ").append(oldLeaderOpt$1).append(", ").append("new leader is ").append(newLeaderOpt$1).toString();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$3(int l$1, TopicPartition topicPartition$1) {
        return new java.lang.StringBuilder(46).append("Expected new leader ").append(l$1).append(" is elected for partition ").append(topicPartition$1).toString();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$4(TopicPartition topicPartition$1, int oldLeader$1, int l$1) {
        return new java.lang.StringBuilder(42).append("Leader for partition ").append(topicPartition$1).append(" is changed from ").append(oldLeader$1).append(" to ").append(l$1).toString();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$5(int l$1, TopicPartition topicPartition$1) {
        return new java.lang.StringBuilder(33).append("Leader ").append(l$1).append(" is elected for partition ").append(topicPartition$1).toString();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$6(TopicPartition topicPartition$1, int l$1) {
        return new java.lang.StringBuilder(33).append("Current leader for partition ").append(topicPartition$1).append(" is ").append(l$1).toString();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$7(TopicPartition topicPartition$1) {
        return new java.lang.StringBuilder(40).append("Leader for partition ").append(topicPartition$1).append(" is not elected yet").toString();
    }

    public static final /* synthetic */ Nothing$ $anonfun$waitUntilLeaderIsElectedOrChanged$8(Option newLeaderOpt$1, Option oldLeaderOpt$1, long timeoutMs$1, TopicPartition topicPartition$1, ObjectRef leader$2) {
        Option option;
        String string;
        Option option2;
        Tuple2 tuple2 = new Tuple2((Object)newLeaderOpt$1, (Object)oldLeaderOpt$1);
        if (tuple2 != null && (option2 = (Option)tuple2._1()) instanceof Some) {
            Some some = (Some)option2;
            int newLeader = BoxesRunTime.unboxToInt((Object)some.value());
            string = new java.lang.StringBuilder(90).append("Timing out after ").append(timeoutMs$1).append(" ms since expected new leader ").append(newLeader).append(" was not elected for partition ").append(topicPartition$1).append(", leader is ").append((Option)leader$2.elem).toString();
        } else if (tuple2 != null && (option = (Option)tuple2._2()) instanceof Some) {
            Some some = (Some)option;
            int oldLeader = BoxesRunTime.unboxToInt((Object)some.value());
            string = new java.lang.StringBuilder(106).append("Timing out after ").append(timeoutMs$1).append(" ms since a new leader that is different from ").append(oldLeader).append(" was not elected for partition ").append(topicPartition$1).append(", ").append("leader is ").append((Option)leader$2.elem).toString();
        } else {
            string = new java.lang.StringBuilder(66).append("Timing out after ").append(timeoutMs$1).append(" ms since a leader was not elected for partition ").append(topicPartition$1).toString();
        }
        String errorMessage = string;
        return Assertions$.MODULE$.fail(errorMessage, new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 750));
    }

    public static final /* synthetic */ boolean $anonfun$subscribeAndWaitForRecords$1(ConsumerRecords records) {
        return !records.isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$isLeaderLocalOnBroker$1(Partition x$9) {
        return x$9.leaderLogIfLocal().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$findLeaderEpoch$1(int brokerId$1, KafkaServer x$10) {
        return x$10.config().brokerId() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$findFollowerId$1(TopicPartition topicPartition$3, KafkaServer server) {
        boolean bl;
        Option option = server.replicaManager().nonOfflinePartition(topicPartition$3);
        if (option instanceof Some) {
            Some some = (Some)option;
            Partition partition = (Partition)some.value();
            bl = !partition.leaderReplicaIdOpt().contains((Object)BoxesRunTime.boxToInteger((int)server.config().brokerId()));
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public static final /* synthetic */ int $anonfun$findFollowerId$2(KafkaServer x$12) {
        return x$12.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$waitUntilBrokerMetadataIsPropagated$1(KafkaServer x$13) {
        return x$13.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilBrokerMetadataIsPropagated$3(Set expectedBrokerIds$1, KafkaServer server) {
        Set set = expectedBrokerIds$1;
        Set set2 = ((TraversableOnce)server.dataPlaneRequestProcessor().metadataCache().getAliveBrokers().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.id()), Seq$.MODULE$.canBuildFrom())).toSet();
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilMetadataIsPropagated$2(String topic$4, int partition$1, IntRef leader$3, KafkaServer server) {
        boolean bl;
        Some some;
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState;
        Option option = server.dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic$4, partition$1);
        if (option instanceof Some && Request$.MODULE$.isValidBrokerId((partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)(some = (Some)option).value()).leader())) {
            leader$3.elem = partitionState.leader();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$awaitLeaderChange$2(Partition x$16) {
        return x$16.leaderLogIfLocal().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$awaitLeaderChange$1(int oldLeader$2, TopicPartition tp$1, KafkaServer server) {
        return server.config().brokerId() != oldLeader$2 && server.replicaManager().nonOfflinePartition(tp$1).exists((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$awaitLeaderChange$2(x$16)));
    }

    public static final /* synthetic */ int $anonfun$awaitLeaderChange$3(KafkaServer x$17) {
        return x$17.config().brokerId();
    }

    private static final Option newLeaderExists$1(Seq servers$5, int oldLeader$2, TopicPartition tp$1) {
        return servers$5.find((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$awaitLeaderChange$1(oldLeader$2, tp$1, server))).map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$awaitLeaderChange$3(x$17)));
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilLeaderIsKnown$2(Partition x$18) {
        return x$18.leaderLogIfLocal().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilLeaderIsKnown$1(TopicPartition tp$2, KafkaServer server) {
        return server.replicaManager().nonOfflinePartition(tp$2).exists((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilLeaderIsKnown$2(x$18)));
    }

    public static final /* synthetic */ int $anonfun$waitUntilLeaderIsKnown$3(KafkaServer x$19) {
        return x$19.config().brokerId();
    }

    private static final Option leaderIfExists$1(Seq servers$6, TopicPartition tp$2) {
        return servers$6.find((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilLeaderIsKnown$1(tp$2, server))).map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$waitUntilLeaderIsKnown$3(x$19)));
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoUnderReplicatedPartitions$6(ObjectRef leader$4, KafkaServer s) {
        return s.config().brokerId() == BoxesRunTime.unboxToInt((Object)((Option)leader$4.elem).get());
    }

    public static final /* synthetic */ boolean $anonfun$assertNoNonDaemonThreads$1(String threadNamePrefix$1, Thread t) {
        return !t.isDaemon() && t.isAlive() && t.getName().startsWith(threadNamePrefix$1);
    }

    public static final /* synthetic */ String $anonfun$generateAndProduceMessages$1(int x) {
        return new java.lang.StringBuilder(5).append("test-").append(x).toString();
    }

    public static final /* synthetic */ TopicPartition $anonfun$verifyTopicDeletion$1(String topic$7, int x$24) {
        return new TopicPartition(topic$7, x$24);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$8(KafkaServer server$1, TopicPartition tp) {
        return server$1.replicaManager().nonOfflinePartition(tp).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$11(KafkaServer server$2, TopicPartition tp) {
        LogManager qual$1 = server$2.getLogManager();
        TopicPartition x$1 = tp;
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(x$1, x$2).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$16(TopicPartition tp$3, Map checkpointsPerLogDir) {
        return !checkpointsPerLogDir.contains((Object)tp$3);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$14(KafkaServer server$3, TopicPartition tp) {
        Seq checkpoints = (Seq)server$3.getLogManager().liveLogDirs().map((Function1 & Serializable & scala.Serializable)logDir -> new OffsetCheckpointFile(new File((File)logDir, "cleaner-offset-checkpoint"), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read(), Seq$.MODULE$.canBuildFrom());
        return checkpoints.forall((Function1 & Serializable & scala.Serializable)checkpointsPerLogDir -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$16(tp, checkpointsPerLogDir)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$21(String logDir$1, TopicPartition tp) {
        return !new File(logDir$1, new java.lang.StringBuilder(1).append(tp.topic()).append("-").append(tp.partition()).toString()).exists();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$19(IndexedSeq topicPartitions$1, KafkaServer server) {
        return server.config().logDirs().forall((Function1 & Serializable & scala.Serializable)logDir -> BoxesRunTime.boxToBoolean((boolean)topicPartitions$1.forall((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$21(logDir, tp)))));
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$27(TopicPartition tp$4, String[] partitionDirectoryName) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionDirectoryName)).startsWith((GenSeq)Predef$.MODULE$.wrapString(new java.lang.StringBuilder(1).append(tp$4.topic()).append("-").append(tp$4.partition()).toString())) && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionDirectoryName)).endsWith((GenSeq)Predef$.MODULE$.wrapString(Log$.MODULE$.DeleteDirSuffix()));
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$26(String logDir$2, TopicPartition tp) {
        return !((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(Arrays.asList((Object[])new String[][]{new File(logDir$2).list()})).asScala()).exists((Function1 & Serializable & scala.Serializable)partitionDirectoryName -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$27(tp, partitionDirectoryName)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$24(IndexedSeq topicPartitions$1, KafkaServer server) {
        return server.config().logDirs().forall((Function1 & Serializable & scala.Serializable)logDir -> BoxesRunTime.boxToBoolean((boolean)topicPartitions$1.forall((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$26(logDir, tp)))));
    }

    private static final Seq subPaths$1(String path2, KafkaZkClient zkClient$9) {
        Seq seq;
        if (zkClient$9.pathExists(path2)) {
            String string = path2;
            seq = (Seq)((SeqLike)((TraversableLike)zkClient$9.getChildren(path2).map((Function1 & Serializable & scala.Serializable)c -> new java.lang.StringBuilder(1).append(path2).append("/").append((String)c).toString(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)path -> TestUtils$.subPaths$1(path, zkClient$9), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    public static final /* synthetic */ void $anonfun$verifySecureZkAcls$1(KafkaZkClient zkClient$10, int usersWithAccess$1, String path) {
        block0: {
            if (!zkClient$10.pathExists(path)) break block0;
            boolean sensitive = ZkData$.MODULE$.sensitivePath(path);
            int aclCount = sensitive ? usersWithAccess$1 : usersWithAccess$1 + 1;
            Seq acls = zkClient$10.getAcl(path);
            Assert.assertEquals((String)new java.lang.StringBuilder(18).append("Invalid ACLs for ").append(path).append(" ").append(acls).toString(), (long)aclCount, (long)acls.size());
            acls.foreach((Function1 & Serializable & scala.Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclSecure(acl, sensitive)));
        }
    }

    public static final /* synthetic */ void $anonfun$verifyUnsecureZkAcls$1(KafkaZkClient zkClient$11, String path) {
        block0: {
            if (!zkClient$11.pathExists(path)) break block0;
            Seq acls = zkClient$11.getAcl(path);
            Assert.assertEquals((String)new java.lang.StringBuilder(18).append("Invalid ACLs for ").append(path).append(" ").append(acls).toString(), (long)1L, (long)acls.size());
            acls.foreach((Function1 & Serializable & scala.Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclUnsecure(acl)));
        }
    }

    private static final void failWithTimeout$1(String message$1, int timeoutMs$2) {
        throw Assertions$.MODULE$.fail(new java.lang.StringBuilder(66).append(message$1).append(". Timed out, the concurrent functions took more than ").append(timeoutMs$2).append(" milliseconds").toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1278));
    }

    private static final boolean pollAction$1(ConsumerRecords polledRecords, ArrayBuffer records$2, int numRecords$1) {
        records$2.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)polledRecords).asScala());
        return records$2.size() >= numRecords$1;
    }

    public static final /* synthetic */ boolean $anonfun$resetToCommittedPositions$1(Tuple2 x$28) {
        return x$28._2() != null;
    }

    public static final /* synthetic */ void $anonfun$resetToCommittedPositions$3(Map committed$1, KafkaConsumer consumer$5, TopicPartition topicPartition) {
        if (committed$1.contains((Object)topicPartition)) {
            consumer$5.seek(topicPartition, BoxesRunTime.unboxToLong((Object)committed$1.apply((Object)topicPartition)));
        } else {
            consumer$5.seekToBeginning(Collections.singletonList(topicPartition));
        }
    }

    public static final /* synthetic */ void $anonfun$assertFutureExceptionTypeEquals$1(Throwable cause$1, String message) {
        Assert.assertTrue((String)new java.lang.StringBuilder(68).append("Received error message : ").append(cause$1.getMessage()).append(" does not contain expected error message : ").append(message).toString(), (boolean)cause$1.getMessage().contains(message));
    }

    public static final /* synthetic */ boolean $anonfun$totalMetricValue$1(String metricName$1, KafkaMetric x$38) {
        String string = x$38.metricName().name();
        String string2 = metricName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ double $anonfun$totalMetricValue$2(double total, KafkaMetric metric) {
        return total + BoxesRunTime.unboxToDouble((Object)metric.metricValue());
    }

    public static final /* synthetic */ boolean $anonfun$meterCount$1(String metricName$2, MetricName x$39) {
        return x$39.getMBeanName().endsWith(metricName$2);
    }

    public static final /* synthetic */ void $anonfun$clearYammerMetrics$1(MetricName metricName) {
        Metrics.defaultRegistry().removeMetric(metricName);
    }

    public static final /* synthetic */ String $anonfun$formatReplicaThrottles$2(TopicPartition tp$5, int replicaId) {
        return new java.lang.StringBuilder(1).append(tp$5.partition()).append(":").append(replicaId).toString();
    }

    private TestUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.random = TestUtils.RANDOM;
        this.RandomPort = 0;
        this.IncorrectBrokerPort = 225;
        this.MockZkPort = 1;
        this.MockZkConnect = new java.lang.StringBuilder(10).append("127.0.0.1:").append(this.MockZkPort()).toString();
        this.SslCertificateCn = "localhost";
        this.kafka$utils$TestUtils$$transactionStatusKey = "transactionStatus";
        this.kafka$utils$TestUtils$$committedValue = "committed".getBytes(StandardCharsets.UTF_8);
        this.kafka$utils$TestUtils$$abortedValue = "aborted".getBytes(StandardCharsets.UTF_8);
    }
}

