/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.timer;

import kafka.utils.MockTime;
import kafka.utils.timer.Timer;
import kafka.utils.timer.TimerTask;
import kafka.utils.timer.TimerTaskEntry;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001A3AAC\u0006\u0001%!)Q\u0004\u0001C\u0001=!9\u0001\u0005\u0001b\u0001\n\u0003\t\u0003B\u0002\u0014\u0001A\u0003%!\u0005C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\t\rQ\u0002\u0001\u0015!\u0003*\u0011\u0015)\u0004\u0001\"\u00017\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015q\u0005\u0001\"\u0011P\u0005%iunY6US6,'O\u0003\u0002\r\u001b\u0005)A/[7fe*\u0011abD\u0001\u0006kRLGn\u001d\u0006\u0002!\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u00143A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1\u0011I\\=SK\u001a\u0004\"AG\u000e\u000e\u0003-I!\u0001H\u0006\u0003\u000bQKW.\u001a:\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u000e\u0001\u0003\u0011!\u0018.\\3\u0016\u0003\t\u0002\"a\t\u0013\u000e\u00035I!!J\u0007\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\n\u0011\u0002^1tWF+X-^3\u0016\u0003%\u00022AK\u00182\u001b\u0005Y#B\u0001\u0017.\u0003\u001diW\u000f^1cY\u0016T!AL\u000b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00021W\ti\u0001K]5pe&$\u00180U;fk\u0016\u0004\"A\u0007\u001a\n\u0005MZ!A\u0004+j[\u0016\u0014H+Y:l\u000b:$(/_\u0001\u000bi\u0006\u001c8.U;fk\u0016\u0004\u0013aA1eIR\u0011qG\u000f\t\u0003)aJ!!O\u000b\u0003\tUs\u0017\u000e\u001e\u0005\u0006w\u0019\u0001\r\u0001P\u0001\ni&lWM\u001d+bg.\u0004\"AG\u001f\n\u0005yZ!!\u0003+j[\u0016\u0014H+Y:l\u00031\tGM^1oG\u0016\u001cEn\\2l)\t\tE\t\u0005\u0002\u0015\u0005&\u00111)\u0006\u0002\b\u0005>|G.Z1o\u0011\u0015)u\u00011\u0001G\u0003%!\u0018.\\3pkRl5\u000f\u0005\u0002\u0015\u000f&\u0011\u0001*\u0006\u0002\u0005\u0019>tw-\u0001\u0003tSj,W#A&\u0011\u0005Qa\u0015BA'\u0016\u0005\rIe\u000e^\u0001\tg\",H\u000fZ8x]R\tq\u0007")
public class MockTimer
implements Timer {
    private final MockTime time = new MockTime();
    private final PriorityQueue<TimerTaskEntry> taskQueue = (PriorityQueue)PriorityQueue$.MODULE$.apply((Seq)Nil$.MODULE$, package$.MODULE$.Ordering().apply(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).reverse());

    public MockTime time() {
        return this.time;
    }

    private PriorityQueue<TimerTaskEntry> taskQueue() {
        return this.taskQueue;
    }

    public void add(TimerTask timerTask) {
        if (timerTask.delayMs() <= 0L) {
            timerTask.run();
        } else {
            PriorityQueue<TimerTaskEntry> priorityQueue = this.taskQueue();
            synchronized (priorityQueue) {
                this.taskQueue().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimerTaskEntry[]{new TimerTaskEntry(timerTask, timerTask.delayMs() + this.time().milliseconds())}));
            }
        }
    }

    public boolean advanceClock(long timeoutMs) {
        this.time().sleep(timeoutMs);
        BooleanRef executed = BooleanRef.create((boolean)false);
        long now = this.time().milliseconds();
        boolean hasMore = true;
        while (hasMore) {
            None$ none$;
            hasMore = false;
            PriorityQueue<TimerTaskEntry> priorityQueue = this.taskQueue();
            synchronized (priorityQueue) {
                None$ none$2;
                if (this.taskQueue().nonEmpty() && now > ((TimerTaskEntry)this.taskQueue().head()).expirationMs()) {
                    Some entry = new Some(this.taskQueue().dequeue());
                    hasMore = this.taskQueue().nonEmpty();
                    none$2 = entry;
                } else {
                    none$2 = None$.MODULE$;
                }
                none$ = none$2;
            }
            None$ head = none$;
            head.foreach((Function1 & java.io.Serializable & Serializable)taskEntry -> {
                MockTimer.$anonfun$advanceClock$1(executed, taskEntry);
                return BoxedUnit.UNIT;
            });
        }
        return executed.elem;
    }

    public int size() {
        return this.taskQueue().size();
    }

    public void shutdown() {
    }

    public static final /* synthetic */ void $anonfun$advanceClock$1(BooleanRef executed$1, TimerTaskEntry taskEntry) {
        block0: {
            if (taskEntry.cancelled()) break block0;
            TimerTask task = taskEntry.timerTask();
            task.run();
            executed$1.elem = true;
        }
    }
}

