/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignPartitionsIntegrationTest$LogDirReassignment$;
import kafka.admin.ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$;
import kafka.api.KAFKA_2_7_IV1$;
import kafka.server.IsrChangePropagationConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.server.ZkIsrManager$;
import kafka.utils.Implicits;
import kafka.utils.Implicits$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.LogDirDescription;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@Timeout(value=300L)
@ScalaSignature(bytes="\u0006\u0001\u0011ua\u0001B1c\u0001\u001dDQA\u001c\u0001\u0005\u0002=DqA\u001d\u0001A\u0002\u0013\u00051\u000fC\u0005\u0002r\u0002\u0001\r\u0011\"\u0001\u0002t\"9\u0011q\u001f\u0001!B\u0013!\bbBA}\u0001\u0011\u0005\u0013\u0011\u001c\u0005\n\u0005#\u0001!\u0019!C\u0001\u0005'A\u0001Ba\n\u0001A\u0003%!Q\u0003\u0005\b\u0005S\u0001A\u0011AAm\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u00033DqAa\u000e\u0001\t\u0003\tI\u000eC\u0004\u0003<\u0001!\t!!7\t\u000f\tu\u0002\u0001\"\u0001\u0002Z\"9!\u0011\t\u0001\u0005\u0002\u0005e\u0007b\u0002B#\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0005\u0013\u0002A\u0011AAm\u0011\u001d\u0011i\u0005\u0001C\u0001\u00033DqA!\u0015\u0001\t\u0013\u0011\u0019\u0006C\u0004\u0003d\u0001!IA!\u001a\t\u000f\t5\u0004\u0001\"\u0003\u0003p!9!\u0011\u0010\u0001\u0005\n\tm\u0004b\u0002BB\u0001\u0011%!Q\u0011\u0005\b\u0005\u0017\u0003A\u0011AAm\u0011\u001d\u0011y\t\u0001C\u0001\u000334aAa%\u0001\u0001\nU\u0005B\u0003BU1\tU\r\u0011\"\u0001\u0002\u0010!Q!1\u0016\r\u0003\u0012\u0003\u0006I!!\u0005\t\u0015\t5\u0006D!f\u0001\n\u0003\ty\u0001\u0003\u0006\u00030b\u0011\t\u0012)A\u0005\u0003#A!B!-\u0019\u0005+\u0007I\u0011AA\b\u0011)\u0011\u0019\f\u0007B\tB\u0003%\u0011\u0011\u0003\u0005\u0007]b!\tA!.\t\u0013\t}\u0006$!A\u0005\u0002\t\u0005\u0007\"\u0003Be1E\u0005I\u0011\u0001Bf\u0011%\u0011\t\u000fGI\u0001\n\u0003\u0011Y\rC\u0005\u0003db\t\n\u0011\"\u0001\u0003L\"I!Q\u001d\r\u0002\u0002\u0013\u0005#q\u001d\u0005\n\u0005SD\u0012\u0011!C\u0001\u0005WD\u0011B!<\u0019\u0003\u0003%\tAa<\t\u0013\te\b$!A\u0005B\tm\b\"CB\u00021\u0005\u0005I\u0011AB\u0003\u0011%\u0019y\u0001GA\u0001\n\u0003\u001a\t\u0002C\u0005\u0004\u0014a\t\t\u0011\"\u0011\u0004\u0016!I1q\u0003\r\u0002\u0002\u0013\u00053\u0011D\u0004\n\u0007;\u0001\u0011\u0011!E\u0001\u0007?1\u0011Ba%\u0001\u0003\u0003E\ta!\t\t\r9lC\u0011AB\u0018\u0011%\u0019\u0019\"LA\u0001\n\u000b\u001a)\u0002C\u0005\u000425\n\t\u0011\"!\u00044!I11H\u0017\u0002\u0002\u0013\u00055Q\b\u0005\b\u0007\u001f\u0002A\u0011BB)\u0011\u001d\u0019Y\u0007\u0001C\u0005\u0007[Bqaa$\u0001\t\u0013\u0019\t\nC\u0004\u0004\u001e\u0002!Iaa(\t\u000f\rE\u0006\u0001\"\u0003\u00044\u001a111\u001a\u0001\u0001\u0007\u001bD!ba48\u0005\u0003\u0005\u000b\u0011BBi\u0011)\u0019)g\u000eBC\u0002\u0013\u0005!1\u001e\u0005\u000b\u0007/<$\u0011!Q\u0001\n\u0005}\u0002B\u000288\t\u0003\u0019I\u000eC\u0005\u0004b^\u0012\r\u0011\"\u0001\u0004d\"A11^\u001c!\u0002\u0013\u0019)\u000fC\u0005\u0004n^\u0012\r\u0011\"\u0001\u0004p\"A1q_\u001c!\u0002\u0013\u0019\t\u0010C\u0005\u0004z^\u0012\r\u0011\"\u0001\u0004p\"A11`\u001c!\u0002\u0013\u0019\tP\u0002\u0003w\u0001\u00019\bBCA\u0007\u0005\n\u0015\r\u0011\"\u0001\u0002\u0010!Q\u00111\u0006\"\u0003\u0002\u0003\u0006I!!\u0005\t\u0015\u00055\"I!A!\u0002\u0013\ty\u0003\u0003\u0006\u0002<\t\u0013\t\u0011)A\u0005\u0003{AaA\u001c\"\u0005\u0002\u0005\u001d\u0003\"CA(\u0005\n\u0007I\u0011AA)\u0011!\tIF\u0011Q\u0001\n\u0005M\u0003\"CA.\u0005\n\u0007I\u0011AA/\u0011!\tIG\u0011Q\u0001\n\u0005}\u0003\"CA6\u0005\n\u0007I\u0011AA7\u0011!\t9I\u0011Q\u0001\n\u0005=\u0004\"CAE\u0005\u0002\u0007I\u0011AAF\u0011%\tIJ\u0011a\u0001\n\u0003\tY\n\u0003\u0005\u0002(\n\u0003\u000b\u0015BAG\u0011%\tIK\u0011a\u0001\n\u0003\ty\u0001C\u0005\u0002,\n\u0003\r\u0011\"\u0001\u0002.\"A\u0011\u0011\u0017\"!B\u0013\t\t\u0002C\u0005\u00024\n\u0003\r\u0011\"\u0001\u00026\"I\u0011q\u001a\"A\u0002\u0013\u0005\u0011\u0011\u001b\u0005\t\u0003+\u0014\u0005\u0015)\u0003\u00028\"9\u0011q\u001b\"\u0005\u0002\u0005e\u0007bBAn\u0005\u0012\u0005\u0011\u0011\u001c\u0005\b\u0003;\u0014E\u0011AAm\u0011\u001d\tyN\u0011C\u0001\u0003CDq!a<C\t\u0003\nInB\u0005\u0004~\u0002\t\t\u0011#\u0001\u0004\u0000\u001aAa\u000fAA\u0001\u0012\u0003!\t\u0001\u0003\u0004o;\u0012\u0005A1\u0001\u0005\n\t\u000bi\u0016\u0013!C\u0001\t\u000fA\u0011\u0002b\u0003^#\u0003%\t\u0001\"\u0004\u0003CI+\u0017m]:jO:\u0004\u0016M\u001d;ji&|gn]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005\r$\u0017!B1e[&t'\"A3\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u001b\t\u0003S2l\u0011A\u001b\u0006\u0003W\u0012\faa]3sm\u0016\u0014\u0018BA7k\u0005E\tVo\u001c:v[R+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003A\u0004\"!\u001d\u0001\u000e\u0003\t\fqa\u00197vgR,'/F\u0001u!\t)()D\u0001\u0001\u0005u\u0011V-Y:tS\u001et\u0007+\u0019:uSRLwN\\:UKN$8\t\\;ti\u0016\u00148\u0003\u0002\"y\u0003\u0003\u0001\"!\u001f@\u000e\u0003iT!a\u001f?\u0002\t1\fgn\u001a\u0006\u0002{\u0006!!.\u0019<b\u0013\ty(P\u0001\u0004PE*,7\r\u001e\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001?\u0002\u0005%|\u0017\u0002BA\u0006\u0003\u000b\u0011\u0011b\u00117pg\u0016\f'\r\\3\u0002\u0013i\\7i\u001c8oK\u000e$XCAA\t!\u0011\t\u0019\"!\n\u000f\t\u0005U\u0011\u0011\u0005\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111\u00044\u0002\rq\u0012xn\u001c;?\u0015\t\ty\"A\u0003tG\u0006d\u0017-\u0003\u0003\u0002$\u0005u\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002(\u0005%\"AB*ue&twM\u0003\u0003\u0002$\u0005u\u0011A\u0003>l\u0007>tg.Z2uA\u0005y1m\u001c8gS\u001e|e/\u001a:sS\u0012,7\u000f\u0005\u0005\u00022\u0005]\u0012\u0011CA\t\u001b\t\t\u0019D\u0003\u0003\u00026\u0005u\u0011AC2pY2,7\r^5p]&!\u0011\u0011HA\u001a\u0005\ri\u0015\r]\u0001\u0016EJ|7.\u001a:D_:4\u0017nZ(wKJ\u0014\u0018\u000eZ3t!!\t\t$a\u000e\u0002@\u0005=\u0002\u0003BA!\u0003\u0007j!!!\b\n\t\u0005\u0015\u0013Q\u0004\u0002\u0004\u0013:$Hc\u0002;\u0002J\u0005-\u0013Q\n\u0005\b\u0003\u001b9\u0005\u0019AA\t\u0011%\tic\u0012I\u0001\u0002\u0004\ty\u0003C\u0005\u0002<\u001d\u0003\n\u00111\u0001\u0002>\u00059!M]8lKJ\u001cXCAA*!!\t\t$a\u000e\u0002@\u0005U\u0003cA=\u0002X%\u0019\u0011q\u0005>\u0002\u0011\t\u0014xn[3sg\u0002\na\u0001^8qS\u000e\u001cXCAA0!!\t\t$a\u000e\u0002V\u0005\u0005\u0004CBA\u0019\u0003G\n9'\u0003\u0003\u0002f\u0005M\"aA*fcB1\u0011\u0011GA2\u0003\u007f\tq\u0001^8qS\u000e\u001c\b%A\u0007ce>\\WM]\"p]\u001aLwm]\u000b\u0003\u0003_\u0002b!!\u001d\u0002x\u0005mTBAA:\u0015\u0011\t)(a\r\u0002\u000f5,H/\u00192mK&!\u0011\u0011PA:\u0005\u0019\u0011UO\u001a4feB!\u0011QPAB\u001b\t\tyHC\u0002\u0002\u0002r\fA!\u001e;jY&!\u0011QQA@\u0005)\u0001&o\u001c9feRLWm]\u0001\u000fEJ|7.\u001a:D_:4\u0017nZ:!\u0003\u001d\u0019XM\u001d<feN,\"!!$\u0011\r\u0005E\u0014qRAJ\u0013\u0011\t\t*a\u001d\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0004S\u0006U\u0015bAALU\nY1*\u00194lCN+'O^3s\u0003-\u0019XM\u001d<feN|F%Z9\u0015\t\u0005u\u00151\u0015\t\u0005\u0003\u0003\ny*\u0003\u0003\u0002\"\u0006u!\u0001B+oSRD\u0011\"!*P\u0003\u0003\u0005\r!!$\u0002\u0007a$\u0013'\u0001\u0005tKJ4XM]:!\u0003)\u0011'o\\6fe2K7\u000f^\u0001\u000fEJ|7.\u001a:MSN$x\fJ3r)\u0011\ti*a,\t\u0013\u0005\u0015&+!AA\u0002\u0005E\u0011a\u00032s_.,'\u000fT5ti\u0002\n1\"\u00193nS:\u001cE.[3oiV\u0011\u0011q\u0017\t\u0005\u0003s\u000bY-\u0004\u0002\u0002<*\u00191-!0\u000b\t\u0005}\u0016\u0011Y\u0001\bG2LWM\u001c;t\u0015\r)\u00171\u0019\u0006\u0005\u0003\u000b\f9-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0013\f1a\u001c:h\u0013\u0011\ti-a/\u0003\u000b\u0005#W.\u001b8\u0002\u001f\u0005$W.\u001b8DY&,g\u000e^0%KF$B!!(\u0002T\"I\u0011QU+\u0002\u0002\u0003\u0007\u0011qW\u0001\rC\u0012l\u0017N\\\"mS\u0016tG\u000fI\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0003\u0003;\u000bQb\u0019:fCR,7+\u001a:wKJ\u001c\u0018\u0001D2sK\u0006$X\rV8qS\u000e\u001c\u0018a\u00049s_\u0012,8-Z'fgN\fw-Z:\u0015\u0011\u0005u\u00151]At\u0003WDq!!:[\u0001\u0004\t\t\"A\u0003u_BL7\rC\u0004\u0002jj\u0003\r!a\u0010\u0002\u0013A\f'\u000f^5uS>t\u0007bBAw5\u0002\u0007\u0011qH\u0001\f]VlW*Z:tC\u001e,7/A\u0003dY>\u001cX-A\u0006dYV\u001cH/\u001a:`I\u0015\fH\u0003BAO\u0003kD\u0001\"!*\u0004\u0003\u0003\u0005\r\u0001^\u0001\tG2,8\u000f^3sA\u0005AA/Z1s\t><h\u000eK\u0002\u0006\u0003{\u0004B!a@\u0003\u000e5\u0011!\u0011\u0001\u0006\u0005\u0005\u0007\u0011)!A\u0002ba&TAAa\u0002\u0003\n\u00059!.\u001e9ji\u0016\u0014(\u0002\u0002B\u0006\u0003\u000f\fQA[;oSRLAAa\u0004\u0003\u0002\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0019k:$\bN]8ui2,GM\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001cXC\u0001B\u000b!!\u00119B!\b\u0002@\t}QB\u0001B\r\u0015\u0011\u0011Y\"a\r\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BA\u001d\u00053\u0001\u0002Ba\u0006\u0003\u001e\u0005U#\u0011\u0005\t\u0005\u0003\u0003\u0012\u0019#\u0003\u0003\u0003&\u0005u!\u0001\u0002'p]\u001e\f\u0011$\u001e8uQJ|G\u000f\u001e7fI\n\u0013xn[3s\u0007>tg-[4tA\u0005\u0001B/Z:u%\u0016\f7o]5h]6,g\u000e\u001e\u0015\u0004\u0011\t5\u0002\u0003BA\u0000\u0005_IAA!\r\u0003\u0002\t!A+Z:u\u0003\u0011\"Xm\u001d;SK\u0006\u001c8/[4o[\u0016tGoV5uQ\u0006cG/\u001a:JgJ$\u0015n]1cY\u0016$\u0007fA\u0005\u0003.\u0005qC/Z:u%\u0016\f7o]5h]6,g\u000e^\"p[BdW\r^5p]\u0012+(/\u001b8h!\u0006\u0014H/[1m+B<'/\u00193fQ\rQ!QF\u0001\u001dKb,7-\u001e;f\u0003:$g+\u001a:jMf\u0014V-Y:tS\u001etW.\u001a8u\u0003-\"Xm\u001d;IS\u001eDw+\u0019;fe6\u000b'o[!gi\u0016\u0014\b+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8nK:$\bf\u0001\u0007\u0003.\u0005iB/Z:u\u00032$XM\u001d*fCN\u001c\u0018n\u001a8nK:$H\u000b\u001b:piRdW\rK\u0002\u000e\u0005[\t\u0011\u0004^3tiRC'o\u001c;uY\u0016$'+Z1tg&<g.\\3oi\"\u001aaB!\f\u0002_Q,7\u000f\u001e)s_\u0012,8-Z!oI\u000e{gn];nK^KG\u000f\u001b*fCN\u001c\u0018n\u001a8nK:$\u0018J\u001c)s_\u001e\u0014Xm]:)\u0007=\u0011i#\u0001\tuKN$8)\u00198dK2d\u0017\r^5p]\"\u001a\u0001C!\f\u0002+]\f\u0017\u000e\u001e$pe2{w\rR5s)\"\u0014x\u000e\u001e;mKR1\u0011Q\u0014B+\u0005?BqAa\u0016\u0012\u0001\u0004\u0011I&\u0001\tuQJ|G\u000f\u001e7fI\n\u0013xn[3sgB1\u00111\u0003B.\u0003\u007fIAA!\u0018\u0002*\t\u00191+\u001a;\t\u000f\t\u0005\u0014\u00031\u0001\u0003\"\u0005qAn\\4ESJ$\u0006N]8ui2,\u0017AG<bSR4uN]%oi\u0016\u0014(I]8lKJ$\u0006N]8ui2,GCBAO\u0005O\u0012I\u0007C\u0004\u0003XI\u0001\rA!\u0017\t\u000f\t-$\u00031\u0001\u0003\"\u0005\u0019\u0012N\u001c;fe\n\u0013xn[3s)\"\u0014x\u000e\u001e;mK\u00061r/Y5u\r>\u0014(I]8lKJ$\u0006N]8ui2,7\u000f\u0006\u0004\u0002\u001e\nE$1\u000f\u0005\b\u0005/\u001a\u0002\u0019\u0001B-\u0011\u001d\u0011)h\u0005a\u0001\u0005o\na\u0002\u001e5s_R$H.Z\"p]\u001aLw\r\u0005\u0005\u00022\u0005]\u0012\u0011\u0003B\u0011\u0003m9\u0018-\u001b;G_J\u0014%o\\6fe2+g/\u001a7UQJ|G\u000f\u001e7fgR!\u0011Q\u0014B?\u0011\u001d\u0011y\b\u0006a\u0001\u0005\u0003\u000bq\u0002^1sO\u0016$H\u000b\u001b:piRdWm\u001d\t\t\u0003c\t9$a\u0010\u0003x\u0005aB-Z:de&\u0014WM\u0011:pW\u0016\u0014H*\u001a<fYRC'o\u001c;uY\u0016\u001cH\u0003\u0002BA\u0005\u000fCqA!#\u0016\u0001\u0004\t9'A\u0005ce>\\WM]%eg\u00061B/Z:u\u0019><G)\u001b:SK\u0006\u001c8/[4o[\u0016tG\u000fK\u0002\u0017\u0005[\t1\u0005^3ti\u0006cG/\u001a:M_\u001e$\u0015N\u001d*fCN\u001c\u0018n\u001a8nK:$H\u000b\u001b:piRdW\rK\u0002\u0018\u0005[\u0011!\u0003T8h\t&\u0014(+Z1tg&<g.\\3oiN9\u0001Da&\u0003\u001e\n\r\u0006\u0003BA!\u00053KAAa'\u0002\u001e\t1\u0011I\\=SK\u001a\u0004B!!\u0011\u0003 &!!\u0011UA\u000f\u0005\u001d\u0001&o\u001c3vGR\u0004B!!\u0011\u0003&&!!qUA\u000f\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011Q7o\u001c8\u0002\u000b)\u001cxN\u001c\u0011\u0002\u0015\r,(O]3oi\u0012K'/A\u0006dkJ\u0014XM\u001c;ESJ\u0004\u0013!\u0003;be\u001e,G\u000fR5s\u0003)!\u0018M]4fi\u0012K'\u000f\t\u000b\t\u0005o\u0013ILa/\u0003>B\u0011Q\u000f\u0007\u0005\b\u0005S{\u0002\u0019AA\t\u0011\u001d\u0011ik\ba\u0001\u0003#AqA!- \u0001\u0004\t\t\"\u0001\u0003d_BLH\u0003\u0003B\\\u0005\u0007\u0014)Ma2\t\u0013\t%\u0006\u0005%AA\u0002\u0005E\u0001\"\u0003BWAA\u0005\t\u0019AA\t\u0011%\u0011\t\f\tI\u0001\u0002\u0004\t\t\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t5'\u0006BA\t\u0005\u001f\\#A!5\u0011\t\tM'Q\\\u0007\u0003\u0005+TAAa6\u0003Z\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u00057\fi\"\u0001\u0006b]:|G/\u0019;j_:LAAa8\u0003V\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002V\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011qH\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011\tPa>\u0011\t\u0005\u0005#1_\u0005\u0005\u0005k\fiBA\u0002B]fD\u0011\"!*'\u0003\u0003\u0005\r!a\u0010\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!@\u0011\r\u0005E\"q By\u0013\u0011\u0019\t!a\r\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0007\u000f\u0019i\u0001\u0005\u0003\u0002B\r%\u0011\u0002BB\u0006\u0003;\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002&\"\n\t\u00111\u0001\u0003r\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002@\u0005AAo\\*ue&tw\r\u0006\u0002\u0002V\u00051Q-];bYN$Baa\u0002\u0004\u001c!I\u0011QU\u0016\u0002\u0002\u0003\u0007!\u0011_\u0001\u0013\u0019><G)\u001b:SK\u0006\u001c8/[4o[\u0016tG\u000f\u0005\u0002v[M)Qfa\t\u0003$Ba1QEB\u0016\u0003#\t\t\"!\u0005\u000386\u00111q\u0005\u0006\u0005\u0007S\ti\"A\u0004sk:$\u0018.\\3\n\t\r52q\u0005\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDCAB\u0010\u0003\u0015\t\u0007\u000f\u001d7z)!\u00119l!\u000e\u00048\re\u0002b\u0002BUa\u0001\u0007\u0011\u0011\u0003\u0005\b\u0005[\u0003\u0004\u0019AA\t\u0011\u001d\u0011\t\f\ra\u0001\u0003#\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004@\r-\u0003CBA!\u0007\u0003\u001a)%\u0003\u0003\u0004D\u0005u!AB(qi&|g\u000e\u0005\u0006\u0002B\r\u001d\u0013\u0011CA\t\u0003#IAa!\u0013\u0002\u001e\t1A+\u001e9mKNB\u0011b!\u00142\u0003\u0003\u0005\rAa.\u0002\u0007a$\u0003'A\fck&dG\rT8h\t&\u0014(+Z1tg&<g.\\3oiRA!qWB*\u0007G\u001a9\u0007C\u0004\u0004VI\u0002\raa\u0016\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!1\u0011LB0\u001b\t\u0019YF\u0003\u0003\u0004^\u0005\u0005\u0017AB2p[6|g.\u0003\u0003\u0004b\rm#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0007K\u0012\u0004\u0019AA \u0003!\u0011'o\\6fe&#\u0007bBB5e\u0001\u0007\u0011qM\u0001\te\u0016\u0004H.[2bg\u0006\u0019\"/\u001e8WKJLg-_!tg&<g.\\3oiRA1qNBC\u0007\u000f\u001bY\t\u0005\u0003\u0004r\r}d\u0002BB:\u0007wrAa!\u001e\u0004z9!\u0011qCB<\u0013\u0005)\u0017BA2e\u0013\r\u0019iHY\u0001\u001a%\u0016\f7o]5h]B\u000b'\u000f^5uS>t7oQ8n[\u0006tG-\u0003\u0003\u0004\u0002\u000e\r%A\u0006,fe&4\u00170Q:tS\u001etW.\u001a8u%\u0016\u001cX\u000f\u001c;\u000b\u0007\ru$\rC\u0004\u00024N\u0002\r!a.\t\u000f\r%5\u00071\u0001\u0002\u0012\u0005Q!n]8o'R\u0014\u0018N\\4\t\u000f\r55\u00071\u0001\u0004\b\u0005\t\u0002O]3tKJ4X\r\u00165s_R$H.Z:\u0002/]\f\u0017\u000e\u001e$peZ+'/\u001b4z\u0003N\u001c\u0018n\u001a8nK:$HCCAO\u0007'\u001b)ja&\u0004\u001a\"9\u00111\u0017\u001bA\u0002\u0005]\u0006bBBEi\u0001\u0007\u0011\u0011\u0003\u0005\b\u0007\u001b#\u0004\u0019AB\u0004\u0011\u001d\u0019Y\n\u000ea\u0001\u0007_\na\"\u001a=qK\u000e$X\r\u001a*fgVdG/\u0001\u000bsk:,\u00050Z2vi\u0016\f5o]5h]6,g\u000e\u001e\u000b\r\u0003;\u001b\tka)\u0004(\u000e-6Q\u0016\u0005\b\u0003g+\u0004\u0019AA\\\u0011\u001d\u0019)+\u000ea\u0001\u0007\u000f\t!\"\u00193eSRLwN\\1m\u0011\u001d\u0019I+\u000ea\u0001\u0003#\t\u0001C]3bgNLwM\\7f]RT5o\u001c8\t\u000f\t-T\u00071\u0001\u0003\"!91qV\u001bA\u0002\t\u0005\u0012a\u0007:fa2L7-Y!mi\u0016\u0014Hj\\4ESJ\u001cH\u000b\u001b:piRdW-A\nsk:\u001c\u0015M\\2fY\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0005\u00046\u000e\u00157qYBe!!\t\tea.\u0004<\u000eu\u0016\u0002BB]\u0003;\u0011a\u0001V;qY\u0016\u0014\u0004CBA\n\u00057\u001a9\u0006\u0005\u0004\u0002\u0014\tm3q\u0018\t\u0005\u00073\u001a\t-\u0003\u0003\u0004D\u000em#!\u0006+pa&\u001c\u0007+\u0019:uSRLwN\u001c*fa2L7-\u0019\u0005\b\u0003g3\u0004\u0019AA\\\u0011\u001d\u0019II\u000ea\u0001\u0003#Aqa!$7\u0001\u0004\u00199A\u0001\u0006Ce>\\WM\u001d#jeN\u001c2a\u000eBL\u0003\u0019\u0011Xm];miB!\u0011\u0011XBj\u0013\u0011\u0019).a/\u0003+\u0011+7o\u0019:jE\u0016dun\u001a#jeN\u0014Vm];mi\u0006I!M]8lKJLE\r\t\u000b\u0007\u00077\u001cina8\u0011\u0005U<\u0004bBBhw\u0001\u00071\u0011\u001b\u0005\b\u0007KZ\u0004\u0019AA \u0003\u001dawn\u001a#jeN,\"a!:\u0011\r\u0005E4q]A\t\u0013\u0011\u0019I/a\u001d\u0003\u000f!\u000b7\u000f[*fi\u0006AAn\\4ESJ\u001c\b%\u0001\u0006dkJdun\u001a#jeN,\"a!=\u0011\u0011\u0005E41_B,\u0003#IAa!>\u0002t\t9\u0001*Y:i\u001b\u0006\u0004\u0018aC2ve2{w\rR5sg\u0002\nQBZ;ukJ,Gj\\4ESJ\u001c\u0018A\u00044viV\u0014X\rT8h\t&\u00148\u000fI\u0001\u001e%\u0016\f7o]5h]B\u000b'\u000f^5uS>t7\u000fV3ti\u000ecWo\u001d;feB\u0011Q/X\n\u0004;\n]ECAB\u0000\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011A\u0011\u0002\u0016\u0005\u0003_\u0011y-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\t\u001fQC!!\u0010\u0003P\":\u0001\u0001b\u0005\u0005\u001a\u0011m\u0001\u0003BA\u0000\t+IA\u0001b\u0006\u0003\u0002\t9A+[7f_V$\u0018!\u0002<bYV,gDA\u0001-\u0001")
public class ReassignPartitionsIntegrationTest
extends QuorumTestHarness {
    private volatile ReassignPartitionsIntegrationTest$LogDirReassignment$ LogDirReassignment$module;
    private volatile ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$ ReassignPartitionsTestCluster$module;
    private ReassignPartitionsTestCluster cluster = null;
    private final scala.collection.immutable.Map<Object, scala.collection.immutable.Map<String, Object>> unthrottledBrokerConfigs = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)brokerId -> ReassignPartitionsIntegrationTest.$anonfun$unthrottledBrokerConfigs$1(BoxesRunTime.unboxToInt((Object)brokerId)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());

    public ReassignPartitionsIntegrationTest$LogDirReassignment$ LogDirReassignment() {
        if (this.LogDirReassignment$module == null) {
            this.LogDirReassignment$lzycompute$1();
        }
        return this.LogDirReassignment$module;
    }

    public ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$ ReassignPartitionsTestCluster() {
        if (this.ReassignPartitionsTestCluster$module == null) {
            this.ReassignPartitionsTestCluster$lzycompute$1();
        }
        return this.ReassignPartitionsTestCluster$module;
    }

    public ReassignPartitionsTestCluster cluster() {
        return this.cluster;
    }

    public void cluster_$eq(ReassignPartitionsTestCluster x$1) {
        this.cluster = x$1;
    }

    @Override
    @AfterEach
    public void tearDown() {
        Utils.closeQuietly((AutoCloseable)this.cluster(), (String)"ReassignPartitionsTestCluster");
        super.tearDown();
    }

    public scala.collection.immutable.Map<Object, scala.collection.immutable.Map<String, Object>> unthrottledBrokerConfigs() {
        return this.unthrottledBrokerConfigs;
    }

    @Test
    public void testReassignment() {
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$2(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$3()));
        this.cluster().setup();
        this.executeAndVerifyReassignment();
    }

    @Test
    public void testReassignmentWithAlterIsrDisabled() {
        Map configOverrides = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp()), (Object)KAFKA_2_7_IV1$.MODULE$.version())}));
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), (Map<String, String>)configOverrides, this.ReassignPartitionsTestCluster().$lessinit$greater$default$3()));
        this.cluster().setup();
        this.executeAndVerifyReassignment();
    }

    @Test
    public void testReassignmentCompletionDuringPartialUpgrade() {
        long x$1 = 500L;
        long x$2 = 100L;
        long x$3 = 500L;
        ZkIsrManager$.MODULE$.DefaultIsrPropagationConfig_$eq(new IsrChangePropagationConfig(x$1, x$3, x$2));
        Map oldIbpConfig = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp()), (Object)KAFKA_2_7_IV1$.MODULE$.version())}));
        Map brokerConfigOverrides = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)oldIbpConfig), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)oldIbpConfig), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)oldIbpConfig)}));
        String x$4 = this.zkConnect();
        Map<String, String> x$6 = this.ReassignPartitionsTestCluster().$lessinit$greater$default$2();
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, x$4, x$6, (Map<Object, Map<String, String>>)brokerConfigOverrides));
        this.cluster().setup();
        this.executeAndVerifyReassignment();
    }

    public void executeAndVerifyReassignment() {
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1,3],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"bar\",\"partition\":0,\"replicas\":[3,2,0],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        Map initialAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 0})), true))}));
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(initialAssignment, ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$2(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$3(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$4()));
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, -1L, -1L);
        Assertions.assertEquals(this.unthrottledBrokerConfigs(), this.describeBrokerLevelThrottles((Seq<Object>)this.unthrottledBrokerConfigs().keySet().toSeq()));
        Map finalAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 0})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 0})), true))}));
        Assertions.assertFalse((boolean)this.runVerifyAssignment(this.cluster().adminClient(), assignment, false).movesOngoing());
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$2(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$3(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$4()));
        Assertions.assertEquals(this.unthrottledBrokerConfigs(), this.describeBrokerLevelThrottles((Seq<Object>)this.unthrottledBrokerConfigs().keySet().toSeq()));
    }

    @Test
    public void testHighWaterMarkAfterPartitionReassignment() {
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$2(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$3()));
        this.cluster().setup();
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[3,1,2],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        TopicPartition part = new TopicPartition("foo", 0);
        ((KafkaServer)this.cluster().servers().apply(0)).replicaManager().logManager().truncateFullyAndStartAt(part, 123L, false);
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, -1L, -1L);
        Map finalAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)part), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), true))}));
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$2(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$3(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$4()));
        long x$3 = 10L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReassignPartitionsIntegrationTest.$anonfun$testHighWaterMarkAfterPartitionReassignment$1(this, part)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)ReassignPartitionsIntegrationTest.$anonfun$testHighWaterMarkAfterPartitionReassignment$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), x$3));
        }
        Assertions.assertEquals((long)123L, (long)((KafkaServer)this.cluster().servers().apply(3)).replicaManager().localLogOrException(part).highWatermark(), (String)"Expected broker 3 to have the correct high water mark for the partition.");
    }

    @Test
    public void testAlterReassignmentThrottle() {
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$2(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$3()));
        this.cluster().setup();
        this.cluster().produceMessages("foo", 0, 50);
        this.cluster().produceMessages("baz", 2, 60);
        String assignment = "{\"version\":1,\"partitions\":\n      [{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,3,2],\"log_dirs\":[\"any\",\"any\",\"any\"]},\n      {\"topic\":\"baz\",\"partition\":2,\"replicas\":[3,2,1],\"log_dirs\":[\"any\",\"any\",\"any\"]}\n      ]}";
        long initialThrottle = 1L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, initialThrottle, -1L);
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), initialThrottle);
        long updatedThrottle = 300000L;
        this.runExecuteAssignment(this.cluster().adminClient(), true, assignment, updatedThrottle, -1L);
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), updatedThrottle);
        Map finalAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 2)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), true))}));
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$2(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$3(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$4()));
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)this.unthrottledBrokerConfigs());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testThrottledReassignment() {
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$2(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$3()));
        this.cluster().setup();
        this.cluster().produceMessages("foo", 0, 50);
        this.cluster().produceMessages("baz", 2, 60);
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,3,2],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"baz\",\"partition\":2,\"replicas\":[3,2,1],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        Map initialAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 2)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), true))}));
        Assertions.assertEquals((Object)new ReassignPartitionsCommand.VerifyAssignmentResult(initialAssignment, ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$2(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$3(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$4()), (Object)this.runVerifyAssignment(this.cluster().adminClient(), assignment, false));
        Assertions.assertEquals(this.unthrottledBrokerConfigs(), this.describeBrokerLevelThrottles((Seq<Object>)this.unthrottledBrokerConfigs().keySet().toSeq()));
        long interBrokerThrottle = 300000L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, interBrokerThrottle, -1L);
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), interBrokerThrottle);
        Map finalAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 2)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), true))}));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReassignPartitionsIntegrationTest.$anonfun$testThrottledReassignment$1(this, assignment, interBrokerThrottle)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReassignPartitionsIntegrationTest.$anonfun$testThrottledReassignment$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, true, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$2(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$3(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$4()));
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), interBrokerThrottle);
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$2(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$3(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$4()));
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)this.unthrottledBrokerConfigs());
    }

    @Test
    public void testProduceAndConsumeWithReassignmentInProgress() {
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$2(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$3()));
        this.cluster().setup();
        this.cluster().produceMessages("baz", 2, 60);
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"baz\",\"partition\":2,\"replicas\":[3,2,1],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, 300L, -1L);
        this.cluster().produceMessages("baz", 2, 100);
        TopicPartition part = new TopicPartition("baz", 2);
        try (KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(this.cluster().brokerList(), TestUtils$.MODULE$.createConsumer$default$2(), TestUtils$.MODULE$.createConsumer$default$3(), TestUtils$.MODULE$.createConsumer$default$4(), TestUtils$.MODULE$.createConsumer$default$5(), TestUtils$.MODULE$.createConsumer$default$6(), TestUtils$.MODULE$.createConsumer$default$7(), TestUtils$.MODULE$.createConsumer$default$8(), TestUtils$.MODULE$.createConsumer$default$9(), TestUtils$.MODULE$.createConsumer$default$10(), TestUtils$.MODULE$.createConsumer$default$11());){
            consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)part, (List)Nil$.MODULE$)).asJava());
            TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 100, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
        }
        TestUtils$.MODULE$.removeReplicationThrottleForPartitions(this.cluster().adminClient(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{part}))));
        Map finalAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)part), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), true))}));
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$2(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$3(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.apply$default$4()));
    }

    @Test
    public void testCancellation() {
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$2(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$3()));
        this.cluster().setup();
        this.cluster().produceMessages("foo", 0, 200);
        this.cluster().produceMessages("baz", 1, 200);
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1,3],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"baz\",\"partition\":1,\"replicas\":[0,2,3],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        Assertions.assertEquals(this.unthrottledBrokerConfigs(), this.describeBrokerLevelThrottles((Seq<Object>)this.unthrottledBrokerConfigs().keySet().toSeq()));
        long interBrokerThrottle = 1L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, interBrokerThrottle, -1L);
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), interBrokerThrottle);
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, true, new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 1)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3})), false))})), true, (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), false));
        Assertions.assertEquals((Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("baz", 1)})), (Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), this.runCancelAssignment(this.cluster().adminClient(), assignment, true));
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), interBrokerThrottle);
        Assertions.assertEquals((Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), this.runCancelAssignment(this.cluster().adminClient(), assignment, false));
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)this.unthrottledBrokerConfigs());
        Assertions.assertFalse((boolean)this.runVerifyAssignment(this.cluster().adminClient(), assignment, false).partsOngoing());
    }

    private void waitForLogDirThrottle(Set<Object> throttledBrokers, long logDirThrottle) {
        Map throttledConfigMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLeaderThrottle()), (Object)BoxesRunTime.boxToLong((long)-1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelFollowerThrottle()), (Object)BoxesRunTime.boxToLong((long)-1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle()), (Object)BoxesRunTime.boxToLong((long)logDirThrottle))}));
        this.waitForBrokerThrottles(throttledBrokers, (Map<String, Object>)throttledConfigMap);
    }

    private void waitForInterBrokerThrottle(Set<Object> throttledBrokers, long interBrokerThrottle) {
        Map throttledConfigMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLeaderThrottle()), (Object)BoxesRunTime.boxToLong((long)interBrokerThrottle)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelFollowerThrottle()), (Object)BoxesRunTime.boxToLong((long)interBrokerThrottle)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle()), (Object)BoxesRunTime.boxToLong((long)-1L))}));
        this.waitForBrokerThrottles(throttledBrokers, (Map<String, Object>)throttledConfigMap);
    }

    private void waitForBrokerThrottles(Set<Object> throttledBrokers, Map<String, Object> throttleConfig) {
        scala.collection.immutable.Map throttledBrokerConfigs = (scala.collection.immutable.Map)this.unthrottledBrokerConfigs().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int brokerId = x0$1._1$mcI$sp();
            scala.collection.immutable.Map unthrottledConfig = (scala.collection.immutable.Map)x0$1._2();
            Map expectedThrottleConfig = throttledBrokers.contains((Object)BoxesRunTime.boxToInteger((int)brokerId)) ? throttleConfig : unthrottledConfig;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Object)expectedThrottleConfig);
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)throttledBrokerConfigs);
    }

    private void waitForBrokerLevelThrottles(Map<Object, Map<String, Object>> targetThrottles) {
        ObjectRef curThrottles = ObjectRef.create((Object)Map$.MODULE$.empty());
        long x$3 = 25L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReassignPartitionsIntegrationTest.$anonfun$waitForBrokerLevelThrottles$1(this, curThrottles, targetThrottles)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)ReassignPartitionsIntegrationTest.$anonfun$waitForBrokerLevelThrottles$2(targetThrottles, curThrottles));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), x$3));
        }
    }

    private Map<Object, Map<String, Object>> describeBrokerLevelThrottles(Seq<Object> brokerIds) {
        return ((TraversableOnce)brokerIds.map((Function1 & Serializable & scala.Serializable)brokerId -> ReassignPartitionsIntegrationTest.$anonfun$describeBrokerLevelThrottles$1(this, BoxesRunTime.unboxToInt((Object)brokerId)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    @Test
    public void testLogDirReassignment() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$2(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$3()));
        this.cluster().setup();
        this.cluster().produceMessages(topicPartition.topic(), topicPartition.partition(), 700);
        int targetBrokerId = 0;
        Seq replicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        LogDirReassignment reassignment = this.buildLogDirReassignment(topicPartition, targetBrokerId, (Seq<Object>)replicas);
        long logDirThrottle = 1L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, reassignment.json(), -1L, logDirThrottle);
        this.waitForVerifyAssignment(this.cluster().adminClient(), reassignment.json(), true, new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), true))})), false, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topicPartition.topic(), topicPartition.partition(), 0)), (Object)new ReassignPartitionsCommand.ActiveMoveState(reassignment.currentDir(), reassignment.targetDir(), reassignment.targetDir()))})), true));
        this.waitForLogDirThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), logDirThrottle);
        this.cluster().adminClient().incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, "0"), Collections.singletonList(new AlterConfigOp(new ConfigEntry(ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle(), ""), AlterConfigOp.OpType.DELETE)))).all().get();
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)this.unthrottledBrokerConfigs());
        this.waitForVerifyAssignment(this.cluster().adminClient(), reassignment.json(), true, new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), true))})), false, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topicPartition.topic(), topicPartition.partition(), 0)), (Object)new ReassignPartitionsCommand.CompletedMoveState(reassignment.targetDir()))})), false));
        BrokerDirs info1 = new BrokerDirs(this, this.cluster().adminClient().describeLogDirs(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)x$3 -> ReassignPartitionsIntegrationTest.$anonfun$testLogDirReassignment$1(BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom())).asJavaCollection()), 0);
        Assertions.assertEquals((Object)reassignment.targetDir(), (Object)info1.curLogDirs().getOrElse((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> ""));
    }

    @Test
    public void testAlterLogDirReassignmentThrottle() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$2(), this.ReassignPartitionsTestCluster().$lessinit$greater$default$3()));
        this.cluster().setup();
        this.cluster().produceMessages(topicPartition.topic(), topicPartition.partition(), 700);
        int targetBrokerId = 0;
        Seq replicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        LogDirReassignment reassignment = this.buildLogDirReassignment(topicPartition, targetBrokerId, (Seq<Object>)replicas);
        long initialLogDirThrottle = 1L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, reassignment.json(), -1L, initialLogDirThrottle);
        this.waitForLogDirThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), initialLogDirThrottle);
        long updatedLogDirThrottle = 3000000L;
        this.runExecuteAssignment(this.cluster().adminClient(), true, reassignment.json(), -1L, updatedLogDirThrottle);
        this.waitForLogDirThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), updatedLogDirThrottle);
        this.waitForVerifyAssignment(this.cluster().adminClient(), reassignment.json(), true, new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), true))})), false, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topicPartition.topic(), topicPartition.partition(), targetBrokerId)), (Object)new ReassignPartitionsCommand.CompletedMoveState(reassignment.targetDir()))})), false));
    }

    private LogDirReassignment buildLogDirReassignment(TopicPartition topicPartition, int brokerId, Seq<Object> replicas) {
        DescribeLogDirsResult describeLogDirsResult = this.cluster().adminClient().describeLogDirs(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)x$4 -> ReassignPartitionsIntegrationTest.$anonfun$buildLogDirReassignment$1(BoxesRunTime.unboxToInt((Object)x$4)), IndexedSeq$.MODULE$.canBuildFrom())).asJavaCollection());
        BrokerDirs logDirInfo = new BrokerDirs(this, describeLogDirsResult, brokerId);
        Assertions.assertTrue((boolean)logDirInfo.futureLogDirs().isEmpty());
        String currentDir = (String)logDirInfo.curLogDirs().apply((Object)topicPartition);
        String newDir = (String)logDirInfo.logDirs().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsIntegrationTest.$anonfun$buildLogDirReassignment$2(currentDir, x$5))).get();
        Seq logDirs = (Seq)replicas.map((Function1 & Serializable & scala.Serializable)replicaId -> ReassignPartitionsIntegrationTest.$anonfun$buildLogDirReassignment$3(brokerId, newDir, BoxesRunTime.unboxToInt((Object)replicaId)), Seq$.MODULE$.canBuildFrom());
        String reassignmentJson = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(246).append("\n         | { \"version\": 1,\n         |  \"partitions\": [\n         |    {\n         |     \"topic\": \"").append(topicPartition.topic()).append("\",\n         |     \"partition\": ").append(topicPartition.partition()).append(",\n         |     \"replicas\": [").append(replicas.mkString(",")).append("],\n         |     \"log_dirs\": [").append(logDirs.mkString(",")).append("]\n         |    }\n         |   ]\n         |  }\n         |").toString())).stripMargin();
        return new LogDirReassignment(this, reassignmentJson, currentDir, newDir);
    }

    private ReassignPartitionsCommand.VerifyAssignmentResult runVerifyAssignment(Admin adminClient, String jsonString, boolean preserveThrottles) {
        Predef$.MODULE$.println((Object)new StringBuilder(46).append("==> verifyAssignment(adminClient, jsonString=").append(jsonString).append(")").toString());
        return ReassignPartitionsCommand$.MODULE$.verifyAssignment(adminClient, jsonString, preserveThrottles);
    }

    private void waitForVerifyAssignment(Admin adminClient, String jsonString, boolean preserveThrottles, ReassignPartitionsCommand.VerifyAssignmentResult expectedResult) {
        ObjectRef latestResult = ObjectRef.create(null);
        long x$3 = 10L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReassignPartitionsIntegrationTest.$anonfun$waitForVerifyAssignment$1(this, latestResult, adminClient, jsonString, preserveThrottles, expectedResult)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)ReassignPartitionsIntegrationTest.$anonfun$waitForVerifyAssignment$2(expectedResult, latestResult));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), x$3));
        }
    }

    private void runExecuteAssignment(Admin adminClient, boolean additional, String reassignmentJson, long interBrokerThrottle, long replicaAlterLogDirsThrottle) {
        Predef$.MODULE$.println((Object)new StringBuilder(119).append("==> executeAssignment(adminClient, additional=").append(additional).append(", ").append("reassignmentJson=").append(reassignmentJson).append(", ").append("interBrokerThrottle=").append(interBrokerThrottle).append(", ").append("replicaAlterLogDirsThrottle=").append(replicaAlterLogDirsThrottle).append("))").toString());
        ReassignPartitionsCommand$.MODULE$.executeAssignment(adminClient, additional, reassignmentJson, interBrokerThrottle, replicaAlterLogDirsThrottle, ReassignPartitionsCommand$.MODULE$.executeAssignment$default$6(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$7());
    }

    private Tuple2<Set<TopicPartition>, Set<TopicPartitionReplica>> runCancelAssignment(Admin adminClient, String jsonString, boolean preserveThrottles) {
        Predef$.MODULE$.println((Object)new StringBuilder(46).append("==> cancelAssignment(adminClient, jsonString=").append(jsonString).append(")").toString());
        return ReassignPartitionsCommand$.MODULE$.cancelAssignment(adminClient, jsonString, preserveThrottles, ReassignPartitionsCommand$.MODULE$.cancelAssignment$default$4(), ReassignPartitionsCommand$.MODULE$.cancelAssignment$default$5());
    }

    private final void LogDirReassignment$lzycompute$1() {
        synchronized (this) {
            if (this.LogDirReassignment$module == null) {
                this.LogDirReassignment$module = new ReassignPartitionsIntegrationTest$LogDirReassignment$(this);
            }
            return;
        }
    }

    private final void ReassignPartitionsTestCluster$lzycompute$1() {
        synchronized (this) {
            if (this.ReassignPartitionsTestCluster$module == null) {
                this.ReassignPartitionsTestCluster$module = new ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testHighWaterMarkAfterPartitionReassignment$1(ReassignPartitionsIntegrationTest $this, TopicPartition part$1) {
        return ((KafkaServer)$this.cluster().servers().apply(3)).replicaManager().onlinePartition(part$1).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.leaderLogIfLocal()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testHighWaterMarkAfterPartitionReassignment$3() {
        return "broker 3 should be the new leader";
    }

    public static final /* synthetic */ boolean $anonfun$testThrottledReassignment$2(Tuple2 x$2) {
        return ((ReassignPartitionsCommand.PartitionReassignmentState)x$2._2()).done();
    }

    public static final /* synthetic */ boolean $anonfun$testThrottledReassignment$1(ReassignPartitionsIntegrationTest $this, String assignment$1, long interBrokerThrottle$1) {
        ReassignPartitionsCommand.VerifyAssignmentResult result = $this.runVerifyAssignment($this.cluster().adminClient(), assignment$1, true);
        if (!result.partsOngoing()) {
            return true;
        }
        Assertions.assertFalse((boolean)result.partStates().forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsIntegrationTest.$anonfun$testThrottledReassignment$2(x$2))), (String)new StringBuilder(73).append("Expected at least one partition reassignment to be ongoing when result = ").append(result).toString());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), (Object)((ReassignPartitionsCommand.PartitionReassignmentState)result.partStates().apply((Object)new TopicPartition("foo", 0))).targetReplicas());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Object)((ReassignPartitionsCommand.PartitionReassignmentState)result.partStates().apply((Object)new TopicPartition("baz", 2))).targetReplicas());
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Current result: {}", new Object[]{result});
        }
        $this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), interBrokerThrottle$1);
        return false;
    }

    public static final /* synthetic */ String $anonfun$testThrottledReassignment$3() {
        return "Expected reassignment to complete.";
    }

    public static final /* synthetic */ boolean $anonfun$waitForBrokerLevelThrottles$1(ReassignPartitionsIntegrationTest $this, ObjectRef curThrottles$1, Map targetThrottles$1) {
        curThrottles$1.elem = $this.describeBrokerLevelThrottles((Seq<Object>)targetThrottles$1.keySet().toSeq());
        return targetThrottles$1.equals((Object)((Map)curThrottles$1.elem));
    }

    public static final /* synthetic */ String $anonfun$waitForBrokerLevelThrottles$2(Map targetThrottles$1, ObjectRef curThrottles$1) {
        return new StringBuilder(73).append("timed out waiting for broker throttle to become ").append(targetThrottles$1).append(".  ").append("Latest throttles were ").append((Map)curThrottles$1.elem).toString();
    }

    public static final /* synthetic */ Tuple2 $anonfun$describeBrokerLevelThrottles$1(ReassignPartitionsIntegrationTest $this, int brokerId) {
        Properties props = $this.zkClient().getEntityConfigs("brokers", Integer.toString(brokerId));
        scala.collection.immutable.Map throttles = ((TraversableOnce)ReassignPartitionsCommand$.MODULE$.brokerLevelThrottles().map((Function1 & Serializable & scala.Serializable)throttleName -> new Tuple2(throttleName, (Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString((String)props.getOrDefault(throttleName, "-1"))).toLong())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Object)throttles);
    }

    public static final /* synthetic */ Integer $anonfun$testLogDirReassignment$1(int x$3) {
        return BoxesRunTime.boxToInteger((int)x$3);
    }

    public static final /* synthetic */ Integer $anonfun$buildLogDirReassignment$1(int x$4) {
        return BoxesRunTime.boxToInteger((int)x$4);
    }

    public static final /* synthetic */ boolean $anonfun$buildLogDirReassignment$2(String currentDir$1, String x$5) {
        return !x$5.equals(currentDir$1);
    }

    public static final /* synthetic */ String $anonfun$buildLogDirReassignment$3(int brokerId$1, String newDir$1, int replicaId) {
        if (replicaId == brokerId$1) {
            return new StringBuilder(2).append("\"").append(newDir$1).append("\"").toString();
        }
        return "\"any\"";
    }

    public static final /* synthetic */ boolean $anonfun$waitForVerifyAssignment$1(ReassignPartitionsIntegrationTest $this, ObjectRef latestResult$1, Admin adminClient$1, String jsonString$1, boolean preserveThrottles$1, ReassignPartitionsCommand.VerifyAssignmentResult expectedResult$1) {
        latestResult$1.elem = $this.runVerifyAssignment(adminClient$1, jsonString$1, preserveThrottles$1);
        return expectedResult$1.equals((Object)((ReassignPartitionsCommand.VerifyAssignmentResult)latestResult$1.elem));
    }

    public static final /* synthetic */ String $anonfun$waitForVerifyAssignment$2(ReassignPartitionsCommand.VerifyAssignmentResult expectedResult$1, ObjectRef latestResult$1) {
        return new StringBuilder(71).append("Timed out waiting for verifyAssignment result ").append(expectedResult$1).append(".  ").append("The latest result was ").append((ReassignPartitionsCommand.VerifyAssignmentResult)latestResult$1.elem).toString();
    }

    public class BrokerDirs {
        private final int brokerId;
        private final HashSet<String> logDirs;
        private final scala.collection.mutable.HashMap<TopicPartition, String> curLogDirs;
        private final scala.collection.mutable.HashMap<TopicPartition, String> futureLogDirs;
        public final /* synthetic */ ReassignPartitionsIntegrationTest $outer;

        public int brokerId() {
            return this.brokerId;
        }

        public HashSet<String> logDirs() {
            return this.logDirs;
        }

        public scala.collection.mutable.HashMap<TopicPartition, String> curLogDirs() {
            return this.curLogDirs;
        }

        public scala.collection.mutable.HashMap<TopicPartition, String> futureLogDirs() {
            return this.futureLogDirs;
        }

        public /* synthetic */ ReassignPartitionsIntegrationTest kafka$admin$ReassignPartitionsIntegrationTest$BrokerDirs$$$outer() {
            return this.$outer;
        }

        public BrokerDirs(ReassignPartitionsIntegrationTest $outer, DescribeLogDirsResult result, int brokerId) {
            this.brokerId = brokerId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.logDirs = new HashSet();
            this.curLogDirs = new scala.collection.mutable.HashMap();
            this.futureLogDirs = new scala.collection.mutable.HashMap();
            ((java.util.Map)((KafkaFuture)result.descriptions().get(BoxesRunTime.boxToInteger((int)brokerId))).get()).forEach((x0$1, x1$1) -> {
                String logDirName = x0$1;
                LogDirDescription logDirInfo = x1$1;
                this.logDirs().add((Object)logDirName);
                logDirInfo.replicaInfos().forEach((x0$2, x1$2) -> {
                    TopicPartition part = x0$2;
                    if (x1$2.isFuture()) {
                        this.futureLogDirs().put((Object)part, (Object)logDirName);
                        return;
                    }
                    this.curLogDirs().put((Object)part, (Object)logDirName);
                });
            });
        }
    }

    public class LogDirReassignment
    implements Product,
    scala.Serializable {
        private final String json;
        private final String currentDir;
        private final String targetDir;
        public final /* synthetic */ ReassignPartitionsIntegrationTest $outer;

        public String json() {
            return this.json;
        }

        public String currentDir() {
            return this.currentDir;
        }

        public String targetDir() {
            return this.targetDir;
        }

        public LogDirReassignment copy(String json, String currentDir, String targetDir) {
            return new LogDirReassignment(this.kafka$admin$ReassignPartitionsIntegrationTest$LogDirReassignment$$$outer(), json, currentDir, targetDir);
        }

        public String copy$default$1() {
            return this.json();
        }

        public String copy$default$2() {
            return this.currentDir();
        }

        public String copy$default$3() {
            return this.targetDir();
        }

        public String productPrefix() {
            return "LogDirReassignment";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.json();
                }
                case 1: {
                    return this.currentDir();
                }
                case 2: {
                    return this.targetDir();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LogDirReassignment;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof LogDirReassignment)) return false;
            if (((LogDirReassignment)x$1).kafka$admin$ReassignPartitionsIntegrationTest$LogDirReassignment$$$outer() != this.kafka$admin$ReassignPartitionsIntegrationTest$LogDirReassignment$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            LogDirReassignment logDirReassignment = (LogDirReassignment)x$1;
            String string = this.json();
            String string2 = logDirReassignment.json();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.currentDir();
            String string4 = logDirReassignment.currentDir();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.targetDir();
            String string6 = logDirReassignment.targetDir();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            if (!logDirReassignment.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ReassignPartitionsIntegrationTest kafka$admin$ReassignPartitionsIntegrationTest$LogDirReassignment$$$outer() {
            return this.$outer;
        }

        public LogDirReassignment(ReassignPartitionsIntegrationTest $outer, String json, String currentDir, String targetDir) {
            this.json = json;
            this.currentDir = currentDir;
            this.targetDir = targetDir;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class ReassignPartitionsTestCluster
    implements Closeable {
        private final String zkConnect;
        private final Map<String, String> configOverrides;
        private final Map<Object, Map<String, String>> brokerConfigOverrides;
        private final Map<Object, String> brokers;
        private final Map<String, Seq<Seq<Object>>> topics;
        private final Buffer<Properties> brokerConfigs;
        private ArrayBuffer<KafkaServer> servers;
        private String brokerList;
        private Admin adminClient;
        public final /* synthetic */ ReassignPartitionsIntegrationTest $outer;

        public String zkConnect() {
            return this.zkConnect;
        }

        public Map<Object, String> brokers() {
            return this.brokers;
        }

        public Map<String, Seq<Seq<Object>>> topics() {
            return this.topics;
        }

        public Buffer<Properties> brokerConfigs() {
            return this.brokerConfigs;
        }

        public ArrayBuffer<KafkaServer> servers() {
            return this.servers;
        }

        public void servers_$eq(ArrayBuffer<KafkaServer> x$1) {
            this.servers = x$1;
        }

        public String brokerList() {
            return this.brokerList;
        }

        public void brokerList_$eq(String x$1) {
            this.brokerList = x$1;
        }

        public Admin adminClient() {
            return this.adminClient;
        }

        public void adminClient_$eq(Admin x$1) {
            this.adminClient = x$1;
        }

        public void setup() {
            this.createServers();
            this.createTopics();
        }

        public void createServers() {
            this.brokers().keySet().foreach((Function1 & Serializable & scala.Serializable)brokerId -> ReassignPartitionsTestCluster.$anonfun$createServers$1(this, BoxesRunTime.unboxToInt((Object)brokerId)));
        }

        public void createTopics() {
            TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
            this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers(this.servers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT)));
            this.adminClient_$eq(Admin.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.brokerList())}))).asJava())));
            this.adminClient().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)this.topics().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String topicName = (String)x0$1._1();
                Seq parts = (Seq)x0$1._2();
                HashMap partMap = new HashMap();
                ((IterableLike)parts.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    if (x0$2 == null) {
                        throw new MatchError(null);
                    }
                    Seq part = (Seq)x0$2._1();
                    int index = x0$2._2$mcI$sp();
                    java.util.List list = (java.util.List)partMap.put(Predef$.MODULE$.int2Integer(index), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)part.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.unboxToInt((Object)x$6), Seq$.MODULE$.canBuildFrom())).asJava());
                    return list;
                });
                NewTopic newTopic = new NewTopic(topicName, partMap);
                return newTopic;
            }, Iterable$.MODULE$.canBuildFrom())).toList()).asJava()).all().get();
            this.topics().foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                if (x0$3 == null) {
                    throw new MatchError(null);
                }
                String topicName = (String)x0$3._1();
                Seq parts = (Seq)x0$3._2();
                Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> map = TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.servers(), topicName, parts.size());
                return map;
            });
        }

        public void produceMessages(String topic, int partition, int numMessages) {
            IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1 & Serializable & scala.Serializable)x$7 -> ReassignPartitionsTestCluster.$anonfun$produceMessages$1(topic, partition, BoxesRunTime.unboxToInt((Object)x$7)), IndexedSeq$.MODULE$.canBuildFrom());
            TestUtils$.MODULE$.produceMessages(this.servers(), (Seq<ProducerRecord<byte[], byte[]>>)records, -1);
        }

        @Override
        public void close() {
            this.brokerList_$eq(null);
            Utils.closeQuietly((AutoCloseable)this.adminClient(), (String)"adminClient");
            this.adminClient_$eq(null);
            try {
                TestUtils$.MODULE$.shutdownServers(this.servers());
            }
            finally {
                this.servers().clear();
            }
        }

        public /* synthetic */ ReassignPartitionsIntegrationTest kafka$admin$ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$$$outer() {
            return this.$outer;
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ void $anonfun$brokerConfigs$3(Properties config$1, Map overrides) {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> config$1.setProperty((String)x$1, (String)x$2);
            Map map = Implicits$.MODULE$.MapExtensionMethods(overrides);
            if (Implicits.MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        }

        public static final /* synthetic */ ArrayBuffer $anonfun$createServers$1(ReassignPartitionsTestCluster $this, int brokerId) {
            return $this.servers().$plus$eq((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.apply((java.util.Map)$this.brokerConfigs().apply(brokerId), KafkaConfig$.MODULE$.apply$default$2()), TestUtils$.MODULE$.createServer$default$2()));
        }

        public static final /* synthetic */ ProducerRecord $anonfun$produceMessages$1(String topic$1, int partition$1, int x$7) {
            return new ProducerRecord(topic$1, Predef$.MODULE$.int2Integer(partition$1), null, (Object)new byte[10000]);
        }

        public ReassignPartitionsTestCluster(ReassignPartitionsIntegrationTest $outer, String zkConnect, Map<String, String> configOverrides, Map<Object, Map<String, String>> brokerConfigOverrides) {
            this.zkConnect = zkConnect;
            this.configOverrides = configOverrides;
            this.brokerConfigOverrides = brokerConfigOverrides;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.brokers = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack1")}));
            this.topics = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 1}))), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"baz"), (Object)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 2}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 1}))), (List)Nil$.MODULE$))))}));
            this.brokerConfigs = ((TraversableOnce)this.brokers().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                void var4_23;
                void forKeyValue$extension_f;
                void forKeyValue$extension_$this;
                Properties config;
                int brokerId;
                if (x0$1 != null) {
                    brokerId = x0$1._1$mcI$sp();
                    String rack = (String)x0$1._2();
                    String x$22 = this.zkConnect();
                    Some x$3 = new Some((Object)rack);
                    boolean x$4 = false;
                    int x$5 = 3;
                    boolean x$6 = TestUtils$.MODULE$.createBrokerConfig$default$4();
                    int x$7 = TestUtils$.MODULE$.createBrokerConfig$default$5();
                    Option<SecurityProtocol> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$6();
                    Option<File> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$7();
                    Option<Properties> x$10 = TestUtils$.MODULE$.createBrokerConfig$default$8();
                    boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$9();
                    boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$10();
                    int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$11();
                    boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$12();
                    int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$13();
                    boolean x$16 = TestUtils$.MODULE$.createBrokerConfig$default$14();
                    int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$15();
                    boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
                    int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
                    short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
                    config = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$22, x$4, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, (Option<String>)x$3, x$5, x$18, x$19, x$20);
                    config.setProperty(KafkaConfig$.MODULE$.ReplicaFetchBackoffMsProp(), "100");
                    config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
                    config.setProperty(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), "1000");
                    Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> config.setProperty((String)x$1, (String)x$2);
                    Map map = Implicits$.MODULE$.MapExtensionMethods($this.configOverrides);
                    if (Implicits.MapExtensionMethods$.MODULE$ == null) {
                        throw null;
                    }
                } else {
                    throw new MatchError(null);
                }
                MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
                $this.brokerConfigOverrides.get((Object)BoxesRunTime.boxToInteger((int)brokerId)).foreach((Function1 & Serializable & scala.Serializable)overrides -> {
                    ReassignPartitionsTestCluster.$anonfun$brokerConfigs$3(config, overrides);
                    return BoxedUnit.UNIT;
                });
                return var4_23;
            }, Iterable$.MODULE$.canBuildFrom())).toBuffer();
            this.servers = new ArrayBuffer();
            this.brokerList = null;
            this.adminClient = null;
        }
    }
}

