/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import kafka.api.ApiVersion$;
import kafka.api.ApiVersionValidator$;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_10_1_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_11_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.api.KAFKA_0_8_0$;
import kafka.api.KAFKA_0_8_1$;
import kafka.api.KAFKA_0_8_2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_0_IV0$;
import kafka.api.KAFKA_1_1_IV0$;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_1_IV0$;
import kafka.api.KAFKA_2_1_IV1$;
import kafka.api.KAFKA_2_1_IV2$;
import kafka.api.KAFKA_2_2_IV0$;
import kafka.api.KAFKA_2_2_IV1$;
import kafka.api.KAFKA_2_3_IV0$;
import kafka.api.KAFKA_2_3_IV1$;
import kafka.api.KAFKA_2_4_IV0$;
import kafka.api.KAFKA_2_4_IV1$;
import kafka.api.KAFKA_2_5_IV0$;
import kafka.api.KAFKA_2_6_IV0$;
import kafka.api.KAFKA_2_7_IV0$;
import kafka.api.KAFKA_2_7_IV1$;
import kafka.api.KAFKA_2_7_IV2$;
import kafka.api.KAFKA_2_8_IV0$;
import kafka.api.KAFKA_2_8_IV1$;
import kafka.api.KAFKA_3_0_IV0$;
import kafka.api.KAFKA_3_0_IV1$;
import kafka.api.KAFKA_3_1_IV0$;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.FinalizedVersionRange;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0004\b\u0001'!)!\u0004\u0001C\u00017!)a\u0004\u0001C\u0001?!)q\u0006\u0001C\u0001?!)\u0011\u0007\u0001C\u0001?!)1\u0007\u0001C\u0001?!)Q\u0007\u0001C\u0001?!)q\u0007\u0001C\u0001?!)\u0011\b\u0001C\u0001?!)1\b\u0001C\u0005y!)q\n\u0001C\u0001?!)\u0011\u000b\u0001C\u0001?!)1\u000b\u0001C\u0005)\nq\u0011\t]5WKJ\u001c\u0018n\u001c8UKN$(BA\b\u0011\u0003\r\t\u0007/\u001b\u0006\u0002#\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\b\t\u0003;\u0001i\u0011AD\u0001\ni\u0016\u001cH/\u00119qYf$\u0012\u0001\t\t\u0003+\u0005J!A\t\f\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\u0011\u0002\"!J\u0017\u000e\u0003\u0019R!aD\u0014\u000b\u0005!J\u0013a\u00026va&$XM\u001d\u0006\u0003U-\nQA[;oSRT\u0011\u0001L\u0001\u0004_J<\u0017B\u0001\u0018'\u0005\u0011!Vm\u001d;\u0002/Q,7\u000f^!qSZ+'o]5p]Vs\u0017.];f\u0013\u0012\u001c\bFA\u0002%\u0003i!Xm\u001d;NS:\u001cV\u000f\u001d9peR,GMV3sg&|gNR8sQ\t!A%\u0001\tuKN$8\u000b[8siZ+'o]5p]\"\u0012Q\u0001J\u0001\u0018i\u0016\u001cH/\u00119j-\u0016\u00148/[8o-\u0006d\u0017\u000eZ1u_JD#A\u0002\u0013\u0002qMDw.\u001e7e\u0007J,\u0017\r^3Ba&\u0014Vm\u001d9p]N,wJ\u001c7z/&$\bnS3zgN+\b\u000f]8si\u0016$')_'bO&\u001cg+\u00197vK\"\u0012q\u0001J\u0001Mg\"|W\u000f\u001c3SKR,(O\u001c$fCR,(/Z&fsN<\u0006.\u001a8NC\u001eL7-S:DkJ\u0014XM\u001c;WC2,X-\u00118e)\"\u0014x\u000e\u001e;mK6\u001b\u0018j\u001d#fM\u0006,H\u000e\u001e+ie>$H\u000f\\3)\u0005!!\u0013!\u0006<fe&4\u00170\u00119j\u0017\u0016L8OR8s\u001b\u0006<\u0017n\u0019\u000b\u0004AuR\u0005\"\u0002 \n\u0001\u0004y\u0014\u0001\u0003:fgB|gn]3\u0011\u0005\u0001CU\"A!\u000b\u0005\t\u001b\u0015\u0001\u0003:fcV,7\u000f^:\u000b\u0005\u0011+\u0015AB2p[6|gN\u0003\u0002\u0012\r*\u0011qiK\u0001\u0007CB\f7\r[3\n\u0005%\u000b%aE!qSZ+'o]5p]N\u0014Vm\u001d9p]N,\u0007\"B&\n\u0001\u0004a\u0015\u0001C7bq6\u000bw-[2\u0011\u0005Ui\u0015B\u0001(\u0017\u0005\u0011\u0011\u0015\u0010^3\u0002\u0011NDw.\u001e7e%\u0016$XO\u001d8BY2\\U-_:XQ\u0016tW*Y4jG&\u001b8)\u001e:sK:$h+\u00197vK\u0006sG\r\u00165s_R$H.Z't\u0013N$UMZ1vYR$\u0006N]8ui2,\u0007F\u0001\u0006%\u0003\u0005\"Xm\u001d;NKR\fG-\u0019;b#V|'/^7Ba&\u001c\u0018I]3ESN\f'\r\\3eQ\tYA%A\tba&\\U-_:J]J+7\u000f]8og\u0016$\"!V2\u0011\u0007Y[V,D\u0001X\u0015\tA\u0016,\u0001\u0003vi&d'\"\u0001.\u0002\t)\fg/Y\u0005\u00039^\u0013q\u0001S1tQN+G\u000f\u0005\u0002_C6\tqL\u0003\u0002a\u0007\u0006A\u0001O]8u_\u000e|G.\u0003\u0002c?\n9\u0011\t]5LKf\u001c\b\"\u00023\r\u0001\u0004y\u0014aC1qSZ+'o]5p]N\u0004")
public class ApiVersionTest {
    @Test
    public void testApply() {
        Assertions.assertEquals((Object)KAFKA_0_8_0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.8.0"));
        Assertions.assertEquals((Object)KAFKA_0_8_0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.8.0.0"));
        Assertions.assertEquals((Object)KAFKA_0_8_0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.8.0.1"));
        Assertions.assertEquals((Object)KAFKA_0_8_1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.8.1"));
        Assertions.assertEquals((Object)KAFKA_0_8_1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.8.1.0"));
        Assertions.assertEquals((Object)KAFKA_0_8_1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.8.1.1"));
        Assertions.assertEquals((Object)KAFKA_0_8_2$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.8.2"));
        Assertions.assertEquals((Object)KAFKA_0_8_2$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.8.2.0"));
        Assertions.assertEquals((Object)KAFKA_0_8_2$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.8.2.1"));
        Assertions.assertEquals((Object)KAFKA_0_9_0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.9.0"));
        Assertions.assertEquals((Object)KAFKA_0_9_0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.9.0.0"));
        Assertions.assertEquals((Object)KAFKA_0_9_0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.9.0.1"));
        Assertions.assertEquals((Object)KAFKA_0_10_0_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.10.0-IV0"));
        Assertions.assertEquals((Object)KAFKA_0_10_0_IV1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.10.0"));
        Assertions.assertEquals((Object)KAFKA_0_10_0_IV1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.10.0.0"));
        Assertions.assertEquals((Object)KAFKA_0_10_0_IV1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.10.0.0-IV0"));
        Assertions.assertEquals((Object)KAFKA_0_10_0_IV1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.10.0.1"));
        Assertions.assertEquals((Object)KAFKA_0_10_1_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.10.1-IV0"));
        Assertions.assertEquals((Object)KAFKA_0_10_1_IV1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.10.1-IV1"));
        Assertions.assertEquals((Object)KAFKA_0_10_1_IV2$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.10.1"));
        Assertions.assertEquals((Object)KAFKA_0_10_1_IV2$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.10.1.0"));
        Assertions.assertEquals((Object)KAFKA_0_10_1_IV2$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.10.1-IV2"));
        Assertions.assertEquals((Object)KAFKA_0_10_1_IV2$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.10.1.1"));
        Assertions.assertEquals((Object)KAFKA_0_10_2_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.10.2"));
        Assertions.assertEquals((Object)KAFKA_0_10_2_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.10.2.0"));
        Assertions.assertEquals((Object)KAFKA_0_10_2_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.10.2-IV0"));
        Assertions.assertEquals((Object)KAFKA_0_10_2_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.10.2.1"));
        Assertions.assertEquals((Object)KAFKA_0_11_0_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.11.0-IV0"));
        Assertions.assertEquals((Object)KAFKA_0_11_0_IV1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.11.0-IV1"));
        Assertions.assertEquals((Object)KAFKA_0_11_0_IV2$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.11.0"));
        Assertions.assertEquals((Object)KAFKA_0_11_0_IV2$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.11.0.0"));
        Assertions.assertEquals((Object)KAFKA_0_11_0_IV2$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.11.0-IV2"));
        Assertions.assertEquals((Object)KAFKA_0_11_0_IV2$.MODULE$, (Object)ApiVersion$.MODULE$.apply("0.11.0.1"));
        Assertions.assertEquals((Object)KAFKA_1_0_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("1.0"));
        Assertions.assertEquals((Object)KAFKA_1_0_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("1.0.0"));
        Assertions.assertEquals((Object)KAFKA_1_0_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("1.0.0-IV0"));
        Assertions.assertEquals((Object)KAFKA_1_0_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("1.0.1"));
        Assertions.assertEquals((Object)KAFKA_1_1_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("1.1-IV0"));
        Assertions.assertEquals((Object)KAFKA_2_0_IV1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.0"));
        Assertions.assertEquals((Object)KAFKA_2_0_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.0-IV0"));
        Assertions.assertEquals((Object)KAFKA_2_0_IV1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.0-IV1"));
        Assertions.assertEquals((Object)KAFKA_2_1_IV2$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.1"));
        Assertions.assertEquals((Object)KAFKA_2_1_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.1-IV0"));
        Assertions.assertEquals((Object)KAFKA_2_1_IV1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.1-IV1"));
        Assertions.assertEquals((Object)KAFKA_2_1_IV2$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.1-IV2"));
        Assertions.assertEquals((Object)KAFKA_2_2_IV1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.2"));
        Assertions.assertEquals((Object)KAFKA_2_2_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.2-IV0"));
        Assertions.assertEquals((Object)KAFKA_2_2_IV1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.2-IV1"));
        Assertions.assertEquals((Object)KAFKA_2_3_IV1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.3"));
        Assertions.assertEquals((Object)KAFKA_2_3_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.3-IV0"));
        Assertions.assertEquals((Object)KAFKA_2_3_IV1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.3-IV1"));
        Assertions.assertEquals((Object)KAFKA_2_4_IV1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.4"));
        Assertions.assertEquals((Object)KAFKA_2_4_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.4-IV0"));
        Assertions.assertEquals((Object)KAFKA_2_4_IV1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.4-IV1"));
        Assertions.assertEquals((Object)KAFKA_2_5_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.5"));
        Assertions.assertEquals((Object)KAFKA_2_5_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.5-IV0"));
        Assertions.assertEquals((Object)KAFKA_2_6_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.6"));
        Assertions.assertEquals((Object)KAFKA_2_6_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.6-IV0"));
        Assertions.assertEquals((Object)KAFKA_2_7_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.7-IV0"));
        Assertions.assertEquals((Object)KAFKA_2_7_IV1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.7-IV1"));
        Assertions.assertEquals((Object)KAFKA_2_7_IV2$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.7-IV2"));
        Assertions.assertEquals((Object)KAFKA_2_8_IV1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.8"));
        Assertions.assertEquals((Object)KAFKA_2_8_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.8-IV0"));
        Assertions.assertEquals((Object)KAFKA_2_8_IV1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("2.8-IV1"));
        Assertions.assertEquals((Object)KAFKA_3_0_IV1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("3.0"));
        Assertions.assertEquals((Object)KAFKA_3_0_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("3.0-IV0"));
        Assertions.assertEquals((Object)KAFKA_3_0_IV1$.MODULE$, (Object)ApiVersion$.MODULE$.apply("3.0-IV1"));
        Assertions.assertEquals((Object)KAFKA_3_1_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("3.1"));
        Assertions.assertEquals((Object)KAFKA_3_1_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.apply("3.1-IV0"));
    }

    @Test
    public void testApiVersionUniqueIds() {
        Seq allIds = (Seq)ApiVersion$.MODULE$.allVersions().map((Function1 & Serializable & scala.Serializable)apiVersion -> BoxesRunTime.boxToInteger((int)apiVersion.id()), Seq$.MODULE$.canBuildFrom());
        Set uniqueIds = allIds.toSet();
        Assertions.assertEquals((int)allIds.size(), (int)uniqueIds.size());
    }

    @Test
    public void testMinSupportedVersionFor() {
        Assertions.assertEquals((Object)KAFKA_0_8_0$.MODULE$, (Object)ApiVersion$.MODULE$.minSupportedFor(RecordVersion.V0));
        Assertions.assertEquals((Object)KAFKA_0_10_0_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.minSupportedFor(RecordVersion.V1));
        Assertions.assertEquals((Object)KAFKA_0_11_0_IV0$.MODULE$, (Object)ApiVersion$.MODULE$.minSupportedFor(RecordVersion.V2));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RecordVersion.values())).foreach((Function1 & Serializable & scala.Serializable)recordVersion -> {
            ApiVersionTest.$anonfun$testMinSupportedVersionFor$1(recordVersion);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testShortVersion() {
        Assertions.assertEquals((Object)"0.8.0", (Object)KAFKA_0_8_0$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"0.10.0", (Object)KAFKA_0_10_0_IV0$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"0.10.0", (Object)KAFKA_0_10_0_IV1$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"0.11.0", (Object)KAFKA_0_11_0_IV0$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"0.11.0", (Object)KAFKA_0_11_0_IV1$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"0.11.0", (Object)KAFKA_0_11_0_IV2$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"1.0", (Object)KAFKA_1_0_IV0$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"1.1", (Object)KAFKA_1_1_IV0$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"2.0", (Object)KAFKA_2_0_IV0$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"2.0", (Object)KAFKA_2_0_IV1$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"2.1", (Object)KAFKA_2_1_IV0$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"2.1", (Object)KAFKA_2_1_IV1$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"2.1", (Object)KAFKA_2_1_IV2$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"2.2", (Object)KAFKA_2_2_IV0$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"2.2", (Object)KAFKA_2_2_IV1$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"2.3", (Object)KAFKA_2_3_IV0$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"2.3", (Object)KAFKA_2_3_IV1$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"2.4", (Object)KAFKA_2_4_IV0$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"2.5", (Object)KAFKA_2_5_IV0$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"2.6", (Object)KAFKA_2_6_IV0$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"2.7", (Object)KAFKA_2_7_IV2$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"2.8", (Object)KAFKA_2_8_IV0$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"2.8", (Object)KAFKA_2_8_IV1$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"3.0", (Object)KAFKA_3_0_IV0$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"3.0", (Object)KAFKA_3_0_IV1$.MODULE$.shortVersion());
        Assertions.assertEquals((Object)"3.1", (Object)KAFKA_3_1_IV0$.MODULE$.shortVersion());
    }

    @Test
    public void testApiVersionValidator() {
        String str = ApiVersionValidator$.MODULE$.toString();
        String[] apiVersions = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(str), 1, str.length()).split(",");
        Assertions.assertEquals((int)ApiVersion$.MODULE$.allVersions().size(), (int)apiVersions.length);
    }

    @Test
    public void shouldCreateApiResponseOnlyWithKeysSupportedByMagicValue() {
        ApiVersionsResponse response = ApiVersion$.MODULE$.apiVersionsResponse(10, RecordVersion.V1, Features.emptySupportedFeatures(), (Option)None$.MODULE$, ApiMessageType.ListenerType.ZK_BROKER);
        this.verifyApiKeysForMagic(response, (byte)1);
        Assertions.assertEquals((int)10, (int)response.throttleTimeMs());
        Assertions.assertTrue((boolean)response.data().supportedFeatures().isEmpty());
        Assertions.assertTrue((boolean)response.data().finalizedFeatures().isEmpty());
        Assertions.assertEquals((long)-1L, (long)response.data().finalizedFeaturesEpoch());
    }

    @Test
    public void shouldReturnFeatureKeysWhenMagicIsCurrentValueAndThrottleMsIsDefaultThrottle() {
        ApiVersionsResponse response = ApiVersion$.MODULE$.apiVersionsResponse(10, RecordVersion.V1, Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature", (Object)new SupportedVersionRange((short)1, (short)4))})), Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature", (Object)new FinalizedVersionRange((short)2, (short)3))})), 10L, (Option)None$.MODULE$, ApiMessageType.ListenerType.ZK_BROKER);
        this.verifyApiKeysForMagic(response, (byte)1);
        Assertions.assertEquals((int)10, (int)response.throttleTimeMs());
        Assertions.assertEquals((int)1, (int)response.data().supportedFeatures().size());
        ApiVersionsResponseData.SupportedFeatureKey sKey = response.data().supportedFeatures().find("feature");
        Assertions.assertNotNull((Object)sKey);
        Assertions.assertEquals((int)1, (int)sKey.minVersion());
        Assertions.assertEquals((int)4, (int)sKey.maxVersion());
        Assertions.assertEquals((int)1, (int)response.data().finalizedFeatures().size());
        ApiVersionsResponseData.FinalizedFeatureKey fKey = response.data().finalizedFeatures().find("feature");
        Assertions.assertNotNull((Object)fKey);
        Assertions.assertEquals((int)2, (int)fKey.minVersionLevel());
        Assertions.assertEquals((int)3, (int)fKey.maxVersionLevel());
        Assertions.assertEquals((long)10L, (long)response.data().finalizedFeaturesEpoch());
    }

    private void verifyApiKeysForMagic(ApiVersionsResponse response, byte maxMagic) {
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)response.data().apiKeys()).asScala()).foreach((Function1 & Serializable & scala.Serializable)version -> {
            ApiVersionTest.$anonfun$verifyApiKeysForMagic$1(maxMagic, version);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void shouldReturnAllKeysWhenMagicIsCurrentValueAndThrottleMsIsDefaultThrottle() {
        ApiVersionsResponse response = ApiVersion$.MODULE$.apiVersionsResponse(0, RecordVersion.current(), Features.emptySupportedFeatures(), (Option)None$.MODULE$, ApiMessageType.ListenerType.ZK_BROKER);
        Assertions.assertEquals(new HashSet(ApiKeys.zkBrokerApis()), this.apiKeysInResponse(response));
        Assertions.assertEquals((int)0, (int)response.throttleTimeMs());
        Assertions.assertTrue((boolean)response.data().supportedFeatures().isEmpty());
        Assertions.assertTrue((boolean)response.data().finalizedFeatures().isEmpty());
        Assertions.assertEquals((long)-1L, (long)response.data().finalizedFeaturesEpoch());
    }

    @Test
    public void testMetadataQuorumApisAreDisabled() {
        ApiVersionsResponse response = ApiVersion$.MODULE$.apiVersionsResponse(0, RecordVersion.current(), Features.emptySupportedFeatures(), (Option)None$.MODULE$, ApiMessageType.ListenerType.ZK_BROKER);
        HashSet<ApiKeys> exposedApis = this.apiKeysInResponse(response);
        Assertions.assertFalse((boolean)exposedApis.contains(ApiKeys.ENVELOPE));
        Assertions.assertFalse((boolean)exposedApis.contains(ApiKeys.VOTE));
        Assertions.assertFalse((boolean)exposedApis.contains(ApiKeys.BEGIN_QUORUM_EPOCH));
        Assertions.assertFalse((boolean)exposedApis.contains(ApiKeys.END_QUORUM_EPOCH));
        Assertions.assertFalse((boolean)exposedApis.contains(ApiKeys.DESCRIBE_QUORUM));
    }

    /*
     * WARNING - void declaration
     */
    private HashSet<ApiKeys> apiKeysInResponse(ApiVersionsResponse apiVersions) {
        void var2_2;
        HashSet apiKeys = new HashSet();
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)apiVersions.data().apiKeys()).asScala()).foreach((Function1 & Serializable & scala.Serializable)version -> BoxesRunTime.boxToBoolean((boolean)apiKeys.add(ApiKeys.forId((int)version.apiKey()))));
        return var2_2;
    }

    public static final /* synthetic */ void $anonfun$testMinSupportedVersionFor$1(RecordVersion recordVersion) {
        Assertions.assertNotNull((Object)ApiVersion$.MODULE$.minSupportedFor(recordVersion));
    }

    public static final /* synthetic */ void $anonfun$verifyApiKeysForMagic$1(byte maxMagic$1, ApiVersionsResponseData.ApiVersion version) {
        Assertions.assertTrue((ApiKeys.forId((int)version.apiKey()).minRequiredInterBrokerMagic <= maxMagic$1 ? 1 : 0) != 0);
    }
}

