/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.record.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u000193A\u0001D\u0007\u0001%!)q\u0003\u0001C\u00011!9!\u0004\u0001b\u0001\n\u0003Y\u0002B\u0002\u0012\u0001A\u0003%A\u0004C\u0004$\u0001\t\u0007I\u0011A\u000e\t\r\u0011\u0002\u0001\u0015!\u0003\u001d\u0011\u001d)\u0003A1A\u0005\u0002mAaA\n\u0001!\u0002\u0013a\u0002bB\u0014\u0001\u0005\u0004%I\u0001\u000b\u0005\u0007c\u0001\u0001\u000b\u0011B\u0015\t\u000bI\u0002A\u0011I\u001a\t\u000b!\u0003A\u0011A%\u0003#1{w-\u00119qK:$G+[7f)\u0016\u001cHO\u0003\u0002\u000f\u001f\u0005\u0019\u0011\r]5\u000b\u0003A\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001'A\u0011A#F\u0007\u0002\u001b%\u0011a#\u0004\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012!\u0007\t\u0003)\u0001\tQ\u0002\u001d:pIV\u001cWM]\"pk:$X#\u0001\u000f\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\u0007%sG/\u0001\bqe>$WoY3s\u0007>,h\u000e\u001e\u0011\u0002\u001b\r|gn];nKJ\u001cu.\u001e8u\u00039\u0019wN\\:v[\u0016\u00148i\\;oi\u0002\n1B\u0019:pW\u0016\u00148i\\;oi\u0006a!M]8lKJ\u001cu.\u001e8uA\u0005)Ao\u001c9jGV\t\u0011\u0006\u0005\u0002+_5\t1F\u0003\u0002-[\u0005!A.\u00198h\u0015\u0005q\u0013\u0001\u00026bm\u0006L!\u0001M\u0016\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005)1/\u001a;VaR\u0011Ag\u000e\t\u0003;UJ!A\u000e\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006q)\u0001\r!O\u0001\ti\u0016\u001cH/\u00138g_B\u0011!HQ\u0007\u0002w)\u0011a\u0002\u0010\u0006\u0003{y\nqA[;qSR,'O\u0003\u0002@\u0001\u0006)!.\u001e8ji*\t\u0011)A\u0002pe\u001eL!aQ\u001e\u0003\u0011Q+7\u000f^%oM>D#AC#\u0011\u0005i2\u0015BA$<\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0013i\u0016\u001cH\u000f\u0015:pIV\u001cWmQ8ogVlW\rF\u00015Q\tY1\n\u0005\u0002;\u0019&\u0011Qj\u000f\u0002\u0005)\u0016\u001cH\u000f")
public class LogAppendTimeTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int brokerCount;
    private final String topic;

    public int producerCount() {
        return this.producerCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    private String topic() {
        return this.topic;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
    }

    @Test
    public void testProduceConsume() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long now = System.currentTimeMillis();
        long createTime = now - TimeUnit.DAYS.toMillis(1L);
        IndexedSeq producerRecords = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> LogAppendTimeTest.$anonfun$testProduceConsume$1(this, createTime, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq recordMetadatas = (IndexedSeq)((TraversableLike)producerRecords.map((Function1 & Serializable & scala.Serializable)x$1 -> producer.send(x$1), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> (RecordMetadata)x$1.get(10L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom());
        recordMetadatas.foreach((Function1 & Serializable & scala.Serializable)recordMetadata -> {
            LogAppendTimeTest.$anonfun$testProduceConsume$4(now, recordMetadata);
            return BoxedUnit.UNIT;
        });
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(Collections.singleton(this.topic()));
        ((IterableLike)TestUtils$.MODULE$.consumeRecords(consumer, producerRecords.size(), TestUtils$.MODULE$.consumeRecords$default$3()).zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogAppendTimeTest.$anonfun$testProduceConsume$5(producerRecords, recordMetadatas, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ ProducerRecord $anonfun$testProduceConsume$1(LogAppendTimeTest $this, long createTime$1, int i) {
        return new ProducerRecord($this.topic(), null, Predef$.MODULE$.long2Long(createTime$1), (Object)new StringBuilder(3).append("key").append(i).toString().getBytes(), (Object)new StringBuilder(5).append("value").append(i).toString().getBytes());
    }

    public static final /* synthetic */ void $anonfun$testProduceConsume$4(long now$1, RecordMetadata recordMetadata) {
        Assertions.assertTrue((recordMetadata.timestamp() >= now$1 ? 1 : 0) != 0);
        Assertions.assertTrue((recordMetadata.timestamp() < now$1 + TimeUnit.SECONDS.toMillis(60L) ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testProduceConsume$5(IndexedSeq producerRecords$1, IndexedSeq recordMetadatas$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ConsumerRecord consumerRecord = (ConsumerRecord)x0$1._1();
            int index = x0$1._2$mcI$sp();
            ProducerRecord producerRecord = (ProducerRecord)producerRecords$1.apply(index);
            RecordMetadata recordMetadata = (RecordMetadata)recordMetadatas$1.apply(index);
            Assertions.assertEquals((Object)new String((byte[])producerRecord.key()), (Object)new String((byte[])consumerRecord.key()));
            Assertions.assertEquals((Object)new String((byte[])producerRecord.value()), (Object)new String((byte[])consumerRecord.value()));
            Assertions.assertNotEquals((Long)producerRecord.timestamp(), (long)consumerRecord.timestamp());
            Assertions.assertEquals((long)recordMetadata.timestamp(), (long)consumerRecord.timestamp());
            Assertions.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)consumerRecord.timestampType());
            return;
        }
        throw new MatchError(null);
    }

    public LogAppendTimeTest() {
        this.producerCount = 1;
        this.consumerCount = 1;
        this.brokerCount = 2;
        this.serverConfig().put(KafkaConfig$.MODULE$.LogMessageTimestampTypeProp(), TimestampType.LOG_APPEND_TIME.name);
        this.serverConfig().put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "2");
        this.topic = "topic";
    }
}

